"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isCacheDisabled = void 0;
/**
 * Returns `true` when caching should be disabled, else `false`.
 *
 * Any code within this check will be removed in the output bundles:
 *
 * ```js
 * if (isCacheDisabled()) {
 *   // This code will be removed from the output bundles
 * }
 * ```
 */
const isCacheDisabled = () => {
    return process.env.NODE_ENV === 'test' && process.env.CACHE === 'false';
};
exports.isCacheDisabled = isCacheDisabled;
//# sourceMappingURL=cache.js.map