// Source: https://github.com/atlassian/react-beautiful-dnd

export const origin = {
  x: 0,
  y: 0
};

// used to apply any function to both values of a point
// eg: const floor = apply(Math.floor)(point);
export const apply = fn => point => ({
  x: fn(point.x),
  y: fn(point.y)
});
export const isEqual = (point1, point2) => point1.x === point2.x && point1.y === point2.y;
export const add = (point1, point2) => ({
  x: point1.x + point2.x,
  y: point1.y + point2.y
});
export const subtract = (point1, point2) => ({
  x: point1.x - point2.x,
  y: point1.y - point2.y
});