/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder;

import io.bazel.kotlin.builder.KotlinBuilderComponent;
import io.bazel.kotlin.builder.KotlinBuilderComponent_Module_ProvideInternalPluginsFactory;
import io.bazel.kotlin.builder.dagger.internal.DaggerGenerated;
import io.bazel.kotlin.builder.dagger.internal.DoubleCheck;
import io.bazel.kotlin.builder.dagger.internal.InstanceFactory;
import io.bazel.kotlin.builder.dagger.internal.Preconditions;
import io.bazel.kotlin.builder.dagger.internal.Provider;
import io.bazel.kotlin.builder.tasks.CompileKotlin;
import io.bazel.kotlin.builder.tasks.KotlinBuilder;
import io.bazel.kotlin.builder.tasks.KotlinBuilder_Factory;
import io.bazel.kotlin.builder.tasks.js.Kotlin2JsTaskExecutor;
import io.bazel.kotlin.builder.tasks.js.Kotlin2JsTaskExecutor_Factory;
import io.bazel.kotlin.builder.tasks.jvm.InternalCompilerPlugins;
import io.bazel.kotlin.builder.tasks.jvm.KotlinJvmTaskExecutor;
import io.bazel.kotlin.builder.tasks.jvm.KotlinJvmTaskExecutor_Factory;
import io.bazel.kotlin.builder.toolchain.KotlinToolchain;
import io.bazel.kotlin.builder.toolchain.KotlinToolchain_K2JSCompilerInvoker_Factory;
import io.bazel.kotlin.builder.toolchain.KotlinToolchain_KotlincInvoker_Factory;

@DaggerGenerated
public final class DaggerKotlinBuilderComponent {
    private DaggerKotlinBuilderComponent() {
    }

    public static KotlinBuilderComponent.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements KotlinBuilderComponent.Builder {
        private KotlinToolchain toolchain;

        private Builder() {
        }

        @Override
        public Builder toolchain(KotlinToolchain toolchain) {
            this.toolchain = Preconditions.checkNotNull(toolchain);
            return this;
        }

        @Override
        public KotlinBuilderComponent build() {
            Preconditions.checkBuilderRequirement(this.toolchain, KotlinToolchain.class);
            return new KotlinBuilderComponentImpl(new KotlinBuilderComponent.Module(), this.toolchain);
        }
    }

    private static final class KotlinBuilderComponentImpl
    implements KotlinBuilderComponent {
        private final KotlinToolchain toolchain;
        private final KotlinBuilderComponentImpl kotlinBuilderComponentImpl = this;
        private Provider<KotlinToolchain> toolchainProvider;
        private Provider<KotlinToolchain.KotlincInvoker> kotlincInvokerProvider;
        private Provider<InternalCompilerPlugins> provideInternalPluginsProvider;
        private Provider<KotlinJvmTaskExecutor> kotlinJvmTaskExecutorProvider;
        private Provider<KotlinToolchain.K2JSCompilerInvoker> k2JSCompilerInvokerProvider;
        private Provider<Kotlin2JsTaskExecutor> kotlin2JsTaskExecutorProvider;
        private Provider<KotlinBuilder> kotlinBuilderProvider;

        private KotlinBuilderComponentImpl(KotlinBuilderComponent.Module moduleParam, KotlinToolchain toolchainParam) {
            this.toolchain = toolchainParam;
            this.initialize(moduleParam, toolchainParam);
        }

        private void initialize(KotlinBuilderComponent.Module moduleParam, KotlinToolchain toolchainParam) {
            this.toolchainProvider = InstanceFactory.create(toolchainParam);
            this.kotlincInvokerProvider = DoubleCheck.provider(KotlinToolchain_KotlincInvoker_Factory.create(this.toolchainProvider));
            this.provideInternalPluginsProvider = KotlinBuilderComponent_Module_ProvideInternalPluginsFactory.create(moduleParam, this.toolchainProvider);
            this.kotlinJvmTaskExecutorProvider = DoubleCheck.provider(KotlinJvmTaskExecutor_Factory.create(this.kotlincInvokerProvider, this.provideInternalPluginsProvider));
            this.k2JSCompilerInvokerProvider = DoubleCheck.provider(KotlinToolchain_K2JSCompilerInvoker_Factory.create(this.toolchainProvider));
            this.kotlin2JsTaskExecutorProvider = DoubleCheck.provider(Kotlin2JsTaskExecutor_Factory.create(this.k2JSCompilerInvokerProvider));
            this.kotlinBuilderProvider = DoubleCheck.provider(KotlinBuilder_Factory.create(this.kotlinJvmTaskExecutorProvider, this.kotlin2JsTaskExecutorProvider));
        }

        @Override
        public KotlinToolchain toolchain() {
            return this.toolchain;
        }

        @Override
        public KotlinJvmTaskExecutor jvmTaskExecutor() {
            return (KotlinJvmTaskExecutor)this.kotlinJvmTaskExecutorProvider.get();
        }

        @Override
        public Kotlin2JsTaskExecutor jsTaskExecutor() {
            return (Kotlin2JsTaskExecutor)this.kotlin2JsTaskExecutorProvider.get();
        }

        @Override
        public CompileKotlin work() {
            return new CompileKotlin((KotlinBuilder)this.kotlinBuilderProvider.get());
        }
    }
}

