/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.ExpressionProcessor;
import net.sf.saxon.expr.flwor.GroupByClausePull;
import net.sf.saxon.expr.flwor.GroupByClausePush;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.flwor.Tuple;
import net.sf.saxon.expr.flwor.TupleExpression;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupByClause
extends Clause {
    Configuration config;
    LocalVariableBinding[] bindings;
    GenericAtomicComparer[] comparers;
    TupleExpression retainedTupleExpression;
    TupleExpression groupingTupleExpression;

    public GroupByClause(Configuration config) {
        this.config = config;
    }

    @Override
    public int getClauseKey() {
        return 3;
    }

    @Override
    public boolean containsNonInlineableVariableReference(Binding binding) {
        for (LocalVariableReference ref : this.retainedTupleExpression.getSlots()) {
            if (ref.getBinding() != binding) continue;
            return true;
        }
        for (LocalVariableReference ref : this.groupingTupleExpression.getSlots()) {
            if (ref.getBinding() != binding) continue;
            return true;
        }
        return false;
    }

    @Override
    public GroupByClause copy() {
        GroupByClause g2 = new GroupByClause(this.config);
        g2.setLocationId(this.getLocationId());
        g2.bindings = new LocalVariableBinding[this.bindings.length];
        for (int i = 0; i < this.bindings.length; ++i) {
            g2.bindings[i] = this.bindings[i].copy();
        }
        g2.comparers = this.comparers;
        g2.retainedTupleExpression = (TupleExpression)this.retainedTupleExpression.copy();
        g2.groupingTupleExpression = (TupleExpression)this.groupingTupleExpression.copy();
        return g2;
    }

    public void setRetainedTupleExpression(TupleExpression expr) {
        this.retainedTupleExpression = expr;
    }

    public TupleExpression getRetainedTupleExpression() {
        return this.retainedTupleExpression;
    }

    @Override
    public void optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        int groupingSize;
        LinkedList<LocalVariableBinding> list = new LinkedList<LocalVariableBinding>(Arrays.asList(this.bindings));
        LinkedList<LocalVariableReference> retainingExpr = new LinkedList<LocalVariableReference>(Arrays.asList(this.retainedTupleExpression.getSlots()));
        for (int i = groupingSize = this.groupingTupleExpression.getSlots().length; i < list.size(); ++i) {
            if (list.get(i).getNominalReferenceCount() != 0) continue;
            list.remove(i);
            retainingExpr.remove(i - groupingSize);
        }
        this.bindings = list.toArray(new LocalVariableBinding[list.size()]);
        this.retainedTupleExpression.setVariables(retainingExpr);
    }

    public void setGroupingTupleExpression(TupleExpression expr) {
        this.groupingTupleExpression = expr;
    }

    public TupleExpression getGroupingTupleExpression() {
        return this.groupingTupleExpression;
    }

    public void setVariableBindings(LocalVariableBinding[] bindings) {
        this.bindings = bindings;
    }

    @Override
    public LocalVariableBinding[] getRangeVariables() {
        return this.bindings;
    }

    public void setComparers(GenericAtomicComparer[] comparers) {
        this.comparers = comparers;
    }

    @Override
    public TuplePull getPullStream(TuplePull base, XPathContext context) {
        return new GroupByClausePull(base, this);
    }

    @Override
    public TuplePush getPushStream(TuplePush destination, XPathContext context) {
        return new GroupByClausePush(destination, this, context);
    }

    @Override
    public void processSubExpressions(ExpressionProcessor processor) throws XPathException {
        this.groupingTupleExpression = (TupleExpression)processor.processExpression(this.groupingTupleExpression);
        this.retainedTupleExpression = (TupleExpression)processor.processExpression(this.retainedTupleExpression);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("group-by");
        for (LocalVariableReference ref : this.retainedTupleExpression.getSlots()) {
            out.startSubsidiaryElement("by");
            out.emitAttribute("var", ref.getDisplayName());
            out.emitAttribute("slot", ref.getBinding().getLocalSlotNumber() + "");
            out.endSubsidiaryElement();
        }
        out.endElement();
    }

    public String toString() {
        FastStringBuffer fsb = new FastStringBuffer(64);
        fsb.append("group by ... ");
        return fsb.toString();
    }

    public void processGroup(List<ObjectToBeGrouped> group, XPathContext context) throws XPathException {
        int j;
        LocalVariableBinding[] bindings = this.getRangeVariables();
        Sequence[] groupingValues = group.get((int)0).groupingValues.getMembers();
        for (j = 0; j < groupingValues.length; ++j) {
            Sequence v = groupingValues[j];
            context.setLocalVariable(bindings[j].getLocalSlotNumber(), v);
        }
        for (j = groupingValues.length; j < bindings.length; ++j) {
            ArrayList<Item> concatenatedValue = new ArrayList<Item>();
            for (ObjectToBeGrouped otbg : group) {
                Item it;
                Sequence val = otbg.retainedValues.getMembers()[j - groupingValues.length];
                SequenceIterator si = val.iterate();
                while ((it = si.next()) != null) {
                    concatenatedValue.add(it);
                }
            }
            SequenceExtent se = new SequenceExtent(concatenatedValue);
            context.setLocalVariable(bindings[j].getLocalSlotNumber(), se);
        }
    }

    public TupleComparisonKey getComparisonKey(Tuple t) {
        return new TupleComparisonKey(t.getMembers());
    }

    public class TupleComparisonKey {
        private Sequence[] groupingValues;

        public TupleComparisonKey(Sequence[] groupingValues) {
            this.groupingValues = groupingValues;
        }

        public int hashCode() {
            int h = 0x77557755 ^ this.groupingValues.length;
            for (int i = 0; i < this.groupingValues.length; ++i) {
                GenericAtomicComparer comparer = GroupByClause.this.comparers[i];
                int implicitTimezone = comparer.getContext().getImplicitTimezone();
                try {
                    AtomicValue val;
                    SequenceIterator atoms = this.groupingValues[i].iterate();
                    while ((val = (AtomicValue)atoms.next()) != null) {
                        h ^= i + val.getXPathComparable(false, comparer.getCollator(), implicitTimezone).hashCode();
                    }
                    continue;
                }
                catch (XPathException e) {
                    // empty catch block
                }
            }
            return h;
        }

        public boolean equals(Object other) {
            if (!(other instanceof TupleComparisonKey)) {
                return false;
            }
            if (this.groupingValues.length != ((TupleComparisonKey)other).groupingValues.length) {
                return false;
            }
            for (int i = 0; i < this.groupingValues.length; ++i) {
                try {
                    if (DeepEqual.deepEquals(this.groupingValues[i].iterate(), ((TupleComparisonKey)other).groupingValues[i].iterate(), (AtomicComparer)GroupByClause.this.comparers[i], GroupByClause.this.config.getConversionContext(), 0)) continue;
                    return false;
                }
                catch (XPathException e) {
                    return false;
                }
            }
            return true;
        }
    }

    public static class ObjectToBeGrouped {
        public Tuple groupingValues;
        public Tuple retainedValues;
    }
}

