/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.junit.impl;

import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.ops4j.pax.exam.spi.StagedExamReactor;
import org.ops4j.pax.exam.spi.reactors.ReactorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectingRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOG = LoggerFactory.getLogger(InjectingRunner.class);
    private ReactorManager manager;
    private StagedExamReactor stagedReactor;

    public InjectingRunner(Class<?> klass) throws InitializationError {
        super(klass);
        LOG.info("creating PaxExam runner for {}", klass);
        try {
            Object testClassInstance = klass.newInstance();
            this.manager = ReactorManager.getInstance();
            this.manager.prepareReactor(klass, testClassInstance);
            this.stagedReactor = this.manager.stageReactor();
        }
        catch (IllegalAccessException | InstantiationException exc) {
            throw new InitializationError((Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        LOG.info("running test class {}", (Object)this.getTestClass().getName());
        Class testClass = this.getTestClass().getJavaClass();
        try {
            this.manager.beforeClass(this.stagedReactor, (Object)testClass);
            super.run(notifier);
        }
        catch (Throwable e) {
            Description description = Description.createSuiteDescription((Class)testClass);
            notifier.fireTestFailure(new Failure(description, e));
        }
        finally {
            this.manager.afterClass(this.stagedReactor, testClass);
        }
    }

    protected Object createTest() throws Exception {
        Object test = super.createTest();
        this.manager.inject(test);
        return test;
    }
}

