/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import org.apache.commons.lang3.exception.AbstractExceptionTest;
import org.apache.commons.lang3.exception.CloneFailedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CloneFailedExceptionTest
extends AbstractExceptionTest {
    @Test
    public void testThrowingExceptionWithCause() {
        Assertions.assertThrows(CloneFailedException.class, () -> {
            throw new CloneFailedException((Throwable)this.generateCause());
        });
    }

    @Test
    public void testThrowingExceptionWithMessage() {
        Assertions.assertThrows(CloneFailedException.class, () -> {
            throw new CloneFailedException("Exception message");
        });
    }

    @Test
    public void testThrowingInformativeException() {
        Assertions.assertThrows(CloneFailedException.class, () -> {
            throw new CloneFailedException("Exception message", (Throwable)this.generateCause());
        });
    }

    @Test
    public void testWithCauseAndMessage() {
        CloneFailedException exception = new CloneFailedException("Exception message", (Throwable)this.generateCause());
        Assertions.assertNotNull((Object)exception);
        Assertions.assertEquals((Object)"Exception message", (Object)exception.getMessage(), (String)"Wrong exception message");
        Throwable cause = exception.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertEquals((Object)"Cause message", (Object)cause.getMessage(), (String)"Wrong cause message");
    }

    @Test
    public void testWithoutCause() {
        CloneFailedException exception = new CloneFailedException("Exception message");
        Assertions.assertNotNull((Object)exception);
        Assertions.assertEquals((Object)"Exception message", (Object)exception.getMessage(), (String)"Wrong exception message");
        Throwable cause = exception.getCause();
        Assertions.assertNull((Object)cause);
    }

    @Test
    public void testWithoutMessage() {
        CloneFailedException exception = new CloneFailedException((Throwable)this.generateCause());
        Assertions.assertNotNull((Object)exception);
        Assertions.assertNotNull((Object)exception.getMessage());
        Throwable cause = exception.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertEquals((Object)"Cause message", (Object)cause.getMessage(), (String)"Wrong cause message");
    }
}

