/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.Base64;
import org.signal.core.util.InputStreamExtensionsKt;
import org.signal.core.util.stream.LimitedInputStream;
import org.signal.core.util.stream.TrimmingInputStream;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.incrementalmac.ChunkSizeChoice;
import org.signal.libsignal.protocol.incrementalmac.IncrementalMacInputStream;
import org.signal.libsignal.protocol.kdf.HKDF;
import org.whispersystems.signalservice.api.backup.MediaRootBackupKey;
import org.whispersystems.signalservice.api.crypto.BetterCipherInputStream;
import org.whispersystems.signalservice.api.crypto.DigestValidatingInputStream;
import org.whispersystems.signalservice.api.crypto.IncrementalMacAdditionalValidationsInputStream;
import org.whispersystems.signalservice.api.crypto.MacValidatingInputStream;
import org.whispersystems.signalservice.internal.util.Util;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003234B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0005H\u0007JB\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0005H\u0007JJ\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0005H\u0007J \u0010\u001c\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000fH\u0007J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000fH\u0007J \u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\rH\u0003JD\u0010#\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0005H\u0003J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u000fH\u0002J\b\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000fH\u0002J.\u0010-\u001a\u00020.2\b\b\u0001\u0010&\u001a\u00020\t2\u0006\u0010/\u001a\u00020\r2\b\b\u0001\u00100\u001a\u00020+2\b\u00101\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/whispersystems/signalservice/api/crypto/AttachmentCipherInputStream;", "", "<init>", "()V", "BLOCK_SIZE", "", "CIPHER_KEY_SIZE", "MAC_KEY_SIZE", "createForAttachment", "Ljava/io/InputStream;", "file", "Ljava/io/File;", "plaintextLength", "", "combinedKeyMaterial", "", "integrityCheck", "Lorg/whispersystems/signalservice/api/crypto/AttachmentCipherInputStream$IntegrityCheck;", "incrementalDigest", "incrementalMacChunkSize", "streamSupplier", "Lorg/whispersystems/signalservice/api/crypto/AttachmentCipherInputStream$StreamSupplier;", "streamLength", "createForArchivedMedia", "archivedMediaKeyMaterial", "Lorg/whispersystems/signalservice/api/backup/MediaRootBackupKey$MediaKeyMaterial;", "originalCipherTextLength", "plaintextHash", "createForArchivedThumbnail", "innerCombinedKeyMaterial", "createForStickerData", "data", "packKey", "createForArchivedMediaOuterLayer", "Lorg/signal/core/util/stream/LimitedInputStream;", "create", "createCipher", "Ljavax/crypto/Cipher;", "inputStream", "aesKey", "sha256Digest", "Ljava/security/MessageDigest;", "initMac", "Ljavax/crypto/Mac;", "key", "verifyMacAndMaybeEncryptedDigest", "", "length", "mac", "theirDigest", "CombinedKeyMaterial", "StreamSupplier", "IntegrityCheck", "signal-service-java"})
public final class AttachmentCipherInputStream {
    @NotNull
    public static final AttachmentCipherInputStream INSTANCE = new AttachmentCipherInputStream();
    private static final int BLOCK_SIZE = 16;
    private static final int CIPHER_KEY_SIZE = 32;
    private static final int MAC_KEY_SIZE = 32;

    private AttachmentCipherInputStream() {
    }

    @JvmStatic
    @NotNull
    public static final InputStream createForAttachment(@NotNull File file, long plaintextLength, @NotNull byte[] combinedKeyMaterial, @NotNull IntegrityCheck integrityCheck, @Nullable byte[] incrementalDigest, int incrementalMacChunkSize) throws InvalidMessageException, IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)combinedKeyMaterial, (String)"combinedKeyMaterial");
        Intrinsics.checkNotNullParameter((Object)integrityCheck, (String)"integrityCheck");
        return AttachmentCipherInputStream.create(() -> AttachmentCipherInputStream.createForAttachment$lambda$0(file), file.length(), plaintextLength, combinedKeyMaterial, integrityCheck, incrementalDigest, incrementalMacChunkSize);
    }

    @JvmStatic
    @NotNull
    public static final InputStream createForAttachment(@NotNull StreamSupplier streamSupplier, long streamLength, long plaintextLength, @NotNull byte[] combinedKeyMaterial, @NotNull IntegrityCheck integrityCheck, @Nullable byte[] incrementalDigest, int incrementalMacChunkSize) throws InvalidMessageException, IOException {
        Intrinsics.checkNotNullParameter((Object)streamSupplier, (String)"streamSupplier");
        Intrinsics.checkNotNullParameter((Object)combinedKeyMaterial, (String)"combinedKeyMaterial");
        Intrinsics.checkNotNullParameter((Object)integrityCheck, (String)"integrityCheck");
        return AttachmentCipherInputStream.create(streamSupplier, streamLength, plaintextLength, combinedKeyMaterial, integrityCheck, incrementalDigest, incrementalMacChunkSize);
    }

    @JvmStatic
    @NotNull
    public static final InputStream createForArchivedMedia(@NotNull MediaRootBackupKey.MediaKeyMaterial archivedMediaKeyMaterial, @NotNull File file, long originalCipherTextLength, long plaintextLength, @NotNull byte[] combinedKeyMaterial, @NotNull byte[] plaintextHash, @Nullable byte[] incrementalDigest, int incrementalMacChunkSize) throws InvalidMessageException, IOException {
        Intrinsics.checkNotNullParameter((Object)archivedMediaKeyMaterial, (String)"archivedMediaKeyMaterial");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)combinedKeyMaterial, (String)"combinedKeyMaterial");
        Intrinsics.checkNotNullParameter((Object)plaintextHash, (String)"plaintextHash");
        CombinedKeyMaterial keyMaterial = CombinedKeyMaterial.Companion.from(combinedKeyMaterial);
        Mac mac = INSTANCE.initMac(keyMaterial.getMacKey());
        if (originalCipherTextLength <= (long)(16 + mac.getMacLength())) {
            throw new InvalidMessageException("Message shorter than crypto overhead!");
        }
        return AttachmentCipherInputStream.create(() -> AttachmentCipherInputStream.createForArchivedMedia$lambda$1(archivedMediaKeyMaterial, file, originalCipherTextLength), originalCipherTextLength, plaintextLength, combinedKeyMaterial, new IntegrityCheck(null, plaintextHash), incrementalDigest, incrementalMacChunkSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final InputStream createForArchivedThumbnail(@NotNull MediaRootBackupKey.MediaKeyMaterial archivedMediaKeyMaterial, @NotNull File file, @NotNull byte[] innerCombinedKeyMaterial) throws InvalidMessageException, IOException {
        Intrinsics.checkNotNullParameter((Object)archivedMediaKeyMaterial, (String)"archivedMediaKeyMaterial");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)innerCombinedKeyMaterial, (String)"innerCombinedKeyMaterial");
        Mac outerMac = INSTANCE.initMac(archivedMediaKeyMaterial.getMacKey());
        if (file.length() <= (long)(16 + outerMac.getMacLength())) {
            throw new InvalidMessageException("Message shorter than crypto overhead! Expected at least " + (16 + outerMac.getMacLength()) + " bytes, got " + file.length());
        }
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream macVerificationStream = (FileInputStream)closeable;
            boolean bl = false;
            INSTANCE.verifyMacAndMaybeEncryptedDigest(macVerificationStream, file.length(), outerMac, null);
            macVerificationStream = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        LimitedInputStream outerEncryptedStreamExcludingMac = new LimitedInputStream((InputStream)new FileInputStream(file), file.length() - (long)outerMac.getMacLength());
        Cipher outerCipher = INSTANCE.createCipher((InputStream)outerEncryptedStreamExcludingMac, archivedMediaKeyMaterial.getAesKey());
        BetterCipherInputStream innerEncryptedStream = new BetterCipherInputStream((InputStream)outerEncryptedStreamExcludingMac, outerCipher);
        CombinedKeyMaterial innerKeyMaterial = CombinedKeyMaterial.Companion.from(innerCombinedKeyMaterial);
        Mac innerMac = INSTANCE.initMac(innerKeyMaterial.getMacKey());
        MacValidatingInputStream innerEncryptedStreamWithMac = new MacValidatingInputStream(innerEncryptedStream, innerMac);
        TrimmingInputStream innerEncryptedStreamExcludingMac = new TrimmingInputStream((InputStream)innerEncryptedStreamWithMac, innerMac.getMacLength(), true);
        Cipher innerCipher = INSTANCE.createCipher((InputStream)innerEncryptedStreamExcludingMac, innerKeyMaterial.getAesKey());
        return new BetterCipherInputStream((InputStream)innerEncryptedStreamExcludingMac, innerCipher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final InputStream createForStickerData(@NotNull byte[] data, @NotNull byte[] packKey) throws InvalidMessageException, IOException {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)packKey, (String)"packKey");
        String string = "Sticker Pack";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        CombinedKeyMaterial keyMaterial = CombinedKeyMaterial.Companion.from(HKDF.deriveSecrets((byte[])packKey, (byte[])byArray, (int)64));
        Mac mac = INSTANCE.initMac(keyMaterial.getMacKey());
        if (data.length <= 16 + mac.getMacLength()) {
            throw new InvalidMessageException("Message shorter than crypto overhead!");
        }
        Closeable closeable = new ByteArrayInputStream(data);
        Throwable throwable = null;
        try {
            ByteArrayInputStream inputStream = (ByteArrayInputStream)closeable;
            boolean bl = false;
            INSTANCE.verifyMacAndMaybeEncryptedDigest(inputStream, data.length, mac, null);
            inputStream = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        ByteArrayInputStream encryptedStream = new ByteArrayInputStream(data);
        LimitedInputStream encryptedStreamExcludingMac = new LimitedInputStream((InputStream)encryptedStream, (long)data.length - (long)mac.getMacLength());
        Cipher cipher = INSTANCE.createCipher((InputStream)encryptedStreamExcludingMac, keyMaterial.getAesKey());
        return new BetterCipherInputStream((InputStream)encryptedStreamExcludingMac, cipher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    private static final LimitedInputStream createForArchivedMediaOuterLayer(MediaRootBackupKey.MediaKeyMaterial archivedMediaKeyMaterial, File file, long originalCipherTextLength) throws InvalidMessageException, IOException {
        Mac mac = INSTANCE.initMac(archivedMediaKeyMaterial.getMacKey());
        if (file.length() <= (long)(16 + mac.getMacLength())) {
            throw new InvalidMessageException("Message shorter than crypto overhead! Expected at least " + (16 + mac.getMacLength()) + " bytes, got " + file.length());
        }
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream macVerificationStream = (FileInputStream)closeable;
            boolean bl = false;
            INSTANCE.verifyMacAndMaybeEncryptedDigest(macVerificationStream, file.length(), mac, null);
            macVerificationStream = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        FileInputStream encryptedStream = new FileInputStream(file);
        LimitedInputStream encryptedStreamExcludingMac = new LimitedInputStream((InputStream)encryptedStream, file.length() - (long)mac.getMacLength());
        Cipher cipher = INSTANCE.createCipher((InputStream)encryptedStreamExcludingMac, archivedMediaKeyMaterial.getAesKey());
        InputStream inputStream = new BetterCipherInputStream((InputStream)encryptedStreamExcludingMac, cipher);
        return new LimitedInputStream(inputStream, originalCipherTextLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    private static final InputStream create(StreamSupplier streamSupplier, long streamLength, long plaintextLength, byte[] combinedKeyMaterial, IntegrityCheck integrityCheck, byte[] incrementalDigest, int incrementalMacChunkSize) throws InvalidMessageException, IOException {
        InputStream inputStream;
        boolean hasIncrementalMac;
        CombinedKeyMaterial keyMaterial = CombinedKeyMaterial.Companion.from(combinedKeyMaterial);
        Mac mac = INSTANCE.initMac(keyMaterial.getMacKey());
        if (streamLength <= (long)(16 + mac.getMacLength())) {
            throw new InvalidMessageException("Message shorter than crypto overhead! length: " + streamLength);
        }
        InputStream wrappedStream = null;
        boolean bl = incrementalDigest != null && !(incrementalDigest.length == 0) && incrementalMacChunkSize > 0 ? true : (hasIncrementalMac = false);
        if (hasIncrementalMac) {
            if (integrityCheck == null) {
                throw new InvalidMessageException("Missing integrityCheck for incremental mac validation!");
            }
            digestValidatingStream = integrityCheck.getEncryptedDigest() != null ? (InputStream)new DigestValidatingInputStream(streamSupplier.openStream(), INSTANCE.sha256Digest(), integrityCheck.getEncryptedDigest()) : streamSupplier.openStream();
            wrappedStream = (InputStream)new IncrementalMacInputStream((InputStream)new IncrementalMacAdditionalValidationsInputStream((InputStream)digestValidatingStream, streamLength, mac), keyMaterial.getMacKey(), ChunkSizeChoice.Companion.everyNthByte(incrementalMacChunkSize), incrementalDigest);
        } else {
            digestValidatingStream = streamSupplier.openStream();
            Throwable throwable = null;
            try {
                InputStream macVerificationStream = (InputStream)digestValidatingStream;
                boolean bl2 = false;
                IntegrityCheck integrityCheck2 = integrityCheck;
                INSTANCE.verifyMacAndMaybeEncryptedDigest(macVerificationStream, streamLength, mac, (byte[])(integrityCheck2 != null ? integrityCheck2.getEncryptedDigest() : null));
                macVerificationStream = Unit.INSTANCE;
            }
            catch (Throwable bl2) {
                throwable = bl2;
                throw bl2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)digestValidatingStream, (Throwable)throwable);
            }
            wrappedStream = streamSupplier.openStream();
        }
        LimitedInputStream encryptedStreamExcludingMac = new LimitedInputStream(wrappedStream, streamLength - (long)mac.getMacLength());
        Cipher cipher = INSTANCE.createCipher((InputStream)encryptedStreamExcludingMac, keyMaterial.getAesKey());
        InputStream decryptingStream = new BetterCipherInputStream((InputStream)encryptedStreamExcludingMac, cipher);
        LimitedInputStream paddinglessDecryptingStream = new LimitedInputStream(decryptingStream, plaintextLength);
        IntegrityCheck integrityCheck3 = integrityCheck;
        if ((byte[])(integrityCheck3 != null ? integrityCheck3.getPlaintextHash() : null) != null) {
            if (integrityCheck.getPlaintextHash().length != MessageDigest.getInstance("SHA-256").getDigestLength()) {
                throw new InvalidMessageException("Invalid plaintext hash size: " + integrityCheck.getPlaintextHash().length);
            }
            inputStream = new DigestValidatingInputStream((InputStream)paddinglessDecryptingStream, INSTANCE.sha256Digest(), integrityCheck.getPlaintextHash());
        } else {
            inputStream = (InputStream)paddinglessDecryptingStream;
        }
        return inputStream;
    }

    private final Cipher createCipher(InputStream inputStream, byte[] aesKey) {
        Cipher cipher;
        byte[] iv = InputStreamExtensionsKt.readNBytesOrThrow((InputStream)inputStream, (int)16);
        Cipher $this$createCipher_u24lambda_u246 = cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        boolean bl = false;
        $this$createCipher_u24lambda_u246.init(2, (Key)new SecretKeySpec(aesKey, "AES"), new IvParameterSpec(iv));
        Cipher cipher2 = cipher;
        Intrinsics.checkNotNullExpressionValue((Object)cipher2, (String)"apply(...)");
        return cipher2;
    }

    private final MessageDigest sha256Digest() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
            return messageDigest;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private final Mac initMac(byte[] key) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            Intrinsics.checkNotNull((Object)mac);
            return mac;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
    }

    private final void verifyMacAndMaybeEncryptedDigest(@Nonnull InputStream inputStream, long length, @Nonnull Mac mac, byte[] theirDigest) throws InvalidMessageException {
        try {
            int read;
            MessageDigest digest = MessageDigest.getInstance("SHA256");
            byte[] buffer = new byte[4096];
            for (int remainingData = Util.toIntExact(length) - mac.getMacLength(); remainingData > 0; remainingData -= read) {
                read = inputStream.read(buffer, 0, Math.min(buffer.length, remainingData));
                mac.update(buffer, 0, read);
                digest.update(buffer, 0, read);
            }
            byte[] ourMac = mac.doFinal();
            byte[] theirMac = new byte[mac.getMacLength()];
            Util.readFully(inputStream, theirMac);
            if (!MessageDigest.isEqual(ourMac, theirMac)) {
                throw new InvalidMessageException("MAC doesn't match!");
            }
            byte[] ourDigest = digest.digest(theirMac);
            if (theirDigest != null && !MessageDigest.isEqual(ourDigest, theirDigest)) {
                throw new InvalidMessageException("Digest doesn't match!");
            }
        }
        catch (IOException e) {
            throw new InvalidMessageException((Throwable)e);
        }
        catch (ArithmeticException e) {
            throw new InvalidMessageException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static final InputStream createForAttachment$lambda$0(File $file) {
        return new FileInputStream($file);
    }

    private static final InputStream createForArchivedMedia$lambda$1(MediaRootBackupKey.MediaKeyMaterial $archivedMediaKeyMaterial, File $file, long $originalCipherTextLength) {
        return (InputStream)AttachmentCipherInputStream.createForArchivedMediaOuterLayer($archivedMediaKeyMaterial, $file, $originalCipherTextLength);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/whispersystems/signalservice/api/crypto/AttachmentCipherInputStream$CombinedKeyMaterial;", "", "aesKey", "", "macKey", "<init>", "([B[B)V", "getAesKey", "()[B", "getMacKey", "Companion", "signal-service-java"})
    private static final class CombinedKeyMaterial {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final byte[] aesKey;
        @NotNull
        private final byte[] macKey;

        public CombinedKeyMaterial(@NotNull byte[] aesKey, @NotNull byte[] macKey) {
            Intrinsics.checkNotNullParameter((Object)aesKey, (String)"aesKey");
            Intrinsics.checkNotNullParameter((Object)macKey, (String)"macKey");
            this.aesKey = aesKey;
            this.macKey = macKey;
        }

        @NotNull
        public final byte[] getAesKey() {
            return this.aesKey;
        }

        @NotNull
        public final byte[] getMacKey() {
            return this.macKey;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/whispersystems/signalservice/api/crypto/AttachmentCipherInputStream$CombinedKeyMaterial$Companion;", "", "<init>", "()V", "from", "Lorg/whispersystems/signalservice/api/crypto/AttachmentCipherInputStream$CombinedKeyMaterial;", "combinedKeyMaterial", "", "signal-service-java"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CombinedKeyMaterial from(@NotNull byte[] combinedKeyMaterial) {
                Intrinsics.checkNotNullParameter((Object)combinedKeyMaterial, (String)"combinedKeyMaterial");
                byte[][] parts = Util.split(combinedKeyMaterial, 32, 32);
                byte[] byArray = parts[0];
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"get(...)");
                byte[] byArray2 = parts[1];
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"get(...)");
                return new CombinedKeyMaterial(byArray, byArray2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/whispersystems/signalservice/api/crypto/AttachmentCipherInputStream$IntegrityCheck;", "", "encryptedDigest", "", "plaintextHash", "<init>", "([B[B)V", "getEncryptedDigest", "()[B", "getPlaintextHash", "Companion", "signal-service-java"})
    public static final class IntegrityCheck {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final byte[] encryptedDigest;
        @Nullable
        private final byte[] plaintextHash;

        public IntegrityCheck(@Nullable byte[] encryptedDigest, @Nullable byte[] plaintextHash) {
            this.encryptedDigest = encryptedDigest;
            this.plaintextHash = plaintextHash;
            if (this.encryptedDigest == null && this.plaintextHash == null) {
                throw new IllegalArgumentException("At least one of encryptedDigest or plaintextHash must be provided");
            }
        }

        @Nullable
        public final byte[] getEncryptedDigest() {
            return this.encryptedDigest;
        }

        @Nullable
        public final byte[] getPlaintextHash() {
            return this.plaintextHash;
        }

        @JvmStatic
        @NotNull
        public static final IntegrityCheck forEncryptedDigest(@NotNull byte[] encryptedDigest) {
            return Companion.forEncryptedDigest(encryptedDigest);
        }

        @JvmStatic
        @NotNull
        public static final IntegrityCheck forPlaintextHash(@NotNull byte[] plaintextHash) {
            return Companion.forPlaintextHash(plaintextHash);
        }

        @JvmStatic
        @NotNull
        public static final IntegrityCheck forEncryptedDigestAndPlaintextHash(@Nullable byte[] encryptedDigest, @Nullable String plaintextHash) {
            return Companion.forEncryptedDigestAndPlaintextHash(encryptedDigest, plaintextHash);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0007J\u001c\u0010\n\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u000bH\u0007\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/crypto/AttachmentCipherInputStream$IntegrityCheck$Companion;", "", "<init>", "()V", "forEncryptedDigest", "Lorg/whispersystems/signalservice/api/crypto/AttachmentCipherInputStream$IntegrityCheck;", "encryptedDigest", "", "forPlaintextHash", "plaintextHash", "forEncryptedDigestAndPlaintextHash", "", "signal-service-java"})
        @SourceDebugExtension(value={"SMAP\nAttachmentCipherInputStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachmentCipherInputStream.kt\norg/whispersystems/signalservice/api/crypto/AttachmentCipherInputStream$IntegrityCheck$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,407:1\n1#2:408\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final IntegrityCheck forEncryptedDigest(@NotNull byte[] encryptedDigest) {
                Intrinsics.checkNotNullParameter((Object)encryptedDigest, (String)"encryptedDigest");
                return new IntegrityCheck(encryptedDigest, null);
            }

            @JvmStatic
            @NotNull
            public final IntegrityCheck forPlaintextHash(@NotNull byte[] plaintextHash) {
                Intrinsics.checkNotNullParameter((Object)plaintextHash, (String)"plaintextHash");
                return new IntegrityCheck(null, plaintextHash);
            }

            @JvmStatic
            @NotNull
            public final IntegrityCheck forEncryptedDigestAndPlaintextHash(@Nullable byte[] encryptedDigest, @Nullable String plaintextHash) {
                byte[] byArray;
                String string = plaintextHash;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    byArray = Base64.decode((String)it);
                } else {
                    byArray = null;
                }
                byte[] plaintextHashBytes = byArray;
                return new IntegrityCheck(encryptedDigest, plaintextHashBytes);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lorg/whispersystems/signalservice/api/crypto/AttachmentCipherInputStream$StreamSupplier;", "", "openStream", "Ljava/io/InputStream;", "signal-service-java"})
    public static interface StreamSupplier {
        @Nonnull
        @NotNull
        public InputStream openStream() throws IOException;
    }
}

