/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.task;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Strings;
import org.elasticsearch.license.LicensedAllocatedPersistentTask;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;

public class JobTask
extends LicensedAllocatedPersistentTask
implements OpenJobAction.JobTaskMatcher {
    private static final Logger logger = LogManager.getLogger(JobTask.class);
    private final String jobId;
    private final AtomicReference<ClosingOrVacating> closingOrVacating = new AtomicReference<ClosingOrVacating>(ClosingOrVacating.NEITHER);
    private volatile AutodetectProcessManager autodetectProcessManager;

    protected JobTask(String jobId, long id, String type, String action, TaskId parentTask, Map<String, String> headers, XPackLicenseState licenseState) {
        super(id, type, action, "job-" + jobId, parentTask, headers, MachineLearning.ML_ANOMALY_JOBS_FEATURE, "job-" + jobId, licenseState);
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    protected void onCancelled() {
        String reason = this.getReasonCancelled();
        logger.trace(() -> Strings.format((String)"[%s] Cancelling job task because: %s", (Object[])new Object[]{this.jobId, reason}));
        this.closingOrVacating.set(ClosingOrVacating.CLOSING);
        this.autodetectProcessManager.killProcess(this, false, reason);
    }

    public boolean isClosing() {
        return this.closingOrVacating.get() == ClosingOrVacating.CLOSING;
    }

    public boolean triggerVacate() {
        return this.closingOrVacating.compareAndSet(ClosingOrVacating.NEITHER, ClosingOrVacating.VACATING);
    }

    public boolean isVacating() {
        return this.closingOrVacating.get() == ClosingOrVacating.VACATING;
    }

    public void closeJob(String reason) {
        if (this.closingOrVacating.getAndSet(ClosingOrVacating.CLOSING) == ClosingOrVacating.VACATING) {
            logger.info("[{}] Close request for job while it was vacating the node", (Object)this.jobId);
        }
        this.autodetectProcessManager.closeJob(this, reason);
    }

    public void killJob(String reason) {
        this.closingOrVacating.set(ClosingOrVacating.CLOSING);
        this.autodetectProcessManager.killProcess(this, true, reason);
    }

    void setAutodetectProcessManager(AutodetectProcessManager autodetectProcessManager) {
        this.autodetectProcessManager = autodetectProcessManager;
    }

    static enum ClosingOrVacating {
        NEITHER,
        VACATING,
        CLOSING;

    }
}

