/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.querydsl.query;

import java.util.Objects;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class WildcardQuery
extends Query {
    private final String field;
    private final String query;
    private final boolean caseInsensitive;

    public WildcardQuery(Source source, String field, String query) {
        this(source, field, query, false);
    }

    public WildcardQuery(Source source, String field, String query, boolean caseInsensitive) {
        super(source);
        this.field = field;
        this.query = query;
        this.caseInsensitive = caseInsensitive;
    }

    public String field() {
        return this.field;
    }

    public String query() {
        return this.query;
    }

    public Boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    protected QueryBuilder asBuilder() {
        WildcardQueryBuilder wb = QueryBuilders.wildcardQuery((String)this.field, (String)this.query);
        return !this.caseInsensitive ? wb : wb.caseInsensitive(this.caseInsensitive);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.query, this.caseInsensitive);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WildcardQuery other = (WildcardQuery)obj;
        return Objects.equals(this.field, other.field) && Objects.equals(this.query, other.query) && Objects.equals(this.caseInsensitive, other.caseInsensitive);
    }

    @Override
    protected String innerToString() {
        return this.field + ":" + this.query;
    }
}

