/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.array.SparseArray;
import org.ojalgo.array.operation.AXPY;
import org.ojalgo.array.operation.CorePrimitiveOperation;
import org.ojalgo.array.operation.IndexOf;
import org.ojalgo.equation.Equation;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.optimisation.ModelEntity;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.UpdatableSolver;
import org.ojalgo.optimisation.linear.LinearSolver;
import org.ojalgo.optimisation.linear.SimplexSolver;
import org.ojalgo.optimisation.linear.TableauCutGenerator;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.ElementView1D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.type.IndexSelector;
import org.ojalgo.type.context.NumberContext;
import org.ojalgo.type.keyvalue.EntryPair;

abstract class SimplexTableau
extends SimplexSolver.Primitive2D {
    static final Array1D.Factory<Double> ARRAY1D_FACTORY = Array1D.factory(Primitive64Array.FACTORY);
    static final DenseArray.Factory<Double> DENSE_FACTORY = Primitive64Array.FACTORY;
    private final int[] myBasis;
    private transient SimplexSolver.Primitive2D myConstraintsBody = null;
    private transient SimplexSolver.Primitive1D myConstraintsRHS = null;
    private final int myNumberOfArtificialVariables;
    private final int myNumberOfConstraints;
    private final int myNumberOfIdentitySlackVariables;
    private final int myNumberOfProblemVariables;
    private final int myNumberOfSlackVariables;
    private transient SimplexSolver.Primitive1D myObjective = null;
    private final IndexSelector mySelector;
    final MetaData meta;

    static void copy(LinearSolver.Builder builder, SimplexTableau tableau) {
        MatrixStore<Double> mtrxAE = builder.getAE();
        SimplexSolver.Primitive2D body = tableau.constraintsBody();
        for (int i = 0; i < mtrxAE.getRowDim(); ++i) {
            for (int j = 0; j < mtrxAE.getColDim(); ++j) {
                double value = mtrxAE.doubleValue(i, j);
                if (!(Math.abs(value) > PrimitiveMath.MACHINE_EPSILON)) continue;
                body.set((long)i, (long)j, value);
            }
        }
        MatrixStore<Double> mtrxBE = builder.getBE();
        SimplexSolver.Primitive1D rhs = tableau.constraintsRHS();
        for (int i = 0; i < mtrxBE.size(); ++i) {
            rhs.set((long)i, mtrxBE.doubleValue(i));
        }
        MatrixStore<Double> mtrxC = builder.getC();
        SimplexSolver.Primitive1D obj = tableau.objective();
        for (int i = 0; i < mtrxC.size(); ++i) {
            obj.set((long)i, mtrxC.doubleValue(i));
        }
    }

    static boolean isSparse(Optimisation.Options options) {
        return options.sparse != null && options.sparse != false;
    }

    static SimplexTableau make(int nbConstraints, int nbPositiveProblemVariables, int nbNegativeProblemVariables, int nbSlackVariables, int nbIdentitySlackVariables, boolean needDual, Optimisation.Options options) {
        if (SimplexTableau.isSparse(options)) {
            return new SparseTableau(nbConstraints, nbPositiveProblemVariables, nbNegativeProblemVariables, nbSlackVariables, nbIdentitySlackVariables, needDual);
        }
        return new DenseRawTableau(nbConstraints, nbPositiveProblemVariables, nbNegativeProblemVariables, nbSlackVariables, nbIdentitySlackVariables, needDual);
    }

    static SimplexTableau make(LinearSolver.Builder builder, Optimisation.Options options) {
        int nbConstraints = builder.countConstraints();
        int nbProblemVariables = builder.countVariables();
        int nbSlackVariables = 0;
        int nbIdentitySlackVariables = 0;
        boolean needDual = true;
        SimplexTableau tableau = SimplexTableau.make(nbConstraints, nbProblemVariables, 0, nbSlackVariables, nbIdentitySlackVariables, needDual, options);
        SimplexTableau.copy(builder, tableau);
        return tableau;
    }

    static SimplexTableau newDense(LinearSolver.Builder matrices) {
        DenseTransposedTableau tableau = new DenseTransposedTableau(matrices.countConstraints(), matrices.countVariables(), 0, 0, 0, true);
        SimplexTableau.copy(matrices, tableau);
        return tableau;
    }

    static SparseTableau newSparse(LinearSolver.Builder matrices) {
        SparseTableau tableau = new SparseTableau(matrices.countConstraints(), matrices.countVariables(), 0, 0, 0, true);
        SimplexTableau.copy(matrices, tableau);
        return tableau;
    }

    static int size(int nbConstraints, int nbProblemVariables, int nbSlackVariables, int nbIdentitySlackVariables, boolean needDual) {
        int numbRows = nbConstraints + 2;
        int numbCols = nbProblemVariables + nbSlackVariables + (needDual ? nbConstraints : nbIdentitySlackVariables) + 1;
        return numbRows * numbCols;
    }

    SimplexTableau(int nbConstraints, int nbPositiveProblemVariables, int nbNegativeProblemVariables, int nbSlackVariables, int nbIdentitySlackVariables, boolean needDual) {
        this.myNumberOfConstraints = nbConstraints;
        this.myNumberOfProblemVariables = nbPositiveProblemVariables + nbNegativeProblemVariables;
        this.myNumberOfSlackVariables = nbSlackVariables;
        this.myNumberOfIdentitySlackVariables = nbIdentitySlackVariables;
        this.myNumberOfArtificialVariables = needDual ? nbConstraints - nbIdentitySlackVariables : 0;
        this.mySelector = new IndexSelector(this.countVariables());
        this.myBasis = BasicArray.makeIncreasingRange(-nbConstraints, nbConstraints);
        this.meta = new MetaData(nbConstraints, nbPositiveProblemVariables, nbNegativeProblemVariables, nbSlackVariables + nbIdentitySlackVariables);
    }

    final SimplexSolver.Primitive2D constraintsBody() {
        if (this.myConstraintsBody == null) {
            this.myConstraintsBody = this.newConstraintsBody();
        }
        return this.myConstraintsBody;
    }

    final SimplexSolver.Primitive1D constraintsRHS() {
        if (this.myConstraintsRHS == null) {
            this.myConstraintsRHS = this.newConstraintsRHS();
        }
        return this.myConstraintsRHS;
    }

    final int countArtificialVariables() {
        return this.myNumberOfArtificialVariables;
    }

    final int countBasicArtificials() {
        int retVal = 0;
        int limit = this.myBasis.length;
        for (int i = 0; i < limit; ++i) {
            if (this.myBasis[i] >= 0) continue;
            ++retVal;
        }
        return retVal;
    }

    final int countBasisDeficit() {
        return this.myNumberOfConstraints - this.mySelector.countIncluded();
    }

    int countConstraints() {
        return this.myNumberOfConstraints;
    }

    int countIdentitySlackVariables() {
        return this.myNumberOfIdentitySlackVariables;
    }

    int countProblemVariables() {
        return this.myNumberOfProblemVariables;
    }

    int countSlackVariables() {
        return this.myNumberOfSlackVariables + this.myNumberOfIdentitySlackVariables;
    }

    int countVariables() {
        return this.myNumberOfProblemVariables + this.myNumberOfSlackVariables + this.myNumberOfIdentitySlackVariables;
    }

    int countVariablesTotally() {
        return this.myNumberOfProblemVariables + this.myNumberOfSlackVariables + this.myNumberOfIdentitySlackVariables + this.myNumberOfArtificialVariables;
    }

    int findNextPivotColumn(Access1D<Double> auxiliaryRow, Access1D<Double> objectiveRow) {
        ElementView1D nz;
        int i;
        int retVal = -1;
        double minQuotient = Double.MAX_VALUE;
        Iterator iterator = auxiliaryRow.nonzeros().iterator();
        while (iterator.hasNext() && (i = (int)(nz = (ElementView1D)iterator.next()).index()) < this.countVariables()) {
            double numerator;
            double quotient;
            double denominator = nz.doubleValue();
            if (!(denominator < -1.0E-8) || !((quotient = Math.abs((numerator = objectiveRow.doubleValue(i)) / denominator)) < minQuotient)) continue;
            minQuotient = quotient;
            retVal = i;
        }
        return retVal;
    }

    abstract boolean fixVariable(int var1, double var2);

    Collection<Equation> generateCutCandidates(boolean[] integer, NumberContext accuracy, double fractionality) {
        int nbConstraints = this.countConstraints();
        int nbProblemVariables = this.countProblemVariables();
        SimplexSolver.Primitive1D constraintsRHS = this.sliceConstraintsRHS();
        ArrayList<Equation> retVal = new ArrayList<Equation>();
        for (int i = 0; i < nbConstraints; ++i) {
            Equation maybe;
            int variableIndex = this.getBasisColumnIndex(i);
            double rhs = constraintsRHS.doubleValue(i);
            if (variableIndex < 0 || variableIndex >= nbProblemVariables || !integer[variableIndex] || accuracy.isInteger(rhs) || (maybe = TableauCutGenerator.doGomoryMixedInteger(this.sliceBodyRow(i), variableIndex, rhs, integer, fractionality)) == null) continue;
            retVal.add(maybe);
        }
        return retVal;
    }

    int[] getBasis() {
        return (int[])this.myBasis.clone();
    }

    int getBasisColumnIndex(int basisRowIndex) {
        return this.myBasis[basisRowIndex];
    }

    int getBasisRowIndex(int basisColumnIndex) {
        return IndexOf.indexOf(this.myBasis, basisColumnIndex);
    }

    int getDualIdentityBase() {
        return this.countVariablesTotally() - this.countConstraints();
    }

    final int[] getExcluded() {
        return this.mySelector.getExcluded();
    }

    final int[] getIncluded() {
        return this.mySelector.getIncluded();
    }

    abstract double getInfeasibility();

    abstract double getValue();

    boolean isAbleToExtractDual() {
        return this.myNumberOfIdentitySlackVariables + this.myNumberOfArtificialVariables == this.myNumberOfConstraints;
    }

    boolean isArtificials() {
        return this.myNumberOfArtificialVariables > 0;
    }

    final boolean isBasicArtificials() {
        return this.myNumberOfConstraints > this.mySelector.countIncluded();
    }

    final boolean isExcluded(int index) {
        return this.mySelector.isExcluded(index);
    }

    final boolean isIncluded(int index) {
        return this.mySelector.isIncluded(index);
    }

    abstract SimplexSolver.Primitive2D newConstraintsBody();

    abstract SimplexSolver.Primitive1D newConstraintsRHS();

    abstract SimplexSolver.Primitive1D newObjective();

    final SimplexSolver.Primitive1D objective() {
        if (this.myObjective == null) {
            this.myObjective = this.newObjective();
        }
        return this.myObjective;
    }

    abstract void pivot(SimplexSolver.IterationPoint var1);

    final SimplexSolver.Primitive1D sliceBodyColumn(final int col) {
        return new SimplexSolver.Primitive1D(){

            @Override
            public double doubleValue(int index) {
                return SimplexTableau.this.doubleValue(index, col);
            }

            @Override
            public void set(int index, double value) {
                SimplexTableau.this.set(index, col, value);
            }

            @Override
            public int size() {
                return SimplexTableau.this.countConstraints();
            }
        };
    }

    final SimplexSolver.Primitive1D sliceBodyRow(final int row) {
        return new SimplexSolver.Primitive1D(){

            @Override
            public double doubleValue(int index) {
                return SimplexTableau.this.doubleValue(row, index);
            }

            @Override
            public void set(int index, double value) {
                SimplexTableau.this.set(row, index, value);
            }

            @Override
            public int size() {
                return SimplexTableau.this.countVariables();
            }
        };
    }

    final SimplexSolver.Primitive1D sliceConstraintsRHS() {
        return this.constraintsRHS();
    }

    final SimplexSolver.Primitive1D sliceDualVariables() {
        final int nbConstraints = this.countConstraints();
        final int nbVariables = this.countVariablesTotally();
        final int dualIdentityBase = this.getDualIdentityBase();
        return new SimplexSolver.Primitive1D(){

            @Override
            public double doubleValue(int index) {
                return -SimplexTableau.this.doubleValue(nbConstraints, dualIdentityBase + index);
            }

            @Override
            public void set(int index, double value) {
                SimplexTableau.this.set(nbConstraints, dualIdentityBase + index, -value);
            }

            @Override
            public int size() {
                return nbVariables - dualIdentityBase;
            }
        };
    }

    final SimplexSolver.Primitive1D sliceTableauColumn(final int col) {
        return new SimplexSolver.Primitive1D(){

            @Override
            public double doubleValue(int index) {
                return SimplexTableau.this.doubleValue(index, col);
            }

            @Override
            public void set(int index, double value) {
                SimplexTableau.this.set(index, col, value);
            }

            @Override
            public int size() {
                return SimplexTableau.this.getRowDim();
            }
        };
    }

    final SimplexSolver.Primitive1D sliceTableauRow(final int row) {
        return new SimplexSolver.Primitive1D(){

            @Override
            public double doubleValue(int index) {
                return SimplexTableau.this.doubleValue(row, index);
            }

            @Override
            public void set(int index, double value) {
                SimplexTableau.this.set(row, index, value);
            }

            @Override
            public int size() {
                return SimplexTableau.this.getColDim();
            }
        };
    }

    abstract DenseTableau toDense();

    void update(int pivotRow, int pivotCol) {
        int tmpNew;
        int tmpOld = this.myBasis[pivotRow];
        if (tmpOld >= 0) {
            this.mySelector.exclude(tmpOld);
        }
        if ((tmpNew = pivotCol) >= 0) {
            this.mySelector.include(tmpNew);
        }
        this.myBasis[pivotRow] = pivotCol;
    }

    void update(long pivotRow, long pivotCol) {
        this.update(Math.toIntExact(pivotRow), Math.toIntExact(pivotCol));
    }

    void update(SimplexSolver.IterationPoint point) {
        this.update(point.row, point.col);
    }

    final double value(boolean phase1) {
        if (phase1) {
            return this.getInfeasibility();
        }
        return this.getValue();
    }

    static final class SparseTableau
    extends SimplexTableau {
        private double myInfeasibility = PrimitiveMath.ZERO;
        private final Array1D<Double> myObjectiveWeights;
        private final DenseArray<Double> myPhase1Weights;
        private final Array1D<Double> myRHS;
        private final SparseArray<Double>[] myRows;
        private final SparseArray.SparseFactory<Double> mySparseFactory;
        private double myValue = PrimitiveMath.ZERO;

        SparseTableau(int nbConstraints, int nbPositiveProblemVariables, int nbNegativeProblemVariables, int nbSlackVariables, int nbIdentitySlackVariables, boolean needDual) {
            super(nbConstraints, nbPositiveProblemVariables, nbNegativeProblemVariables, nbSlackVariables, nbIdentitySlackVariables, needDual);
            int nbProblemVariables = nbPositiveProblemVariables + nbNegativeProblemVariables;
            long initial = Math.max(5L, Math.round(Math.sqrt(Math.min(nbConstraints, nbProblemVariables))));
            this.mySparseFactory = (SparseArray.SparseFactory)SparseArray.factory(Primitive64Array.FACTORY).initial(initial);
            int totNumbVars = this.countVariablesTotally();
            this.myRows = new SparseArray[nbConstraints];
            for (int r = 0; r < nbConstraints; ++r) {
                this.myRows[r] = ((SparseArray.SparseFactory)this.mySparseFactory.limit(totNumbVars)).make();
            }
            this.myRHS = (Array1D)ARRAY1D_FACTORY.make(nbConstraints);
            this.myObjectiveWeights = (Array1D)ARRAY1D_FACTORY.make(totNumbVars);
            this.myPhase1Weights = (DenseArray)DENSE_FACTORY.make(totNumbVars);
        }

        @Override
        public double doubleValue(int row, int col) {
            int nbConstraints = this.countConstraints();
            int nbVariables = this.countVariablesTotally();
            if (row < nbConstraints) {
                if (col < nbVariables) {
                    return this.myRows[row].doubleValue(col);
                }
                return this.myRHS.doubleValue(row);
            }
            if (row == nbConstraints) {
                if (col < nbVariables) {
                    return this.myObjectiveWeights.doubleValue(col);
                }
                return this.myValue;
            }
            if (col < nbVariables) {
                return this.myPhase1Weights.doubleValue(col);
            }
            return this.myInfeasibility;
        }

        @Override
        public int getColDim() {
            return this.countVariablesTotally() + 1;
        }

        @Override
        public int getRowDim() {
            return this.countConstraints() + 2;
        }

        @Override
        public void set(int row, int col, double value) {
            int nbConstraints = this.countConstraints();
            int nbVariables = this.countVariablesTotally();
            if (row < nbConstraints) {
                if (col < nbVariables) {
                    this.myRows[row].set((long)col, value);
                } else {
                    this.myRHS.set((long)row, value);
                }
            } else if (row == nbConstraints) {
                if (col < nbVariables) {
                    this.myObjectiveWeights.set((long)col, value);
                } else {
                    this.myValue = value;
                }
            } else if (col < nbVariables) {
                this.myPhase1Weights.set((long)col, value);
            } else {
                this.myInfeasibility = value;
            }
        }

        private void doPivot(int row, int col, SparseArray<Double> pivotRowBody, double pivotRowRHS) {
            double colVal;
            for (int i = 0; i < this.myRows.length; ++i) {
                SparseArray<Double> rowY;
                if (i == row || (colVal = -(rowY = this.myRows[i]).doubleValue(col)) == PrimitiveMath.ZERO) continue;
                pivotRowBody.axpy(colVal, rowY);
                this.myRHS.add((long)i, colVal * pivotRowRHS);
            }
            colVal = -this.myObjectiveWeights.doubleValue(col);
            if (colVal != PrimitiveMath.ZERO) {
                pivotRowBody.axpy(colVal, this.myObjectiveWeights);
                this.myValue += colVal * pivotRowRHS;
            }
            if ((colVal = -this.myPhase1Weights.doubleValue(col)) != PrimitiveMath.ZERO) {
                pivotRowBody.axpy(colVal, this.myPhase1Weights);
                this.myInfeasibility += colVal * pivotRowRHS;
            }
        }

        private double scale(SparseArray<Double> pivotRowBody, double pivotRowRHS, int col) {
            double pivotElement = pivotRowBody.doubleValue(col);
            if (pivotElement != PrimitiveMath.ONE) {
                UnaryFunction<double> modifier = PrimitiveMath.DIVIDE.second(pivotElement);
                pivotRowBody.modifyAll(modifier);
                return modifier.invoke(pivotRowRHS);
            }
            return pivotRowRHS;
        }

        @Override
        boolean fixVariable(int index, double value) {
            int row = this.getBasisRowIndex(index);
            if (row < 0) {
                return false;
            }
            SparseArray<Double> currentRow = this.myRows[row];
            double currentRHS = this.myRHS.doubleValue(row);
            int totNumbVars = this.countVariablesTotally();
            Access1D auxiliaryRow = ((SparseArray.SparseFactory)this.mySparseFactory.limit(totNumbVars)).make();
            double auxiliaryRHS = PrimitiveMath.ZERO;
            if (currentRHS > value) {
                currentRow.axpy(PrimitiveMath.NEG, (Mutate1D.Modifiable<?>)((Object)auxiliaryRow));
                ((SparseArray)auxiliaryRow).set(index, PrimitiveMath.ZERO);
                auxiliaryRHS = value - currentRHS;
            } else if (currentRHS < value) {
                currentRow.axpy(PrimitiveMath.ONE, (Mutate1D.Modifiable<?>)((Object)auxiliaryRow));
                ((SparseArray)auxiliaryRow).set(index, PrimitiveMath.ZERO);
                auxiliaryRHS = currentRHS - value;
            } else {
                return true;
            }
            SimplexSolver.Primitive1D objectiveRow = this.sliceTableauRow(this.countConstraints());
            int pivotCol = this.findNextPivotColumn(auxiliaryRow, objectiveRow);
            if (pivotCol < 0) {
                return false;
            }
            auxiliaryRHS = this.scale((SparseArray<Double>)auxiliaryRow, auxiliaryRHS, pivotCol);
            this.doPivot(-1, pivotCol, (SparseArray<Double>)auxiliaryRow, auxiliaryRHS);
            this.myRows[row] = auxiliaryRow;
            this.myRHS.set((long)row, auxiliaryRHS);
            for (ElementView1D elem : this.sliceConstraintsRHS().elements()) {
                if (!(elem.doubleValue() < PrimitiveMath.ZERO)) continue;
                return false;
            }
            this.update(row, pivotCol);
            return true;
        }

        @Override
        double getInfeasibility() {
            return this.myInfeasibility;
        }

        Array1D<Double> getObjectiveWeights() {
            return this.myObjectiveWeights;
        }

        DenseArray<Double> getPhase1Weights() {
            return this.myPhase1Weights;
        }

        Array1D<Double> getRHS() {
            return this.myRHS;
        }

        SparseArray<Double> getRow(int row) {
            return this.myRows[row];
        }

        SparseArray<Double> getRow(long row) {
            return this.myRows[Math.toIntExact(row)];
        }

        SparseArray<Double>[] getRows() {
            return this.myRows;
        }

        @Override
        double getValue() {
            return this.myValue;
        }

        @Override
        SimplexSolver.Primitive2D newConstraintsBody() {
            final int nbIdentitySlackVariables = this.countIdentitySlackVariables();
            final int dualIdentityBase = this.getDualIdentityBase();
            return new SimplexSolver.Primitive2D(){

                @Override
                public double doubleValue(int row, int col) {
                    return this.getRow(row).doubleValue(col);
                }

                @Override
                public int getColDim() {
                    return this.countVariables();
                }

                @Override
                public int getRowDim() {
                    return this.countConstraints();
                }

                @Override
                public void set(int row, int col, double value) {
                    this.getRow(row).set((long)col, value);
                    if (row < nbIdentitySlackVariables) {
                        if (col >= dualIdentityBase && value == 1.0) {
                            this.update(row, col);
                        }
                    } else {
                        this.getPhase1Weights().add((long)col, -value);
                    }
                }
            };
        }

        @Override
        SimplexSolver.Primitive1D newConstraintsRHS() {
            final Array1D<Double> rhs = this.getRHS();
            final int nbIdentitySlackVariables = this.countIdentitySlackVariables();
            final int dualIdentityBase = this.getDualIdentityBase();
            final boolean artificials = this.isArtificials();
            return new SimplexSolver.Primitive1D(){

                @Override
                public double doubleValue(int index) {
                    return rhs.doubleValue(index);
                }

                @Override
                public void set(int index, double value) {
                    if (artificials) {
                        this.getRow(index).set((long)(dualIdentityBase + index), PrimitiveMath.ONE);
                    }
                    rhs.set((long)index, value);
                    if (index >= nbIdentitySlackVariables) {
                        this.subtractInfeasibility(value);
                    }
                }

                @Override
                public int size() {
                    return this.countConstraints();
                }
            };
        }

        @Override
        SimplexSolver.Primitive1D newObjective() {
            final Array1D<Double> objectiveWeights = this.getObjectiveWeights();
            return new SimplexSolver.Primitive1D(){

                @Override
                public double doubleValue(int index) {
                    return objectiveWeights.doubleValue(index);
                }

                @Override
                public void set(int index, double value) {
                    objectiveWeights.set((long)index, value);
                }

                @Override
                public int size() {
                    return this.countProblemVariables();
                }
            };
        }

        @Override
        void pivot(SimplexSolver.IterationPoint iterationPoint) {
            int row = iterationPoint.row;
            int col = iterationPoint.col;
            SparseArray<Double> pivotRowBody = this.myRows[row];
            double pivotRowRHS = this.myRHS.doubleValue(row);
            pivotRowRHS = this.scale(pivotRowBody, pivotRowRHS, col);
            this.myRHS.set((long)row, pivotRowRHS);
            this.doPivot(row, col, pivotRowBody, pivotRowRHS);
            this.update(iterationPoint);
        }

        void subtractInfeasibility(double infeasibility) {
            this.myInfeasibility -= infeasibility;
        }

        @Override
        DenseTableau toDense() {
            return new DenseTransposedTableau(this);
        }
    }

    static final class MetaData
    implements UpdatableSolver.EntityMap {
        final boolean[] negatedDual;
        final int[] negativePartVariables;
        final int[] positivePartVariables;
        final EntryPair<ModelEntity<?>, Optimisation.ConstraintType>[] slack;

        MetaData(int nbConstr, int nbPos, int nbNeg, int nbSlack) {
            this.positivePartVariables = new int[nbPos];
            this.negativePartVariables = new int[nbNeg];
            this.slack = new EntryPair[nbSlack];
            this.negatedDual = new boolean[nbConstr];
        }

        @Override
        public int countSlackVariables() {
            return this.slack.length;
        }

        @Override
        public int countVariables() {
            return this.positivePartVariables.length + this.negativePartVariables.length;
        }

        @Override
        public EntryPair<ModelEntity<?>, Optimisation.ConstraintType> getSlack(int idx) {
            return this.slack[idx];
        }

        @Override
        public int indexOf(int idx) {
            if (idx < 0) {
                throw new IllegalArgumentException();
            }
            if (idx < this.positivePartVariables.length) {
                return this.positivePartVariables[idx];
            }
            int negIdx = idx - this.positivePartVariables.length;
            if (negIdx < this.negativePartVariables.length) {
                return this.negativePartVariables[negIdx];
            }
            return -1;
        }

        @Override
        public boolean isNegated(int idx) {
            if (idx < 0) {
                throw new IllegalArgumentException();
            }
            if (idx < this.positivePartVariables.length) {
                return false;
            }
            return idx - this.positivePartVariables.length < this.negativePartVariables.length;
        }
    }

    static final class DenseTransposedTableau
    extends DenseTableau {
        private final int myColDim;
        private final Primitive64Store myTransposed;

        DenseTransposedTableau(int nbConstraints, int nbPositiveProblemVariables, int nbNegativeProblemVariables, int nbSlackVariables, int nbIdentitySlackVariables, boolean needDual) {
            super(nbConstraints, nbPositiveProblemVariables, nbNegativeProblemVariables, nbSlackVariables, nbIdentitySlackVariables, needDual);
            int nbRows = this.countConstraints() + 2;
            int nbCols = this.countVariablesTotally() + 1;
            this.myTransposed = (Primitive64Store)Primitive64Store.FACTORY.make(nbCols, nbRows);
            this.myColDim = this.myTransposed.getRowDim();
        }

        DenseTransposedTableau(SimplexTableau toCopy) {
            super(toCopy.countConstraints(), toCopy.countProblemVariables(), 0, toCopy.countSlackVariables() - toCopy.countIdentitySlackVariables(), toCopy.countIdentitySlackVariables(), toCopy.isArtificials());
            this.myTransposed = Primitive64Store.FACTORY.transpose(toCopy);
            this.myColDim = this.myTransposed.getRowDim();
        }

        @Override
        public double doubleValue(int row, int col) {
            return this.myTransposed.doubleValue(col, row);
        }

        @Override
        public int getColDim() {
            return this.myColDim;
        }

        @Override
        public int getRowDim() {
            return this.myTransposed.getColDim();
        }

        @Override
        public void set(int row, int col, double value) {
            this.myTransposed.set((long)col, (long)row, value);
        }

        private void doPivot(int row, int col, double[] pivotRowData, int pivotRowIndexBase) {
            double[] data = this.myTransposed.data;
            int limit = this.myTransposed.getColDim();
            for (int i = 0; i < limit; ++i) {
                int dataIndexBase;
                double colVal;
                if (i == row || (colVal = data[(dataIndexBase = i * this.myColDim) + col]) == PrimitiveMath.ZERO) continue;
                AXPY.invoke(data, dataIndexBase, -colVal, pivotRowData, pivotRowIndexBase, 0, this.myColDim);
            }
        }

        private void scale(double[] pivotRowData, int pivotRowIndexBase, int col) {
            double pivotElement = pivotRowData[pivotRowIndexBase + col];
            if (pivotElement != PrimitiveMath.ONE) {
                CorePrimitiveOperation.divide(pivotRowData, pivotRowIndexBase, pivotRowIndexBase + this.myColDim, pivotElement);
            }
        }

        @Override
        boolean fixVariable(int index, double value) {
            int row = this.getBasisRowIndex(index);
            if (row < 0) {
                return false;
            }
            Access1D currentRow = this.myTransposed.sliceColumn(row);
            double currentRHS = ((Array1D)currentRow).doubleValue(this.myColDim - 1);
            Primitive64Array auxiliaryRow = Primitive64Array.make(this.myColDim);
            if (currentRHS > value) {
                currentRow.axpy(PrimitiveMath.NEG, auxiliaryRow);
                auxiliaryRow.set((long)index, PrimitiveMath.ZERO);
                auxiliaryRow.set((long)(this.myColDim - 1), value - currentRHS);
            } else if (currentRHS < value) {
                currentRow.axpy(PrimitiveMath.ONE, auxiliaryRow);
                auxiliaryRow.set((long)index, PrimitiveMath.ZERO);
                auxiliaryRow.set((long)(this.myColDim - 1), currentRHS - value);
            } else {
                return true;
            }
            SimplexSolver.Primitive1D objectiveRow = this.sliceTableauRow(this.countConstraints());
            int pivotCol = this.findNextPivotColumn(auxiliaryRow, objectiveRow);
            if (pivotCol < 0) {
                return false;
            }
            this.scale(auxiliaryRow.data, 0, pivotCol);
            this.doPivot(-1, pivotCol, auxiliaryRow.data, 0);
            this.myTransposed.fillColumn((long)row, auxiliaryRow);
            for (ElementView1D elem : this.sliceConstraintsRHS().elements()) {
                if (!(elem.doubleValue() < PrimitiveMath.ZERO)) continue;
                return false;
            }
            this.update(row, pivotCol);
            return true;
        }

        @Override
        double getInfeasibility() {
            return this.myTransposed.doubleValue(this.countVariablesTotally(), this.countConstraints() + 1);
        }

        Primitive64Store getTransposed() {
            return this.myTransposed;
        }

        @Override
        double getValue() {
            return this.myTransposed.doubleValue(this.countVariablesTotally(), this.countConstraints());
        }

        @Override
        SimplexSolver.Primitive2D newConstraintsBody() {
            final Primitive64Store transposed = this.getTransposed();
            final int nbConstraints = this.countConstraints();
            final int nbVariables = this.countVariables();
            final int nbIdentitySlackVariables = this.countIdentitySlackVariables();
            final int dualIdentityBase = this.getDualIdentityBase();
            return new SimplexSolver.Primitive2D(){

                @Override
                public double doubleValue(int row, int col) {
                    return transposed.doubleValue(col, row);
                }

                @Override
                public int getColDim() {
                    return nbVariables;
                }

                @Override
                public int getRowDim() {
                    return nbConstraints;
                }

                @Override
                public void set(int row, int col, double value) {
                    transposed.set((long)col, (long)row, value);
                    if (row < nbIdentitySlackVariables) {
                        if (col >= dualIdentityBase && value == 1.0) {
                            this.update(row, col);
                        }
                    } else {
                        transposed.add((long)col, (long)(nbConstraints + 1), -value);
                    }
                }
            };
        }

        @Override
        SimplexSolver.Primitive1D newConstraintsRHS() {
            final Primitive64Store transposed = this.getTransposed();
            final int nbConstraints = this.countConstraints();
            final int nbVariablesTotally = this.countVariablesTotally();
            final int nbIdentitySlackVariables = this.countIdentitySlackVariables();
            final int dualIdentityBase = this.getDualIdentityBase();
            final boolean artificials = this.isArtificials();
            return new SimplexSolver.Primitive1D(){

                @Override
                public double doubleValue(int index) {
                    return transposed.doubleValue(nbVariablesTotally, index);
                }

                @Override
                public void set(int index, double value) {
                    if (artificials) {
                        transposed.set((long)(dualIdentityBase + index), (long)index, PrimitiveMath.ONE);
                    }
                    transposed.set((long)nbVariablesTotally, (long)index, value);
                    if (index >= nbIdentitySlackVariables) {
                        transposed.add((long)nbVariablesTotally, (long)(nbConstraints + 1), -value);
                    }
                }

                @Override
                public int size() {
                    return nbConstraints;
                }
            };
        }

        @Override
        SimplexSolver.Primitive1D newObjective() {
            final Primitive64Store transposed = this.getTransposed();
            final int nbConstraints = this.countConstraints();
            return new SimplexSolver.Primitive1D(){

                @Override
                public double doubleValue(int index) {
                    return transposed.doubleValue(index, nbConstraints);
                }

                @Override
                public void set(int index, double value) {
                    transposed.set((long)index, (long)nbConstraints, value);
                }

                @Override
                public int size() {
                    return this.countProblemVariables();
                }
            };
        }

        @Override
        void pivot(SimplexSolver.IterationPoint iterationPoint) {
            int row = iterationPoint.row;
            int col = iterationPoint.col;
            double[] data = this.myTransposed.data;
            int pivotRowIndexBase = row * this.myColDim;
            this.scale(data, pivotRowIndexBase, col);
            this.doPivot(row, col, data, pivotRowIndexBase);
            this.update(iterationPoint);
        }

        @Override
        DenseTableau toDense() {
            return this;
        }
    }

    static abstract class DenseTableau
    extends SimplexTableau {
        DenseTableau(int nbConstraints, int nbPositiveProblemVariables, int nbNegativeProblemVariables, int nbSlackVariables, int nbIdentitySlackVariables, boolean needDual) {
            super(nbConstraints, nbPositiveProblemVariables, nbNegativeProblemVariables, nbSlackVariables, nbIdentitySlackVariables, needDual);
        }
    }

    static final class DenseRawTableau
    extends DenseTableau {
        private final int myColDim;
        private final double[][] myRaw;

        DenseRawTableau(int nbConstraints, int nbPositiveProblemVariables, int nbNegativeProblemVariables, int nbSlackVariables, int nbIdentitySlackVariables, boolean needDual) {
            super(nbConstraints, nbPositiveProblemVariables, nbNegativeProblemVariables, nbSlackVariables, nbIdentitySlackVariables, needDual);
            int nbCols;
            int nbRows = this.countConstraints() + 2;
            this.myColDim = nbCols = this.countVariablesTotally() + 1;
            this.myRaw = new double[nbRows][nbCols];
        }

        DenseRawTableau(SimplexTableau toCopy) {
            super(toCopy.countConstraints(), toCopy.countProblemVariables(), 0, toCopy.countSlackVariables() - toCopy.countIdentitySlackVariables(), toCopy.countIdentitySlackVariables(), toCopy.isArtificials());
            this.myColDim = toCopy.getColDim();
            this.myRaw = toCopy.toRawCopy2D();
        }

        @Override
        public double doubleValue(int row, int col) {
            return this.myRaw[row][col];
        }

        @Override
        public int getColDim() {
            return this.myColDim;
        }

        @Override
        public int getRowDim() {
            return this.myRaw.length;
        }

        @Override
        public void set(int row, int col, double value) {
            this.myRaw[row][col] = value;
        }

        private void doPivot(int row, int col, double[] pivotRow) {
            int limit = this.myRaw.length;
            for (int i = 0; i < limit; ++i) {
                double[] dataRow;
                double colVal;
                if (i == row || (colVal = (dataRow = this.myRaw[i])[col]) == PrimitiveMath.ZERO) continue;
                AXPY.invoke(dataRow, 0, -colVal, pivotRow, 0, 0, this.myColDim);
            }
        }

        private void scale(double[] pivotRow, int col) {
            double pivotElement = pivotRow[col];
            if (pivotElement != PrimitiveMath.ONE) {
                CorePrimitiveOperation.divide(pivotRow, 0, this.myColDim, pivotElement);
            }
        }

        @Override
        boolean fixVariable(int index, double value) {
            int row = this.getBasisRowIndex(index);
            if (row < 0) {
                return false;
            }
            Primitive64Array currentRow = Primitive64Array.wrap(this.myRaw[row]);
            double currentRHS = currentRow.doubleValue((long)(this.myColDim - 1));
            Primitive64Array auxiliaryRow = Primitive64Array.make(this.myColDim);
            if (currentRHS > value) {
                currentRow.axpy(PrimitiveMath.NEG, auxiliaryRow);
                auxiliaryRow.set((long)index, PrimitiveMath.ZERO);
                auxiliaryRow.set((long)(this.myColDim - 1), value - currentRHS);
            } else if (currentRHS < value) {
                currentRow.axpy(PrimitiveMath.ONE, auxiliaryRow);
                auxiliaryRow.set((long)index, PrimitiveMath.ZERO);
                auxiliaryRow.set((long)(this.myColDim - 1), currentRHS - value);
            } else {
                return true;
            }
            SimplexSolver.Primitive1D objectiveRow = this.sliceTableauRow(this.countConstraints());
            int pivotCol = this.findNextPivotColumn(auxiliaryRow, objectiveRow);
            if (pivotCol < 0) {
                return false;
            }
            this.scale(auxiliaryRow.data, pivotCol);
            this.doPivot(-1, pivotCol, auxiliaryRow.data);
            this.myRaw[row] = auxiliaryRow.data;
            for (ElementView1D elem : this.sliceConstraintsRHS().elements()) {
                if (!(elem.doubleValue() < PrimitiveMath.ZERO)) continue;
                return false;
            }
            this.update(row, pivotCol);
            return true;
        }

        @Override
        double getInfeasibility() {
            return this.myRaw[this.countConstraints() + 1][this.countVariablesTotally()];
        }

        @Override
        double getValue() {
            return this.myRaw[this.countConstraints()][this.countVariablesTotally()];
        }

        @Override
        SimplexSolver.Primitive2D newConstraintsBody() {
            final double[][] store = this.myRaw;
            final int nbConstraints = this.countConstraints();
            final int nbVariables = this.countVariables();
            final int nbIdentitySlackVariables = this.countIdentitySlackVariables();
            final int dualIdentityBase = this.getDualIdentityBase();
            return new SimplexSolver.Primitive2D(){

                @Override
                public double doubleValue(int row, int col) {
                    return store[row][col];
                }

                @Override
                public int getColDim() {
                    return nbVariables;
                }

                @Override
                public int getRowDim() {
                    return nbConstraints;
                }

                @Override
                public void set(int row, int col, double value) {
                    store[row][col] = value;
                    if (row < nbIdentitySlackVariables) {
                        if (col >= dualIdentityBase && value == 1.0) {
                            this.update(row, col);
                        }
                    } else {
                        double[] dArray = store[nbConstraints + 1];
                        int n = col;
                        dArray[n] = dArray[n] - value;
                    }
                }
            };
        }

        @Override
        SimplexSolver.Primitive1D newConstraintsRHS() {
            final double[][] store = this.myRaw;
            final int nbConstraints = this.countConstraints();
            final int nbVariablesTotally = this.countVariablesTotally();
            final int nbIdentitySlackVariables = this.countIdentitySlackVariables();
            final int dualIdentityBase = this.getDualIdentityBase();
            final boolean artificials = this.isArtificials();
            return new SimplexSolver.Primitive1D(){

                @Override
                public double doubleValue(int index) {
                    return store[index][nbVariablesTotally];
                }

                @Override
                public void set(int index, double value) {
                    if (artificials) {
                        store[index][dualIdentityBase + index] = PrimitiveMath.ONE;
                    }
                    store[index][nbVariablesTotally] = value;
                    if (index >= nbIdentitySlackVariables) {
                        double[] dArray = store[nbConstraints + 1];
                        int n = nbVariablesTotally;
                        dArray[n] = dArray[n] - value;
                    }
                }

                @Override
                public int size() {
                    return nbConstraints;
                }
            };
        }

        @Override
        SimplexSolver.Primitive1D newObjective() {
            final double[][] store = this.myRaw;
            final int nbConstraints = this.countConstraints();
            return new SimplexSolver.Primitive1D(){

                @Override
                public double doubleValue(int index) {
                    return store[nbConstraints][index];
                }

                @Override
                public void set(int index, double value) {
                    store[nbConstraints][index] = value;
                }

                @Override
                public int size() {
                    return this.countProblemVariables();
                }
            };
        }

        @Override
        void pivot(SimplexSolver.IterationPoint iterationPoint) {
            int row = iterationPoint.row;
            int col = iterationPoint.col;
            double[] pivotRow = this.myRaw[row];
            this.scale(pivotRow, col);
            this.doPivot(row, col, pivotRow);
            this.update(row, col);
        }

        @Override
        DenseTableau toDense() {
            return this;
        }
    }
}

