/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.ojalgo.array.SparseArray;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.ColumnView;
import org.ojalgo.structure.ElementView1D;

public final class ColumnsSupplier<N extends Comparable<N>>
implements Access2D<N>,
ElementsSupplier<N>,
Supplier<PhysicalStore<N>> {
    private final List<SparseArray<N>> myColumns = new ArrayList<SparseArray<N>>();
    private final PhysicalStore.Factory<N, ?> myFactory;
    private final int myRowsCount;

    ColumnsSupplier(PhysicalStore.Factory<N, ?> factory, int numberOfRows) {
        this.myRowsCount = numberOfRows;
        this.myFactory = factory;
    }

    public SparseArray<N> addColumn() {
        return this.addColumn((SparseArray<N>)((SparseArray.SparseFactory)SparseArray.factory(this.myFactory.array()).limit(this.myRowsCount)).make());
    }

    public void addColumns(int numberToAdd) {
        SparseArray.SparseFactory factory = (SparseArray.SparseFactory)SparseArray.factory(this.myFactory.array()).limit(this.myRowsCount);
        for (int j = 0; j < numberToAdd; ++j) {
            this.myColumns.add((SparseArray<N>)factory.make());
        }
    }

    @Override
    public ColumnView<N> columns() {
        return new ItemView(this);
    }

    @Override
    public long countColumns() {
        return this.myColumns.size();
    }

    @Override
    public long countRows() {
        return this.myRowsCount;
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myColumns.get((int)col).doubleValue(row);
    }

    @Override
    public PhysicalStore<N> get() {
        return (PhysicalStore)this.collect(this.myFactory);
    }

    @Override
    public N get(long row, long col) {
        return this.myColumns.get((int)col).get(row);
    }

    public SparseArray<N> getColumn(int index) {
        return this.myColumns.get(index);
    }

    public Access1D<N> removeColumn(int index) {
        return this.myColumns.remove(index);
    }

    public ColumnsSupplier<N> selectColumns(int[] indices) {
        ColumnsSupplier<N> retVal = new ColumnsSupplier<N>(this.myFactory, this.myRowsCount);
        for (int i = 0; i < indices.length; ++i) {
            retVal.addColumn(this.getColumn(indices[i]));
        }
        return retVal;
    }

    @Override
    public void supplyTo(TransformableRegion<N> receiver) {
        receiver.reset();
        int limit = this.myColumns.size();
        for (int j = 0; j < limit; ++j) {
            this.myColumns.get(j).supplyNonZerosTo(receiver.regionByColumns(j));
        }
    }

    public String toString() {
        return Access2D.toString(this);
    }

    SparseArray<N> addColumn(SparseArray<N> columnToAdd) {
        if (this.myColumns.add(columnToAdd)) {
            return columnToAdd;
        }
        return null;
    }

    static final class ItemView<N extends Comparable<N>>
    extends ColumnView<N> {
        private final ColumnsSupplier<N> mySupplier;

        ItemView(ColumnsSupplier<N> access) {
            super(access);
            this.mySupplier = access;
        }

        @Override
        public ElementView1D<N, ?> elements() {
            return this.getCurrent().elements();
        }

        @Override
        public ElementView1D<N, ?> nonzeros() {
            return this.getCurrent().nonzeros();
        }

        private SparseArray<N> getCurrent() {
            return this.mySupplier.getColumn(Math.toIntExact(this.column()));
        }
    }
}

