/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function;

import java.util.function.BiFunction;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.BasicFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.type.NumberDefinition;

public interface ParameterFunction<N extends Comparable<N>>
extends BasicFunction,
BiFunction<N, Integer, N> {
    default public ParameterFunction<N> andThen(final UnaryFunction<N> after) {
        ProgrammingError.throwIfNull(after);
        return new ParameterFunction<N>(){

            @Override
            public double invoke(double arg, int param) {
                return after.invoke(ParameterFunction.this.invoke(arg, param));
            }

            @Override
            public float invoke(float arg, int param) {
                return after.invoke(ParameterFunction.this.invoke(arg, param));
            }

            @Override
            public N invoke(N arg, int param) {
                return after.invoke(ParameterFunction.this.invoke(arg, param));
            }
        };
    }

    @Override
    default public N apply(N arg, Integer param) {
        return this.invoke(arg, (int)param);
    }

    default public ParameterFunction<N> compose(final UnaryFunction<N> before) {
        ProgrammingError.throwIfNull(before);
        return new ParameterFunction<N>(){

            @Override
            public double invoke(double arg, int param) {
                return ParameterFunction.this.invoke(before.invoke(arg), param);
            }

            @Override
            public float invoke(float arg, int param) {
                return ParameterFunction.this.invoke(before.invoke(arg), param);
            }

            @Override
            public N invoke(N arg, int param) {
                return ParameterFunction.this.invoke(before.invoke(arg), param);
            }
        };
    }

    default public byte invoke(byte arg, int param) {
        return (byte)this.invoke((double)arg, param);
    }

    public double invoke(double var1, int var3);

    default public float invoke(float arg, int param) {
        return (float)this.invoke((double)arg, param);
    }

    default public int invoke(int arg, int param) {
        return NumberDefinition.toInt(this.invoke((double)arg, param));
    }

    default public long invoke(long arg, int param) {
        return NumberDefinition.toLong(this.invoke((double)arg, param));
    }

    public N invoke(N var1, int var2);

    default public short invoke(short arg, int param) {
        return (short)this.invoke((double)arg, param);
    }

    default public UnaryFunction<N> parameter(int param) {
        return new FixedParameter(this, param);
    }

    public static final class FixedParameter<N extends Comparable<N>>
    implements UnaryFunction<N> {
        private final ParameterFunction<N> myFunction;
        private final int myParameter;

        private FixedParameter() {
            this(null, 0);
        }

        FixedParameter(ParameterFunction<N> function, int param) {
            this.myFunction = function;
            this.myParameter = param;
        }

        public ParameterFunction<N> getFunction() {
            return this.myFunction;
        }

        public int getParameter() {
            return this.myParameter;
        }

        @Override
        public double invoke(double arg) {
            return this.myFunction.invoke(arg, this.myParameter);
        }

        @Override
        public float invoke(float arg) {
            return this.myFunction.invoke(arg, this.myParameter);
        }

        @Override
        public N invoke(N arg) {
            return this.myFunction.invoke(arg, this.myParameter);
        }
    }
}

