/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.ojalgo.data.domain.finance.portfolio.FinancePortfolio;
import org.ojalgo.data.domain.finance.portfolio.MarketEquilibrium;
import org.ojalgo.data.domain.finance.portfolio.SimpleAsset;
import org.ojalgo.data.domain.finance.portfolio.simulator.PortfolioSimulator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.Primitive64Matrix;
import org.ojalgo.random.process.GeometricBrownianMotion;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access2D;

public final class SimplePortfolio
extends FinancePortfolio
implements FinancePortfolio.Context {
    private transient Primitive64Matrix myAssetReturns = null;
    private transient Primitive64Matrix myAssetVolatilities = null;
    private transient Primitive64Matrix myAssetWeights = null;
    private final List<SimpleAsset> myComponents;
    private final Primitive64Matrix myCorrelations;
    private transient Primitive64Matrix myCovariances = null;
    private transient Comparable<?> myMeanReturn;
    private transient Comparable<?> myReturnVariance;
    private transient List<BigDecimal> myWeights;

    static List<SimpleAsset> toSimpleAssets(double[] someWeights) {
        ArrayList<SimpleAsset> retVal = new ArrayList<SimpleAsset>(someWeights.length);
        for (int i = 0; i < someWeights.length; ++i) {
            retVal.add(new SimpleAsset(Double.valueOf(someWeights[i])));
        }
        return retVal;
    }

    static List<SimpleAsset> toSimpleAssets(Comparable<?>[] someWeights) {
        ArrayList<SimpleAsset> retVal = new ArrayList<SimpleAsset>(someWeights.length);
        for (int i = 0; i < someWeights.length; ++i) {
            retVal.add(new SimpleAsset(someWeights[i]));
        }
        return retVal;
    }

    public SimplePortfolio(Access2D<?> correlationsMatrix, List<SimpleAsset> someAssets) {
        if ((long)someAssets.size() != correlationsMatrix.countRows() || (long)someAssets.size() != correlationsMatrix.countColumns()) {
            throw new IllegalArgumentException("Input dimensions don't match!");
        }
        this.myCorrelations = (Primitive64Matrix)MATRIX_FACTORY.copy((Access2D)correlationsMatrix);
        this.myComponents = someAssets;
    }

    public SimplePortfolio(FinancePortfolio.Context portfolioContext, FinancePortfolio weightsPortfolio) {
        this.myCorrelations = portfolioContext.getCorrelations();
        Primitive64Matrix tmpCovariances = portfolioContext.getCovariances();
        Primitive64Matrix tmpAssetReturns = portfolioContext.getAssetReturns();
        List<BigDecimal> tmpWeights = weightsPortfolio.getWeights();
        if ((long)tmpWeights.size() != this.myCorrelations.countRows() || (long)tmpWeights.size() != this.myCorrelations.countColumns()) {
            throw new IllegalArgumentException("Input dimensions don't match!");
        }
        this.myComponents = new ArrayList<SimpleAsset>(tmpWeights.size());
        for (int i = 0; i < tmpWeights.size(); ++i) {
            double tmpMeanReturn = tmpAssetReturns.doubleValue(i, 0L);
            double tmpVolatilty = PrimitiveMath.SQRT.invoke(tmpCovariances.doubleValue(i, i));
            BigDecimal tmpWeight = tmpWeights.get(i);
            this.myComponents.add(new SimpleAsset(Double.valueOf(tmpMeanReturn), Double.valueOf(tmpVolatilty), tmpWeight));
        }
    }

    public SimplePortfolio(double[] someWeights) {
        this(SimplePortfolio.toSimpleAssets(someWeights));
    }

    public SimplePortfolio(List<SimpleAsset> someAssets) {
        this((Access2D<?>)MATRIX_FACTORY.makeEye(someAssets.size(), someAssets.size()), someAssets);
    }

    public SimplePortfolio(Comparable<?> ... someWeights) {
        this(SimplePortfolio.toSimpleAssets(someWeights));
    }

    @Override
    public double calculatePortfolioReturn(FinancePortfolio weightsPortfolio) {
        List<BigDecimal> tmpWeights = weightsPortfolio.getWeights();
        Primitive64Matrix tmpAssetWeights = (Primitive64Matrix)MATRIX_FACTORY.columns(new List[]{tmpWeights});
        Primitive64Matrix tmpAssetReturns = this.getAssetReturns();
        return MarketEquilibrium.calculatePortfolioReturn(tmpAssetWeights, tmpAssetReturns).doubleValue();
    }

    @Override
    public double calculatePortfolioVariance(FinancePortfolio weightsPortfolio) {
        List<BigDecimal> tmpWeights = weightsPortfolio.getWeights();
        Primitive64Matrix tmpAssetWeights = (Primitive64Matrix)MATRIX_FACTORY.columns(new List[]{tmpWeights});
        return new MarketEquilibrium(this.getCovariances()).calculatePortfolioVariance(tmpAssetWeights).doubleValue();
    }

    @Override
    public Primitive64Matrix getAssetReturns() {
        if (this.myAssetReturns == null) {
            int tmpSize = this.myComponents.size();
            Primitive64Matrix.DenseReceiver tmpReturns = (Primitive64Matrix.DenseReceiver)MATRIX_FACTORY.makeDense(tmpSize, 1L);
            for (int i = 0; i < tmpSize; ++i) {
                tmpReturns.set((long)i, 0L, this.getMeanReturn(i));
            }
            this.myAssetReturns = (Primitive64Matrix)tmpReturns.get();
        }
        return this.myAssetReturns;
    }

    @Override
    public Primitive64Matrix getAssetVolatilities() {
        if (this.myAssetVolatilities == null) {
            int tmpSize = this.myComponents.size();
            Primitive64Matrix.DenseReceiver tmpVolatilities = (Primitive64Matrix.DenseReceiver)MATRIX_FACTORY.makeDense(tmpSize, 1L);
            for (int i = 0; i < tmpSize; ++i) {
                tmpVolatilities.set((long)i, 0L, this.getVolatility(i));
            }
            this.myAssetVolatilities = (Primitive64Matrix)tmpVolatilities.get();
        }
        return this.myAssetVolatilities;
    }

    public double getCorrelation(int row, int col) {
        return this.myCorrelations.doubleValue(row, col);
    }

    @Override
    public Primitive64Matrix getCorrelations() {
        return this.myCorrelations;
    }

    public double getCovariance(int row, int col) {
        Primitive64Matrix tmpCovariances = this.myCovariances;
        if (tmpCovariances != null) {
            return tmpCovariances.doubleValue(row, col);
        }
        double tmpRowRisk = this.getVolatility(row);
        double tmpColRisk = this.getVolatility(col);
        double tmpCorrelation = this.getCorrelation(row, col);
        return tmpRowRisk * tmpCorrelation * tmpColRisk;
    }

    @Override
    public Primitive64Matrix getCovariances() {
        if (this.myCovariances == null) {
            int tmpSize = this.myComponents.size();
            Primitive64Matrix.DenseReceiver tmpCovaris = (Primitive64Matrix.DenseReceiver)MATRIX_FACTORY.makeDense(tmpSize, tmpSize);
            for (int j = 0; j < tmpSize; ++j) {
                for (int i = 0; i < tmpSize; ++i) {
                    tmpCovaris.set((long)i, (long)j, this.getCovariance(i, j));
                }
            }
            this.myCovariances = (Primitive64Matrix)tmpCovaris.get();
        }
        return this.myCovariances;
    }

    @Override
    public double getMeanReturn() {
        if (this.myMeanReturn == null) {
            Primitive64Matrix tmpWeightsVector = this.getAssetWeights();
            Primitive64Matrix tmpReturnsVector = this.getAssetReturns();
            this.myMeanReturn = (Comparable)MarketEquilibrium.calculatePortfolioReturn(tmpWeightsVector, tmpReturnsVector).get();
        }
        return Scalar.doubleValue(this.myMeanReturn);
    }

    public double getMeanReturn(int index) {
        return this.myComponents.get(index).getMeanReturn();
    }

    @Override
    public double getReturnVariance() {
        if (this.myReturnVariance == null) {
            MarketEquilibrium tmpMarketEquilibrium = new MarketEquilibrium(this.getCovariances());
            Primitive64Matrix tmpWeightsVector = this.getAssetWeights();
            this.myReturnVariance = (Comparable)tmpMarketEquilibrium.calculatePortfolioVariance(tmpWeightsVector).get();
        }
        return Scalar.doubleValue(this.myReturnVariance);
    }

    public double getReturnVariance(int index) {
        return this.myComponents.get(index).getReturnVariance();
    }

    public PortfolioSimulator getSimulator() {
        ArrayList<GeometricBrownianMotion> tmpAssetProcesses = new ArrayList<GeometricBrownianMotion>(this.myComponents.size());
        for (SimpleAsset tmpAsset : this.myComponents) {
            GeometricBrownianMotion tmpForecast = tmpAsset.forecast();
            tmpForecast.setValue(tmpAsset.getWeight().doubleValue());
            tmpAssetProcesses.add(tmpForecast);
        }
        return new PortfolioSimulator(this.myCorrelations, tmpAssetProcesses);
    }

    public double getVolatility(int index) {
        return this.myComponents.get(index).getVolatility();
    }

    public BigDecimal getWeight(int index) {
        return this.myComponents.get(index).getWeight();
    }

    @Override
    public List<BigDecimal> getWeights() {
        if (this.myWeights == null) {
            this.myWeights = new ArrayList<BigDecimal>(this.myComponents.size());
            for (SimpleAsset tmpAsset : this.myComponents) {
                this.myWeights.add(tmpAsset.getWeight());
            }
        }
        return this.myWeights;
    }

    @Override
    public int size() {
        return this.myComponents.size();
    }

    @Override
    protected void reset() {
        this.myMeanReturn = null;
        this.myReturnVariance = null;
        this.myWeights = null;
        this.myCovariances = null;
        this.myAssetReturns = null;
        this.myAssetVolatilities = null;
        this.myAssetWeights = null;
        for (SimpleAsset tmpAsset : this.myComponents) {
            tmpAsset.reset();
        }
    }

    Primitive64Matrix getAssetWeights() {
        if (this.myAssetWeights == null) {
            int tmpSize = this.myComponents.size();
            Primitive64Matrix.DenseReceiver tmpWeights = (Primitive64Matrix.DenseReceiver)MATRIX_FACTORY.makeDense(tmpSize, 1L);
            for (int i = 0; i < tmpSize; ++i) {
                tmpWeights.set((long)i, 0L, (Comparable)this.getWeight(i));
            }
            this.myAssetWeights = (Primitive64Matrix)tmpWeights.get();
        }
        return this.myAssetWeights;
    }
}

