/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.session;

import java.util.List;
import org.elasticsearch.xpack.ql.type.Schema;
import org.elasticsearch.xpack.sql.session.AbstractRowSet;
import org.elasticsearch.xpack.sql.session.SchemaRowSet;

public class ListRowSet
extends AbstractRowSet
implements SchemaRowSet {
    private final Schema schema;
    private final List<List<?>> list;
    private final int columnCount;
    private int pos = 0;

    ListRowSet(Schema schema, List<List<?>> list) {
        this(schema, list, schema.size());
    }

    ListRowSet(Schema schema, List<List<?>> list, int columnCount) {
        this.schema = schema;
        this.columnCount = columnCount;
        this.list = list;
    }

    @Override
    protected boolean doHasCurrent() {
        return this.pos < this.size();
    }

    @Override
    protected boolean doNext() {
        if (this.pos + 1 < this.size()) {
            ++this.pos;
            return true;
        }
        return false;
    }

    @Override
    protected Object getColumn(int index) {
        return this.list.get(this.pos).get(index);
    }

    @Override
    protected void doReset() {
        this.pos = 0;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Schema schema() {
        return this.schema;
    }

    @Override
    public int columnCount() {
        return this.columnCount;
    }
}

