/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.session.AbstractRowSet;
import org.elasticsearch.xpack.sql.util.Check;

abstract class ResultRowSet<E extends NamedWriteable>
extends AbstractRowSet {
    private final List<E> extractors;
    private final BitSet mask;

    ResultRowSet(List<E> extractors, BitSet mask) {
        this.extractors = extractors;
        this.mask = mask;
        Check.isTrue(mask.length() <= extractors.size(), "Invalid number of extracted columns specified");
    }

    @Override
    public final int columnCount() {
        return this.mask.cardinality();
    }

    @Override
    protected Object getColumn(int column) {
        return this.extractValue(this.userExtractor(column));
    }

    List<E> extractors() {
        return this.extractors;
    }

    BitSet mask() {
        return this.mask;
    }

    E userExtractor(int column) {
        int i = -1;
        i = this.mask.nextSetBit(0);
        while (i >= 0) {
            if (column-- == 0) {
                return (E)((NamedWriteable)this.extractors.get(i));
            }
            i = this.mask.nextSetBit(i + 1);
        }
        throw new SqlIllegalArgumentException("Cannot find column [{}]", column);
    }

    Object resultColumn(int column) {
        return this.extractValue((NamedWriteable)this.extractors().get(column));
    }

    int resultColumnCount() {
        return this.extractors.size();
    }

    void forEachResultColumn(Consumer<? super Object> action) {
        Objects.requireNonNull(action);
        int rowSize = this.resultColumnCount();
        for (int i = 0; i < rowSize; ++i) {
            action.accept(this.resultColumn(i));
        }
    }

    protected abstract Object extractValue(E var1);
}

