/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.utils;

import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public final class SimpleBoundedInputStream
extends InputStream {
    private final InputStream in;
    private final long maxBytes;
    private long numBytes;

    public SimpleBoundedInputStream(InputStream inputStream, long maxBytes) {
        this.in = ExceptionsHelper.requireNonNull(inputStream, "inputStream");
        if (maxBytes < 0L) {
            throw new IllegalArgumentException("[maxBytes] must be greater than or equal to 0");
        }
        this.maxBytes = maxBytes;
    }

    @Override
    public int read() throws IOException {
        if (this.numBytes >= this.maxBytes) {
            throw new StreamSizeExceededException("input stream exceeded maximum bytes of [" + this.maxBytes + "]", this.maxBytes);
        }
        ++this.numBytes;
        return this.in.read();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public static class StreamSizeExceededException
    extends IOException {
        private final long maxBytes;

        public StreamSizeExceededException(String message, long maxBytes) {
            super(message);
            this.maxBytes = maxBytes;
        }

        public long getMaxBytes() {
            return this.maxBytes;
        }
    }
}

