/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.table;

import java.util.ArrayList;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.aggregation.table.RowInTableLookup;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.ReleasableIterator;

final class BlockHashRowInTableLookup
extends RowInTableLookup {
    private final BlockHash hash;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BlockHashRowInTableLookup(BlockFactory blockFactory, Block[] keys) {
        ArrayList<BlockHash.GroupSpec> groups = new ArrayList<BlockHash.GroupSpec>(keys.length);
        for (int k = 0; k < keys.length; ++k) {
            groups.add(new BlockHash.GroupSpec(k, keys[k].elementType()));
        }
        this.hash = BlockHash.buildPackedValuesBlockHash(groups, blockFactory, (int)BlockFactory.DEFAULT_MAX_BLOCK_PRIMITIVE_ARRAY_SIZE.getBytes());
        boolean success = false;
        try {
            this.hash.add(new Page(keys), new GroupingAggregatorFunction.AddInput(this){
                private int lastOrd = -1;

                @Override
                public void add(int positionOffset, IntBlock groupIds) {
                    for (int p = 0; p < groupIds.getPositionCount(); ++p) {
                        int first = groupIds.getFirstValueIndex(p);
                        int end = groupIds.getValueCount(p) + first;
                        for (int i = first; i < end; ++i) {
                            int ord = groupIds.getInt(i);
                            if (ord != this.lastOrd + 1) {
                                throw new IllegalArgumentException("found a duplicate row");
                            }
                            this.lastOrd = ord;
                        }
                    }
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    for (int p = 0; p < groupIds.getPositionCount(); ++p) {
                        int ord = groupIds.getInt(p);
                        if (ord != this.lastOrd + 1) {
                            throw new IllegalArgumentException("found a duplicate row");
                        }
                        this.lastOrd = ord;
                    }
                }

                public void close() {
                }
            });
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    @Override
    public ReleasableIterator<IntBlock> lookup(Page page, ByteSizeValue targetBlockSize) {
        return this.hash.lookup(page, targetBlockSize);
    }

    @Override
    public String toString() {
        return this.hash.toString();
    }

    public void close() {
        this.hash.close();
    }
}

