/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es818;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.elasticsearch.index.codec.vectors.BQVectorUtils;
import org.elasticsearch.index.codec.vectors.es818.BinarizedByteVectorValues;
import org.elasticsearch.index.codec.vectors.es818.OptimizedScalarQuantizer;

abstract class OffHeapBinarizedVectorValues
extends BinarizedByteVectorValues {
    final int dimension;
    final int size;
    final int numBytes;
    final VectorSimilarityFunction similarityFunction;
    final FlatVectorsScorer vectorsScorer;
    final IndexInput slice;
    final byte[] binaryValue;
    final ByteBuffer byteBuffer;
    final int byteSize;
    private int lastOrd = -1;
    final float[] correctiveValues;
    int quantizedComponentSum;
    final OptimizedScalarQuantizer binaryQuantizer;
    final float[] centroid;
    final float centroidDp;
    private final int discretizedDimensions;

    OffHeapBinarizedVectorValues(int dimension, int size, float[] centroid, float centroidDp, OptimizedScalarQuantizer quantizer, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) {
        this.dimension = dimension;
        this.size = size;
        this.similarityFunction = similarityFunction;
        this.vectorsScorer = vectorsScorer;
        this.slice = slice;
        this.centroid = centroid;
        this.centroidDp = centroidDp;
        this.numBytes = BQVectorUtils.discretize(dimension, 64) / 8;
        this.correctiveValues = new float[3];
        this.byteSize = this.numBytes + 12 + 2;
        this.byteBuffer = ByteBuffer.allocate(this.numBytes);
        this.binaryValue = this.byteBuffer.array();
        this.binaryQuantizer = quantizer;
        this.discretizedDimensions = BQVectorUtils.discretize(dimension, 64);
    }

    public int dimension() {
        return this.dimension;
    }

    public int size() {
        return this.size;
    }

    public byte[] vectorValue(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.binaryValue;
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.numBytes);
        this.slice.readFloats(this.correctiveValues, 0, 3);
        this.quantizedComponentSum = Short.toUnsignedInt(this.slice.readShort());
        this.lastOrd = targetOrd;
        return this.binaryValue;
    }

    @Override
    public int discretizedDimensions() {
        return this.discretizedDimensions;
    }

    @Override
    public float getCentroidDP() {
        return this.centroidDp;
    }

    @Override
    public OptimizedScalarQuantizer.QuantizationResult getCorrectiveTerms(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return new OptimizedScalarQuantizer.QuantizationResult(this.correctiveValues[0], this.correctiveValues[1], this.correctiveValues[2], this.quantizedComponentSum);
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize + (long)this.numBytes);
        this.slice.readFloats(this.correctiveValues, 0, 3);
        this.quantizedComponentSum = Short.toUnsignedInt(this.slice.readShort());
        return new OptimizedScalarQuantizer.QuantizationResult(this.correctiveValues[0], this.correctiveValues[1], this.correctiveValues[2], this.quantizedComponentSum);
    }

    @Override
    public OptimizedScalarQuantizer getQuantizer() {
        return this.binaryQuantizer;
    }

    @Override
    public float[] getCentroid() {
        return this.centroid;
    }

    public int getVectorByteLength() {
        return this.numBytes;
    }

    static OffHeapBinarizedVectorValues load(OrdToDocDISIReaderConfiguration configuration, int dimension, int size, OptimizedScalarQuantizer binaryQuantizer, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, float[] centroid, float centroidDp, long quantizedVectorDataOffset, long quantizedVectorDataLength, IndexInput vectorData) throws IOException {
        if (configuration.isEmpty()) {
            return new EmptyOffHeapVectorValues(dimension, similarityFunction, vectorsScorer);
        }
        assert (centroid != null);
        IndexInput bytesSlice = vectorData.slice("quantized-vector-data", quantizedVectorDataOffset, quantizedVectorDataLength);
        if (configuration.isDense()) {
            return new DenseOffHeapVectorValues(dimension, size, centroid, centroidDp, binaryQuantizer, similarityFunction, vectorsScorer, bytesSlice);
        }
        return new SparseOffHeapVectorValues(configuration, dimension, size, centroid, centroidDp, binaryQuantizer, vectorData, similarityFunction, vectorsScorer, bytesSlice);
    }

    private static class EmptyOffHeapVectorValues
    extends OffHeapBinarizedVectorValues {
        EmptyOffHeapVectorValues(int dimension, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer) {
            super(dimension, 0, null, Float.NaN, null, similarityFunction, vectorsScorer, null);
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        @Override
        public DenseOffHeapVectorValues copy() {
            throw new UnsupportedOperationException();
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return null;
        }

        @Override
        public VectorScorer scorer(float[] target) {
            return null;
        }
    }

    static class DenseOffHeapVectorValues
    extends OffHeapBinarizedVectorValues {
        DenseOffHeapVectorValues(int dimension, int size, float[] centroid, float centroidDp, OptimizedScalarQuantizer binaryQuantizer, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) {
            super(dimension, size, centroid, centroidDp, binaryQuantizer, similarityFunction, vectorsScorer, slice);
        }

        @Override
        public DenseOffHeapVectorValues copy() throws IOException {
            return new DenseOffHeapVectorValues(this.dimension, this.size, this.centroid, this.centroidDp, this.binaryQuantizer, this.similarityFunction, this.vectorsScorer, this.slice.clone());
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return acceptDocs;
        }

        @Override
        public VectorScorer scorer(float[] target) throws IOException {
            DenseOffHeapVectorValues copy = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            final RandomVectorScorer scorer = this.vectorsScorer.getRandomVectorScorer(this.similarityFunction, (KnnVectorValues)copy, target);
            return new VectorScorer(){

                public float score() throws IOException {
                    return scorer.score(iterator.index());
                }

                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapBinarizedVectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final OrdToDocDISIReaderConfiguration configuration;

        SparseOffHeapVectorValues(OrdToDocDISIReaderConfiguration configuration, int dimension, int size, float[] centroid, float centroidDp, OptimizedScalarQuantizer binaryQuantizer, IndexInput dataIn, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) throws IOException {
            super(dimension, size, centroid, centroidDp, binaryQuantizer, similarityFunction, vectorsScorer, slice);
            this.configuration = configuration;
            this.dataIn = dataIn;
            this.ordToDoc = configuration.getDirectMonotonicReader(dataIn);
            this.disi = configuration.getIndexedDISI(dataIn);
        }

        @Override
        public SparseOffHeapVectorValues copy() throws IOException {
            return new SparseOffHeapVectorValues(this.configuration, this.dimension, this.size, this.centroid, this.centroidDp, this.binaryQuantizer, this.dataIn, this.similarityFunction, this.vectorsScorer, this.slice.clone());
        }

        public int ordToDoc(int ord) {
            return (int)this.ordToDoc.get((long)ord);
        }

        public Bits getAcceptOrds(final Bits acceptDocs) {
            if (acceptDocs == null) {
                return null;
            }
            return new Bits(){

                public boolean get(int index) {
                    return acceptDocs.get(this.ordToDoc(index));
                }

                public int length() {
                    return size;
                }
            };
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return IndexedDISI.asDocIndexIterator((IndexedDISI)this.disi);
        }

        @Override
        public VectorScorer scorer(float[] target) throws IOException {
            SparseOffHeapVectorValues copy = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            final RandomVectorScorer scorer = this.vectorsScorer.getRandomVectorScorer(this.similarityFunction, (KnnVectorValues)copy, target);
            return new VectorScorer(){

                public float score() throws IOException {
                    return scorer.score(iterator.index());
                }

                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }
    }
}

