/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.io.IOException;
import java.util.Optional;
import org.apache.lucene.codecs.hnsw.DefaultFlatVectorScorer;
import org.apache.lucene.codecs.hnsw.FlatFieldVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.codecs.hnsw.ScalarQuantizedVectorScorer;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsWriter;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.hnsw.CloseableRandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.quantization.QuantizedByteVectorValues;
import org.apache.lucene.util.quantization.QuantizedVectorsReader;
import org.apache.lucene.util.quantization.ScalarQuantizer;
import org.elasticsearch.simdvec.VectorScorerFactory;
import org.elasticsearch.simdvec.VectorSimilarityType;

public class ES814ScalarQuantizedVectorsFormat
extends FlatVectorsFormat {
    static final String NAME = "ES814ScalarQuantizedVectorsFormat";
    private static final int ALLOWED_BITS = 400;
    private static final FlatVectorsFormat rawVectorFormat = new Lucene99FlatVectorsFormat((FlatVectorsScorer)DefaultFlatVectorScorer.INSTANCE);
    static final FlatVectorsScorer flatVectorScorer = new ESFlatVectorsScorer((FlatVectorsScorer)new ScalarQuantizedVectorScorer((FlatVectorsScorer)DefaultFlatVectorScorer.INSTANCE));
    private static final float MINIMUM_CONFIDENCE_INTERVAL = 0.9f;
    private static final float MAXIMUM_CONFIDENCE_INTERVAL = 1.0f;
    public final Float confidenceInterval;
    private final byte bits;
    private final boolean compress;

    public ES814ScalarQuantizedVectorsFormat(Float confidenceInterval, int bits, boolean compress) {
        super(NAME);
        if (confidenceInterval != null && confidenceInterval.floatValue() != 0.0f && (confidenceInterval.floatValue() < 0.9f || confidenceInterval.floatValue() > 1.0f)) {
            throw new IllegalArgumentException("confidenceInterval must be between 0.9 and 1.0; confidenceInterval=" + confidenceInterval);
        }
        if (bits < 1 || bits > 8 || (0x190 & 1 << bits) == 0) {
            throw new IllegalArgumentException("bits must be one of: 4, 7, 8; bits=" + bits);
        }
        this.confidenceInterval = confidenceInterval;
        this.bits = (byte)bits;
        this.compress = compress;
    }

    public String toString() {
        return "ES814ScalarQuantizedVectorsFormat(name=ES814ScalarQuantizedVectorsFormat, confidenceInterval=" + this.confidenceInterval + ", bits=" + this.bits + ", compressed=" + this.compress + ", flatVectorScorer=" + String.valueOf(flatVectorScorer) + ", rawVectorFormat=" + String.valueOf(rawVectorFormat) + ")";
    }

    public FlatVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new ES814ScalarQuantizedVectorsWriter(new Lucene99ScalarQuantizedVectorsWriter(state, this.confidenceInterval, this.bits, this.compress, rawVectorFormat.fieldsWriter(state), flatVectorScorer));
    }

    public FlatVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new ES814ScalarQuantizedVectorsReader(new Lucene99ScalarQuantizedVectorsReader(state, rawVectorFormat.fieldsReader(state), flatVectorScorer));
    }

    public int getMaxDimensions(String fieldName) {
        return 4096;
    }

    static final class ES814ScalarQuantizedVectorsWriter
    extends FlatVectorsWriter {
        final Lucene99ScalarQuantizedVectorsWriter delegate;

        ES814ScalarQuantizedVectorsWriter(Lucene99ScalarQuantizedVectorsWriter delegate) {
            super(delegate.getFlatVectorScorer());
            this.delegate = delegate;
        }

        public FlatFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
            return this.delegate.addField(fieldInfo);
        }

        public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
            this.delegate.mergeOneField(fieldInfo, mergeState);
        }

        public CloseableRandomVectorScorerSupplier mergeOneFieldToIndex(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
            return this.delegate.mergeOneFieldToIndex(fieldInfo, mergeState);
        }

        public void finish() throws IOException {
            this.delegate.finish();
        }

        public void flush(int i, Sorter.DocMap docMap) throws IOException {
            this.delegate.flush(i, docMap);
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public long ramBytesUsed() {
            return this.delegate.ramBytesUsed();
        }
    }

    static final class ES814ScalarQuantizedVectorsReader
    extends FlatVectorsReader
    implements QuantizedVectorsReader {
        final Lucene99ScalarQuantizedVectorsReader delegate;

        ES814ScalarQuantizedVectorsReader(Lucene99ScalarQuantizedVectorsReader delegate) {
            super(delegate.getFlatVectorScorer());
            this.delegate = delegate;
        }

        public RandomVectorScorer getRandomVectorScorer(String field, float[] target) throws IOException {
            return this.delegate.getRandomVectorScorer(field, target);
        }

        public RandomVectorScorer getRandomVectorScorer(String field, byte[] target) throws IOException {
            return this.delegate.getRandomVectorScorer(field, target);
        }

        public void checkIntegrity() throws IOException {
            this.delegate.checkIntegrity();
        }

        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            return this.delegate.getFloatVectorValues(field);
        }

        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            return this.delegate.getByteVectorValues(field);
        }

        public QuantizedByteVectorValues getQuantizedVectorValues(String fieldName) throws IOException {
            return this.delegate.getQuantizedVectorValues(fieldName);
        }

        public ScalarQuantizer getQuantizationState(String fieldName) {
            return this.delegate.getQuantizationState(fieldName);
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public long ramBytesUsed() {
            return this.delegate.ramBytesUsed();
        }
    }

    static final class ESFlatVectorsScorer
    implements FlatVectorsScorer {
        final FlatVectorsScorer delegate;
        final VectorScorerFactory factory;

        ESFlatVectorsScorer(FlatVectorsScorer delegte) {
            this.delegate = delegte;
            this.factory = VectorScorerFactory.instance().orElse(null);
        }

        public String toString() {
            return "ESFlatVectorsScorer(delegate=" + String.valueOf(this.delegate) + ", factory=" + String.valueOf(this.factory) + ")";
        }

        public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction sim, KnnVectorValues values) throws IOException {
            QuantizedByteVectorValues qValues;
            if (values instanceof QuantizedByteVectorValues && (qValues = (QuantizedByteVectorValues)values).getSlice() != null) {
                Optional scorer;
                if (qValues.getScalarQuantizer().getBits() != 7) {
                    return this.delegate.getRandomVectorScorerSupplier(sim, values);
                }
                if (this.factory != null && (scorer = this.factory.getInt7SQVectorScorerSupplier(VectorSimilarityType.of((VectorSimilarityFunction)sim), qValues.getSlice(), qValues, qValues.getScalarQuantizer().getConstantMultiplier())).isPresent()) {
                    return (RandomVectorScorerSupplier)scorer.get();
                }
            }
            return this.delegate.getRandomVectorScorerSupplier(sim, values);
        }

        public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction sim, KnnVectorValues values, float[] query) throws IOException {
            QuantizedByteVectorValues qValues;
            if (values instanceof QuantizedByteVectorValues && (qValues = (QuantizedByteVectorValues)values).getSlice() != null) {
                Optional scorer;
                if (qValues.getScalarQuantizer().getBits() != 7) {
                    return this.delegate.getRandomVectorScorer(sim, values, query);
                }
                if (this.factory != null && (scorer = this.factory.getInt7SQVectorScorer(sim, qValues, query)).isPresent()) {
                    return (RandomVectorScorer)scorer.get();
                }
            }
            return this.delegate.getRandomVectorScorer(sim, values, query);
        }

        public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction sim, KnnVectorValues values, byte[] query) throws IOException {
            return this.delegate.getRandomVectorScorer(sim, values, query);
        }
    }
}

