/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.DataStreamFailureStore;
import org.elasticsearch.cluster.metadata.ResettableValue;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record DataStreamOptions(@Nullable DataStreamFailureStore failureStore) implements SimpleDiffable<DataStreamOptions>,
ToXContentObject
{
    public static final ParseField FAILURE_STORE_FIELD = new ParseField("failure_store", new String[0]);
    public static final DataStreamOptions FAILURE_STORE_ENABLED = new DataStreamOptions(new DataStreamFailureStore(true));
    public static final DataStreamOptions FAILURE_STORE_DISABLED = new DataStreamOptions(new DataStreamFailureStore(false));
    public static final DataStreamOptions EMPTY = new DataStreamOptions(null);
    public static final ConstructingObjectParser<DataStreamOptions, Void> PARSER = new ConstructingObjectParser("options", false, (args, unused) -> new DataStreamOptions((DataStreamFailureStore)args[0]));

    public static DataStreamOptions read(StreamInput in) throws IOException {
        return new DataStreamOptions(in.readOptionalWriteable(DataStreamFailureStore::new));
    }

    public static Diff<DataStreamOptions> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(DataStreamOptions::read, in);
    }

    public boolean isEmpty() {
        return this.failureStore == null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.failureStore);
    }

    @Override
    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.failureStore != null) {
            builder.field(FAILURE_STORE_FIELD.getPreferredName(), (ToXContent)this.failureStore);
        }
        builder.endObject();
        return builder;
    }

    public static DataStreamOptions fromXContent(XContentParser parser) throws IOException {
        return (DataStreamOptions)PARSER.parse(parser, null);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DataStreamFailureStore.fromXContent(p), FAILURE_STORE_FIELD);
    }

    public record Template(ResettableValue<DataStreamFailureStore.Template> failureStore) implements Writeable,
    ToXContentObject
    {
        public static final Template EMPTY = new Template(ResettableValue.undefined());
        public static final ConstructingObjectParser<Template, Void> PARSER = new ConstructingObjectParser("data_stream_options_template", false, (args, unused) -> new Template(args[0] == null ? ResettableValue.undefined() : (ResettableValue)args[0]));

        public Template {
            assert (failureStore != null) : "Template does not accept null values, please use Resettable.undefined()";
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            ResettableValue.write(out, this.failureStore, (o, v) -> v.writeTo(o));
        }

        public static Template read(StreamInput in) throws IOException {
            ResettableValue<DataStreamFailureStore.Template> failureStore = ResettableValue.read(in, DataStreamFailureStore.Template::read);
            return new Template(failureStore);
        }

        public static Template fromXContent(XContentParser parser) throws IOException {
            return (Template)PARSER.parse(parser, null);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.failureStore.toXContent(builder, params, FAILURE_STORE_FIELD.getPreferredName());
            builder.endObject();
            return builder;
        }

        public DataStreamOptions toDataStreamOptions() {
            return new DataStreamOptions(this.failureStore.mapAndGet(DataStreamFailureStore.Template::toFailureStore));
        }

        public static Builder builder(Template template) {
            return new Builder(template);
        }

        @Override
        public String toString() {
            return Strings.toString((ToXContent)this, true, true);
        }

        static {
            PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, s) -> ResettableValue.create(DataStreamFailureStore.Template.fromXContent(p)), ResettableValue.reset(), FAILURE_STORE_FIELD);
        }

        public static class Builder {
            private ResettableValue<DataStreamFailureStore.Template> failureStore = ResettableValue.undefined();

            public Builder(Template template) {
                if (template != null) {
                    this.failureStore = template.failureStore();
                }
            }

            public Builder updateFailureStore(ResettableValue<DataStreamFailureStore.Template> newFailureStore) {
                this.failureStore = ResettableValue.merge(this.failureStore, newFailureStore, DataStreamFailureStore.Template::merge);
                return this;
            }

            public Template build() {
                return new Template(this.failureStore);
            }
        }
    }
}

