/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.Iterator;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;

public class BulkResponse
extends ActionResponse
implements Iterable<BulkItemResponse>,
ChunkedToXContentObject {
    static final String ITEMS = "items";
    static final String ERRORS = "errors";
    static final String TOOK = "took";
    static final String INGEST_TOOK = "ingest_took";
    public static final long NO_INGEST_TOOK = -1L;
    private final BulkItemResponse[] responses;
    private final long tookInMillis;
    private final long ingestTookInMillis;
    private final BulkRequest.IncrementalState incrementalState;

    public BulkResponse(StreamInput in) throws IOException {
        super(in);
        this.responses = in.readArray(BulkItemResponse::new, BulkItemResponse[]::new);
        this.tookInMillis = in.readVLong();
        this.ingestTookInMillis = in.readZLong();
        this.incrementalState = in.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0) ? new BulkRequest.IncrementalState(in) : BulkRequest.IncrementalState.EMPTY;
    }

    public BulkResponse(BulkItemResponse[] responses, long tookInMillis) {
        this(responses, tookInMillis, -1L);
    }

    public BulkResponse(BulkItemResponse[] responses, long tookInMillis, long ingestTookInMillis) {
        this(responses, tookInMillis, ingestTookInMillis, BulkRequest.IncrementalState.EMPTY);
    }

    public BulkResponse(BulkItemResponse[] responses, long tookInMillis, long ingestTookInMillis, BulkRequest.IncrementalState incrementalState) {
        this.responses = responses;
        this.tookInMillis = tookInMillis;
        this.ingestTookInMillis = ingestTookInMillis;
        this.incrementalState = incrementalState;
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public TimeValue getIngestTook() {
        return new TimeValue(this.ingestTookInMillis);
    }

    public long getIngestTookInMillis() {
        return this.ingestTookInMillis;
    }

    BulkRequest.IncrementalState getIncrementalState() {
        return this.incrementalState;
    }

    public boolean hasFailures() {
        for (BulkItemResponse response : this.responses) {
            if (!response.isFailed()) continue;
            return true;
        }
        return false;
    }

    public String buildFailureMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("failure in bulk execution:");
        for (int i = 0; i < this.responses.length; ++i) {
            BulkItemResponse response = this.responses[i];
            if (!response.isFailed()) continue;
            sb.append("\n[").append(i).append("]: index [").append(response.getIndex()).append("], id [").append(response.getId()).append("], message [").append(response.getFailureMessage()).append("]");
        }
        return sb.toString();
    }

    public BulkItemResponse[] getItems() {
        return this.responses;
    }

    @Override
    public Iterator<BulkItemResponse> iterator() {
        return Iterators.forArray(this.responses);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray(this.responses);
        out.writeVLong(this.tookInMillis);
        out.writeZLong(this.ingestTookInMillis);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0)) {
            this.incrementalState.writeTo(out);
        }
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(Iterators.single((builder, p) -> {
            builder.startObject();
            builder.field(ERRORS, this.hasFailures());
            builder.field(TOOK, this.tookInMillis);
            if (this.ingestTookInMillis != -1L) {
                builder.field(INGEST_TOOK, this.ingestTookInMillis);
            }
            return builder.startArray(ITEMS);
        }), Iterators.forArray(this.responses), Iterators.single((builder, p) -> builder.endArray().endObject()));
    }
}

