/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.versionfield;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.script.BytesRefProducer;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.versionfield.VersionEncoder;

public class Version
implements ToXContentFragment,
BytesRefProducer,
Comparable<Version> {
    protected String version;
    protected BytesRef bytes;

    public Version(String version) {
        this.version = version;
        this.bytes = VersionEncoder.encodeVersion((String)version).bytesRef;
    }

    public Version(BytesRef bytes) {
        this.version = VersionEncoder.decodeVersion(bytes).utf8ToString();
        this.bytes = bytes;
    }

    public String toString() {
        return this.version;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }

    public BytesRef toBytesRef() {
        return this.bytes;
    }

    @Override
    public int compareTo(Version o) {
        return this.toBytesRef().compareTo(o.toBytesRef());
    }
}

