/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.openai.OpenAiActionVisitor;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.openai.OpenAiRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.ApiKeySecrets;

public abstract class OpenAiModel
extends Model {
    private final OpenAiRateLimitServiceSettings rateLimitServiceSettings;
    private final SecureString apiKey;

    public OpenAiModel(ModelConfigurations configurations, ModelSecrets secrets, OpenAiRateLimitServiceSettings rateLimitServiceSettings, @Nullable ApiKeySecrets apiKeySecrets) {
        super(configurations, secrets);
        this.rateLimitServiceSettings = Objects.requireNonNull(rateLimitServiceSettings);
        this.apiKey = ServiceUtils.apiKey(apiKeySecrets);
    }

    protected OpenAiModel(OpenAiModel model, TaskSettings taskSettings) {
        super((Model)model, taskSettings);
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
        this.apiKey = model.apiKey();
    }

    protected OpenAiModel(OpenAiModel model, ServiceSettings serviceSettings) {
        super((Model)model, serviceSettings);
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
        this.apiKey = model.apiKey();
    }

    public SecureString apiKey() {
        return this.apiKey;
    }

    public OpenAiRateLimitServiceSettings rateLimitServiceSettings() {
        return this.rateLimitServiceSettings;
    }

    public abstract ExecutableAction accept(OpenAiActionVisitor var1, Map<String, Object> var2);
}

