/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class RerankTaskSettings
implements TaskSettings {
    public static final String NAME = "custom_eland_rerank_task_settings";
    public static final String RETURN_DOCUMENTS = "return_documents";
    static final RerankTaskSettings DEFAULT_SETTINGS = new RerankTaskSettings(Boolean.TRUE);
    private final Boolean returnDocuments;

    public static RerankTaskSettings defaultsFromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        if (map == null || map.isEmpty()) {
            return DEFAULT_SETTINGS;
        }
        Boolean returnDocuments = ServiceUtils.extractOptionalBoolean(map, RETURN_DOCUMENTS, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        if (returnDocuments == null) {
            returnDocuments = true;
        }
        return new RerankTaskSettings(returnDocuments);
    }

    public static RerankTaskSettings fromMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return DEFAULT_SETTINGS;
        }
        Boolean returnDocuments = ServiceUtils.extractOptionalBoolean(map, RETURN_DOCUMENTS, new ValidationException());
        return new RerankTaskSettings(returnDocuments);
    }

    public static RerankTaskSettings of(RerankTaskSettings originalSettings, RerankTaskSettings requestTaskSettings) {
        return requestTaskSettings.returnDocuments() != null ? requestTaskSettings : originalSettings;
    }

    public RerankTaskSettings(StreamInput in) throws IOException {
        this(in.readOptionalBoolean());
    }

    public RerankTaskSettings(@Nullable Boolean doReturnDocuments) {
        this.returnDocuments = doReturnDocuments == null ? Boolean.valueOf(true) : doReturnDocuments;
    }

    public boolean isEmpty() {
        return this.returnDocuments == null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.returnDocuments != null) {
            builder.field(RETURN_DOCUMENTS, this.returnDocuments);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_14_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalBoolean(this.returnDocuments);
    }

    public Boolean returnDocuments() {
        return this.returnDocuments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RerankTaskSettings that = (RerankTaskSettings)o;
        return Objects.equals(this.returnDocuments, that.returnDocuments);
    }

    public int hashCode() {
        return Objects.hash(this.returnDocuments);
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        RerankTaskSettings updatedSettings = RerankTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return RerankTaskSettings.of(this, updatedSettings);
    }
}

