/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.lib.Logger;

public class StandardLogger
extends Logger {
    private PrintWriter writer = new PrintWriter(System.err);
    private int threshold = 0;
    private boolean mustClose = false;

    public StandardLogger() {
    }

    public StandardLogger(PrintStream stream) {
        this.setPrintStream(stream);
    }

    public StandardLogger(Writer writer) {
        this.setPrintWriter(new PrintWriter(writer));
    }

    public StandardLogger(File fileName) throws FileNotFoundException {
        this.setPrintStream(new PrintStream(fileName));
        this.mustClose = true;
    }

    public void setPrintStream(PrintStream stream) {
        this.writer = new PrintWriter(stream);
    }

    public void setPrintWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public PrintWriter getPrintWriter() {
        return this.writer;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public StreamResult asStreamResult() {
        return new StreamResult(this.writer);
    }

    @Override
    public void println(String message, int severity) {
        if (severity >= this.threshold) {
            this.writer.write(message + "\n");
            this.writer.flush();
        }
    }

    @Override
    public void close() {
        if (this.mustClose) {
            this.writer.close();
        }
    }
}

