// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudConsulTelemetry20230414ServiceTopology ServiceTopology is a topology of service metrics.
//
// swagger:model hashicorp.cloud.consul_telemetry_20230414.ServiceTopology
type HashicorpCloudConsulTelemetry20230414ServiceTopology struct {

	// edges connect nodes by node id (arbitrary key). These describe the connections/requests between services.
	Edges []*HashicorpCloudConsulTelemetry20230414ServiceTopologyEdge `json:"edges"`

	// nodes is a map from node ids (arbitrary keys) to nodes (services with meta).
	Nodes map[string]HashicorpCloudConsulTelemetry20230414ServiceTopologyNode `json:"nodes,omitempty"`
}

// Validate validates this hashicorp cloud consul telemetry 20230414 service topology
func (m *HashicorpCloudConsulTelemetry20230414ServiceTopology) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEdges(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNodes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudConsulTelemetry20230414ServiceTopology) validateEdges(formats strfmt.Registry) error {
	if swag.IsZero(m.Edges) { // not required
		return nil
	}

	for i := 0; i < len(m.Edges); i++ {
		if swag.IsZero(m.Edges[i]) { // not required
			continue
		}

		if m.Edges[i] != nil {
			if err := m.Edges[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("edges" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("edges" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudConsulTelemetry20230414ServiceTopology) validateNodes(formats strfmt.Registry) error {
	if swag.IsZero(m.Nodes) { // not required
		return nil
	}

	for k := range m.Nodes {

		if err := validate.Required("nodes"+"."+k, "body", m.Nodes[k]); err != nil {
			return err
		}
		if val, ok := m.Nodes[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nodes" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("nodes" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp cloud consul telemetry 20230414 service topology based on the context it is used
func (m *HashicorpCloudConsulTelemetry20230414ServiceTopology) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEdges(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNodes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudConsulTelemetry20230414ServiceTopology) contextValidateEdges(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Edges); i++ {

		if m.Edges[i] != nil {

			if swag.IsZero(m.Edges[i]) { // not required
				return nil
			}

			if err := m.Edges[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("edges" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("edges" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudConsulTelemetry20230414ServiceTopology) contextValidateNodes(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.Nodes {

		if val, ok := m.Nodes[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudConsulTelemetry20230414ServiceTopology) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudConsulTelemetry20230414ServiceTopology) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudConsulTelemetry20230414ServiceTopology
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
