//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
#[cfg(target_vendor = "apple")]
use objc2_core_graphics::*;
#[cfg(feature = "objc2-core-text")]
#[cfg(target_vendor = "apple")]
use objc2_core_text::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// ******* Font Matrix ********
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfontidentitymatrix?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static NSFontIdentityMatrix: NonNull<CGFloat>;
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfont?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSFont;
);

#[cfg(feature = "objc2-core-text")]
#[cfg(target_vendor = "apple")]
impl AsRef<NSFont> for CTFont {
    #[inline]
    fn as_ref(&self) -> &NSFont {
        unsafe { &*((self as *const Self).cast()) }
    }
}

#[cfg(feature = "objc2-core-text")]
#[cfg(target_vendor = "apple")]
impl AsRef<CTFont> for NSFont {
    #[inline]
    fn as_ref(&self) -> &CTFont {
        unsafe { &*((self as *const Self).cast()) }
    }
}

extern_conformance!(
    unsafe impl NSCoding for NSFont {}
);

extern_conformance!(
    unsafe impl NSCopying for NSFont {}
);

unsafe impl CopyingHelper for NSFont {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSFont {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for NSFont {}
);

impl NSFont {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        /// ******* Factory ********
        #[unsafe(method(fontWithName:size:))]
        #[unsafe(method_family = none)]
        pub fn fontWithName_size(
            font_name: &NSString,
            font_size: CGFloat,
        ) -> Option<Retained<NSFont>>;

        #[cfg(feature = "objc2-core-foundation")]
        /// # Safety
        ///
        /// `font_matrix` must be a valid pointer.
        #[unsafe(method(fontWithName:matrix:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fontWithName_matrix(
            font_name: &NSString,
            font_matrix: NonNull<CGFloat>,
        ) -> Option<Retained<NSFont>>;

        #[cfg(all(feature = "NSFontDescriptor", feature = "objc2-core-foundation"))]
        #[unsafe(method(fontWithDescriptor:size:))]
        #[unsafe(method_family = none)]
        pub fn fontWithDescriptor_size(
            font_descriptor: &NSFontDescriptor,
            font_size: CGFloat,
        ) -> Option<Retained<NSFont>>;

        #[cfg(feature = "NSFontDescriptor")]
        #[unsafe(method(fontWithDescriptor:textTransform:))]
        #[unsafe(method_family = none)]
        pub fn fontWithDescriptor_textTransform(
            font_descriptor: &NSFontDescriptor,
            text_transform: Option<&NSAffineTransform>,
        ) -> Option<Retained<NSFont>>;

        #[cfg(feature = "objc2-core-foundation")]
        /// ******* Meta Font ********
        #[unsafe(method(userFontOfSize:))]
        #[unsafe(method_family = none)]
        pub fn userFontOfSize(font_size: CGFloat) -> Option<Retained<NSFont>>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(userFixedPitchFontOfSize:))]
        #[unsafe(method_family = none)]
        pub fn userFixedPitchFontOfSize(font_size: CGFloat) -> Option<Retained<NSFont>>;

        #[unsafe(method(setUserFont:))]
        #[unsafe(method_family = none)]
        pub fn setUserFont(font: Option<&NSFont>);

        #[unsafe(method(setUserFixedPitchFont:))]
        #[unsafe(method_family = none)]
        pub fn setUserFixedPitchFont(font: Option<&NSFont>);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(systemFontOfSize:))]
        #[unsafe(method_family = none)]
        pub fn systemFontOfSize(font_size: CGFloat) -> Retained<NSFont>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(boldSystemFontOfSize:))]
        #[unsafe(method_family = none)]
        pub fn boldSystemFontOfSize(font_size: CGFloat) -> Retained<NSFont>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(labelFontOfSize:))]
        #[unsafe(method_family = none)]
        pub fn labelFontOfSize(font_size: CGFloat) -> Retained<NSFont>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(titleBarFontOfSize:))]
        #[unsafe(method_family = none)]
        pub fn titleBarFontOfSize(font_size: CGFloat) -> Retained<NSFont>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(menuFontOfSize:))]
        #[unsafe(method_family = none)]
        pub fn menuFontOfSize(font_size: CGFloat) -> Retained<NSFont>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(menuBarFontOfSize:))]
        #[unsafe(method_family = none)]
        pub fn menuBarFontOfSize(font_size: CGFloat) -> Retained<NSFont>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(messageFontOfSize:))]
        #[unsafe(method_family = none)]
        pub fn messageFontOfSize(font_size: CGFloat) -> Retained<NSFont>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(paletteFontOfSize:))]
        #[unsafe(method_family = none)]
        pub fn paletteFontOfSize(font_size: CGFloat) -> Retained<NSFont>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(toolTipsFontOfSize:))]
        #[unsafe(method_family = none)]
        pub fn toolTipsFontOfSize(font_size: CGFloat) -> Retained<NSFont>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(controlContentFontOfSize:))]
        #[unsafe(method_family = none)]
        pub fn controlContentFontOfSize(font_size: CGFloat) -> Retained<NSFont>;

        #[cfg(all(feature = "NSFontDescriptor", feature = "objc2-core-foundation"))]
        #[unsafe(method(systemFontOfSize:weight:))]
        #[unsafe(method_family = none)]
        pub fn systemFontOfSize_weight(
            font_size: CGFloat,
            weight: NSFontWeight,
        ) -> Retained<NSFont>;

        #[cfg(all(feature = "NSFontDescriptor", feature = "objc2-core-foundation"))]
        #[unsafe(method(monospacedDigitSystemFontOfSize:weight:))]
        #[unsafe(method_family = none)]
        pub fn monospacedDigitSystemFontOfSize_weight(
            font_size: CGFloat,
            weight: NSFontWeight,
        ) -> Retained<NSFont>;

        #[cfg(all(feature = "NSFontDescriptor", feature = "objc2-core-foundation"))]
        #[unsafe(method(systemFontOfSize:weight:width:))]
        #[unsafe(method_family = none)]
        pub fn systemFontOfSize_weight_width(
            font_size: CGFloat,
            weight: NSFontWeight,
            width: NSFontWidth,
        ) -> Retained<NSFont>;

        #[cfg(all(feature = "NSFontDescriptor", feature = "objc2-core-foundation"))]
        #[unsafe(method(monospacedSystemFontOfSize:weight:))]
        #[unsafe(method_family = none)]
        pub fn monospacedSystemFontOfSize_weight(
            font_size: CGFloat,
            weight: NSFontWeight,
        ) -> Retained<NSFont>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(fontWithSize:))]
        #[unsafe(method_family = none)]
        pub fn fontWithSize(&self, font_size: CGFloat) -> Retained<NSFont>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(systemFontSize))]
        #[unsafe(method_family = none)]
        pub fn systemFontSize() -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(smallSystemFontSize))]
        #[unsafe(method_family = none)]
        pub fn smallSystemFontSize() -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(labelFontSize))]
        #[unsafe(method_family = none)]
        pub fn labelFontSize() -> CGFloat;

        #[cfg(all(feature = "NSCell", feature = "objc2-core-foundation"))]
        #[unsafe(method(systemFontSizeForControlSize:))]
        #[unsafe(method_family = none)]
        pub fn systemFontSizeForControlSize(control_size: NSControlSize) -> CGFloat;

        /// ******* Core font attribute ********
        #[unsafe(method(fontName))]
        #[unsafe(method_family = none)]
        pub fn fontName(&self) -> Retained<NSString>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(pointSize))]
        #[unsafe(method_family = none)]
        pub fn pointSize(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(matrix))]
        #[unsafe(method_family = none)]
        pub fn matrix(&self) -> NonNull<CGFloat>;

        #[unsafe(method(familyName))]
        #[unsafe(method_family = none)]
        pub fn familyName(&self) -> Option<Retained<NSString>>;

        #[unsafe(method(displayName))]
        #[unsafe(method_family = none)]
        pub fn displayName(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSFontDescriptor")]
        #[unsafe(method(fontDescriptor))]
        #[unsafe(method_family = none)]
        pub fn fontDescriptor(&self) -> Retained<NSFontDescriptor>;

        #[unsafe(method(textTransform))]
        #[unsafe(method_family = none)]
        pub fn textTransform(&self) -> Retained<NSAffineTransform>;

        /// ******* Glyph coverage ********
        #[unsafe(method(numberOfGlyphs))]
        #[unsafe(method_family = none)]
        pub fn numberOfGlyphs(&self) -> NSUInteger;

        #[unsafe(method(mostCompatibleStringEncoding))]
        #[unsafe(method_family = none)]
        pub fn mostCompatibleStringEncoding(&self) -> NSStringEncoding;

        #[unsafe(method(coveredCharacterSet))]
        #[unsafe(method_family = none)]
        pub fn coveredCharacterSet(&self) -> Retained<NSCharacterSet>;

        #[unsafe(method(boundingRectForFont))]
        #[unsafe(method_family = none)]
        pub fn boundingRectForFont(&self) -> NSRect;

        #[unsafe(method(maximumAdvancement))]
        #[unsafe(method_family = none)]
        pub fn maximumAdvancement(&self) -> NSSize;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(ascender))]
        #[unsafe(method_family = none)]
        pub fn ascender(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(descender))]
        #[unsafe(method_family = none)]
        pub fn descender(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(leading))]
        #[unsafe(method_family = none)]
        pub fn leading(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(underlinePosition))]
        #[unsafe(method_family = none)]
        pub fn underlinePosition(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(underlineThickness))]
        #[unsafe(method_family = none)]
        pub fn underlineThickness(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(italicAngle))]
        #[unsafe(method_family = none)]
        pub fn italicAngle(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(capHeight))]
        #[unsafe(method_family = none)]
        pub fn capHeight(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(xHeight))]
        #[unsafe(method_family = none)]
        pub fn xHeight(&self) -> CGFloat;

        #[unsafe(method(isFixedPitch))]
        #[unsafe(method_family = none)]
        pub fn isFixedPitch(&self) -> bool;

        #[cfg(feature = "objc2-core-graphics")]
        #[cfg(target_vendor = "apple")]
        /// ******* Glyph metrics ********
        ///
        /// ******* Glyph metrics ********
        #[unsafe(method(boundingRectForCGGlyph:))]
        #[unsafe(method_family = none)]
        pub fn boundingRectForCGGlyph(&self, glyph: CGGlyph) -> NSRect;

        #[cfg(feature = "objc2-core-graphics")]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(advancementForCGGlyph:))]
        #[unsafe(method_family = none)]
        pub fn advancementForCGGlyph(&self, glyph: CGGlyph) -> NSSize;

        #[cfg(feature = "objc2-core-graphics")]
        #[cfg(target_vendor = "apple")]
        /// # Safety
        ///
        /// - `bounds` must be a valid pointer.
        /// - `glyphs` must be a valid pointer.
        #[unsafe(method(getBoundingRects:forCGGlyphs:count:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getBoundingRects_forCGGlyphs_count(
            &self,
            bounds: NSRectArray,
            glyphs: NonNull<CGGlyph>,
            glyph_count: NSUInteger,
        );

        #[cfg(feature = "objc2-core-graphics")]
        #[cfg(target_vendor = "apple")]
        /// # Safety
        ///
        /// - `advancements` must be a valid pointer.
        /// - `glyphs` must be a valid pointer.
        #[unsafe(method(getAdvancements:forCGGlyphs:count:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getAdvancements_forCGGlyphs_count(
            &self,
            advancements: NSSizeArray,
            glyphs: NonNull<CGGlyph>,
            glyph_count: NSUInteger,
        );

        /// ******* NSGraphicsContext-related ********
        #[unsafe(method(set))]
        #[unsafe(method_family = none)]
        pub fn set(&self);

        #[cfg(feature = "NSGraphicsContext")]
        #[unsafe(method(setInContext:))]
        #[unsafe(method_family = none)]
        pub fn setInContext(&self, graphics_context: &NSGraphicsContext);

        /// ******* Vertical mode ********
        #[unsafe(method(verticalFont))]
        #[unsafe(method_family = none)]
        pub fn verticalFont(&self) -> Retained<NSFont>;

        #[unsafe(method(isVertical))]
        #[unsafe(method_family = none)]
        pub fn isVertical(&self) -> bool;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSFont {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSFont {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

extern "C" {
    /// ******* Notifications ********
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsantialiasthresholdchangednotification?language=objc)
    pub static NSAntialiasThresholdChangedNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfontsetchangednotification?language=objc)
    pub static NSFontSetChangedNotification: &'static NSNotificationName;
}

/// ******* Deprecated API ********
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsglyph?language=objc)
pub type NSGlyph = c_uint;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontrolglyph?language=objc)
pub const NSControlGlyph: c_uint = 0x00FFFFFF;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsnullglyph?language=objc)
pub const NSNullGlyph: c_uint = 0x0;

/// ******* Screen Font Rendering Mode ********
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfontrenderingmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSFontRenderingMode(pub NSUInteger);
impl NSFontRenderingMode {
    #[doc(alias = "NSFontDefaultRenderingMode")]
    pub const DefaultRenderingMode: Self = Self(0);
    #[doc(alias = "NSFontAntialiasedRenderingMode")]
    pub const AntialiasedRenderingMode: Self = Self(1);
    #[doc(alias = "NSFontIntegerAdvancementsRenderingMode")]
    pub const IntegerAdvancementsRenderingMode: Self = Self(2);
    #[doc(alias = "NSFontAntialiasedIntegerAdvancementsRenderingMode")]
    pub const AntialiasedIntegerAdvancementsRenderingMode: Self = Self(3);
}

unsafe impl Encode for NSFontRenderingMode {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSFontRenderingMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmultibyteglyphpacking?language=objc)
// NS_ENUM
#[deprecated]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSMultibyteGlyphPacking(pub NSUInteger);
impl NSMultibyteGlyphPacking {
    #[doc(alias = "NSNativeShortGlyphPacking")]
    #[deprecated]
    pub const NativeShortGlyphPacking: Self = Self(5);
}

unsafe impl Encode for NSMultibyteGlyphPacking {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSMultibyteGlyphPacking {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `gl_buf` must be a valid pointer.
    /// - `packed_glyphs` must be a valid pointer.
    #[deprecated]
    pub fn NSConvertGlyphsToPackedGlyphs(
        gl_buf: NonNull<NSGlyph>,
        count: NSInteger,
        packing: NSMultibyteGlyphPacking,
        packed_glyphs: NonNull<c_char>,
    ) -> NSInteger;
}

/// NSFont_Deprecated.
impl NSFont {
    extern_methods!(
        #[unsafe(method(glyphWithName:))]
        #[unsafe(method_family = none)]
        pub fn glyphWithName(&self, name: &NSString) -> NSGlyph;

        #[unsafe(method(boundingRectForGlyph:))]
        #[unsafe(method_family = none)]
        pub fn boundingRectForGlyph(&self, glyph: NSGlyph) -> NSRect;

        #[unsafe(method(advancementForGlyph:))]
        #[unsafe(method_family = none)]
        pub fn advancementForGlyph(&self, glyph: NSGlyph) -> NSSize;

        /// # Safety
        ///
        /// - `bounds` must be a valid pointer.
        /// - `glyphs` must be a valid pointer.
        #[unsafe(method(getBoundingRects:forGlyphs:count:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getBoundingRects_forGlyphs_count(
            &self,
            bounds: NSRectArray,
            glyphs: NonNull<NSGlyph>,
            glyph_count: NSUInteger,
        );

        /// # Safety
        ///
        /// - `advancements` must be a valid pointer.
        /// - `glyphs` must be a valid pointer.
        #[unsafe(method(getAdvancements:forGlyphs:count:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getAdvancements_forGlyphs_count(
            &self,
            advancements: NSSizeArray,
            glyphs: NonNull<NSGlyph>,
            glyph_count: NSUInteger,
        );

        /// # Safety
        ///
        /// - `advancements` must be a valid pointer.
        /// - `packed_glyphs` must be a valid pointer.
        #[unsafe(method(getAdvancements:forPackedGlyphs:length:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getAdvancements_forPackedGlyphs_length(
            &self,
            advancements: NSSizeArray,
            packed_glyphs: NonNull<c_void>,
            length: NSUInteger,
        );

        /// ******* Rendering mode ********
        #[unsafe(method(printerFont))]
        #[unsafe(method_family = none)]
        pub fn printerFont(&self) -> Retained<NSFont>;

        #[unsafe(method(screenFont))]
        #[unsafe(method_family = none)]
        pub fn screenFont(&self) -> Retained<NSFont>;

        #[unsafe(method(screenFontWithRenderingMode:))]
        #[unsafe(method_family = none)]
        pub fn screenFontWithRenderingMode(
            &self,
            rendering_mode: NSFontRenderingMode,
        ) -> Retained<NSFont>;

        #[unsafe(method(renderingMode))]
        #[unsafe(method_family = none)]
        pub fn renderingMode(&self) -> NSFontRenderingMode;
    );
}

/// NSFont_TextStyles.
impl NSFont {
    extern_methods!(
        #[cfg(feature = "NSFontDescriptor")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(preferredFontForTextStyle:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredFontForTextStyle_options(
            style: &NSFontTextStyle,
            options: &NSDictionary<NSFontTextStyleOptionKey, AnyObject>,
        ) -> Retained<NSFont>;
    );
}
