/* Generated by re2c 3.0 on Wed Jun 12 10:26:07 2024 */
#line 1 "parse_date.re"
/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015-2023 Derick Rethans
 * Copyright (c) 2018 MongoDB, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "timelib.h"
#include "timelib_private.h"

#include <ctype.h>
#include <errno.h>
#include <math.h>
#include <assert.h>
#include <limits.h>

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279
#define TIMELIB_LF_DAY_OF_MONTH 280
#define TIMELIB_WEEK_DAY_OF_MONTH 281

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

/* Some compilers like AIX, defines uchar in sys/types.h */
#undef uchar
typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free timelib_free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, TIMELIB_ERR_DOUBLE_TIME, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->us = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->us = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, TIMELIB_ERR_DOUBLE_DATE, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { s->time->have_zone > 1 ? add_error(s, TIMELIB_ERR_DOUBLE_TZ, "Double timezone specification") : add_warning(s, TIMELIB_WARN_DOUBLE_TZ, "Double timezone specification"); timelib_string_free(str); s->time->have_zone++; return TIMELIB_ERROR; } else { s->time->have_zone++; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x, l) { \
	if (((x) == TIMELIB_UNSET) || ((l) >= 4)) { \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

typedef struct _timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct _Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	timelib_error_container *errors;

	timelib_time        *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
	const char *name;
	int         type;
	int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

/* The timezone table. */
static const timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static const timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static const timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

#if defined(_POSIX_TZNAME_MAX)
# define MAX_ABBR_LEN _POSIX_TZNAME_MAX
#elif defined(TZNAME_MAX)
# define MAX_ABBR_LEN TZNAME_MAX
#else
# define MAX_ABBR_LEN 6
#endif

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "ms",           TIMELIB_MICROSEC, 1000 },
	{ "msec",         TIMELIB_MICROSEC, 1000 },
	{ "msecs",        TIMELIB_MICROSEC, 1000 },
	{ "millisecond",  TIMELIB_MICROSEC, 1000 },
	{ "milliseconds", TIMELIB_MICROSEC, 1000 },
	{ "µs",           TIMELIB_MICROSEC,    1 },
	{ "usec",         TIMELIB_MICROSEC,    1 },
	{ "usecs",        TIMELIB_MICROSEC,    1 },
	{ "µsec",         TIMELIB_MICROSEC,    1 },
	{ "µsecs",        TIMELIB_MICROSEC,    1 },
	{ "microsecond",  TIMELIB_MICROSEC,    1 },
	{ "microseconds", TIMELIB_MICROSEC,    1 },
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "mondays",     TIMELIB_WEEKDAY, 1 },
	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesdays",    TIMELIB_WEEKDAY, 2 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesdays",  TIMELIB_WEEKDAY, 3 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursdays",   TIMELIB_WEEKDAY, 4 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "fridays",     TIMELIB_WEEKDAY, 5 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturdays",   TIMELIB_WEEKDAY, 6 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sundays",     TIMELIB_WEEKDAY, 0 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "eighth",   0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) timelib_malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			timelib_free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static timelib_error_message *alloc_error_message(timelib_error_message **messages, int *count)
{
	/* Realloc in power of two increments */
	int is_pow2 = (*count & (*count - 1)) == 0;

	if (is_pow2) {
		size_t alloc_size = *count ? (*count * 2) : 1;

		*messages = timelib_realloc(*messages, alloc_size * sizeof(timelib_error_message));
	}
	return *messages + (*count)++;
}

static void add_warning(Scanner *s, int error_code, const char *error)
{
	timelib_error_message *message = alloc_error_message(&s->errors->warning_messages, &s->errors->warning_count);

	message->error_code = error_code;
	message->position = s->tok ? s->tok - s->str : 0;
	message->character = s->tok ? *s->tok : 0;
	message->message = timelib_strdup(error);
}

static void add_error(Scanner *s, int error_code, const char *error)
{
	timelib_error_message *message = alloc_error_message(&s->errors->error_messages, &s->errors->error_count);

	message->error_code = error_code;
	message->position = s->tok ? s->tok - s->str : 0;
	message->character = s->tok ? *s->tok : 0;
	message->message = timelib_strdup(error);
}

static void add_pbf_warning(Scanner *s, int error_code, const char *error, const char *sptr, const char *cptr)
{
	timelib_error_message *message = alloc_error_message(&s->errors->warning_messages, &s->errors->warning_count);

	message->error_code = error_code;
	message->position = cptr - sptr;
	message->character = *cptr;
	message->message = timelib_strdup(error);
}

static void add_pbf_error(Scanner *s, int error_code, const char *error, const char *sptr, const char *cptr)
{
	timelib_error_message *message = alloc_error_message(&s->errors->error_messages, &s->errors->error_count);

	message->error_code = error_code;
	message->position = cptr - sptr;
	message->character = *cptr;
	message->message = timelib_strdup(error);
}

static timelib_sll timelib_meridian(const char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
	}
	if (**ptr == 'M' || **ptr == 'm') {
		++*ptr;
	}
	if (**ptr == '.') {
		++*ptr;
	}
	return retval;
}

static timelib_sll timelib_meridian_with_check(const char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (**ptr && !strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if(!**ptr) {
		return TIMELIB_UNSET;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
		if (**ptr != 'm' && **ptr != 'M') {
			return TIMELIB_UNSET;
		}
		++*ptr;
		if (**ptr != '.' ) {
			return TIMELIB_UNSET;
		}
		++*ptr;
	} else if (**ptr == 'm' || **ptr == 'M') {
		++*ptr;
	} else {
		return TIMELIB_UNSET;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = timelib_calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr_ex(const char **ptr, int max_length, int *scanned_length)
{
	const char *begin, *end;
	char *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	if (scanned_length) {
		*scanned_length = end - begin;
	}
	str = timelib_calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	timelib_free(str);
	return tmp_nr;
}

static timelib_sll timelib_get_nr(const char **ptr, int max_length)
{
	return timelib_get_nr_ex(ptr, max_length, NULL);
}

static void timelib_skip_day_suffix(const char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!timelib_strncasecmp(*ptr, "nd", 2) || !timelib_strncasecmp(*ptr, "rd", 2) ||!timelib_strncasecmp(*ptr, "st", 2) || !timelib_strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static timelib_sll timelib_get_frac_nr(const char **ptr)
{
	const char *begin, *end;
	char *str;
	double tmp_nr = TIMELIB_UNSET;

	while ((**ptr != '.') && (**ptr != ':') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr == '.') || (**ptr == ':') || ((**ptr >= '0') && (**ptr <= '9'))) {
		++*ptr;
	}
	end = *ptr;
	str = timelib_calloc(1, end - begin);
	memcpy(str, begin + 1, end - begin - 1);
	tmp_nr = strtod(str, NULL) * pow(10, 7 - (end - begin));
	timelib_free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_signed_nr(Scanner *s, const char **ptr, int max_length)
{
	char *str, *str_ptr;
	timelib_sll tmp_nr = 0;
	int len = 0;

	str = timelib_calloc(1, max_length + 2); // for sign and \0
	str_ptr = str;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			add_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Found unexpected data");
			timelib_free(str);
			return 0;
		}
		++*ptr;
	}

	if ((**ptr == '+') || (**ptr == '-')) {
		*str_ptr = **ptr;
		++*ptr;
		++str_ptr;
	}

	while (((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			timelib_free(str);
			add_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Found unexpected data");
			return 0;
		}
		++*ptr;
	}

	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		*str_ptr = **ptr;
		++*ptr;
		++str_ptr;
		++len;
	}

	errno = 0;
	tmp_nr = strtoll(str, NULL, 10);
	if (errno == ERANGE) {
		timelib_free(str);
		add_error(s, TIMELIB_ERR_NUMBER_OUT_OF_RANGE, "Number out of range");
		return 0;
	}

	timelib_free(str);

	return tmp_nr;
}

static timelib_sll timelib_lookup_relative_text(const char **ptr, int *behavior)
{
	char *word;
	const char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(const char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static timelib_long timelib_lookup_month(const char **ptr)
{
	char *word;
	const char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_long timelib_get_month(const char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(const char **ptr)
{
	do {
		if (**ptr == ' ' || **ptr == '\t') {
			++*ptr;
			continue;
		}
		if ((*ptr)[0] == '\xe2' && (*ptr)[1] == '\x80' && (*ptr)[2] == '\xaf') { // NNBSP
			*ptr += 3;
			continue;
		}
		if ((*ptr)[0] == '\xc2' && (*ptr)[1] == '\xa0') { // NBSP
			*ptr += 2;
			continue;
		}
		break;
	} while (true);
}

static void timelib_eat_until_separator(const char **ptr)
{
	++*ptr;
	while (strchr(" \t.,:;/-0123456789", **ptr) == NULL) {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(const char **ptr)
{
	char *word;
	const char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != ',' && **ptr != '\t' && **ptr != ';' && **ptr != ':' &&
		**ptr != '/' && **ptr != '.' && **ptr != '-' && **ptr != '(' && **ptr != ')' ) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	timelib_free(word);
	return value;
}

static void add_with_overflow(Scanner *s, timelib_sll *e, timelib_sll amount, int multiplier)
{
#if defined(__has_builtin) && __has_builtin(__builtin_saddll_overflow)
	if (__builtin_saddll_overflow(*e, amount * multiplier, e)) {
		add_error(s, TIMELIB_ERR_NUMBER_OUT_OF_RANGE, "Number out of range");
	}
#else
	*e += (amount * multiplier);
#endif
}

/**
 * The time_part parameter is a flag. It can be TIMELIB_TIME_PART_KEEP in case
 * the time portion should not be reset to midnight, or
 * TIMELIB_TIME_PART_DONT_KEEP in case it does need to be reset. This is used
 * for not overwriting the time portion for 'X weekday'.
 */
static void timelib_set_relative(const char **ptr, timelib_sll amount, int behavior, Scanner *s, int time_part)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_MICROSEC: add_with_overflow(s, &s->time->relative.us, amount, relunit->multiplier); break;
		case TIMELIB_SECOND:   add_with_overflow(s, &s->time->relative.s, amount, relunit->multiplier); break;
		case TIMELIB_MINUTE:   add_with_overflow(s, &s->time->relative.i, amount, relunit->multiplier); break;
		case TIMELIB_HOUR:     add_with_overflow(s, &s->time->relative.h, amount, relunit->multiplier); break;
		case TIMELIB_DAY:      add_with_overflow(s, &s->time->relative.d, amount, relunit->multiplier); break;
		case TIMELIB_MONTH:    add_with_overflow(s, &s->time->relative.m, amount, relunit->multiplier); break;
		case TIMELIB_YEAR:     add_with_overflow(s, &s->time->relative.y, amount, relunit->multiplier); break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			if (time_part != TIMELIB_TIME_PART_KEEP) {
				TIMELIB_UNHAVE_TIME();
			}
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			if (time_part != TIMELIB_TIME_PART_KEEP) {
				TIMELIB_UNHAVE_TIME();
			}
			s->time->relative.special.type = relunit->multiplier;
			s->time->relative.special.amount = amount;
	}
}

static const timelib_tz_lookup_table* abbr_search(const char *word, timelib_long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (timelib_strcasecmp("utc", word) == 0 || timelib_strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}

	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if (fmp->gmtoffset == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static timelib_long timelib_lookup_abbr(const char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	const char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_tz_lookup_table *tp;

	/* Only include A-Z, a-z, 0-9, /, _, and - in abbreviations/TZ IDs */
	while (
		(**ptr >= 'A' && **ptr <= 'Z') ||
		(**ptr >= 'a' && **ptr <= 'z') ||
		(**ptr >= '0' && **ptr <= '9') ||
		**ptr == '/' || **ptr == '_' || **ptr == '-' || **ptr == '+'
	) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if (end - begin < MAX_ABBR_LEN && (tp = abbr_search(word, -1, 0))) {
		value = tp->gmtoffset;
		*dst = tp->type;
		value -= tp->type * 3600;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

#define sHOUR(a) (int)(a * 3600)
#define sMIN(a) (int)(a * 60)

static timelib_long timelib_parse_tz_cor(const char **ptr, int *tz_not_found)
{
	const char *begin = *ptr, *end;
	timelib_long  tmp;

	*tz_not_found = 1;

	while (isdigit(**ptr) || **ptr == ':') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1: /* H */
		case 2: /* HH */
			*tz_not_found = 0;
			return sHOUR(strtol(begin, NULL, 10));

		case 3: /* H:M */
		case 4: /* H:MM, HH:M, HHMM */
			if (begin[1] == ':') {
				*tz_not_found = 0;
				tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 2, NULL, 10));
				return tmp;
			} else if (begin[2] == ':') {
				*tz_not_found = 0;
				tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10));
				return tmp;
			} else {
				*tz_not_found = 0;
				tmp = strtol(begin, NULL, 10);
				return sHOUR(tmp / 100) + sMIN(tmp % 100);
			}

		case 5: /* HH:MM */
			if (begin[2] != ':') {
				break;
			}

			*tz_not_found = 0;
			tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10));
			return tmp;

		case 6: /* HHMMSS */
			*tz_not_found = 0;
			tmp = strtol(begin, NULL, 10);
			tmp = sHOUR(tmp / 10000) + sMIN((tmp / 100) % 100) + (tmp % 100);
			return tmp;

		case 8: /* HH:MM:SS */
			if (begin[2] != ':' || begin[5] != ':') {
				break;
			}

			*tz_not_found = 0;
			tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10)) + strtol(begin + 6, NULL, 10);
			return tmp;

	}
	return 0;
}

static timelib_long timelib_parse_tz_minutes(const char **ptr, timelib_time *t)
{
	timelib_long retval = TIMELIB_UNSET;
	const char *begin = *ptr;

	/* First character must be +/- */
	if (**ptr != '+' && **ptr != '-') {
		return retval;
	}

	++*ptr;
	while (isdigit(**ptr)) {
		++*ptr;
	}

	if (*begin == '+') {
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = sMIN(strtol(begin + 1, NULL, 10));
	} else if (*begin == '-') {
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = -1 * sMIN(strtol(begin + 1, NULL, 10));
	}
	return retval;
}

timelib_long timelib_parse_zone(const char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_wrapper)
{
	timelib_tzinfo *res;
	timelib_long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if ((*ptr)[0] == 'G' && (*ptr)[1] == 'M' && (*ptr)[2] == 'T' && ((*ptr)[3] == '+' || (*ptr)[3] == '-')) {
		*ptr += 3;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr, tz_not_found);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr, tz_not_found);
	} else {
		int found = 0;
		timelib_long offset = 0;
		char *tz_abbr;

		t->is_localtime = 1;

		/* First, we lookup by abbreviation only */
		offset = timelib_lookup_abbr(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
			t->dst = *dst;
			timelib_time_tz_abbr_update(t, tz_abbr);
		}

		/* Otherwise, we look if we have a TimeZone identifier */
		if (!found || strcmp("UTC", tz_abbr) == 0) {
			int dummy_error_code;

			if ((res = tz_wrapper(tz_abbr, tzdb, &dummy_error_code)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		timelib_free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		timelib_free(arg.v[i]);    \
	}                              \
	if (arg.v) {                   \
		timelib_free(arg.v);       \
	}                              \
}

static int scan(Scanner *s, timelib_tz_get_wrapper tz_get_wrapper)
{
	uchar *cursor = s->cur;
	char *str;
	const char *ptr = NULL;

std:
	s->tok = cursor;
	s->len = 0;
#line 1147 "parse_date.re"



#line 1022 "<stdout>"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,  50,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		 50,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   4,  32,  20,  48,   0, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   0,   0,   0,   0,   0,   0, 
		  0,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,   0,   0,   0,   0,   0, 
		  0, 192, 192, 192, 224, 192, 192, 192, 
		224, 192, 192, 192, 192, 192, 224, 192, 
		192, 192, 224, 224, 224, 192, 192, 192, 
		192, 192, 192,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	YYDEBUG(0, *YYCURSOR);
	if ((YYLIMIT - YYCURSOR) < 36) YYFILL(36);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 2) {
		goto yy4;
	}
	if (yych <= 'R') {
		if (yych <= '?') {
			if (yych <= ',') {
				if (yych <= '\'') {
					if (yych <= 0x00) goto yy1;
					if (yych <= 0x08) goto yy2;
					if (yych >= '\v') goto yy2;
				} else {
					if (yych <= '(') goto yy6;
					if (yych <= '*') goto yy2;
					if (yych <= '+') goto yy7;
					goto yy8;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '-') goto yy7;
					if (yych <= '.') goto yy8;
					if (yych <= '/') goto yy2;
					goto yy9;
				} else {
					if (yych <= '2') {
						if (yych <= '1') goto yy10;
						goto yy11;
					} else {
						if (yych <= '3') goto yy12;
						if (yych <= '9') goto yy13;
						goto yy2;
					}
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'C') {
					if (yych <= '@') goto yy14;
					if (yych <= 'A') goto yy15;
					if (yych <= 'B') goto yy17;
					goto yy18;
				} else {
					if (yych <= 'E') {
						if (yych <= 'D') goto yy19;
						goto yy20;
					} else {
						if (yych <= 'F') goto yy21;
						if (yych <= 'G') goto yy22;
						goto yy18;
					}
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'I') goto yy23;
					if (yych <= 'J') goto yy24;
					if (yych <= 'K') goto yy18;
					goto yy25;
				} else {
					if (yych <= 'N') {
						if (yych <= 'M') goto yy26;
						goto yy27;
					} else {
						if (yych <= 'O') goto yy28;
						if (yych <= 'P') goto yy29;
						goto yy18;
					}
				}
			}
		}
	} else {
		if (yych <= 'k') {
			if (yych <= '`') {
				if (yych <= 'V') {
					if (yych <= 'S') goto yy30;
					if (yych <= 'T') goto yy31;
					if (yych <= 'U') goto yy18;
					goto yy32;
				} else {
					if (yych <= 'X') {
						if (yych <= 'W') goto yy33;
						goto yy34;
					} else {
						if (yych <= 'Y') goto yy35;
						if (yych <= 'Z') goto yy18;
						goto yy2;
					}
				}
			} else {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy36;
					if (yych <= 'b') goto yy37;
					if (yych <= 'c') goto yy38;
					goto yy39;
				} else {
					if (yych <= 'f') {
						if (yych <= 'e') goto yy40;
						goto yy41;
					} else {
						if (yych == 'j') goto yy42;
						goto yy38;
					}
				}
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') {
					if (yych <= 'l') goto yy43;
					if (yych <= 'm') goto yy44;
					if (yych <= 'n') goto yy45;
					goto yy46;
				} else {
					if (yych <= 'r') {
						if (yych <= 'p') goto yy47;
						goto yy38;
					} else {
						if (yych <= 's') goto yy48;
						if (yych <= 't') goto yy49;
						goto yy38;
					}
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'w') goto yy50;
					if (yych == 'y') goto yy51;
					goto yy38;
				} else {
					if (yych <= 0xC2) {
						if (yych <= 0xC1) goto yy2;
						goto yy52;
					} else {
						if (yych == 0xE2) goto yy53;
						goto yy2;
					}
				}
			}
		}
	}
yy1:
	YYDEBUG(1, *YYCURSOR);
	++YYCURSOR;
#line 1981 "parse_date.re"
	{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 1207 "<stdout>"
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
yy3:
	YYDEBUG(3, *YYCURSOR);
#line 1987 "parse_date.re"
	{
		add_error(s, TIMELIB_ERR_UNEXPECTED_CHARACTER, "Unexpected character");
		goto std;
	}
#line 1218 "<stdout>"
yy4:
	YYDEBUG(4, *YYCURSOR);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 25) YYFILL(25);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 2) {
		goto yy4;
	}
	if (yych <= '/') goto yy5;
	if (yych <= '9') goto yy54;
yy5:
	YYDEBUG(5, *YYCURSOR);
#line 1976 "parse_date.re"
	{
		goto std;
	}
#line 1236 "<stdout>"
yy6:
	YYDEBUG(6, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy3;
	if (yych <= 'Z') goto yy38;
	if (yych <= '`') goto yy3;
	if (yych <= 'z') goto yy38;
	goto yy3;
yy7:
	YYDEBUG(7, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= ' ') {
		if (yych == '\t') goto yy56;
		if (yych <= 0x1F) goto yy3;
		goto yy56;
	} else {
		if (yych <= '1') {
			if (yych <= '/') goto yy3;
			goto yy58;
		} else {
			if (yych <= '2') goto yy59;
			if (yych <= '9') goto yy60;
			goto yy3;
		}
	}
yy8:
	YYDEBUG(8, *YYCURSOR);
	++YYCURSOR;
#line 1971 "parse_date.re"
	{
		goto std;
	}
#line 1273 "<stdout>"
yy9:
	YYDEBUG(9, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy61;
					goto yy3;
				} else {
					if (yych <= ' ') goto yy63;
					if (yych <= ',') goto yy3;
					goto yy64;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy65;
					if (yych <= '/') goto yy66;
					goto yy67;
				} else {
					if (yych <= '9') goto yy68;
					if (yych <= ':') goto yy69;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy63;
					if (yych <= 'C') goto yy3;
					goto yy63;
				} else {
					if (yych == 'F') goto yy63;
					goto yy3;
				}
			} else {
				if (yych <= 'O') {
					if (yych <= 'J') goto yy63;
					if (yych <= 'L') goto yy3;
					goto yy63;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'Y') goto yy63;
					if (yych <= '`') goto yy3;
					goto yy63;
				}
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'h') {
				if (yych <= 'e') {
					if (yych == 'd') goto yy63;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy63;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'j') goto yy63;
					goto yy3;
				} else {
					if (yych == 'n') goto yy87;
					if (yych <= 'o') goto yy63;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 'r') goto yy88;
					if (yych <= 's') goto yy89;
					goto yy90;
				} else {
					if (yych == 'v') goto yy3;
					goto yy63;
				}
			} else {
				if (yych <= 0xC1) {
					if (yych == 'y') goto yy63;
					goto yy3;
				} else {
					if (yych <= 0xC2) goto yy91;
					if (yych == 0xE2) goto yy92;
					goto yy3;
				}
			}
		}
	}
yy10:
	YYDEBUG(10, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy93;
					goto yy3;
				} else {
					if (yych <= ' ') goto yy95;
					if (yych <= ',') goto yy3;
					goto yy64;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '.') goto yy96;
					if (yych <= '/') goto yy66;
					goto yy68;
				} else {
					if (yych <= '9') goto yy97;
					if (yych <= ':') goto yy98;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy95;
					if (yych <= 'C') goto yy3;
					goto yy95;
				} else {
					if (yych == 'F') goto yy95;
					goto yy3;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy95;
					if (yych <= 'L') goto yy3;
					goto yy95;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'Y') goto yy95;
					if (yych <= '`') goto yy3;
					goto yy95;
				}
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'h') {
				if (yych <= 'e') {
					if (yych == 'd') goto yy95;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy95;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'j') goto yy95;
					goto yy3;
				} else {
					if (yych == 'n') goto yy87;
					if (yych <= 'p') goto yy95;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 'r') goto yy88;
					if (yych <= 's') goto yy89;
					goto yy90;
				} else {
					if (yych == 'v') goto yy3;
					goto yy95;
				}
			} else {
				if (yych <= 0xC1) {
					if (yych == 'y') goto yy95;
					goto yy3;
				} else {
					if (yych <= 0xC2) goto yy101;
					if (yych == 0xE2) goto yy102;
					goto yy3;
				}
			}
		}
	}
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy93;
					goto yy3;
				} else {
					if (yych <= ' ') goto yy95;
					if (yych <= ',') goto yy3;
					goto yy64;
				}
			} else {
				if (yych <= '4') {
					if (yych <= '.') goto yy96;
					if (yych <= '/') goto yy66;
					goto yy97;
				} else {
					if (yych <= '9') goto yy103;
					if (yych <= ':') goto yy98;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy95;
					if (yych <= 'C') goto yy3;
					goto yy95;
				} else {
					if (yych == 'F') goto yy95;
					goto yy3;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy95;
					if (yych <= 'L') goto yy3;
					goto yy95;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'Y') goto yy95;
					if (yych <= '`') goto yy3;
					goto yy95;
				}
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'h') {
				if (yych <= 'e') {
					if (yych == 'd') goto yy95;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy95;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'j') goto yy95;
					goto yy3;
				} else {
					if (yych == 'n') goto yy87;
					if (yych <= 'p') goto yy95;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 'r') goto yy88;
					if (yych <= 's') goto yy89;
					goto yy90;
				} else {
					if (yych == 'v') goto yy3;
					goto yy95;
				}
			} else {
				if (yych <= 0xC1) {
					if (yych == 'y') goto yy95;
					goto yy3;
				} else {
					if (yych <= 0xC2) goto yy101;
					if (yych == 0xE2) goto yy102;
					goto yy3;
				}
			}
		}
	}
yy12:
	YYDEBUG(12, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy93;
					goto yy3;
				} else {
					if (yych <= ' ') goto yy95;
					if (yych <= ',') goto yy3;
					goto yy64;
				}
			} else {
				if (yych <= '1') {
					if (yych <= '.') goto yy96;
					if (yych <= '/') goto yy66;
					goto yy103;
				} else {
					if (yych <= '9') goto yy104;
					if (yych <= ':') goto yy98;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy95;
					if (yych <= 'C') goto yy3;
					goto yy95;
				} else {
					if (yych == 'F') goto yy95;
					goto yy3;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy95;
					if (yych <= 'L') goto yy3;
					goto yy95;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'Y') goto yy95;
					if (yych <= '`') goto yy3;
					goto yy95;
				}
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'h') {
				if (yych <= 'e') {
					if (yych == 'd') goto yy95;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy95;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'j') goto yy95;
					goto yy3;
				} else {
					if (yych == 'n') goto yy87;
					if (yych <= 'p') goto yy95;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 'r') goto yy88;
					if (yych <= 's') goto yy89;
					goto yy90;
				} else {
					if (yych == 'v') goto yy3;
					goto yy95;
				}
			} else {
				if (yych <= 0xC1) {
					if (yych == 'y') goto yy95;
					goto yy3;
				} else {
					if (yych <= 0xC2) goto yy101;
					if (yych == 0xE2) goto yy102;
					goto yy3;
				}
			}
		}
	}
yy13:
	YYDEBUG(13, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'c') {
		if (yych <= 'A') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy93;
					goto yy3;
				} else {
					if (yych <= ' ') goto yy95;
					if (yych <= ',') goto yy3;
					goto yy64;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '.') goto yy96;
					if (yych <= '/') goto yy66;
					goto yy104;
				} else {
					if (yych <= ':') goto yy98;
					if (yych <= '@') goto yy3;
					goto yy95;
				}
			}
		} else {
			if (yych <= 'J') {
				if (yych <= 'E') {
					if (yych == 'D') goto yy95;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy95;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'L') goto yy3;
					if (yych <= 'P') goto yy95;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy95;
					if (yych == 'a') goto yy95;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'i') {
				if (yych <= 'f') {
					if (yych == 'e') goto yy3;
					goto yy95;
				} else {
					if (yych == 'h') goto yy95;
					goto yy3;
				}
			} else {
				if (yych <= 'm') {
					if (yych <= 'j') goto yy95;
					if (yych <= 'l') goto yy3;
					goto yy95;
				} else {
					if (yych <= 'n') goto yy87;
					if (yych <= 'p') goto yy95;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 'r') goto yy88;
					if (yych <= 's') goto yy89;
					goto yy90;
				} else {
					if (yych == 'v') goto yy3;
					goto yy95;
				}
			} else {
				if (yych <= 0xC1) {
					if (yych == 'y') goto yy95;
					goto yy3;
				} else {
					if (yych <= 0xC2) goto yy101;
					if (yych == 0xE2) goto yy102;
					goto yy3;
				}
			}
		}
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy106;
	}
	if (yych == '-') goto yy105;
	goto yy3;
yy15:
	YYDEBUG(15, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy107;
			if (yych >= 'A') goto yy108;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy109;
				goto yy108;
			} else {
				if (yych <= 'P') goto yy110;
				if (yych <= 'T') goto yy108;
				goto yy111;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy108;
			} else {
				if (yych == 'g') goto yy113;
				goto yy112;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy114;
				goto yy112;
			} else {
				if (yych <= 'u') goto yy115;
				if (yych <= 'z') goto yy112;
			}
		}
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
#line 1886 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		timelib_eat_spaces(&ptr);
		s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 1788 "<stdout>"
yy17:
	YYDEBUG(17, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy107;
		if (yych <= '@') goto yy16;
		goto yy116;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy108;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy117;
			if (yych <= 'z') goto yy112;
			goto yy16;
		}
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy108;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy112;
		goto yy16;
	}
yy19:
	YYDEBUG(19, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy108;
			goto yy118;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy108;
			if (yych <= '`') goto yy16;
			goto yy112;
		} else {
			if (yych <= 'e') goto yy119;
			if (yych <= 'z') goto yy112;
			goto yy16;
		}
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == 'I') goto yy120;
			if (yych <= 'K') goto yy108;
			goto yy121;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy108;
			if (yych <= '`') goto yy16;
			if (yych <= 'h') goto yy112;
			goto yy122;
		} else {
			if (yych == 'l') goto yy123;
			if (yych <= 'z') goto yy112;
			goto yy16;
		}
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy107;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'D') goto yy108;
				goto yy124;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy125;
				goto yy108;
			} else {
				if (yych <= 'O') goto yy126;
				if (yych <= 'Q') goto yy108;
				goto yy127;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy108;
				if (yych <= '`') goto yy16;
				goto yy112;
			} else {
				if (yych <= 'e') goto yy128;
				if (yych <= 'h') goto yy112;
				goto yy129;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy130;
				goto yy112;
			} else {
				if (yych <= 'r') goto yy131;
				if (yych <= 'z') goto yy112;
				goto yy16;
			}
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy107;
		if (yych <= '@') goto yy16;
		goto yy108;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy132;
			goto yy108;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy112;
			goto yy16;
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy107;
				goto yy16;
			} else {
				if (yych == '/') goto yy16;
				goto yy134;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy16;
				goto yy108;
			} else {
				if (yych <= 'I') goto yy138;
				if (yych <= 'U') goto yy108;
				goto yy139;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy139;
				goto yy108;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy112;
				goto yy16;
			}
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych <= 'A') goto yy140;
			if (yych <= 'T') goto yy108;
			goto yy141;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy108;
			if (yych <= '`') goto yy16;
			goto yy142;
		} else {
			if (yych == 'u') goto yy143;
			if (yych <= 'z') goto yy112;
			goto yy16;
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy107;
		if (yych <= '@') goto yy16;
		goto yy144;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy108;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy145;
			if (yych <= 'z') goto yy112;
			goto yy16;
		}
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy107;
			if (yych <= '@') goto yy16;
			goto yy146;
		} else {
			if (yych == 'I') goto yy147;
			if (yych <= 'N') goto yy108;
			goto yy148;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy108;
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy149;
			goto yy112;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy150;
				goto yy112;
			} else {
				if (yych <= 'o') goto yy151;
				if (yych <= 'z') goto yy112;
				goto yy16;
			}
		}
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy107;
			if (yych <= '@') goto yy16;
			goto yy108;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy152;
				goto yy108;
			} else {
				if (yych <= 'I') goto yy153;
				if (yych <= 'N') goto yy108;
				goto yy154;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy108;
				goto yy16;
			} else {
				if (yych == 'e') goto yy155;
				goto yy112;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy156;
				goto yy112;
			} else {
				if (yych <= 'o') goto yy157;
				if (yych <= 'z') goto yy112;
				goto yy16;
			}
		}
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'B') goto yy108;
			goto yy158;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy108;
			if (yych <= '`') goto yy16;
			goto yy112;
		} else {
			if (yych <= 'c') goto yy159;
			if (yych <= 'z') goto yy112;
			goto yy16;
		}
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy108;
			goto yy160;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy108;
			if (yych <= '`') goto yy16;
			goto yy112;
		} else {
			if (yych <= 'r') goto yy161;
			if (yych <= 'z') goto yy112;
			goto yy16;
		}
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy107;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'A') goto yy162;
				goto yy108;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy163;
				goto yy108;
			} else {
				if (yych <= 'I') goto yy164;
				if (yych <= 'T') goto yy108;
				goto yy148;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy108;
				goto yy16;
			} else {
				if (yych <= 'a') goto yy165;
				if (yych <= 'd') goto yy112;
				goto yy166;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy167;
				goto yy112;
			} else {
				if (yych <= 'u') goto yy151;
				if (yych <= 'z') goto yy112;
				goto yy16;
			}
		}
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy107;
		case '0':
		case '1': goto yy168;
		case '2': goto yy170;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy171;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'X':
		case 'Y':
		case 'Z': goto yy108;
		case 'E': goto yy153;
		case 'H': goto yy172;
		case 'O': goto yy173;
		case 'U': goto yy174;
		case 'W': goto yy175;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'x':
		case 'y':
		case 'z': goto yy112;
		case 'e': goto yy156;
		case 'h': goto yy176;
		case 'o': goto yy177;
		case 'u': goto yy178;
		case 'w': goto yy179;
		default: goto yy16;
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy134;
			if (yych <= 0x1F) goto yy16;
			goto yy134;
		} else {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy134;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy134;
			if (yych <= '@') goto yy16;
			goto yy108;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy180;
				goto yy108;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy112;
				goto yy16;
			}
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy108;
			goto yy181;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy108;
			if (yych <= '`') goto yy16;
			goto yy112;
		} else {
			if (yych <= 'e') goto yy182;
			if (yych <= 'z') goto yy112;
			goto yy16;
		}
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy134;
			if (yych <= 0x1F) goto yy16;
			goto yy134;
		} else {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy134;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy134;
			if (yych <= '@') goto yy16;
			goto yy108;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy138;
				goto yy108;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy112;
				goto yy16;
			}
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy108;
			goto yy183;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy108;
			if (yych <= '`') goto yy16;
			goto yy112;
		} else {
			if (yych <= 'e') goto yy184;
			if (yych <= 'z') goto yy112;
			goto yy16;
		}
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy107;
			if (yych <= '@') goto yy16;
			goto yy108;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy109;
				goto yy108;
			} else {
				if (yych <= 'P') goto yy110;
				if (yych <= 'T') goto yy108;
				goto yy111;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy108;
				goto yy16;
			} else {
				if (yych == 'g') goto yy109;
				goto yy108;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy110;
				goto yy108;
			} else {
				if (yych <= 'u') goto yy111;
				if (yych <= 'z') goto yy108;
				goto yy16;
			}
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy107;
		if (yych <= '@') goto yy16;
		goto yy116;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy108;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy116;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy108;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy108;
		goto yy16;
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy108;
			goto yy118;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy108;
			if (yych <= '`') goto yy16;
			goto yy108;
		} else {
			if (yych <= 'e') goto yy118;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == 'I') goto yy120;
			if (yych <= 'K') goto yy108;
			goto yy121;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy108;
			if (yych <= '`') goto yy16;
			if (yych <= 'h') goto yy108;
			goto yy120;
		} else {
			if (yych == 'l') goto yy121;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy107;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'D') goto yy108;
				goto yy124;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy125;
				goto yy108;
			} else {
				if (yych <= 'O') goto yy126;
				if (yych <= 'Q') goto yy108;
				goto yy127;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy108;
				if (yych <= '`') goto yy16;
				goto yy108;
			} else {
				if (yych <= 'e') goto yy124;
				if (yych <= 'h') goto yy108;
				goto yy125;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy126;
				goto yy108;
			} else {
				if (yych <= 'r') goto yy127;
				if (yych <= 'z') goto yy108;
				goto yy16;
			}
		}
	}
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych <= 'A') goto yy140;
			if (yych <= 'T') goto yy108;
			goto yy141;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy108;
			if (yych <= '`') goto yy16;
			goto yy140;
		} else {
			if (yych == 'u') goto yy141;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy107;
		if (yych <= '@') goto yy16;
		goto yy144;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy108;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy144;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy107;
			if (yych <= '@') goto yy16;
			goto yy146;
		} else {
			if (yych == 'I') goto yy147;
			if (yych <= 'N') goto yy108;
			goto yy148;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy108;
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy146;
			goto yy108;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy147;
				goto yy108;
			} else {
				if (yych <= 'o') goto yy148;
				if (yych <= 'z') goto yy108;
				goto yy16;
			}
		}
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy107;
			if (yych <= '@') goto yy16;
			goto yy108;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy152;
				goto yy108;
			} else {
				if (yych <= 'I') goto yy153;
				if (yych <= 'N') goto yy108;
				goto yy154;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy108;
				goto yy16;
			} else {
				if (yych == 'e') goto yy152;
				goto yy108;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy153;
				goto yy108;
			} else {
				if (yych <= 'o') goto yy154;
				if (yych <= 'z') goto yy108;
				goto yy16;
			}
		}
	}
yy46:
	YYDEBUG(46, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'B') goto yy108;
			goto yy158;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy108;
			if (yych <= '`') goto yy16;
			goto yy108;
		} else {
			if (yych <= 'c') goto yy158;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy108;
			goto yy160;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy108;
			if (yych <= '`') goto yy16;
			goto yy108;
		} else {
			if (yych <= 'r') goto yy160;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy48:
	YYDEBUG(48, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy107;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'A') goto yy162;
				goto yy108;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy163;
				goto yy108;
			} else {
				if (yych <= 'I') goto yy164;
				if (yych <= 'T') goto yy108;
				goto yy148;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy108;
				goto yy16;
			} else {
				if (yych <= 'a') goto yy162;
				if (yych <= 'd') goto yy108;
				goto yy163;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy164;
				goto yy108;
			} else {
				if (yych <= 'u') goto yy148;
				if (yych <= 'z') goto yy108;
				goto yy16;
			}
		}
	}
yy49:
	YYDEBUG(49, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy107;
		case '0':
		case '1': goto yy168;
		case '2': goto yy170;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy171;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'x':
		case 'y':
		case 'z': goto yy108;
		case 'E':
		case 'e': goto yy153;
		case 'H':
		case 'h': goto yy172;
		case 'O':
		case 'o': goto yy173;
		case 'U':
		case 'u': goto yy174;
		case 'W':
		case 'w': goto yy175;
		default: goto yy16;
	}
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy108;
			goto yy181;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy108;
			if (yych <= '`') goto yy16;
			goto yy108;
		} else {
			if (yych <= 'e') goto yy181;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy51:
	YYDEBUG(51, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy108;
			goto yy183;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy108;
			if (yych <= '`') goto yy16;
			goto yy108;
		} else {
			if (yych <= 'e') goto yy183;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy52:
	YYDEBUG(52, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xA0) goto yy185;
	goto yy3;
yy53:
	YYDEBUG(53, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 0x80) goto yy186;
	goto yy3;
yy54:
	YYDEBUG(54, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '9') goto yy189;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy55:
	YYDEBUG(55, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 16) {
		if (yyaccept <= 8) {
			if (yyaccept <= 4) {
				if (yyaccept <= 2) {
					if (yyaccept <= 1) {
						if (yyaccept == 0) {
							goto yy5;
						} else {
							goto yy3;
						}
					} else {
						goto yy16;
					}
				} else {
					if (yyaccept == 3) {
						goto yy75;
					} else {
						goto yy169;
					}
				}
			} else {
				if (yyaccept <= 6) {
					if (yyaccept == 5) {
						goto yy216;
					} else {
						goto yy251;
					}
				} else {
					if (yyaccept == 7) {
						goto yy286;
					} else {
						goto yy284;
					}
				}
			}
		} else {
			if (yyaccept <= 12) {
				if (yyaccept <= 10) {
					if (yyaccept == 9) {
						goto yy306;
					} else {
						goto yy316;
					}
				} else {
					if (yyaccept == 11) {
						goto yy342;
					} else {
						goto yy411;
					}
				}
			} else {
				if (yyaccept <= 14) {
					if (yyaccept == 13) {
						goto yy413;
					} else {
						goto yy515;
					}
				} else {
					if (yyaccept == 15) {
						goto yy556;
					} else {
						goto yy709;
					}
				}
			}
		}
	} else {
		if (yyaccept <= 25) {
			if (yyaccept <= 21) {
				if (yyaccept <= 19) {
					if (yyaccept <= 18) {
						if (yyaccept == 17) {
							goto yy726;
						} else {
							goto yy739;
						}
					} else {
						goto yy764;
					}
				} else {
					if (yyaccept == 20) {
						goto yy836;
					} else {
						goto yy912;
					}
				}
			} else {
				if (yyaccept <= 23) {
					if (yyaccept == 22) {
						goto yy589;
					} else {
						goto yy928;
					}
				} else {
					if (yyaccept == 24) {
						goto yy968;
					} else {
						goto yy1010;
					}
				}
			}
		} else {
			if (yyaccept <= 29) {
				if (yyaccept <= 27) {
					if (yyaccept == 26) {
						goto yy1028;
					} else {
						goto yy1033;
					}
				} else {
					if (yyaccept == 28) {
						goto yy1090;
					} else {
						goto yy1125;
					}
				}
			} else {
				if (yyaccept <= 31) {
					if (yyaccept == 30) {
						goto yy1151;
					} else {
						goto yy1154;
					}
				} else {
					if (yyaccept == 32) {
						goto yy1301;
					} else {
						goto yy1344;
					}
				}
			}
		}
	}
yy56:
	YYDEBUG(56, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 25) YYFILL(25);
	yych = *YYCURSOR;
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy56;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy56;
		if (yych <= '/') goto yy55;
		if (yych <= '9') goto yy54;
		goto yy55;
	}
yy57:
	YYDEBUG(57, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 25) YYFILL(25);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy56;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy56;
		if (yych <= '/') goto yy55;
		if (yych <= '9') goto yy54;
		goto yy55;
	}
yy58:
	YYDEBUG(58, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy16;
					goto yy188;
				} else {
					if (yych == ' ') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= ':') {
					if (yych <= '9') goto yy194;
					goto yy195;
				} else {
					if (yych == 'D') goto yy188;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy188;
					goto yy16;
				} else {
					if (yych <= 'H') goto yy188;
					if (yych <= 'L') goto yy16;
					goto yy188;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy16;
					goto yy188;
				} else {
					if (yych == 'W') goto yy188;
					goto yy16;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy188;
					goto yy16;
				} else {
					if (yych == 'e') goto yy16;
					goto yy188;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy16;
					goto yy188;
				} else {
					if (yych == 'm') goto yy188;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy188;
					goto yy16;
				} else {
					if (yych == 'x') goto yy16;
					goto yy188;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy16;
					goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
					goto yy16;
				}
			}
		}
	}
yy59:
	YYDEBUG(59, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy16;
					goto yy188;
				} else {
					if (yych == ' ') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= '5') {
					if (yych <= '4') goto yy194;
					goto yy196;
				} else {
					if (yych <= '9') goto yy197;
					if (yych <= ':') goto yy195;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy188;
					goto yy16;
				} else {
					if (yych == 'G') goto yy16;
					goto yy188;
				}
			} else {
				if (yych <= 'R') {
					if (yych == 'M') goto yy188;
					goto yy16;
				} else {
					if (yych == 'V') goto yy16;
					goto yy188;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') {
					if (yych <= 'X') goto yy16;
					goto yy188;
				} else {
					if (yych == 'd') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy188;
					goto yy16;
				} else {
					if (yych <= 'h') goto yy188;
					if (yych <= 'l') goto yy16;
					goto yy188;
				}
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'u') {
					if (yych <= 'r') goto yy16;
					goto yy188;
				} else {
					if (yych == 'w') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 'y') goto yy188;
					if (yych <= 0xC1) goto yy16;
					goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
					goto yy16;
				}
			}
		}
	}
yy60:
	YYDEBUG(60, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy16;
					goto yy188;
				} else {
					if (yych == ' ') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '5') goto yy196;
					goto yy197;
				} else {
					if (yych <= ':') goto yy195;
					if (yych <= 'C') goto yy16;
					goto yy188;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy16;
					goto yy188;
				} else {
					if (yych == 'H') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy188;
					goto yy16;
				} else {
					if (yych == 'V') goto yy16;
					goto yy188;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') {
					if (yych <= 'X') goto yy16;
					goto yy188;
				} else {
					if (yych == 'd') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy188;
					goto yy16;
				} else {
					if (yych <= 'h') goto yy188;
					if (yych <= 'l') goto yy16;
					goto yy188;
				}
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'u') {
					if (yych <= 'r') goto yy16;
					goto yy188;
				} else {
					if (yych == 'w') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 'y') goto yy188;
					if (yych <= 0xC1) goto yy16;
					goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
					goto yy16;
				}
			}
		}
	}
yy61:
	YYDEBUG(61, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy63;
	if (yych <= '0') goto yy200;
	if (yych <= '1') goto yy201;
	if (yych <= '9') goto yy202;
	goto yy63;
yy62:
	YYDEBUG(62, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy63:
	YYDEBUG(63, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy62;
					goto yy55;
				} else {
					if (yych <= ' ') goto yy62;
					if (yych <= ',') goto yy55;
					goto yy198;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy70;
					goto yy55;
				} else {
					if (yych <= 'D') goto yy71;
					if (yych == 'F') goto yy72;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy73;
					if (yych <= 'I') goto yy74;
					goto yy76;
				} else {
					if (yych <= 'L') goto yy55;
					if (yych <= 'M') goto yy77;
					goto yy78;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy79;
					if (yych <= 'R') goto yy55;
					goto yy80;
				} else {
					if (yych <= 'T') goto yy81;
					if (yych <= 'U') goto yy82;
					if (yych <= 'V') goto yy83;
					goto yy84;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy85;
					if (yych <= 'Y') goto yy86;
					goto yy55;
				} else {
					if (yych <= 'a') goto yy70;
					if (yych <= 'c') goto yy55;
					goto yy71;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy72;
					goto yy55;
				} else {
					if (yych <= 'h') goto yy73;
					if (yych == 'j') goto yy76;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy77;
					if (yych <= 'n') goto yy78;
					goto yy79;
				} else {
					if (yych <= 'r') goto yy55;
					if (yych <= 's') goto yy80;
					if (yych <= 't') goto yy81;
					goto yy82;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy84;
					goto yy55;
				} else {
					if (yych <= 'y') goto yy86;
					if (yych == 0xC2) goto yy203;
					goto yy55;
				}
			}
		}
	}
yy64:
	YYDEBUG(64, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy199;
	if (yych <= '0') goto yy204;
	if (yych <= '1') goto yy205;
	if (yych <= '9') goto yy206;
	goto yy199;
yy65:
	YYDEBUG(65, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy199;
		if (yych <= '0') goto yy211;
		goto yy212;
	} else {
		if (yych <= '5') goto yy213;
		if (yych <= '9') goto yy214;
		goto yy199;
	}
yy66:
	YYDEBUG(66, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2': goto yy215;
		case '3': goto yy217;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy218;
		case 'A':
		case 'a': goto yy219;
		case 'D':
		case 'd': goto yy220;
		case 'F':
		case 'f': goto yy221;
		case 'J':
		case 'j': goto yy222;
		case 'M':
		case 'm': goto yy223;
		case 'N':
		case 'n': goto yy224;
		case 'O':
		case 'o': goto yy225;
		case 'S':
		case 's': goto yy226;
		default: goto yy55;
	}
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'm') {
		if (yych <= '.') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy63;
				goto yy61;
			} else {
				if (yych <= ',') goto yy63;
				if (yych <= '-') goto yy227;
				goto yy65;
			}
		} else {
			if (yych <= '5') {
				if (yych <= '/') goto yy66;
				goto yy228;
			} else {
				if (yych <= '9') goto yy229;
				if (yych <= ':') goto yy69;
				goto yy63;
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'q') {
				if (yych <= 'n') goto yy87;
				goto yy63;
			} else {
				if (yych <= 'r') goto yy88;
				if (yych <= 's') goto yy89;
				goto yy90;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy63;
				goto yy91;
			} else {
				if (yych == 0xE2) goto yy92;
				goto yy63;
			}
		}
	}
yy68:
	YYDEBUG(68, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'm') {
		if (yych <= '.') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy95;
				goto yy93;
			} else {
				if (yych <= ',') goto yy95;
				if (yych <= '-') goto yy227;
				goto yy96;
			}
		} else {
			if (yych <= '5') {
				if (yych <= '/') goto yy66;
				goto yy228;
			} else {
				if (yych <= '9') goto yy229;
				if (yych <= ':') goto yy98;
				goto yy95;
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'q') {
				if (yych <= 'n') goto yy87;
				goto yy95;
			} else {
				if (yych <= 'r') goto yy88;
				if (yych <= 's') goto yy89;
				goto yy90;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy95;
				goto yy101;
			} else {
				if (yych == 0xE2) goto yy102;
				goto yy95;
			}
		}
	}
yy69:
	YYDEBUG(69, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy230;
	if (yych <= '9') goto yy231;
	goto yy55;
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy232;
		if (yych <= 'T') goto yy55;
		goto yy233;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy55;
			goto yy232;
		} else {
			if (yych == 'u') goto yy233;
			goto yy55;
		}
	}
yy71:
	YYDEBUG(71, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy234;
		if (yych <= 'D') goto yy55;
		goto yy235;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy234;
		} else {
			if (yych == 'e') goto yy235;
			goto yy55;
		}
	}
yy72:
	YYDEBUG(72, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy236;
			goto yy55;
		} else {
			if (yych <= 'O') goto yy237;
			if (yych <= 'Q') goto yy55;
			goto yy238;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy236;
			goto yy55;
		} else {
			if (yych <= 'o') goto yy237;
			if (yych == 'r') goto yy238;
			goto yy55;
		}
	}
yy73:
	YYDEBUG(73, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy239;
	if (yych == 'o') goto yy239;
	goto yy55;
yy74:
	YYDEBUG(74, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy240;
		} else {
			if (yych <= ' ') goto yy240;
			if (yych <= ',') goto yy75;
			if (yych <= '.') goto yy240;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy241;
			if (yych == 'I') goto yy243;
		} else {
			if (yych == 'W') goto yy75;
			if (yych <= 'X') goto yy244;
		}
	}
yy75:
	YYDEBUG(75, *YYCURSOR);
#line 1633 "parse_date.re"
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		timelib_skip_day_suffix(&ptr);
		s->time->m = timelib_get_month(&ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 3602 "<stdout>"
yy76:
	YYDEBUG(76, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy245;
		if (yych <= 'T') goto yy55;
		goto yy246;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy245;
		} else {
			if (yych == 'u') goto yy246;
			goto yy55;
		}
	}
yy77:
	YYDEBUG(77, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy247;
			if (yych <= 'H') goto yy55;
			goto yy248;
		} else {
			if (yych == 'O') goto yy249;
			if (yych <= 'R') goto yy55;
			goto yy250;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy247;
			if (yych <= 'h') goto yy55;
			goto yy248;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy55;
				goto yy249;
			} else {
				if (yych == 's') goto yy250;
				goto yy55;
			}
		}
	}
yy78:
	YYDEBUG(78, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy252;
	if (yych == 'o') goto yy252;
	goto yy55;
yy79:
	YYDEBUG(79, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy253;
	if (yych == 'c') goto yy253;
	goto yy55;
yy80:
	YYDEBUG(80, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy254;
			goto yy55;
		} else {
			if (yych <= 'E') goto yy255;
			if (yych <= 'T') goto yy55;
			goto yy256;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy254;
			goto yy55;
		} else {
			if (yych <= 'e') goto yy255;
			if (yych == 'u') goto yy256;
			goto yy55;
		}
	}
yy81:
	YYDEBUG(81, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy257;
		if (yych <= 'T') goto yy55;
		goto yy258;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy55;
			goto yy257;
		} else {
			if (yych == 'u') goto yy258;
			goto yy55;
		}
	}
yy82:
	YYDEBUG(82, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy259;
	if (yych == 's') goto yy259;
	goto yy55;
yy83:
	YYDEBUG(83, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy75;
			goto yy240;
		} else {
			if (yych == ' ') goto yy240;
			goto yy75;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy240;
			if (yych <= '/') goto yy75;
			goto yy241;
		} else {
			if (yych == 'I') goto yy85;
			goto yy75;
		}
	}
yy84:
	YYDEBUG(84, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy260;
	if (yych == 'e') goto yy260;
	goto yy55;
yy85:
	YYDEBUG(85, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy75;
			goto yy240;
		} else {
			if (yych == ' ') goto yy240;
			goto yy75;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy240;
			if (yych <= '/') goto yy75;
			goto yy241;
		} else {
			if (yych == 'I') goto yy243;
			goto yy75;
		}
	}
yy86:
	YYDEBUG(86, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy261;
	if (yych == 'e') goto yy261;
	goto yy55;
yy87:
	YYDEBUG(87, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy252;
		goto yy55;
	} else {
		if (yych <= 'd') goto yy262;
		if (yych == 'o') goto yy252;
		goto yy55;
	}
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy262;
	goto yy55;
yy89:
	YYDEBUG(89, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy254;
			goto yy55;
		} else {
			if (yych <= 'E') goto yy255;
			if (yych == 'U') goto yy256;
			goto yy55;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy254;
			if (yych <= 'd') goto yy55;
			goto yy255;
		} else {
			if (yych <= 's') goto yy55;
			if (yych <= 't') goto yy262;
			if (yych <= 'u') goto yy256;
			goto yy55;
		}
	}
yy90:
	YYDEBUG(90, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy257;
		if (yych <= 'T') goto yy55;
		goto yy258;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy55;
			goto yy263;
		} else {
			if (yych == 'u') goto yy258;
			goto yy55;
		}
	}
yy91:
	YYDEBUG(91, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy264;
	if (yych == 0xB5) goto yy265;
	goto yy55;
yy92:
	YYDEBUG(92, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy266;
	goto yy55;
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy95;
	if (yych <= '0') goto yy200;
	if (yych <= '1') goto yy201;
	if (yych <= '9') goto yy202;
	goto yy95;
yy94:
	YYDEBUG(94, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy95:
	YYDEBUG(95, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy94;
					goto yy55;
				} else {
					if (yych <= ' ') goto yy94;
					if (yych <= ',') goto yy55;
					goto yy198;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy99;
					goto yy55;
				} else {
					if (yych <= 'D') goto yy71;
					if (yych == 'F') goto yy72;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy73;
					if (yych <= 'I') goto yy74;
					goto yy76;
				} else {
					if (yych <= 'L') goto yy55;
					if (yych <= 'M') goto yy77;
					if (yych <= 'N') goto yy78;
					goto yy79;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'P') goto yy100;
					if (yych <= 'R') goto yy55;
					goto yy80;
				} else {
					if (yych <= 'T') goto yy81;
					if (yych <= 'U') goto yy82;
					if (yych <= 'V') goto yy83;
					goto yy84;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy85;
					if (yych <= 'Y') goto yy86;
					goto yy55;
				} else {
					if (yych <= 'a') goto yy99;
					if (yych == 'd') goto yy71;
					goto yy55;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'f') goto yy72;
					if (yych <= 'g') goto yy55;
					goto yy73;
				} else {
					if (yych == 'j') goto yy76;
					if (yych <= 'l') goto yy55;
					goto yy77;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') {
					if (yych <= 'n') goto yy78;
					if (yych <= 'o') goto yy79;
					goto yy100;
				} else {
					if (yych <= 'r') goto yy55;
					if (yych <= 's') goto yy80;
					if (yych <= 't') goto yy81;
					goto yy82;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy84;
					goto yy55;
				} else {
					if (yych <= 'y') goto yy86;
					if (yych == 0xC2) goto yy203;
					goto yy55;
				}
			}
		}
	}
yy96:
	YYDEBUG(96, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy199;
		if (yych <= '0') goto yy267;
		goto yy268;
	} else {
		if (yych <= '5') goto yy269;
		if (yych <= '9') goto yy270;
		goto yy199;
	}
yy97:
	YYDEBUG(97, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'm') {
		if (yych <= '.') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy63;
				goto yy61;
			} else {
				if (yych <= ',') goto yy63;
				if (yych <= '-') goto yy227;
				goto yy65;
			}
		} else {
			if (yych <= '5') {
				if (yych <= '/') goto yy271;
				goto yy228;
			} else {
				if (yych <= '9') goto yy229;
				if (yych <= ':') goto yy69;
				goto yy63;
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'q') {
				if (yych <= 'n') goto yy87;
				goto yy63;
			} else {
				if (yych <= 'r') goto yy88;
				if (yych <= 's') goto yy89;
				goto yy90;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy63;
				goto yy91;
			} else {
				if (yych == 0xE2) goto yy92;
				goto yy63;
			}
		}
	}
yy98:
	YYDEBUG(98, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy272;
	if (yych <= '9') goto yy273;
	goto yy55;
yy99:
	YYDEBUG(99, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy274;
			goto yy55;
		} else {
			if (yych <= 'M') goto yy275;
			if (yych == 'P') goto yy232;
			goto yy55;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy233;
			if (yych == 'm') goto yy275;
			goto yy55;
		} else {
			if (yych <= 'p') goto yy232;
			if (yych == 'u') goto yy233;
			goto yy55;
		}
	}
yy100:
	YYDEBUG(100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy274;
		goto yy55;
	} else {
		if (yych <= 'M') goto yy275;
		if (yych == 'm') goto yy275;
		goto yy55;
	}
yy101:
	YYDEBUG(101, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy276;
	if (yych == 0xB5) goto yy265;
	goto yy55;
yy102:
	YYDEBUG(102, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy277;
	goto yy55;
yy103:
	YYDEBUG(103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'n') {
		if (yych <= '-') {
			if (yych == '\t') goto yy61;
			if (yych <= ',') goto yy63;
			goto yy227;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy278;
				goto yy271;
			} else {
				if (yych <= '9') goto yy229;
				if (yych <= 'm') goto yy63;
				goto yy87;
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'q') goto yy63;
			if (yych <= 'r') goto yy88;
			if (yych <= 's') goto yy89;
			goto yy90;
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy63;
				goto yy91;
			} else {
				if (yych == 0xE2) goto yy92;
				goto yy63;
			}
		}
	}
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy279;
		if (yych <= '/') goto yy188;
		goto yy229;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy105:
	YYDEBUG(105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy106;
	}
	goto yy55;
yy106:
	YYDEBUG(106, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 7) YYFILL(7);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy106;
	}
	if (yych == '.') goto yy280;
#line 1207 "parse_date.re"
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_signed_nr(s, &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->us = 0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 4140 "<stdout>"
yy107:
	YYDEBUG(107, *YYCURSOR);
	++YYCURSOR;
	goto yy16;
yy108:
	YYDEBUG(108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy282;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy282;
		goto yy16;
	}
yy109:
	YYDEBUG(109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy282;
			goto yy283;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'o') goto yy283;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy110:
	YYDEBUG(110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy282;
			goto yy285;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'r') goto yy285;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy111:
	YYDEBUG(111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'F') goto yy282;
			goto yy287;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'g') goto yy287;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy112:
	YYDEBUG(112, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			goto yy288;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy16;
			if (yych <= 'Z') goto yy282;
			goto yy16;
		} else {
			if (yych <= '_') goto yy288;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy289;
			goto yy16;
		}
	}
yy113:
	YYDEBUG(113, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy283;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 'o') goto yy290;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy114:
	YYDEBUG(114, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy285;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 'r') goto yy291;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy115:
	YYDEBUG(115, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy287;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 'g') goto yy292;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy116:
	YYDEBUG(116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'B') goto yy282;
			goto yy293;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'c') goto yy293;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy117:
	YYDEBUG(117, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy293;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 'c') goto yy294;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy118:
	YYDEBUG(118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'B') goto yy282;
			goto yy295;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'c') goto yy295;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy119:
	YYDEBUG(119, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy295;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 'c') goto yy296;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy120:
	YYDEBUG(120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'F') goto yy282;
			goto yy297;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'g') goto yy297;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy121:
	YYDEBUG(121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy282;
			goto yy298;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'e') goto yy298;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy122:
	YYDEBUG(122, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy297;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 'g') goto yy299;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy123:
	YYDEBUG(123, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy298;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 'e') goto yy300;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy124:
	YYDEBUG(124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'A') goto yy282;
			goto yy301;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'b') goto yy301;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy125:
	YYDEBUG(125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == 'F') goto yy302;
			if (yych <= 'Q') goto yy282;
			goto yy303;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			if (yych <= 'e') goto yy282;
			goto yy302;
		} else {
			if (yych == 'r') goto yy303;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy126:
	YYDEBUG(126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'T') goto yy282;
			goto yy304;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'u') goto yy304;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy127:
	YYDEBUG(127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '@') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == 'I') goto yy305;
			if (yych <= 'N') goto yy282;
			goto yy307;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			if (yych <= 'h') goto yy282;
			goto yy305;
		} else {
			if (yych == 'o') goto yy307;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy128:
	YYDEBUG(128, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy301;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 'b') goto yy308;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy129:
	YYDEBUG(129, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy107;
			} else {
				if (yych == '-') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy288;
				goto yy16;
			} else {
				if (yych == 'F') goto yy302;
				goto yy282;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'R') goto yy303;
				goto yy282;
			} else {
				if (yych == '_') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'f') goto yy309;
				goto yy289;
			} else {
				if (yych <= 'r') goto yy310;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy130:
	YYDEBUG(130, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy304;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 'u') goto yy311;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy131:
	YYDEBUG(131, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy107;
			} else {
				if (yych == '-') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy288;
				goto yy16;
			} else {
				if (yych == 'I') goto yy305;
				goto yy282;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'O') goto yy307;
				goto yy282;
			} else {
				if (yych == '_') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy312;
				goto yy289;
			} else {
				if (yych <= 'o') goto yy313;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy132:
	YYDEBUG(132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy107;
		if (yych <= '@') goto yy16;
		goto yy282;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'T') goto yy314;
			goto yy282;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy133:
	YYDEBUG(133, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 26) YYFILL(26);
	yych = *YYCURSOR;
yy134:
	YYDEBUG(134, *YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy133;
	}
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy135;
	if (yych <= '3') goto yy136;
	if (yych <= '9') goto yy137;
	goto yy55;
yy135:
	YYDEBUG(135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy315;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy317;
				if (yych <= 0x1F) goto yy55;
				goto yy317;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy317;
				goto yy55;
			} else {
				if (yych <= '.') goto yy317;
				if (yych <= '/') goto yy55;
				goto yy319;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy55;
				goto yy317;
			} else {
				if (yych == 'h') goto yy317;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy320;
				if (yych <= 'q') goto yy55;
				goto yy320;
			} else {
				if (yych <= 's') goto yy321;
				if (yych <= 't') goto yy322;
				goto yy55;
			}
		}
	}
yy136:
	YYDEBUG(136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy315;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy317;
				if (yych <= 0x1F) goto yy55;
				goto yy317;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy317;
				goto yy55;
			} else {
				if (yych <= '.') goto yy317;
				if (yych <= '/') goto yy55;
				goto yy319;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy323;
				if (yych <= 'c') goto yy55;
				goto yy317;
			} else {
				if (yych == 'h') goto yy317;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy320;
				if (yych <= 'q') goto yy55;
				goto yy320;
			} else {
				if (yych <= 's') goto yy321;
				if (yych <= 't') goto yy322;
				goto yy55;
			}
		}
	}
yy137:
	YYDEBUG(137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy315;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy317;
				if (yych <= 0x1F) goto yy55;
				goto yy317;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy317;
				goto yy55;
			} else {
				if (yych <= '.') goto yy317;
				if (yych <= '/') goto yy55;
				goto yy323;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy55;
				goto yy317;
			} else {
				if (yych == 'h') goto yy317;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy320;
				if (yych <= 'q') goto yy55;
				goto yy320;
			} else {
				if (yych <= 's') goto yy321;
				if (yych <= 't') goto yy322;
				goto yy55;
			}
		}
	}
yy138:
	YYDEBUG(138, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy134;
			if (yych <= 0x1F) goto yy16;
			goto yy134;
		} else {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy134;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy134;
			if (yych <= '@') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy324;
				goto yy282;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy282;
				goto yy16;
			}
		}
	}
yy139:
	YYDEBUG(139, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy134;
			goto yy16;
		} else {
			if (yych <= ' ') goto yy134;
			if (yych == ')') goto yy107;
			goto yy16;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy16;
			if (yych <= '9') goto yy134;
			goto yy16;
		} else {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy140:
	YYDEBUG(140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy282;
			goto yy325;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'n') goto yy325;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy141:
	YYDEBUG(141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == 'L') goto yy326;
			if (yych <= 'M') goto yy282;
			goto yy327;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			if (yych <= 'k') goto yy282;
			goto yy326;
		} else {
			if (yych == 'n') goto yy327;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy142:
	YYDEBUG(142, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy325;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 'n') goto yy328;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy143:
	YYDEBUG(143, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy107;
			} else {
				if (yych == '-') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy288;
				goto yy16;
			} else {
				if (yych == 'L') goto yy326;
				goto yy282;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'N') goto yy327;
				goto yy282;
			} else {
				if (yych == '_') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'l') goto yy329;
				goto yy289;
			} else {
				if (yych <= 'n') goto yy330;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy144:
	YYDEBUG(144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy282;
			goto yy331;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 's') goto yy331;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy145:
	YYDEBUG(145, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy331;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 's') goto yy332;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy146:
	YYDEBUG(146, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == 'R') goto yy333;
			if (yych <= 'X') goto yy282;
			goto yy334;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			if (yych <= 'q') goto yy282;
			goto yy333;
		} else {
			if (yych == 'y') goto yy334;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy147:
	YYDEBUG(147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy282;
			goto yy335;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'd') goto yy335;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy148:
	YYDEBUG(148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy282;
			goto yy305;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'n') goto yy305;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy149:
	YYDEBUG(149, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy107;
			} else {
				if (yych == '-') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy288;
				goto yy16;
			} else {
				if (yych == 'R') goto yy333;
				goto yy282;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'Y') goto yy334;
				goto yy282;
			} else {
				if (yych == '_') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'r') goto yy336;
				goto yy289;
			} else {
				if (yych <= 'y') goto yy337;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy150:
	YYDEBUG(150, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy335;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 'd') goto yy338;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy151:
	YYDEBUG(151, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy305;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 'n') goto yy312;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy152:
	YYDEBUG(152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'W') goto yy282;
			goto yy339;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'x') goto yy339;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy153:
	YYDEBUG(153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy282;
			goto yy302;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'n') goto yy302;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy154:
	YYDEBUG(154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy107;
			if (yych <= '@') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'O') goto yy340;
			if (yych <= 'U') goto yy282;
			if (yych <= 'V') goto yy295;
			goto yy341;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			if (yych <= 'n') goto yy282;
			goto yy340;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy282;
				goto yy295;
			} else {
				if (yych <= 'w') goto yy341;
				if (yych <= 'z') goto yy282;
				goto yy16;
			}
		}
	}
yy155:
	YYDEBUG(155, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy339;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 'x') goto yy343;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy156:
	YYDEBUG(156, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy302;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 'n') goto yy309;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy157:
	YYDEBUG(157, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy107;
			} else {
				if (yych == '-') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '/') goto yy288;
				if (yych <= '@') goto yy16;
				goto yy282;
			} else {
				if (yych <= 'O') goto yy340;
				if (yych <= 'U') goto yy282;
				goto yy295;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'W') goto yy341;
				if (yych <= 'Z') goto yy282;
				goto yy16;
			} else {
				if (yych <= '_') goto yy288;
				if (yych <= '`') goto yy16;
				goto yy289;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy344;
				if (yych <= 'u') goto yy289;
				goto yy296;
			} else {
				if (yych <= 'w') goto yy345;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy158:
	YYDEBUG(158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy282;
			goto yy346;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 't') goto yy346;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy159:
	YYDEBUG(159, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy346;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 't') goto yy347;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy160:
	YYDEBUG(160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy282;
			goto yy348;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'e') goto yy348;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy161:
	YYDEBUG(161, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy348;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 'e') goto yy349;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy162:
	YYDEBUG(162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy282;
			goto yy350;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 't') goto yy350;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy163:
	YYDEBUG(163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy107;
			if (yych <= '@') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy351;
				goto yy282;
			} else {
				if (yych <= 'P') goto yy352;
				if (yych <= 'U') goto yy282;
				goto yy353;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy282;
				goto yy16;
			} else {
				if (yych == 'c') goto yy351;
				goto yy282;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy352;
				goto yy282;
			} else {
				if (yych <= 'v') goto yy353;
				if (yych <= 'z') goto yy282;
				goto yy16;
			}
		}
	}
yy164:
	YYDEBUG(164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'W') goto yy282;
			goto yy302;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'x') goto yy302;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy165:
	YYDEBUG(165, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy350;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 't') goto yy354;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy166:
	YYDEBUG(166, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych <= ',') {
				if (yych == ')') goto yy107;
				goto yy16;
			} else {
				if (yych == '.') goto yy16;
				goto yy288;
			}
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy16;
				if (yych <= 'B') goto yy282;
				goto yy351;
			} else {
				if (yych == 'P') goto yy352;
				goto yy282;
			}
		}
	} else {
		if (yych <= 'b') {
			if (yych <= '^') {
				if (yych <= 'V') goto yy353;
				if (yych <= 'Z') goto yy282;
				goto yy16;
			} else {
				if (yych <= '_') goto yy288;
				if (yych <= '`') goto yy16;
				goto yy289;
			}
		} else {
			if (yych <= 'p') {
				if (yych <= 'c') goto yy355;
				if (yych <= 'o') goto yy289;
				goto yy356;
			} else {
				if (yych == 'v') goto yy357;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy167:
	YYDEBUG(167, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy302;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 'x') goto yy309;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy168:
	YYDEBUG(168, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy69;
	} else {
		if (yych <= '9') goto yy358;
		if (yych <= ':') goto yy69;
	}
yy169:
	YYDEBUG(169, *YYCURSOR);
#line 1374 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("timetiny24 | timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr(&ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr(&ptr, 2);

				if (*ptr == '.') {
					s->time->us = timelib_get_frac_nr(&ptr);
				}
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 5893 "<stdout>"
yy170:
	YYDEBUG(170, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy69;
		goto yy169;
	} else {
		if (yych <= '4') goto yy358;
		if (yych == ':') goto yy69;
		goto yy169;
	}
yy171:
	YYDEBUG(171, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy69;
	if (yych == ':') goto yy69;
	goto yy169;
yy172:
	YYDEBUG(172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == 'I') goto yy359;
			if (yych <= 'T') goto yy282;
			goto yy360;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			if (yych <= 'h') goto yy282;
			goto yy359;
		} else {
			if (yych == 'u') goto yy360;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy173:
	YYDEBUG(173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == 'D') goto yy361;
			if (yych <= 'L') goto yy282;
			goto yy362;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			if (yych <= 'c') goto yy282;
			goto yy361;
		} else {
			if (yych == 'm') goto yy362;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy174:
	YYDEBUG(174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy282;
			goto yy363;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'e') goto yy363;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy175:
	YYDEBUG(175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy282;
			goto yy364;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'e') goto yy364;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy176:
	YYDEBUG(176, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy107;
			} else {
				if (yych == '-') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy288;
				goto yy16;
			} else {
				if (yych == 'I') goto yy359;
				goto yy282;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'U') goto yy360;
				goto yy282;
			} else {
				if (yych == '_') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy365;
				goto yy289;
			} else {
				if (yych <= 'u') goto yy366;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy177:
	YYDEBUG(177, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy107;
			} else {
				if (yych == '-') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy288;
				goto yy16;
			} else {
				if (yych == 'D') goto yy361;
				goto yy282;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'M') goto yy362;
				goto yy282;
			} else {
				if (yych == '_') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= 'l') {
				if (yych == 'd') goto yy367;
				goto yy289;
			} else {
				if (yych <= 'm') goto yy368;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy178:
	YYDEBUG(178, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy363;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 'e') goto yy369;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy179:
	YYDEBUG(179, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy364;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 'e') goto yy370;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy180:
	YYDEBUG(180, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy134;
			if (yych <= 0x1F) goto yy16;
			goto yy134;
		} else {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy134;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy134;
			if (yych <= '@') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy371;
				goto yy282;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy282;
				goto yy16;
			}
		}
	}
yy181:
	YYDEBUG(181, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '@') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych <= 'C') goto yy282;
			if (yych <= 'D') goto yy372;
			goto yy373;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 'd') goto yy372;
			if (yych <= 'e') goto yy373;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy182:
	YYDEBUG(182, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy16;
				goto yy288;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'C') goto yy282;
				goto yy372;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'E') goto yy373;
				goto yy282;
			} else {
				if (yych == '_') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy289;
				goto yy374;
			} else {
				if (yych <= 'e') goto yy375;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy183:
	YYDEBUG(183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy282;
			goto yy376;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy16;
			goto yy282;
		} else {
			if (yych <= 's') goto yy376;
			if (yych <= 'z') goto yy282;
			goto yy16;
		}
	}
yy184:
	YYDEBUG(184, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy282;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy376;
			if (yych <= 'Z') goto yy282;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy16;
				goto yy289;
			} else {
				if (yych <= 's') goto yy377;
				if (yych <= 'z') goto yy289;
				goto yy16;
			}
		}
	}
yy185:
	YYDEBUG(185, *YYCURSOR);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xC2) goto yy378;
	goto yy5;
yy186:
	YYDEBUG(186, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy379;
	goto yy55;
yy187:
	YYDEBUG(187, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy188:
	YYDEBUG(188, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy187;
				if (yych <= 0x1F) goto yy55;
				goto yy187;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy55;
					goto yy190;
				} else {
					if (yych == 'F') goto yy191;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy73;
					goto yy55;
				} else {
					if (yych <= 'M') goto yy192;
					if (yych <= 'R') goto yy55;
					goto yy193;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy81;
					goto yy82;
				} else {
					if (yych == 'W') goto yy84;
					goto yy55;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy86;
					goto yy55;
				} else {
					if (yych <= 'd') goto yy190;
					if (yych <= 'e') goto yy55;
					goto yy191;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy55;
					goto yy73;
				} else {
					if (yych == 'm') goto yy192;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy193;
					goto yy81;
				} else {
					if (yych <= 'u') goto yy82;
					if (yych <= 'v') goto yy55;
					goto yy84;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy55;
					goto yy86;
				} else {
					if (yych == 0xC2) goto yy203;
					goto yy55;
				}
			}
		}
	}
yy189:
	YYDEBUG(189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '9') goto yy380;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy190:
	YYDEBUG(190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy234;
	if (yych == 'a') goto yy234;
	goto yy55;
yy191:
	YYDEBUG(191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy237;
		if (yych <= 'Q') goto yy55;
		goto yy238;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy55;
			goto yy237;
		} else {
			if (yych == 'r') goto yy238;
			goto yy55;
		}
	}
yy192:
	YYDEBUG(192, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy248;
			goto yy55;
		} else {
			if (yych <= 'O') goto yy249;
			if (yych <= 'R') goto yy55;
			goto yy250;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy248;
			goto yy55;
		} else {
			if (yych <= 'o') goto yy249;
			if (yych == 's') goto yy250;
			goto yy55;
		}
	}
yy193:
	YYDEBUG(193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy254;
			goto yy55;
		} else {
			if (yych <= 'E') goto yy381;
			if (yych <= 'T') goto yy55;
			goto yy256;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy254;
			goto yy55;
		} else {
			if (yych <= 'e') goto yy381;
			if (yych == 'u') goto yy256;
			goto yy55;
		}
	}
yy194:
	YYDEBUG(194, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy16;
					goto yy188;
				} else {
					if (yych == ' ') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '5') goto yy382;
					goto yy383;
				} else {
					if (yych <= ':') goto yy384;
					if (yych <= 'C') goto yy16;
					goto yy188;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy16;
					goto yy188;
				} else {
					if (yych == 'H') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy188;
					goto yy16;
				} else {
					if (yych == 'V') goto yy16;
					goto yy188;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') {
					if (yych <= 'X') goto yy16;
					goto yy188;
				} else {
					if (yych == 'd') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy188;
					goto yy16;
				} else {
					if (yych <= 'h') goto yy188;
					if (yych <= 'l') goto yy16;
					goto yy188;
				}
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'u') {
					if (yych <= 'r') goto yy16;
					goto yy188;
				} else {
					if (yych == 'w') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 'y') goto yy188;
					if (yych <= 0xC1) goto yy16;
					goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
					goto yy16;
				}
			}
		}
	}
yy195:
	YYDEBUG(195, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy385;
	if (yych <= '9') goto yy107;
	goto yy55;
yy196:
	YYDEBUG(196, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy188;
				if (yych <= 0x1F) goto yy16;
				goto yy188;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy16;
					goto yy383;
				} else {
					if (yych == 'D') goto yy188;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy188;
					goto yy16;
				} else {
					if (yych <= 'H') goto yy188;
					if (yych <= 'L') goto yy16;
					goto yy188;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy16;
					goto yy188;
				} else {
					if (yych == 'W') goto yy188;
					goto yy16;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy188;
					goto yy16;
				} else {
					if (yych == 'e') goto yy16;
					goto yy188;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy16;
					goto yy188;
				} else {
					if (yych == 'm') goto yy188;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy188;
					goto yy16;
				} else {
					if (yych == 'x') goto yy16;
					goto yy188;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy16;
					goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
					goto yy16;
				}
			}
		}
	}
yy197:
	YYDEBUG(197, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy188;
				if (yych <= 0x1F) goto yy16;
				goto yy188;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy16;
					goto yy386;
				} else {
					if (yych == 'D') goto yy188;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy188;
					goto yy16;
				} else {
					if (yych <= 'H') goto yy188;
					if (yych <= 'L') goto yy16;
					goto yy188;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy16;
					goto yy188;
				} else {
					if (yych == 'W') goto yy188;
					goto yy16;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy188;
					goto yy16;
				} else {
					if (yych == 'e') goto yy16;
					goto yy188;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy16;
					goto yy188;
				} else {
					if (yych == 'm') goto yy188;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy188;
					goto yy16;
				} else {
					if (yych == 'x') goto yy16;
					goto yy188;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy16;
					goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
					goto yy16;
				}
			}
		}
	}
yy198:
	YYDEBUG(198, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy199:
	YYDEBUG(199, *YYCURSOR);
	switch (yych) {
		case '\t':
		case ' ':
		case '-':
		case '.': goto yy198;
		case 'A':
		case 'a': goto yy70;
		case 'D':
		case 'd': goto yy207;
		case 'F':
		case 'f': goto yy208;
		case 'I': goto yy74;
		case 'J':
		case 'j': goto yy76;
		case 'M':
		case 'm': goto yy209;
		case 'N':
		case 'n': goto yy78;
		case 'O':
		case 'o': goto yy79;
		case 'S':
		case 's': goto yy210;
		case 'V': goto yy83;
		case 'X': goto yy85;
		default: goto yy55;
	}
yy200:
	YYDEBUG(200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy55;
		if (yych <= '-') goto yy387;
		goto yy388;
	} else {
		if (yych <= '/') goto yy55;
		if (yych <= '9') goto yy202;
		goto yy55;
	}
yy201:
	YYDEBUG(201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy55;
		if (yych <= '-') goto yy387;
		goto yy388;
	} else {
		if (yych <= '/') goto yy55;
		if (yych >= '3') goto yy55;
	}
yy202:
	YYDEBUG(202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy55;
	if (yych <= '-') goto yy387;
	if (yych <= '.') goto yy388;
	goto yy55;
yy203:
	YYDEBUG(203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy265;
	goto yy55;
yy204:
	YYDEBUG(204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy55;
		if (yych <= '-') goto yy389;
		goto yy387;
	} else {
		if (yych <= '/') goto yy55;
		if (yych <= '9') goto yy206;
		goto yy55;
	}
yy205:
	YYDEBUG(205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy55;
		if (yych <= '-') goto yy389;
		goto yy387;
	} else {
		if (yych <= '/') goto yy55;
		if (yych >= '3') goto yy55;
	}
yy206:
	YYDEBUG(206, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy55;
	if (yych <= '-') goto yy389;
	if (yych <= '.') goto yy387;
	goto yy55;
yy207:
	YYDEBUG(207, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy235;
	if (yych == 'e') goto yy235;
	goto yy55;
yy208:
	YYDEBUG(208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy236;
	if (yych == 'e') goto yy236;
	goto yy55;
yy209:
	YYDEBUG(209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy247;
	if (yych == 'a') goto yy247;
	goto yy55;
yy210:
	YYDEBUG(210, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy390;
	if (yych == 'e') goto yy390;
	goto yy55;
yy211:
	YYDEBUG(211, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy169;
		if (yych <= '-') goto yy387;
		goto yy391;
	} else {
		if (yych <= '/') goto yy169;
		if (yych <= '9') goto yy214;
		if (yych <= ':') goto yy392;
		goto yy169;
	}
yy212:
	YYDEBUG(212, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy169;
		if (yych <= '-') goto yy387;
		if (yych <= '.') goto yy391;
		goto yy169;
	} else {
		if (yych <= '2') goto yy214;
		if (yych <= '9') goto yy231;
		if (yych <= ':') goto yy392;
		goto yy169;
	}
yy213:
	YYDEBUG(213, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy169;
		if (yych <= '-') goto yy387;
		goto yy391;
	} else {
		if (yych <= '/') goto yy169;
		if (yych <= '9') goto yy231;
		if (yych <= ':') goto yy392;
		goto yy169;
	}
yy214:
	YYDEBUG(214, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy169;
		if (yych <= '-') goto yy387;
		goto yy391;
	} else {
		if (yych == ':') goto yy392;
		goto yy169;
	}
yy215:
	YYDEBUG(215, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy393;
		} else {
			if (yych <= '9') goto yy218;
			if (yych >= 'n') goto yy394;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy394;
		} else {
			if (yych <= 's') goto yy395;
			if (yych <= 't') goto yy396;
		}
	}
yy216:
	YYDEBUG(216, *YYCURSOR);
#line 1468 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
			TIMELIB_PROCESS_YEAR(s->time->y, length);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 6937 "<stdout>"
yy217:
	YYDEBUG(217, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy216;
			goto yy393;
		} else {
			if (yych <= '1') goto yy218;
			if (yych <= 'm') goto yy216;
			goto yy394;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy216;
			goto yy394;
		} else {
			if (yych <= 's') goto yy395;
			if (yych <= 't') goto yy396;
			goto yy216;
		}
	}
yy218:
	YYDEBUG(218, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy393;
		if (yych <= 'm') goto yy216;
		goto yy394;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy216;
			goto yy394;
		} else {
			if (yych <= 's') goto yy395;
			if (yych <= 't') goto yy396;
			goto yy216;
		}
	}
yy219:
	YYDEBUG(219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy397;
		if (yych <= 'T') goto yy55;
		goto yy398;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy55;
			goto yy397;
		} else {
			if (yych == 'u') goto yy398;
			goto yy55;
		}
	}
yy220:
	YYDEBUG(220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy399;
	if (yych == 'e') goto yy399;
	goto yy55;
yy221:
	YYDEBUG(221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy400;
	if (yych == 'e') goto yy400;
	goto yy55;
yy222:
	YYDEBUG(222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy401;
		if (yych <= 'T') goto yy55;
		goto yy402;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy401;
		} else {
			if (yych == 'u') goto yy402;
			goto yy55;
		}
	}
yy223:
	YYDEBUG(223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy403;
	if (yych == 'a') goto yy403;
	goto yy55;
yy224:
	YYDEBUG(224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy404;
	if (yych == 'o') goto yy404;
	goto yy55;
yy225:
	YYDEBUG(225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy405;
	if (yych == 'c') goto yy405;
	goto yy55;
yy226:
	YYDEBUG(226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy406;
	if (yych == 'e') goto yy406;
	goto yy55;
yy227:
	YYDEBUG(227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy199;
	if (yych <= '0') goto yy407;
	if (yych <= '1') goto yy408;
	if (yych <= '9') goto yy206;
	goto yy199;
yy228:
	YYDEBUG(228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy409;
		if (yych <= '/') goto yy188;
		goto yy410;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy229:
	YYDEBUG(229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy409;
		if (yych <= '/') goto yy188;
		goto yy412;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy230:
	YYDEBUG(230, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy392;
		goto yy169;
	} else {
		if (yych <= '9') goto yy231;
		if (yych <= ':') goto yy392;
		goto yy169;
	}
yy231:
	YYDEBUG(231, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy392;
	if (yych == ':') goto yy392;
	goto yy169;
yy232:
	YYDEBUG(232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy414;
	if (yych == 'r') goto yy414;
	goto yy55;
yy233:
	YYDEBUG(233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy415;
	if (yych == 'g') goto yy415;
	goto yy55;
yy234:
	YYDEBUG(234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy416;
	if (yych == 'y') goto yy416;
	goto yy55;
yy235:
	YYDEBUG(235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy417;
	if (yych == 'c') goto yy417;
	goto yy55;
yy236:
	YYDEBUG(236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy418;
	if (yych == 'b') goto yy418;
	goto yy55;
yy237:
	YYDEBUG(237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy419;
	if (yych == 'r') goto yy419;
	goto yy55;
yy238:
	YYDEBUG(238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy420;
	if (yych == 'i') goto yy420;
	goto yy55;
yy239:
	YYDEBUG(239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy421;
	if (yych == 'u') goto yy421;
	goto yy55;
yy240:
	YYDEBUG(240, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy240;
		if (yych <= 0x1F) goto yy55;
		goto yy240;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy55;
			goto yy240;
		} else {
			if (yych <= '/') goto yy55;
			if (yych >= ':') goto yy55;
		}
	}
yy241:
	YYDEBUG(241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy242;
	if (yych <= '9') goto yy422;
yy242:
	YYDEBUG(242, *YYCURSOR);
#line 1550 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		timelib_skip_day_suffix(&ptr);
		s->time->m = timelib_get_month(&ptr);
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 7193 "<stdout>"
yy243:
	YYDEBUG(243, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy75;
			goto yy240;
		} else {
			if (yych == ' ') goto yy240;
			goto yy75;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy240;
			if (yych <= '/') goto yy75;
			goto yy241;
		} else {
			if (yych != 'I') goto yy75;
		}
	}
yy244:
	YYDEBUG(244, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy240;
		if (yych <= 0x1F) goto yy75;
		goto yy240;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy75;
			goto yy240;
		} else {
			if (yych <= '/') goto yy75;
			if (yych <= '9') goto yy241;
			goto yy75;
		}
	}
yy245:
	YYDEBUG(245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy423;
	if (yych == 'n') goto yy423;
	goto yy55;
yy246:
	YYDEBUG(246, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy424;
		if (yych <= 'M') goto yy55;
		goto yy425;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy55;
			goto yy424;
		} else {
			if (yych == 'n') goto yy425;
			goto yy55;
		}
	}
yy247:
	YYDEBUG(247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy426;
		if (yych <= 'X') goto yy55;
		goto yy244;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy55;
			goto yy426;
		} else {
			if (yych == 'y') goto yy244;
			goto yy55;
		}
	}
yy248:
	YYDEBUG(248, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy427;
			goto yy55;
		} else {
			if (yych <= 'L') goto yy428;
			if (yych <= 'M') goto yy55;
			goto yy429;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy427;
			goto yy55;
		} else {
			if (yych <= 'l') goto yy428;
			if (yych == 'n') goto yy429;
			goto yy55;
		}
	}
yy249:
	YYDEBUG(249, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy430;
	if (yych == 'n') goto yy430;
	goto yy55;
yy250:
	YYDEBUG(250, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy431;
	if (yych == 'e') goto yy431;
yy251:
	YYDEBUG(251, *YYCURSOR);
#line 1955 "parse_date.re"
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_signed_nr(s, &ptr, 24);
			timelib_eat_spaces(&ptr);
			timelib_set_relative(&ptr, i, 1, s, TIMELIB_TIME_PART_KEEP);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 7322 "<stdout>"
yy252:
	YYDEBUG(252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy417;
	if (yych == 'v') goto yy417;
	goto yy55;
yy253:
	YYDEBUG(253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy432;
	if (yych == 't') goto yy432;
	goto yy55;
yy254:
	YYDEBUG(254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy433;
	if (yych == 't') goto yy433;
	goto yy55;
yy255:
	YYDEBUG(255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy434;
		if (yych <= 'O') goto yy55;
		goto yy435;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy55;
			goto yy434;
		} else {
			if (yych == 'p') goto yy435;
			goto yy55;
		}
	}
yy256:
	YYDEBUG(256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy420;
	if (yych == 'n') goto yy420;
	goto yy55;
yy257:
	YYDEBUG(257, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy436;
	if (yych == 'u') goto yy436;
	goto yy55;
yy258:
	YYDEBUG(258, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy437;
	if (yych == 'e') goto yy437;
	goto yy55;
yy259:
	YYDEBUG(259, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy431;
	if (yych == 'e') goto yy431;
	goto yy55;
yy260:
	YYDEBUG(260, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy55;
		if (yych <= 'D') goto yy438;
		goto yy439;
	} else {
		if (yych <= 'c') goto yy55;
		if (yych <= 'd') goto yy438;
		if (yych <= 'e') goto yy439;
		goto yy55;
	}
yy261:
	YYDEBUG(261, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy421;
	if (yych == 'a') goto yy421;
	goto yy55;
yy262:
	YYDEBUG(262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy278;
		goto yy199;
	} else {
		if (yych <= '-') goto yy440;
		if (yych <= '.') goto yy278;
		if (yych <= '/') goto yy271;
		goto yy199;
	}
yy263:
	YYDEBUG(263, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy199;
			goto yy278;
		} else {
			if (yych <= ',') goto yy199;
			if (yych <= '-') goto yy440;
			goto yy278;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '/') goto yy271;
			if (yych <= 'T') goto yy199;
			goto yy436;
		} else {
			if (yych == 'u') goto yy436;
			goto yy199;
		}
	}
yy264:
	YYDEBUG(264, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= 'c') {
		if (yych <= 'M') {
			if (yych <= 'F') {
				if (yych == 'D') goto yy190;
				if (yych <= 'E') goto yy55;
				goto yy191;
			} else {
				if (yych == 'H') goto yy73;
				if (yych <= 'L') goto yy55;
				goto yy192;
			}
		} else {
			if (yych <= 'U') {
				if (yych <= 'R') goto yy55;
				if (yych <= 'S') goto yy193;
				if (yych <= 'T') goto yy81;
				goto yy82;
			} else {
				if (yych <= 'W') {
					if (yych <= 'V') goto yy55;
					goto yy84;
				} else {
					if (yych == 'Y') goto yy86;
					goto yy55;
				}
			}
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'g') {
				if (yych <= 'd') goto yy190;
				if (yych == 'f') goto yy191;
				goto yy55;
			} else {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy73;
					goto yy55;
				} else {
					if (yych <= 'm') goto yy192;
					if (yych <= 'r') goto yy55;
					goto yy193;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') goto yy81;
				if (yych <= 'u') goto yy82;
				if (yych <= 'v') goto yy55;
				goto yy84;
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy55;
					goto yy86;
				} else {
					if (yych == 0xC2) goto yy91;
					goto yy55;
				}
			}
		}
	}
yy265:
	YYDEBUG(265, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy250;
	if (yych == 's') goto yy250;
	goto yy55;
yy266:
	YYDEBUG(266, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy441;
	goto yy55;
yy267:
	YYDEBUG(267, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy169;
		if (yych <= '-') goto yy387;
		goto yy442;
	} else {
		if (yych <= '/') goto yy169;
		if (yych <= '9') goto yy443;
		if (yych <= ':') goto yy444;
		goto yy169;
	}
yy268:
	YYDEBUG(268, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy169;
		if (yych <= '-') goto yy387;
		if (yych <= '.') goto yy442;
		goto yy169;
	} else {
		if (yych <= '2') goto yy443;
		if (yych <= '9') goto yy445;
		if (yych <= ':') goto yy444;
		goto yy169;
	}
yy269:
	YYDEBUG(269, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy169;
		if (yych <= '-') goto yy387;
		goto yy442;
	} else {
		if (yych <= '/') goto yy169;
		if (yych <= '9') goto yy445;
		if (yych <= ':') goto yy444;
		goto yy169;
	}
yy270:
	YYDEBUG(270, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy169;
		if (yych <= '-') goto yy387;
		goto yy442;
	} else {
		if (yych == ':') goto yy444;
		goto yy169;
	}
yy271:
	YYDEBUG(271, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy219;
		case 'D':
		case 'd': goto yy220;
		case 'F':
		case 'f': goto yy221;
		case 'J':
		case 'j': goto yy222;
		case 'M':
		case 'm': goto yy223;
		case 'N':
		case 'n': goto yy224;
		case 'O':
		case 'o': goto yy225;
		case 'S':
		case 's': goto yy226;
		default: goto yy55;
	}
yy272:
	YYDEBUG(272, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy444;
		goto yy169;
	} else {
		if (yych <= '9') goto yy446;
		if (yych <= ':') goto yy444;
		goto yy169;
	}
yy273:
	YYDEBUG(273, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy444;
	if (yych == ':') goto yy444;
	goto yy169;
yy274:
	YYDEBUG(274, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy275;
	if (yych != 'm') goto yy55;
yy275:
	YYDEBUG(275, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy447;
		if (yych == '\t') goto yy447;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy447;
		if (yych == '.') goto yy448;
		goto yy55;
	}
yy276:
	YYDEBUG(276, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'M') {
			if (yych <= 'E') {
				if (yych <= 'A') {
					if (yych <= '@') goto yy55;
					goto yy100;
				} else {
					if (yych == 'D') goto yy190;
					goto yy55;
				}
			} else {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy191;
					goto yy55;
				} else {
					if (yych <= 'H') goto yy73;
					if (yych <= 'L') goto yy55;
					goto yy192;
				}
			}
		} else {
			if (yych <= 'T') {
				if (yych <= 'P') {
					if (yych <= 'O') goto yy55;
					goto yy100;
				} else {
					if (yych <= 'R') goto yy55;
					if (yych <= 'S') goto yy193;
					goto yy81;
				}
			} else {
				if (yych <= 'W') {
					if (yych <= 'U') goto yy82;
					if (yych <= 'V') goto yy55;
					goto yy84;
				} else {
					if (yych == 'Y') goto yy86;
					goto yy55;
				}
			}
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'a') goto yy100;
					goto yy55;
				} else {
					if (yych <= 'd') goto yy190;
					if (yych <= 'e') goto yy55;
					goto yy191;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'h') goto yy73;
					goto yy55;
				} else {
					if (yych <= 'm') goto yy192;
					if (yych <= 'o') goto yy55;
					goto yy100;
				}
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 's') {
					if (yych <= 'r') goto yy55;
					goto yy193;
				} else {
					if (yych <= 't') goto yy81;
					if (yych <= 'u') goto yy82;
					goto yy55;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'w') goto yy84;
					if (yych <= 'x') goto yy55;
					goto yy86;
				} else {
					if (yych == 0xC2) goto yy101;
					goto yy55;
				}
			}
		}
	}
yy277:
	YYDEBUG(277, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy449;
	goto yy55;
yy278:
	YYDEBUG(278, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy199;
	if (yych <= '0') goto yy200;
	if (yych <= '1') goto yy201;
	if (yych <= '9') goto yy202;
	goto yy199;
yy279:
	YYDEBUG(279, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy450;
		case '1': goto yy451;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy452;
		case 'A':
		case 'a': goto yy453;
		case 'D':
		case 'd': goto yy454;
		case 'F':
		case 'f': goto yy455;
		case 'J':
		case 'j': goto yy456;
		case 'M':
		case 'm': goto yy457;
		case 'N':
		case 'n': goto yy458;
		case 'O':
		case 'o': goto yy459;
		case 'S':
		case 's': goto yy460;
		default: goto yy55;
	}
yy280:
	YYDEBUG(280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy281;
	if (yych <= '9') goto yy461;
yy281:
	YYDEBUG(281, *YYCURSOR);
#line 1233 "parse_date.re"
	{
		timelib_sll i;
		timelib_ull us;
		const char *ptr_before;
		bool is_negative;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		is_negative = *(ptr + 1) == '-';

		i = timelib_get_signed_nr(s, &ptr, 24);

		ptr_before = ptr;
		us = timelib_get_signed_nr(s, &ptr, 6);
		us = us * pow(10, 7 - (ptr - ptr_before));
		if (is_negative) {
			us *= -1;
		}

		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->us = 0;
		s->time->relative.s += i;
		s->time->relative.us = us;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 7807 "<stdout>"
yy282:
	YYDEBUG(282, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy462;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy462;
		goto yy16;
	}
yy283:
	YYDEBUG(283, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy107;
	} else {
		if (yych <= 'Z') goto yy462;
		if (yych <= '`') goto yy284;
		if (yych <= 'z') goto yy462;
	}
yy284:
	YYDEBUG(284, *YYCURSOR);
#line 1796 "parse_date.re"
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->relative.weekday == 0) {
			s->time->relative.weekday = -7;
		}
		if (s->time->relative.have_special_relative && s->time->relative.special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->relative.special.amount = 0 - s->time->relative.special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 7852 "<stdout>"
yy285:
	YYDEBUG(285, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy134;
			} else {
				if (yych == ' ') goto yy134;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy107;
			} else {
				if (yych <= '-') goto yy463;
				if (yych <= '.') goto yy134;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy134;
			} else {
				if (yych == 'I') goto yy464;
				goto yy462;
			}
		} else {
			if (yych <= 'h') {
				if (yych >= 'a') goto yy462;
			} else {
				if (yych <= 'i') goto yy464;
				if (yych <= 'z') goto yy462;
			}
		}
	}
yy286:
	YYDEBUG(286, *YYCURSOR);
#line 1876 "parse_date.re"
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month(&ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 7900 "<stdout>"
yy287:
	YYDEBUG(287, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy107;
				goto yy286;
			} else {
				if (yych <= '-') goto yy463;
				if (yych <= '.') goto yy134;
				goto yy286;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy134;
				goto yy286;
			} else {
				if (yych == 'U') goto yy465;
				goto yy462;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy286;
				goto yy462;
			} else {
				if (yych <= 'u') goto yy465;
				if (yych <= 'z') goto yy462;
				goto yy286;
			}
		}
	}
yy288:
	YYDEBUG(288, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 64) {
		goto yy466;
	}
	goto yy55;
yy289:
	YYDEBUG(289, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			goto yy288;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy16;
			if (yych <= 'Z') goto yy462;
			goto yy16;
		} else {
			if (yych <= '_') goto yy288;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy467;
			goto yy16;
		}
	}
yy290:
	YYDEBUG(290, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy284;
		} else {
			if (yych == '.') goto yy284;
			goto yy288;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy284;
			if (yych <= 'Z') goto yy462;
			goto yy284;
		} else {
			if (yych <= '_') goto yy288;
			if (yych <= '`') goto yy284;
			if (yych <= 'z') goto yy467;
			goto yy284;
		}
	}
yy291:
	YYDEBUG(291, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy107;
				if (yych <= ',') goto yy286;
				goto yy468;
			} else {
				if (yych == '/') goto yy288;
				goto yy134;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy286;
				goto yy462;
			} else {
				if (yych <= 'I') goto yy464;
				if (yych <= 'Z') goto yy462;
				goto yy286;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy288;
				if (yych <= '`') goto yy286;
				goto yy467;
			} else {
				if (yych <= 'i') goto yy469;
				if (yych <= 'z') goto yy467;
				goto yy286;
			}
		}
	}
yy292:
	YYDEBUG(292, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy107;
				if (yych <= ',') goto yy286;
				goto yy468;
			} else {
				if (yych == '/') goto yy288;
				goto yy134;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy286;
				goto yy462;
			} else {
				if (yych <= 'U') goto yy465;
				if (yych <= 'Z') goto yy462;
				goto yy286;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy288;
				if (yych <= '`') goto yy286;
				goto yy467;
			} else {
				if (yych <= 'u') goto yy470;
				if (yych <= 'z') goto yy467;
				goto yy286;
			}
		}
	}
yy293:
	YYDEBUG(293, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'J') goto yy462;
			goto yy471;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 'k') goto yy471;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy294:
	YYDEBUG(294, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy471;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy16;
				goto yy467;
			} else {
				if (yych <= 'k') goto yy472;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy295:
	YYDEBUG(295, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy107;
				goto yy286;
			} else {
				if (yych <= '-') goto yy463;
				if (yych <= '.') goto yy134;
				goto yy286;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy134;
				goto yy286;
			} else {
				if (yych == 'E') goto yy473;
				goto yy462;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy286;
				goto yy462;
			} else {
				if (yych <= 'e') goto yy473;
				if (yych <= 'z') goto yy462;
				goto yy286;
			}
		}
	}
yy296:
	YYDEBUG(296, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy107;
				if (yych <= ',') goto yy286;
				goto yy468;
			} else {
				if (yych == '/') goto yy288;
				goto yy134;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy286;
				goto yy462;
			} else {
				if (yych <= 'E') goto yy473;
				if (yych <= 'Z') goto yy462;
				goto yy286;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy288;
				if (yych <= '`') goto yy286;
				goto yy467;
			} else {
				if (yych <= 'e') goto yy474;
				if (yych <= 'z') goto yy467;
				goto yy286;
			}
		}
	}
yy297:
	YYDEBUG(297, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'G') goto yy462;
			goto yy475;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 'h') goto yy475;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy298:
	YYDEBUG(298, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'U') goto yy462;
			goto yy476;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 'v') goto yy476;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy299:
	YYDEBUG(299, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy475;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy16;
				goto yy467;
			} else {
				if (yych <= 'h') goto yy477;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy300:
	YYDEBUG(300, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy476;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy16;
				goto yy467;
			} else {
				if (yych <= 'v') goto yy478;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy301:
	YYDEBUG(301, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy107;
				goto yy286;
			} else {
				if (yych <= '-') goto yy463;
				if (yych <= '.') goto yy134;
				goto yy286;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy134;
				goto yy286;
			} else {
				if (yych == 'R') goto yy479;
				goto yy462;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy286;
				goto yy462;
			} else {
				if (yych <= 'r') goto yy479;
				if (yych <= 'z') goto yy462;
				goto yy286;
			}
		}
	}
yy302:
	YYDEBUG(302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy462;
			goto yy480;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 't') goto yy480;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy303:
	YYDEBUG(303, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy462;
			goto yy481;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 's') goto yy481;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy304:
	YYDEBUG(304, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy462;
			goto yy482;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 'r') goto yy482;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy305:
	YYDEBUG(305, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych >= ')') goto yy107;
		} else {
			if (yych <= '@') goto yy306;
			if (yych <= 'C') goto yy462;
			goto yy483;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy462;
			if (yych >= 'a') goto yy462;
		} else {
			if (yych <= 'd') goto yy483;
			if (yych <= 'z') goto yy462;
		}
	}
yy306:
	YYDEBUG(306, *YYCURSOR);
#line 1817 "parse_date.re"
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit(&ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}

		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 8492 "<stdout>"
yy307:
	YYDEBUG(307, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy462;
			goto yy484;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 'n') goto yy484;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy308:
	YYDEBUG(308, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy107;
				if (yych <= ',') goto yy286;
				goto yy468;
			} else {
				if (yych == '/') goto yy288;
				goto yy134;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy286;
				goto yy462;
			} else {
				if (yych <= 'R') goto yy479;
				if (yych <= 'Z') goto yy462;
				goto yy286;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy288;
				if (yych <= '`') goto yy286;
				goto yy467;
			} else {
				if (yych <= 'r') goto yy485;
				if (yych <= 'z') goto yy467;
				goto yy286;
			}
		}
	}
yy309:
	YYDEBUG(309, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy480;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy467;
			} else {
				if (yych <= 't') goto yy486;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy310:
	YYDEBUG(310, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy481;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy16;
				goto yy467;
			} else {
				if (yych <= 's') goto yy487;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy311:
	YYDEBUG(311, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy482;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy16;
				goto yy467;
			} else {
				if (yych <= 'r') goto yy488;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy312:
	YYDEBUG(312, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy306;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy306;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy483;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy306;
			goto yy288;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy306;
				goto yy467;
			} else {
				if (yych <= 'd') goto yy489;
				if (yych <= 'z') goto yy467;
				goto yy306;
			}
		}
	}
yy313:
	YYDEBUG(313, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy484;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy16;
				goto yy467;
			} else {
				if (yych <= 'n') goto yy490;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy314:
	YYDEBUG(314, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych == '+') goto yy491;
			goto yy16;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy491;
			if (yych <= '@') goto yy16;
			goto yy462;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy315:
	YYDEBUG(315, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '0') {
			if (yych >= '0') goto yy492;
		} else {
			if (yych <= '1') goto yy493;
			if (yych <= '2') goto yy494;
			goto yy495;
		}
	} else {
		if (yych <= 'T') {
			if (yych >= 'T') goto yy496;
		} else {
			if (yych == 't') goto yy496;
		}
	}
yy316:
	YYDEBUG(316, *YYCURSOR);
#line 1619 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 8773 "<stdout>"
yy317:
	YYDEBUG(317, *YYCURSOR);
	yyaccept = 10;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 21) YYFILL(21);
	yych = *YYCURSOR;
yy318:
	YYDEBUG(318, *YYCURSOR);
	if (yybm[0+yych] & 32) {
		goto yy317;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy316;
		if (yych <= '0') goto yy497;
		if (yych <= '1') goto yy498;
		goto yy499;
	} else {
		if (yych <= '9') goto yy500;
		if (yych == 'T') goto yy496;
		goto yy316;
	}
yy319:
	YYDEBUG(319, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy315;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy317;
				if (yych <= 0x1F) goto yy55;
				goto yy317;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy317;
				goto yy55;
			} else {
				if (yych <= '.') goto yy317;
				if (yych <= '/') goto yy55;
				goto yy501;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy55;
				goto yy317;
			} else {
				if (yych == 'h') goto yy317;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy320;
				if (yych <= 'q') goto yy55;
			} else {
				if (yych <= 's') goto yy321;
				if (yych <= 't') goto yy322;
				goto yy55;
			}
		}
	}
yy320:
	YYDEBUG(320, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy502;
	goto yy318;
yy321:
	YYDEBUG(321, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 't') goto yy502;
	goto yy318;
yy322:
	YYDEBUG(322, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'h') goto yy502;
	goto yy318;
yy323:
	YYDEBUG(323, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy501;
	goto yy55;
yy324:
	YYDEBUG(324, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy134;
			goto yy16;
		} else {
			if (yych <= ' ') goto yy134;
			if (yych == ')') goto yy107;
			goto yy16;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy16;
			if (yych <= '9') goto yy134;
			goto yy16;
		} else {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy325:
	YYDEBUG(325, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy107;
				goto yy286;
			} else {
				if (yych <= '-') goto yy463;
				if (yych <= '.') goto yy134;
				goto yy286;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy134;
				goto yy286;
			} else {
				if (yych == 'U') goto yy503;
				goto yy462;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy286;
				goto yy462;
			} else {
				if (yych <= 'u') goto yy503;
				if (yych <= 'z') goto yy462;
				goto yy286;
			}
		}
	}
yy326:
	YYDEBUG(326, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy107;
				goto yy286;
			} else {
				if (yych <= '-') goto yy463;
				if (yych <= '.') goto yy134;
				goto yy286;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy134;
				goto yy286;
			} else {
				if (yych == 'Y') goto yy504;
				goto yy462;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy286;
				goto yy462;
			} else {
				if (yych <= 'y') goto yy504;
				if (yych <= 'z') goto yy462;
				goto yy286;
			}
		}
	}
yy327:
	YYDEBUG(327, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy107;
				goto yy286;
			} else {
				if (yych <= '-') goto yy463;
				if (yych <= '.') goto yy134;
				goto yy286;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy134;
				goto yy286;
			} else {
				if (yych == 'E') goto yy504;
				goto yy462;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy286;
				goto yy462;
			} else {
				if (yych <= 'e') goto yy504;
				if (yych <= 'z') goto yy462;
				goto yy286;
			}
		}
	}
yy328:
	YYDEBUG(328, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy107;
				if (yych <= ',') goto yy286;
				goto yy468;
			} else {
				if (yych == '/') goto yy288;
				goto yy134;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy286;
				goto yy462;
			} else {
				if (yych <= 'U') goto yy503;
				if (yych <= 'Z') goto yy462;
				goto yy286;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy288;
				if (yych <= '`') goto yy286;
				goto yy467;
			} else {
				if (yych <= 'u') goto yy505;
				if (yych <= 'z') goto yy467;
				goto yy286;
			}
		}
	}
yy329:
	YYDEBUG(329, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy107;
				if (yych <= ',') goto yy286;
				goto yy468;
			} else {
				if (yych == '/') goto yy288;
				goto yy134;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy286;
				goto yy462;
			} else {
				if (yych <= 'Y') goto yy504;
				if (yych <= 'Z') goto yy462;
				goto yy286;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy288;
				if (yych <= '`') goto yy286;
				goto yy467;
			} else {
				if (yych <= 'y') goto yy506;
				if (yych <= 'z') goto yy467;
				goto yy286;
			}
		}
	}
yy330:
	YYDEBUG(330, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy107;
				if (yych <= ',') goto yy286;
				goto yy468;
			} else {
				if (yych == '/') goto yy288;
				goto yy134;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy286;
				goto yy462;
			} else {
				if (yych <= 'E') goto yy504;
				if (yych <= 'Z') goto yy462;
				goto yy286;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy288;
				if (yych <= '`') goto yy286;
				goto yy467;
			} else {
				if (yych <= 'e') goto yy506;
				if (yych <= 'z') goto yy467;
				goto yy286;
			}
		}
	}
yy331:
	YYDEBUG(331, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy462;
			goto yy507;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 't') goto yy507;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy332:
	YYDEBUG(332, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy507;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy467;
			} else {
				if (yych <= 't') goto yy508;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy333:
	YYDEBUG(333, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy107;
				goto yy286;
			} else {
				if (yych <= '-') goto yy463;
				if (yych <= '.') goto yy134;
				goto yy286;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy134;
				goto yy286;
			} else {
				if (yych == 'C') goto yy509;
				goto yy462;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy286;
				goto yy462;
			} else {
				if (yych <= 'c') goto yy509;
				if (yych <= 'z') goto yy462;
				goto yy286;
			}
		}
	}
yy334:
	YYDEBUG(334, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy134;
			if (yych <= 0x1F) goto yy286;
			goto yy134;
		} else {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy286;
			goto yy463;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy286;
			if (yych <= '9') goto yy134;
			goto yy286;
		} else {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy286;
			if (yych <= 'z') goto yy462;
			goto yy286;
		}
	}
yy335:
	YYDEBUG(335, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy462;
			goto yy510;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 'n') goto yy510;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy336:
	YYDEBUG(336, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy107;
				if (yych <= ',') goto yy286;
				goto yy468;
			} else {
				if (yych == '/') goto yy288;
				goto yy134;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy286;
				goto yy462;
			} else {
				if (yych <= 'C') goto yy509;
				if (yych <= 'Z') goto yy462;
				goto yy286;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy288;
				if (yych <= '`') goto yy286;
				goto yy467;
			} else {
				if (yych <= 'c') goto yy511;
				if (yych <= 'z') goto yy467;
				goto yy286;
			}
		}
	}
yy337:
	YYDEBUG(337, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy134;
			if (yych <= 0x1F) goto yy286;
			goto yy134;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy286;
				goto yy107;
			} else {
				if (yych <= ',') goto yy286;
				if (yych <= '-') goto yy468;
				goto yy134;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy288;
			if (yych <= '9') goto yy134;
			if (yych <= '@') goto yy286;
			goto yy462;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy286;
				goto yy288;
			} else {
				if (yych <= '`') goto yy286;
				if (yych <= 'z') goto yy467;
				goto yy286;
			}
		}
	}
yy338:
	YYDEBUG(338, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy510;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy16;
				goto yy467;
			} else {
				if (yych <= 'n') goto yy512;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy339:
	YYDEBUG(339, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy462;
			goto yy513;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 't') goto yy513;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy340:
	YYDEBUG(340, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy462;
			goto yy514;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 'n') goto yy514;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy341:
	YYDEBUG(341, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy107;
	} else {
		if (yych <= 'Z') goto yy462;
		if (yych <= '`') goto yy342;
		if (yych <= 'z') goto yy462;
	}
yy342:
	YYDEBUG(342, *YYCURSOR);
#line 1164 "parse_date.re"
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 9475 "<stdout>"
yy343:
	YYDEBUG(343, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy513;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy467;
			} else {
				if (yych <= 't') goto yy516;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy344:
	YYDEBUG(344, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy514;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy16;
				goto yy467;
			} else {
				if (yych <= 'n') goto yy517;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy345:
	YYDEBUG(345, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy342;
		} else {
			if (yych == '.') goto yy342;
			goto yy288;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy342;
			if (yych <= 'Z') goto yy462;
			goto yy342;
		} else {
			if (yych <= '_') goto yy288;
			if (yych <= '`') goto yy342;
			if (yych <= 'z') goto yy467;
			goto yy342;
		}
	}
yy346:
	YYDEBUG(346, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy107;
				goto yy286;
			} else {
				if (yych <= '-') goto yy463;
				if (yych <= '.') goto yy134;
				goto yy286;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy134;
				goto yy286;
			} else {
				if (yych == 'O') goto yy518;
				goto yy462;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy286;
				goto yy462;
			} else {
				if (yych <= 'o') goto yy518;
				if (yych <= 'z') goto yy462;
				goto yy286;
			}
		}
	}
yy347:
	YYDEBUG(347, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy107;
				if (yych <= ',') goto yy286;
				goto yy468;
			} else {
				if (yych == '/') goto yy288;
				goto yy134;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy286;
				goto yy462;
			} else {
				if (yych <= 'O') goto yy518;
				if (yych <= 'Z') goto yy462;
				goto yy286;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy288;
				if (yych <= '`') goto yy286;
				goto yy467;
			} else {
				if (yych <= 'o') goto yy519;
				if (yych <= 'z') goto yy467;
				goto yy286;
			}
		}
	}
yy348:
	YYDEBUG(348, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'U') goto yy462;
			goto yy520;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 'v') goto yy520;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy349:
	YYDEBUG(349, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy520;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy16;
				goto yy467;
			} else {
				if (yych <= 'v') goto yy521;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy350:
	YYDEBUG(350, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy306;
			goto yy107;
		} else {
			if (yych <= '@') goto yy306;
			if (yych <= 'T') goto yy462;
			goto yy522;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy306;
			goto yy462;
		} else {
			if (yych <= 'u') goto yy522;
			if (yych <= 'z') goto yy462;
			goto yy306;
		}
	}
yy351:
	YYDEBUG(351, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy462;
			goto yy523;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 'o') goto yy523;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy352:
	YYDEBUG(352, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy107;
				goto yy286;
			} else {
				if (yych <= '-') goto yy463;
				if (yych <= '.') goto yy134;
				goto yy286;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy134;
				goto yy286;
			} else {
				if (yych == 'T') goto yy524;
				goto yy462;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy286;
				goto yy462;
			} else {
				if (yych <= 't') goto yy524;
				if (yych <= 'z') goto yy462;
				goto yy286;
			}
		}
	}
yy353:
	YYDEBUG(353, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy462;
			goto yy525;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 'e') goto yy525;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy354:
	YYDEBUG(354, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy306;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy306;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy522;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy306;
			goto yy288;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy306;
				goto yy467;
			} else {
				if (yych <= 'u') goto yy526;
				if (yych <= 'z') goto yy467;
				goto yy306;
			}
		}
	}
yy355:
	YYDEBUG(355, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy523;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy16;
				goto yy467;
			} else {
				if (yych <= 'o') goto yy527;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy356:
	YYDEBUG(356, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy107;
				if (yych <= ',') goto yy286;
				goto yy468;
			} else {
				if (yych == '/') goto yy288;
				goto yy134;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy286;
				goto yy462;
			} else {
				if (yych <= 'T') goto yy524;
				if (yych <= 'Z') goto yy462;
				goto yy286;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy288;
				if (yych <= '`') goto yy286;
				goto yy467;
			} else {
				if (yych <= 't') goto yy528;
				if (yych <= 'z') goto yy467;
				goto yy286;
			}
		}
	}
yy357:
	YYDEBUG(357, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy525;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy467;
			} else {
				if (yych <= 'e') goto yy529;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy358:
	YYDEBUG(358, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy69;
		goto yy169;
	} else {
		if (yych <= '5') goto yy530;
		if (yych == ':') goto yy69;
		goto yy169;
	}
yy359:
	YYDEBUG(359, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych <= 'Q') goto yy462;
			if (yych <= 'R') goto yy531;
			goto yy513;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 'r') goto yy531;
			if (yych <= 's') goto yy513;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy360:
	YYDEBUG(360, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy306;
			goto yy107;
		} else {
			if (yych <= '@') goto yy306;
			if (yych <= 'Q') goto yy462;
			goto yy532;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy306;
			goto yy462;
		} else {
			if (yych <= 'r') goto yy532;
			if (yych <= 'z') goto yy462;
			goto yy306;
		}
	}
yy361:
	YYDEBUG(361, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy107;
		if (yych <= '@') goto yy16;
		goto yy533;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy462;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy533;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy362:
	YYDEBUG(362, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy462;
			goto yy534;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 'o') goto yy534;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy363:
	YYDEBUG(363, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy306;
			goto yy107;
		} else {
			if (yych <= '@') goto yy306;
			if (yych <= 'R') goto yy462;
			goto yy535;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy306;
			goto yy462;
		} else {
			if (yych <= 's') goto yy535;
			if (yych <= 'z') goto yy462;
			goto yy306;
		}
	}
yy364:
	YYDEBUG(364, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'K') goto yy462;
			goto yy536;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 'l') goto yy536;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy365:
	YYDEBUG(365, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy16;
				goto yy288;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'Q') goto yy462;
				goto yy531;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'S') goto yy513;
				goto yy462;
			} else {
				if (yych == '_') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy467;
				goto yy537;
			} else {
				if (yych <= 's') goto yy516;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy366:
	YYDEBUG(366, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy306;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy306;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy532;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy306;
			goto yy288;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy306;
				goto yy467;
			} else {
				if (yych <= 'r') goto yy538;
				if (yych <= 'z') goto yy467;
				goto yy306;
			}
		}
	}
yy367:
	YYDEBUG(367, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy533;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy539;
			if (yych <= 'z') goto yy467;
			goto yy16;
		}
	}
yy368:
	YYDEBUG(368, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy534;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy16;
				goto yy467;
			} else {
				if (yych <= 'o') goto yy540;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy369:
	YYDEBUG(369, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy306;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy306;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy535;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy306;
			goto yy288;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy306;
				goto yy467;
			} else {
				if (yych <= 's') goto yy541;
				if (yych <= 'z') goto yy467;
				goto yy306;
			}
		}
	}
yy370:
	YYDEBUG(370, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy536;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy16;
				goto yy467;
			} else {
				if (yych <= 'l') goto yy542;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy371:
	YYDEBUG(371, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy134;
			if (yych <= 0x1F) goto yy16;
			goto yy134;
		} else {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy134;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy134;
			if (yych <= '@') goto yy16;
			goto yy462;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy543;
				goto yy462;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy462;
				goto yy16;
			}
		}
	}
yy372:
	YYDEBUG(372, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy306;
			goto yy107;
		} else {
			if (yych <= '@') goto yy306;
			if (yych <= 'M') goto yy462;
			goto yy544;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy306;
			goto yy462;
		} else {
			if (yych <= 'n') goto yy544;
			if (yych <= 'z') goto yy462;
			goto yy306;
		}
	}
yy373:
	YYDEBUG(373, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'J') goto yy462;
			goto yy535;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 'k') goto yy535;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy374:
	YYDEBUG(374, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy306;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy306;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy544;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy306;
			goto yy288;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy306;
				goto yy467;
			} else {
				if (yych <= 'n') goto yy545;
				if (yych <= 'z') goto yy467;
				goto yy306;
			}
		}
	}
yy375:
	YYDEBUG(375, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy535;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy16;
				goto yy467;
			} else {
				if (yych <= 'k') goto yy541;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy376:
	YYDEBUG(376, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy462;
			goto yy546;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '`') goto yy16;
			goto yy462;
		} else {
			if (yych <= 't') goto yy546;
			if (yych <= 'z') goto yy462;
			goto yy16;
		}
	}
yy377:
	YYDEBUG(377, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy462;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy546;
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy467;
			} else {
				if (yych <= 't') goto yy547;
				if (yych <= 'z') goto yy467;
				goto yy16;
			}
		}
	}
yy378:
	YYDEBUG(378, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy185;
	goto yy55;
yy379:
	YYDEBUG(379, *YYCURSOR);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xE2) goto yy548;
	goto yy5;
yy380:
	YYDEBUG(380, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '9') goto yy549;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy381:
	YYDEBUG(381, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy434;
	if (yych == 'c') goto yy434;
	goto yy55;
yy382:
	YYDEBUG(382, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy188;
				if (yych <= 0x1F) goto yy16;
				goto yy188;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy16;
					goto yy550;
				} else {
					if (yych == 'D') goto yy188;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy188;
					goto yy16;
				} else {
					if (yych <= 'H') goto yy188;
					if (yych <= 'L') goto yy16;
					goto yy188;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy16;
					goto yy188;
				} else {
					if (yych == 'W') goto yy188;
					goto yy16;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy188;
					goto yy16;
				} else {
					if (yych == 'e') goto yy16;
					goto yy188;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy16;
					goto yy188;
				} else {
					if (yych == 'm') goto yy188;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy188;
					goto yy16;
				} else {
					if (yych == 'x') goto yy16;
					goto yy188;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy16;
					goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
					goto yy16;
				}
			}
		}
	}
yy383:
	YYDEBUG(383, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy188;
				if (yych <= 0x1F) goto yy16;
				goto yy188;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy16;
					goto yy551;
				} else {
					if (yych == 'D') goto yy188;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy188;
					goto yy16;
				} else {
					if (yych <= 'H') goto yy188;
					if (yych <= 'L') goto yy16;
					goto yy188;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy16;
					goto yy188;
				} else {
					if (yych == 'W') goto yy188;
					goto yy16;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy188;
					goto yy16;
				} else {
					if (yych == 'e') goto yy16;
					goto yy188;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy16;
					goto yy188;
				} else {
					if (yych == 'm') goto yy188;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy188;
					goto yy16;
				} else {
					if (yych == 'x') goto yy16;
					goto yy188;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy16;
					goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
					goto yy16;
				}
			}
		}
	}
yy384:
	YYDEBUG(384, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy552;
	if (yych <= '9') goto yy107;
	goto yy55;
yy385:
	YYDEBUG(385, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy16;
	if (yych <= '9') goto yy107;
	goto yy16;
yy386:
	YYDEBUG(386, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '9') goto yy551;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy387:
	YYDEBUG(387, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy553;
	goto yy55;
yy388:
	YYDEBUG(388, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy554;
	goto yy55;
yy389:
	YYDEBUG(389, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy555;
	if (yych <= '3') goto yy557;
	if (yych <= '9') goto yy558;
	goto yy55;
yy390:
	YYDEBUG(390, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy435;
	if (yych == 'p') goto yy435;
	goto yy55;
yy391:
	YYDEBUG(391, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy559;
	if (yych <= '6') goto yy560;
	if (yych <= '9') goto yy561;
	goto yy55;
yy392:
	YYDEBUG(392, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy562;
	if (yych <= '6') goto yy563;
	if (yych <= '9') goto yy564;
	goto yy55;
yy393:
	YYDEBUG(393, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy565;
	goto yy55;
yy394:
	YYDEBUG(394, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy566;
	goto yy55;
yy395:
	YYDEBUG(395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy566;
	goto yy55;
yy396:
	YYDEBUG(396, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy566;
	goto yy55;
yy397:
	YYDEBUG(397, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy567;
	if (yych == 'r') goto yy567;
	goto yy55;
yy398:
	YYDEBUG(398, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy567;
	if (yych == 'g') goto yy567;
	goto yy55;
yy399:
	YYDEBUG(399, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy567;
	if (yych == 'c') goto yy567;
	goto yy55;
yy400:
	YYDEBUG(400, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy567;
	if (yych == 'b') goto yy567;
	goto yy55;
yy401:
	YYDEBUG(401, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy567;
	if (yych == 'n') goto yy567;
	goto yy55;
yy402:
	YYDEBUG(402, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy567;
		if (yych <= 'M') goto yy55;
		goto yy567;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy55;
			goto yy567;
		} else {
			if (yych == 'n') goto yy567;
			goto yy55;
		}
	}
yy403:
	YYDEBUG(403, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy567;
		if (yych <= 'X') goto yy55;
		goto yy567;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy55;
			goto yy567;
		} else {
			if (yych == 'y') goto yy567;
			goto yy55;
		}
	}
yy404:
	YYDEBUG(404, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy567;
	if (yych == 'v') goto yy567;
	goto yy55;
yy405:
	YYDEBUG(405, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy567;
	if (yych == 't') goto yy567;
	goto yy55;
yy406:
	YYDEBUG(406, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy568;
	if (yych == 'p') goto yy568;
	goto yy55;
yy407:
	YYDEBUG(407, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy55;
		if (yych <= '-') goto yy389;
		goto yy387;
	} else {
		if (yych <= '/') goto yy55;
		if (yych <= '9') goto yy569;
		goto yy55;
	}
yy408:
	YYDEBUG(408, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy55;
		if (yych <= '-') goto yy389;
		goto yy387;
	} else {
		if (yych <= '/') goto yy55;
		if (yych <= '2') goto yy569;
		goto yy55;
	}
yy409:
	YYDEBUG(409, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy570;
		case '1': goto yy571;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy452;
		case 'A':
		case 'a': goto yy453;
		case 'D':
		case 'd': goto yy454;
		case 'F':
		case 'f': goto yy455;
		case 'J':
		case 'j': goto yy456;
		case 'M':
		case 'm': goto yy457;
		case 'N':
		case 'n': goto yy458;
		case 'O':
		case 'o': goto yy459;
		case 'S':
		case 's': goto yy460;
		default: goto yy55;
	}
yy410:
	YYDEBUG(410, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '5') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy573;
				} else {
					if (yych <= ' ') goto yy573;
					if (yych >= '-') goto yy574;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy575;
					if (yych <= '/') goto yy576;
					goto yy577;
				} else {
					if (yych <= '1') goto yy578;
					if (yych <= '2') goto yy579;
					if (yych <= '3') goto yy580;
					goto yy581;
				}
			}
		} else {
			if (yych <= 'C') {
				if (yych <= ':') {
					if (yych <= '6') goto yy582;
					if (yych <= '9') goto yy583;
					goto yy584;
				} else {
					if (yych == 'A') goto yy573;
				}
			} else {
				if (yych <= 'F') {
					if (yych != 'E') goto yy573;
				} else {
					if (yych <= 'G') goto yy411;
					if (yych <= 'J') goto yy573;
					if (yych >= 'M') goto yy573;
				}
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'a') {
				if (yych <= 'W') {
					if (yych <= 'R') goto yy411;
					if (yych <= 'V') goto yy573;
					goto yy596;
				} else {
					if (yych <= 'Y') goto yy573;
					if (yych >= 'a') goto yy573;
				}
			} else {
				if (yych <= 'e') {
					if (yych == 'd') goto yy573;
				} else {
					if (yych == 'g') goto yy411;
					if (yych <= 'h') goto yy573;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'o') {
					if (yych <= 'j') goto yy573;
					if (yych >= 'm') goto yy573;
				} else {
					if (yych <= 'r') goto yy411;
					if (yych != 'v') goto yy573;
				}
			} else {
				if (yych <= 0xC1) {
					if (yych == 'y') goto yy573;
				} else {
					if (yych <= 0xC2) goto yy91;
					if (yych == 0xE2) goto yy92;
				}
			}
		}
	}
yy411:
	YYDEBUG(411, *YYCURSOR);
#line 1402 "parse_date.re"
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr(&ptr, 2);
				s->time->i = timelib_get_nr(&ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr(&ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, TIMELIB_ERR_DOUBLE_TIME, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 11000 "<stdout>"
yy412:
	YYDEBUG(412, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '3') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy573;
				} else {
					if (yych <= ' ') goto yy573;
					if (yych >= '-') goto yy574;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy575;
					if (yych <= '/') goto yy576;
					goto yy598;
				} else {
					if (yych <= '1') goto yy599;
					if (yych <= '2') goto yy600;
					goto yy601;
				}
			}
		} else {
			if (yych <= 'D') {
				if (yych <= '@') {
					if (yych <= '9') goto yy583;
					if (yych <= ':') goto yy584;
				} else {
					if (yych <= 'A') goto yy573;
					if (yych >= 'D') goto yy573;
				}
			} else {
				if (yych <= 'G') {
					if (yych == 'F') goto yy573;
				} else {
					if (yych <= 'J') goto yy573;
					if (yych <= 'L') goto yy413;
					if (yych <= 'O') goto yy573;
				}
			}
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'c') {
				if (yych <= 'Y') {
					if (yych == 'W') goto yy596;
					goto yy573;
				} else {
					if (yych == 'a') goto yy573;
				}
			} else {
				if (yych <= 'f') {
					if (yych != 'e') goto yy573;
				} else {
					if (yych == 'h') goto yy573;
					if (yych >= 'j') goto yy573;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'l') goto yy413;
					if (yych <= 'o') goto yy573;
				} else {
					if (yych != 'v') goto yy573;
				}
			} else {
				if (yych <= 0xC1) {
					if (yych == 'y') goto yy573;
				} else {
					if (yych <= 0xC2) goto yy91;
					if (yych == 0xE2) goto yy92;
				}
			}
		}
	}
yy413:
	YYDEBUG(413, *YYCURSOR);
#line 1787 "parse_date.re"
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr(&ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 11089 "<stdout>"
yy414:
	YYDEBUG(414, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy240;
			goto yy75;
		} else {
			if (yych <= ' ') goto yy240;
			if (yych <= ',') goto yy75;
			goto yy240;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy75;
			if (yych <= '9') goto yy241;
			goto yy75;
		} else {
			if (yych <= 'I') goto yy602;
			if (yych == 'i') goto yy602;
			goto yy75;
		}
	}
yy415:
	YYDEBUG(415, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy240;
			goto yy75;
		} else {
			if (yych <= ' ') goto yy240;
			if (yych <= ',') goto yy75;
			goto yy240;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy75;
			if (yych <= '9') goto yy241;
			goto yy75;
		} else {
			if (yych <= 'U') goto yy603;
			if (yych == 'u') goto yy603;
			goto yy75;
		}
	}
yy416:
	YYDEBUG(416, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy604;
	if (yych == 's') goto yy604;
	goto yy251;
yy417:
	YYDEBUG(417, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy240;
			goto yy75;
		} else {
			if (yych <= ' ') goto yy240;
			if (yych <= ',') goto yy75;
			goto yy240;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy75;
			if (yych <= '9') goto yy241;
			goto yy75;
		} else {
			if (yych <= 'E') goto yy605;
			if (yych == 'e') goto yy605;
			goto yy75;
		}
	}
yy418:
	YYDEBUG(418, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy240;
			goto yy75;
		} else {
			if (yych <= ' ') goto yy240;
			if (yych <= ',') goto yy75;
			goto yy240;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy75;
			if (yych <= '9') goto yy241;
			goto yy75;
		} else {
			if (yych <= 'R') goto yy606;
			if (yych == 'r') goto yy606;
			goto yy75;
		}
	}
yy419:
	YYDEBUG(419, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy607;
	if (yych == 't') goto yy607;
	goto yy55;
yy420:
	YYDEBUG(420, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy190;
	if (yych == 'd') goto yy190;
	goto yy251;
yy421:
	YYDEBUG(421, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy416;
	if (yych == 'r') goto yy416;
	goto yy55;
yy422:
	YYDEBUG(422, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy242;
	if (yych <= '9') goto yy608;
	goto yy242;
yy423:
	YYDEBUG(423, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy240;
			goto yy75;
		} else {
			if (yych <= ' ') goto yy240;
			if (yych <= ',') goto yy75;
			goto yy240;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy75;
			if (yych <= '9') goto yy241;
			goto yy75;
		} else {
			if (yych <= 'U') goto yy609;
			if (yych == 'u') goto yy609;
			goto yy75;
		}
	}
yy424:
	YYDEBUG(424, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy240;
			goto yy75;
		} else {
			if (yych <= ' ') goto yy240;
			if (yych <= ',') goto yy75;
			goto yy240;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy75;
			if (yych <= '9') goto yy241;
			goto yy75;
		} else {
			if (yych <= 'Y') goto yy244;
			if (yych == 'y') goto yy244;
			goto yy75;
		}
	}
yy425:
	YYDEBUG(425, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy240;
			goto yy75;
		} else {
			if (yych <= ' ') goto yy240;
			if (yych <= ',') goto yy75;
			goto yy240;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy75;
			if (yych <= '9') goto yy241;
			goto yy75;
		} else {
			if (yych <= 'E') goto yy244;
			if (yych == 'e') goto yy244;
			goto yy75;
		}
	}
yy426:
	YYDEBUG(426, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy240;
			goto yy75;
		} else {
			if (yych <= ' ') goto yy240;
			if (yych <= ',') goto yy75;
			goto yy240;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy75;
			if (yych <= '9') goto yy241;
			goto yy75;
		} else {
			if (yych <= 'C') goto yy610;
			if (yych == 'c') goto yy610;
			goto yy75;
		}
	}
yy427:
	YYDEBUG(427, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy611;
	if (yych == 'r') goto yy611;
	goto yy55;
yy428:
	YYDEBUG(428, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy612;
	if (yych == 'l') goto yy612;
	goto yy55;
yy429:
	YYDEBUG(429, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy604;
		if (yych <= 'T') goto yy251;
		goto yy613;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy251;
			goto yy604;
		} else {
			if (yych == 'u') goto yy613;
			goto yy251;
		}
	}
yy430:
	YYDEBUG(430, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy190;
		if (yych <= 'S') goto yy251;
		goto yy614;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy251;
			goto yy190;
		} else {
			if (yych == 't') goto yy614;
			goto yy251;
		}
	}
yy431:
	YYDEBUG(431, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy416;
	if (yych == 'c') goto yy416;
	goto yy55;
yy432:
	YYDEBUG(432, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy240;
			goto yy75;
		} else {
			if (yych <= ' ') goto yy240;
			if (yych <= ',') goto yy75;
			goto yy240;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy75;
			if (yych <= '9') goto yy241;
			goto yy75;
		} else {
			if (yych <= 'O') goto yy615;
			if (yych == 'o') goto yy615;
			goto yy75;
		}
	}
yy433:
	YYDEBUG(433, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy616;
	if (yych == 'u') goto yy616;
	goto yy251;
yy434:
	YYDEBUG(434, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy617;
		if (yych <= 'R') goto yy251;
		goto yy604;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy251;
			goto yy617;
		} else {
			if (yych == 's') goto yy604;
			goto yy251;
		}
	}
yy435:
	YYDEBUG(435, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy240;
			goto yy75;
		} else {
			if (yych <= ' ') goto yy240;
			if (yych <= ',') goto yy75;
			goto yy240;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy75;
			if (yych <= '9') goto yy241;
			goto yy75;
		} else {
			if (yych <= 'T') goto yy417;
			if (yych == 't') goto yy417;
			goto yy75;
		}
	}
yy436:
	YYDEBUG(436, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy618;
	if (yych == 'r') goto yy618;
	goto yy251;
yy437:
	YYDEBUG(437, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy619;
	if (yych == 's') goto yy619;
	goto yy251;
yy438:
	YYDEBUG(438, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy620;
	if (yych == 'n') goto yy620;
	goto yy251;
yy439:
	YYDEBUG(439, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy621;
	if (yych == 'k') goto yy621;
	goto yy55;
yy440:
	YYDEBUG(440, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy199;
	if (yych <= '0') goto yy622;
	if (yych <= '1') goto yy623;
	if (yych <= '9') goto yy624;
	goto yy199;
yy441:
	YYDEBUG(441, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= 'd') {
		if (yych <= 'R') {
			if (yych <= 'F') {
				if (yych == 'D') goto yy190;
				if (yych <= 'E') goto yy55;
				goto yy191;
			} else {
				if (yych <= 'H') {
					if (yych <= 'G') goto yy55;
					goto yy73;
				} else {
					if (yych == 'M') goto yy192;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'V') {
				if (yych <= 'S') goto yy193;
				if (yych <= 'T') goto yy81;
				if (yych <= 'U') goto yy82;
				goto yy55;
			} else {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy84;
					goto yy55;
				} else {
					if (yych <= 'Y') goto yy86;
					if (yych <= 'c') goto yy55;
					goto yy190;
				}
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'h') {
				if (yych == 'f') goto yy191;
				if (yych <= 'g') goto yy55;
				goto yy73;
			} else {
				if (yych <= 'm') {
					if (yych <= 'l') goto yy55;
					goto yy192;
				} else {
					if (yych <= 'r') goto yy55;
					if (yych <= 's') goto yy193;
					goto yy81;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy82;
					goto yy55;
				} else {
					if (yych <= 'w') goto yy84;
					if (yych <= 'x') goto yy55;
					goto yy86;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy55;
					goto yy203;
				} else {
					if (yych == 0xE2) goto yy92;
					goto yy55;
				}
			}
		}
	}
yy442:
	YYDEBUG(442, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy625;
	if (yych <= '6') goto yy626;
	if (yych <= '9') goto yy561;
	goto yy55;
yy443:
	YYDEBUG(443, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= ',') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy169;
				goto yy627;
			} else {
				if (yych == ' ') goto yy627;
				goto yy169;
			}
		} else {
			if (yych <= '9') {
				if (yych <= '-') goto yy387;
				if (yych <= '.') goto yy442;
				goto yy169;
			} else {
				if (yych <= ':') goto yy444;
				if (yych <= '@') goto yy169;
				goto yy100;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'P') {
				if (yych <= 'O') goto yy169;
				goto yy100;
			} else {
				if (yych == 'a') goto yy100;
				goto yy169;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'p') goto yy100;
				if (yych <= 0xC1) goto yy169;
				goto yy628;
			} else {
				if (yych == 0xE2) goto yy629;
				goto yy169;
			}
		}
	}
yy444:
	YYDEBUG(444, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy630;
	if (yych <= '6') goto yy631;
	if (yych <= '9') goto yy564;
	goto yy55;
yy445:
	YYDEBUG(445, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy169;
				goto yy627;
			} else {
				if (yych == ' ') goto yy627;
				goto yy169;
			}
		} else {
			if (yych <= '9') {
				if (yych <= '.') goto yy444;
				goto yy169;
			} else {
				if (yych <= ':') goto yy444;
				if (yych <= '@') goto yy169;
				goto yy100;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'P') {
				if (yych <= 'O') goto yy169;
				goto yy100;
			} else {
				if (yych == 'a') goto yy100;
				goto yy169;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'p') goto yy100;
				if (yych <= 0xC1) goto yy169;
				goto yy628;
			} else {
				if (yych == 0xE2) goto yy629;
				goto yy169;
			}
		}
	}
yy446:
	YYDEBUG(446, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy169;
				goto yy627;
			} else {
				if (yych == ' ') goto yy627;
				goto yy169;
			}
		} else {
			if (yych <= '9') {
				if (yych <= '.') goto yy444;
				goto yy169;
			} else {
				if (yych <= ':') goto yy632;
				if (yych <= '@') goto yy169;
				goto yy100;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'P') {
				if (yych <= 'O') goto yy169;
				goto yy100;
			} else {
				if (yych == 'a') goto yy100;
				goto yy169;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'p') goto yy100;
				if (yych <= 0xC1) goto yy169;
				goto yy628;
			} else {
				if (yych == 0xE2) goto yy629;
				goto yy169;
			}
		}
	}
yy447:
	YYDEBUG(447, *YYCURSOR);
	++YYCURSOR;
#line 1336 "parse_date.re"
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr(&ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr(&ptr, 2);
			}
		}
		timelib_eat_spaces(&ptr);
		s->time->h += timelib_meridian(&ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 11712 "<stdout>"
yy448:
	YYDEBUG(448, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy447;
		if (yych <= 0x08) goto yy55;
		goto yy447;
	} else {
		if (yych == ' ') goto yy447;
		goto yy55;
	}
yy449:
	YYDEBUG(449, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= 'a') {
		if (yych <= 'O') {
			if (yych <= 'E') {
				if (yych <= 'A') {
					if (yych <= '@') goto yy55;
					goto yy100;
				} else {
					if (yych == 'D') goto yy190;
					goto yy55;
				}
			} else {
				if (yych <= 'H') {
					if (yych <= 'F') goto yy191;
					if (yych <= 'G') goto yy55;
					goto yy73;
				} else {
					if (yych == 'M') goto yy192;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'U') {
				if (yych <= 'R') {
					if (yych <= 'P') goto yy100;
					goto yy55;
				} else {
					if (yych <= 'S') goto yy193;
					if (yych <= 'T') goto yy81;
					goto yy82;
				}
			} else {
				if (yych <= 'X') {
					if (yych == 'W') goto yy84;
					goto yy55;
				} else {
					if (yych <= 'Y') goto yy86;
					if (yych <= '`') goto yy55;
					goto yy100;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy55;
					goto yy190;
				} else {
					if (yych == 'f') goto yy191;
					goto yy55;
				}
			} else {
				if (yych <= 'm') {
					if (yych <= 'h') goto yy73;
					if (yych <= 'l') goto yy55;
					goto yy192;
				} else {
					if (yych == 'p') goto yy100;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'u') {
					if (yych <= 's') goto yy193;
					if (yych <= 't') goto yy81;
					goto yy82;
				} else {
					if (yych == 'w') goto yy84;
					goto yy55;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 'y') goto yy86;
					if (yych <= 0xC1) goto yy55;
					goto yy203;
				} else {
					if (yych == 0xE2) goto yy102;
					goto yy55;
				}
			}
		}
	}
yy450:
	YYDEBUG(450, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy633;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy634;
	goto yy55;
yy451:
	YYDEBUG(451, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy633;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy634;
	goto yy55;
yy452:
	YYDEBUG(452, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy633;
	goto yy55;
yy453:
	YYDEBUG(453, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy635;
		if (yych <= 'T') goto yy55;
		goto yy636;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy55;
			goto yy635;
		} else {
			if (yych == 'u') goto yy636;
			goto yy55;
		}
	}
yy454:
	YYDEBUG(454, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy637;
	if (yych == 'e') goto yy637;
	goto yy55;
yy455:
	YYDEBUG(455, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy638;
	if (yych == 'e') goto yy638;
	goto yy55;
yy456:
	YYDEBUG(456, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy639;
		if (yych <= 'T') goto yy55;
		goto yy640;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy639;
		} else {
			if (yych == 'u') goto yy640;
			goto yy55;
		}
	}
yy457:
	YYDEBUG(457, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy641;
	if (yych == 'a') goto yy641;
	goto yy55;
yy458:
	YYDEBUG(458, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy642;
	if (yych == 'o') goto yy642;
	goto yy55;
yy459:
	YYDEBUG(459, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy643;
	if (yych == 'c') goto yy643;
	goto yy55;
yy460:
	YYDEBUG(460, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy644;
	if (yych == 'e') goto yy644;
	goto yy55;
yy461:
	YYDEBUG(461, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy281;
	if (yych <= '9') goto yy645;
	goto yy281;
yy462:
	YYDEBUG(462, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy646;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy646;
		goto yy16;
	}
yy463:
	YYDEBUG(463, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy134;
	if (yych <= '2') goto yy647;
	if (yych <= '3') goto yy648;
	goto yy134;
yy464:
	YYDEBUG(464, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'K') goto yy646;
			goto yy649;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'l') goto yy649;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy465:
	YYDEBUG(465, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy646;
			goto yy650;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 's') goto yy650;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy466:
	YYDEBUG(466, *YYCURSOR);
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 64) {
		goto yy466;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy288;
		goto yy16;
	} else {
		if (yych <= '/') goto yy288;
		if (yych == '_') goto yy288;
		goto yy16;
	}
yy467:
	YYDEBUG(467, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			goto yy288;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy16;
			if (yych <= 'Z') goto yy646;
			goto yy16;
		} else {
			if (yych <= '_') goto yy288;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy651;
			goto yy16;
		}
	}
yy468:
	YYDEBUG(468, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 64) {
		goto yy466;
	}
	if (yych <= '/') goto yy134;
	if (yych <= '2') goto yy647;
	if (yych <= '3') goto yy648;
	goto yy134;
yy469:
	YYDEBUG(469, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy649;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'l') goto yy652;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy470:
	YYDEBUG(470, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy650;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 's') goto yy653;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy471:
	YYDEBUG(471, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy654;
		if (yych <= '(') goto yy16;
		goto yy107;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy16;
			goto yy646;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy472:
	YYDEBUG(472, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy654;
			goto yy16;
		} else {
			if (yych <= ')') goto yy107;
			if (yych == '-') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy288;
			if (yych <= '@') goto yy16;
			if (yych <= 'Z') goto yy646;
			goto yy16;
		} else {
			if (yych <= '_') goto yy288;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy651;
			goto yy16;
		}
	}
yy473:
	YYDEBUG(473, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'L') goto yy646;
			goto yy655;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'm') goto yy655;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy474:
	YYDEBUG(474, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy655;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'm') goto yy656;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy475:
	YYDEBUG(475, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy646;
			goto yy657;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 't') goto yy657;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy476:
	YYDEBUG(476, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy646;
			goto yy658;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'e') goto yy658;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy477:
	YYDEBUG(477, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy657;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 't') goto yy659;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy478:
	YYDEBUG(478, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy658;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'e') goto yy660;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy479:
	YYDEBUG(479, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'T') goto yy646;
			goto yy661;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'u') goto yy661;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy480:
	YYDEBUG(480, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'G') goto yy646;
			goto yy662;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'h') goto yy662;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy481:
	YYDEBUG(481, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy646;
			goto yy663;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 't') goto yy663;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy482:
	YYDEBUG(482, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy646;
			goto yy664;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 't') goto yy664;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy483:
	YYDEBUG(483, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy107;
		if (yych <= '@') goto yy16;
		goto yy665;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy646;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy665;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy484:
	YYDEBUG(484, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy646;
			goto yy666;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 't') goto yy666;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy485:
	YYDEBUG(485, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy661;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'u') goto yy667;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy486:
	YYDEBUG(486, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy662;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'h') goto yy668;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy487:
	YYDEBUG(487, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy663;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 't') goto yy669;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy488:
	YYDEBUG(488, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy664;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 't') goto yy670;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy489:
	YYDEBUG(489, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy665;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy671;
			if (yych <= 'z') goto yy651;
			goto yy16;
		}
	}
yy490:
	YYDEBUG(490, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy666;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 't') goto yy672;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy491:
	YYDEBUG(491, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy673;
	if (yych <= '2') goto yy674;
	if (yych <= '9') goto yy675;
	goto yy55;
yy492:
	YYDEBUG(492, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy676;
		goto yy55;
	} else {
		if (yych <= '0') goto yy677;
		if (yych <= '9') goto yy495;
		if (yych <= ':') goto yy676;
		goto yy55;
	}
yy493:
	YYDEBUG(493, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy678;
		goto yy55;
	} else {
		if (yych <= '2') goto yy495;
		if (yych <= '9') goto yy677;
		if (yych <= ':') goto yy678;
		goto yy55;
	}
yy494:
	YYDEBUG(494, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy678;
		goto yy55;
	} else {
		if (yych <= '4') goto yy677;
		if (yych == ':') goto yy678;
		goto yy55;
	}
yy495:
	YYDEBUG(495, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy678;
	if (yych == ':') goto yy678;
	goto yy55;
yy496:
	YYDEBUG(496, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy679;
	if (yych <= '2') goto yy680;
	if (yych <= '9') goto yy677;
	goto yy55;
yy497:
	YYDEBUG(497, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy676;
		goto yy316;
	} else {
		if (yych <= '0') goto yy681;
		if (yych <= '9') goto yy682;
		if (yych <= ':') goto yy676;
		goto yy316;
	}
yy498:
	YYDEBUG(498, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy678;
		goto yy316;
	} else {
		if (yych <= '2') goto yy682;
		if (yych <= '9') goto yy681;
		if (yych <= ':') goto yy678;
		goto yy316;
	}
yy499:
	YYDEBUG(499, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy678;
		goto yy316;
	} else {
		if (yych <= '4') goto yy681;
		if (yych <= '9') goto yy683;
		if (yych <= ':') goto yy678;
		goto yy316;
	}
yy500:
	YYDEBUG(500, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy678;
		goto yy316;
	} else {
		if (yych <= '9') goto yy683;
		if (yych <= ':') goto yy678;
		goto yy316;
	}
yy501:
	YYDEBUG(501, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy684;
	goto yy55;
yy502:
	YYDEBUG(502, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x00) goto yy315;
	goto yy318;
yy503:
	YYDEBUG(503, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy107;
		if (yych <= '@') goto yy16;
		goto yy685;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy646;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy685;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy504:
	YYDEBUG(504, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy134;
			goto yy286;
		} else {
			if (yych <= ' ') goto yy134;
			if (yych == ')') goto yy107;
			goto yy286;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy286;
			if (yych <= '9') goto yy134;
			goto yy286;
		} else {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy286;
			if (yych <= 'z') goto yy646;
			goto yy286;
		}
	}
yy505:
	YYDEBUG(505, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy685;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy686;
			if (yych <= 'z') goto yy651;
			goto yy16;
		}
	}
yy506:
	YYDEBUG(506, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy134;
			if (yych <= 0x1F) goto yy286;
			goto yy134;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy286;
				goto yy107;
			} else {
				if (yych <= ',') goto yy286;
				if (yych <= '-') goto yy687;
				goto yy134;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy288;
			if (yych <= '9') goto yy134;
			if (yych <= '@') goto yy286;
			goto yy646;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy286;
				goto yy288;
			} else {
				if (yych <= '`') goto yy286;
				if (yych <= 'z') goto yy651;
				goto yy286;
			}
		}
	}
yy507:
	YYDEBUG(507, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy688;
			goto yy16;
		} else {
			if (yych <= ' ') goto yy690;
			if (yych == ')') goto yy107;
			goto yy16;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy646;
			goto yy16;
		} else {
			if (yych <= 0xC2) goto yy691;
			if (yych == 0xE2) goto yy692;
			goto yy16;
		}
	}
yy508:
	YYDEBUG(508, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy688;
			} else {
				if (yych == ' ') goto yy690;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy107;
				goto yy16;
			} else {
				if (yych == '.') goto yy16;
				goto yy288;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy16;
				goto yy646;
			} else {
				if (yych == '_') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'z') goto yy651;
				if (yych <= 0xC1) goto yy16;
				goto yy691;
			} else {
				if (yych == 0xE2) goto yy692;
				goto yy16;
			}
		}
	}
yy509:
	YYDEBUG(509, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'G') goto yy646;
			goto yy649;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'h') goto yy649;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy510:
	YYDEBUG(510, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'H') goto yy646;
			goto yy693;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'i') goto yy693;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy511:
	YYDEBUG(511, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy649;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'h') goto yy652;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy512:
	YYDEBUG(512, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy693;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'i') goto yy694;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy513:
	YYDEBUG(513, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy688;
			goto yy16;
		} else {
			if (yych <= ' ') goto yy688;
			if (yych == ')') goto yy107;
			goto yy16;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy646;
			goto yy16;
		} else {
			if (yych <= 0xC2) goto yy691;
			if (yych == 0xE2) goto yy692;
			goto yy16;
		}
	}
yy514:
	YYDEBUG(514, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy107;
	} else {
		if (yych <= 'Z') goto yy646;
		if (yych <= '`') goto yy515;
		if (yych <= 'z') goto yy646;
	}
yy515:
	YYDEBUG(515, *YYCURSOR);
#line 1173 "parse_date.re"
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 13049 "<stdout>"
yy516:
	YYDEBUG(516, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy688;
			} else {
				if (yych == ' ') goto yy688;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy107;
				goto yy16;
			} else {
				if (yych == '.') goto yy16;
				goto yy288;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy16;
				goto yy646;
			} else {
				if (yych == '_') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'z') goto yy651;
				if (yych <= 0xC1) goto yy16;
				goto yy691;
			} else {
				if (yych == 0xE2) goto yy692;
				goto yy16;
			}
		}
	}
yy517:
	YYDEBUG(517, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy515;
		} else {
			if (yych == '.') goto yy515;
			goto yy288;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy515;
			if (yych <= 'Z') goto yy646;
			goto yy515;
		} else {
			if (yych <= '_') goto yy288;
			if (yych <= '`') goto yy515;
			if (yych <= 'z') goto yy651;
			goto yy515;
		}
	}
yy518:
	YYDEBUG(518, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'A') goto yy646;
			goto yy695;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'b') goto yy695;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy519:
	YYDEBUG(519, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy695;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'b') goto yy696;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy520:
	YYDEBUG(520, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'H') goto yy646;
			goto yy697;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'i') goto yy697;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy521:
	YYDEBUG(521, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy697;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'i') goto yy698;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy522:
	YYDEBUG(522, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy646;
			goto yy699;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'r') goto yy699;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy523:
	YYDEBUG(523, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy646;
			goto yy700;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'n') goto yy700;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy524:
	YYDEBUG(524, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy107;
				goto yy286;
			} else {
				if (yych <= '-') goto yy463;
				if (yych <= '.') goto yy134;
				goto yy286;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy134;
				goto yy286;
			} else {
				if (yych == 'E') goto yy701;
				goto yy646;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy286;
				goto yy646;
			} else {
				if (yych <= 'e') goto yy701;
				if (yych <= 'z') goto yy646;
				goto yy286;
			}
		}
	}
yy525:
	YYDEBUG(525, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy646;
			goto yy702;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'n') goto yy702;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy526:
	YYDEBUG(526, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy699;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'r') goto yy703;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy527:
	YYDEBUG(527, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy700;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'n') goto yy704;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy528:
	YYDEBUG(528, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy286;
				goto yy134;
			} else {
				if (yych == ' ') goto yy134;
				goto yy286;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy107;
				if (yych <= ',') goto yy286;
				goto yy468;
			} else {
				if (yych == '/') goto yy288;
				goto yy134;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy286;
				goto yy646;
			} else {
				if (yych <= 'E') goto yy701;
				if (yych <= 'Z') goto yy646;
				goto yy286;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy288;
				if (yych <= '`') goto yy286;
				goto yy651;
			} else {
				if (yych <= 'e') goto yy705;
				if (yych <= 'z') goto yy651;
				goto yy286;
			}
		}
	}
yy529:
	YYDEBUG(529, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy702;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'n') goto yy706;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy530:
	YYDEBUG(530, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy707;
	goto yy55;
yy531:
	YYDEBUG(531, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy646;
			goto yy662;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'd') goto yy662;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy532:
	YYDEBUG(532, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy646;
			goto yy699;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 's') goto yy699;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy533:
	YYDEBUG(533, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'X') goto yy646;
			goto yy708;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'y') goto yy708;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy534:
	YYDEBUG(534, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy646;
			goto yy710;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'r') goto yy710;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy535:
	YYDEBUG(535, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy646;
			goto yy711;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'd') goto yy711;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy536:
	YYDEBUG(536, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'E') goto yy646;
			goto yy702;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'f') goto yy702;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy537:
	YYDEBUG(537, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy662;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'd') goto yy668;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy538:
	YYDEBUG(538, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy699;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 's') goto yy703;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy539:
	YYDEBUG(539, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy708;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'y') goto yy712;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy540:
	YYDEBUG(540, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy710;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'r') goto yy713;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy541:
	YYDEBUG(541, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy711;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'd') goto yy714;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy542:
	YYDEBUG(542, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'F') goto yy702;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'e') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'f') goto yy706;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy543:
	YYDEBUG(543, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy134;
			goto yy16;
		} else {
			if (yych <= ' ') goto yy134;
			if (yych == ')') goto yy107;
			goto yy16;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy16;
			if (yych <= '9') goto yy134;
			goto yy16;
		} else {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy544:
	YYDEBUG(544, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy646;
			goto yy715;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'e') goto yy715;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy545:
	YYDEBUG(545, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy715;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'e') goto yy716;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy546:
	YYDEBUG(546, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy646;
			goto yy717;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy646;
			if (yych <= '`') goto yy16;
			goto yy646;
		} else {
			if (yych <= 'e') goto yy717;
			if (yych <= 'z') goto yy646;
			goto yy16;
		}
	}
yy547:
	YYDEBUG(547, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy646;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy717;
			if (yych <= 'Z') goto yy646;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy651;
			} else {
				if (yych <= 'e') goto yy718;
				if (yych <= 'z') goto yy651;
				goto yy16;
			}
		}
	}
yy548:
	YYDEBUG(548, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy186;
	goto yy55;
yy549:
	YYDEBUG(549, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '9') goto yy583;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy550:
	YYDEBUG(550, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '9') {
			if (yych <= ',') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy16;
					goto yy188;
				} else {
					if (yych == ' ') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '-') goto yy719;
					goto yy16;
				} else {
					if (yych <= '5') goto yy720;
					if (yych <= '6') goto yy721;
					goto yy722;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy16;
					goto yy188;
				} else {
					if (yych == 'F') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'H') goto yy188;
					if (yych <= 'L') goto yy16;
					goto yy188;
				} else {
					if (yych <= 'R') goto yy16;
					if (yych <= 'U') goto yy188;
					goto yy16;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy188;
					goto yy16;
				} else {
					if (yych <= 'Y') goto yy188;
					if (yych <= 'c') goto yy16;
					goto yy188;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy188;
					goto yy16;
				} else {
					if (yych <= 'h') goto yy188;
					if (yych <= 'l') goto yy16;
					goto yy188;
				}
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'u') {
					if (yych <= 'r') goto yy16;
					goto yy188;
				} else {
					if (yych == 'w') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 'y') goto yy188;
					if (yych <= 0xC1) goto yy16;
					goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
					goto yy16;
				}
			}
		}
	}
yy551:
	YYDEBUG(551, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy719;
		if (yych <= '/') goto yy188;
		goto yy722;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy552:
	YYDEBUG(552, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy16;
	if (yych <= '9') goto yy723;
	goto yy16;
yy553:
	YYDEBUG(553, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy724;
	goto yy55;
yy554:
	YYDEBUG(554, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy725;
	goto yy55;
yy555:
	YYDEBUG(555, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy556;
		if (yych <= '9') goto yy727;
		if (yych >= 'n') goto yy728;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy728;
		} else {
			if (yych <= 's') goto yy729;
			if (yych <= 't') goto yy730;
		}
	}
yy556:
	YYDEBUG(556, *YYCURSOR);
#line 1536 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 14108 "<stdout>"
yy557:
	YYDEBUG(557, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy556;
			goto yy727;
		} else {
			if (yych <= '9') goto yy724;
			if (yych <= 'm') goto yy556;
			goto yy728;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy556;
			goto yy728;
		} else {
			if (yych <= 's') goto yy729;
			if (yych <= 't') goto yy730;
			goto yy556;
		}
	}
yy558:
	YYDEBUG(558, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy556;
		if (yych <= '9') goto yy724;
		if (yych <= 'm') goto yy556;
		goto yy728;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy556;
			goto yy728;
		} else {
			if (yych <= 's') goto yy729;
			if (yych <= 't') goto yy730;
			goto yy556;
		}
	}
yy559:
	YYDEBUG(559, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy731;
	if (yych <= '/') goto yy169;
	if (yych <= '9') goto yy732;
	goto yy169;
yy560:
	YYDEBUG(560, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy731;
		goto yy169;
	} else {
		if (yych <= '0') goto yy732;
		if (yych <= '9') goto yy725;
		goto yy169;
	}
yy561:
	YYDEBUG(561, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy731;
	if (yych <= '/') goto yy169;
	if (yych <= '9') goto yy725;
	goto yy169;
yy562:
	YYDEBUG(562, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy731;
	if (yych <= '/') goto yy169;
	if (yych <= '9') goto yy564;
	goto yy169;
yy563:
	YYDEBUG(563, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy731;
	if (yych != '0') goto yy169;
yy564:
	YYDEBUG(564, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy731;
	goto yy169;
yy565:
	YYDEBUG(565, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy216;
	if (yych <= '9') goto yy733;
	goto yy216;
yy566:
	YYDEBUG(566, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy393;
	goto yy216;
yy567:
	YYDEBUG(567, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy734;
	goto yy55;
yy568:
	YYDEBUG(568, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy734;
		goto yy55;
	} else {
		if (yych <= 'T') goto yy567;
		if (yych == 't') goto yy567;
		goto yy55;
	}
yy569:
	YYDEBUG(569, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy55;
	if (yych <= '-') goto yy735;
	if (yych <= '.') goto yy387;
	goto yy55;
yy570:
	YYDEBUG(570, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy633;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy452;
	goto yy55;
yy571:
	YYDEBUG(571, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy633;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy452;
	goto yy55;
yy572:
	YYDEBUG(572, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy573:
	YYDEBUG(573, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy572;
					goto yy55;
				} else {
					if (yych <= ' ') goto yy572;
					if (yych <= ',') goto yy55;
					goto yy736;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy585;
					goto yy55;
				} else {
					if (yych <= 'D') goto yy586;
					if (yych == 'F') goto yy587;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy73;
					if (yych <= 'I') goto yy588;
					goto yy590;
				} else {
					if (yych <= 'L') goto yy55;
					if (yych <= 'M') goto yy591;
					goto yy592;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy593;
					if (yych <= 'R') goto yy55;
					goto yy594;
				} else {
					if (yych <= 'T') goto yy81;
					if (yych <= 'U') goto yy82;
					if (yych <= 'V') goto yy595;
					goto yy84;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy597;
					if (yych <= 'Y') goto yy86;
					goto yy55;
				} else {
					if (yych <= 'a') goto yy585;
					if (yych <= 'c') goto yy55;
					goto yy586;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy587;
					goto yy55;
				} else {
					if (yych <= 'h') goto yy73;
					if (yych == 'j') goto yy590;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy591;
					if (yych <= 'n') goto yy592;
					goto yy593;
				} else {
					if (yych <= 'r') goto yy55;
					if (yych <= 's') goto yy594;
					if (yych <= 't') goto yy81;
					goto yy82;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy84;
					goto yy55;
				} else {
					if (yych <= 'y') goto yy86;
					if (yych == 0xC2) goto yy203;
					goto yy55;
				}
			}
		}
	}
yy574:
	YYDEBUG(574, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy738;
		case '1': goto yy740;
		case '2': goto yy741;
		case '3': goto yy742;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy743;
		case 'A':
		case 'a': goto yy744;
		case 'D':
		case 'd': goto yy745;
		case 'F':
		case 'f': goto yy746;
		case 'J':
		case 'j': goto yy747;
		case 'M':
		case 'm': goto yy748;
		case 'N':
		case 'n': goto yy749;
		case 'O':
		case 'o': goto yy750;
		case 'S':
		case 's': goto yy751;
		case 'W': goto yy752;
		default: goto yy737;
	}
yy575:
	YYDEBUG(575, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy737;
	if (yych <= '0') goto yy753;
	if (yych <= '2') goto yy754;
	if (yych <= '3') goto yy755;
	goto yy737;
yy576:
	YYDEBUG(576, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy760;
	if (yych <= '1') goto yy761;
	if (yych <= '9') goto yy762;
	goto yy55;
yy577:
	YYDEBUG(577, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '0') goto yy763;
		if (yych <= '9') goto yy765;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy578:
	YYDEBUG(578, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '2') goto yy765;
		if (yych <= '9') goto yy766;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy579:
	YYDEBUG(579, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '9') goto yy766;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy580:
	YYDEBUG(580, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '/') goto yy188;
		if (yych <= '5') goto yy766;
		if (yych <= '6') goto yy767;
		goto yy768;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy581:
	YYDEBUG(581, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '9') goto yy768;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy582:
	YYDEBUG(582, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '0') goto yy768;
		if (yych <= '9') goto yy769;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy583:
	YYDEBUG(583, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '9') goto yy769;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy584:
	YYDEBUG(584, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy770;
	if (yych <= '1') goto yy771;
	goto yy55;
yy585:
	YYDEBUG(585, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy772;
		if (yych <= 'T') goto yy55;
		goto yy773;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy55;
			goto yy772;
		} else {
			if (yych == 'u') goto yy773;
			goto yy55;
		}
	}
yy586:
	YYDEBUG(586, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy234;
		if (yych <= 'D') goto yy55;
		goto yy774;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy234;
		} else {
			if (yych == 'e') goto yy774;
			goto yy55;
		}
	}
yy587:
	YYDEBUG(587, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy775;
			goto yy55;
		} else {
			if (yych <= 'O') goto yy237;
			if (yych <= 'Q') goto yy55;
			goto yy238;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy775;
			goto yy55;
		} else {
			if (yych <= 'o') goto yy237;
			if (yych == 'r') goto yy238;
			goto yy55;
		}
	}
yy588:
	YYDEBUG(588, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'I') goto yy776;
	} else {
		if (yych == 'W') goto yy589;
		if (yych <= 'X') goto yy777;
	}
yy589:
	YYDEBUG(589, *YYCURSOR);
#line 1605 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_month(&ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 14572 "<stdout>"
yy590:
	YYDEBUG(590, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy778;
		if (yych <= 'T') goto yy55;
		goto yy779;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy778;
		} else {
			if (yych == 'u') goto yy779;
			goto yy55;
		}
	}
yy591:
	YYDEBUG(591, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy780;
			if (yych <= 'H') goto yy55;
			goto yy248;
		} else {
			if (yych == 'O') goto yy249;
			if (yych <= 'R') goto yy55;
			goto yy250;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy780;
			if (yych <= 'h') goto yy55;
			goto yy248;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy55;
				goto yy249;
			} else {
				if (yych == 's') goto yy250;
				goto yy55;
			}
		}
	}
yy592:
	YYDEBUG(592, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy781;
	if (yych == 'o') goto yy781;
	goto yy55;
yy593:
	YYDEBUG(593, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy782;
	if (yych == 'c') goto yy782;
	goto yy55;
yy594:
	YYDEBUG(594, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy254;
			goto yy55;
		} else {
			if (yych <= 'E') goto yy783;
			if (yych <= 'T') goto yy55;
			goto yy256;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy254;
			goto yy55;
		} else {
			if (yych <= 'e') goto yy783;
			if (yych == 'u') goto yy256;
			goto yy55;
		}
	}
yy595:
	YYDEBUG(595, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy597;
	goto yy589;
yy596:
	YYDEBUG(596, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy55;
		if (yych <= '0') goto yy784;
		if (yych <= '4') goto yy785;
		goto yy786;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy55;
			goto yy260;
		} else {
			if (yych == 'e') goto yy260;
			goto yy55;
		}
	}
yy597:
	YYDEBUG(597, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy776;
	goto yy589;
yy598:
	YYDEBUG(598, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '0') goto yy787;
		if (yych <= '9') goto yy788;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy599:
	YYDEBUG(599, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '2') goto yy788;
		if (yych <= '9') goto yy789;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy600:
	YYDEBUG(600, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '9') goto yy789;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy601:
	YYDEBUG(601, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '/') goto yy188;
		if (yych <= '5') goto yy789;
		if (yych <= '6') goto yy790;
		goto yy769;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy602:
	YYDEBUG(602, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy244;
	if (yych == 'l') goto yy244;
	goto yy55;
yy603:
	YYDEBUG(603, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy791;
	if (yych == 's') goto yy791;
	goto yy55;
yy604:
	YYDEBUG(604, *YYCURSOR);
	++YYCURSOR;
	goto yy251;
yy605:
	YYDEBUG(605, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy615;
	if (yych == 'm') goto yy615;
	goto yy55;
yy606:
	YYDEBUG(606, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy609;
	if (yych == 'u') goto yy609;
	goto yy55;
yy607:
	YYDEBUG(607, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy792;
		if (yych <= 'M') goto yy55;
		goto yy793;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy55;
			goto yy792;
		} else {
			if (yych == 'n') goto yy793;
			goto yy55;
		}
	}
yy608:
	YYDEBUG(608, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy242;
	if (yych <= '9') goto yy794;
	goto yy242;
yy609:
	YYDEBUG(609, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy795;
	if (yych == 'a') goto yy795;
	goto yy55;
yy610:
	YYDEBUG(610, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy244;
	if (yych == 'h') goto yy244;
	goto yy55;
yy611:
	YYDEBUG(611, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy796;
	if (yych == 'o') goto yy796;
	goto yy55;
yy612:
	YYDEBUG(612, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy796;
	if (yych == 'i') goto yy796;
	goto yy55;
yy613:
	YYDEBUG(613, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy797;
	if (yych == 't') goto yy797;
	goto yy55;
yy614:
	YYDEBUG(614, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy416;
	if (yych == 'h') goto yy416;
	goto yy55;
yy615:
	YYDEBUG(615, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy798;
	if (yych == 'b') goto yy798;
	goto yy55;
yy616:
	YYDEBUG(616, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy619;
	if (yych == 'r') goto yy619;
	goto yy55;
yy617:
	YYDEBUG(617, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy799;
	if (yych == 'n') goto yy799;
	goto yy55;
yy618:
	YYDEBUG(618, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy619;
	if (yych != 's') goto yy55;
yy619:
	YYDEBUG(619, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy190;
	if (yych == 'd') goto yy190;
	goto yy55;
yy620:
	YYDEBUG(620, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy618;
	if (yych == 'e') goto yy618;
	goto yy55;
yy621:
	YYDEBUG(621, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy190;
		if (yych <= 'R') goto yy251;
		goto yy604;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy251;
			goto yy190;
		} else {
			if (yych == 's') goto yy604;
			goto yy251;
		}
	}
yy622:
	YYDEBUG(622, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy55;
	if (yych <= '.') goto yy387;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy624;
	goto yy55;
yy623:
	YYDEBUG(623, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy55;
	if (yych <= '.') goto yy387;
	if (yych <= '/') goto yy55;
	if (yych >= '3') goto yy55;
yy624:
	YYDEBUG(624, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy55;
	if (yych <= '.') goto yy387;
	goto yy55;
yy625:
	YYDEBUG(625, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy731;
	if (yych <= '/') goto yy169;
	if (yych <= '9') goto yy800;
	goto yy169;
yy626:
	YYDEBUG(626, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy731;
		goto yy169;
	} else {
		if (yych <= '0') goto yy800;
		if (yych <= '9') goto yy725;
		goto yy169;
	}
yy627:
	YYDEBUG(627, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy627;
			goto yy55;
		} else {
			if (yych <= ' ') goto yy627;
			if (yych <= '@') goto yy55;
			goto yy100;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy100;
			goto yy55;
		} else {
			if (yych <= 'a') goto yy100;
			if (yych == 'p') goto yy100;
			goto yy55;
		}
	}
yy628:
	YYDEBUG(628, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy801;
	goto yy55;
yy629:
	YYDEBUG(629, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy802;
	goto yy55;
yy630:
	YYDEBUG(630, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy731;
	if (yych <= '/') goto yy169;
	if (yych <= '9') goto yy803;
	goto yy169;
yy631:
	YYDEBUG(631, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy731;
	if (yych == '0') goto yy803;
	goto yy169;
yy632:
	YYDEBUG(632, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy804;
	if (yych <= '6') goto yy805;
	if (yych <= '9') goto yy564;
	goto yy55;
yy633:
	YYDEBUG(633, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy806;
	if (yych <= '3') goto yy807;
	if (yych <= '9') goto yy808;
	goto yy55;
yy634:
	YYDEBUG(634, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy809;
	goto yy55;
yy635:
	YYDEBUG(635, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy810;
	if (yych == 'r') goto yy810;
	goto yy55;
yy636:
	YYDEBUG(636, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy810;
	if (yych == 'g') goto yy810;
	goto yy55;
yy637:
	YYDEBUG(637, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy810;
	if (yych == 'c') goto yy810;
	goto yy55;
yy638:
	YYDEBUG(638, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy810;
	if (yych == 'b') goto yy810;
	goto yy55;
yy639:
	YYDEBUG(639, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy810;
	if (yych == 'n') goto yy810;
	goto yy55;
yy640:
	YYDEBUG(640, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy810;
		if (yych <= 'M') goto yy55;
		goto yy810;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy55;
			goto yy810;
		} else {
			if (yych == 'n') goto yy810;
			goto yy55;
		}
	}
yy641:
	YYDEBUG(641, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy810;
		if (yych <= 'X') goto yy55;
		goto yy810;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy55;
			goto yy810;
		} else {
			if (yych == 'y') goto yy810;
			goto yy55;
		}
	}
yy642:
	YYDEBUG(642, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy810;
	if (yych == 'v') goto yy810;
	goto yy55;
yy643:
	YYDEBUG(643, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy810;
	if (yych == 't') goto yy810;
	goto yy55;
yy644:
	YYDEBUG(644, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy811;
	if (yych == 'p') goto yy811;
	goto yy55;
yy645:
	YYDEBUG(645, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy281;
	if (yych <= '9') goto yy812;
	goto yy281;
yy646:
	YYDEBUG(646, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy813;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy813;
		goto yy16;
	}
yy647:
	YYDEBUG(647, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy315;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy317;
				if (yych <= 0x1F) goto yy55;
				goto yy317;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy317;
				goto yy55;
			} else {
				if (yych <= '.') goto yy317;
				if (yych <= '/') goto yy55;
				goto yy814;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy55;
				goto yy317;
			} else {
				if (yych == 'h') goto yy317;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy320;
				if (yych <= 'q') goto yy55;
				goto yy320;
			} else {
				if (yych <= 's') goto yy321;
				if (yych <= 't') goto yy322;
				goto yy55;
			}
		}
	}
yy648:
	YYDEBUG(648, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy315;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy317;
				if (yych <= 0x1F) goto yy55;
				goto yy317;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy317;
				goto yy55;
			} else {
				if (yych <= '.') goto yy317;
				if (yych <= '/') goto yy55;
				goto yy814;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy323;
				if (yych <= 'c') goto yy55;
				goto yy317;
			} else {
				if (yych == 'h') goto yy317;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy320;
				if (yych <= 'q') goto yy55;
				goto yy320;
			} else {
				if (yych <= 's') goto yy321;
				if (yych <= 't') goto yy322;
				goto yy55;
			}
		}
	}
yy649:
	YYDEBUG(649, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy134;
			goto yy286;
		} else {
			if (yych <= ' ') goto yy134;
			if (yych == ')') goto yy107;
			goto yy286;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy286;
			if (yych <= '9') goto yy134;
			goto yy286;
		} else {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy286;
			if (yych <= 'z') goto yy813;
			goto yy286;
		}
	}
yy650:
	YYDEBUG(650, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy813;
			goto yy815;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy16;
			goto yy813;
		} else {
			if (yych <= 't') goto yy815;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy651:
	YYDEBUG(651, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			goto yy288;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy16;
			if (yych <= 'Z') goto yy813;
			goto yy16;
		} else {
			if (yych <= '_') goto yy288;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy816;
			goto yy16;
		}
	}
yy652:
	YYDEBUG(652, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy134;
			if (yych <= 0x1F) goto yy286;
			goto yy134;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy286;
				goto yy107;
			} else {
				if (yych <= ',') goto yy286;
				if (yych <= '-') goto yy687;
				goto yy134;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy288;
			if (yych <= '9') goto yy134;
			if (yych <= '@') goto yy286;
			goto yy813;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy286;
				goto yy288;
			} else {
				if (yych <= '`') goto yy286;
				if (yych <= 'z') goto yy816;
				goto yy286;
			}
		}
	}
yy653:
	YYDEBUG(653, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy813;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy815;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy816;
			} else {
				if (yych <= 't') goto yy817;
				if (yych <= 'z') goto yy816;
				goto yy16;
			}
		}
	}
yy654:
	YYDEBUG(654, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy818;
	if (yych == 'o') goto yy818;
	goto yy55;
yy655:
	YYDEBUG(655, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'A') goto yy813;
			goto yy819;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy16;
			goto yy813;
		} else {
			if (yych <= 'b') goto yy819;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy656:
	YYDEBUG(656, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy813;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy819;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy16;
				goto yy816;
			} else {
				if (yych <= 'b') goto yy820;
				if (yych <= 'z') goto yy816;
				goto yy16;
			}
		}
	}
yy657:
	YYDEBUG(657, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy821;
			if (yych <= 0x1F) goto yy16;
			goto yy821;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy107;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'G') goto yy813;
				goto yy823;
			}
		}
	} else {
		if (yych <= 'z') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy813;
				goto yy16;
			} else {
				if (yych == 'h') goto yy823;
				goto yy813;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy16;
				goto yy824;
			} else {
				if (yych == 0xE2) goto yy825;
				goto yy16;
			}
		}
	}
yy658:
	YYDEBUG(658, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy813;
			goto yy826;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy16;
			goto yy813;
		} else {
			if (yych <= 'n') goto yy826;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy659:
	YYDEBUG(659, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= 0x1F) {
				if (yych == '\t') goto yy821;
				goto yy16;
			} else {
				if (yych <= ' ') goto yy821;
				if (yych <= '(') goto yy16;
				goto yy107;
			}
		} else {
			if (yych <= '.') {
				if (yych == '-') goto yy288;
				goto yy16;
			} else {
				if (yych <= '/') goto yy288;
				if (yych <= '@') goto yy16;
				goto yy813;
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= '^') {
				if (yych <= 'H') goto yy823;
				if (yych <= 'Z') goto yy813;
				goto yy16;
			} else {
				if (yych <= '_') goto yy288;
				if (yych <= '`') goto yy16;
				goto yy816;
			}
		} else {
			if (yych <= 0xC1) {
				if (yych <= 'h') goto yy827;
				if (yych <= 'z') goto yy816;
				goto yy16;
			} else {
				if (yych <= 0xC2) goto yy824;
				if (yych == 0xE2) goto yy825;
				goto yy16;
			}
		}
	}
yy660:
	YYDEBUG(660, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy813;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy826;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy16;
				goto yy816;
			} else {
				if (yych <= 'n') goto yy828;
				if (yych <= 'z') goto yy816;
				goto yy16;
			}
		}
	}
yy661:
	YYDEBUG(661, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy107;
		if (yych <= '@') goto yy16;
		goto yy829;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy813;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy829;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy662:
	YYDEBUG(662, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy821;
			goto yy16;
		} else {
			if (yych <= ' ') goto yy821;
			if (yych == ')') goto yy107;
			goto yy16;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy813;
			goto yy16;
		} else {
			if (yych <= 0xC2) goto yy824;
			if (yych == 0xE2) goto yy825;
			goto yy16;
		}
	}
yy663:
	YYDEBUG(663, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy821;
			goto yy16;
		} else {
			if (yych <= ' ') goto yy830;
			if (yych == ')') goto yy107;
			goto yy16;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy813;
			goto yy16;
		} else {
			if (yych <= 0xC2) goto yy824;
			if (yych == 0xE2) goto yy825;
			goto yy16;
		}
	}
yy664:
	YYDEBUG(664, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'G') goto yy813;
			goto yy823;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy16;
			goto yy813;
		} else {
			if (yych <= 'h') goto yy823;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy665:
	YYDEBUG(665, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'X') goto yy813;
			goto yy831;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy16;
			goto yy813;
		} else {
			if (yych <= 'y') goto yy831;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy666:
	YYDEBUG(666, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy654;
		if (yych <= '(') goto yy16;
		goto yy107;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy16;
			goto yy813;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy667:
	YYDEBUG(667, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy829;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy832;
			if (yych <= 'z') goto yy816;
			goto yy16;
		}
	}
yy668:
	YYDEBUG(668, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy821;
			} else {
				if (yych == ' ') goto yy821;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy107;
				goto yy16;
			} else {
				if (yych == '.') goto yy16;
				goto yy288;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy16;
				goto yy813;
			} else {
				if (yych == '_') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'z') goto yy816;
				if (yych <= 0xC1) goto yy16;
				goto yy824;
			} else {
				if (yych == 0xE2) goto yy825;
				goto yy16;
			}
		}
	}
yy669:
	YYDEBUG(669, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy821;
			} else {
				if (yych == ' ') goto yy830;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy107;
				goto yy16;
			} else {
				if (yych == '.') goto yy16;
				goto yy288;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy16;
				goto yy813;
			} else {
				if (yych == '_') goto yy288;
				goto yy16;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'z') goto yy816;
				if (yych <= 0xC1) goto yy16;
				goto yy824;
			} else {
				if (yych == 0xE2) goto yy825;
				goto yy16;
			}
		}
	}
yy670:
	YYDEBUG(670, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy813;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy823;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy16;
				goto yy816;
			} else {
				if (yych <= 'h') goto yy827;
				if (yych <= 'z') goto yy816;
				goto yy16;
			}
		}
	}
yy671:
	YYDEBUG(671, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy813;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy831;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy16;
				goto yy816;
			} else {
				if (yych <= 'y') goto yy833;
				if (yych <= 'z') goto yy816;
				goto yy16;
			}
		}
	}
yy672:
	YYDEBUG(672, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy654;
			goto yy16;
		} else {
			if (yych <= ')') goto yy107;
			if (yych == '-') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy288;
			if (yych <= '@') goto yy16;
			if (yych <= 'Z') goto yy813;
			goto yy16;
		} else {
			if (yych <= '_') goto yy288;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy816;
			goto yy16;
		}
	}
yy673:
	YYDEBUG(673, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy16;
	if (yych <= '9') goto yy834;
	if (yych <= ':') goto yy195;
	goto yy16;
yy674:
	YYDEBUG(674, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '5') {
		if (yych <= '/') goto yy16;
		if (yych <= '4') goto yy834;
		goto yy385;
	} else {
		if (yych <= '9') goto yy107;
		if (yych <= ':') goto yy195;
		goto yy16;
	}
yy675:
	YYDEBUG(675, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy16;
	if (yych <= '5') goto yy385;
	if (yych <= '9') goto yy107;
	if (yych <= ':') goto yy195;
	goto yy16;
yy676:
	YYDEBUG(676, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy835;
	if (yych <= '9') goto yy837;
	goto yy55;
yy677:
	YYDEBUG(677, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy676;
	if (yych == ':') goto yy676;
	goto yy55;
yy678:
	YYDEBUG(678, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy838;
	if (yych <= '9') goto yy839;
	goto yy55;
yy679:
	YYDEBUG(679, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy676;
		goto yy55;
	} else {
		if (yych <= '9') goto yy677;
		if (yych <= ':') goto yy676;
		goto yy55;
	}
yy680:
	YYDEBUG(680, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy676;
		goto yy55;
	} else {
		if (yych <= '4') goto yy677;
		if (yych == ':') goto yy676;
		goto yy55;
	}
yy681:
	YYDEBUG(681, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy676;
		goto yy316;
	} else {
		if (yych <= '9') goto yy840;
		if (yych <= ':') goto yy676;
		goto yy316;
	}
yy682:
	YYDEBUG(682, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy678;
		goto yy316;
	} else {
		if (yych <= '9') goto yy840;
		if (yych <= ':') goto yy678;
		goto yy316;
	}
yy683:
	YYDEBUG(683, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy316;
	if (yych <= '9') goto yy840;
	goto yy316;
yy684:
	YYDEBUG(684, *YYCURSOR);
	++YYCURSOR;
#line 1591 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 15958 "<stdout>"
yy685:
	YYDEBUG(685, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy813;
			goto yy841;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy16;
			goto yy813;
		} else {
			if (yych <= 'r') goto yy841;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy686:
	YYDEBUG(686, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy813;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy841;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy16;
				goto yy816;
			} else {
				if (yych <= 'r') goto yy842;
				if (yych <= 'z') goto yy816;
				goto yy16;
			}
		}
	}
yy687:
	YYDEBUG(687, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 64) {
		goto yy466;
	}
	goto yy134;
yy688:
	YYDEBUG(688, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy689:
	YYDEBUG(689, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy688;
				if (yych <= 0x1F) goto yy55;
				goto yy688;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy55;
					goto yy843;
				} else {
					if (yych == 'F') goto yy844;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy845;
					goto yy55;
				} else {
					if (yych <= 'M') goto yy846;
					if (yych <= 'R') goto yy55;
					goto yy847;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy848;
					goto yy849;
				} else {
					if (yych == 'W') goto yy850;
					goto yy55;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy851;
					goto yy55;
				} else {
					if (yych <= 'd') goto yy843;
					if (yych <= 'e') goto yy55;
					goto yy844;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy55;
					goto yy845;
				} else {
					if (yych == 'm') goto yy846;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy847;
					goto yy848;
				} else {
					if (yych <= 'u') goto yy849;
					if (yych <= 'v') goto yy55;
					goto yy850;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy55;
					goto yy851;
				} else {
					if (yych == 0xC2) goto yy852;
					goto yy55;
				}
			}
		}
	}
yy690:
	YYDEBUG(690, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy853;
	if (yych == 'd') goto yy853;
	goto yy689;
yy691:
	YYDEBUG(691, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xA0) goto yy854;
	goto yy55;
yy692:
	YYDEBUG(692, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy855;
	goto yy55;
yy693:
	YYDEBUG(693, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'F') goto yy813;
			goto yy856;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy16;
			goto yy813;
		} else {
			if (yych <= 'g') goto yy856;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy694:
	YYDEBUG(694, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy813;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy856;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy16;
				goto yy816;
			} else {
				if (yych <= 'g') goto yy857;
				if (yych <= 'z') goto yy816;
				goto yy16;
			}
		}
	}
yy695:
	YYDEBUG(695, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy813;
			goto yy858;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy16;
			goto yy813;
		} else {
			if (yych <= 'e') goto yy858;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy696:
	YYDEBUG(696, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy813;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy858;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy816;
			} else {
				if (yych <= 'e') goto yy859;
				if (yych <= 'z') goto yy816;
				goto yy16;
			}
		}
	}
yy697:
	YYDEBUG(697, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy813;
			goto yy860;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy16;
			goto yy813;
		} else {
			if (yych <= 'o') goto yy860;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy698:
	YYDEBUG(698, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy813;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy860;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy16;
				goto yy816;
			} else {
				if (yych <= 'o') goto yy861;
				if (yych <= 'z') goto yy816;
				goto yy16;
			}
		}
	}
yy699:
	YYDEBUG(699, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy813;
			goto yy862;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy16;
			goto yy813;
		} else {
			if (yych <= 'd') goto yy862;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy700:
	YYDEBUG(700, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy813;
			goto yy823;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy16;
			goto yy813;
		} else {
			if (yych <= 'd') goto yy823;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy701:
	YYDEBUG(701, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'L') goto yy813;
			goto yy863;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy16;
			goto yy813;
		} else {
			if (yych <= 'm') goto yy863;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy702:
	YYDEBUG(702, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy813;
			goto yy864;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy16;
			goto yy813;
		} else {
			if (yych <= 't') goto yy864;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy703:
	YYDEBUG(703, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy813;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy862;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy16;
				goto yy816;
			} else {
				if (yych <= 'd') goto yy865;
				if (yych <= 'z') goto yy816;
				goto yy16;
			}
		}
	}
yy704:
	YYDEBUG(704, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy813;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy823;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy16;
				goto yy816;
			} else {
				if (yych <= 'd') goto yy827;
				if (yych <= 'z') goto yy816;
				goto yy16;
			}
		}
	}
yy705:
	YYDEBUG(705, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy813;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy863;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy16;
				goto yy816;
			} else {
				if (yych <= 'm') goto yy866;
				if (yych <= 'z') goto yy816;
				goto yy16;
			}
		}
	}
yy706:
	YYDEBUG(706, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy813;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy864;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy816;
			} else {
				if (yych <= 't') goto yy867;
				if (yych <= 'z') goto yy816;
				goto yy16;
			}
		}
	}
yy707:
	YYDEBUG(707, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy411;
	if (yych <= '5') goto yy868;
	if (yych <= '6') goto yy869;
	goto yy411;
yy708:
	YYDEBUG(708, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy107;
	} else {
		if (yych <= 'Z') goto yy813;
		if (yych <= '`') goto yy709;
		if (yych <= 'z') goto yy813;
	}
yy709:
	YYDEBUG(709, *YYCURSOR);
#line 1185 "parse_date.re"
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 16528 "<stdout>"
yy710:
	YYDEBUG(710, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy813;
			goto yy870;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy16;
			goto yy813;
		} else {
			if (yych <= 'r') goto yy870;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy711:
	YYDEBUG(711, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy107;
		if (yych <= '@') goto yy16;
		goto yy871;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy813;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy871;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy712:
	YYDEBUG(712, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy709;
		} else {
			if (yych == '.') goto yy709;
			goto yy288;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy709;
			if (yych <= 'Z') goto yy813;
			goto yy709;
		} else {
			if (yych <= '_') goto yy288;
			if (yych <= '`') goto yy709;
			if (yych <= 'z') goto yy816;
			goto yy709;
		}
	}
yy713:
	YYDEBUG(713, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy813;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy870;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy16;
				goto yy816;
			} else {
				if (yych <= 'r') goto yy872;
				if (yych <= 'z') goto yy816;
				goto yy16;
			}
		}
	}
yy714:
	YYDEBUG(714, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy871;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy873;
			if (yych <= 'z') goto yy816;
			goto yy16;
		}
	}
yy715:
	YYDEBUG(715, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy813;
			goto yy874;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy16;
			goto yy813;
		} else {
			if (yych <= 's') goto yy874;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy716:
	YYDEBUG(716, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy813;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy874;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy16;
				goto yy816;
			} else {
				if (yych <= 's') goto yy875;
				if (yych <= 'z') goto yy816;
				goto yy16;
			}
		}
	}
yy717:
	YYDEBUG(717, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy107;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy813;
			goto yy876;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy813;
			if (yych <= '`') goto yy16;
			goto yy813;
		} else {
			if (yych <= 'r') goto yy876;
			if (yych <= 'z') goto yy813;
			goto yy16;
		}
	}
yy718:
	YYDEBUG(718, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		} else {
			if (yych == '/') goto yy288;
			if (yych <= '@') goto yy16;
			goto yy813;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy876;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy16;
				goto yy816;
			} else {
				if (yych <= 'r') goto yy877;
				if (yych <= 'z') goto yy816;
				goto yy16;
			}
		}
	}
yy719:
	YYDEBUG(719, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy878;
	if (yych <= '1') goto yy879;
	goto yy55;
yy720:
	YYDEBUG(720, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy880;
		if (yych <= '/') goto yy188;
		goto yy881;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy721:
	YYDEBUG(721, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych <= ',') goto yy188;
			goto yy880;
		} else {
			if (yych <= '/') goto yy188;
			if (yych <= '0') goto yy881;
			goto yy882;
		}
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy722:
	YYDEBUG(722, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy880;
		if (yych <= '/') goto yy188;
		goto yy882;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy723:
	YYDEBUG(723, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy883;
	goto yy16;
yy724:
	YYDEBUG(724, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy884;
	goto yy55;
yy725:
	YYDEBUG(725, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy726;
	if (yych <= '9') goto yy884;
yy726:
	YYDEBUG(726, *YYCURSOR);
#line 1577 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->y = timelib_get_nr_ex(&ptr, 2, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 16851 "<stdout>"
yy727:
	YYDEBUG(727, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy556;
		if (yych <= '9') goto yy884;
		if (yych <= 'm') goto yy556;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy556;
		} else {
			if (yych <= 's') goto yy729;
			if (yych <= 't') goto yy730;
			goto yy556;
		}
	}
yy728:
	YYDEBUG(728, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy885;
	goto yy55;
yy729:
	YYDEBUG(729, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy885;
	goto yy55;
yy730:
	YYDEBUG(730, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy885;
	goto yy55;
yy731:
	YYDEBUG(731, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy886;
	goto yy55;
yy732:
	YYDEBUG(732, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy731;
	if (yych <= '/') goto yy169;
	if (yych <= '9') goto yy884;
	goto yy169;
yy733:
	YYDEBUG(733, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy216;
	if (yych <= '9') goto yy887;
	goto yy216;
yy734:
	YYDEBUG(734, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy888;
	goto yy55;
yy735:
	YYDEBUG(735, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy889;
	if (yych <= '3') goto yy890;
	if (yych <= '9') goto yy558;
	goto yy55;
yy736:
	YYDEBUG(736, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy737:
	YYDEBUG(737, *YYCURSOR);
	switch (yych) {
		case '\t':
		case ' ':
		case '-':
		case '.': goto yy736;
		case 'A':
		case 'a': goto yy585;
		case 'D':
		case 'd': goto yy756;
		case 'F':
		case 'f': goto yy757;
		case 'I': goto yy588;
		case 'J':
		case 'j': goto yy590;
		case 'M':
		case 'm': goto yy758;
		case 'N':
		case 'n': goto yy592;
		case 'O':
		case 'o': goto yy593;
		case 'S':
		case 's': goto yy759;
		case 'V': goto yy595;
		case 'X': goto yy597;
		default: goto yy55;
	}
yy738:
	YYDEBUG(738, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy891;
	} else {
		if (yych <= '0') goto yy892;
		if (yych <= '9') goto yy893;
	}
yy739:
	YYDEBUG(739, *YYCURSOR);
#line 1522 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 16976 "<stdout>"
yy740:
	YYDEBUG(740, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy891;
		goto yy739;
	} else {
		if (yych <= '2') goto yy893;
		if (yych <= '9') goto yy894;
		goto yy739;
	}
yy741:
	YYDEBUG(741, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy891;
	if (yych <= '/') goto yy739;
	if (yych <= '9') goto yy894;
	goto yy739;
yy742:
	YYDEBUG(742, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy891;
		goto yy739;
	} else {
		if (yych <= '5') goto yy894;
		if (yych <= '6') goto yy895;
		goto yy739;
	}
yy743:
	YYDEBUG(743, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy891;
	goto yy739;
yy744:
	YYDEBUG(744, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy896;
		if (yych <= 'T') goto yy55;
		goto yy897;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy55;
			goto yy896;
		} else {
			if (yych == 'u') goto yy897;
			goto yy55;
		}
	}
yy745:
	YYDEBUG(745, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy898;
	if (yych == 'e') goto yy898;
	goto yy55;
yy746:
	YYDEBUG(746, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy899;
	if (yych == 'e') goto yy899;
	goto yy55;
yy747:
	YYDEBUG(747, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy900;
		if (yych <= 'T') goto yy55;
		goto yy901;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy900;
		} else {
			if (yych == 'u') goto yy901;
			goto yy55;
		}
	}
yy748:
	YYDEBUG(748, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy902;
	if (yych == 'a') goto yy902;
	goto yy55;
yy749:
	YYDEBUG(749, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy903;
	if (yych == 'o') goto yy903;
	goto yy55;
yy750:
	YYDEBUG(750, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy904;
	if (yych == 'c') goto yy904;
	goto yy55;
yy751:
	YYDEBUG(751, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy905;
	if (yych == 'e') goto yy905;
	goto yy55;
yy752:
	YYDEBUG(752, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy784;
	if (yych <= '4') goto yy785;
	if (yych <= '5') goto yy786;
	goto yy55;
yy753:
	YYDEBUG(753, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy906;
	if (yych <= '9') goto yy894;
	goto yy55;
yy754:
	YYDEBUG(754, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy894;
	goto yy55;
yy755:
	YYDEBUG(755, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy894;
	if (yych <= '6') goto yy895;
	goto yy55;
yy756:
	YYDEBUG(756, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy774;
	if (yych == 'e') goto yy774;
	goto yy55;
yy757:
	YYDEBUG(757, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy775;
	if (yych == 'e') goto yy775;
	goto yy55;
yy758:
	YYDEBUG(758, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy780;
	if (yych == 'a') goto yy780;
	goto yy55;
yy759:
	YYDEBUG(759, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy907;
	if (yych == 'e') goto yy907;
	goto yy55;
yy760:
	YYDEBUG(760, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy55;
	if (yych <= '/') goto yy908;
	if (yych <= '9') goto yy909;
	goto yy55;
yy761:
	YYDEBUG(761, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy55;
	if (yych <= '/') goto yy908;
	if (yych <= '2') goto yy909;
	goto yy55;
yy762:
	YYDEBUG(762, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy908;
	goto yy55;
yy763:
	YYDEBUG(763, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych >= '\t') goto yy188;
				} else {
					if (yych == ' ') goto yy188;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy910;
					goto yy911;
				} else {
					if (yych <= '3') goto yy913;
					if (yych <= '9') goto yy914;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy188;
				} else {
					if (yych != 'G') goto yy188;
				}
			} else {
				if (yych <= 'R') {
					if (yych == 'M') goto yy188;
				} else {
					if (yych != 'V') goto yy188;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') {
					if (yych >= 'Y') goto yy188;
				} else {
					if (yych == 'd') goto yy188;
				}
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy188;
				} else {
					if (yych <= 'h') goto yy188;
					if (yych >= 'm') goto yy188;
				}
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'u') {
					if (yych >= 's') goto yy188;
				} else {
					if (yych == 'w') goto yy188;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 'y') goto yy188;
					if (yych >= 0xC2) goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
				}
			}
		}
	}
yy764:
	YYDEBUG(764, *YYCURSOR);
#line 1448 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		s->time->s = timelib_get_nr(&ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 17244 "<stdout>"
yy765:
	YYDEBUG(765, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy764;
					goto yy188;
				} else {
					if (yych == ' ') goto yy188;
					goto yy764;
				}
			} else {
				if (yych <= '3') {
					if (yych <= '2') goto yy911;
					goto yy913;
				} else {
					if (yych <= '9') goto yy914;
					if (yych <= 'C') goto yy764;
					goto yy188;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy764;
					goto yy188;
				} else {
					if (yych == 'H') goto yy188;
					goto yy764;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy188;
					goto yy764;
				} else {
					if (yych == 'V') goto yy764;
					goto yy188;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') {
					if (yych <= 'X') goto yy764;
					goto yy188;
				} else {
					if (yych == 'd') goto yy188;
					goto yy764;
				}
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy188;
					goto yy764;
				} else {
					if (yych <= 'h') goto yy188;
					if (yych <= 'l') goto yy764;
					goto yy188;
				}
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'u') {
					if (yych <= 'r') goto yy764;
					goto yy188;
				} else {
					if (yych == 'w') goto yy188;
					goto yy764;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 'y') goto yy188;
					if (yych <= 0xC1) goto yy764;
					goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
					goto yy764;
				}
			}
		}
	}
yy766:
	YYDEBUG(766, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy188;
				if (yych <= 0x1F) goto yy764;
				goto yy188;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy764;
					goto yy914;
				} else {
					if (yych == 'D') goto yy188;
					goto yy764;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy188;
					goto yy764;
				} else {
					if (yych <= 'H') goto yy188;
					if (yych <= 'L') goto yy764;
					goto yy188;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy764;
					goto yy188;
				} else {
					if (yych == 'W') goto yy188;
					goto yy764;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy188;
					goto yy764;
				} else {
					if (yych == 'e') goto yy764;
					goto yy188;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy764;
					goto yy188;
				} else {
					if (yych == 'm') goto yy188;
					goto yy764;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy188;
					goto yy764;
				} else {
					if (yych == 'x') goto yy764;
					goto yy188;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy764;
					goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
					goto yy764;
				}
			}
		}
	}
yy767:
	YYDEBUG(767, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy764;
					goto yy188;
				} else {
					if (yych == ' ') goto yy188;
					goto yy764;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '6') goto yy914;
					goto yy915;
				} else {
					if (yych == 'D') goto yy188;
					goto yy764;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy188;
					goto yy764;
				} else {
					if (yych <= 'H') goto yy188;
					if (yych <= 'L') goto yy764;
					goto yy188;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy764;
					goto yy188;
				} else {
					if (yych == 'W') goto yy188;
					goto yy764;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy188;
					goto yy764;
				} else {
					if (yych == 'e') goto yy764;
					goto yy188;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy764;
					goto yy188;
				} else {
					if (yych == 'm') goto yy188;
					goto yy764;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy188;
					goto yy764;
				} else {
					if (yych == 'x') goto yy764;
					goto yy188;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy764;
					goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
					goto yy764;
				}
			}
		}
	}
yy768:
	YYDEBUG(768, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy188;
				if (yych <= 0x1F) goto yy764;
				goto yy188;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy764;
					goto yy915;
				} else {
					if (yych == 'D') goto yy188;
					goto yy764;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy188;
					goto yy764;
				} else {
					if (yych <= 'H') goto yy188;
					if (yych <= 'L') goto yy764;
					goto yy188;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy764;
					goto yy188;
				} else {
					if (yych == 'W') goto yy188;
					goto yy764;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy188;
					goto yy764;
				} else {
					if (yych == 'e') goto yy764;
					goto yy188;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy764;
					goto yy188;
				} else {
					if (yych == 'm') goto yy188;
					goto yy764;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy188;
					goto yy764;
				} else {
					if (yych == 'x') goto yy764;
					goto yy188;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy764;
					goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
					goto yy764;
				}
			}
		}
	}
yy769:
	YYDEBUG(769, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '9') goto yy915;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy770:
	YYDEBUG(770, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy916;
	goto yy55;
yy771:
	YYDEBUG(771, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy916;
	goto yy55;
yy772:
	YYDEBUG(772, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy917;
	if (yych == 'r') goto yy917;
	goto yy55;
yy773:
	YYDEBUG(773, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy918;
	if (yych == 'g') goto yy918;
	goto yy55;
yy774:
	YYDEBUG(774, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy919;
	if (yych == 'c') goto yy919;
	goto yy55;
yy775:
	YYDEBUG(775, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy920;
	if (yych == 'b') goto yy920;
	goto yy55;
yy776:
	YYDEBUG(776, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy589;
yy777:
	YYDEBUG(777, *YYCURSOR);
	++YYCURSOR;
	goto yy589;
yy778:
	YYDEBUG(778, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy921;
	if (yych == 'n') goto yy921;
	goto yy55;
yy779:
	YYDEBUG(779, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy922;
		if (yych <= 'M') goto yy55;
		goto yy923;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy55;
			goto yy922;
		} else {
			if (yych == 'n') goto yy923;
			goto yy55;
		}
	}
yy780:
	YYDEBUG(780, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy924;
		if (yych <= 'X') goto yy55;
		goto yy777;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy55;
			goto yy924;
		} else {
			if (yych == 'y') goto yy777;
			goto yy55;
		}
	}
yy781:
	YYDEBUG(781, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy919;
	if (yych == 'v') goto yy919;
	goto yy55;
yy782:
	YYDEBUG(782, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy925;
	if (yych == 't') goto yy925;
	goto yy55;
yy783:
	YYDEBUG(783, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy434;
		if (yych <= 'O') goto yy55;
		goto yy926;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy55;
			goto yy434;
		} else {
			if (yych == 'p') goto yy926;
			goto yy55;
		}
	}
yy784:
	YYDEBUG(784, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy55;
	if (yych <= '9') goto yy927;
	goto yy55;
yy785:
	YYDEBUG(785, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy927;
	goto yy55;
yy786:
	YYDEBUG(786, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '3') goto yy927;
	goto yy55;
yy787:
	YYDEBUG(787, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '0') {
			if (yych <= '/') goto yy188;
			goto yy910;
		} else {
			if (yych <= '2') goto yy911;
			if (yych <= '3') goto yy913;
			goto yy914;
		}
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy788:
	YYDEBUG(788, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '/') goto yy188;
		if (yych <= '2') goto yy911;
		if (yych <= '3') goto yy913;
		goto yy914;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy789:
	YYDEBUG(789, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '9') goto yy914;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy790:
	YYDEBUG(790, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '6') goto yy914;
		if (yych <= '9') goto yy915;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy791:
	YYDEBUG(791, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy244;
	if (yych == 't') goto yy244;
	goto yy55;
yy792:
	YYDEBUG(792, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy793;
	if (yych != 'n') goto yy55;
yy793:
	YYDEBUG(793, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy929;
	if (yych == 'i') goto yy929;
	goto yy55;
yy794:
	YYDEBUG(794, *YYCURSOR);
	++YYCURSOR;
	goto yy242;
yy795:
	YYDEBUG(795, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy930;
	if (yych == 'r') goto yy930;
	goto yy55;
yy796:
	YYDEBUG(796, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy931;
	if (yych == 's') goto yy931;
	goto yy55;
yy797:
	YYDEBUG(797, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy416;
	if (yych == 'e') goto yy416;
	goto yy55;
yy798:
	YYDEBUG(798, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy932;
	if (yych == 'e') goto yy932;
	goto yy55;
yy799:
	YYDEBUG(799, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy416;
	if (yych == 'd') goto yy416;
	goto yy55;
yy800:
	YYDEBUG(800, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy169;
				goto yy627;
			} else {
				if (yych == ' ') goto yy627;
				goto yy169;
			}
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy731;
				goto yy169;
			} else {
				if (yych <= '9') goto yy884;
				if (yych <= '@') goto yy169;
				goto yy100;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'P') {
				if (yych <= 'O') goto yy169;
				goto yy100;
			} else {
				if (yych == 'a') goto yy100;
				goto yy169;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'p') goto yy100;
				if (yych <= 0xC1) goto yy169;
				goto yy628;
			} else {
				if (yych == 0xE2) goto yy629;
				goto yy169;
			}
		}
	}
yy801:
	YYDEBUG(801, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'A') {
			if (yych <= '@') goto yy55;
			goto yy100;
		} else {
			if (yych == 'P') goto yy100;
			goto yy55;
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'a') goto yy100;
			if (yych <= 'o') goto yy55;
			goto yy100;
		} else {
			if (yych == 0xC2) goto yy628;
			goto yy55;
		}
	}
yy802:
	YYDEBUG(802, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy933;
	goto yy55;
yy803:
	YYDEBUG(803, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy627;
			if (yych <= 0x1F) goto yy169;
			goto yy627;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy169;
				goto yy731;
			} else {
				if (yych == 'A') goto yy100;
				goto yy169;
			}
		}
	} else {
		if (yych <= 'p') {
			if (yych <= '`') {
				if (yych <= 'P') goto yy100;
				goto yy169;
			} else {
				if (yych <= 'a') goto yy100;
				if (yych <= 'o') goto yy169;
				goto yy100;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy169;
				goto yy628;
			} else {
				if (yych == 0xE2) goto yy629;
				goto yy169;
			}
		}
	}
yy804:
	YYDEBUG(804, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy731;
	if (yych <= '/') goto yy169;
	if (yych <= '9') goto yy934;
	goto yy169;
yy805:
	YYDEBUG(805, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy731;
	if (yych == '0') goto yy934;
	goto yy169;
yy806:
	YYDEBUG(806, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy556;
		if (yych <= '9') goto yy808;
		if (yych <= 'm') goto yy556;
		goto yy728;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy556;
			goto yy728;
		} else {
			if (yych <= 's') goto yy729;
			if (yych <= 't') goto yy730;
			goto yy556;
		}
	}
yy807:
	YYDEBUG(807, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy556;
		if (yych <= '1') goto yy808;
		if (yych <= 'm') goto yy556;
		goto yy728;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy556;
			goto yy728;
		} else {
			if (yych <= 's') goto yy729;
			if (yych <= 't') goto yy730;
			goto yy556;
		}
	}
yy808:
	YYDEBUG(808, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy728;
		goto yy556;
	} else {
		if (yych <= 'r') goto yy728;
		if (yych <= 's') goto yy729;
		if (yych <= 't') goto yy730;
		goto yy556;
	}
yy809:
	YYDEBUG(809, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy935;
	if (yych <= '3') goto yy936;
	if (yych <= '9') goto yy808;
	goto yy55;
yy810:
	YYDEBUG(810, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy937;
	goto yy55;
yy811:
	YYDEBUG(811, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy937;
		goto yy55;
	} else {
		if (yych <= 'T') goto yy810;
		if (yych == 't') goto yy810;
		goto yy55;
	}
yy812:
	YYDEBUG(812, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy281;
	if (yych <= '9') goto yy938;
	goto yy281;
yy813:
	YYDEBUG(813, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy107;
	goto yy16;
yy814:
	YYDEBUG(814, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy315;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy317;
				if (yych <= 0x1F) goto yy55;
				goto yy317;
			}
		} else {
			if (yych <= '-') {
				if (yych <= '+') goto yy55;
				if (yych <= ',') goto yy317;
				goto yy939;
			} else {
				if (yych <= '.') goto yy317;
				if (yych <= '/') goto yy55;
				goto yy501;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy55;
				goto yy317;
			} else {
				if (yych == 'h') goto yy317;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy320;
				if (yych <= 'q') goto yy55;
				goto yy320;
			} else {
				if (yych <= 's') goto yy321;
				if (yych <= 't') goto yy322;
				goto yy55;
			}
		}
	}
yy815:
	YYDEBUG(815, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy286;
			goto yy134;
		} else {
			if (yych == ' ') goto yy134;
			goto yy286;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy107;
			if (yych <= ',') goto yy286;
			goto yy134;
		} else {
			if (yych <= '/') goto yy286;
			if (yych <= '9') goto yy134;
			goto yy286;
		}
	}
yy816:
	YYDEBUG(816, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy940;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy107;
		if (yych <= ',') goto yy16;
		goto yy288;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy16;
			goto yy288;
		} else {
			if (yych == '_') goto yy288;
			goto yy16;
		}
	}
yy817:
	YYDEBUG(817, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy940;
	}
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy134;
			goto yy286;
		} else {
			if (yych <= ' ') goto yy134;
			if (yych == ')') goto yy107;
			goto yy286;
		}
	} else {
		if (yych <= '/') {
			if (yych <= '-') goto yy687;
			if (yych <= '.') goto yy134;
			goto yy288;
		} else {
			if (yych <= '9') goto yy134;
			if (yych == '_') goto yy288;
			goto yy286;
		}
	}
yy818:
	YYDEBUG(818, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy942;
	if (yych == 'f') goto yy942;
	goto yy55;
yy819:
	YYDEBUG(819, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'E') goto yy943;
		if (yych == 'e') goto yy943;
		goto yy16;
	}
yy820:
	YYDEBUG(820, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy943;
			if (yych == '_') goto yy288;
			goto yy16;
		} else {
			if (yych == 'e') goto yy944;
			if (yych <= 'z') goto yy940;
			goto yy16;
		}
	}
yy821:
	YYDEBUG(821, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy822:
	YYDEBUG(822, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy821;
				if (yych <= 0x1F) goto yy55;
				goto yy821;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy55;
					goto yy843;
				} else {
					if (yych == 'F') goto yy844;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy845;
					goto yy55;
				} else {
					if (yych <= 'M') goto yy846;
					if (yych <= 'R') goto yy55;
					goto yy847;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy848;
					goto yy849;
				} else {
					if (yych == 'W') goto yy945;
					goto yy55;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy851;
					goto yy55;
				} else {
					if (yych <= 'd') goto yy843;
					if (yych <= 'e') goto yy55;
					goto yy844;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy55;
					goto yy845;
				} else {
					if (yych == 'm') goto yy846;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy847;
					goto yy848;
				} else {
					if (yych <= 'u') goto yy849;
					if (yych <= 'v') goto yy55;
					goto yy945;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy55;
					goto yy851;
				} else {
					if (yych == 0xC2) goto yy852;
					goto yy55;
				}
			}
		}
	}
yy823:
	YYDEBUG(823, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy16;
			goto yy821;
		} else {
			if (yych == ' ') goto yy821;
			goto yy16;
		}
	} else {
		if (yych <= 0xC2) {
			if (yych <= ')') goto yy107;
			if (yych <= 0xC1) goto yy16;
		} else {
			if (yych == 0xE2) goto yy825;
			goto yy16;
		}
	}
yy824:
	YYDEBUG(824, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xA0) goto yy946;
	goto yy55;
yy825:
	YYDEBUG(825, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy947;
	goto yy55;
yy826:
	YYDEBUG(826, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'T') goto yy948;
		if (yych == 't') goto yy948;
		goto yy16;
	}
yy827:
	YYDEBUG(827, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy940;
	}
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy821;
			if (yych <= 0x1F) goto yy16;
			goto yy821;
		} else {
			if (yych == ')') goto yy107;
			if (yych <= ',') goto yy16;
			goto yy288;
		}
	} else {
		if (yych <= '_') {
			if (yych == '/') goto yy288;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy16;
				goto yy824;
			} else {
				if (yych == 0xE2) goto yy825;
				goto yy16;
			}
		}
	}
yy828:
	YYDEBUG(828, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'T') goto yy948;
			if (yych == '_') goto yy288;
			goto yy16;
		} else {
			if (yych == 't') goto yy949;
			if (yych <= 'z') goto yy940;
			goto yy16;
		}
	}
yy829:
	YYDEBUG(829, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'R') goto yy950;
		if (yych == 'r') goto yy950;
		goto yy16;
	}
yy830:
	YYDEBUG(830, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy853;
	if (yych == 'd') goto yy853;
	goto yy822;
yy831:
	YYDEBUG(831, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == ')') goto yy107;
		goto yy306;
	} else {
		if (yych <= 'S') goto yy951;
		if (yych == 's') goto yy951;
		goto yy306;
	}
yy832:
	YYDEBUG(832, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy950;
			if (yych == '_') goto yy288;
			goto yy16;
		} else {
			if (yych == 'r') goto yy952;
			if (yych <= 'z') goto yy940;
			goto yy16;
		}
	}
yy833:
	YYDEBUG(833, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy306;
		} else {
			if (yych == '.') goto yy306;
			if (yych <= '/') goto yy288;
			goto yy306;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'S') goto yy951;
			if (yych == '_') goto yy288;
			goto yy306;
		} else {
			if (yych == 's') goto yy953;
			if (yych <= 'z') goto yy940;
			goto yy306;
		}
	}
yy834:
	YYDEBUG(834, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy16;
	if (yych <= '5') goto yy954;
	if (yych <= '9') goto yy107;
	if (yych <= ':') goto yy384;
	goto yy16;
yy835:
	YYDEBUG(835, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy955;
	} else {
		if (yych <= '9') goto yy837;
		if (yych <= ':') goto yy955;
	}
yy836:
	YYDEBUG(836, *YYCURSOR);
#line 1925 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr(&ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr(&ptr);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 18501 "<stdout>"
yy837:
	YYDEBUG(837, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy955;
	if (yych == ':') goto yy955;
	goto yy836;
yy838:
	YYDEBUG(838, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy956;
		goto yy836;
	} else {
		if (yych <= '9') goto yy957;
		if (yych <= ':') goto yy956;
		goto yy836;
	}
yy839:
	YYDEBUG(839, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy956;
	if (yych == ':') goto yy956;
	goto yy836;
yy840:
	YYDEBUG(840, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy316;
	if (yych <= '9') goto yy958;
	goto yy316;
yy841:
	YYDEBUG(841, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'Y') goto yy959;
		if (yych == 'y') goto yy959;
		goto yy16;
	}
yy842:
	YYDEBUG(842, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy959;
			if (yych == '_') goto yy288;
			goto yy16;
		} else {
			if (yych == 'y') goto yy960;
			if (yych <= 'z') goto yy940;
			goto yy16;
		}
	}
yy843:
	YYDEBUG(843, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy961;
	if (yych == 'a') goto yy961;
	goto yy55;
yy844:
	YYDEBUG(844, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy962;
		if (yych <= 'Q') goto yy55;
		goto yy963;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy55;
			goto yy962;
		} else {
			if (yych == 'r') goto yy963;
			goto yy55;
		}
	}
yy845:
	YYDEBUG(845, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy964;
	if (yych == 'o') goto yy964;
	goto yy55;
yy846:
	YYDEBUG(846, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy965;
			goto yy55;
		} else {
			if (yych <= 'O') goto yy966;
			if (yych <= 'R') goto yy55;
			goto yy967;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy965;
			goto yy55;
		} else {
			if (yych <= 'o') goto yy966;
			if (yych == 's') goto yy967;
			goto yy55;
		}
	}
yy847:
	YYDEBUG(847, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy969;
			goto yy55;
		} else {
			if (yych <= 'E') goto yy970;
			if (yych <= 'T') goto yy55;
			goto yy971;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy969;
			goto yy55;
		} else {
			if (yych <= 'e') goto yy970;
			if (yych == 'u') goto yy971;
			goto yy55;
		}
	}
yy848:
	YYDEBUG(848, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy972;
		if (yych <= 'T') goto yy55;
		goto yy973;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy55;
			goto yy972;
		} else {
			if (yych == 'u') goto yy973;
			goto yy55;
		}
	}
yy849:
	YYDEBUG(849, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy974;
	if (yych == 's') goto yy974;
	goto yy55;
yy850:
	YYDEBUG(850, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy975;
	if (yych == 'e') goto yy975;
	goto yy55;
yy851:
	YYDEBUG(851, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy976;
	if (yych == 'e') goto yy976;
	goto yy55;
yy852:
	YYDEBUG(852, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy977;
	goto yy55;
yy853:
	YYDEBUG(853, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy978;
	if (yych == 'a') goto yy978;
	goto yy55;
yy854:
	YYDEBUG(854, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= 'c') {
		if (yych <= 'M') {
			if (yych <= 'F') {
				if (yych == 'D') goto yy843;
				if (yych <= 'E') goto yy55;
				goto yy844;
			} else {
				if (yych == 'H') goto yy845;
				if (yych <= 'L') goto yy55;
				goto yy846;
			}
		} else {
			if (yych <= 'U') {
				if (yych <= 'R') goto yy55;
				if (yych <= 'S') goto yy847;
				if (yych <= 'T') goto yy848;
				goto yy849;
			} else {
				if (yych <= 'W') {
					if (yych <= 'V') goto yy55;
					goto yy850;
				} else {
					if (yych == 'Y') goto yy851;
					goto yy55;
				}
			}
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'g') {
				if (yych <= 'd') goto yy843;
				if (yych == 'f') goto yy844;
				goto yy55;
			} else {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy845;
					goto yy55;
				} else {
					if (yych <= 'm') goto yy846;
					if (yych <= 'r') goto yy55;
					goto yy847;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') goto yy848;
				if (yych <= 'u') goto yy849;
				if (yych <= 'v') goto yy55;
				goto yy850;
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy55;
					goto yy851;
				} else {
					if (yych == 0xC2) goto yy979;
					goto yy55;
				}
			}
		}
	}
yy855:
	YYDEBUG(855, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy980;
	goto yy55;
yy856:
	YYDEBUG(856, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'H') goto yy981;
		if (yych == 'h') goto yy981;
		goto yy16;
	}
yy857:
	YYDEBUG(857, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy981;
			if (yych == '_') goto yy288;
			goto yy16;
		} else {
			if (yych == 'h') goto yy982;
			if (yych <= 'z') goto yy940;
			goto yy16;
		}
	}
yy858:
	YYDEBUG(858, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Q') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'R') goto yy959;
		if (yych == 'r') goto yy959;
		goto yy16;
	}
yy859:
	YYDEBUG(859, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy959;
			if (yych == '_') goto yy288;
			goto yy16;
		} else {
			if (yych == 'r') goto yy960;
			if (yych <= 'z') goto yy940;
			goto yy16;
		}
	}
yy860:
	YYDEBUG(860, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'U') goto yy983;
		if (yych == 'u') goto yy983;
		goto yy16;
	}
yy861:
	YYDEBUG(861, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'U') goto yy983;
			if (yych == '_') goto yy288;
			goto yy16;
		} else {
			if (yych == 'u') goto yy984;
			if (yych <= 'z') goto yy940;
			goto yy16;
		}
	}
yy862:
	YYDEBUG(862, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'A') goto yy985;
		if (yych == 'a') goto yy985;
		goto yy16;
	}
yy863:
	YYDEBUG(863, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'B') goto yy986;
		if (yych == 'b') goto yy986;
		goto yy16;
	}
yy864:
	YYDEBUG(864, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'H') goto yy987;
		if (yych == 'h') goto yy987;
		goto yy16;
	}
yy865:
	YYDEBUG(865, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy985;
			if (yych <= '^') goto yy16;
			goto yy288;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy988;
			if (yych <= 'z') goto yy940;
			goto yy16;
		}
	}
yy866:
	YYDEBUG(866, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'B') goto yy986;
			if (yych == '_') goto yy288;
			goto yy16;
		} else {
			if (yych == 'b') goto yy989;
			if (yych <= 'z') goto yy940;
			goto yy16;
		}
	}
yy867:
	YYDEBUG(867, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy987;
			if (yych == '_') goto yy288;
			goto yy16;
		} else {
			if (yych == 'h') goto yy990;
			if (yych <= 'z') goto yy940;
			goto yy16;
		}
	}
yy868:
	YYDEBUG(868, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy991;
	goto yy55;
yy869:
	YYDEBUG(869, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy991;
	goto yy55;
yy870:
	YYDEBUG(870, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'O') goto yy992;
		if (yych == 'o') goto yy992;
		goto yy16;
	}
yy871:
	YYDEBUG(871, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'Y') goto yy993;
		if (yych == 'y') goto yy993;
		goto yy16;
	}
yy872:
	YYDEBUG(872, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'O') goto yy992;
			if (yych == '_') goto yy288;
			goto yy16;
		} else {
			if (yych == 'o') goto yy994;
			if (yych <= 'z') goto yy940;
			goto yy16;
		}
	}
yy873:
	YYDEBUG(873, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy993;
			if (yych == '_') goto yy288;
			goto yy16;
		} else {
			if (yych == 'y') goto yy995;
			if (yych <= 'z') goto yy940;
			goto yy16;
		}
	}
yy874:
	YYDEBUG(874, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'D') goto yy996;
		if (yych == 'd') goto yy996;
		goto yy16;
	}
yy875:
	YYDEBUG(875, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy996;
			if (yych == '_') goto yy288;
			goto yy16;
		} else {
			if (yych == 'd') goto yy997;
			if (yych <= 'z') goto yy940;
			goto yy16;
		}
	}
yy876:
	YYDEBUG(876, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy107;
		goto yy16;
	} else {
		if (yych <= 'D') goto yy998;
		if (yych == 'd') goto yy998;
		goto yy16;
	}
yy877:
	YYDEBUG(877, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy107;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy288;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy998;
			if (yych == '_') goto yy288;
			goto yy16;
		} else {
			if (yych == 'd') goto yy999;
			if (yych <= 'z') goto yy940;
			goto yy16;
		}
	}
yy878:
	YYDEBUG(878, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1000;
	goto yy55;
yy879:
	YYDEBUG(879, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy1000;
	goto yy55;
yy880:
	YYDEBUG(880, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy1001;
	if (yych <= '1') goto yy1002;
	goto yy55;
yy881:
	YYDEBUG(881, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ',') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy16;
					goto yy188;
				} else {
					if (yych == ' ') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '-') goto yy880;
					goto yy16;
				} else {
					if (yych <= '9') goto yy1003;
					if (yych <= 'C') goto yy16;
					goto yy188;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy16;
					goto yy188;
				} else {
					if (yych == 'H') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy188;
					goto yy16;
				} else {
					if (yych == 'V') goto yy16;
					goto yy188;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') {
					if (yych <= 'X') goto yy16;
					goto yy188;
				} else {
					if (yych == 'd') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy188;
					goto yy16;
				} else {
					if (yych <= 'h') goto yy188;
					if (yych <= 'l') goto yy16;
					goto yy188;
				}
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'u') {
					if (yych <= 'r') goto yy16;
					goto yy188;
				} else {
					if (yych == 'w') goto yy188;
					goto yy16;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 'y') goto yy188;
					if (yych <= 0xC1) goto yy16;
					goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
					goto yy16;
				}
			}
		}
	}
yy882:
	YYDEBUG(882, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy880;
		if (yych <= '/') goto yy188;
		goto yy1003;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy883:
	YYDEBUG(883, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1004;
	if (yych <= '6') goto yy1005;
	goto yy55;
yy884:
	YYDEBUG(884, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1006;
	goto yy55;
yy885:
	YYDEBUG(885, *YYCURSOR);
	++YYCURSOR;
	goto yy556;
yy886:
	YYDEBUG(886, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') goto yy169;
	if (yych <= '9') goto yy886;
	goto yy169;
yy887:
	YYDEBUG(887, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy216;
	if (yych <= '9') goto yy1007;
	goto yy216;
yy888:
	YYDEBUG(888, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1008;
	goto yy55;
yy889:
	YYDEBUG(889, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy556;
		if (yych <= '9') goto yy1009;
		if (yych <= 'm') goto yy556;
		goto yy728;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy556;
			goto yy728;
		} else {
			if (yych <= 's') goto yy729;
			if (yych <= 't') goto yy730;
			goto yy556;
		}
	}
yy890:
	YYDEBUG(890, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy556;
			goto yy1009;
		} else {
			if (yych <= '9') goto yy724;
			if (yych <= 'm') goto yy556;
			goto yy728;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy556;
			goto yy728;
		} else {
			if (yych <= 's') goto yy729;
			if (yych <= 't') goto yy730;
			goto yy556;
		}
	}
yy891:
	YYDEBUG(891, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy1011;
	if (yych <= '3') goto yy1012;
	if (yych <= '9') goto yy1013;
	goto yy55;
yy892:
	YYDEBUG(892, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1014;
	if (yych <= '0') goto yy739;
	if (yych <= '9') goto yy1015;
	goto yy739;
yy893:
	YYDEBUG(893, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1014;
	if (yych <= '/') goto yy739;
	if (yych <= '9') goto yy1015;
	goto yy739;
yy894:
	YYDEBUG(894, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1015;
	goto yy55;
yy895:
	YYDEBUG(895, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '6') goto yy1015;
	goto yy55;
yy896:
	YYDEBUG(896, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1016;
	if (yych == 'r') goto yy1016;
	goto yy55;
yy897:
	YYDEBUG(897, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1017;
	if (yych == 'g') goto yy1017;
	goto yy55;
yy898:
	YYDEBUG(898, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1018;
	if (yych == 'c') goto yy1018;
	goto yy55;
yy899:
	YYDEBUG(899, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1019;
	if (yych == 'b') goto yy1019;
	goto yy55;
yy900:
	YYDEBUG(900, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1020;
	if (yych == 'n') goto yy1020;
	goto yy55;
yy901:
	YYDEBUG(901, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy1021;
		if (yych <= 'M') goto yy55;
		goto yy1022;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy55;
			goto yy1021;
		} else {
			if (yych == 'n') goto yy1022;
			goto yy55;
		}
	}
yy902:
	YYDEBUG(902, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy1023;
		if (yych <= 'X') goto yy55;
		goto yy1024;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy55;
			goto yy1023;
		} else {
			if (yych == 'y') goto yy1024;
			goto yy55;
		}
	}
yy903:
	YYDEBUG(903, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy1018;
	if (yych == 'v') goto yy1018;
	goto yy55;
yy904:
	YYDEBUG(904, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1025;
	if (yych == 't') goto yy1025;
	goto yy55;
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy1026;
	if (yych == 'p') goto yy1026;
	goto yy55;
yy906:
	YYDEBUG(906, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy55;
	if (yych <= '9') goto yy1015;
	goto yy55;
yy907:
	YYDEBUG(907, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy926;
	if (yych == 'p') goto yy926;
	goto yy55;
yy908:
	YYDEBUG(908, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy1027;
	if (yych <= '3') goto yy1029;
	if (yych <= '9') goto yy1030;
	goto yy55;
yy909:
	YYDEBUG(909, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy1031;
	goto yy55;
yy910:
	YYDEBUG(910, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '9') goto yy1032;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy911:
	YYDEBUG(911, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy188;
				if (yych >= ' ') goto yy188;
			} else {
				if (yych <= '9') {
					if (yych >= '0') goto yy1032;
				} else {
					if (yych == 'D') goto yy188;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy188;
				} else {
					if (yych <= 'H') goto yy188;
					if (yych >= 'M') goto yy188;
				}
			} else {
				if (yych <= 'U') {
					if (yych >= 'S') goto yy188;
				} else {
					if (yych == 'W') goto yy188;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy188;
				} else {
					if (yych != 'e') goto yy188;
				}
			} else {
				if (yych <= 'h') {
					if (yych >= 'h') goto yy188;
				} else {
					if (yych == 'm') goto yy188;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy188;
				} else {
					if (yych != 'x') goto yy188;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych >= 0xC2) goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
				}
			}
		}
	}
yy912:
	YYDEBUG(912, *YYCURSOR);
#line 1683 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->d = timelib_get_nr(&ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 19557 "<stdout>"
yy913:
	YYDEBUG(913, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy912;
					goto yy188;
				} else {
					if (yych == ' ') goto yy188;
					goto yy912;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '1') goto yy1032;
					goto yy1034;
				} else {
					if (yych == 'D') goto yy188;
					goto yy912;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy188;
					goto yy912;
				} else {
					if (yych <= 'H') goto yy188;
					if (yych <= 'L') goto yy912;
					goto yy188;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy912;
					goto yy188;
				} else {
					if (yych == 'W') goto yy188;
					goto yy912;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy188;
					goto yy912;
				} else {
					if (yych == 'e') goto yy912;
					goto yy188;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy912;
					goto yy188;
				} else {
					if (yych == 'm') goto yy188;
					goto yy912;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy188;
					goto yy912;
				} else {
					if (yych == 'x') goto yy912;
					goto yy188;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy912;
					goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
					goto yy912;
				}
			}
		}
	}
yy914:
	YYDEBUG(914, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy188;
				if (yych <= 0x1F) goto yy912;
				goto yy188;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy912;
					goto yy1034;
				} else {
					if (yych == 'D') goto yy188;
					goto yy912;
				}
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'G') {
					if (yych <= 'F') goto yy188;
					goto yy912;
				} else {
					if (yych <= 'H') goto yy188;
					if (yych <= 'L') goto yy912;
					goto yy188;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy912;
					goto yy188;
				} else {
					if (yych == 'W') goto yy188;
					goto yy912;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy188;
					goto yy912;
				} else {
					if (yych == 'e') goto yy912;
					goto yy188;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy912;
					goto yy188;
				} else {
					if (yych == 'm') goto yy188;
					goto yy912;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy188;
					goto yy912;
				} else {
					if (yych == 'x') goto yy912;
					goto yy188;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy912;
					goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
					goto yy912;
				}
			}
		}
	}
yy915:
	YYDEBUG(915, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '9') goto yy1034;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy916:
	YYDEBUG(916, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1035;
	goto yy55;
yy917:
	YYDEBUG(917, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy1036;
	if (yych == 'i') goto yy1036;
	goto yy589;
yy918:
	YYDEBUG(918, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy1037;
	if (yych == 'u') goto yy1037;
	goto yy589;
yy919:
	YYDEBUG(919, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1038;
	if (yych == 'e') goto yy1038;
	goto yy589;
yy920:
	YYDEBUG(920, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy1039;
	if (yych == 'r') goto yy1039;
	goto yy589;
yy921:
	YYDEBUG(921, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy1040;
	if (yych == 'u') goto yy1040;
	goto yy589;
yy922:
	YYDEBUG(922, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy777;
	if (yych == 'y') goto yy777;
	goto yy589;
yy923:
	YYDEBUG(923, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy777;
	if (yych == 'e') goto yy777;
	goto yy589;
yy924:
	YYDEBUG(924, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy1041;
	if (yych == 'c') goto yy1041;
	goto yy589;
yy925:
	YYDEBUG(925, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy1042;
	if (yych == 'o') goto yy1042;
	goto yy589;
yy926:
	YYDEBUG(926, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy919;
	if (yych == 't') goto yy919;
	goto yy589;
yy927:
	YYDEBUG(927, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1043;
	if (yych <= '/') goto yy928;
	if (yych <= '7') goto yy1044;
yy928:
	YYDEBUG(928, *YYCURSOR);
#line 1716 "parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr(&ptr, 4);
		w = timelib_get_nr(&ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 19829 "<stdout>"
yy929:
	YYDEBUG(929, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1045;
	if (yych == 'g') goto yy1045;
	goto yy55;
yy930:
	YYDEBUG(930, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy244;
	if (yych == 'y') goto yy244;
	goto yy55;
yy931:
	YYDEBUG(931, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1046;
	if (yych == 'e') goto yy1046;
	goto yy55;
yy932:
	YYDEBUG(932, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy244;
	if (yych == 'r') goto yy244;
	goto yy55;
yy933:
	YYDEBUG(933, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'A') {
			if (yych <= '@') goto yy55;
			goto yy100;
		} else {
			if (yych == 'P') goto yy100;
			goto yy55;
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'a') goto yy100;
			if (yych <= 'o') goto yy55;
			goto yy100;
		} else {
			if (yych == 0xE2) goto yy629;
			goto yy55;
		}
	}
yy934:
	YYDEBUG(934, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy169;
				goto yy627;
			} else {
				if (yych == ' ') goto yy627;
				goto yy169;
			}
		} else {
			if (yych <= '9') {
				if (yych <= '.') goto yy1047;
				goto yy169;
			} else {
				if (yych <= ':') goto yy1048;
				if (yych <= '@') goto yy169;
				goto yy100;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'P') {
				if (yych <= 'O') goto yy169;
				goto yy100;
			} else {
				if (yych == 'a') goto yy100;
				goto yy169;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'p') goto yy100;
				if (yych <= 0xC1) goto yy169;
				goto yy628;
			} else {
				if (yych == 0xE2) goto yy629;
				goto yy169;
			}
		}
	}
yy935:
	YYDEBUG(935, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy556;
		if (yych <= '9') goto yy1049;
		if (yych <= 'm') goto yy556;
		goto yy728;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy556;
			goto yy728;
		} else {
			if (yych <= 's') goto yy729;
			if (yych <= 't') goto yy730;
			goto yy556;
		}
	}
yy936:
	YYDEBUG(936, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy556;
		if (yych <= '1') goto yy1049;
		if (yych <= 'm') goto yy556;
		goto yy728;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy556;
			goto yy728;
		} else {
			if (yych <= 's') goto yy729;
			if (yych <= 't') goto yy730;
			goto yy556;
		}
	}
yy937:
	YYDEBUG(937, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy1050;
	if (yych <= '3') goto yy1051;
	goto yy55;
yy938:
	YYDEBUG(938, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy281;
	if (yych <= '9') goto yy1052;
	goto yy281;
yy939:
	YYDEBUG(939, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1053;
	goto yy55;
yy940:
	YYDEBUG(940, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy941:
	YYDEBUG(941, *YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy940;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy288;
		goto yy55;
	} else {
		if (yych <= '/') goto yy288;
		if (yych == '_') goto yy288;
		goto yy55;
	}
yy942:
	YYDEBUG(942, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ' ') goto yy1055;
	goto yy55;
yy943:
	YYDEBUG(943, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy959;
	if (yych == 'r') goto yy959;
	goto yy55;
yy944:
	YYDEBUG(944, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy959;
	if (yych == 'r') goto yy960;
	goto yy941;
yy945:
	YYDEBUG(945, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1056;
	if (yych == 'e') goto yy1056;
	goto yy55;
yy946:
	YYDEBUG(946, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= 'c') {
		if (yych <= 'M') {
			if (yych <= 'F') {
				if (yych == 'D') goto yy843;
				if (yych <= 'E') goto yy55;
				goto yy844;
			} else {
				if (yych == 'H') goto yy845;
				if (yych <= 'L') goto yy55;
				goto yy846;
			}
		} else {
			if (yych <= 'U') {
				if (yych <= 'R') goto yy55;
				if (yych <= 'S') goto yy847;
				if (yych <= 'T') goto yy848;
				goto yy849;
			} else {
				if (yych <= 'W') {
					if (yych <= 'V') goto yy55;
					goto yy945;
				} else {
					if (yych == 'Y') goto yy851;
					goto yy55;
				}
			}
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'g') {
				if (yych <= 'd') goto yy843;
				if (yych == 'f') goto yy844;
				goto yy55;
			} else {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy845;
					goto yy55;
				} else {
					if (yych <= 'm') goto yy846;
					if (yych <= 'r') goto yy55;
					goto yy847;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') goto yy848;
				if (yych <= 'u') goto yy849;
				if (yych <= 'v') goto yy55;
				goto yy945;
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy55;
					goto yy851;
				} else {
					if (yych == 0xC2) goto yy1057;
					goto yy55;
				}
			}
		}
	}
yy947:
	YYDEBUG(947, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy1058;
	goto yy55;
yy948:
	YYDEBUG(948, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy987;
	if (yych == 'h') goto yy987;
	goto yy55;
yy949:
	YYDEBUG(949, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy987;
	if (yych == 'h') goto yy990;
	goto yy941;
yy950:
	YYDEBUG(950, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy959;
	if (yych == 'y') goto yy959;
	goto yy55;
yy951:
	YYDEBUG(951, *YYCURSOR);
	++YYCURSOR;
	goto yy306;
yy952:
	YYDEBUG(952, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy959;
	if (yych == 'y') goto yy960;
	goto yy941;
yy953:
	YYDEBUG(953, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy940;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy288;
		goto yy306;
	} else {
		if (yych <= '/') goto yy288;
		if (yych == '_') goto yy288;
		goto yy306;
	}
yy954:
	YYDEBUG(954, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy16;
	if (yych <= '9') goto yy1059;
	goto yy16;
yy955:
	YYDEBUG(955, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1060;
	if (yych <= '6') goto yy1061;
	if (yych <= '9') goto yy1062;
	goto yy55;
yy956:
	YYDEBUG(956, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1063;
	if (yych <= '6') goto yy1064;
	if (yych <= '9') goto yy1062;
	goto yy55;
yy957:
	YYDEBUG(957, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy836;
				goto yy1065;
			} else {
				if (yych == ' ') goto yy1065;
				goto yy836;
			}
		} else {
			if (yych <= '9') {
				if (yych <= '.') goto yy956;
				goto yy836;
			} else {
				if (yych <= ':') goto yy956;
				if (yych <= '@') goto yy836;
				goto yy1066;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'P') {
				if (yych <= 'O') goto yy836;
				goto yy1066;
			} else {
				if (yych == 'a') goto yy1066;
				goto yy836;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 'p') goto yy1066;
				if (yych <= 0xC1) goto yy836;
				goto yy1067;
			} else {
				if (yych == 0xE2) goto yy1068;
				goto yy836;
			}
		}
	}
yy958:
	YYDEBUG(958, *YYCURSOR);
	++YYCURSOR;
	goto yy316;
yy959:
	YYDEBUG(959, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy134;
		if (yych <= 0x1F) goto yy286;
		goto yy134;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy286;
			goto yy134;
		} else {
			if (yych <= '/') goto yy286;
			if (yych <= '9') goto yy134;
			goto yy286;
		}
	}
yy960:
	YYDEBUG(960, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy940;
	}
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy134;
			goto yy286;
		} else {
			if (yych <= ' ') goto yy134;
			if (yych <= ',') goto yy286;
			goto yy687;
		}
	} else {
		if (yych <= '9') {
			if (yych == '/') goto yy288;
			goto yy134;
		} else {
			if (yych == '_') goto yy288;
			goto yy286;
		}
	}
yy961:
	YYDEBUG(961, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1069;
	if (yych == 'y') goto yy1069;
	goto yy55;
yy962:
	YYDEBUG(962, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1070;
	if (yych == 'r') goto yy1070;
	goto yy55;
yy963:
	YYDEBUG(963, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1071;
	if (yych == 'i') goto yy1071;
	goto yy55;
yy964:
	YYDEBUG(964, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1072;
	if (yych == 'u') goto yy1072;
	goto yy55;
yy965:
	YYDEBUG(965, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy1073;
			goto yy55;
		} else {
			if (yych <= 'L') goto yy1074;
			if (yych <= 'M') goto yy55;
			goto yy1075;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy1073;
			goto yy55;
		} else {
			if (yych <= 'l') goto yy1074;
			if (yych == 'n') goto yy1075;
			goto yy55;
		}
	}
yy966:
	YYDEBUG(966, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1076;
	if (yych == 'n') goto yy1076;
	goto yy55;
yy967:
	YYDEBUG(967, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1077;
	if (yych == 'e') goto yy1077;
yy968:
	YYDEBUG(968, *YYCURSOR);
#line 1859 "parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text(&ptr, &behavior);
			timelib_eat_spaces(&ptr);
			timelib_set_relative(&ptr, i, behavior, s, TIMELIB_TIME_PART_DONT_KEEP);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 20321 "<stdout>"
yy969:
	YYDEBUG(969, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1078;
	if (yych == 't') goto yy1078;
	goto yy55;
yy970:
	YYDEBUG(970, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1079;
	if (yych == 'c') goto yy1079;
	goto yy55;
yy971:
	YYDEBUG(971, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1071;
	if (yych == 'n') goto yy1071;
	goto yy55;
yy972:
	YYDEBUG(972, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1080;
	if (yych == 'u') goto yy1080;
	goto yy55;
yy973:
	YYDEBUG(973, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1081;
	if (yych == 'e') goto yy1081;
	goto yy55;
yy974:
	YYDEBUG(974, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1077;
	if (yych == 'e') goto yy1077;
	goto yy55;
yy975:
	YYDEBUG(975, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy55;
		if (yych <= 'D') goto yy1082;
		goto yy1083;
	} else {
		if (yych <= 'c') goto yy55;
		if (yych <= 'd') goto yy1082;
		if (yych <= 'e') goto yy1083;
		goto yy55;
	}
yy976:
	YYDEBUG(976, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1072;
	if (yych == 'a') goto yy1072;
	goto yy55;
yy977:
	YYDEBUG(977, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy967;
	if (yych == 's') goto yy967;
	goto yy55;
yy978:
	YYDEBUG(978, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1084;
	if (yych == 'y') goto yy1084;
	goto yy55;
yy979:
	YYDEBUG(979, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy854;
	if (yych == 0xB5) goto yy977;
	goto yy55;
yy980:
	YYDEBUG(980, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= 'd') {
		if (yych <= 'R') {
			if (yych <= 'F') {
				if (yych == 'D') goto yy843;
				if (yych <= 'E') goto yy55;
				goto yy844;
			} else {
				if (yych <= 'H') {
					if (yych <= 'G') goto yy55;
					goto yy845;
				} else {
					if (yych == 'M') goto yy846;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'V') {
				if (yych <= 'S') goto yy847;
				if (yych <= 'T') goto yy848;
				if (yych <= 'U') goto yy849;
				goto yy55;
			} else {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy850;
					goto yy55;
				} else {
					if (yych <= 'Y') goto yy851;
					if (yych <= 'c') goto yy55;
					goto yy843;
				}
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'h') {
				if (yych == 'f') goto yy844;
				if (yych <= 'g') goto yy55;
				goto yy845;
			} else {
				if (yych <= 'm') {
					if (yych <= 'l') goto yy55;
					goto yy846;
				} else {
					if (yych <= 'r') goto yy55;
					if (yych <= 's') goto yy847;
					goto yy848;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy849;
					goto yy55;
				} else {
					if (yych <= 'w') goto yy850;
					if (yych <= 'x') goto yy55;
					goto yy851;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy55;
					goto yy852;
				} else {
					if (yych == 0xE2) goto yy692;
					goto yy55;
				}
			}
		}
	}
yy981:
	YYDEBUG(981, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1085;
	if (yych == 't') goto yy1085;
	goto yy55;
yy982:
	YYDEBUG(982, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1085;
	if (yych == 't') goto yy1086;
	goto yy941;
yy983:
	YYDEBUG(983, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1087;
	if (yych == 's') goto yy1087;
	goto yy55;
yy984:
	YYDEBUG(984, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1087;
	if (yych == 's') goto yy1088;
	goto yy941;
yy985:
	YYDEBUG(985, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy993;
	if (yych == 'y') goto yy993;
	goto yy55;
yy986:
	YYDEBUG(986, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy943;
	if (yych == 'e') goto yy943;
	goto yy55;
yy987:
	YYDEBUG(987, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy821;
		if (yych <= 0x1F) goto yy55;
		goto yy821;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy55;
			goto yy824;
		} else {
			if (yych == 0xE2) goto yy825;
			goto yy55;
		}
	}
yy988:
	YYDEBUG(988, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy993;
	if (yych == 'y') goto yy995;
	goto yy941;
yy989:
	YYDEBUG(989, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy943;
	if (yych == 'e') goto yy944;
	goto yy941;
yy990:
	YYDEBUG(990, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy821;
		if (yych <= 0x1F) goto yy941;
		goto yy821;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy941;
			goto yy824;
		} else {
			if (yych == 0xE2) goto yy825;
			goto yy941;
		}
	}
yy991:
	YYDEBUG(991, *YYCURSOR);
	++YYCURSOR;
	goto yy764;
yy992:
	YYDEBUG(992, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1089;
	if (yych == 'w') goto yy1089;
	goto yy55;
yy993:
	YYDEBUG(993, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy951;
	if (yych == 's') goto yy951;
	goto yy306;
yy994:
	YYDEBUG(994, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1089;
	if (yych == 'w') goto yy1091;
	goto yy941;
yy995:
	YYDEBUG(995, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy288;
			goto yy306;
		} else {
			if (yych <= '/') goto yy288;
			if (yych <= 'R') goto yy306;
			goto yy951;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy288;
			goto yy306;
		} else {
			if (yych == 's') goto yy953;
			if (yych <= 'z') goto yy940;
			goto yy306;
		}
	}
yy996:
	YYDEBUG(996, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy985;
	if (yych == 'a') goto yy985;
	goto yy55;
yy997:
	YYDEBUG(997, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy985;
	if (yych == 'a') goto yy988;
	goto yy941;
yy998:
	YYDEBUG(998, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1092;
	if (yych == 'a') goto yy1092;
	goto yy55;
yy999:
	YYDEBUG(999, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1092;
	if (yych == 'a') goto yy1093;
	goto yy941;
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy1094;
	goto yy55;
yy1001:
	YYDEBUG(1001, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1095;
	goto yy55;
yy1002:
	YYDEBUG(1002, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy1095;
	goto yy55;
yy1003:
	YYDEBUG(1003, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy880;
		if (yych <= '/') goto yy188;
		goto yy1096;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy107;
	goto yy55;
yy1005:
	YYDEBUG(1005, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy107;
	goto yy55;
yy1006:
	YYDEBUG(1006, *YYCURSOR);
	++YYCURSOR;
#line 1565 "parse_date.re"
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->y = timelib_get_nr(&ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 20678 "<stdout>"
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	++YYCURSOR;
	goto yy216;
yy1008:
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1097;
	goto yy55;
yy1009:
	YYDEBUG(1009, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy1010;
		if (yych <= '9') goto yy884;
		if (yych >= 'n') goto yy728;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy728;
		} else {
			if (yych <= 's') goto yy729;
			if (yych <= 't') goto yy730;
		}
	}
yy1010:
	YYDEBUG(1010, *YYCURSOR);
#line 1496 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 20720 "<stdout>"
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy556;
			goto yy1013;
		} else {
			if (yych == 'T') goto yy1098;
			goto yy556;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1099;
			if (yych <= 'q') goto yy556;
			goto yy1099;
		} else {
			if (yych <= 's') goto yy1100;
			if (yych <= 't') goto yy1101;
			goto yy556;
		}
	}
yy1012:
	YYDEBUG(1012, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy556;
		} else {
			if (yych == 'T') goto yy1098;
			goto yy556;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1099;
			if (yych <= 'q') goto yy556;
			goto yy1099;
		} else {
			if (yych <= 's') goto yy1100;
			if (yych <= 't') goto yy1101;
			goto yy556;
		}
	}
yy1013:
	YYDEBUG(1013, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1098;
		if (yych <= 'm') goto yy556;
		goto yy1099;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy556;
			goto yy1099;
		} else {
			if (yych <= 's') goto yy1100;
			if (yych <= 't') goto yy1101;
			goto yy556;
		}
	}
yy1014:
	YYDEBUG(1014, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy1102;
	if (yych <= '3') goto yy1103;
	if (yych <= '9') goto yy1013;
	goto yy55;
yy1015:
	YYDEBUG(1015, *YYCURSOR);
	++YYCURSOR;
	goto yy912;
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy937;
		goto yy589;
	} else {
		if (yych <= 'I') goto yy1036;
		if (yych == 'i') goto yy1036;
		goto yy589;
	}
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy937;
		goto yy589;
	} else {
		if (yych <= 'U') goto yy1037;
		if (yych == 'u') goto yy1037;
		goto yy589;
	}
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy937;
		goto yy589;
	} else {
		if (yych <= 'E') goto yy1038;
		if (yych == 'e') goto yy1038;
		goto yy589;
	}
yy1019:
	YYDEBUG(1019, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy937;
		goto yy589;
	} else {
		if (yych <= 'R') goto yy1039;
		if (yych == 'r') goto yy1039;
		goto yy589;
	}
yy1020:
	YYDEBUG(1020, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy937;
		goto yy589;
	} else {
		if (yych <= 'U') goto yy1040;
		if (yych == 'u') goto yy1040;
		goto yy589;
	}
yy1021:
	YYDEBUG(1021, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy937;
		goto yy589;
	} else {
		if (yych <= 'Y') goto yy777;
		if (yych == 'y') goto yy777;
		goto yy589;
	}
yy1022:
	YYDEBUG(1022, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy937;
		goto yy589;
	} else {
		if (yych <= 'E') goto yy777;
		if (yych == 'e') goto yy777;
		goto yy589;
	}
yy1023:
	YYDEBUG(1023, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy937;
		goto yy589;
	} else {
		if (yych <= 'C') goto yy1041;
		if (yych == 'c') goto yy1041;
		goto yy589;
	}
yy1024:
	YYDEBUG(1024, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy937;
	goto yy589;
yy1025:
	YYDEBUG(1025, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy937;
		goto yy589;
	} else {
		if (yych <= 'O') goto yy1042;
		if (yych == 'o') goto yy1042;
		goto yy589;
	}
yy1026:
	YYDEBUG(1026, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy937;
		goto yy589;
	} else {
		if (yych <= 'T') goto yy1018;
		if (yych == 't') goto yy1018;
		goto yy589;
	}
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy1028;
		if (yych <= '9') goto yy1030;
		if (yych >= 'n') goto yy1104;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy1104;
		} else {
			if (yych <= 's') goto yy1105;
			if (yych <= 't') goto yy1106;
		}
	}
yy1028:
	YYDEBUG(1028, *YYCURSOR);
#line 1484 "parse_date.re"
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_signed_nr(s, &ptr, 4);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 20951 "<stdout>"
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy1028;
		if (yych <= '1') goto yy1030;
		if (yych <= 'm') goto yy1028;
		goto yy1104;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1028;
			goto yy1104;
		} else {
			if (yych <= 's') goto yy1105;
			if (yych <= 't') goto yy1106;
			goto yy1028;
		}
	}
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy1104;
		goto yy1028;
	} else {
		if (yych <= 'r') goto yy1104;
		if (yych <= 's') goto yy1105;
		if (yych <= 't') goto yy1106;
		goto yy1028;
	}
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy1107;
	if (yych <= '3') goto yy1108;
	if (yych <= '9') goto yy1030;
	goto yy55;
yy1032:
	YYDEBUG(1032, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'F') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych >= '\t') goto yy187;
				} else {
					if (yych == ' ') goto yy187;
				}
			} else {
				if (yych <= 'C') {
					if (yych <= '9') goto yy1109;
				} else {
					if (yych <= 'D') goto yy190;
					if (yych >= 'F') goto yy191;
				}
			}
		} else {
			if (yych <= 'R') {
				if (yych <= 'H') {
					if (yych >= 'H') goto yy73;
				} else {
					if (yych == 'M') goto yy192;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'S') goto yy193;
					if (yych <= 'T') goto yy1110;
					goto yy82;
				} else {
					if (yych == 'W') goto yy84;
				}
			}
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy86;
				} else {
					if (yych <= 'd') goto yy190;
					if (yych >= 'f') goto yy191;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'h') goto yy73;
				} else {
					if (yych <= 'm') goto yy192;
					if (yych >= 's') goto yy193;
				}
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'u') {
					if (yych <= 't') goto yy1111;
					goto yy82;
				} else {
					if (yych == 'w') goto yy84;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 'y') goto yy86;
					if (yych >= 0xC2) goto yy91;
				} else {
					if (yych == 0xE2) goto yy92;
				}
			}
		}
	}
yy1033:
	YYDEBUG(1033, *YYCURSOR);
#line 1645 "parse_date.re"
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr(&ptr, 4);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 21077 "<stdout>"
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '9') goto yy1109;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy1035:
	YYDEBUG(1035, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy1112;
	if (yych <= '3') goto yy1113;
	goto yy55;
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy777;
	if (yych == 'l') goto yy777;
	goto yy55;
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1114;
	if (yych == 's') goto yy1114;
	goto yy55;
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1042;
	if (yych == 'm') goto yy1042;
	goto yy55;
yy1039:
	YYDEBUG(1039, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1040;
	if (yych != 'u') goto yy55;
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1115;
	if (yych == 'a') goto yy1115;
	goto yy55;
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy777;
	if (yych == 'h') goto yy777;
	goto yy55;
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1116;
	if (yych == 'b') goto yy1116;
	goto yy55;
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '8') goto yy55;
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	++YYCURSOR;
#line 1697 "parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr(&ptr, 4);
		w = timelib_get_nr(&ptr, 2);
		d = timelib_get_nr(&ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 21164 "<stdout>"
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1117;
	if (yych == 'h') goto yy1117;
	goto yy55;
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1118;
	if (yych == 'c') goto yy1118;
	goto yy55;
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1119;
	goto yy55;
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1120;
	goto yy55;
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy728;
		goto yy1010;
	} else {
		if (yych <= 'r') goto yy728;
		if (yych <= 's') goto yy729;
		if (yych <= 't') goto yy730;
		goto yy1010;
	}
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1121;
	goto yy55;
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1121;
	goto yy55;
yy1052:
	YYDEBUG(1052, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy281;
	if (yych <= '9') goto yy1122;
	goto yy281;
yy1053:
	YYDEBUG(1053, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1054;
	if (yych <= '9') goto yy1123;
yy1054:
	YYDEBUG(1054, *YYCURSOR);
#line 1735 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 21240 "<stdout>"
yy1055:
	YYDEBUG(1055, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1124;
	if (yych <= '2') goto yy1126;
	if (yych <= '9') goto yy1127;
	goto yy55;
yy1056:
	YYDEBUG(1056, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy55;
		if (yych <= 'D') goto yy1082;
		goto yy1128;
	} else {
		if (yych <= 'c') goto yy55;
		if (yych <= 'd') goto yy1082;
		if (yych <= 'e') goto yy1128;
		goto yy55;
	}
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy946;
	if (yych == 0xB5) goto yy977;
	goto yy55;
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= 'd') {
		if (yych <= 'R') {
			if (yych <= 'F') {
				if (yych == 'D') goto yy843;
				if (yych <= 'E') goto yy55;
				goto yy844;
			} else {
				if (yych <= 'H') {
					if (yych <= 'G') goto yy55;
					goto yy845;
				} else {
					if (yych == 'M') goto yy846;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'V') {
				if (yych <= 'S') goto yy847;
				if (yych <= 'T') goto yy848;
				if (yych <= 'U') goto yy849;
				goto yy55;
			} else {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy945;
					goto yy55;
				} else {
					if (yych <= 'Y') goto yy851;
					if (yych <= 'c') goto yy55;
					goto yy843;
				}
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'h') {
				if (yych == 'f') goto yy844;
				if (yych <= 'g') goto yy55;
				goto yy845;
			} else {
				if (yych <= 'm') {
					if (yych <= 'l') goto yy55;
					goto yy846;
				} else {
					if (yych <= 'r') goto yy55;
					if (yych <= 's') goto yy847;
					goto yy848;
				}
			}
		} else {
			if (yych <= 'y') {
				if (yych <= 'v') {
					if (yych <= 'u') goto yy849;
					goto yy55;
				} else {
					if (yych <= 'w') goto yy945;
					if (yych <= 'x') goto yy55;
					goto yy851;
				}
			} else {
				if (yych <= 0xC2) {
					if (yych <= 0xC1) goto yy55;
					goto yy852;
				} else {
					if (yych == 0xE2) goto yy825;
					goto yy55;
				}
			}
		}
	}
yy1059:
	YYDEBUG(1059, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy16;
	if (yych <= '5') goto yy1004;
	if (yych <= '6') goto yy1005;
	goto yy16;
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy836;
	if (yych <= '9') goto yy1129;
	goto yy836;
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1129;
	goto yy836;
yy1062:
	YYDEBUG(1062, *YYCURSOR);
	++YYCURSOR;
	goto yy836;
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy836;
	if (yych <= '9') goto yy1130;
	goto yy836;
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1130;
	goto yy836;
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1065;
			goto yy55;
		} else {
			if (yych <= ' ') goto yy1065;
			if (yych <= '@') goto yy55;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy55;
		} else {
			if (yych <= 'a') goto yy1066;
			if (yych != 'p') goto yy55;
		}
	}
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy1131;
		goto yy55;
	} else {
		if (yych <= 'M') goto yy1132;
		if (yych == 'm') goto yy1132;
		goto yy55;
	}
yy1067:
	YYDEBUG(1067, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy1133;
	goto yy55;
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy1134;
	goto yy55;
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1135;
	if (yych == 's') goto yy1135;
	goto yy968;
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1136;
	if (yych == 't') goto yy1136;
	goto yy55;
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1137;
			goto yy968;
		} else {
			if (yych <= ' ') goto yy1137;
			if (yych <= 'C') goto yy968;
			goto yy1138;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych == 'd') goto yy1138;
			goto yy968;
		} else {
			if (yych <= 0xC2) goto yy1139;
			if (yych == 0xE2) goto yy1140;
			goto yy968;
		}
	}
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1069;
	if (yych == 'r') goto yy1069;
	goto yy55;
yy1073:
	YYDEBUG(1073, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1141;
	if (yych == 'r') goto yy1141;
	goto yy55;
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy1142;
	if (yych == 'l') goto yy1142;
	goto yy55;
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy1135;
		if (yych <= 'T') goto yy968;
		goto yy1143;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy968;
			goto yy1135;
		} else {
			if (yych == 'u') goto yy1143;
			goto yy968;
		}
	}
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1137;
			if (yych <= 0x1F) goto yy968;
			goto yy1137;
		} else {
			if (yych == 'D') goto yy1138;
			if (yych <= 'S') goto yy968;
			goto yy1144;
		}
	} else {
		if (yych <= 't') {
			if (yych == 'd') goto yy1138;
			if (yych <= 's') goto yy968;
			goto yy1144;
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy968;
				goto yy1139;
			} else {
				if (yych == 0xE2) goto yy1140;
				goto yy968;
			}
		}
	}
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1069;
	if (yych == 'c') goto yy1069;
	goto yy55;
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1137;
			goto yy968;
		} else {
			if (yych <= ' ') goto yy1137;
			if (yych <= 'T') goto yy968;
			goto yy1145;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych == 'u') goto yy1145;
			goto yy968;
		} else {
			if (yych <= 0xC2) goto yy1139;
			if (yych == 0xE2) goto yy1140;
			goto yy968;
		}
	}
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy1146;
		if (yych <= 'R') goto yy968;
		goto yy1135;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy968;
			goto yy1146;
		} else {
			if (yych == 's') goto yy1135;
			goto yy968;
		}
	}
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1137;
			goto yy968;
		} else {
			if (yych <= ' ') goto yy1137;
			if (yych <= 'Q') goto yy968;
			goto yy1147;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych == 'r') goto yy1147;
			goto yy968;
		} else {
			if (yych <= 0xC2) goto yy1139;
			if (yych == 0xE2) goto yy1140;
			goto yy968;
		}
	}
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1137;
			goto yy968;
		} else {
			if (yych <= ' ') goto yy1137;
			if (yych <= 'R') goto yy968;
			goto yy1148;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych == 's') goto yy1148;
			goto yy968;
		} else {
			if (yych <= 0xC2) goto yy1139;
			if (yych == 0xE2) goto yy1140;
			goto yy968;
		}
	}
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1137;
			goto yy968;
		} else {
			if (yych <= ' ') goto yy1137;
			if (yych <= 'M') goto yy968;
			goto yy1149;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych == 'n') goto yy1149;
			goto yy968;
		} else {
			if (yych <= 0xC2) goto yy1139;
			if (yych == 0xE2) goto yy1140;
			goto yy968;
		}
	}
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1150;
	if (yych == 'k') goto yy1150;
	goto yy55;
yy1084:
	YYDEBUG(1084, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych == ' ') goto yy1152;
		goto yy968;
	} else {
		if (yych <= 'S') goto yy1135;
		if (yych == 's') goto yy1135;
		goto yy968;
	}
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	++YYCURSOR;
	goto yy709;
yy1086:
	YYDEBUG(1086, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy940;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy288;
		goto yy709;
	} else {
		if (yych <= '/') goto yy288;
		if (yych == '_') goto yy288;
		goto yy709;
	}
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy688;
		if (yych <= 0x1F) goto yy55;
		goto yy688;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy55;
			goto yy691;
		} else {
			if (yych == 0xE2) goto yy692;
			goto yy55;
		}
	}
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy688;
		if (yych <= 0x1F) goto yy941;
		goto yy688;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy941;
			goto yy691;
		} else {
			if (yych == 0xE2) goto yy692;
			goto yy941;
		}
	}
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	++YYCURSOR;
yy1090:
	YYDEBUG(1090, *YYCURSOR);
#line 1195 "parse_date.re"
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 21723 "<stdout>"
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy940;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy288;
		goto yy1090;
	} else {
		if (yych <= '/') goto yy288;
		if (yych == '_') goto yy288;
		goto yy1090;
	}
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1153;
	if (yych == 'y') goto yy1153;
	goto yy55;
yy1093:
	YYDEBUG(1093, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1153;
	if (yych == 'y') goto yy1155;
	goto yy941;
yy1094:
	YYDEBUG(1094, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy1156;
	if (yych <= '3') goto yy1157;
	goto yy55;
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy1158;
	goto yy55;
yy1096:
	YYDEBUG(1096, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy880;
		if (yych <= '/') goto yy188;
		goto yy1159;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1160;
	goto yy55;
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1161;
	if (yych <= '2') goto yy1162;
	if (yych <= '9') goto yy1163;
	goto yy55;
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1164;
	goto yy55;
yy1100:
	YYDEBUG(1100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1164;
	goto yy55;
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1164;
	goto yy55;
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy556;
			goto yy1165;
		} else {
			if (yych == 'T') goto yy1098;
			goto yy556;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1099;
			if (yych <= 'q') goto yy556;
			goto yy1099;
		} else {
			if (yych <= 's') goto yy1100;
			if (yych <= 't') goto yy1101;
			goto yy556;
		}
	}
yy1103:
	YYDEBUG(1103, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy556;
			goto yy1165;
		} else {
			if (yych == 'T') goto yy1098;
			goto yy556;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1099;
			if (yych <= 'q') goto yy556;
			goto yy1099;
		} else {
			if (yych <= 's') goto yy1100;
			if (yych <= 't') goto yy1101;
			goto yy556;
		}
	}
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1166;
	goto yy55;
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1166;
	goto yy55;
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1166;
	goto yy55;
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy1028;
		if (yych <= '9') goto yy1167;
		if (yych <= 'm') goto yy1028;
		goto yy1104;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1028;
			goto yy1104;
		} else {
			if (yych <= 's') goto yy1105;
			if (yych <= 't') goto yy1106;
			goto yy1028;
		}
	}
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy1028;
		if (yych <= '1') goto yy1167;
		if (yych <= 'm') goto yy1028;
		goto yy1104;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1028;
			goto yy1104;
		} else {
			if (yych <= 's') goto yy1105;
			if (yych <= 't') goto yy1106;
			goto yy1028;
		}
	}
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '9') goto yy1168;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy55;
			if (yych <= '1') goto yy1169;
			goto yy1170;
		} else {
			if (yych <= '9') goto yy1171;
			if (yych <= 'G') goto yy55;
			goto yy257;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy258;
			goto yy55;
		} else {
			if (yych <= 'h') goto yy257;
			if (yych == 'u') goto yy258;
			goto yy55;
		}
	}
yy1111:
	YYDEBUG(1111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy55;
			if (yych <= '1') goto yy1172;
			goto yy1173;
		} else {
			if (yych <= '9') goto yy1174;
			if (yych <= 'G') goto yy55;
			goto yy257;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy258;
			goto yy55;
		} else {
			if (yych <= 'h') goto yy257;
			if (yych == 'u') goto yy258;
			goto yy55;
		}
	}
yy1112:
	YYDEBUG(1112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1175;
	goto yy55;
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1175;
	goto yy55;
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy777;
	if (yych == 't') goto yy777;
	goto yy55;
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1176;
	if (yych == 'r') goto yy1176;
	goto yy55;
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1177;
	if (yych == 'e') goto yy1177;
	goto yy55;
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy416;
	if (yych == 't') goto yy416;
	goto yy55;
yy1118:
	YYDEBUG(1118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy617;
	if (yych == 'o') goto yy617;
	goto yy55;
yy1119:
	YYDEBUG(1119, *YYCURSOR);
	yyaccept = 4;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy169;
			goto yy1119;
		} else {
			if (yych == 'A') goto yy1178;
			goto yy169;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy1178;
			if (yych <= '`') goto yy169;
			goto yy1178;
		} else {
			if (yych == 'p') goto yy1178;
			goto yy169;
		}
	}
yy1120:
	YYDEBUG(1120, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy55;
			goto yy1120;
		} else {
			if (yych == 'A') goto yy1178;
			goto yy55;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy1178;
			if (yych <= '`') goto yy55;
			goto yy1178;
		} else {
			if (yych == 'p') goto yy1178;
			goto yy55;
		}
	}
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	++YYCURSOR;
#line 1749 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 22070 "<stdout>"
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	++YYCURSOR;
	goto yy281;
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1054;
	if (yych <= '9') goto yy1179;
	goto yy1054;
yy1124:
	YYDEBUG(1124, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1180;
			if (yych >= ' ') goto yy1180;
		} else {
			if (yych <= '9') {
				if (yych >= '0') goto yy1127;
			} else {
				if (yych == 'A') goto yy1181;
			}
		}
	} else {
		if (yych <= 'p') {
			if (yych <= '`') {
				if (yych <= 'P') goto yy1181;
			} else {
				if (yych <= 'a') goto yy1181;
				if (yych >= 'p') goto yy1181;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych >= 0xC2) goto yy1182;
			} else {
				if (yych == 0xE2) goto yy1183;
			}
		}
	}
yy1125:
	YYDEBUG(1125, *YYCURSOR);
#line 1291 "parse_date.re"
	{
		DEBUG_OUTPUT("backof | frontof");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();

		if (*ptr == 'b') {
			s->time->h = timelib_get_nr(&ptr, 2);
			s->time->i = 15;
		} else {
			s->time->h = timelib_get_nr(&ptr, 2) - 1;
			s->time->i = 45;
		}
		if (*ptr != '\0' ) {
			timelib_eat_spaces(&ptr);
			s->time->h += timelib_meridian(&ptr, s->time->h);
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 22136 "<stdout>"
yy1126:
	YYDEBUG(1126, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1180;
			if (yych <= 0x1F) goto yy1125;
			goto yy1180;
		} else {
			if (yych <= '4') {
				if (yych <= '/') goto yy1125;
			} else {
				if (yych == 'A') goto yy1181;
				goto yy1125;
			}
		}
	} else {
		if (yych <= 'p') {
			if (yych <= '`') {
				if (yych <= 'P') goto yy1181;
				goto yy1125;
			} else {
				if (yych <= 'a') goto yy1181;
				if (yych <= 'o') goto yy1125;
				goto yy1181;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy1125;
				goto yy1182;
			} else {
				if (yych == 0xE2) goto yy1183;
				goto yy1125;
			}
		}
	}
yy1127:
	YYDEBUG(1127, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'P') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1180;
			if (yych <= 0x1F) goto yy1125;
			goto yy1180;
		} else {
			if (yych == 'A') goto yy1181;
			if (yych <= 'O') goto yy1125;
			goto yy1181;
		}
	} else {
		if (yych <= 'p') {
			if (yych == 'a') goto yy1181;
			if (yych <= 'o') goto yy1125;
			goto yy1181;
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy1125;
				goto yy1182;
			} else {
				if (yych == 0xE2) goto yy1183;
				goto yy1125;
			}
		}
	}
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1184;
	if (yych == 'k') goto yy1184;
	goto yy55;
yy1129:
	YYDEBUG(1129, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1186;
			if (yych <= 0x1F) goto yy836;
			goto yy1186;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy836;
				goto yy1186;
			} else {
				if (yych == '+') goto yy1186;
				goto yy836;
			}
		}
	} else {
		if (yych <= 'z') {
			if (yych <= '@') {
				if (yych <= '-') goto yy1186;
				goto yy836;
			} else {
				if (yych <= 'Z') goto yy1186;
				if (yych <= '`') goto yy836;
				goto yy1186;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy836;
				goto yy1192;
			} else {
				if (yych == 0xE2) goto yy1193;
				goto yy836;
			}
		}
	}
yy1130:
	YYDEBUG(1130, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1195;
			if (yych <= 0x1F) goto yy836;
			goto yy1195;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy836;
				goto yy1195;
			} else {
				if (yych == '+') goto yy1195;
				goto yy836;
			}
		}
	} else {
		if (yych <= 'z') {
			if (yych <= '@') {
				if (yych <= '-') goto yy1195;
				goto yy836;
			} else {
				if (yych <= 'Z') goto yy1195;
				if (yych <= '`') goto yy836;
				goto yy1195;
			}
		} else {
			if (yych <= 0xC2) {
				if (yych <= 0xC1) goto yy836;
				goto yy1198;
			} else {
				if (yych == 0xE2) goto yy1199;
				goto yy836;
			}
		}
	}
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1132;
	if (yych != 'm') goto yy55;
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1200;
		if (yych == '\t') goto yy1200;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy1200;
		if (yych == '.') goto yy1201;
		goto yy55;
	}
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'A') {
			if (yych <= '@') goto yy55;
			goto yy1066;
		} else {
			if (yych == 'P') goto yy1066;
			goto yy55;
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'a') goto yy1066;
			if (yych <= 'o') goto yy55;
			goto yy1066;
		} else {
			if (yych == 0xC2) goto yy1067;
			goto yy55;
		}
	}
yy1134:
	YYDEBUG(1134, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy1202;
	goto yy55;
yy1135:
	YYDEBUG(1135, *YYCURSOR);
	++YYCURSOR;
	goto yy968;
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1203;
		if (yych <= 'M') goto yy55;
		goto yy1204;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy55;
			goto yy1203;
		} else {
			if (yych == 'n') goto yy1204;
			goto yy55;
		}
	}
yy1137:
	YYDEBUG(1137, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy1137;
		if (yych <= 0x1F) goto yy55;
		goto yy1137;
	} else {
		if (yych <= 'O') {
			if (yych <= 'N') goto yy55;
			goto yy1205;
		} else {
			if (yych == 'o') goto yy1205;
			goto yy55;
		}
	}
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1206;
	if (yych == 'a') goto yy1206;
	goto yy55;
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy1207;
	goto yy55;
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy1208;
	goto yy55;
yy1141:
	YYDEBUG(1141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1209;
	if (yych == 'o') goto yy1209;
	goto yy55;
yy1142:
	YYDEBUG(1142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1209;
	if (yych == 'i') goto yy1209;
	goto yy55;
yy1143:
	YYDEBUG(1143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1210;
	if (yych == 't') goto yy1210;
	goto yy55;
yy1144:
	YYDEBUG(1144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1069;
	if (yych == 'h') goto yy1069;
	goto yy55;
yy1145:
	YYDEBUG(1145, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1148;
	if (yych == 'r') goto yy1148;
	goto yy55;
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1211;
	if (yych == 'n') goto yy1211;
	goto yy55;
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1148;
	if (yych != 's') goto yy55;
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1138;
	if (yych == 'd') goto yy1138;
	goto yy55;
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1147;
	if (yych == 'e') goto yy1147;
	goto yy55;
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy843;
		if (yych >= 'S') goto yy1135;
	} else {
		if (yych <= 'd') {
			if (yych >= 'd') goto yy843;
		} else {
			if (yych == 's') goto yy1135;
		}
	}
yy1151:
	YYDEBUG(1151, *YYCURSOR);
#line 1835 "parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetextweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text(&ptr, &behavior);
			timelib_eat_spaces(&ptr);
			timelib_set_relative(&ptr, i, behavior, s, TIMELIB_TIME_PART_DONT_KEEP);
			s->time->relative.weekday_behavior = 2;

			/* to handle the format weekday + last/this/next week */
			if (s->time->relative.have_weekday_relative == 0) {
				TIMELIB_HAVE_WEEKDAY_RELATIVE();
				s->time->relative.weekday = 1;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 22482 "<stdout>"
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1212;
	if (yych == 'o') goto yy1212;
	goto yy55;
yy1153:
	YYDEBUG(1153, *YYCURSOR);
	++YYCURSOR;
yy1154:
	YYDEBUG(1154, *YYCURSOR);
#line 1152 "parse_date.re"
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 22505 "<stdout>"
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy940;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy288;
		goto yy1154;
	} else {
		if (yych <= '/') goto yy288;
		if (yych == '_') goto yy288;
		goto yy1154;
	}
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1166;
	goto yy55;
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1166;
	goto yy55;
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy1213;
	if (yych <= '3') goto yy1214;
	goto yy55;
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy880;
		if (yych <= '/') goto yy188;
		goto yy1215;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy1160:
	YYDEBUG(1160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1216;
	goto yy55;
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1163;
	if (yych <= ':') goto yy1217;
	goto yy55;
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '4') goto yy1163;
	if (yych == ':') goto yy1217;
	goto yy55;
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1217;
	goto yy55;
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy1098;
	goto yy556;
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1218;
		if (yych <= 'm') goto yy1028;
		goto yy1099;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1028;
			goto yy1099;
		} else {
			if (yych <= 's') goto yy1100;
			if (yych <= 't') goto yy1101;
			goto yy1028;
		}
	}
yy1166:
	YYDEBUG(1166, *YYCURSOR);
	++YYCURSOR;
	goto yy1028;
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy1166;
		if (yych <= 'm') goto yy1028;
		goto yy1104;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1028;
			goto yy1104;
		} else {
			if (yych <= 's') goto yy1105;
			if (yych <= 't') goto yy1106;
			goto yy1028;
		}
	}
yy1168:
	YYDEBUG(1168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '9') goto yy1219;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy1169:
	YYDEBUG(1169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1220;
	if (yych <= '9') goto yy1171;
	if (yych <= ':') goto yy1221;
	goto yy55;
yy1170:
	YYDEBUG(1170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy55;
		if (yych <= '4') goto yy1220;
		goto yy1222;
	} else {
		if (yych == ':') goto yy1221;
		goto yy55;
	}
yy1171:
	YYDEBUG(1171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1222;
	if (yych == ':') goto yy1221;
	goto yy55;
yy1172:
	YYDEBUG(1172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1223;
	if (yych <= '9') goto yy1174;
	goto yy55;
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '4') goto yy1223;
	if (yych <= '5') goto yy1222;
	goto yy55;
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1222;
	goto yy55;
yy1175:
	YYDEBUG(1175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ' ') goto yy1224;
	goto yy55;
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy777;
	if (yych == 'y') goto yy777;
	goto yy55;
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy777;
	if (yych == 'r') goto yy777;
	goto yy55;
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy1225;
		goto yy55;
	} else {
		if (yych <= 'M') goto yy1226;
		if (yych == 'm') goto yy1226;
		goto yy55;
	}
yy1179:
	YYDEBUG(1179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1054;
	if (yych <= '9') goto yy1227;
	goto yy1054;
yy1180:
	YYDEBUG(1180, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1180;
			goto yy55;
		} else {
			if (yych <= ' ') goto yy1180;
			if (yych <= '@') goto yy55;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy55;
		} else {
			if (yych <= 'a') goto yy1181;
			if (yych != 'p') goto yy55;
		}
	}
yy1181:
	YYDEBUG(1181, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy1228;
		goto yy55;
	} else {
		if (yych <= 'M') goto yy1229;
		if (yych == 'm') goto yy1229;
		goto yy55;
	}
yy1182:
	YYDEBUG(1182, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy1230;
	goto yy55;
yy1183:
	YYDEBUG(1183, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy1231;
	goto yy55;
yy1184:
	YYDEBUG(1184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == 'D') goto yy843;
		if (yych <= 'R') goto yy55;
		goto yy1135;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy55;
			goto yy843;
		} else {
			if (yych == 's') goto yy1135;
			goto yy55;
		}
	}
yy1185:
	YYDEBUG(1185, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy1186:
	YYDEBUG(1186, *YYCURSOR);
	if (yych <= '+') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1185;
			if (yych <= 0x1F) goto yy55;
			goto yy1185;
		} else {
			if (yych == '(') goto yy1187;
			if (yych <= '*') goto yy55;
			goto yy1188;
		}
	} else {
		if (yych <= 'F') {
			if (yych == '-') goto yy1188;
			if (yych <= '@') goto yy55;
			goto yy1189;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'G') goto yy1190;
				goto yy1189;
			} else {
				if (yych <= '`') goto yy55;
				if (yych <= 'z') goto yy1191;
				goto yy55;
			}
		}
	}
yy1187:
	YYDEBUG(1187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy55;
	if (yych <= 'Z') goto yy1191;
	if (yych <= '`') goto yy55;
	if (yych <= 'z') goto yy1191;
	goto yy55;
yy1188:
	YYDEBUG(1188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1232;
	if (yych <= '2') goto yy1233;
	if (yych <= '9') goto yy1234;
	goto yy55;
yy1189:
	YYDEBUG(1189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1062;
		goto yy836;
	} else {
		if (yych <= 'Z') goto yy1235;
		if (yych <= '`') goto yy836;
		if (yych <= 'z') goto yy1236;
		goto yy836;
	}
yy1190:
	YYDEBUG(1190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy1062;
		if (yych <= '@') goto yy836;
		goto yy1235;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy1237;
			goto yy1235;
		} else {
			if (yych <= '`') goto yy836;
			if (yych <= 'z') goto yy1236;
			goto yy836;
		}
	}
yy1191:
	YYDEBUG(1191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1062;
		goto yy836;
	} else {
		if (yych <= 'Z') goto yy1235;
		if (yych <= '`') goto yy836;
		if (yych <= 'z') goto yy1235;
		goto yy836;
	}
yy1192:
	YYDEBUG(1192, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy1238;
	goto yy55;
yy1193:
	YYDEBUG(1193, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy1239;
	goto yy55;
yy1194:
	YYDEBUG(1194, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy1195:
	YYDEBUG(1195, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy55;
				goto yy1194;
			} else {
				if (yych == ' ') goto yy1194;
				goto yy55;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy1187;
				if (yych <= '*') goto yy55;
				goto yy1188;
			} else {
				if (yych == '-') goto yy1188;
				goto yy55;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy1196;
				if (yych <= 'F') goto yy1189;
				goto yy1190;
			} else {
				if (yych != 'P') goto yy1189;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy55;
				if (yych <= 'a') goto yy1197;
				goto yy1191;
			} else {
				if (yych <= 'p') goto yy1197;
				if (yych <= 'z') goto yy1191;
				goto yy55;
			}
		}
	}
yy1196:
	YYDEBUG(1196, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy1062;
			goto yy836;
		} else {
			if (yych <= '.') goto yy1131;
			if (yych <= '@') goto yy836;
			goto yy1235;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy1240;
			if (yych <= 'Z') goto yy1235;
			goto yy836;
		} else {
			if (yych == 'm') goto yy1241;
			if (yych <= 'z') goto yy1236;
			goto yy836;
		}
	}
yy1197:
	YYDEBUG(1197, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy1062;
			goto yy836;
		} else {
			if (yych <= '.') goto yy1131;
			if (yych <= '@') goto yy836;
			goto yy1235;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy1240;
			if (yych <= 'Z') goto yy1235;
			goto yy836;
		} else {
			if (yych == 'm') goto yy1240;
			if (yych <= 'z') goto yy1235;
			goto yy836;
		}
	}
yy1198:
	YYDEBUG(1198, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy1242;
	goto yy55;
yy1199:
	YYDEBUG(1199, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy1243;
	goto yy55;
yy1200:
	YYDEBUG(1200, *YYCURSOR);
	++YYCURSOR;
#line 1901 "parse_date.re"
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr(&ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr(&ptr);
			}
		}

		s->time->h += timelib_meridian(&ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 23019 "<stdout>"
yy1201:
	YYDEBUG(1201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1200;
		if (yych <= 0x08) goto yy55;
		goto yy1200;
	} else {
		if (yych == ' ') goto yy1200;
		goto yy55;
	}
yy1202:
	YYDEBUG(1202, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'A') {
			if (yych <= '@') goto yy55;
			goto yy1066;
		} else {
			if (yych == 'P') goto yy1066;
			goto yy55;
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'a') goto yy1066;
			if (yych <= 'o') goto yy55;
			goto yy1066;
		} else {
			if (yych == 0xE2) goto yy1068;
			goto yy55;
		}
	}
yy1203:
	YYDEBUG(1203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1204;
	if (yych != 'n') goto yy55;
yy1204:
	YYDEBUG(1204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1244;
	if (yych == 'i') goto yy1244;
	goto yy55;
yy1205:
	YYDEBUG(1205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1245;
	if (yych == 'f') goto yy1245;
	goto yy55;
yy1206:
	YYDEBUG(1206, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1246;
	if (yych == 'y') goto yy1246;
	goto yy55;
yy1207:
	YYDEBUG(1207, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= 'n') {
		if (yych == 'O') goto yy1205;
		goto yy55;
	} else {
		if (yych <= 'o') goto yy1205;
		if (yych == 0xC2) goto yy1139;
		goto yy55;
	}
yy1208:
	YYDEBUG(1208, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy1247;
	goto yy55;
yy1209:
	YYDEBUG(1209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1248;
	if (yych == 's') goto yy1248;
	goto yy55;
yy1210:
	YYDEBUG(1210, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1069;
	if (yych == 'e') goto yy1069;
	goto yy55;
yy1211:
	YYDEBUG(1211, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1069;
	if (yych == 'd') goto yy1069;
	goto yy55;
yy1212:
	YYDEBUG(1212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1249;
	if (yych == 'f') goto yy1249;
	goto yy55;
yy1213:
	YYDEBUG(1213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1250;
	goto yy55;
yy1214:
	YYDEBUG(1214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1250;
	goto yy55;
yy1215:
	YYDEBUG(1215, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy880;
		if (yych <= '/') goto yy188;
		goto yy1251;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy1216:
	YYDEBUG(1216, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1252;
	if (yych <= '2') goto yy1253;
	goto yy55;
yy1217:
	YYDEBUG(1217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1254;
	if (yych <= '9') goto yy1255;
	goto yy55;
yy1218:
	YYDEBUG(1218, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1256;
	if (yych <= '2') goto yy1257;
	if (yych <= '9') goto yy1163;
	goto yy55;
yy1219:
	YYDEBUG(1219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '9') goto yy1258;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy1220:
	YYDEBUG(1220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1259;
	if (yych <= '9') goto yy1260;
	if (yych >= ';') goto yy55;
yy1221:
	YYDEBUG(1221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1261;
	goto yy55;
yy1222:
	YYDEBUG(1222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1260;
	goto yy55;
yy1223:
	YYDEBUG(1223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1259;
	if (yych <= '9') goto yy1260;
	goto yy55;
yy1224:
	YYDEBUG(1224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1262;
	if (yych <= '2') goto yy1263;
	goto yy55;
yy1225:
	YYDEBUG(1225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1226;
	if (yych != 'm') goto yy55;
yy1226:
	YYDEBUG(1226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1264;
		if (yych == '\t') goto yy1264;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy1264;
		if (yych == '.') goto yy1265;
		goto yy55;
	}
yy1227:
	YYDEBUG(1227, *YYCURSOR);
	++YYCURSOR;
	goto yy1054;
yy1228:
	YYDEBUG(1228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1229;
	if (yych != 'm') goto yy55;
yy1229:
	YYDEBUG(1229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1266;
		if (yych == '\t') goto yy1266;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy1266;
		if (yych == '.') goto yy1267;
		goto yy55;
	}
yy1230:
	YYDEBUG(1230, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'A') {
			if (yych <= '@') goto yy55;
			goto yy1181;
		} else {
			if (yych == 'P') goto yy1181;
			goto yy55;
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'a') goto yy1181;
			if (yych <= 'o') goto yy55;
			goto yy1181;
		} else {
			if (yych == 0xC2) goto yy1182;
			goto yy55;
		}
	}
yy1231:
	YYDEBUG(1231, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy1268;
	goto yy55;
yy1232:
	YYDEBUG(1232, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy836;
	if (yych <= '9') goto yy1269;
	if (yych <= ':') goto yy1270;
	goto yy836;
yy1233:
	YYDEBUG(1233, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '5') {
		if (yych <= '/') goto yy836;
		if (yych <= '4') goto yy1269;
		goto yy1271;
	} else {
		if (yych <= '9') goto yy1062;
		if (yych <= ':') goto yy1270;
		goto yy836;
	}
yy1234:
	YYDEBUG(1234, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy836;
	if (yych <= '5') goto yy1271;
	if (yych <= '9') goto yy1062;
	if (yych <= ':') goto yy1270;
	goto yy836;
yy1235:
	YYDEBUG(1235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1062;
		goto yy836;
	} else {
		if (yych <= 'Z') goto yy1272;
		if (yych <= '`') goto yy836;
		if (yych <= 'z') goto yy1272;
		goto yy836;
	}
yy1236:
	YYDEBUG(1236, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1062;
			goto yy836;
		} else {
			if (yych == '.') goto yy836;
			goto yy1273;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy836;
			if (yych <= 'Z') goto yy1272;
			goto yy836;
		} else {
			if (yych <= '_') goto yy1273;
			if (yych <= '`') goto yy836;
			if (yych <= 'z') goto yy1274;
			goto yy836;
		}
	}
yy1237:
	YYDEBUG(1237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy1062;
		if (yych <= '@') goto yy836;
		goto yy1272;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'T') goto yy1275;
			goto yy1272;
		} else {
			if (yych <= '`') goto yy836;
			if (yych <= 'z') goto yy1272;
			goto yy836;
		}
	}
yy1238:
	YYDEBUG(1238, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '*') {
			if (yych == '(') goto yy1187;
			goto yy55;
		} else {
			if (yych == ',') goto yy55;
			if (yych <= '-') goto yy1188;
			goto yy55;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'G') goto yy1190;
			if (yych <= 'Z') goto yy1189;
			goto yy55;
		} else {
			if (yych <= 'z') goto yy1191;
			if (yych == 0xC2) goto yy1192;
			goto yy55;
		}
	}
yy1239:
	YYDEBUG(1239, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy1276;
	goto yy55;
yy1240:
	YYDEBUG(1240, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy1200;
			if (yych <= 0x08) goto yy836;
			goto yy1200;
		} else {
			if (yych == ' ') goto yy1200;
			if (yych <= '(') goto yy836;
			goto yy1062;
		}
	} else {
		if (yych <= '@') {
			if (yych == '.') goto yy1201;
			goto yy836;
		} else {
			if (yych <= 'Z') goto yy1272;
			if (yych <= '`') goto yy836;
			if (yych <= 'z') goto yy1272;
			goto yy836;
		}
	}
yy1241:
	YYDEBUG(1241, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy1200;
			if (yych == '\t') goto yy1200;
			goto yy836;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy1200;
				goto yy836;
			} else {
				if (yych <= ')') goto yy1062;
				if (yych <= ',') goto yy836;
				goto yy1273;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy1201;
			if (yych <= '/') goto yy1273;
			if (yych <= '@') goto yy836;
			goto yy1272;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy836;
				goto yy1273;
			} else {
				if (yych <= '`') goto yy836;
				if (yych <= 'z') goto yy1274;
				goto yy836;
			}
		}
	}
yy1242:
	YYDEBUG(1242, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych <= '(') {
				if (yych <= '\'') goto yy55;
				goto yy1187;
			} else {
				if (yych == '+') goto yy1188;
				goto yy55;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '-') goto yy1188;
				goto yy55;
			} else {
				if (yych <= 'A') goto yy1196;
				if (yych <= 'F') goto yy1189;
				goto yy1190;
			}
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') {
				if (yych <= 'O') goto yy1189;
				goto yy1196;
			} else {
				if (yych <= 'Z') goto yy1189;
				if (yych <= '`') goto yy55;
				goto yy1197;
			}
		} else {
			if (yych <= 'z') {
				if (yych == 'p') goto yy1197;
				goto yy1191;
			} else {
				if (yych == 0xC2) goto yy1198;
				goto yy55;
			}
		}
	}
yy1243:
	YYDEBUG(1243, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy1277;
	goto yy55;
yy1244:
	YYDEBUG(1244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1278;
	if (yych == 'g') goto yy1278;
	goto yy55;
yy1245:
	YYDEBUG(1245, *YYCURSOR);
	++YYCURSOR;
#line 1314 "parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("weekdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_SPECIAL_RELATIVE();

		i = timelib_get_relative_text(&ptr, &behavior);
		timelib_eat_spaces(&ptr);
		if (i > 0) { /* first, second... etc */
			s->time->relative.special.type = TIMELIB_SPECIAL_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative(&ptr, i, 1, s, TIMELIB_TIME_PART_DONT_KEEP);
		} else { /* last */
			s->time->relative.special.type = TIMELIB_SPECIAL_LAST_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative(&ptr, i, behavior, s, TIMELIB_TIME_PART_DONT_KEEP);
		}
		TIMELIB_DEINIT;
		return TIMELIB_WEEK_DAY_OF_MONTH;
	}
#line 23541 "<stdout>"
yy1246:
	YYDEBUG(1246, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1137;
			goto yy968;
		} else {
			if (yych <= ' ') goto yy1137;
			if (yych <= 'R') goto yy968;
			goto yy1279;
		}
	} else {
		if (yych <= 0xC1) {
			if (yych == 's') goto yy1279;
			goto yy968;
		} else {
			if (yych <= 0xC2) goto yy1139;
			if (yych == 0xE2) goto yy1140;
			goto yy968;
		}
	}
yy1247:
	YYDEBUG(1247, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= 'n') {
		if (yych == 'O') goto yy1205;
		goto yy55;
	} else {
		if (yych <= 'o') goto yy1205;
		if (yych == 0xE2) goto yy1140;
		goto yy55;
	}
yy1248:
	YYDEBUG(1248, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1280;
	if (yych == 'e') goto yy1280;
	goto yy55;
yy1249:
	YYDEBUG(1249, *YYCURSOR);
	++YYCURSOR;
#line 1273 "parse_date.re"
	{
		DEBUG_OUTPUT("firstdayof | lastdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME(); // Don't merge into PHP

		/* skip "last day of" or "first day of" */
		if (*ptr == 'l' || *ptr == 'L') {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_LAST_DAY_OF_MONTH;
		} else {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_FIRST_DAY_OF_MONTH;
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 23604 "<stdout>"
yy1250:
	YYDEBUG(1250, *YYCURSOR);
	++YYCURSOR;
#line 1510 "parse_date.re"
	{
		DEBUG_OUTPUT("iso8601datex");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_signed_nr(s, &ptr, 19);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 23619 "<stdout>"
yy1251:
	YYDEBUG(1251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy880;
		if (yych <= '/') goto yy188;
		goto yy1281;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy1252:
	YYDEBUG(1252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1282;
	goto yy55;
yy1253:
	YYDEBUG(1253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '4') goto yy1282;
	goto yy55;
yy1254:
	YYDEBUG(1254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1255;
	if (yych <= ':') goto yy1283;
	goto yy55;
yy1255:
	YYDEBUG(1255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1283;
	goto yy55;
yy1256:
	YYDEBUG(1256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1284;
	if (yych <= ':') goto yy1217;
	goto yy55;
yy1257:
	YYDEBUG(1257, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '4') goto yy1284;
	if (yych == ':') goto yy1217;
	goto yy55;
yy1258:
	YYDEBUG(1258, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0xC1) {
		if (yych <= '/') goto yy188;
		if (yych <= '9') goto yy1285;
		goto yy188;
	} else {
		if (yych <= 0xC2) goto yy91;
		if (yych == 0xE2) goto yy92;
		goto yy188;
	}
yy1259:
	YYDEBUG(1259, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1283;
	if (yych <= '6') goto yy1286;
	if (yych >= ':') goto yy55;
yy1260:
	YYDEBUG(1260, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1287;
	if (yych <= '6') goto yy1288;
	goto yy55;
yy1261:
	YYDEBUG(1261, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1289;
	goto yy55;
yy1262:
	YYDEBUG(1262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1290;
	goto yy55;
yy1263:
	YYDEBUG(1263, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '4') goto yy1290;
	goto yy55;
yy1264:
	YYDEBUG(1264, *YYCURSOR);
	++YYCURSOR;
#line 1354 "parse_date.re"
	{
		DEBUG_OUTPUT("mssqltime");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr(&ptr, 2);

			if (*ptr == ':' || *ptr == '.') {
				s->time->us = timelib_get_frac_nr(&ptr);
			}
		}
		timelib_eat_spaces(&ptr);
		s->time->h += timelib_meridian(&ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 23740 "<stdout>"
yy1265:
	YYDEBUG(1265, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1264;
		if (yych <= 0x08) goto yy55;
		goto yy1264;
	} else {
		if (yych == ' ') goto yy1264;
		goto yy55;
	}
yy1266:
	YYDEBUG(1266, *YYCURSOR);
	++YYCURSOR;
	goto yy1125;
yy1267:
	YYDEBUG(1267, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1266;
		if (yych <= 0x08) goto yy55;
		goto yy1266;
	} else {
		if (yych == ' ') goto yy1266;
		goto yy55;
	}
yy1268:
	YYDEBUG(1268, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'A') {
			if (yych <= '@') goto yy55;
			goto yy1181;
		} else {
			if (yych == 'P') goto yy1181;
			goto yy55;
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'a') goto yy1181;
			if (yych <= 'o') goto yy55;
			goto yy1181;
		} else {
			if (yych == 0xE2) goto yy1183;
			goto yy55;
		}
	}
yy1269:
	YYDEBUG(1269, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy836;
	if (yych <= '5') goto yy1291;
	if (yych <= '9') goto yy1062;
	if (yych <= ':') goto yy1292;
	goto yy836;
yy1270:
	YYDEBUG(1270, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1271;
	if (yych <= '9') goto yy1062;
	goto yy55;
yy1271:
	YYDEBUG(1271, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy836;
	if (yych <= '9') goto yy1062;
	goto yy836;
yy1272:
	YYDEBUG(1272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1062;
		goto yy836;
	} else {
		if (yych <= 'Z') goto yy1293;
		if (yych <= '`') goto yy836;
		if (yych <= 'z') goto yy1293;
		goto yy836;
	}
yy1273:
	YYDEBUG(1273, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy55;
	if (yych <= 'Z') goto yy1294;
	if (yych <= '`') goto yy55;
	if (yych <= 'z') goto yy1294;
	goto yy55;
yy1274:
	YYDEBUG(1274, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1062;
			goto yy836;
		} else {
			if (yych == '.') goto yy836;
			goto yy1273;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy836;
			if (yych <= 'Z') goto yy1293;
			goto yy836;
		} else {
			if (yych <= '_') goto yy1273;
			if (yych <= '`') goto yy836;
			if (yych <= 'z') goto yy1295;
			goto yy836;
		}
	}
yy1275:
	YYDEBUG(1275, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy836;
			goto yy1062;
		} else {
			if (yych == '+') goto yy1188;
			goto yy836;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy1188;
			if (yych <= '@') goto yy836;
			goto yy1293;
		} else {
			if (yych <= '`') goto yy836;
			if (yych <= 'z') goto yy1293;
			goto yy836;
		}
	}
yy1276:
	YYDEBUG(1276, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '*') {
			if (yych == '(') goto yy1187;
			goto yy55;
		} else {
			if (yych == ',') goto yy55;
			if (yych <= '-') goto yy1188;
			goto yy55;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'G') goto yy1190;
			if (yych <= 'Z') goto yy1189;
			goto yy55;
		} else {
			if (yych <= 'z') goto yy1191;
			if (yych == 0xE2) goto yy1193;
			goto yy55;
		}
	}
yy1277:
	YYDEBUG(1277, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych <= '(') {
				if (yych <= '\'') goto yy55;
				goto yy1187;
			} else {
				if (yych == '+') goto yy1188;
				goto yy55;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '-') goto yy1188;
				goto yy55;
			} else {
				if (yych <= 'A') goto yy1196;
				if (yych <= 'F') goto yy1189;
				goto yy1190;
			}
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') {
				if (yych <= 'O') goto yy1189;
				goto yy1196;
			} else {
				if (yych <= 'Z') goto yy1189;
				if (yych <= '`') goto yy55;
				goto yy1197;
			}
		} else {
			if (yych <= 'z') {
				if (yych == 'p') goto yy1197;
				goto yy1191;
			} else {
				if (yych == 0xE2) goto yy1199;
				goto yy55;
			}
		}
	}
yy1278:
	YYDEBUG(1278, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1296;
	if (yych == 'h') goto yy1296;
	goto yy55;
yy1279:
	YYDEBUG(1279, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1137;
		if (yych <= 0x1F) goto yy968;
		goto yy1137;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy968;
			goto yy1139;
		} else {
			if (yych == 0xE2) goto yy1140;
			goto yy968;
		}
	}
yy1280:
	YYDEBUG(1280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1297;
	if (yych == 'c') goto yy1297;
	goto yy55;
yy1281:
	YYDEBUG(1281, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy880;
		if (yych <= '/') goto yy188;
		goto yy1298;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy1282:
	YYDEBUG(1282, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1299;
	goto yy55;
yy1283:
	YYDEBUG(1283, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1300;
	if (yych <= '6') goto yy1302;
	if (yych <= '9') goto yy1303;
	goto yy55;
yy1284:
	YYDEBUG(1284, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1304;
	goto yy55;
yy1285:
	YYDEBUG(1285, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xC2) goto yy91;
	if (yych == 0xE2) goto yy92;
	goto yy188;
yy1286:
	YYDEBUG(1286, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy1300;
	if (yych <= '5') goto yy1287;
	if (yych <= '6') goto yy1288;
	goto yy55;
yy1287:
	YYDEBUG(1287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1303;
	goto yy55;
yy1288:
	YYDEBUG(1288, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1303;
	goto yy55;
yy1289:
	YYDEBUG(1289, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1260;
	goto yy55;
yy1290:
	YYDEBUG(1290, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1221;
	goto yy55;
yy1291:
	YYDEBUG(1291, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy836;
	if (yych <= '9') goto yy1305;
	goto yy836;
yy1292:
	YYDEBUG(1292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1306;
	if (yych <= '9') goto yy1062;
	goto yy55;
yy1293:
	YYDEBUG(1293, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1062;
		goto yy836;
	} else {
		if (yych <= 'Z') goto yy1307;
		if (yych <= '`') goto yy836;
		if (yych <= 'z') goto yy1307;
		goto yy836;
	}
yy1294:
	YYDEBUG(1294, *YYCURSOR);
	yyaccept = 20;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych <= ',') goto yy836;
			goto yy1273;
		} else {
			if (yych == '/') goto yy1273;
			goto yy836;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy1294;
			if (yych <= '^') goto yy836;
			goto yy1273;
		} else {
			if (yych <= '`') goto yy836;
			if (yych <= 'z') goto yy1294;
			goto yy836;
		}
	}
yy1295:
	YYDEBUG(1295, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1062;
			goto yy836;
		} else {
			if (yych == '.') goto yy836;
			goto yy1273;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy836;
			if (yych <= 'Z') goto yy1307;
			goto yy836;
		} else {
			if (yych <= '_') goto yy1273;
			if (yych <= '`') goto yy836;
			if (yych <= 'z') goto yy1308;
			goto yy836;
		}
	}
yy1296:
	YYDEBUG(1296, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1069;
	if (yych == 't') goto yy1069;
	goto yy55;
yy1297:
	YYDEBUG(1297, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1146;
	if (yych == 'o') goto yy1146;
	goto yy55;
yy1298:
	YYDEBUG(1298, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych == '-') goto yy880;
		if (yych <= '/') goto yy188;
		goto yy1309;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy188;
			goto yy91;
		} else {
			if (yych == 0xE2) goto yy92;
			goto yy188;
		}
	}
yy1299:
	YYDEBUG(1299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1310;
	goto yy55;
yy1300:
	YYDEBUG(1300, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1301;
	if (yych <= '9') goto yy1303;
yy1301:
	YYDEBUG(1301, *YYCURSOR);
#line 1657 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr(&ptr, 4);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		s->time->s = timelib_get_nr(&ptr, 2);
		if (*ptr == '.') {
			s->time->us = timelib_get_frac_nr(&ptr);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
				if (tz_not_found) {
					add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 24188 "<stdout>"
yy1302:
	YYDEBUG(1302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy1301;
yy1303:
	YYDEBUG(1303, *YYCURSOR);
	++YYCURSOR;
	goto yy1301;
yy1304:
	YYDEBUG(1304, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1311;
	if (yych <= '9') goto yy1255;
	goto yy55;
yy1305:
	YYDEBUG(1305, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy836;
	if (yych <= '5') goto yy1312;
	if (yych <= '6') goto yy1313;
	goto yy836;
yy1306:
	YYDEBUG(1306, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy836;
	if (yych <= '9') goto yy1314;
	goto yy836;
yy1307:
	YYDEBUG(1307, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1062;
		goto yy836;
	} else {
		if (yych <= 'Z') goto yy1315;
		if (yych <= '`') goto yy836;
		if (yych <= 'z') goto yy1315;
		goto yy836;
	}
yy1308:
	YYDEBUG(1308, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1062;
			goto yy836;
		} else {
			if (yych == '.') goto yy836;
			goto yy1273;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy836;
			if (yych <= 'Z') goto yy1315;
			goto yy836;
		} else {
			if (yych <= '_') goto yy1273;
			if (yych <= '`') goto yy836;
			if (yych <= 'z') goto yy1316;
			goto yy836;
		}
	}
yy1309:
	YYDEBUG(1309, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy880;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1317;
	goto yy55;
yy1310:
	YYDEBUG(1310, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1318;
	goto yy55;
yy1311:
	YYDEBUG(1311, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1319;
	if (yych <= ':') goto yy1283;
	goto yy55;
yy1312:
	YYDEBUG(1312, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1062;
	goto yy55;
yy1313:
	YYDEBUG(1313, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1062;
	goto yy55;
yy1314:
	YYDEBUG(1314, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy1320;
	goto yy836;
yy1315:
	YYDEBUG(1315, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy1062;
	goto yy836;
yy1316:
	YYDEBUG(1316, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= '(') goto yy836;
			goto yy1062;
		} else {
			if (yych == '-') goto yy1273;
			goto yy836;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '/') goto yy1273;
			if (yych <= '^') goto yy836;
			goto yy1273;
		} else {
			if (yych <= '`') goto yy836;
			if (yych <= 'z') goto yy1321;
			goto yy836;
		}
	}
yy1317:
	YYDEBUG(1317, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy880;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1322;
	goto yy55;
yy1318:
	YYDEBUG(1318, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1323;
	goto yy55;
yy1319:
	YYDEBUG(1319, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1324;
	goto yy55;
yy1320:
	YYDEBUG(1320, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1312;
	if (yych <= '6') goto yy1313;
	goto yy55;
yy1321:
	YYDEBUG(1321, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') {
		if (yych == '-') goto yy1273;
		if (yych <= '.') goto yy55;
		goto yy1273;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy55;
			goto yy1273;
		} else {
			if (yych <= '`') goto yy55;
			if (yych <= 'z') goto yy1321;
			goto yy55;
		}
	}
yy1322:
	YYDEBUG(1322, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy880;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1325;
	goto yy55;
yy1323:
	YYDEBUG(1323, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1326;
	if (yych <= '6') goto yy1327;
	goto yy55;
yy1324:
	YYDEBUG(1324, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1328;
	if (yych <= '6') goto yy1329;
	if (yych <= '9') goto yy1303;
	goto yy55;
yy1325:
	YYDEBUG(1325, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy880;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1330;
	goto yy55;
yy1326:
	YYDEBUG(1326, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1331;
	goto yy55;
yy1327:
	YYDEBUG(1327, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1331;
	goto yy55;
yy1328:
	YYDEBUG(1328, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1301;
	if (yych <= '9') goto yy1332;
	goto yy1301;
yy1329:
	YYDEBUG(1329, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1332;
	goto yy1301;
yy1330:
	YYDEBUG(1330, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy880;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1333;
	goto yy55;
yy1331:
	YYDEBUG(1331, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy1334;
		if (yych <= 0x1F) goto yy55;
		goto yy1334;
	} else {
		if (yych <= 0xC2) {
			if (yych <= 0xC1) goto yy55;
			goto yy1335;
		} else {
			if (yych == 0xE2) goto yy1336;
			goto yy55;
		}
	}
yy1332:
	YYDEBUG(1332, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1337;
	goto yy1301;
yy1333:
	YYDEBUG(1333, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy880;
	goto yy55;
yy1334:
	YYDEBUG(1334, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= '*') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy55;
			goto yy1334;
		} else {
			if (yych == ' ') goto yy1334;
			goto yy55;
		}
	} else {
		if (yych <= '-') {
			if (yych == ',') goto yy55;
			goto yy1338;
		} else {
			if (yych == 'G') goto yy1339;
			goto yy55;
		}
	}
yy1335:
	YYDEBUG(1335, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xA0) goto yy1340;
	goto yy55;
yy1336:
	YYDEBUG(1336, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0x80) goto yy1341;
	goto yy55;
yy1337:
	YYDEBUG(1337, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1342;
	goto yy55;
yy1338:
	YYDEBUG(1338, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1343;
	if (yych <= '2') goto yy1345;
	if (yych <= '9') goto yy1346;
	goto yy55;
yy1339:
	YYDEBUG(1339, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1347;
	goto yy55;
yy1340:
	YYDEBUG(1340, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= '-') {
		if (yych == '+') goto yy1338;
		if (yych <= ',') goto yy55;
		goto yy1338;
	} else {
		if (yych <= 'G') {
			if (yych <= 'F') goto yy55;
			goto yy1339;
		} else {
			if (yych == 0xC2) goto yy1335;
			goto yy55;
		}
	}
yy1341:
	YYDEBUG(1341, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == 0xAF) goto yy1348;
	goto yy55;
yy1342:
	YYDEBUG(1342, *YYCURSOR);
	yyaccept = 32;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= '-') {
		if (yych == '+') goto yy1349;
		if (yych <= ',') goto yy1301;
		goto yy1349;
	} else {
		if (yych <= '9') {
			if (yych <= '/') goto yy1301;
			goto yy1342;
		} else {
			if (yych == 'G') goto yy1350;
			goto yy1301;
		}
	}
yy1343:
	YYDEBUG(1343, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1344;
	if (yych <= '9') goto yy1351;
	if (yych <= ':') goto yy1352;
yy1344:
	YYDEBUG(1344, *YYCURSOR);
#line 1763 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->m = timelib_get_month(&ptr);
		s->time->y = timelib_get_nr(&ptr, 4);
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		s->time->s = timelib_get_nr(&ptr, 2);

		timelib_eat_spaces(&ptr);

		s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 24578 "<stdout>"
yy1345:
	YYDEBUG(1345, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '5') {
		if (yych <= '/') goto yy1344;
		if (yych <= '4') goto yy1351;
		goto yy1353;
	} else {
		if (yych <= '9') goto yy1354;
		if (yych <= ':') goto yy1352;
		goto yy1344;
	}
yy1346:
	YYDEBUG(1346, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1344;
	if (yych <= '5') goto yy1353;
	if (yych <= '9') goto yy1354;
	if (yych <= ':') goto yy1352;
	goto yy1344;
yy1347:
	YYDEBUG(1347, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1355;
	goto yy55;
yy1348:
	YYDEBUG(1348, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yych <= '-') {
		if (yych == '+') goto yy1338;
		if (yych <= ',') goto yy55;
		goto yy1338;
	} else {
		if (yych <= 'G') {
			if (yych <= 'F') goto yy55;
			goto yy1339;
		} else {
			if (yych == 0xE2) goto yy1336;
			goto yy55;
		}
	}
yy1349:
	YYDEBUG(1349, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1356;
	if (yych <= '2') goto yy1357;
	if (yych <= '9') goto yy1358;
	goto yy55;
yy1350:
	YYDEBUG(1350, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1359;
	goto yy55;
yy1351:
	YYDEBUG(1351, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1344;
	if (yych <= '5') goto yy1360;
	if (yych <= '9') goto yy1354;
	if (yych <= ':') goto yy1361;
	goto yy1344;
yy1352:
	YYDEBUG(1352, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1353;
	if (yych <= '9') goto yy1354;
	goto yy55;
yy1353:
	YYDEBUG(1353, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1344;
	if (yych >= ':') goto yy1344;
yy1354:
	YYDEBUG(1354, *YYCURSOR);
	++YYCURSOR;
	goto yy1344;
yy1355:
	YYDEBUG(1355, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy1338;
	if (yych == '-') goto yy1338;
	goto yy55;
yy1356:
	YYDEBUG(1356, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1301;
	if (yych <= '9') goto yy1362;
	if (yych <= ':') goto yy1363;
	goto yy1301;
yy1357:
	YYDEBUG(1357, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '5') {
		if (yych <= '/') goto yy1301;
		if (yych <= '4') goto yy1362;
		goto yy1300;
	} else {
		if (yych <= '9') goto yy1303;
		if (yych <= ':') goto yy1363;
		goto yy1301;
	}
yy1358:
	YYDEBUG(1358, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1301;
	if (yych <= '5') goto yy1300;
	if (yych <= '9') goto yy1303;
	if (yych <= ':') goto yy1363;
	goto yy1301;
yy1359:
	YYDEBUG(1359, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1364;
	goto yy55;
yy1360:
	YYDEBUG(1360, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1344;
	if (yych <= '9') goto yy1365;
	goto yy1344;
yy1361:
	YYDEBUG(1361, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1366;
	if (yych <= '9') goto yy1354;
	goto yy55;
yy1362:
	YYDEBUG(1362, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1301;
	if (yych <= '5') goto yy1367;
	if (yych <= '9') goto yy1303;
	if (yych <= ':') goto yy1368;
	goto yy1301;
yy1363:
	YYDEBUG(1363, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1300;
	if (yych <= '9') goto yy1303;
	goto yy55;
yy1364:
	YYDEBUG(1364, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy1349;
	if (yych == '-') goto yy1349;
	goto yy55;
yy1365:
	YYDEBUG(1365, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1344;
	if (yych <= '5') goto yy1369;
	if (yych <= '6') goto yy1370;
	goto yy1344;
yy1366:
	YYDEBUG(1366, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1344;
	if (yych <= '9') goto yy1371;
	goto yy1344;
yy1367:
	YYDEBUG(1367, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1301;
	if (yych <= '9') goto yy1372;
	goto yy1301;
yy1368:
	YYDEBUG(1368, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1373;
	if (yych <= '9') goto yy1303;
	goto yy55;
yy1369:
	YYDEBUG(1369, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1354;
	goto yy55;
yy1370:
	YYDEBUG(1370, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1354;
	goto yy55;
yy1371:
	YYDEBUG(1371, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy1374;
	goto yy1344;
yy1372:
	YYDEBUG(1372, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1301;
	if (yych <= '5') goto yy1287;
	if (yych <= '6') goto yy1288;
	goto yy1301;
yy1373:
	YYDEBUG(1373, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1301;
	if (yych <= '9') goto yy1375;
	goto yy1301;
yy1374:
	YYDEBUG(1374, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1369;
	if (yych <= '6') goto yy1370;
	goto yy55;
yy1375:
	YYDEBUG(1375, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy1260;
	goto yy1301;
}
#line 1991 "parse_date.re"

}

#line 24814 "<stdout>"
#define YYMAXFILL 36
#line 1994 "parse_date.re"


timelib_time *timelib_strtotime(const char *s, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	Scanner in;
	int t;
	const char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, TIMELIB_ERR_EMPTY_STRING, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->us = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = timelib_malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->us = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;
	in.time->relative.days = TIMELIB_UNSET;

	do {
		t = scan(&in, tz_get_wrapper);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	/* do funky checking whether the parsed time was valid time */
	if (in.time->have_time && !timelib_valid_time( in.time->h, in.time->i, in.time->s)) {
		add_warning(&in, TIMELIB_WARN_INVALID_TIME, "The parsed time was invalid");
	}
	/* do funky checking whether the parsed date was valid date */
	if (in.time->have_date && !timelib_valid_date( in.time->y, in.time->m, in.time->d)) {
		add_warning(&in, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid");
	}

	timelib_free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

#define TIMELIB_CHECK_NUMBER                                           \
		if (strchr("0123456789", *ptr) == NULL)                        \
		{                                                              \
			add_pbf_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Unexpected data found.", string, begin); \
		}
#define TIMELIB_CHECK_SIGNED_NUMBER                                    \
		if (strchr("+-0123456789", *ptr) == NULL)                      \
		{                                                              \
			add_pbf_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Unexpected data found.", string, begin); \
		}

static void timelib_time_reset_fields(timelib_time *time)
{
	assert(time != NULL);

	time->y = 1970;
	time->m = 1;
	time->d = 1;
	time->h = time->i = time->s = 0;
	time->us = 0;
	time->tz_info = NULL;
}

static void timelib_time_reset_unset_fields(timelib_time *time)
{
	assert(time != NULL);

	if (time->y == TIMELIB_UNSET ) time->y = 1970;
	if (time->m == TIMELIB_UNSET ) time->m = 1;
	if (time->d == TIMELIB_UNSET ) time->d = 1;
	if (time->h == TIMELIB_UNSET ) time->h = 0;
	if (time->i == TIMELIB_UNSET ) time->i = 0;
	if (time->s == TIMELIB_UNSET ) time->s = 0;
	if (time->us == TIMELIB_UNSET ) time->us = 0;
}

static const timelib_format_specifier default_format_map[] = {
	{'+', TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS},
	{'#', TIMELIB_FORMAT_ANY_SEPARATOR},
	{'j', TIMELIB_FORMAT_DAY_TWO_DIGIT},
	{'d', TIMELIB_FORMAT_DAY_TWO_DIGIT_PADDED},
	{'z', TIMELIB_FORMAT_DAY_OF_YEAR},
	{'S', TIMELIB_FORMAT_DAY_SUFFIX},
	{'U', TIMELIB_FORMAT_EPOCH_SECONDS},
	{'\\', TIMELIB_FORMAT_ESCAPE},
	{'h', TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX},
	{'g', TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX_PADDED},
	{'H', TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX},
	{'G', TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX_PADDED},
	{'a', TIMELIB_FORMAT_MERIDIAN},
	{'A', TIMELIB_FORMAT_MERIDIAN},
	{'u', TIMELIB_FORMAT_MICROSECOND_SIX_DIGIT},
	{'v', TIMELIB_FORMAT_MILLISECOND_THREE_DIGIT},
	{'i', TIMELIB_FORMAT_MINUTE_TWO_DIGIT},
	{'n', TIMELIB_FORMAT_MONTH_TWO_DIGIT},
	{'m', TIMELIB_FORMAT_MONTH_TWO_DIGIT_PADDED},
	{'?', TIMELIB_FORMAT_RANDOM_CHAR},
	{'!', TIMELIB_FORMAT_RESET_ALL},
	{'|', TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET},
	{'s', TIMELIB_FORMAT_SECOND_TWO_DIGIT},
	{';', TIMELIB_FORMAT_SEPARATOR},
	{':', TIMELIB_FORMAT_SEPARATOR},
	{'/', TIMELIB_FORMAT_SEPARATOR},
	{'.', TIMELIB_FORMAT_SEPARATOR},
	{',', TIMELIB_FORMAT_SEPARATOR},
	{'-', TIMELIB_FORMAT_SEPARATOR},
	{'(', TIMELIB_FORMAT_SEPARATOR},
	{')', TIMELIB_FORMAT_SEPARATOR},
	{'*', TIMELIB_FORMAT_SKIP_TO_SEPARATOR},
	{'D', TIMELIB_FORMAT_TEXTUAL_DAY_3_LETTER},
	{'l', TIMELIB_FORMAT_TEXTUAL_DAY_FULL},
	{'M', TIMELIB_FORMAT_TEXTUAL_MONTH_3_LETTER},
	{'F', TIMELIB_FORMAT_TEXTUAL_MONTH_FULL},
	{'e', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'P', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'p', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'T', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'O', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{' ', TIMELIB_FORMAT_WHITESPACE},
	{'y', TIMELIB_FORMAT_YEAR_TWO_DIGIT},
	{'Y', TIMELIB_FORMAT_YEAR_FOUR_DIGIT},
	{'x', TIMELIB_FORMAT_YEAR_EXPANDED},
	{'X', TIMELIB_FORMAT_YEAR_EXPANDED},
	{'\0', TIMELIB_FORMAT_END}
};

static const timelib_format_config default_format_config = {
	default_format_map,
	// No prefix required by default.
	'\0'
};

static timelib_format_specifier_code timelib_lookup_format(char input, const timelib_format_specifier* format_map)
{
	while (format_map && format_map->specifier != '\0') {
		if (format_map->specifier == input) {
			return format_map->code;
		}
		format_map++;
	}
	return TIMELIB_FORMAT_LITERAL;
}

timelib_time *timelib_parse_from_format(const char *format, const char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	return timelib_parse_from_format_with_map(format, string, len, errors, tzdb, tz_get_wrapper, &default_format_config);
}

timelib_time *timelib_parse_from_format_with_map(const char *format, const char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper, const timelib_format_config* format_config)
{
	const char  *fptr = format;
	const char  *ptr = string;
	const char  *begin;
	timelib_sll  tmp;
	Scanner      in;
	Scanner     *s = &in;
	bool         allow_extra = false;
	bool         prefix_found = false;
	int          iso_year = TIMELIB_UNSET;
	int          iso_week_of_year = TIMELIB_UNSET;
	int          iso_day_of_week = TIMELIB_UNSET;
	char         prefix_char = format_config->prefix_char;
	const timelib_format_specifier *format_map = format_config->format_map;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->us = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	/* Loop over the format string */
	while (*fptr && *ptr) {
		begin = ptr;

		if (prefix_char) {
			/* There are 2 cases where the input string and format string
			 * should match the next literal:
			 *
			 * 1. No prefix has been specified yet in the format, so expect 1:1
			 *    match.
			 * 2. Sequential prefix characters indicating that the second
			 *    prefix is escaped. (e.g. "%%" is expecting literal "%")
			 */
			if ((!prefix_found && *fptr != prefix_char) ||
				(prefix_found && *fptr == prefix_char)) {
				if (*fptr != *ptr) {
					add_pbf_error(s, TIMELIB_ERR_FORMAT_LITERAL_MISMATCH, "Format literal not found", string, begin);
				}
				ptr++;
				fptr++;
				prefix_found = false;
				continue;
			}

			if (*fptr == prefix_char) {
				fptr++;
				prefix_found = true;
				continue;
			}

			/* Fall through case is that the prefix has been found and the next
			 * character is the format specifier. */
			prefix_found = false;
		}

		switch (timelib_lookup_format(*fptr, format_map)) {
			case TIMELIB_FORMAT_TEXTUAL_DAY_3_LETTER: /* three letter day */
			case TIMELIB_FORMAT_TEXTUAL_DAY_FULL: /* full day */
				{
					const timelib_relunit* tmprel = 0;

					tmprel = timelib_lookup_relunit(&ptr);
					if (!tmprel) {
						add_pbf_error(s, TIMELIB_ERR_NO_TEXTUAL_DAY, "A textual day could not be found", string, begin);
						break;
					} else {
						in.time->have_relative = 1;
						in.time->relative.have_weekday_relative = 1;
						in.time->relative.weekday = tmprel->multiplier;
						in.time->relative.weekday_behavior = 1;
					}
				}
				break;
			case TIMELIB_FORMAT_DAY_TWO_DIGIT: /* two digit day, without leading zero */
			case TIMELIB_FORMAT_DAY_TWO_DIGIT_PADDED: /* two digit day, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->d = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_DAY, "A two digit day could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_DAY_SUFFIX: /* day suffix, ignored, nor checked */
				timelib_skip_day_suffix(&ptr);
				break;
			case TIMELIB_FORMAT_DAY_OF_YEAR: /* day of year - resets month (0 based) - also initializes everything else to !TIMELIB_UNSET */
				TIMELIB_CHECK_NUMBER;
				if (s->time->y == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_MERIDIAN_BEFORE_HOUR, "A 'day of year' can only come after a year has been found", string, begin);
				}
				if ((tmp = timelib_get_nr(&ptr, 3)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_THREE_DIGIT_DAY_OF_YEAR, "A three digit day-of-year could not be found", string, begin);
					break;
				}

				if (s->time->y != TIMELIB_UNSET) {
					s->time->have_date = 1;
					s->time->m = 1;
					s->time->d = tmp + 1;
					timelib_do_normalize(s->time);
				}
				break;

			case TIMELIB_FORMAT_MONTH_TWO_DIGIT: /* two digit month, without leading zero */
			case TIMELIB_FORMAT_MONTH_TWO_DIGIT_PADDED: /* two digit month, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->m = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_MONTH, "A two digit month could not be found", string, begin);
					break;
				}
				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_TEXTUAL_MONTH_3_LETTER: /* three letter month */
			case TIMELIB_FORMAT_TEXTUAL_MONTH_FULL: /* full month */
				tmp = timelib_lookup_month(&ptr);
				if (!tmp) {
					add_pbf_error(s, TIMELIB_ERR_NO_TEXTUAL_MONTH, "A textual month could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				s->time->m = tmp;
				break;
			case TIMELIB_FORMAT_YEAR_TWO_DIGIT: /* two digit year */
				{
					int length = 0;
					TIMELIB_CHECK_NUMBER;
					if ((s->time->y = timelib_get_nr_ex(&ptr, 2, &length)) == TIMELIB_UNSET) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_YEAR, "A two digit year could not be found", string, begin);
						break;
					}
					
					s->time->have_date = 1;
					TIMELIB_PROCESS_YEAR(s->time->y, length);
				}
				break;
			case TIMELIB_FORMAT_YEAR_FOUR_DIGIT: /* four digit year */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr(&ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_FOUR_DIGIT_YEAR, "A four digit year could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_YEAR_EXPANDED: /* optional symbol, followed by up to 19 digits */
				TIMELIB_CHECK_SIGNED_NUMBER;
				if ((s->time->y = timelib_get_signed_nr(s, &ptr, 19)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_FOUR_DIGIT_YEAR, "An expanded digit year could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX: /* two digit hour, without leading zero */
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX_PADDED: /* two digit hour, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_HOUR, "A two digit hour could not be found", string, begin);
					break;
				}
				if (s->time->h > 12) {
					add_pbf_error(s, TIMELIB_ERR_HOUR_LARGER_THAN_12, "Hour cannot be higher than 12", string, begin);
					break;
				}

				s->time->have_time = 1;
				break;
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX_PADDED: /* two digit hour, with leading zero */
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX: /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_HOUR, "A two digit hour could not be found", string, begin);
					break;
				}

				s->time->have_time = 1;
				break;
			case TIMELIB_FORMAT_MERIDIAN: /* am/pm/a.m./p.m. AM/PM/A.M./P.M. */
				if (s->time->h == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_MERIDIAN_BEFORE_HOUR, "Meridian can only come after an hour has been found", string, begin);
				}
				if ((tmp = timelib_meridian_with_check(&ptr, s->time->h)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_MERIDIAN, "A meridian could not be found", string, begin);
					break;
				}

				s->time->have_time = 1;
				if (s->time->h != TIMELIB_UNSET) {
					s->time->h += tmp;
				}
				break;
			case TIMELIB_FORMAT_MINUTE_TWO_DIGIT: /* two digit minute, with leading zero */
				{
					int length;
					timelib_sll min;

					TIMELIB_CHECK_NUMBER;
					min = timelib_get_nr_ex(&ptr, 2, &length);
					if (min == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_MINUTE, "A two digit minute could not be found", string, begin);
						break;
					}

					s->time->have_time = 1;
					s->time->i = min;
				}
				break;
			case TIMELIB_FORMAT_SECOND_TWO_DIGIT: /* two digit second, with leading zero */
				{
					int length;
					timelib_sll sec;

					TIMELIB_CHECK_NUMBER;
					sec = timelib_get_nr_ex(&ptr, 2, &length);
					if (sec == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_SECOND, "A two digit second could not be found", string, begin);
						break;
					}

					s->time->have_time = 1;
					s->time->s = sec;
				}
				break;
			case TIMELIB_FORMAT_MICROSECOND_SIX_DIGIT: /* up to six digit microsecond */
				{
					double f;
					const char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr(&ptr, 6)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, TIMELIB_ERR_NO_SIX_DIGIT_MICROSECOND, "A six digit microsecond could not be found", string, begin);
						break;
					}

					s->time->us = (f * pow(10, 6 - (ptr - tptr)));
				}
				break;
			case TIMELIB_FORMAT_MILLISECOND_THREE_DIGIT: /* up to three digit millisecond */
				{
					double f;
					const char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr(&ptr, 3)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, TIMELIB_ERR_NO_THREE_DIGIT_MILLISECOND, "A three digit millisecond could not be found", string, begin);
						break;
					}
					
					s->time->us = (f * pow(10, 3 - (ptr - tptr)) * 1000);
				}
				break;
			case TIMELIB_FORMAT_WHITESPACE: /* any sort of whitespace (' ' and \t) */
				timelib_eat_spaces(&ptr);
				break;
			case TIMELIB_FORMAT_EPOCH_SECONDS: /* epoch seconds */
				TIMELIB_CHECK_SIGNED_NUMBER;
				tmp = timelib_get_signed_nr(s, &ptr, 24);
				s->time->have_zone = 1;
				s->time->sse = tmp;
				s->time->is_localtime = 1;
				s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
				s->time->z = 0;
				s->time->dst = 0;
				timelib_update_from_sse(s->time);
				break;

			case TIMELIB_FORMAT_ANY_SEPARATOR: /* separation symbol */
				if (timelib_lookup_format(*ptr, format_map) != TIMELIB_FORMAT_SEPARATOR) {
					add_pbf_error(s, TIMELIB_ERR_NO_SEP_SYMBOL, "The separation symbol ([;:/.,-]) could not be found", string, begin);
					break;
				}
				
				++ptr;
				break;

			case TIMELIB_FORMAT_SEPARATOR:
				if (*ptr != *fptr) {
					add_pbf_error(s, TIMELIB_ERR_NO_SEP_SYMBOL, "The separation symbol could not be found", string, begin);
					break;
				}

				++ptr;
				break;

			case TIMELIB_FORMAT_RESET_ALL: /* reset all fields to default */
				timelib_time_reset_fields(s->time);
				break; /* break intentionally not missing */

			case TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET: /* reset all fields to default when not set */
				timelib_time_reset_unset_fields(s->time);
				break; /* break intentionally not missing */

			case TIMELIB_FORMAT_RANDOM_CHAR: /* random char */
				++ptr;
				break;

			case TIMELIB_FORMAT_ESCAPE: /* escaped char */
				if (!fptr[1]) {
					add_pbf_error(s, TIMELIB_ERR_EXPECTED_ESCAPE_CHAR, "Escaped character expected", string, begin);
					break;
				}
				fptr++;
				if (*ptr != *fptr) {
					add_pbf_error(s, TIMELIB_ERR_NO_ESCAPED_CHAR, "The escaped character could not be found", string, begin);
					break;
				}

				++ptr;
				break;

			case TIMELIB_FORMAT_SKIP_TO_SEPARATOR: /* random chars until a separator or number ([ \t.,:;/-0123456789]) */
				timelib_eat_until_separator(&ptr);
				break;

			case TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS: /* allow extra chars in the format */
				allow_extra = true;
				break;
			case TIMELIB_FORMAT_YEAR_ISO:
				if ((iso_year = timelib_get_nr(&ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_FOUR_DIGIT_YEAR_ISO, "A four digit ISO year could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_WEEK_OF_YEAR_ISO:
				if ((iso_week_of_year = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_WEEK, "A two digit ISO week could not be found", string, begin);
					break;
				}
				/* Range is 1 - 53  for ISO week of year */
				if (iso_week_of_year < 1 || iso_week_of_year > 53) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_WEEK, "ISO Week must be between 1 and 53", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_DAY_OF_WEEK_ISO:
				if ((iso_day_of_week = timelib_get_nr(&ptr, 1)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_DAY_OF_WEEK, "A single digit day of week could not be found", string, begin);
					break;
				}
				if (iso_day_of_week < 1 || iso_day_of_week > 7) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_DAY_OF_WEEK, "Day of week must be between 1 and 7", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_TIMEZONE_OFFSET: /* timezone */
				{
					int tz_not_found;

					s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
					if (tz_not_found) {
						add_pbf_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database", string, begin);
						break;
					}

					s->time->have_zone = 1;
				}
				break;
			case TIMELIB_FORMAT_TIMEZONE_OFFSET_MINUTES: /* timezone format +/-mmm */
				s->time->z = timelib_parse_tz_minutes(&ptr, s->time);
				if (s->time->z == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_TZ_OFFSET, "Invalid timezone offset in minutes", string, begin);
					break;
				}

				s->time->have_zone = 1;
				break;
			case TIMELIB_FORMAT_LITERAL:
			default:
				if (*fptr != *ptr) {
					add_pbf_error(s, TIMELIB_ERR_WRONG_FORMAT_SEP, "The format separator does not match", string, begin);
				}
				ptr++;
		}
		fptr++;
	}
	if (*ptr) {
		if (allow_extra) {
			add_pbf_warning(s, TIMELIB_WARN_TRAILING_DATA, "Trailing data", string, ptr);
		} else {
			add_pbf_error(s, TIMELIB_ERR_TRAILING_DATA, "Trailing data", string, ptr);
		}
	}

	if (*fptr) {
		/* Trailing reset specifiers are valid. */
		int done = 0;
		while (*fptr && !done) {
			switch (timelib_lookup_format(*fptr, format_map)) {
				case TIMELIB_FORMAT_RESET_ALL: /* reset all fields to default */
					timelib_time_reset_fields(s->time);
					break;

				case TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET: /* reset all fields to default when not set */
					timelib_time_reset_unset_fields(s->time);
					break;
				case TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS:
					break;

				default:
					add_pbf_error(s, TIMELIB_ERR_DATA_MISSING, "Not enough data available to satisfy format", string, ptr);
					done = 1;
			}
			fptr++;
		}
	}

	/* clean up a bit */
	if (s->time->h != TIMELIB_UNSET || s->time->i != TIMELIB_UNSET || s->time->s != TIMELIB_UNSET || s->time->us != TIMELIB_UNSET) {
		if (s->time->h == TIMELIB_UNSET ) {
			s->time->h = 0;
		}
		if (s->time->i == TIMELIB_UNSET ) {
			s->time->i = 0;
		}
		if (s->time->s == TIMELIB_UNSET ) {
			s->time->s = 0;
		}
		if (s->time->us == TIMELIB_UNSET ) {
			s->time->us = 0;
		}
	}

	/* Check for mixing of ISO dates with natural dates. */
	if (s->time->y != TIMELIB_UNSET && (iso_week_of_year != TIMELIB_UNSET || iso_year != TIMELIB_UNSET || iso_day_of_week != TIMELIB_UNSET)) {
		add_pbf_error(s, TIMELIB_ERR_MIX_ISO_WITH_NATURAL, "Mixing of ISO dates with natural dates is not allowed", string, ptr);
	}
	if (iso_year != TIMELIB_UNSET && (s->time->y != TIMELIB_UNSET || s->time->m != TIMELIB_UNSET || s->time->d != TIMELIB_UNSET)) {
		add_pbf_error(s, TIMELIB_ERR_MIX_ISO_WITH_NATURAL, "Mixing of ISO dates with natural dates is not allowed", string, ptr);
	}

	/* Convert ISO values */
	if (iso_year != TIMELIB_UNSET) {
		/* Default week of year and day of week to 1. */
		if (iso_week_of_year == TIMELIB_UNSET) {
			iso_week_of_year = 1;
		}
		if (iso_day_of_week == TIMELIB_UNSET) {
			iso_day_of_week = 1;
		}
		timelib_date_from_isodate(iso_year, iso_week_of_year, iso_day_of_week, &s->time->y, &s->time->m, &s->time->d);
	} else if (iso_week_of_year != TIMELIB_UNSET || iso_day_of_week != TIMELIB_UNSET) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid", string, ptr);
	}

	/* do funky checking whether the parsed time was valid time */
	if (s->time->h != TIMELIB_UNSET && s->time->i != TIMELIB_UNSET &&
		s->time->s != TIMELIB_UNSET &&
		!timelib_valid_time( s->time->h, s->time->i, s->time->s)) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_TIME, "The parsed time was invalid", string, ptr);
	}
	/* do funky checking whether the parsed date was valid date */
	if (s->time->y != TIMELIB_UNSET && s->time->m != TIMELIB_UNSET &&
		s->time->d != TIMELIB_UNSET &&
		!timelib_valid_date( s->time->y, s->time->m, s->time->d)) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid", string, ptr);
	}

	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options & TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->us = 0;
	}
	if (
		parsed->y != TIMELIB_UNSET || parsed->m != TIMELIB_UNSET || parsed->d != TIMELIB_UNSET ||
		parsed->h != TIMELIB_UNSET || parsed->i != TIMELIB_UNSET || parsed->s != TIMELIB_UNSET
	) {
		if (parsed->us == TIMELIB_UNSET) parsed->us = 0;
	} else {
		if (parsed->us == TIMELIB_UNSET) parsed->us = now->us != TIMELIB_UNSET ? now->us : 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;

	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? (!(options & TIMELIB_NO_CLONE) ? timelib_tzinfo_clone(now->tz_info) : now->tz_info) : NULL;

		if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
		if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

		if (!parsed->tz_abbr) {
			parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
		}
	}

	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

const char *timelib_timezone_id_from_abbr(const char *abbr, timelib_long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = abbr_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS",
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;
}
#endif

/*
 * vim: syntax=c
 */
