package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRemind invokes the dataworks_public.DeleteRemind API synchronously
func (client *Client) DeleteRemind(request *DeleteRemindRequest) (response *DeleteRemindResponse, err error) {
	response = CreateDeleteRemindResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRemindWithChan invokes the dataworks_public.DeleteRemind API asynchronously
func (client *Client) DeleteRemindWithChan(request *DeleteRemindRequest) (<-chan *DeleteRemindResponse, <-chan error) {
	responseChan := make(chan *DeleteRemindResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRemind(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRemindWithCallback invokes the dataworks_public.DeleteRemind API asynchronously
func (client *Client) DeleteRemindWithCallback(request *DeleteRemindRequest, callback func(response *DeleteRemindResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRemindResponse
		var err error
		defer close(result)
		response, err = client.DeleteRemind(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRemindRequest is the request struct for api DeleteRemind
type DeleteRemindRequest struct {
	*requests.RpcRequest
	RemindId requests.Integer `position:"Body" name:"RemindId"`
}

// DeleteRemindResponse is the response struct for api DeleteRemind
type DeleteRemindResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           bool   `json:"Data" xml:"Data"`
}

// CreateDeleteRemindRequest creates a request to invoke DeleteRemind API
func CreateDeleteRemindRequest() (request *DeleteRemindRequest) {
	request = &DeleteRemindRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DeleteRemind", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteRemindResponse creates a response to parse from DeleteRemind response
func CreateDeleteRemindResponse() (response *DeleteRemindResponse) {
	response = &DeleteRemindResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
