package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryNumberGroupDetail invokes the cloudcallcenter.QueryNumberGroupDetail API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/querynumbergroupdetail.html
func (client *Client) QueryNumberGroupDetail(request *QueryNumberGroupDetailRequest) (response *QueryNumberGroupDetailResponse, err error) {
	response = CreateQueryNumberGroupDetailResponse()
	err = client.DoAction(request, response)
	return
}

// QueryNumberGroupDetailWithChan invokes the cloudcallcenter.QueryNumberGroupDetail API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/querynumbergroupdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryNumberGroupDetailWithChan(request *QueryNumberGroupDetailRequest) (<-chan *QueryNumberGroupDetailResponse, <-chan error) {
	responseChan := make(chan *QueryNumberGroupDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryNumberGroupDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryNumberGroupDetailWithCallback invokes the cloudcallcenter.QueryNumberGroupDetail API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/querynumbergroupdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryNumberGroupDetailWithCallback(request *QueryNumberGroupDetailRequest, callback func(response *QueryNumberGroupDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryNumberGroupDetailResponse
		var err error
		defer close(result)
		response, err = client.QueryNumberGroupDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryNumberGroupDetailRequest is the request struct for api QueryNumberGroupDetail
type QueryNumberGroupDetailRequest struct {
	*requests.RpcRequest
	NumberGroupId string `position:"Query" name:"NumberGroupId"`
}

// QueryNumberGroupDetailResponse is the response struct for api QueryNumberGroupDetail
type QueryNumberGroupDetailResponse struct {
	*responses.BaseResponse
	RequestId      string                              `json:"RequestId" xml:"RequestId"`
	Success        bool                                `json:"Success" xml:"Success"`
	Code           string                              `json:"Code" xml:"Code"`
	Message        string                              `json:"Message" xml:"Message"`
	HttpStatusCode int                                 `json:"HttpStatusCode" xml:"HttpStatusCode"`
	NumberGroup    NumberGroupInQueryNumberGroupDetail `json:"NumberGroup" xml:"NumberGroup"`
}

// CreateQueryNumberGroupDetailRequest creates a request to invoke QueryNumberGroupDetail API
func CreateQueryNumberGroupDetailRequest() (request *QueryNumberGroupDetailRequest) {
	request = &QueryNumberGroupDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "QueryNumberGroupDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryNumberGroupDetailResponse creates a response to parse from QueryNumberGroupDetail response
func CreateQueryNumberGroupDetailResponse() (response *QueryNumberGroupDetailResponse) {
	response = &QueryNumberGroupDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
