/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import com.intellij.openapi.util.io.NioFiles;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.inspections.metrics.database.Metrics_sql_statementsKt;
import org.jetbrains.qodana.staticAnalysis.inspections.metrics.database.rowData.MetricTableRowData;
import org.jetbrains.qodana.staticAnalysis.inspections.metrics.database.rowData.MetricTableRowDataKt;
import org.jetbrains.qodana.staticAnalysis.inspections.metrics.database.tables.MetricTable;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.ToolResultRecord;
import org.jetbrains.sqlite.Binder;
import org.jetbrains.sqlite.EmptyBinder;
import org.jetbrains.sqlite.ObjectBinder;
import org.jetbrains.sqlite.SqliteConnection;
import org.jetbrains.sqlite.SqlitePreparedStatement;
import org.jetbrains.sqlite.SqliteResultSet;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 '2\u00060\u0001j\u0002`\u0002:\u0004'()*B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nJ6\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u0018\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u0011J\u0016\u0010#\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010$\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010%\u001a\u00020\u001eJ\t\u0010&\u001a\u00020\bH\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaToolResultDatabase;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "connection", "Lorg/jetbrains/sqlite/SqliteConnection;", "<init>", "(Lorg/jetbrains/sqlite/SqliteConnection;)V", "insert", "", "inspectionGroup", "", "inspectionId", "hash", "json", "insertDuplicate", "file", "line", "", "start", "end", "insertMetricsData", "rowData", "Lorg/jetbrains/qodana/staticAnalysis/inspections/metrics/database/rowData/MetricTableRowData;", "deleteMetricsDataForFile", "filePath", "metricTable", "Lorg/jetbrains/qodana/staticAnalysis/inspections/metrics/database/tables/MetricTable;", "select", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaToolResultDatabase$ToolResultsClosableQuery;", "selectDuplicate", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaToolResultDatabase$StringColumnClosableQuery;", "getResultsFromMetricsTable", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaToolResultDatabase$MetricColumnClosableQuery;", "query", "numberOfColumns", "insertRelatedProblem", "selectRelatedProblems", "selectTriggeredInspectionIds", "close", "Companion", "MetricColumnClosableQuery", "StringColumnClosableQuery", "ToolResultsClosableQuery", "intellij.qodana"})
public final class QodanaToolResultDatabase
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SqliteConnection connection;

    private QodanaToolResultDatabase(SqliteConnection connection) {
        this.connection = connection;
    }

    public final void insert(@NotNull String inspectionGroup, @NotNull String inspectionId, @NotNull String hash2, @NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)inspectionGroup, (String)"inspectionGroup");
        Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
        Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String[] stringArray = new String[]{inspectionGroup, inspectionId, hash2, json};
        this.connection.execute("INSERT INTO results VALUES (?, ?, ?, ?);", (Object)stringArray);
    }

    public final void insertDuplicate(@NotNull String file2, int line, int start2, int end, @NotNull String hash2, @NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Object[] objectArray = new Object[]{file2, line, start2, end, hash2, json};
        this.connection.execute("INSERT INTO duplicates VALUES (?, ?, ?, ?, ?, ?);", (Object)objectArray);
    }

    public final void insertMetricsData(@NotNull MetricTableRowData rowData) {
        Intrinsics.checkNotNullParameter((Object)rowData, (String)"rowData");
        MetricTable metricTable = rowData.getMetricTable();
        String insertStatement = Metrics_sql_statementsKt.getInsertStatement(metricTable);
        this.connection.execute(insertStatement, (Object)MetricTableRowDataKt.getValues(rowData));
    }

    public final void deleteMetricsDataForFile(@NotNull String filePath, @NotNull MetricTable metricTable) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)metricTable, (String)"metricTable");
        String deleteStatement = Metrics_sql_statementsKt.getDeleteStatementForFile(metricTable);
        String[] stringArray = new String[]{filePath};
        this.connection.execute(deleteStatement, (Object)stringArray);
    }

    @NotNull
    public final ToolResultsClosableQuery select(@NotNull String inspectionGroup) {
        Intrinsics.checkNotNullParameter((Object)inspectionGroup, (String)"inspectionGroup");
        ObjectBinder binder = new ObjectBinder(1, 0, 2, null);
        SqlitePreparedStatement statement = this.connection.prepareStatement("SELECT inspection, hash, json FROM results WHERE inspectionGroup = ? ORDER BY inspection, hash;", (Binder)binder);
        binder.bind((Object)inspectionGroup);
        return new ToolResultsClosableQuery(statement);
    }

    @NotNull
    public final StringColumnClosableQuery selectDuplicate(@NotNull String file2, int line, int start2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ObjectBinder binder = new ObjectBinder(3, 0, 2, null);
        SqlitePreparedStatement statement = this.connection.prepareStatement("SELECT json FROM duplicates WHERE file = ? AND line = ? AND start = ? ORDER BY hash;", (Binder)binder);
        Object[] objectArray = new Object[]{file2, line, start2};
        binder.bindMultiple(objectArray);
        return new StringColumnClosableQuery(statement);
    }

    @NotNull
    public final MetricColumnClosableQuery getResultsFromMetricsTable(@Language(value="SQLite") @NotNull String query, int numberOfColumns) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        SqlitePreparedStatement statement = this.connection.prepareStatement(query, (Binder)EmptyBinder.INSTANCE);
        return new MetricColumnClosableQuery(statement, numberOfColumns);
    }

    public final void insertRelatedProblem(@NotNull String hash2, @NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String[] stringArray = new String[]{hash2, json};
        this.connection.execute("INSERT INTO related_problem VALUES (?, ?);", (Object)stringArray);
    }

    @NotNull
    public final StringColumnClosableQuery selectRelatedProblems(@NotNull String hash2) {
        Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
        ObjectBinder binder = new ObjectBinder(1, 0, 2, null);
        SqlitePreparedStatement statement = this.connection.prepareStatement("SELECT json FROM related_problem WHERE hash = ?;", (Binder)binder);
        Object[] objectArray = new Object[]{hash2};
        binder.bindMultiple(objectArray);
        return new StringColumnClosableQuery(statement);
    }

    @NotNull
    public final StringColumnClosableQuery selectTriggeredInspectionIds() {
        return new StringColumnClosableQuery(this.connection.prepareStatement("SELECT DISTINCT inspection FROM results;", (Binder)EmptyBinder.INSTANCE));
    }

    @Override
    public void close() {
        this.connection.close();
    }

    public /* synthetic */ QodanaToolResultDatabase(SqliteConnection connection, DefaultConstructorMarker $constructor_marker) {
        this(connection);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaToolResultDatabase$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaToolResultDatabase;", "path", "Ljava/nio/file/Path;", "open", "intellij.qodana"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QodanaToolResultDatabase create(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            NioFiles.deleteRecursively((Path)path.resolve("tool-results.db"));
            QodanaToolResultDatabase db = this.open(path);
            db.connection.execute("\n  BEGIN TRANSACTION;\n\n  CREATE TABLE results (\n    inspectionGroup TEXT,\n    inspection TEXT,\n    hash TEXT,\n    json TEXT\n  );\n  \n  CREATE INDEX idx_results_inspection_hash ON results (inspection, hash);\n  \n  CREATE TABLE duplicates (\n    file TEXT,\n    line INT,\n    start INT,\n    end INT,\n    hash TEXT,\n    json TEXT\n  );\n  \n  CREATE INDEX idx_duplicates_location ON duplicates (file, line, start, end);\n  \n  CREATE TABLE related_problem (\n    hash TEXT,\n    json TEXT\n  );\n  \n  CREATE INDEX idx_related_problem_hash ON related_problem (hash);\n  \n  COMMIT;\n");
            String createMetricsTableSchema = Metrics_sql_statementsKt.getSchemaForAllTables(MetricTable.Companion);
            db.connection.execute(createMetricsTableSchema);
            return db;
        }

        @NotNull
        public final QodanaToolResultDatabase open(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new QodanaToolResultDatabase(new SqliteConnection(path.resolve("tool-results.db"), false, 2, null), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u001d\b\u0000\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaToolResultDatabase$MetricColumnClosableQuery;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "statement", "Lorg/jetbrains/sqlite/SqlitePreparedStatement;", "numberOfColumns", "", "<init>", "(Lorg/jetbrains/sqlite/SqlitePreparedStatement;I)V", "executeQuery", "Lkotlin/sequences/Sequence;", "", "", "close", "", "intellij.qodana"})
    public static final class MetricColumnClosableQuery
    implements AutoCloseable {
        @NotNull
        private final SqlitePreparedStatement<?> statement;
        private final int numberOfColumns;

        public MetricColumnClosableQuery(@NotNull SqlitePreparedStatement<?> statement, int numberOfColumns) {
            Intrinsics.checkNotNullParameter(statement, (String)"statement");
            this.statement = statement;
            this.numberOfColumns = numberOfColumns;
        }

        @NotNull
        public final Sequence<String[]> executeQuery() {
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String[]>, Continuation<? super Unit>, Object>(this, null){
                Object L$1;
                Object L$2;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ MetricColumnClosableQuery this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (SequenceScope)this.L$0;
                    var9_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            resultSet = MetricColumnClosableQuery.access$getStatement$p(this.this$0).executeQuery();
lbl7:
                            // 5 sources

                            while (resultSet.next()) {
                                var5_7 = 0;
                                var6_8 = MetricColumnClosableQuery.access$getNumberOfColumns$p(this.this$0);
                                var7_9 = new String[var6_8];
                                while (var5_7 < var6_8) {
                                    var8_10 = var5_7++;
                                    Intrinsics.checkNotNull((Object)resultSet.getString(var8_10));
                                }
                                values = var7_9;
                                this.L$0 = $this$sequence;
                                this.L$1 = resultSet;
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)values);
                                this.label = 1;
                                v0 = $this$sequence.yield((Object)values, (Continuation)this);
                                if (v0 != var9_3) continue;
                                return var9_3;
                            }
                            break;
                        }
                        case 1: {
                            values = (String[])this.L$2;
                            resultSet = (SqliteResultSet)this.L$1;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                ** GOTO lbl7
                            }
                            catch (Exception e) {
                                this.L$0 = $this$sequence;
                                this.L$1 = resultSet;
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)e);
                                this.label = 2;
                                v1 = $this$sequence.yield((Object)new String[0], (Continuation)this);
                                if (v1 != var9_3) ** GOTO lbl7
                                return var9_3;
                            }
                        }
                        case 2: {
                            e = (Exception)this.L$2;
                            resultSet = (SqliteResultSet)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            ** GOTO lbl7
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                public final Object invoke(SequenceScope<? super String[]> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        @Override
        public void close() {
            this.statement.close();
        }

        public static final /* synthetic */ SqlitePreparedStatement access$getStatement$p(MetricColumnClosableQuery $this) {
            return $this.statement;
        }

        public static final /* synthetic */ int access$getNumberOfColumns$p(MetricColumnClosableQuery $this) {
            return $this.numberOfColumns;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\b\u0000\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\b\u0010\n\u001a\u00020\u000bH\u0016R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaToolResultDatabase$StringColumnClosableQuery;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "statement", "Lorg/jetbrains/sqlite/SqlitePreparedStatement;", "<init>", "(Lorg/jetbrains/sqlite/SqlitePreparedStatement;)V", "executeQuery", "Lkotlin/sequences/Sequence;", "", "close", "", "intellij.qodana"})
    public static final class StringColumnClosableQuery
    implements AutoCloseable {
        @NotNull
        private final SqlitePreparedStatement<?> statement;

        public StringColumnClosableQuery(@NotNull SqlitePreparedStatement<?> statement) {
            Intrinsics.checkNotNullParameter(statement, (String)"statement");
            this.statement = statement;
        }

        @NotNull
        public final Sequence<String> executeQuery() {
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(this, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ StringColumnClosableQuery this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (SequenceScope)this.L$0;
                    var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            resultSet = StringColumnClosableQuery.access$getStatement$p(this.this$0).executeQuery();
lbl7:
                            // 3 sources

                            while (resultSet.next()) {
                                v0 = resultSet.getString(0);
                                Intrinsics.checkNotNull((Object)v0);
                                this.L$0 = $this$sequence;
                                this.L$1 = resultSet;
                                this.label = 1;
                                v1 = $this$sequence.yield((Object)v0, (Continuation)this);
                                if (v1 != var4_3) continue;
                                return var4_3;
                            }
                            break;
                        }
                        case 1: {
                            resultSet = (SqliteResultSet)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            ** GOTO lbl7
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                public final Object invoke(SequenceScope<? super String> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        @Override
        public void close() {
            this.statement.close();
        }

        public static final /* synthetic */ SqlitePreparedStatement access$getStatement$p(StringColumnClosableQuery $this) {
            return $this.statement;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\b\u0000\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\b\u0010\n\u001a\u00020\u000bH\u0016R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaToolResultDatabase$ToolResultsClosableQuery;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "statement", "Lorg/jetbrains/sqlite/SqlitePreparedStatement;", "<init>", "(Lorg/jetbrains/sqlite/SqlitePreparedStatement;)V", "executeQuery", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/ToolResultRecord;", "close", "", "intellij.qodana"})
    public static final class ToolResultsClosableQuery
    implements AutoCloseable {
        @NotNull
        private final SqlitePreparedStatement<?> statement;

        public ToolResultsClosableQuery(@NotNull SqlitePreparedStatement<?> statement) {
            Intrinsics.checkNotNullParameter(statement, (String)"statement");
            this.statement = statement;
        }

        @NotNull
        public final Sequence<ToolResultRecord> executeQuery() {
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super ToolResultRecord>, Continuation<? super Unit>, Object>(this, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ ToolResultsClosableQuery this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (SequenceScope)this.L$0;
                    var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            resultSet = ToolResultsClosableQuery.access$getStatement$p(this.this$0).executeQuery();
lbl7:
                            // 3 sources

                            while (resultSet.next()) {
                                v0 = resultSet.getString(0);
                                Intrinsics.checkNotNull((Object)v0);
                                v1 = resultSet.getString(1);
                                Intrinsics.checkNotNull((Object)v1);
                                v2 = resultSet.getString(2);
                                Intrinsics.checkNotNull((Object)v2);
                                this.L$0 = $this$sequence;
                                this.L$1 = resultSet;
                                this.label = 1;
                                v3 = $this$sequence.yield((Object)new ToolResultRecord(v0, v1, v2), (Continuation)this);
                                if (v3 != var4_3) continue;
                                return var4_3;
                            }
                            break;
                        }
                        case 1: {
                            resultSet = (SqliteResultSet)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
                            ** GOTO lbl7
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                public final Object invoke(SequenceScope<? super ToolResultRecord> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        @Override
        public void close() {
            this.statement.close();
        }

        public static final /* synthetic */ SqlitePreparedStatement access$getStatement$p(ToolResultsClosableQuery $this) {
            return $this.statement;
        }
    }
}

