/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.model.data;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseDataSource;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseMapType;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.data.AbstractDatabaseList;
import org.jkiss.dbeaver.model.impl.struct.AbstractAttribute;
import org.jkiss.dbeaver.model.impl.struct.AbstractStructDataType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class ClickhouseMapValue
extends AbstractDatabaseList {
    private final ClickhouseDataSource dataSource;
    private final ClickhouseMapType mapType;
    private final EntryType entryType;
    private final EntryAttribute[] attributes;
    private List<EntryComposite> contents;
    private boolean modified;

    public ClickhouseMapValue(@NotNull ClickhouseDataSource dataSource, @NotNull ClickhouseMapType type, @NotNull Map<?, ?> contents) {
        this.dataSource = dataSource;
        this.mapType = type;
        this.entryType = new EntryType(dataSource);
        this.attributes = new EntryAttribute[]{new EntryAttribute(this.entryType, "Key", type.getKeyType(), 0), new EntryAttribute(this.entryType, "Value", type.getValueType(), 1)};
        this.contents = contents.entrySet().stream().map(entry -> new EntryComposite(entry.getKey(), entry.getValue())).collect(Collectors.toList());
    }

    @NotNull
    public DBSDataType getComponentType() {
        return this.entryType;
    }

    @NotNull
    public DBDValueHandler getComponentValueHandler() {
        return DBUtils.findValueHandler((DBPDataSource)this.dataSource, (DBSTypedObject)this.entryType);
    }

    public int getItemCount() {
        return this.contents != null ? this.contents.size() : 0;
    }

    public Object getItem(int index) {
        return this.contents.get(index);
    }

    public void setItem(int index, Object value) {
        this.contents.set(index, (EntryComposite)value);
        this.modified = true;
    }

    public void setContents(Object[] contents) {
        this.contents.clear();
        this.modified = true;
        Object[] objectArray = contents;
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            Object content = objectArray[n2];
            this.contents.add((EntryComposite)content);
            ++n2;
        }
    }

    public Object getRawValue() {
        return this.contents;
    }

    public boolean isNull() {
        return this.contents == null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void release() {
        this.contents = null;
    }

    public String toString() {
        return this.contents.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    private static class EntryAttribute
    extends AbstractAttribute
    implements DBSEntityAttribute {
        private final EntryType parent;
        private final DBSDataType type;

        public EntryAttribute(@NotNull EntryType parent, @NotNull String name, @NotNull DBSDataType type, int position) {
            super(name, type.getFullTypeName(), type.getTypeID(), position, 0L, null, null, true, false);
            this.parent = parent;
            this.type = type;
        }

        @Nullable
        public String getDefaultValue() {
            return null;
        }

        @NotNull
        public DBSEntity getParentObject() {
            return this.parent;
        }

        public DBPDataSource getDataSource() {
            return this.parent.getDataSource();
        }

        @NotNull
        public DBPDataKind getDataKind() {
            return this.type.getDataKind();
        }
    }

    private class EntryComposite
    implements DBDComposite {
        private final Object key;
        private Object value;

        public EntryComposite(@Nullable Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public DBSDataType getDataType() {
            return ClickhouseMapValue.this.entryType;
        }

        @NotNull
        public DBSAttributeBase[] getAttributes() {
            return ClickhouseMapValue.this.attributes;
        }

        @Nullable
        public Object getAttributeValue(@NotNull DBSAttributeBase attribute) {
            if (attribute.getOrdinalPosition() == 0) {
                return this.key;
            }
            return this.value;
        }

        public void setAttributeValue(@NotNull DBSAttributeBase attribute, @Nullable Object value) throws DBCException {
            if (attribute.getOrdinalPosition() == 0) {
                throw new DBCException("Key is read-only");
            }
            this.value = value;
            ClickhouseMapValue.this.modified = true;
        }

        public Object getRawValue() {
            return this.value;
        }

        public boolean isNull() {
            return false;
        }

        public boolean isModified() {
            return ClickhouseMapValue.this.modified;
        }

        public void release() {
        }

        public String toString() {
            return String.format("{%s : %s}", this.key, this.value);
        }
    }

    private class EntryType
    extends AbstractStructDataType<ClickhouseDataSource>
    implements DBSEntity {
        public EntryType(ClickhouseDataSource dataSource) {
            super((DBPDataSource)dataSource);
        }

        @NotNull
        public String getTypeName() {
            return ClickhouseMapValue.this.mapType.getFullTypeName();
        }

        public int getTypeID() {
            return ClickhouseMapValue.this.mapType.getTypeID();
        }

        @NotNull
        public DBPDataKind getDataKind() {
            return DBPDataKind.STRUCT;
        }

        @NotNull
        public DBSEntityType getEntityType() {
            return DBSEntityType.VIRTUAL_ENTITY;
        }

        @Nullable
        public List<? extends DBSEntityAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
            return List.of();
        }
    }
}

