// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"

namespace Rivet {


  /// @brief R measurement
  class CRYSTAL_BALL_1990_I294419 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(CRYSTAL_BALL_1990_I294419);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      // Initialise and register projections
      declare(FinalState(), "FS");

      // Book histograms
      for (size_t ix=0; ix<2; ++ix) {
        book(_c_hadrons[ix], "/TMP/sigma_hadrons_"+toString(ix+1), refData<YODA::BinnedEstimate<string>>(1+ix,1,1));
        book(_c_muons[ix],   "/TMP/sigma_muons_" +toString(ix+1), refData<YODA::BinnedEstimate<string>>(1+ix,1,1));
        for (const string& en : _c_hadrons[ix].binning().edges<0>()) {
          double eval = stod(en)*GeV;
          if (isCompatibleWithSqrtS(eval)) {
            _sqs[ix] = en; break;
          }
        }
      }
      raiseBeamErrorIf(_sqs[0].empty() && _sqs[1].empty());
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");

      map<long,int> nCount;
      int ntotal(0);
      for (const Particle& p : fs.particles()) {
        nCount[p.pid()] += 1;
        ++ntotal;
      }
      if (nCount[-13]==1 && nCount[13]==1 && ntotal==2+nCount[22]) {
        // mu+mu- + photons
        _c_muons[0]->fill(_sqs[0]);
        _c_muons[1]->fill(_sqs[1]);
      }
      else {
        // everything else
        _c_hadrons[0]->fill(_sqs[0]);
        _c_hadrons[1]->fill(_sqs[1]);
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      for (size_t ix=-0; ix<2; ++ix) {
        BinnedEstimatePtr<string> mult;
        book(mult, 1+ix, 1, 1);
        divide(_c_hadrons[ix], _c_muons[ix], mult);
      }
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string> _c_hadrons[2], _c_muons[2];
    string _sqs[2];
    /// @}

  };

  RIVET_DECLARE_PLUGIN(CRYSTAL_BALL_1990_I294419);
}
