// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"


namespace Rivet {


  /// @brief e+e- -> pi0 gamma
  class SND_2016_I1418483 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(SND_2016_I1418483);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      declare(FinalState(), "FS");
      book(_numPi0Gamma, 1, 1, 5);
      for (const string& en : _numPi0Gamma.binning().edges<0>()) {
        const size_t idx = en.find("-");
        if (idx != string::npos) {
          const double emin = stod(en.substr(0,idx));
          const double emax = stod(en.substr(idx+1,string::npos));
          if (inRange(sqrtS()/MeV, emin, emax)) {
            _sqs = en; break;
          }
        }
        else {
          const double eval = stod(en)*MeV;
          if (isCompatibleWithSqrtS(eval)) {
            _sqs = en; break;
          }
        }
      }
      raiseBeamErrorIf(_sqs.empty());
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {

      const FinalState& fs = apply<FinalState>(event, "FS");

      map<long,int> nCount;
      int ntotal(0);
      for (const Particle& p : fs.particles()) {
        nCount[p.pid()] += 1;
        ++ntotal;
      }
      if (ntotal==2 && nCount[22]==1 && nCount[111]==1) {
        _numPi0Gamma->fill(_sqs);
      }

    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_numPi0Gamma, crossSection()/sumOfWeights()/nanobarn);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string> _numPi0Gamma;
    string _sqs = "";
    /// @}


  };


  RIVET_DECLARE_PLUGIN(SND_2016_I1418483);


}
