// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p><code>PutRecords</code> results.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct PutRecordsOutput {
    /// <p>The number of unsuccessfully processed records in a <code>PutRecords</code> request.</p>
    pub failed_record_count: ::std::option::Option<i32>,
    /// <p>An array of successfully and unsuccessfully processed record results. A record that is successfully added to a stream includes <code>SequenceNumber</code> and <code>ShardId</code> in the result. A record that fails to be added to a stream includes <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.</p>
    pub records: ::std::vec::Vec<crate::types::PutRecordsResultEntry>,
    /// <p>The encryption type used on the records. This parameter can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p><code>NONE</code>: Do not encrypt the records.</p></li>
    /// <li>
    /// <p><code>KMS</code>: Use server-side encryption on the records using a customer-managed Amazon Web Services KMS key.</p></li>
    /// </ul>
    pub encryption_type: ::std::option::Option<crate::types::EncryptionType>,
    _request_id: Option<String>,
}
impl PutRecordsOutput {
    /// <p>The number of unsuccessfully processed records in a <code>PutRecords</code> request.</p>
    pub fn failed_record_count(&self) -> ::std::option::Option<i32> {
        self.failed_record_count
    }
    /// <p>An array of successfully and unsuccessfully processed record results. A record that is successfully added to a stream includes <code>SequenceNumber</code> and <code>ShardId</code> in the result. A record that fails to be added to a stream includes <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.</p>
    pub fn records(&self) -> &[crate::types::PutRecordsResultEntry] {
        use std::ops::Deref;
        self.records.deref()
    }
    /// <p>The encryption type used on the records. This parameter can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p><code>NONE</code>: Do not encrypt the records.</p></li>
    /// <li>
    /// <p><code>KMS</code>: Use server-side encryption on the records using a customer-managed Amazon Web Services KMS key.</p></li>
    /// </ul>
    pub fn encryption_type(&self) -> ::std::option::Option<&crate::types::EncryptionType> {
        self.encryption_type.as_ref()
    }
}
impl ::aws_types::request_id::RequestId for PutRecordsOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl PutRecordsOutput {
    /// Creates a new builder-style object to manufacture [`PutRecordsOutput`](crate::operation::put_records::PutRecordsOutput).
    pub fn builder() -> crate::operation::put_records::builders::PutRecordsOutputBuilder {
        crate::operation::put_records::builders::PutRecordsOutputBuilder::default()
    }
}

/// A builder for [`PutRecordsOutput`](crate::operation::put_records::PutRecordsOutput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct PutRecordsOutputBuilder {
    pub(crate) failed_record_count: ::std::option::Option<i32>,
    pub(crate) records: ::std::option::Option<::std::vec::Vec<crate::types::PutRecordsResultEntry>>,
    pub(crate) encryption_type: ::std::option::Option<crate::types::EncryptionType>,
    _request_id: Option<String>,
}
impl PutRecordsOutputBuilder {
    /// <p>The number of unsuccessfully processed records in a <code>PutRecords</code> request.</p>
    pub fn failed_record_count(mut self, input: i32) -> Self {
        self.failed_record_count = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of unsuccessfully processed records in a <code>PutRecords</code> request.</p>
    pub fn set_failed_record_count(mut self, input: ::std::option::Option<i32>) -> Self {
        self.failed_record_count = input;
        self
    }
    /// <p>The number of unsuccessfully processed records in a <code>PutRecords</code> request.</p>
    pub fn get_failed_record_count(&self) -> &::std::option::Option<i32> {
        &self.failed_record_count
    }
    /// Appends an item to `records`.
    ///
    /// To override the contents of this collection use [`set_records`](Self::set_records).
    ///
    /// <p>An array of successfully and unsuccessfully processed record results. A record that is successfully added to a stream includes <code>SequenceNumber</code> and <code>ShardId</code> in the result. A record that fails to be added to a stream includes <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.</p>
    pub fn records(mut self, input: crate::types::PutRecordsResultEntry) -> Self {
        let mut v = self.records.unwrap_or_default();
        v.push(input);
        self.records = ::std::option::Option::Some(v);
        self
    }
    /// <p>An array of successfully and unsuccessfully processed record results. A record that is successfully added to a stream includes <code>SequenceNumber</code> and <code>ShardId</code> in the result. A record that fails to be added to a stream includes <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.</p>
    pub fn set_records(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::PutRecordsResultEntry>>) -> Self {
        self.records = input;
        self
    }
    /// <p>An array of successfully and unsuccessfully processed record results. A record that is successfully added to a stream includes <code>SequenceNumber</code> and <code>ShardId</code> in the result. A record that fails to be added to a stream includes <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.</p>
    pub fn get_records(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::PutRecordsResultEntry>> {
        &self.records
    }
    /// <p>The encryption type used on the records. This parameter can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p><code>NONE</code>: Do not encrypt the records.</p></li>
    /// <li>
    /// <p><code>KMS</code>: Use server-side encryption on the records using a customer-managed Amazon Web Services KMS key.</p></li>
    /// </ul>
    pub fn encryption_type(mut self, input: crate::types::EncryptionType) -> Self {
        self.encryption_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The encryption type used on the records. This parameter can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p><code>NONE</code>: Do not encrypt the records.</p></li>
    /// <li>
    /// <p><code>KMS</code>: Use server-side encryption on the records using a customer-managed Amazon Web Services KMS key.</p></li>
    /// </ul>
    pub fn set_encryption_type(mut self, input: ::std::option::Option<crate::types::EncryptionType>) -> Self {
        self.encryption_type = input;
        self
    }
    /// <p>The encryption type used on the records. This parameter can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p><code>NONE</code>: Do not encrypt the records.</p></li>
    /// <li>
    /// <p><code>KMS</code>: Use server-side encryption on the records using a customer-managed Amazon Web Services KMS key.</p></li>
    /// </ul>
    pub fn get_encryption_type(&self) -> &::std::option::Option<crate::types::EncryptionType> {
        &self.encryption_type
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`PutRecordsOutput`](crate::operation::put_records::PutRecordsOutput).
    /// This method will fail if any of the following fields are not set:
    /// - [`records`](crate::operation::put_records::builders::PutRecordsOutputBuilder::records)
    pub fn build(self) -> ::std::result::Result<crate::operation::put_records::PutRecordsOutput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::put_records::PutRecordsOutput {
            failed_record_count: self.failed_record_count,
            records: self.records.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "records",
                    "records was not specified but it is required when building PutRecordsOutput",
                )
            })?,
            encryption_type: self.encryption_type,
            _request_id: self._request_id,
        })
    }
}
