# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::RU;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20250323211835;

my $formatters = [
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '[0-79]',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                [0-356]2|
                4[29]|
                7|
                8[27]
              )|
              2(?:
                13[03-69]|
                62[013-9]
              )
            )|
            72[1-57-9]2
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                0(?:
                  [356]|
                  4[023]
                )|
                [18]|
                2(?:
                  3[013-9]|
                  5
                )|
                3[45]|
                43[013-79]|
                5(?:
                  3[1-8]|
                  4[1-7]|
                  5
                )|
                6(?:
                  3[0-35-9]|
                  [4-6]
                )
              )|
              2(?:
                1(?:
                  3[178]|
                  [45]
                )|
                [24-689]|
                3[35]|
                7[457]
              )
            )|
            7(?:
              14|
              23
            )4[0-8]|
            71(?:
              33|
              45
            )[1-79]
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{5})(\\d)(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3-$4',
                  'leading_digits' => '
            [349]|
            8(?:
              [02-7]|
              1[1-8]
            )
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '8',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15]|
              6[1-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'geographic' => '
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15]|
              6[1-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'mobile' => '9\\d{9}',
                'pager' => '',
                'personal_number' => '808\\d{7}',
                'specialrate' => '(80[39]\\d{7})',
                'toll_free' => '
          8(?:
            0[04]|
            108\\d{3}
          )\\d{7}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"77292", "Aktau",
"7421", "Khabarovsk\ Territory",
"7481", "Smolensk",
"771235", "Dossor",
"7866", "Kabardino\-Balkarian\ Republic",
"77222", "Semey",
"772778", "Chundzha",
"772154", "Botakara",
"7346", "Surgut",
"771649", "Zhaksynsky\ District",
"771639", "Stepnyak",
"772631", "Kulan",
"772641", "Akkol",
"771636", "Shuchinsk",
"771646", "Makinsk",
"772256", "Kainar",
"772777", "Kegen",
"772343", "Terekty",
"772333", "Samarskoye",
"772340", "Zaisan",
"772432", "Shiyeli",
"772330", "Zyryanovsky\ District",
"77112", "Uralsk",
"772644", "Karatau",
"772634", "Zhanatas",
"7495", "Moscow",
"772438", "Aiteke\ bi",
"772153", "Topar",
"7343", "Ekaterinburg",
"7382", "Tomsk",
"7821", "Komi\ Republic",
"7863", "Rostov",
"772640", "Moiynkumsky\ District",
"772633", "Asa",
"772643", "Shu",
"772334", "Tavricheskoye",
"772344", "Akzhar",
"7812", "St\ Petersburg",
"77213", "Aktau\/Temirtau",
"772341", "Ulken\ Naryn",
"772331", "Glubokoye",
"772437", "Zhosaly",
"771339", "Komsomolskoye",
"771349", "Shalkarsky\ District",
"772772", "Kapchagai",
"771346", "Shubarkuduk",
"771336", "Khromtau",
"771454", "Karamendy",
"7347", "Republic\ of\ Bashkortostan",
"7871", "Chechen\ Republic",
"77185", "Shaldai",
"772932", "Beineu",
"772530", "Temirlanovka",
"7867", "Republic\ of\ North\ Ossetia",
"772540", "Arys",
"772533", "Turkestan",
"771451", "Sarykol",
"772543", "Aqsumbe",
"771435", "Zhitikara",
"77242", "Kyzylorda",
"771445", "Ubaganskoye",
"771132", "Fyodorovka",
"771142", "Taipak",
"7353", "Orenburg",
"771840", "Bayanaul",
"771833", "Terenkol",
"771035", "Ulytau",
"771843", "Maisky\ District",
"7496", "Moscow",
"7814", "Republic\ of\ Karelia",
"772544", "Shaulder",
"772534", "Zhetysai",
"7471", "Kursk",
"771536", "Taiynsha",
"771546", "Talshik",
"772237", "Ayagoz",
"771539", "Beskol",
"772531", "Aksukent",
"772541", "Myrzakent",
"771453", "Auliekol",
"771138", "Zhalpaktal",
"77279", "Almaty",
"772937", "Kuryk",
"772938", "Fort\ Shevchenko",
"7345", "Tyumen",
"771147", "Akzhaiksky\ District",
"771137", "Chingirlau",
"771844", "Irtyshsky\ District",
"771834", "Uspenka",
"7848", "Tolyatti",
"7865", "Stavropol\ territory",
"772839", "Sarkand",
"771831", "Zhelezinka",
"771841", "Aktogai",
"7384", "Kemerovo",
"772836", "Karabulak",
"772637", "Sarykemer",
"772774", "Talgar",
"772835", "Tekeli",
"77182", "Pavlodar",
"7492", "Vladimir",
"7415", "Kamchatka\ Region",
"772771", "Kaskelen",
"772725", "Otegen\ Batyra",
"772433", "Aralsk",
"772332", "Shemonaikha",
"7499", "Moscow",
"772342", "Katon\-Karagai",
"771535", "Novoishimski",
"771545", "Zhambylsky\ District",
"77252", "Shymkent",
"7817", "Vologda",
"7352", "Kurgan",
"77245", "Kyzylorda\ Region",
"772638", "Tole\ bi",
"7851", "Astrakhan",
"771039", "Priozersk",
"7815", "Murmansk",
"7391", "Krasnoyarsk\ Territory",
"771036", "Balkhash",
"77272", "Almaty",
"772642", "Moiynkum",
"772632", "Merke",
"772431", "Zhalagash",
"771449", "Taranovskoye",
"772347", "Kalbatau",
"772337", "Serebryansk",
"771439", "Torgai",
"771436", "Taranovskoye",
"772770", "Uzynagash",
"771446", "Uzunkolsky\ District",
"772773", "Bakanas",
"740", "Kaliningrad",
"736", "Simferopol",
"772348", "Kokpekty",
"772338", "Bozanbai\/Molodezhnyi",
"772759", "Almaty\ Region",
"7385", "Altai\ Territory",
"771143", "Akzhaik",
"7302", "Chita",
"771133", "Aksai",
"771140", "Saikhin",
"771130", "Peremetnoye",
"77232", "Ust\-Kamenogorsk",
"771345", "Karauylkeldy",
"771458", "Kostanai\ Region",
"771335", "Shalkar",
"77145834", "Krasnogorsk",
"771842", "Koktobe",
"771832", "Irtyshsk",
"7712302", "Tengizshevroil",
"7878", "Karachayevo\-Cherkessian\ Republic",
"772230", "Urdzhar",
"772542", "Asykata",
"771457", "Dzhangildinsky\ District",
"772532", "Abai",
"7413", "Magadan",
"7494", "Kostroma",
"7816", "Veliky\ Novgorod",
"772538", "Turara\ Ryskulova",
"772548", "Shayan",
"7841", "Penza",
"7349", "Yamalo\-Nenets\ Autonomous\ District",
"772146", "Karkaralinsk",
"771141", "Zhangala",
"7342", "Perm",
"771131", "Darinskoye",
"772149", "Osakarovka",
"771837", "Aksu",
"7869", "Sevastopol",
"7383", "Novosibirsk",
"771134", "Zhympity",
"771144", "Kaztalovka",
"7862", "Sochi",
"771635", "Zhaksy",
"771645", "Stepnogorsk",
"77262", "Taraz",
"771651", "Kabanbai\ Batyr",
"7416", "Amur\ Region",
"772934", "Zhanaozen",
"771838", "Koktobe",
"7813", "Leningrad\ region",
"7831", "Nizhni\ Novgorod",
"772931", "Shetpe",
"771236", "Makhambet",
"771452", "Karasu",
"772537", "Saryagash",
"772547", "Lenger",
"771239", "Makat",
"7484", "Kaluga",
"7424", "Sakhalin\ Region",
"771456", "Kachar",
"771533", "Saumalkol",
"771543", "Yavlenka",
"771459", "Kostanai\ Region",
"771540", "Kishkenekol",
"771232", "Atyrau\ Region",
"772132", "Nurinsky\ District",
"7879", "Mineranye\ Vody",
"772435", "Zhanakorgan",
"77142", "Kostanai",
"7872", "Republic\ of\ Daghestan",
"772833", "Usharal",
"77102", "Zhezkazgan",
"772843", "Lepsy",
"772830", "Alakolsky\ District",
"772840", "Saryozek",
"7847", "Republic\ of\ Kalmykia",
"771544", "Presnovka",
"771534", "Sergeyevka",
"7845", "Saratov",
"772148", "Molodezhnoye",
"772138", "Gabidena\ Mustafina",
"771531", "Bulayevo",
"771541", "Mamlutka",
"7820", "Cherepovets",
"771237", "Kulsary",
"772539", "Kazygurt",
"772536", "Kentau",
"772546", "Sholakkorgan",
"772775", "Esik",
"7835", "Chuvashi\ Republic",
"772834", "Ushtobe",
"771238", "Miyaly",
"772147", "Egindybulak",
"772137", "Saran",
"771836", "Sharbakty",
"772831", "Zharkent",
"772841", "Kapal",
"77187", "Ekibastuz",
"7472", "Belgorod",
"771839", "Akku",
"77122", "Atyrau",
"772159", "Karaganda\ Region",
"772156", "Shakhtinsk",
"7411", "Republic\ of\ Sakha",
"772935", "Zhetybai",
"7836", "Republic\ of\ Marij\ El",
"772752", "Otegen\ Batyra",
"7498", "Moscow",
"77135", "Aktobe\ Region",
"772636", "Kordai",
"771631", "Shortandy",
"771641", "Astrakhanka",
"772639", "Saudakent",
"7855", "Naberezhnye\ Chelny",
"771032", "Karazhal",
"771042", "Zharyk",
"7846", "Samara",
"771644", "Arshaly",
"77212", "Karaganda",
"771145", "Karatobe\ District",
"771135", "Zhanibek",
"771442", "Fyodorovka",
"771340", "Khobdinsky\ District",
"771330", "Khromtau\ District",
"771343", "Irgiz",
"772251", "Kurchatov",
"771333", "Kandyagash",
"7482", "Tver",
"771438", "Amangeldy",
"771448", "Oktyabrskoye",
"7833", "Kirov",
"77224", "Barshatas",
"7395", "Irkutsk",
"772757", "Akshi",
"7811", "Pskov",
"7474", "Lipetsk",
"771038", "Shashubai",
"771334", "Emba",
"771037", "Aktogai",
"771633", "Ereimentau",
"771643", "Atbasar",
"771630", "Burabay",
"771640", "Balkashino",
"7381", "Omsk",
"772346", "Aksuat",
"772336", "Ridder",
"771437", "Kamysty",
"772339", "Kurchum",
"771447", "Karabalyksky\ District",
"771341", "Khobda",
"771331", "Martuk",
"7843", "Republic\ of\ Tatarstan",
"77132", "Aktobe\/Kargalinskoye",
"772345", "Shar",
"772335", "Zyryanovsk",
"772842", "Kogaly",
"772832", "Zhansugurov",
"77125", "Atyrau\ Region",
"77272983", "Kaskelen",
"7712303", "Tengizs",
"7483", "Bryansk",
"7423", "Primorie\ territory",
"7717", "Astana",
"771233", "Ganyushkino",
"772351", "Borodulikha",
"7301", "Republic\ of\ Buryatia",
"771230", "Atyrau\ Region",
"771542", "Kishkenekol",
"771532", "Smirnovo",
"771139", "Taskala",
"771149", "Zelenovsky\ District",
"772131", "Abai",
"771146", "Akzhaiksky\ District",
"77106", "Satpaev",
"7390", "Republic\ of\ Khakassia",
"771136", "Chapayev",
"771538", "Beskol",
"772635", "Bauyrzhan\ Mamyshuly",
"77162", "Kokshetau\/Krasni\ Yar",
"772144", "Kiyevka",
"7394", "Republic\ of\ Tuva",
"772837", "Kabanbai",
"7475", "Tambov",
"771234", "Indernborski",
"772838", "Balpyk\ bi",
"7861", "Krasnodar\ Territory",
"7426", "Jewish\ Autonomous\ Region",
"7877", "Republic\ of\ Adygeya",
"7486", "Orel",
"771231", "Akkystau",
"772353", "Novaya\ Shulba",
"7341", "Udmurtian\ Republic",
"771537", "Timiryazevo",
"772239", "Makanchi",
"771547", "Zhambylsky\ District",
"772236", "Beskaragai",
"7842", "Ulyanovsk",
"771043", "Zhairem",
"771845", "Pavlodar\ Area",
"77282", "Taldykorgan",
"771033", "Agadyr",
"771040", "Zhairem\ \(GOK\)",
"771030", "Atasu",
"7351", "Chelyabinsk",
"771637", "Korgalzhyn",
"771647", "Esil",
"771332", "Uil",
"771430", "Arkalyk",
"772776", "Shelek",
"772257", "Shulbinsk",
"771342", "Badamsha",
"771440", "Amangeldy",
"771433", "Lisakovsk",
"771443", "Borovskoi",
"77273", "Almaty",
"77274", "Karassaisky\ District",
"772779", "Narynkol",
"7485", "Yaroslavl",
"7491", "Ryazan",
"7873", "Ingushi\ Republic",
"772535", "Shardara",
"772545", "Ikan",
"77152", "Petropavlovsk",
"771638", "Akkol",
"771648", "Derzhavinsk",
"77149", "Kostanai",
"771642", "Egendykol",
"771632", "Zerenda",
"733", "Baikonur",
"771041", "Aktau\,\ Zhezkazgan",
"771031", "Aksu\-Ayuly",
"771444", "Uzunkol",
"771434", "Denisovka",
"7844", "Volgograd",
"7388", "Republic\ of\ Altai",
"772436", "Terenozek",
"772252", "Karaul",
"771347", "Aitekebisky\ District",
"771034", "Zhezdy",
"772439", "Aralsky\ District",
"771337", "Alga",
"771431", "Rudny",
"771441", "Karabalyk",
"7818", "Arkhangelsk",
"771348", "Shalkarsky\ District",
"771455", "Zatobolsk",
"7834", "Republic\ of\ Mordovia",
"77272956", "Talgar",
"7473", "Voronezh",
"7487", "Tula",
"7427", "Chukotka\ Autonomous\ District",};
$areanames{ru} = {"771439", "Джангильдинский\ р\-н",
"772337", "Серебрянск",
"772347", "Жарминский\ р\-н",
"771449", "Тарановский\ р\-н",
"772431", "Жалагашский\ р\-н",
"772773", "Балхашский\ р\-н",
"771446", "Узункольский\ р\-н",
"772770", "Жамбылский\ р\-н",
"771436", "Тарановский\ р\-н",
"740", "Калининградская\ обл\.",
"736", "Республика\ Крым",
"7815", "Мурманская\ обл\.",
"771039", "Приозерск",
"771036", "Балхаш",
"7391", "Красноярский\ край",
"772632", "Меркенский\ р\-н",
"772642", "Мойынкумский\ р\-н",
"77272", "Алма\-Ата",
"772759", "Алматинская\ область",
"7385", "Алтайский\ край",
"772338", "Уланский\ р\-н",
"772348", "Кокпектинский\ р\-н",
"7492", "Владимирская\ обл\.",
"772771", "Карасайский\ р\-н",
"772725", "Отеген\-Батыр",
"7415", "Камчатский\ край",
"772342", "Катон\-Карагайский\ р\-н",
"772332", "Шемонаихинский\ р\-н",
"7499", "г\.\ Москва",
"772433", "Аральский\ р\-н",
"772637", "Байзакский\ р\-н",
"772774", "Талгарский\ р\-н",
"77182", "Павлодар",
"772835", "Текели",
"7352", "Курганская\ обл\.",
"77245", "Кызылординская\ область",
"772638", "Шуский\ р\-н",
"7851", "Астраханская\ обл\.",
"77252", "Шымкент",
"771545", "Жамбылский\ р\-н",
"771535", "Габита\ Мусрепова\ р\-н",
"7817", "Вологодская\ обл\.",
"771837", "Аксуский\ р\-н",
"7383", "Новосибирская\ обл\.",
"7869", "г\.\ Севастополь",
"771645", "Степногорск",
"77262", "Тараз",
"7862", "Краснодарский\ край",
"771635", "Жаксынский\ р\-н",
"771144", "Казталовский\ р\-н",
"771134", "Сырымский\ р\-н",
"772548", "Шаян",
"772538", "имени\ Турара\ Рыскулова",
"7349", "Ямало\-Ненецкий\ АО",
"7841", "Пензенская\ обл\.",
"772146", "Каркаралинск",
"772149", "Осакаровский\ р\-н",
"771131", "Зеленовский\ р\-н",
"7342", "Пермский\ край",
"771141", "Жангалинский\ р\-н",
"7831", "Нижегородская\ обл\.",
"772931", "Мангистауский\ р\-н",
"771236", "Махамбетский\ р\-н",
"771239", "Макатский\ р\-н",
"772547", "Ленгер",
"772537", "Сарыагаш",
"771452", "Карасуский\ р\-н",
"771651", "Целиноградский\ р\-н",
"772934", "Жанаозен",
"7416", "Амурская\ обл\.",
"7813", "Ленинградская\ обл\.",
"771838", "Майский\ р\-он",
"77145834", "Красногорск",
"771832", "Иртышский\ р\-н",
"771842", "Майский\ р\-он",
"771130", "Зеленовский\ р\-н",
"771140", "Бокейординский\ р\-н",
"771133", "Бурлинский\ р\-н",
"7302", "Забайкальский\ край",
"771143", "Теректинский\ р\-н",
"771335", "Шалкарский\ р\-н",
"771458", "Костанайская\ область",
"77232", "Усть\-Каменогорск",
"771345", "Байганинский\ р\-н",
"771457", "Джангильдинский\ р\-н",
"772532", "Абая",
"772542", "Асыката",
"772230", "Урджарский\ р\-н",
"7413", "Магаданская\ обл\.",
"7494", "Костромская\ обл\.",
"7816", "Новгородская\ обл\.",
"7878", "Республика\ Карачаево\-Черкесская",
"7712302", "Тенгизшевройл",
"7382", "Томская\ обл\.",
"7821", "Республика\ Коми",
"7863", "Ростовская\ обл\.",
"772438", "Казалинский\ р\-н",
"7343", "Свердловская\ обл",
"772153", "Абайский\ р\-н",
"771349", "Шалкарский\ р\-н",
"772437", "Кармакшинский\ р\-н",
"771339", "Айтекебийский\ р\-н",
"772331", "Глубоковский\ р\-н",
"772341", "Катон\-Карагайский\ р\-н",
"771336", "Хромтауский\ р\-н",
"772772", "Капчагай",
"771346", "Темирский\ р\-н",
"772643", "Шуский\ р\-н",
"772633", "Жамбылский\ р\-н",
"772640", "Мойынкумский\ р\-н",
"7812", "г\.\ Санкт\-Петербург",
"772344", "Тарбагатайский\ р\-н",
"772334", "Уланский\ р\-н",
"77213", "Темиртау",
"772154", "Бухар\-Жырауский\ р\-н",
"7346", "Ханты\ \-\ Мансийский\ \-\ Югра\ АО",
"7481", "Смоленская\ обл\.",
"7421", "Хабаровский\ край",
"77292", "Актау",
"77222", "Семипалатинск",
"771235", "Макатский\ р\-н",
"7866", "Республика\ Кабардино\-Балкарская",
"772778", "Уйгурский\ р\-н",
"772777", "Райымбекский\ р\-н",
"772256", "Алгабас",
"772330", "Зыряновский\ р\-н",
"772432", "Шиелийский\ р\-н",
"772340", "Зайсанский\ р\-н",
"772333", "Кокпектинский\ р\-н",
"772343", "Курчумский\ р\-н",
"772634", "Жанатас",
"772644", "Таласский\ р\-н",
"77112", "Уральск",
"7495", "Московская\ обл\.",
"772641", "Таласский\ р\-н",
"772631", "Турара\ Рыскулова\ р\-н",
"771639", "Енбекшилдерский\ р\-н",
"771649", "Жаксынский\ р\-н",
"771646", "Буландинский\ р\-н",
"771636", "Щучинский\ р\-н",
"771546", "Акжарский\ р\-н",
"771536", "Тайыншинский\ р\-н",
"771453", "Аулиекольский\ р\-н",
"772541", "Мырзакент",
"772531", "Аксукент",
"771539", "Кызылжарский\ р\-н",
"772237", "Аязог",
"771138", "Казталовский\ р\-н",
"772937", "Каракиянский\ р\-н",
"77279", "Алматы",
"7496", "г\.\ Москва",
"772534", "Жетысай",
"772544", "Шаульдер",
"7814", "Республика\ Карелия",
"7471", "Курская\ обл\.",
"7848", "Самарская\ обл\.",
"7865", "Ставропольский\ край",
"771841", "Актогайский\ р\-н",
"771831", "Железинский\ р\-н",
"772839", "Саркандский\ р\-н",
"772836", "Ескельдинский\ р\-н",
"7384", "Кемеровская\ обл\.",
"772938", "Тупкараганский\ р\-н",
"771137", "Чингирлауский\ р\-н",
"771147", "Акжаикский\ р\-н",
"7345", "Тюменская\ обл\.",
"771834", "Успенский\ р\-н",
"771844", "Иртышский\ р\-н",
"772932", "Бейнеуский\ р\-н",
"7493", "Ивановская\ обл\.",
"77185", "Шалдай",
"7871", "Республика\ Чеченская",
"772543", "Аксумбе",
"771451", "Сарыкольский\ р\-н",
"772533", "Туркестан",
"772540", "Арыс",
"7867", "Республика\ Северная\ Осетия\ \-\ Алания",
"772530", "Темирлановка",
"7347", "Республика\ Башкортостан",
"771454", "Наурзумский\ р\-н",
"7353", "Оренбургская\ обл\.",
"771035", "Улытауский\ р\-н",
"771843", "Майский\ р\-н",
"771833", "Качирский\ р\-н",
"771840", "Баянаульский\ р\-н",
"77242", "Кызылорда",
"771445", "Алтынсаринский\ р\-н",
"771435", "Житикаринский\ р\-н",
"771142", "Акжаикский\ р\-н",
"771132", "Теректинский\ р\-н",
"772144", "Нуринский\ р\-н",
"77162", "Кокшетау",
"772635", "Жуалынский\ р\-н",
"7394", "Республика\ Тыва",
"7475", "Тамбовская\ обл\.",
"772837", "Алакольский\ р\-н",
"772131", "Абайский\ р\-н",
"771149", "Акжаикский\ р\-н",
"771139", "Таскалинский\ р\-н",
"771136", "Акжаикский\ р\-н",
"77106", "Сатпаев",
"771146", "Акжаикский\ р\-н",
"7390", "Республика\ Хакасия",
"771538", "Кызылжарский\ р\-н",
"771547", "Жамбылский\ р\-н",
"772239", "Урджарский\ р\-н",
"771537", "Тимирязевский\ р\-н",
"7341", "Республика\ Удмуртская",
"772353", "Бородулихинский\ р\-н",
"771231", "Исатайский\ р\-н",
"772236", "Бескарагайский\ р\-н",
"7842", "Ульяновская\ обл\.",
"7861", "Краснодарский\ край",
"772838", "Коксуский\ р\-н",
"771234", "Индерский\ р\-н",
"7486", "Орловская\ обл\.",
"7877", "Республика\ Адыгея",
"7426", "Еврейская\ автономная\ обл\.",
"772832", "Аксуский\ р\-н",
"772842", "Кербулакский\ р\-н",
"77125", "Атырауская\ область",
"772335", "Зыряновск",
"772345", "Жарминский\ р\-н",
"77132", "Актобе\/Актюбинск",
"7717", "Астана",
"7483", "Брянская\ обл\.",
"7423", "Приморский\ край",
"771532", "Аккайынский\ р\-н",
"771230", "Атырауская\ область",
"771542", "Уалихановский\ р\-н",
"7301", "Республика\ Бурятия",
"772351", "Бородулихинский\ р\-н",
"771233", "Курмангазинский\ р\-н",
"77272983", "Каскелен",
"7712303", "Тензиз",
"7844", "Волгоградская\ обл\.",
"772436", "Сырдарьинский\ р\-н",
"7388", "Республика\ Алтай",
"771441", "Карабалыкский\ р\-н",
"771431", "Рудный",
"772439", "Аральский\ р\-н",
"771337", "Алгинский\ р\-н",
"772252", "Абайский\ р\-н",
"771347", "Айтекебийский\ р\-н",
"771034", "Улытауский\ р\-н",
"771632", "Зерендинский\ р\-н",
"771642", "Егиндыкольский\ р\-н",
"771434", "Денисовский\ р\-н",
"771444", "Узункольский\ р\-н",
"771031", "Шетский\ р\-н",
"771041", "Актау\,\ Жезказган",
"733", "Байконыр",
"7473", "Воронежская\ обл\.",
"7487", "Тульская\ обл\.",
"7427", "Чукотский\ АО",
"7834", "Республика\ Мордовия",
"771455", "Костанайский\ р\-н",
"7818", "Архангельская\ обл\.",
"771348", "Шалкарский\ р\-н",
"77272956", "Талгар",
"771443", "Мендыкаринский\ р\-н",
"771433", "Лисаковск",
"771342", "Каргалинский\ р\-н",
"772776", "Енбекшиказахский\ р\-н",
"772257", "Шульбинск",
"771440", "Амангельдинский\ р\-н",
"771332", "Уилский\ р\-н",
"771430", "Аркалык",
"7485", "Ярославская\ обл\.",
"772779", "Райымбекский\ р\-н",
"77274", "Карасайский\ р\-н",
"77273", "Алма\-Ата",
"771030", "Жана\-Аркинский\ р\-н",
"771040", "Жайрем\ \(ГОК\)",
"77282", "Талдыкорган",
"771845", "Павлодар",
"771033", "Шетский\ р\-н",
"771043", "Жайрем\ \(поселок\)",
"7351", "Челябинская\ обл\.",
"771647", "Есильский\ р\-н",
"771637", "Коргалжынский\ р\-н",
"771648", "Жаркаинский\ р\-н",
"771638", "Аккольский\ р\-н",
"77149", "Костанай",
"7873", "Республика\ Ингушетия",
"7491", "Рязанская\ обл\.",
"772545", "Икан",
"77152", "Петропавловск",
"772535", "Шардара",
"7845", "Саратовская\ обл\.",
"772138", "Бухар\-Жырауский\ р\-н",
"772148", "Осакаровский\ р\-н",
"772539", "Казыгурт",
"771237", "Жылыойский\ р\-н",
"7820", "Вологодская\ обл\.",
"771541", "Мамлютский\ р\-н",
"771531", "Магжана\ Жумабаева\ р\-н",
"772546", "Шолаккорган",
"772536", "Кентау",
"771534", "Шал\ Акына\ р\-н",
"771544", "Жамбылский\ р\-н",
"771836", "Щербактинский\ р\-н",
"771839", "Лебяжинский\ р\-н",
"7472", "Белгородская\ обл\.",
"772841", "Аксуский\ р\-н",
"77187", "Экибастуз",
"772831", "Панфиловский\ р\-н",
"772775", "Енбекшиказахский\ р\-н",
"771238", "Кзылкогинский\ р\-н",
"772834", "Каратальский\ р\-н",
"7835", "Чувашская\ Республика\ \-\ Чувашия",
"772137", "Сарань",
"772147", "Каркаралинский\ р\-н",
"771456", "Качар",
"7484", "Калужская\ обл\.",
"7424", "Сахалинская\ обл\.",
"771232", "Атырауская\ область",
"771540", "Уалихановский\ р\-н",
"771459", "Костанайская\ область",
"771543", "Есильский\ р\-н",
"771533", "Айыртауский\ р\-н",
"772840", "Кербулакский\ р\-н",
"772830", "Алакольский\ р\-н",
"772843", "Лепсы",
"772833", "Алакольский\ р\-н",
"77102", "Жезказган",
"7847", "Республика\ Калмыкия",
"7879", "Ставропольский\ край",
"772132", "Нуринский\ р\-н",
"77142", "Костанай",
"772435", "Жанакорганский\ р\-н",
"7872", "Республика\ Дагестан",
"7395", "Иркутская\ обл\.",
"77224", "Эмельтау",
"7811", "Псковская\ обл\.",
"772757", "Акший",
"771038", "Сыры\-Шаган",
"7474", "Липецкая\ обл\.",
"7833", "Кировская\ обл\.",
"771448", "Карасуский\ р\-н",
"771438", "Амангельдинский\ р\-н",
"772336", "Риддер",
"772346", "Тарбагатайский\ р\-н",
"771331", "Мартукский\ р\-н",
"771341", "Хобдинский\ р\-н",
"771447", "Карабалыкский\ р\-н",
"772339", "Курчумский\ р\-н",
"771437", "Камыстинский\ р\-н",
"7843", "Республика\ Татарстан",
"771037", "Актогайский\ р\-н",
"771334", "Мугалжарский\ р\-н",
"771640", "Сандыктауский\ р\-н",
"771630", "Боровое",
"771643", "Атбасарский\ р\-н",
"771633", "Ерейментауский\ р\-н",
"7381", "Омская\ обл\.",
"772752", "Илийский\ р\-н",
"7836", "Республика\ Марий\ Эл",
"77135", "Актюбинская\ область",
"7498", "Московская\ обл\.",
"77122", "Атырау",
"772159", "Карагандинская\ область",
"772935", "Каракиянский\ р\-н",
"7411", "Республика\ Саха\ \/Якутия\/",
"772156", "Шахтинск",
"771135", "Жанибекский\ р\-н",
"771145", "Каратобинский\ р\-н",
"77212", "Караганда",
"771644", "Аршалынский\ р\-н",
"772251", "Курчатов",
"771333", "Мугалжарский\ р\-н",
"771343", "Иргизский\ р\-н",
"771330", "Хромтауский\ р\-н",
"771340", "Хобдинский\ р\-н",
"771442", "Федоровский\ р\-н",
"7482", "Тверская\ обл\.",
"772636", "Кордай",
"772639", "Сарысуский\ р\-н",
"771641", "Астраханский\ р\-н",
"771631", "Шортандинский\ р\-н",
"771042", "Акой",
"771032", "Каражал",
"7855", "Республика\ Татарстан",
"7846", "Самарская\ обл\.",};
my $timezones = {
               '' => [
                       'Asia/Almaty',
                       'Asia/Anadyr',
                       'Asia/Aqtobe',
                       'Asia/Irkutsk',
                       'Asia/Kamchatka',
                       'Asia/Krasnoyarsk',
                       'Asia/Magadan',
                       'Asia/Novosibirsk',
                       'Asia/Omsk',
                       'Asia/Sakhalin',
                       'Asia/Vladivostok',
                       'Asia/Yakutsk',
                       'Asia/Yekaterinburg',
                       'Europe/Bucharest',
                       'Europe/Moscow',
                       'Europe/Samara'
                     ],
               '301' => [
                          'Asia/Irkutsk'
                        ],
               '302' => [
                          'Asia/Yakutsk'
                        ],
               '33' => [
                         'Asia/Almaty'
                       ],
               '34' => [
                         'Asia/Yekaterinburg'
                       ],
               '341' => [
                          'Europe/Samara'
                        ],
               '35' => [
                         'Asia/Yekaterinburg'
                       ],
               '36' => [
                         'Europe/Moscow'
                       ],
               '381' => [
                          'Asia/Omsk'
                        ],
               '382' => [
                          'Asia/Novosibirsk'
                        ],
               '383' => [
                          'Asia/Novosibirsk'
                        ],
               '384' => [
                          'Asia/Krasnoyarsk'
                        ],
               '385' => [
                          'Asia/Krasnoyarsk'
                        ],
               '388' => [
                          'Asia/Krasnoyarsk'
                        ],
               '390' => [
                          'Asia/Krasnoyarsk'
                        ],
               '391' => [
                          'Asia/Krasnoyarsk'
                        ],
               '394' => [
                          'Asia/Krasnoyarsk'
                        ],
               '395' => [
                          'Asia/Irkutsk'
                        ],
               '40' => [
                         'Europe/Bucharest'
                       ],
               '411' => [
                          'Asia/Yakutsk'
                        ],
               '413' => [
                          'Asia/Magadan'
                        ],
               '415' => [
                          'Asia/Kamchatka'
                        ],
               '416' => [
                          'Asia/Yakutsk'
                        ],
               '421' => [
                          'Asia/Vladivostok'
                        ],
               '423' => [
                          'Asia/Vladivostok'
                        ],
               '424' => [
                          'Asia/Sakhalin'
                        ],
               '426' => [
                          'Asia/Vladivostok'
                        ],
               '427' => [
                          'Asia/Anadyr'
                        ],
               '47' => [
                         'Europe/Moscow'
                       ],
               '48' => [
                         'Europe/Moscow'
                       ],
               '49' => [
                         'Europe/Moscow'
                       ],
               '7' => [
                        'Asia/Almaty',
                        'Asia/Aqtobe'
                      ],
               '71' => [
                         'Asia/Almaty'
                       ],
               '711' => [
                          'Asia/Aqtobe'
                        ],
               '712' => [
                          'Asia/Aqtobe'
                        ],
               '713' => [
                          'Asia/Aqtobe'
                        ],
               '72' => [
                         'Asia/Almaty'
                       ],
               '729' => [
                          'Asia/Aqtobe'
                        ],
               '79' => [
                         'Asia/Almaty'
                       ],
               '800' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '803' => [
                          'Europe/Moscow'
                        ],
               '804' => [
                          'Europe/Moscow'
                        ],
               '808' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '809' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '81' => [
                         'Europe/Moscow'
                       ],
               '810' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '82' => [
                         'Europe/Moscow'
                       ],
               '83' => [
                         'Europe/Moscow'
                       ],
               '840' => [
                          'Europe/Bucharest',
                          'Europe/Moscow'
                        ],
               '841' => [
                          'Europe/Moscow'
                        ],
               '842' => [
                          'Europe/Samara'
                        ],
               '843' => [
                          'Europe/Moscow'
                        ],
               '844' => [
                          'Europe/Moscow'
                        ],
               '845' => [
                          'Europe/Moscow'
                        ],
               '846' => [
                          'Europe/Samara'
                        ],
               '847' => [
                          'Europe/Moscow'
                        ],
               '848' => [
                          'Europe/Samara'
                        ],
               '851' => [
                          'Europe/Samara'
                        ],
               '855' => [
                          'Europe/Moscow'
                        ],
               '86' => [
                         'Europe/Moscow'
                       ],
               '87' => [
                         'Europe/Moscow'
                       ],
               '9' => [
                        'Europe/Moscow'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+7|\D)//g;
      my $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:8)//;
      $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;