/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached.protocol;

import java.net.ProtocolException;
import java.nio.ByteBuffer;
import org.couchbase.mock.memcached.KeySpec;
import org.couchbase.mock.memcached.protocol.CommandCode;

public class BinaryCommand {
    private final CommandCode cc;
    private final short keyLength;
    final byte extraLength;
    private final short vbucket;
    private final int bodyLength;
    private final int opaque;
    final long cas;
    final ByteBuffer bodyBuffer;

    BinaryCommand(ByteBuffer header) throws ProtocolException {
        header.rewind();
        header.get();
        this.cc = CommandCode.valueOf(header.get());
        this.keyLength = header.getShort();
        this.extraLength = header.get();
        if (header.get() != 0) {
            throw new ProtocolException("Illegal data type");
        }
        this.vbucket = header.getShort();
        this.bodyLength = header.getInt();
        this.opaque = header.getInt();
        this.cas = header.getLong();
        this.bodyBuffer = this.bodyLength > 0 ? ByteBuffer.allocate(this.bodyLength) : null;
    }

    public ByteBuffer getInputBuffer() {
        return this.bodyBuffer;
    }

    public CommandCode getComCode() {
        return this.cc;
    }

    public int getOpaque() {
        return this.opaque;
    }

    public short getVBucketId() {
        return this.vbucket;
    }

    public long getCas() {
        return this.cas;
    }

    public String getKey() {
        if (this.keyLength == 0) {
            return null;
        }
        return new String(this.bodyBuffer.array(), (int)this.extraLength, (int)this.keyLength);
    }

    public KeySpec getKeySpec() {
        return new KeySpec(this.getKey(), this.vbucket);
    }

    public byte[] getValue() {
        byte[] ret = new byte[this.bodyLength - this.extraLength - this.keyLength];
        System.arraycopy(this.bodyBuffer.array(), this.extraLength + this.keyLength, ret, 0, ret.length);
        return ret;
    }

    public boolean complete() {
        return this.bodyLength == 0 || !this.bodyBuffer.hasRemaining();
    }

    public void process() throws ProtocolException {
    }
}

