#!/usr/bin/perl

package eBay::API::XML::Call::SetShippingDiscountProfiles;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SetShippingDiscountProfiles.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::SetShippingDiscountProfiles

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::SetShippingDiscountProfiles inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::SetShippingDiscountProfiles::SetShippingDiscountProfilesRequestType;
use eBay::API::XML::Call::SetShippingDiscountProfiles::SetShippingDiscountProfilesResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'SetShippingDiscountProfiles';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::SetShippingDiscountProfiles::SetShippingDiscountProfilesRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::SetShippingDiscountProfiles::SetShippingDiscountProfilesResponseType';
}

#
# input properties
#

=head2 setCalculatedHandlingDiscount()

The data for the specific packaging/handling cost details for combined payment.

  RequiredInput: No
#    Argument: 'ns:CalculatedHandlingDiscountType'

=cut
       
sub setCalculatedHandlingDiscount {
   my $self   = shift;
   my $pCalculatedHandlingDiscount = shift;
   $self->getRequestDataType()->setCalculatedHandlingDiscount($pCalculatedHandlingDiscount);
}

=head2 setCalculatedShippingDiscount()

Details of a shipping cost discount profile for calculated shipping.
If this is provided, FlatShippingDiscount and PromotionalShippingDiscountDetails
should be omitted.

  RequiredInput: No
#    Argument: 'ns:CalculatedShippingDiscountType'

=cut
       
sub setCalculatedShippingDiscount {
   my $self   = shift;
   my $pCalculatedShippingDiscount = shift;
   $self->getRequestDataType()->setCalculatedShippingDiscount($pCalculatedShippingDiscount);
}

=head2 setCombinedDuration()

Only those items purchased within CombinedDuration days of each other can
be combined into an order and benefit from any shipping discounts.

  RequiredInput: Yes
#    Argument: 'ns:CombinedPaymentPeriodCodeType'

=cut
       
sub setCombinedDuration {
   my $self   = shift;
   my $sCombinedDuration = shift;
   $self->getRequestDataType()->setCombinedDuration($sCombinedDuration);
}

=head2 setCurrencyID()

The ID of the currency to be used for shipping cost discounts and
insurance for combined payment. A discount profile can only be
associated with a listing if the currency ID of the profile matches the
currency ID of the listing.
Required if the user creates flat rate shipping discount profiles, a promotional
discount, a packaging/handling cost profile based on a variable
discount rule, or if the user defines shipping insurance range/fee pairs.
<br><br>
Note: There is a currencyID attribute on many elements of SetShippingDiscountProfiles.
To avoid an error, be sure to use the same value of CurrencyCodeType in each
occurrence within the same request.

  RequiredInput: Conditionally
#    Argument: 'ns:CurrencyCodeType'

=cut
       
sub setCurrencyID {
   my $self   = shift;
   my $sCurrencyID = shift;
   $self->getRequestDataType()->setCurrencyID($sCurrencyID);
}

=head2 setFlatShippingDiscount()

Details of a shipping cost discount profile for flat rate shipping.
If this is provided, CalculatedShippingDiscount and PromotionalShippingDiscountDetails
should be omitted.

  RequiredInput: No
#    Argument: 'ns:FlatShippingDiscountType'

=cut
       
sub setFlatShippingDiscount {
   my $self   = shift;
   my $pFlatShippingDiscount = shift;
   $self->getRequestDataType()->setFlatShippingDiscount($pFlatShippingDiscount);
}

=head2 setInternationalShippingInsurance()

Information establishing what fee to apply for international shipping
insurance for combined payment depending on which range the order item-
total price falls into.

  RequiredInput: No
#    Argument: 'ns:ShippingInsuranceType'

=cut
       
sub setInternationalShippingInsurance {
   my $self   = shift;
   my $pInternationalShippingInsurance = shift;
   $self->getRequestDataType()->setInternationalShippingInsurance($pInternationalShippingInsurance);
}

=head2 setModifyActionCode()

Indicates what action to take on the specified flat shipping discount,
calculated shipping discount or promotional discount.
If the action is Delete and if a flat rate or calculated shipping discount
profile is specified, the discount profile identified by
DiscountProfile.DiscountProfileID is deleted
(see DiscountProfile.MappedDiscountProfileID for related details).

  RequiredInput: Yes
#    Argument: 'ns:ModifyActionCodeType'

=cut
       
sub setModifyActionCode {
   my $self   = shift;
   my $sModifyActionCode = shift;
   $self->getRequestDataType()->setModifyActionCode($sModifyActionCode);
}

=head2 setPromotionalShippingDiscountDetails()

The data for the promotional shipping discount.
If this is provided, FlatShippingDiscount and CalculatedShippingDiscount
should be omitted.

  RequiredInput: No
#    Argument: 'ns:PromotionalShippingDiscountDetailsType'

=cut
       
sub setPromotionalShippingDiscountDetails {
   my $self   = shift;
   my $pPromotionalShippingDiscountDetails = shift;
   $self->getRequestDataType()->setPromotionalShippingDiscountDetails($pPromotionalShippingDiscountDetails);
}

=head2 setShippingInsurance()

Information establishing what fee to apply for domestic shipping insurance
for combined payment depending on which range the order item-total price
falls into.

  RequiredInput: No
#    Argument: 'ns:ShippingInsuranceType'

=cut
       
sub setShippingInsurance {
   my $self   = shift;
   my $pShippingInsurance = shift;
   $self->getRequestDataType()->setShippingInsurance($pShippingInsurance);
}



#
# output properties
#





1;   
