package ZCS::Admin::Types::FaultDetailError;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'urn:zimbra' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Code_of :ATTR(:get<Code>);
my %Trace_of :ATTR(:get<Trace>);
my %a_of :ATTR(:get<a>);

__PACKAGE__->_factory(
    [ qw(        Code
        Trace
        a

    ) ],
    {
        'Code' => \%Code_of,
        'Trace' => \%Trace_of,
        'a' => \%a_of,
    },
    {
        'Code' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Trace' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'a' => 'ZCS::Admin::Types::ItemAttribute',
    },
    {

        'Code' => 'Code',
        'Trace' => 'Trace',
        'a' => 'a',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

ZCS::Admin::Types::FaultDetailError

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
FaultDetailError from the namespace urn:zimbra.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Code


=item * Trace


=item * a




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ZCS::Admin::Types::FaultDetailError
   Code =>  $some_value, # string
   Trace =>  $some_value, # string
   a =>  { value => $some_value },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

