######################################################################
#
# 2100_utf8.1_by_cp00930.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x00"],
        ["\x01",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x01"],
        ["\x02",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x02"],
        ["\x03",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x03"],
        ["\x37",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x04"],
        ["\x2D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x05"],
        ["\x2E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x06"],
        ["\x2F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x07"],
        ["\x16",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x08"],
        ["\x05",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x09"],
        ["\x15",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x0A"],
        ["\x0B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x0B"],
        ["\x0C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x0C"],
        ["\x0D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x0D"],
        ["\x0E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x0E"],
        ["\x0F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x0F"],
        ["\x10",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x10"],
        ["\x11",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x11"],
        ["\x12",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x12"],
        ["\x13",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x13"],
        ["\x3C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x14"],
        ["\x3D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x15"],
        ["\x32",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x16"],
        ["\x26",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x17"],
        ["\x18",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x18"],
        ["\x19",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x19"],
        ["\x3F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x1A"],
        ["\x27",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x1B"],
        ["\x1C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x1C"],
        ["\x1D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x1D"],
        ["\x1E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x1E"],
        ["\x1F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x1F"],
        ["\x40",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x20"],
        ["\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x21"],
        ["\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x22"],
        ["\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x23"],
        ["\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x24"],
        ["\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x25"],
        ["\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x26"],
        ["\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x27"],
        ["\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x28"],
        ["\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x29"],
        ["\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x2A"],
        ["\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x2B"],
        ["\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x2C"],
        ["\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x2D"],
        ["\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x2E"],
        ["\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x2F"],
        ["\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x30"],
        ["\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x31"],
        ["\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x32"],
        ["\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x33"],
        ["\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x34"],
        ["\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x35"],
        ["\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x36"],
        ["\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x37"],
        ["\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x38"],
        ["\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x39"],
        ["\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x3A"],
        ["\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x3B"],
        ["\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x3C"],
        ["\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x3D"],
        ["\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x3E"],
        ["\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x3F"],
        ["\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x40"],
        ["\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x41"],
        ["\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x42"],
        ["\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x43"],
        ["\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x44"],
        ["\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x45"],
        ["\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x46"],
        ["\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x47"],
        ["\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x48"],
        ["\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x49"],
        ["\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x4A"],
        ["\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x4B"],
        ["\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x4C"],
        ["\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x4D"],
        ["\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x4E"],
        ["\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x4F"],
        ["\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x50"],
        ["\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x51"],
        ["\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x52"],
        ["\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x53"],
        ["\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x54"],
        ["\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x55"],
        ["\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x56"],
        ["\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x57"],
        ["\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x58"],
        ["\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x59"],
        ["\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x5A"],
        ["\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x5B"],
        ["\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x5C"],
        ["\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x5D"],
        ["\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x5E"],
        ["\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x5F"],
        ["\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x60"],
        ["\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x61"],
        ["\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x62"],
        ["\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x63"],
        ["\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x64"],
        ["\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x65"],
        ["\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x66"],
        ["\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x67"],
        ["\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x68"],
        ["\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x69"],
        ["\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x6A"],
        ["\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x6B"],
        ["\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x6C"],
        ["\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x6D"],
        ["\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x6E"],
        ["\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x6F"],
        ["\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x70"],
        ["\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x71"],
        ["\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x72"],
        ["\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x73"],
        ["\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x74"],
        ["\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x75"],
        ["\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x76"],
        ["\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x77"],
        ["\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x78"],
        ["\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x79"],
        ["\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x7A"],
        ["\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x7B"],
        ["\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x7C"],
        ["\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x7D"],
        ["\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x7E"],
        ["\x07",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\x7F"],
        ["\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA1"],
        ["\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA2"],
        ["\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA3"],
        ["\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA4"],
        ["\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA5"],
        ["\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA6"],
        ["\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA7"],
        ["\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA8"],
        ["\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA9"],
        ["\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xAA"],
        ["\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xAB"],
        ["\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xAC"],
        ["\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xAD"],
        ["\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xAE"],
        ["\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xAF"],
        ["\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB0"],
        ["\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB1"],
        ["\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB2"],
        ["\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB3"],
        ["\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB4"],
        ["\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB5"],
        ["\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB6"],
        ["\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB7"],
        ["\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB8"],
        ["\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB9"],
        ["\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xBA"],
        ["\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xBB"],
        ["\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xBC"],
        ["\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xBD"],
        ["\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xBE"],
        ["\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xBF"],
        ["\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x80"],
        ["\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x81"],
        ["\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x82"],
        ["\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x83"],
        ["\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x84"],
        ["\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x85"],
        ["\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x86"],
        ["\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x87"],
        ["\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x88"],
        ["\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x89"],
        ["\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x8A"],
        ["\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x8B"],
        ["\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x8C"],
        ["\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x8D"],
        ["\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x8E"],
        ["\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x8F"],
        ["\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x90"],
        ["\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x91"],
        ["\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x92"],
        ["\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x93"],
        ["\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x94"],
        ["\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x95"],
        ["\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x96"],
        ["\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x97"],
        ["\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x98"],
        ["\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x99"],
        ["\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x9A"],
        ["\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x9B"],
        ["\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x9C"],
        ["\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x9D"],
        ["\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x9E"],
        ["\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x9F"],
        ["\x40\x40",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x80"],
        ["\x43\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x81"],
        ["\x43\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x82"],
        ["\x42\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8C"],
        ["\x42\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8E"],
        ["\x43\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBB"],
        ["\x42\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9A"],
        ["\x42\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9B"],
        ["\x42\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9F"],
        ["\x42\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x81"],
        ["\x43\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9B"],
        ["\x43\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9C"],
        ["\x44\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],
        ["\x42\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x80"],
        ["\x44\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],
        ["\x44\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBE"],
        ["\x42\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA3"],
        ["\x42\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBF"],
        ["\x43\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBD"],
        ["\x43\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBE"],
        ["\x44\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9D"],
        ["\x44\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9E"],
        ["\x44\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x83"],
        ["\x44\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9D"],
        ["\x44\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x85"],
        ["\x44\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x86"],
        ["\x44\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x87"],
        ["\x43\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBC"],
        ["\xDD\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x94"],
        ["\x44\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x90"],
        ["\x42\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8F"],
        ["\x43\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBC"],
        ["\x43\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9C"],
        ["\xDF\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x96"],
        ["\x42\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9C"],
        ["\x44\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA6"],
        ["\x44\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA5"],
        ["\x44\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x98"],
        ["\x44\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x99"],
        ["\x44\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x9C"],
        ["\x44\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x9D"],
        ["\x42\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x88"],
        ["\x42\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x89"],
        ["\x44\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x94"],
        ["\x44\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x95"],
        ["\x44\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBB"],
        ["\x44\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBD"],
        ["\x42\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9B"],
        ["\x42\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9D"],
        ["\x44\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x88"],
        ["\x44\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x89"],
        ["\x44\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8A"],
        ["\x44\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8B"],
        ["\x43\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8C"],
        ["\x43\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8D"],
        ["\x44\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8E"],
        ["\x44\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8F"],
        ["\x44\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x90"],
        ["\x44\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x91"],
        ["\x42\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8B"],
        ["\xE9\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x92"],
        ["\x44\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],
        ["\x44\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x97"],
        ["\x44\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],
        ["\x42\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9D"],
        ["\x44\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA0"],
        ["\x42\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9C"],
        ["\x42\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9E"],
        ["\x44\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA6"],
        ["\x44\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA7"],
        ["\x44\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9E"],
        ["\x44\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xB4"],
        ["\x44\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\x82"],
        ["\x44\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\x80"],
        ["\x44\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],
        ["\x44\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB2"],
        ["\x44\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB3"],
        ["\x44\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x83"],
        ["\x42\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA5"],
        ["\x42\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x84"],
        ["\x43\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA0"],
        ["\x42\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA1"],
        ["\x42\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x85"],
        ["\x42\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x83"],
        ["\x42\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x86"],
        ["\x42\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8A"],
        ["\x42\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA0"],
        ["\x44\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],
        ["\x44\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x86"],
        ["\x44\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x85"],
        ["\x44\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8B"],
        ["\x44\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8F"],
        ["\x44\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8E"],
        ["\x44\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x87"],
        ["\x44\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x86"],
        ["\x44\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xA1"],
        ["\x44\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xA0"],
        ["\x44\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB3"],
        ["\x44\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB2"],
        ["\x44\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xBD"],
        ["\x44\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xBC"],
        ["\x44\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xBB"],
        ["\x44\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x92"],
        ["\x44\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x92"],
        ["\x44\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x90"],
        ["\x44\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x91"],
        ["\x44\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x93"],
        ["\x44\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\x43\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x88"],
        ["\x43\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x8B"],
        ["\x43\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x86"],
        ["\x43\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x87"],
        ["\x43\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x82"],
        ["\x43\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x83"],
        ["\x43\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAA"],
        ["\x43\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA9"],
        ["\x43\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA7"],
        ["\x43\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA8"],
        ["\x42\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA2"],
        ["\x43\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\x92"],
        ["\x43\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\x94"],
        ["\x43\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x80"],
        ["\x43\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x83"],
        ["\x43\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA0"],
        ["\x43\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\xA5"],
        ["\x43\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C\x92"],
        ["\x43\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x82"],
        ["\x43\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x87"],
        ["\x43\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA1"],
        ["\x43\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\x92"],
        ["\x43\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xAA"],
        ["\x43\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xAB"],
        ["\x43\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9A"],
        ["\x43\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xBD"],
        ["\x43\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9D"],
        ["\x44\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xB5"],
        ["\x43\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAB"],
        ["\x43\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAC"],
        ["\x43\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\xAB"],
        ["\x43\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB0"],
        ["\x43\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAF"],
        ["\x43\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAD"],
        ["\x43\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAA"],
        ["\x43\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA0"],
        ["\x43\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA1"],
        ["\x43\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],
        ["\x43\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\xAF"],
        ["\x42\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x90"],
        ["\x42\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x91"],
        ["\x42\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x92"],
        ["\x42\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x93"],
        ["\x42\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x94"],
        ["\x42\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x95"],
        ["\x42\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x96"],
        ["\x42\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x97"],
        ["\x42\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x98"],
        ["\x42\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x99"],
        ["\x42\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA1"],
        ["\x42\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA2"],
        ["\x42\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA3"],
        ["\x42\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA4"],
        ["\x42\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA5"],
        ["\x42\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA6"],
        ["\x42\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA7"],
        ["\x42\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA8"],
        ["\x42\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA9"],
        ["\x42\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAA"],
        ["\x42\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAB"],
        ["\x42\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAC"],
        ["\x42\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAD"],
        ["\x42\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAE"],
        ["\x42\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAF"],
        ["\x42\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB0"],
        ["\x42\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB1"],
        ["\x42\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB2"],
        ["\x42\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB3"],
        ["\x42\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB4"],
        ["\x42\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB5"],
        ["\x42\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB6"],
        ["\x42\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB7"],
        ["\x42\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB8"],
        ["\x42\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB9"],
        ["\x42\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBA"],
        ["\x42\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x81"],
        ["\x42\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x82"],
        ["\x42\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x83"],
        ["\x42\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x84"],
        ["\x42\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x85"],
        ["\x42\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x86"],
        ["\x42\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x87"],
        ["\x42\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x88"],
        ["\x42\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x89"],
        ["\x42\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8A"],
        ["\x42\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8B"],
        ["\x42\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8C"],
        ["\x42\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8D"],
        ["\x42\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8E"],
        ["\x42\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8F"],
        ["\x42\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x90"],
        ["\x42\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x91"],
        ["\x42\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x92"],
        ["\x42\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x93"],
        ["\x42\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x94"],
        ["\x42\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x95"],
        ["\x42\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x96"],
        ["\x42\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x97"],
        ["\x42\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x98"],
        ["\x42\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x99"],
        ["\x42\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9A"],
        ["\x44\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x81"],
        ["\x44\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x82"],
        ["\x44\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x83"],
        ["\x44\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x84"],
        ["\x44\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x85"],
        ["\x44\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x86"],
        ["\x44\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x87"],
        ["\x44\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x88"],
        ["\x44\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x89"],
        ["\x44\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8A"],
        ["\x44\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8B"],
        ["\x44\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8C"],
        ["\x44\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8D"],
        ["\x44\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8E"],
        ["\x44\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8F"],
        ["\x44\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x90"],
        ["\x44\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x91"],
        ["\x44\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x92"],
        ["\x44\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x93"],
        ["\x44\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x94"],
        ["\x44\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x95"],
        ["\x44\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x96"],
        ["\x44\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x97"],
        ["\x44\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x98"],
        ["\x44\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x99"],
        ["\x44\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9A"],
        ["\x44\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9B"],
        ["\x44\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9C"],
        ["\x44\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9D"],
        ["\x44\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9E"],
        ["\x44\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9F"],
        ["\x44\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA0"],
        ["\x44\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA1"],
        ["\x44\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA2"],
        ["\x44\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA3"],
        ["\x44\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA4"],
        ["\x44\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA5"],
        ["\x44\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA6"],
        ["\x44\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA7"],
        ["\x44\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA8"],
        ["\x44\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA9"],
        ["\x44\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAA"],
        ["\x44\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAB"],
        ["\x44\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAC"],
        ["\x44\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAD"],
        ["\x44\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAE"],
        ["\x44\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAF"],
        ["\x44\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB0"],
        ["\x44\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB1"],
        ["\x44\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB2"],
        ["\x44\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB3"],
        ["\x44\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB4"],
        ["\x44\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB5"],
        ["\x44\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB6"],
        ["\x44\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB7"],
        ["\x44\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB8"],
        ["\x44\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB9"],
        ["\x44\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBA"],
        ["\x44\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBB"],
        ["\x44\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBC"],
        ["\x44\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBD"],
        ["\x44\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBE"],
        ["\x44\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBF"],
        ["\x44\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x80"],
        ["\x44\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x81"],
        ["\x44\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x82"],
        ["\x44\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x83"],
        ["\x44\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x84"],
        ["\x44\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x85"],
        ["\x44\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x86"],
        ["\x44\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x87"],
        ["\x44\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x88"],
        ["\x44\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x89"],
        ["\x44\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8A"],
        ["\x44\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8B"],
        ["\x44\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8C"],
        ["\x44\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8D"],
        ["\x44\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8E"],
        ["\x44\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8F"],
        ["\x44\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x90"],
        ["\x44\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x91"],
        ["\x44\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x92"],
        ["\x44\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x93"],
        ["\x43\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA1"],
        ["\x43\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA2"],
        ["\x43\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA3"],
        ["\x43\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA4"],
        ["\x43\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA5"],
        ["\x43\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA6"],
        ["\x43\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA7"],
        ["\x43\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA8"],
        ["\x43\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA9"],
        ["\x43\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAA"],
        ["\x43\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAB"],
        ["\x43\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAC"],
        ["\x43\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAD"],
        ["\x43\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAE"],
        ["\x43\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAF"],
        ["\x43\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB0"],
        ["\x43\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB1"],
        ["\x43\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB2"],
        ["\x43\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB3"],
        ["\x43\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB4"],
        ["\x43\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB5"],
        ["\x43\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB6"],
        ["\x43\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB7"],
        ["\x43\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB8"],
        ["\x43\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB9"],
        ["\x43\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBA"],
        ["\x43\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBB"],
        ["\x43\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBC"],
        ["\x43\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBD"],
        ["\x43\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBE"],
        ["\x43\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBF"],
        ["\x43\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x80"],
        ["\x43\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x81"],
        ["\x43\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x82"],
        ["\x43\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x83"],
        ["\x43\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x84"],
        ["\x43\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x85"],
        ["\x43\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x86"],
        ["\x43\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x87"],
        ["\x43\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x88"],
        ["\x43\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x89"],
        ["\x43\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8A"],
        ["\x43\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8B"],
        ["\x43\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8C"],
        ["\x43\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8D"],
        ["\x43\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8E"],
        ["\x43\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8F"],
        ["\x43\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x90"],
        ["\x43\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x91"],
        ["\x43\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x92"],
        ["\x43\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x93"],
        ["\x43\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x94"],
        ["\x43\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x95"],
        ["\x43\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x96"],
        ["\x43\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x97"],
        ["\x43\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x98"],
        ["\x43\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x99"],
        ["\x43\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9A"],
        ["\x43\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9B"],
        ["\x43\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9C"],
        ["\x43\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9D"],
        ["\x43\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9E"],
        ["\x43\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9F"],
        ["\x43\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA0"],
        ["\x43\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA1"],
        ["\x43\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA2"],
        ["\x43\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA3"],
        ["\x43\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA4"],
        ["\x43\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA5"],
        ["\x43\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA6"],
        ["\x43\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA7"],
        ["\x43\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA8"],
        ["\x43\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA9"],
        ["\x43\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAA"],
        ["\x43\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAB"],
        ["\x43\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAC"],
        ["\x43\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAD"],
        ["\x43\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAE"],
        ["\x43\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAF"],
        ["\x43\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB0"],
        ["\x43\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB1"],
        ["\x43\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB2"],
        ["\x43\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB3"],
        ["\x43\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB4"],
        ["\x43\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB5"],
        ["\x43\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB6"],
        ["\x41\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x91"],
        ["\x41\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x92"],
        ["\x41\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x93"],
        ["\x41\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x94"],
        ["\x41\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x95"],
        ["\x41\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x96"],
        ["\x41\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x97"],
        ["\x41\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x98"],
        ["\x41\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x99"],
        ["\x41\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x9A"],
        ["\x41\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x9B"],
        ["\x41\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x9C"],
        ["\x41\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x9D"],
        ["\x41\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x9E"],
        ["\x41\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x9F"],
        ["\x41\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA0"],
        ["\x41\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],
        ["\x41\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],
        ["\x41\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],
        ["\x41\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],
        ["\x41\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],
        ["\x41\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],
        ["\x41\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],
        ["\x41\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],
        ["\x41\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],
        ["\x41\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],
        ["\x41\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],
        ["\x41\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],
        ["\x41\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],
        ["\x41\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],
        ["\x41\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],
        ["\x41\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],
        ["\x41\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],
        ["\x41\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],
        ["\x41\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],
        ["\x41\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],
        ["\x41\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],
        ["\x41\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],
        ["\x41\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],
        ["\x41\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x80"],
        ["\x41\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x81"],
        ["\x41\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x83"],
        ["\x41\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x84"],
        ["\x41\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x85"],
        ["\x41\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x86"],
        ["\x41\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x87"],
        ["\x41\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x88"],
        ["\x41\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x89"],
        ["\x41\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x90"],
        ["\x41\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x91"],
        ["\x41\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x92"],
        ["\x41\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x93"],
        ["\x41\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x94"],
        ["\x41\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x95"],
        ["\x41\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x81"],
        ["\x41\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x96"],
        ["\x41\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x97"],
        ["\x41\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x98"],
        ["\x41\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x99"],
        ["\x41\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x9A"],
        ["\x41\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x9B"],
        ["\x41\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x9C"],
        ["\x41\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x9D"],
        ["\x41\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x9E"],
        ["\x41\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x9F"],
        ["\x41\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA0"],
        ["\x41\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],
        ["\x41\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],
        ["\x41\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],
        ["\x41\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],
        ["\x41\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],
        ["\x41\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],
        ["\x41\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],
        ["\x41\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],
        ["\x41\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],
        ["\x41\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],
        ["\x41\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],
        ["\x41\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],
        ["\x41\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],
        ["\x41\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],
        ["\x41\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],
        ["\x41\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],
        ["\x41\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],
        ["\x41\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],
        ["\x41\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],
        ["\x41\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],
        ["\x41\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],
        ["\x41\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x91"],
        ["\x41\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],
        ["\x41\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],
        ["\x41\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],
        ["\x41\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],
        ["\x41\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],
        ["\x41\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],
        ["\x41\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],
        ["\x41\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],
        ["\x41\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],
        ["\x41\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],
        ["\x41\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x80"],
        ["\x41\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x81"],
        ["\x41\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x82"],
        ["\x41\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x83"],
        ["\x41\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x84"],
        ["\x41\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x85"],
        ["\x41\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x86"],
        ["\x41\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x87"],
        ["\x41\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x88"],
        ["\x41\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x89"],
        ["\x41\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x8A"],
        ["\x41\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x8B"],
        ["\x41\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x8C"],
        ["\x41\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x8D"],
        ["\x41\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x8E"],
        ["\x41\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x8F"],
        ["\x43\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x80"],
        ["\x43\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x82"],
        ["\x43\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x8C"],
        ["\x43\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x90"],
        ["\x43\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x98"],
        ["\x43\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x94"],
        ["\x43\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9C"],
        ["\x43\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAC"],
        ["\x43\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA4"],
        ["\x43\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB4"],
        ["\x43\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBC"],
        ["\x43\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x81"],
        ["\x43\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x83"],
        ["\x43\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x8F"],
        ["\x43\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x93"],
        ["\x43\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9B"],
        ["\x43\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x97"],
        ["\x43\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA3"],
        ["\x43\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB3"],
        ["\x43\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAB"],
        ["\x43\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBB"],
        ["\x43\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x95\x8B"],
        ["\x43\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA0"],
        ["\x43\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAF"],
        ["\x43\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA8"],
        ["\x43\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB7"],
        ["\x43\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBF"],
        ["\x43\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9D"],
        ["\x43\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB0"],
        ["\x43\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA5"],
        ["\x43\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB8"],
        ["\x43\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x95\x82"],
        ["\xE2\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA0"],
        ["\xE2\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA1"],
        ["\xE2\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA2"],
        ["\xE2\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA3"],
        ["\xE2\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA4"],
        ["\xE2\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA5"],
        ["\xE2\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA6"],
        ["\xE2\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA7"],
        ["\xE2\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA8"],
        ["\xE2\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA9"],
        ["\xE2\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAA"],
        ["\xE2\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAB"],
        ["\xE2\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAC"],
        ["\xE2\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAD"],
        ["\xE2\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAE"],
        ["\xE2\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAF"],
        ["\xE2\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB0"],
        ["\xE2\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB1"],
        ["\xE2\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB2"],
        ["\xE2\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB3"],
        ["\x41\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA0"],
        ["\x41\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA1"],
        ["\x41\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA2"],
        ["\x41\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA3"],
        ["\x41\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA4"],
        ["\x41\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA5"],
        ["\x41\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA6"],
        ["\x41\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA7"],
        ["\x41\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA8"],
        ["\x41\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA9"],
        ["\xE8\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x89"],
        ["\xE8\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x94"],
        ["\xE8\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA2"],
        ["\xE8\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x8D"],
        ["\xE8\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x98"],
        ["\xE8\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA7"],
        ["\xE8\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x83"],
        ["\xE8\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xB6"],
        ["\xE8\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x91"],
        ["\xE8\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x97"],
        ["\xE8\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x8D"],
        ["\xE8\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA6"],
        ["\xE8\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA3"],
        ["\xE8\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xAB"],
        ["\xE8\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x8A"],
        ["\xE8\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xBB"],
        ["\xE8\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9C"],
        ["\xE8\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9D"],
        ["\xE8\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9E"],
        ["\xE8\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x8E"],
        ["\xE8\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x8F"],
        ["\xE9\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F\x84"],
        ["\xE8\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\xA1"],
        ["\xE8\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBB"],
        ["\xE6\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9D"],
        ["\xE6\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9F"],
        ["\x44\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x96"],
        ["\xE9\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F\x8D"],
        ["\x44\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\xA1"],
        ["\xE7\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA4"],
        ["\xE7\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA5"],
        ["\xE7\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA6"],
        ["\xE7\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA7"],
        ["\xE7\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA8"],
        ["\x44\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB1"],
        ["\xE6\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB2"],
        ["\xE6\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB9"],
        ["\xE8\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBE"],
        ["\xE8\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBD"],
        ["\xE8\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBC"],
        ["\xDF\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAE"],
        ["\xDF\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x91"],
        ["\xDF\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9F"],
        ["\xE0\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\xBF"],
        ["\x48\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9C"],
        ["\x54\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x96"],
        ["\x55\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x83"],
        ["\x46\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xBF"],
        ["\x4E\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x80"],
        ["\x45\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9B"],
        ["\x4F\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xA8"],
        ["\x51\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xB6"],
        ["\x4D\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA2"],
        ["\x50\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB5"],
        ["\x50\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x9C"],
        ["\x50\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x90"],
        ["\x49\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xAA"],
        ["\x4D\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA1"],
        ["\x4E\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA5"],
        ["\x47\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xAD"],
        ["\x4E\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA6"],
        ["\x4A\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA6"],
        ["\x67\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB5"],
        ["\x50\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x93"],
        ["\x47\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA7"],
        ["\x55\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA1"],
        ["\x4C\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB1"],
        ["\x50\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9B"],
        ["\x54\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x90"],
        ["\x51\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xBB"],
        ["\x52\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xB4"],
        ["\x4E\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA2"],
        ["\x49\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBE"],
        ["\x4F\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x8E"],
        ["\x4D\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x96"],
        ["\x4B\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x9F"],
        ["\x54\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB7"],
        ["\x45\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x89"],
        ["\x4E\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB5"],
        ["\x54\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x89"],
        ["\x4B\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x97"],
        ["\x48\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x88"],
        ["\x53\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x87"],
        ["\x50\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x8D"],
        ["\x50\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8F"],
        ["\x46\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA5"],
        ["\x45\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8A"],
        ["\x47\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8D"],
        ["\x4A\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x9D"],
        ["\x4D\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x89"],
        ["\x4A\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB2"],
        ["\x51\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB7"],
        ["\x48\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x94"],
        ["\x4C\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x81"],
        ["\x51\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x89"],
        ["\x4F\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9F"],
        ["\x47\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8F"],
        ["\x4F\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB0"],
        ["\x47\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x93"],
        ["\x4F\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x85"],
        ["\x49\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xBA"],
        ["\x55\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8F"],
        ["\x4A\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB0"],
        ["\x49\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xBB"],
        ["\x48\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAD"],
        ["\x4E\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xAF"],
        ["\x4D\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x83"],
        ["\x54\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8E"],
        ["\x4A\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA3"],
        ["\x55\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x82"],
        ["\x49\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x95"],
        ["\x4C\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBA"],
        ["\x4A\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBB"],
        ["\x45\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x95"],
        ["\x4F\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA5"],
        ["\x48\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x9F"],
        ["\x48\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB2"],
        ["\x49\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x81"],
        ["\x48\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xAF"],
        ["\x45\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x80"],
        ["\x4E\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB1"],
        ["\x52\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xA2"],
        ["\x4A\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB8"],
        ["\x47\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB2"],
        ["\x47\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xA8"],
        ["\x51\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8B"],
        ["\x55\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAF"],
        ["\x4C\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x81"],
        ["\x47\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB0"],
        ["\x52\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBD"],
        ["\x46\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA1"],
        ["\x4A\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xA0"],
        ["\x52\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xBB"],
        ["\x46\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x95"],
        ["\x4B\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xB2"],
        ["\x55\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAB"],
        ["\x4E\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA4"],
        ["\x4E\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xAD"],
        ["\x49\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA2"],
        ["\x4C\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB0"],
        ["\x4E\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA0"],
        ["\x55\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xBB"],
        ["\x55\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8B"],
        ["\x48\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB3"],
        ["\x46\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x87"],
        ["\x50\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x8F"],
        ["\x47\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xBD"],
        ["\x55\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x82"],
        ["\x49\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA8"],
        ["\x4C\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xAF"],
        ["\x4B\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9C"],
        ["\x55\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBA"],
        ["\x4D\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x91"],
        ["\x4F\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x93"],
        ["\x4A\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBC"],
        ["\x51\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA6"],
        ["\x50\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x98"],
        ["\x4C\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x84"],
        ["\x55\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9D"],
        ["\x54\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x9A"],
        ["\x54\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xBB"],
        ["\x52\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA5"],
        ["\x53\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA9"],
        ["\x46\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA6"],
        ["\x4E\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x9C"],
        ["\x54\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8F"],
        ["\x52\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x82"],
        ["\x49\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x91"],
        ["\x46\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8B"],
        ["\x4A\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB2"],
        ["\x51\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x8F"],
        ["\x50\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x8C"],
        ["\x51\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA1"],
        ["\x48\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xB6"],
        ["\x55\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB0"],
        ["\x49\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB1"],
        ["\x47\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA0"],
        ["\x4E\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB3"],
        ["\x45\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x84"],
        ["\x45\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB8"],
        ["\x4F\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB3"],
        ["\x50\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA9"],
        ["\x4F\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9B"],
        ["\x51\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x88"],
        ["\x52\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8E"],
        ["\x55\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB4"],
        ["\x45\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB1"],
        ["\x47\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9B"],
        ["\x51\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA0"],
        ["\x4D\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xAD"],
        ["\x4A\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB2"],
        ["\x50\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xAB"],
        ["\x47\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8A"],
        ["\x49\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x85"],
        ["\x48\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA6"],
        ["\x54\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x81"],
        ["\x46\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x8A"],
        ["\x51\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xB2"],
        ["\x49\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x8E"],
        ["\x53\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xAD"],
        ["\x46\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x86"],
        ["\x47\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x92"],
        ["\x50\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB0"],
        ["\x52\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x84"],
        ["\x50\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB4"],
        ["\x47\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB6"],
        ["\x54\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA8"],
        ["\x55\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA9"],
        ["\x4A\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB4"],
        ["\x4E\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBF"],
        ["\x49\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x94"],
        ["\x4D\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x8E"],
        ["\x53\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x94"],
        ["\x4B\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x99"],
        ["\x50\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x95"],
        ["\x4C\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xBF"],
        ["\x4B\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x81"],
        ["\x4D\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB6"],
        ["\x50\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x91"],
        ["\x4C\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x97"],
        ["\x46\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA0"],
        ["\x49\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9B"],
        ["\x52\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9B"],
        ["\x47\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA9"],
        ["\x4D\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xBC"],
        ["\x4E\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9A"],
        ["\x55\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA5"],
        ["\x50\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB9"],
        ["\x47\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAE"],
        ["\x46\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA5"],
        ["\x4C\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x80"],
        ["\x48\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x9C"],
        ["\x49\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBC"],
        ["\x4F\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xBA"],
        ["\x45\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAA"],
        ["\x4A\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA7"],
        ["\x54\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB4"],
        ["\x49\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x8B"],
        ["\x4F\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x81"],
        ["\x54\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x96"],
        ["\x67\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAC"],
        ["\x54\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x8E"],
        ["\x4A\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x84"],
        ["\x45\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA1"],
        ["\x47\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x96"],
        ["\x49\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBB"],
        ["\x45\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x84"],
        ["\x45\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8B"],
        ["\x4E\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xB6"],
        ["\x54\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x86"],
        ["\x4E\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB6"],
        ["\x50\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA1"],
        ["\x4B\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x99"],
        ["\x4E\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xBA"],
        ["\x4E\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB8"],
        ["\x4C\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA9"],
        ["\x49\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA9"],
        ["\x50\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8F"],
        ["\x48\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB3"],
        ["\x45\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8B"],
        ["\x45\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x96"],
        ["\x4D\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xAE"],
        ["\x47\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x95"],
        ["\x54\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBD"],
        ["\x47\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xA1"],
        ["\x48\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB3"],
        ["\x45\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA0"],
        ["\x47\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAF"],
        ["\x47\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x89"],
        ["\x49\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8F"],
        ["\x4E\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x81"],
        ["\x46\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB6"],
        ["\x52\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA1"],
        ["\x48\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x91"],
        ["\x4F\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x87"],
        ["\x47\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9C"],
        ["\x4E\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB6"],
        ["\x46\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x8C"],
        ["\x46\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB3"],
        ["\x47\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAB"],
        ["\x4C\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x82"],
        ["\x52\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8D"],
        ["\x54\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBE"],
        ["\x4D\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBC"],
        ["\x4F\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x87"],
        ["\x46\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB1"],
        ["\x53\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9B"],
        ["\x54\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x84"],
        ["\x4B\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB7"],
        ["\x4B\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xAF"],
        ["\x4C\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x93"],
        ["\x51\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA6"],
        ["\x49\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB2"],
        ["\x52\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xA9"],
        ["\x4A\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA8"],
        ["\x53\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA6"],
        ["\x48\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8E"],
        ["\x4E\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x9E"],
        ["\x4F\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8A"],
        ["\x54\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x84"],
        ["\x4F\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA8"],
        ["\x49\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x91"],
        ["\x53\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x99"],
        ["\x46\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBB"],
        ["\x53\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA5"],
        ["\x4E\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBD"],
        ["\x55\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBE"],
        ["\x46\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x80"],
        ["\x47\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x85"],
        ["\x55\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x93"],
        ["\x53\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x95"],
        ["\x48\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8B"],
        ["\x45\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9A"],
        ["\x47\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA3"],
        ["\x46\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9E"],
        ["\x50\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x8A"],
        ["\x4E\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8A"],
        ["\x4B\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBB"],
        ["\x4C\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xAB"],
        ["\x4E\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAA"],
        ["\x50\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x94"],
        ["\x55\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA2"],
        ["\x4E\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x90"],
        ["\x4D\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x92"],
        ["\x53\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x90"],
        ["\x48\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB9"],
        ["\x52\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x81"],
        ["\x55\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA6"],
        ["\x46\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB0"],
        ["\x45\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB7"],
        ["\x4A\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB0"],
        ["\x47\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8C"],
        ["\x4A\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x86"],
        ["\x4A\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB5"],
        ["\x4F\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA5"],
        ["\x50\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB9"],
        ["\x46\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8B"],
        ["\x49\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8E"],
        ["\x49\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x9D"],
        ["\x51\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB1"],
        ["\x55\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xBE"],
        ["\x46\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x96"],
        ["\x53\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB3"],
        ["\x49\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB3"],
        ["\x50\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x96"],
        ["\x52\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA8"],
        ["\x4C\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x82"],
        ["\x4F\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xAF"],
        ["\x53\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8D"],
        ["\x4F\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8B"],
        ["\x4B\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x97"],
        ["\x4D\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB2"],
        ["\x54\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xA7"],
        ["\x55\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xB8"],
        ["\x55\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAC"],
        ["\x4B\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xA8"],
        ["\x55\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x99"],
        ["\x47\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA3"],
        ["\x4A\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBF"],
        ["\x62\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8E"],
        ["\x53\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x8E"],
        ["\x55\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x83"],
        ["\x55\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x87"],
        ["\x47\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x84"],
        ["\x54\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x93"],
        ["\x48\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xA1"],
        ["\x5B\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB9"],
        ["\x47\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBC"],
        ["\x4B\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB8"],
        ["\x50\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBB"],
        ["\x4D\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB2"],
        ["\x48\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBA"],
        ["\x4F\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xAB"],
        ["\x4A\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x9A"],
        ["\x47\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x92"],
        ["\x53\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xAB"],
        ["\x4A\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x83"],
        ["\x51\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xAD"],
        ["\x4A\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA3"],
        ["\x50\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x94"],
        ["\x4A\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA9"],
        ["\x45\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA6"],
        ["\x4D\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB3"],
        ["\x47\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBD"],
        ["\x47\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8D"],
        ["\x54\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8E"],
        ["\x4A\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x9B"],
        ["\x47\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA0"],
        ["\x4B\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAB"],
        ["\x4F\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xBF"],
        ["\x49\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB6"],
        ["\x55\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x8D"],
        ["\x46\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9F"],
        ["\x47\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB2"],
        ["\x54\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9D"],
        ["\x53\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB0"],
        ["\x4F\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAC"],
        ["\x47\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBB"],
        ["\x54\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x87"],
        ["\x4B\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x91"],
        ["\x48\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x9B"],
        ["\x54\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x90"],
        ["\x50\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x84"],
        ["\x4F\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x94"],
        ["\x53\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB9"],
        ["\x4F\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB6"],
        ["\x51\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9B"],
        ["\x4E\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBA"],
        ["\x54\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x84"],
        ["\x48\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xAA"],
        ["\x51\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x9C"],
        ["\x60\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x83"],
        ["\x49\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB2"],
        ["\x4A\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9C"],
        ["\x49\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x8C"],
        ["\x54\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x9B"],
        ["\x4C\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xA8"],
        ["\x52\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA2"],
        ["\x4B\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x85"],
        ["\x4F\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB1"],
        ["\x52\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA5"],
        ["\x4B\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x88"],
        ["\x4E\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x85"],
        ["\x49\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA6"],
        ["\x49\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xBE"],
        ["\x4F\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x83"],
        ["\x4E\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA0"],
        ["\x4B\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x92"],
        ["\x4C\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8A"],
        ["\x4B\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x98"],
        ["\x4C\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA7"],
        ["\x48\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBB"],
        ["\x52\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9A"],
        ["\x4F\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xAA"],
        ["\x55\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA6"],
        ["\x48\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8C"],
        ["\x49\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x98"],
        ["\x47\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9B"],
        ["\x4A\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB2"],
        ["\x48\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB9"],
        ["\x4D\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA3"],
        ["\x47\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9F"],
        ["\x4D\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA3"],
        ["\x51\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xBE"],
        ["\x49\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x9B"],
        ["\x4F\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA2"],
        ["\x4E\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x91"],
        ["\x53\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x93"],
        ["\x55\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xBA"],
        ["\x4E\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBE"],
        ["\x4D\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x93"],
        ["\x4E\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x97"],
        ["\x4F\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA2"],
        ["\x54\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x97"],
        ["\x5D\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x85"],
        ["\x4A\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xB0"],
        ["\x4B\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x98"],
        ["\x49\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA3"],
        ["\x4D\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x8B"],
        ["\x52\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xBF"],
        ["\x46\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xA1"],
        ["\x4B\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA1"],
        ["\x4C\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA9"],
        ["\x50\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xB6"],
        ["\x54\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB0"],
        ["\x4C\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9D"],
        ["\x4C\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA6"],
        ["\x51\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9E"],
        ["\x48\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB3"],
        ["\x63\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8C"],
        ["\x49\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAB"],
        ["\x4D\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x84"],
        ["\x4E\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x91"],
        ["\x45\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x93"],
        ["\x4D\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x91"],
        ["\x45\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA2"],
        ["\x4F\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA5"],
        ["\x4E\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x93"],
        ["\x48\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA8"],
        ["\x4C\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x98"],
        ["\x46\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB8"],
        ["\x49\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAB"],
        ["\x47\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB8"],
        ["\x49\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x8C"],
        ["\x4E\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA9"],
        ["\x54\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x8C"],
        ["\x49\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xBC"],
        ["\x45\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA9"],
        ["\x55\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xAB"],
        ["\x55\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8B"],
        ["\x51\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x81"],
        ["\x53\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x91"],
        ["\x48\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x94"],
        ["\x4C\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x98"],
        ["\x47\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x81"],
        ["\x4E\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8E"],
        ["\x4B\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB1"],
        ["\x45\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9C"],
        ["\x45\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA8"],
        ["\x46\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBA"],
        ["\x4D\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x87"],
        ["\x4F\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x89"],
        ["\x49\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x84"],
        ["\x47\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x90"],
        ["\x4A\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x8C"],
        ["\x4B\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBE"],
        ["\x50\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x8C"],
        ["\x4B\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xAE"],
        ["\x4D\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBA"],
        ["\x4D\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x97"],
        ["\x4B\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA2"],
        ["\x46\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9F"],
        ["\x4E\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8B"],
        ["\x4E\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x84"],
        ["\x45\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x9F"],
        ["\x49\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB0"],
        ["\x4A\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x85"],
        ["\x45\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x97"],
        ["\x49\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBD"],
        ["\x50\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xBF"],
        ["\x4E\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x88"],
        ["\x4A\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA3"],
        ["\x52\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x80"],
        ["\x46\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x80"],
        ["\x55\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xBD"],
        ["\x46\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8F"],
        ["\x47\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x98"],
        ["\x48\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB4"],
        ["\x48\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB7"],
        ["\x4D\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8C"],
        ["\x47\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9D"],
        ["\x53\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xA2"],
        ["\x50\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x8E"],
        ["\x4A\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xBC"],
        ["\x47\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x80"],
        ["\x50\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xBD"],
        ["\x49\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x80"],
        ["\x53\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x93"],
        ["\x4D\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9C"],
        ["\x4F\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAF"],
        ["\x48\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x80"],
        ["\x4F\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xAC"],
        ["\x51\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBA"],
        ["\x4F\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA0"],
        ["\x4C\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x91"],
        ["\x51\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x87"],
        ["\x45\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA9"],
        ["\x51\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xBB"],
        ["\x52\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xBC"],
        ["\x47\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB0"],
        ["\x55\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAC"],
        ["\x46\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8A"],
        ["\x51\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA0"],
        ["\x45\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x89"],
        ["\x55\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x83"],
        ["\x4D\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAB"],
        ["\x53\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x94"],
        ["\x4B\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x98"],
        ["\x4B\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB0"],
        ["\x52\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA7"],
        ["\x4A\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB5"],
        ["\x55\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8D"],
        ["\x4A\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB4"],
        ["\x4A\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA2"],
        ["\x4D\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x9A"],
        ["\x52\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x90"],
        ["\x4B\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x86"],
        ["\x4D\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x98"],
        ["\x45\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x85"],
        ["\x50\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x87"],
        ["\x4A\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x91"],
        ["\x48\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8A"],
        ["\x4B\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB8"],
        ["\x45\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xAE"],
        ["\x4B\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x93"],
        ["\x47\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA5"],
        ["\x4C\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x91"],
        ["\x50\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBD"],
        ["\x49\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x82"],
        ["\x50\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB2"],
        ["\x4D\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA3"],
        ["\x54\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB8"],
        ["\x48\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x83"],
        ["\x49\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB6"],
        ["\x50\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAE"],
        ["\x51\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x88"],
        ["\x49\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9A"],
        ["\x51\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBE"],
        ["\x47\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA6"],
        ["\x4C\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA7"],
        ["\x49\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9B"],
        ["\x4A\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xBB"],
        ["\x48\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x85"],
        ["\x4A\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA8"],
        ["\x4F\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x92"],
        ["\x4D\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xA0"],
        ["\x4B\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x99"],
        ["\x52\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA0"],
        ["\x4F\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9A"],
        ["\x4A\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB1"],
        ["\x4D\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9D"],
        ["\x51\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB8"],
        ["\x4B\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x81"],
        ["\x55\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xA6"],
        ["\x48\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x9A"],
        ["\x4B\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA8"],
        ["\x4B\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAB"],
        ["\x45\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAC"],
        ["\x48\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x9B"],
        ["\x52\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xA0"],
        ["\x55\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x91"],
        ["\x55\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x87"],
        ["\x49\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB6"],
        ["\x47\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB1"],
        ["\x51\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB6"],
        ["\x47\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x94"],
        ["\x4D\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA1"],
        ["\x53\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBF"],
        ["\x4D\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAB"],
        ["\x4C\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAC"],
        ["\x4A\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x83"],
        ["\x51\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA1"],
        ["\x46\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB7"],
        ["\x53\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8A"],
        ["\x55\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAF"],
        ["\x4B\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x90"],
        ["\x49\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAD"],
        ["\x55\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x9F"],
        ["\x47\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x99"],
        ["\x45\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x8B"],
        ["\x4A\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x81"],
        ["\x4E\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x82"],
        ["\x4C\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xAD"],
        ["\x51\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAF"],
        ["\x4B\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB8"],
        ["\x50\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x85"],
        ["\x46\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x88"],
        ["\x55\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8E"],
        ["\x49\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xB7"],
        ["\x4A\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA1"],
        ["\x4A\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xBF"],
        ["\x51\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x97"],
        ["\x4C\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x9A"],
        ["\x4D\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB0"],
        ["\x4E\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9D"],
        ["\x68\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xAD"],
        ["\x4C\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x81"],
        ["\x45\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAD"],
        ["\x48\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x80"],
        ["\x49\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB2"],
        ["\x49\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB5"],
        ["\x45\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x89"],
        ["\x49\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x90"],
        ["\x55\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x81"],
        ["\x4F\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x85"],
        ["\x49\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA4"],
        ["\x49\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x87"],
        ["\x4A\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBE"],
        ["\x4B\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA6"],
        ["\x54\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA4"],
        ["\x4B\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA3"],
        ["\x4C\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBD"],
        ["\x4C\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB4"],
        ["\x4D\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x81"],
        ["\x55\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBD"],
        ["\x4B\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8B"],
        ["\x4B\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8A"],
        ["\x4D\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB9"],
        ["\x4C\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8C"],
        ["\x4A\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBF"],
        ["\x54\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x9F"],
        ["\x4D\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xB9"],
        ["\x46\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x91"],
        ["\x45\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x91"],
        ["\x50\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9F"],
        ["\x47\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x80"],
        ["\x45\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9D"],
        ["\x4F\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xB6"],
        ["\x4C\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA5"],
        ["\x45\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBA"],
        ["\x52\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x97"],
        ["\x4D\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x96"],
        ["\x4E\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA9"],
        ["\x4A\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA6"],
        ["\x53\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAF"],
        ["\x4C\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x86"],
        ["\x4F\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x88"],
        ["\x49\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x92"],
        ["\x47\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB7"],
        ["\x52\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9A"],
        ["\x55\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9E"],
        ["\x4E\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xB0"],
        ["\x47\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBA"],
        ["\x50\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB6"],
        ["\x55\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x93"],
        ["\x49\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x87"],
        ["\x4B\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x85"],
        ["\x4C\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB2"],
        ["\x4D\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9B"],
        ["\x4B\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA7"],
        ["\x54\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x91"],
        ["\x4D\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x88"],
        ["\x4D\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x98"],
        ["\x50\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x9F"],
        ["\x4F\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x93"],
        ["\x4D\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB4"],
        ["\x52\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA1"],
        ["\x4A\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAA"],
        ["\x46\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x8A"],
        ["\x4C\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x88"],
        ["\x4E\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x82"],
        ["\x47\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x97"],
        ["\x4B\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xB0"],
        ["\x48\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x91"],
        ["\x4F\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xAC"],
        ["\x49\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB2"],
        ["\x47\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9B"],
        ["\x49\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAB"],
        ["\x4B\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x93"],
        ["\x47\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA4"],
        ["\x48\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8D"],
        ["\x49\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA1"],
        ["\x53\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA6"],
        ["\x4F\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x88"],
        ["\x53\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x81"],
        ["\x48\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x82"],
        ["\x4A\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xBE"],
        ["\x4C\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x91"],
        ["\x4B\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x84"],
        ["\x47\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x93"],
        ["\x49\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xAD"],
        ["\x4C\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAA"],
        ["\x46\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x8B"],
        ["\x4C\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x91"],
        ["\x46\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA2"],
        ["\x4E\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x84"],
        ["\x46\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB5"],
        ["\x48\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB6"],
        ["\x4E\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA7"],
        ["\x51\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA9"],
        ["\x4D\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB2"],
        ["\x4E\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xBA"],
        ["\x47\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xAC"],
        ["\x49\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAF"],
        ["\x49\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x82"],
        ["\x51\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x93"],
        ["\x51\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA6"],
        ["\x4F\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBD"],
        ["\x48\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBB"],
        ["\x46\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8C"],
        ["\x4A\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x99"],
        ["\x53\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8B"],
        ["\x55\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAB"],
        ["\x4E\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x8E"],
        ["\x53\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x8A"],
        ["\x4D\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8D"],
        ["\x45\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x88"],
        ["\x54\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA3"],
        ["\x4A\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xA6"],
        ["\x48\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBD"],
        ["\x66\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x9A"],
        ["\x4D\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x8F"],
        ["\x49\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB8"],
        ["\x4B\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x8E"],
        ["\x4D\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA8"],
        ["\x49\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x87"],
        ["\x54\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9F"],
        ["\x4A\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x83"],
        ["\x4B\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x80"],
        ["\x53\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x99"],
        ["\x50\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x81"],
        ["\x4F\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x91"],
        ["\x4C\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA0"],
        ["\x47\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBA"],
        ["\x4A\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x94"],
        ["\x4B\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB4"],
        ["\x46\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x90"],
        ["\x4B\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x80"],
        ["\x54\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA3"],
        ["\x45\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x88"],
        ["\x48\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB6"],
        ["\x52\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xB9"],
        ["\x52\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA6"],
        ["\x46\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xA5"],
        ["\x48\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xBC"],
        ["\x4B\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB8"],
        ["\x4C\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA3"],
        ["\x4F\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA7"],
        ["\x4F\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8F"],
        ["\x4A\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x85"],
        ["\x4E\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x8C"],
        ["\x46\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBA"],
        ["\x47\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xB2"],
        ["\x4D\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB8"],
        ["\x50\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB3"],
        ["\x54\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB2"],
        ["\x48\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9C"],
        ["\x48\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA9"],
        ["\x54\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xBD"],
        ["\x4A\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAC"],
        ["\x4F\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAE"],
        ["\x46\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x94"],
        ["\x53\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAF"],
        ["\x49\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB9"],
        ["\x45\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x8C"],
        ["\x4B\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA9"],
        ["\x45\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8B"],
        ["\x49\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x99"],
        ["\x47\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA2"],
        ["\x4E\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x92"],
        ["\x4E\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA3"],
        ["\x4E\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xB5"],
        ["\x4A\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xBA"],
        ["\x4A\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x95"],
        ["\x48\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x93"],
        ["\x4C\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xB8"],
        ["\x46\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x83"],
        ["\x45\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x9F"],
        ["\x4C\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB3"],
        ["\x50\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBB"],
        ["\x4E\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA6"],
        ["\x47\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9B"],
        ["\x47\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x90"],
        ["\x4C\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x84"],
        ["\x46\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xBE"],
        ["\x55\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x83"],
        ["\x53\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB7"],
        ["\x47\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x80"],
        ["\x55\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xBA"],
        ["\x48\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x90"],
        ["\x54\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8E"],
        ["\x49\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8B"],
        ["\x45\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA4"],
        ["\x4A\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBC"],
        ["\x4A\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBA"],
        ["\x53\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x91"],
        ["\x4E\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA4"],
        ["\x47\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB1"],
        ["\x45\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAB"],
        ["\x53\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA7"],
        ["\x45\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB8"],
        ["\x4A\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x85"],
        ["\x50\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xAF"],
        ["\x4D\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x96"],
        ["\x51\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x90"],
        ["\x54\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x8A"],
        ["\x4F\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB4"],
        ["\x4C\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA1"],
        ["\x4D\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA1"],
        ["\x51\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB0"],
        ["\x4A\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x8E"],
        ["\x4E\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x87"],
        ["\x55\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA8"],
        ["\x55\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB7"],
        ["\x4C\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x87"],
        ["\x4E\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xA7"],
        ["\x4F\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x93"],
        ["\x45\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x94"],
        ["\x4B\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x92"],
        ["\x4D\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8D"],
        ["\x45\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x88"],
        ["\x4A\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x89"],
        ["\x47\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBE"],
        ["\x50\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xAF"],
        ["\x45\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8C"],
        ["\x46\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA1"],
        ["\x4A\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9F"],
        ["\x52\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA7"],
        ["\x55\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x8E"],
        ["\x53\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9A"],
        ["\x4F\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x81"],
        ["\x48\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x9E"],
        ["\x4D\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA4"],
        ["\x49\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB7"],
        ["\x51\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x90"],
        ["\x4E\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9E"],
        ["\x4F\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x89"],
        ["\x47\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA4"],
        ["\x54\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBC"],
        ["\x53\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAF"],
        ["\x4C\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x99"],
        ["\x53\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x96"],
        ["\x45\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x89"],
        ["\x46\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAC"],
        ["\x48\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x9F"],
        ["\x49\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB9"],
        ["\x51\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBE"],
        ["\x49\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x9A"],
        ["\x45\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA3"],
        ["\x46\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x91"],
        ["\x51\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8E"],
        ["\x52\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x89"],
        ["\x4E\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x91"],
        ["\x54\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA2"],
        ["\x46\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xBD"],
        ["\x4B\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x94"],
        ["\x45\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9D"],
        ["\x46\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8F"],
        ["\x45\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA5"],
        ["\x4C\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA7"],
        ["\x53\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB7"],
        ["\x45\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB8"],
        ["\x45\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x83"],
        ["\x51\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x9A"],
        ["\x46\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB7"],
        ["\x45\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x98"],
        ["\x47\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x92"],
        ["\x53\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8C"],
        ["\x4A\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x97"],
        ["\x50\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x98"],
        ["\x4C\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA7"],
        ["\x4B\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBB"],
        ["\x5B\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x82"],
        ["\x48\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x83"],
        ["\x4A\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB4"],
        ["\x50\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAD"],
        ["\x48\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA1"],
        ["\x52\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x97"],
        ["\x47\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8B"],
        ["\x45\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9F"],
        ["\x4F\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAA"],
        ["\x46\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA9"],
        ["\x48\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAF"],
        ["\x4A\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9D"],
        ["\x48\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB2"],
        ["\x4C\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x87"],
        ["\x4A\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAC"],
        ["\x4F\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBF"],
        ["\x51\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA0"],
        ["\x4B\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x85"],
        ["\x4C\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x98"],
        ["\x50\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9E"],
        ["\x48\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB1"],
        ["\x49\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x95"],
        ["\x47\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x83"],
        ["\x50\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAF"],
        ["\x52\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB1"],
        ["\x52\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x94"],
        ["\x51\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x8F"],
        ["\x48\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAA"],
        ["\x46\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x92"],
        ["\x45\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x8C"],
        ["\x4B\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA1"],
        ["\x4A\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9B"],
        ["\x4A\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA2"],
        ["\x4E\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBC"],
        ["\x50\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x8A"],
        ["\x4D\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB5"],
        ["\x48\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xB1"],
        ["\x5F\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xBF"],
        ["\x46\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBC"],
        ["\x54\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA4"],
        ["\x49\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8D"],
        ["\x4A\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x85"],
        ["\x46\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x99"],
        ["\x45\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x98"],
        ["\x4D\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xBB"],
        ["\x49\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9B"],
        ["\x54\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAB"],
        ["\x48\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB7"],
        ["\x45\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x88"],
        ["\x55\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x95"],
        ["\x55\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB7"],
        ["\x53\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA0"],
        ["\x4C\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAA"],
        ["\x50\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x9F"],
        ["\x52\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB9"],
        ["\x47\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8B"],
        ["\x4B\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xBB"],
        ["\x49\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x8A"],
        ["\x45\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBD"],
        ["\x4E\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x80"],
        ["\x51\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB7"],
        ["\x50\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA0"],
        ["\x46\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x92"],
        ["\x4E\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x84"],
        ["\x54\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x89"],
        ["\x4B\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB0"],
        ["\x54\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x91"],
        ["\x50\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBD"],
        ["\x54\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9A"],
        ["\x4A\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xA8"],
        ["\x50\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x9B"],
        ["\x48\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBC"],
        ["\x4D\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA4"],
        ["\x49\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x83"],
        ["\x45\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8A"],
        ["\x4B\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB0"],
        ["\x53\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA4"],
        ["\x54\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBE"],
        ["\x4A\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x9A"],
        ["\x53\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA8"],
        ["\x4E\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x87"],
        ["\x54\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8F"],
        ["\x4F\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x86"],
        ["\x46\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB9"],
        ["\x53\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB1"],
        ["\x4B\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB7"],
        ["\x53\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x95"],
        ["\x4C\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBA"],
        ["\x55\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAE"],
        ["\x50\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x82"],
        ["\x55\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9B"],
        ["\x45\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x90"],
        ["\x50\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x89"],
        ["\x51\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x86"],
        ["\x4E\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAF"],
        ["\x48\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA6"],
        ["\x49\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xAE"],
        ["\x47\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBB"],
        ["\x4E\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x99"],
        ["\x51\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB3"],
        ["\x49\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x82"],
        ["\x51\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x90"],
        ["\x4D\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x96"],
        ["\x4F\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9F"],
        ["\x4E\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x90"],
        ["\x48\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA7"],
        ["\x54\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xAB"],
        ["\x4B\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB5"],
        ["\x4C\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xAC"],
        ["\x48\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8D"],
        ["\x46\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x80"],
        ["\x4A\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x89"],
        ["\x53\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x9E"],
        ["\x49\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBB"],
        ["\x4E\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB0"],
        ["\x4D\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA9"],
        ["\x49\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8D"],
        ["\x4B\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA1"],
        ["\x4D\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBD"],
        ["\x48\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB3"],
        ["\x47\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x88"],
        ["\x4C\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xBD"],
        ["\x53\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x87"],
        ["\x53\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x80"],
        ["\x4C\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x95"],
        ["\x54\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA6"],
        ["\x4C\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xAD"],
        ["\x47\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x8E"],
        ["\x47\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB0"],
        ["\x4B\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x9C"],
        ["\x49\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x81"],
        ["\x4D\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x89"],
        ["\x47\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x9B"],
        ["\x47\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA4"],
        ["\x47\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA8"],
        ["\x46\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x90"],
        ["\x4C\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAA"],
        ["\x49\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA1"],
        ["\x50\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB4"],
        ["\x45\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x82"],
        ["\x45\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAA"],
        ["\x4A\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xBA"],
        ["\x4B\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x8A"],
        ["\x54\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB4"],
        ["\x4C\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB2"],
        ["\x45\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x8E"],
        ["\x46\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBC"],
        ["\x52\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x95"],
        ["\x50\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xBA"],
        ["\x45\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9C"],
        ["\x4A\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8A"],
        ["\x4F\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8B"],
        ["\x50\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xBE"],
        ["\x48\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA8"],
        ["\x4F\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x94"],
        ["\x51\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB5"],
        ["\x54\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x84"],
        ["\x46\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x96"],
        ["\x4C\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA2"],
        ["\x50\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAF"],
        ["\x47\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9C"],
        ["\x53\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAD"],
        ["\x49\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB9"],
        ["\x54\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x99"],
        ["\x4E\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8A"],
        ["\x48\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB7"],
        ["\x4B\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9F"],
        ["\x4F\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB6"],
        ["\x4C\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAE"],
        ["\x4F\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA6"],
        ["\x48\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAD"],
        ["\x49\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBA"],
        ["\x4C\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA9"],
        ["\x4A\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x91"],
        ["\x52\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x90"],
        ["\x4F\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x96"],
        ["\x55\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8C"],
        ["\x55\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x86"],
        ["\x4E\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAB"],
        ["\x4D\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xBF"],
        ["\x54\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x92"],
        ["\x45\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x89"],
        ["\x50\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x98"],
        ["\x48\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x82"],
        ["\x45\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB1"],
        ["\x50\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA8"],
        ["\x53\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x92"],
        ["\x4A\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA3"],
        ["\x51\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9F"],
        ["\x54\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA6"],
        ["\x53\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8A"],
        ["\x45\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA3"],
        ["\x48\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x97"],
        ["\x55\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x82"],
        ["\x4F\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x95"],
        ["\x51\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x83"],
        ["\x4D\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9B"],
        ["\x48\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB8"],
        ["\x55\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x90"],
        ["\x4E\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAC"],
        ["\x50\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xAB"],
        ["\x49\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8B"],
        ["\x48\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x95"],
        ["\x54\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x94"],
        ["\x50\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBA"],
        ["\x48\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBF"],
        ["\x4B\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xBA"],
        ["\x45\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB8"],
        ["\x47\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB2"],
        ["\x4B\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA3"],
        ["\x45\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9B"],
        ["\x46\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAB"],
        ["\x49\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x8B"],
        ["\x4C\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x89"],
        ["\x4B\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xBF"],
        ["\x45\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x90"],
        ["\x55\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8D"],
        ["\x45\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x82"],
        ["\x4A\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAB"],
        ["\x46\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x97"],
        ["\x46\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9D"],
        ["\x47\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x87"],
        ["\x47\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAF"],
        ["\x4F\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9C"],
        ["\x4E\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAF"],
        ["\x48\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xBD"],
        ["\x4D\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA8"],
        ["\x46\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9D"],
        ["\x48\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA2"],
        ["\x49\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xBB"],
        ["\x48\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x8F"],
        ["\x51\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x85"],
        ["\x4F\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x89"],
        ["\x46\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x81"],
        ["\x46\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB8"],
        ["\x46\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x99"],
        ["\x4A\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAB"],
        ["\x53\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA2"],
        ["\x48\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x82"],
        ["\x4A\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xB3"],
        ["\x4A\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x96"],
        ["\x4E\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x9E"],
        ["\x4C\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA9"],
        ["\x49\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA6"],
        ["\x4B\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x8C"],
        ["\x4F\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAE"],
        ["\x46\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x87"],
        ["\x4F\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9C"],
        ["\x52\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8C"],
        ["\x4A\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBC"],
        ["\x4A\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xAF"],
        ["\x45\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8B"],
        ["\x4B\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBC"],
        ["\x4F\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8D"],
        ["\x46\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x90"],
        ["\x48\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x97"],
        ["\x46\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBA"],
        ["\x4C\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x88"],
        ["\x46\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x81"],
        ["\x46\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x82"],
        ["\x45\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA1"],
        ["\x48\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x8B"],
        ["\x45\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBB"],
        ["\x4C\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBE"],
        ["\x52\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xBD"],
        ["\x51\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x94"],
        ["\x4A\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x81"],
        ["\x48\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBA"],
        ["\x51\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8C"],
        ["\x4C\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB3"],
        ["\x45\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xAA"],
        ["\x4F\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x94"],
        ["\x4D\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9E"],
        ["\x50\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x90"],
        ["\x46\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xBF"],
        ["\x46\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8F"],
        ["\x4A\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x98"],
        ["\x50\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAB"],
        ["\x54\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xBA"],
        ["\x4B\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xB8"],
        ["\x4C\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8D"],
        ["\x52\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xAB"],
        ["\x45\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x83"],
        ["\x50\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB1"],
        ["\x4D\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB7"],
        ["\x49\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB1"],
        ["\x53\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x89"],
        ["\x47\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA4"],
        ["\x54\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x89"],
        ["\x4C\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xBF"],
        ["\x4D\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x86"],
        ["\x51\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBE"],
        ["\x46\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xAA"],
        ["\x45\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9F"],
        ["\x52\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x80"],
        ["\x48\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA0"],
        ["\x54\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB2"],
        ["\x47\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB4"],
        ["\x49\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x9D"],
        ["\x55\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA1"],
        ["\x62\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8A"],
        ["\x4F\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9E"],
        ["\x4C\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8E"],
        ["\x48\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x99"],
        ["\x49\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x84"],
        ["\x4B\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA8"],
        ["\x51\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA6"],
        ["\x4B\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9C"],
        ["\x4C\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xAE"],
        ["\x46\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBE"],
        ["\x4F\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x97"],
        ["\x46\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x85"],
        ["\x4D\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9D"],
        ["\x46\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8A"],
        ["\x54\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAE"],
        ["\x4F\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x87"],
        ["\x4E\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xAA"],
        ["\x4A\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9F"],
        ["\x54\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBA"],
        ["\x4C\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBA"],
        ["\x54\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x93"],
        ["\x54\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xBC"],
        ["\x53\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB5"],
        ["\x52\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8C"],
        ["\x4D\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x88"],
        ["\x52\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAB"],
        ["\x46\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA5"],
        ["\x4F\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x82"],
        ["\x4B\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB1"],
        ["\x54\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB9"],
        ["\x47\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBB"],
        ["\x46\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x96"],
        ["\x46\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x88"],
        ["\x45\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8B"],
        ["\x4D\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB1"],
        ["\x48\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8A"],
        ["\x4A\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA9"],
        ["\x4B\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA0"],
        ["\x46\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xAE"],
        ["\x51\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xAB"],
        ["\x4C\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xA3"],
        ["\x47\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x92"],
        ["\x49\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x96"],
        ["\x54\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x92"],
        ["\x48\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x97"],
        ["\x54\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xAA"],
        ["\x46\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBF"],
        ["\x4C\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x88"],
        ["\x46\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB9"],
        ["\x51\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAC"],
        ["\x47\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x80"],
        ["\x50\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9A"],
        ["\x47\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8E"],
        ["\x48\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xA8"],
        ["\x47\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x97"],
        ["\x4B\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB1"],
        ["\x47\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9E"],
        ["\x46\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xAE"],
        ["\x52\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x81"],
        ["\x4D\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBE"],
        ["\x4B\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB2"],
        ["\x45\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x80"],
        ["\x46\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x8B"],
        ["\x49\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x82"],
        ["\x52\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8D"],
        ["\x4A\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x92"],
        ["\x4D\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xAD"],
        ["\x4B\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9F"],
        ["\x4F\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x90"],
        ["\x4B\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x86"],
        ["\x4D\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB2"],
        ["\x53\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x90"],
        ["\x52\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB4"],
        ["\x55\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xAF"],
        ["\x4A\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB1"],
        ["\x55\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8B"],
        ["\x51\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xAC"],
        ["\x47\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x86"],
        ["\x53\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x9C"],
        ["\x53\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x80"],
        ["\x46\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8F"],
        ["\x48\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x85"],
        ["\x45\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x81"],
        ["\x48\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x93"],
        ["\x51\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8E"],
        ["\x4D\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x94"],
        ["\x4D\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x81"],
        ["\x48\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x8B"],
        ["\x4F\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xA3"],
        ["\x4E\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA6"],
        ["\x45\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8D"],
        ["\x4C\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x83"],
        ["\x4F\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x94"],
        ["\x54\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x99"],
        ["\x48\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xBF"],
        ["\x4A\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x91"],
        ["\x4C\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9D"],
        ["\x49\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xAE"],
        ["\x4F\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x9B"],
        ["\x52\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xBE"],
        ["\x4E\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x9F"],
        ["\x45\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBA"],
        ["\x48\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x93"],
        ["\x4A\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB0"],
        ["\x46\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8A"],
        ["\x50\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBB"],
        ["\x46\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA5"],
        ["\x4D\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xAC"],
        ["\x54\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA3"],
        ["\x4F\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9C"],
        ["\x4C\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xBF"],
        ["\x4F\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x86"],
        ["\x4E\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAA"],
        ["\x4D\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xAC"],
        ["\x4F\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAF"],
        ["\x53\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x89"],
        ["\x48\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB3"],
        ["\x46\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x96"],
        ["\x4A\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA4"],
        ["\x50\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xBE"],
        ["\x47\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x94"],
        ["\x4D\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA1"],
        ["\x52\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB5"],
        ["\x51\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x87"],
        ["\x47\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x86"],
        ["\x48\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA6"],
        ["\x47\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x9D"],
        ["\x45\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x80"],
        ["\x4F\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x91"],
        ["\x51\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x99"],
        ["\x50\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9A"],
        ["\x50\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB6"],
        ["\x4A\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x92"],
        ["\x4C\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB2"],
        ["\x47\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB8"],
        ["\x53\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAF"],
        ["\x55\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xB7"],
        ["\x47\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB8"],
        ["\x46\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA9"],
        ["\x50\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x99"],
        ["\x46\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB3"],
        ["\x4D\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x8F"],
        ["\x50\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x90"],
        ["\x52\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x95"],
        ["\x52\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA4"],
        ["\x49\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA4"],
        ["\x4C\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB7"],
        ["\x4A\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9F"],
        ["\x45\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9D"],
        ["\x4E\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA0"],
        ["\x4E\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x87"],
        ["\x4F\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAC"],
        ["\x55\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA8"],
        ["\x46\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x86"],
        ["\x4D\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB1"],
        ["\x54\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x97"],
        ["\x4E\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA8"],
        ["\x53\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBE"],
        ["\x54\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xBC"],
        ["\x52\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB5"],
        ["\x49\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x86"],
        ["\x45\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8F"],
        ["\x48\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x91"],
        ["\x48\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x9A"],
        ["\x48\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x84"],
        ["\x4A\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x8A"],
        ["\x55\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA0"],
        ["\x49\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB0"],
        ["\x4C\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBF"],
        ["\x4E\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x84"],
        ["\x4B\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9B"],
        ["\x4E\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8C"],
        ["\x4D\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB7"],
        ["\x46\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x87"],
        ["\x46\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8C"],
        ["\x45\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAD"],
        ["\x4A\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB6"],
        ["\x45\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBE"],
        ["\x50\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA2"],
        ["\x53\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9F"],
        ["\x55\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB5"],
        ["\x46\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBC"],
        ["\x48\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x88"],
        ["\x4A\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x89"],
        ["\x51\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x98"],
        ["\x49\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xBC"],
        ["\x4D\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xA6"],
        ["\x47\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA7"],
        ["\x4E\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x87"],
        ["\x48\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x81"],
        ["\x49\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x9D"],
        ["\x51\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x81"],
        ["\x49\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA5"],
        ["\x4B\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xB0"],
        ["\x47\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA0"],
        ["\x49\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x91"],
        ["\x4B\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA7"],
        ["\x4C\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB9"],
        ["\x52\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x96"],
        ["\x51\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x96"],
        ["\x53\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x8B"],
        ["\x53\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x89"],
        ["\x4D\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9D"],
        ["\x4F\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB3"],
        ["\x50\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9F"],
        ["\x49\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBC"],
        ["\x4F\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x94"],
        ["\x4D\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB3"],
        ["\x49\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xA1"],
        ["\x4A\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9E"],
        ["\x50\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xA4"],
        ["\x4F\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA6"],
        ["\x53\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xBE"],
        ["\x4C\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x98"],
        ["\x4B\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x9C"],
        ["\x52\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x98"],
        ["\x45\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8A"],
        ["\x49\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x88"],
        ["\x4F\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x9E"],
        ["\x49\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x97"],
        ["\x52\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x97"],
        ["\x4D\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB0"],
        ["\x45\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8E"],
        ["\x45\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB4"],
        ["\x51\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8C"],
        ["\x4D\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xA2"],
        ["\x46\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB8"],
        ["\x48\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x85"],
        ["\x55\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBE"],
        ["\x47\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA1"],
        ["\x50\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x96"],
        ["\x4C\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x84"],
        ["\x48\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB6"],
        ["\x4E\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB3"],
        ["\x4E\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA3"],
        ["\x4A\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB8"],
        ["\x4B\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB2"],
        ["\x50\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB8"],
        ["\x4E\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA0"],
        ["\x50\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB1"],
        ["\x4F\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB4"],
        ["\x49\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBE"],
        ["\x4E\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAD"],
        ["\x47\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8D"],
        ["\x4E\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x96"],
        ["\x54\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAD"],
        ["\x48\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x94"],
        ["\x48\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB7"],
        ["\x47\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB2"],
        ["\x4C\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA6"],
        ["\x46\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9F"],
        ["\x53\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x95"],
        ["\x52\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB1"],
        ["\x49\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBB"],
        ["\x46\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB8"],
        ["\x45\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA1"],
        ["\x4F\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xB5"],
        ["\x4F\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x87"],
        ["\x52\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA0"],
        ["\x4B\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9D"],
        ["\x49\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA9"],
        ["\x46\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x83"],
        ["\x4A\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8E"],
        ["\x48\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xAF"],
        ["\x45\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB0"],
        ["\x4B\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8B"],
        ["\x45\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAE"],
        ["\x4D\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x9B"],
        ["\x4D\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB8"],
        ["\x47\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB1"],
        ["\x49\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB3"],
        ["\x54\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB9"],
        ["\x46\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9F"],
        ["\x45\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9E"],
        ["\x4C\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA6"],
        ["\x4E\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB3"],
        ["\x4A\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA3"],
        ["\x4F\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAF"],
        ["\x54\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAA"],
        ["\x48\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAA"],
        ["\x4D\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBA"],
        ["\x47\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAB"],
        ["\x4D\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9B"],
        ["\x46\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB2"],
        ["\x49\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9D"],
        ["\x4D\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x87"],
        ["\x45\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xBA"],
        ["\x47\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x81"],
        ["\x4F\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x83"],
        ["\x4D\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB5"],
        ["\x51\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAC"],
        ["\x4D\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8B"],
        ["\x4B\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9A"],
        ["\x4F\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBD"],
        ["\x52\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x8E"],
        ["\x50\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8A"],
        ["\x50\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x85"],
        ["\x4C\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA3"],
        ["\x66\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xAD"],
        ["\x52\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA5"],
        ["\x4B\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8F"],
        ["\x46\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x88"],
        ["\x4B\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA2"],
        ["\x47\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB3"],
        ["\x51\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA8"],
        ["\x4F\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x97"],
        ["\x49\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB9"],
        ["\x4B\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x82"],
        ["\x52\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xA5"],
        ["\x48\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA8"],
        ["\x45\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB4"],
        ["\x4F\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x8A"],
        ["\x52\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA1"],
        ["\x4F\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x8B"],
        ["\x4F\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA0"],
        ["\x4F\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB0"],
        ["\x4C\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x82"],
        ["\x4E\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x94"],
        ["\x53\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x90"],
        ["\x54\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x98"],
        ["\x4E\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8F"],
        ["\x4B\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9E"],
        ["\x52\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x84"],
        ["\x4C\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x87"],
        ["\x50\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xA9"],
        ["\x46\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB0"],
        ["\x52\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA2"],
        ["\x55\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xA8"],
        ["\x51\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x9B"],
        ["\x4E\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xAE"],
        ["\x46\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x89"],
        ["\x4F\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x99"],
        ["\x47\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x85"],
        ["\x55\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x97"],
        ["\x4F\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x80"],
        ["\x4C\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBE"],
        ["\x48\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x84"],
        ["\x51\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xBA"],
        ["\x4B\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB8"],
        ["\x46\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x96"],
        ["\x46\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xAC"],
        ["\x50\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9D"],
        ["\x4B\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAF"],
        ["\x52\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x84"],
        ["\x46\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB6"],
        ["\x47\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA2"],
        ["\x4F\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x93"],
        ["\x4A\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x81"],
        ["\x46\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA7"],
        ["\x45\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x90"],
        ["\x45\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBF"],
        ["\x47\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB4"],
        ["\x47\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x9F"],
        ["\x47\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB4"],
        ["\x53\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB2"],
        ["\x4D\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x96"],
        ["\x45\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA3"],
        ["\x45\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x85"],
        ["\x51\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB2"],
        ["\x45\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9F"],
        ["\x48\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9B"],
        ["\x46\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xBE"],
        ["\x4B\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x96"],
        ["\x49\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB0"],
        ["\x45\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBD"],
        ["\x45\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xBF"],
        ["\x46\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA0"],
        ["\x4F\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x93"],
        ["\x4A\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8B"],
        ["\x53\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9D"],
        ["\x53\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x92"],
        ["\x46\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x92"],
        ["\x46\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x99"],
        ["\x46\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x89"],
        ["\x47\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8E"],
        ["\x55\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x86"],
        ["\x4F\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xBB"],
        ["\x4B\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAD"],
        ["\x4E\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9C"],
        ["\x55\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9A"],
        ["\x51\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA5"],
        ["\x4C\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x94"],
        ["\x4A\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x90"],
        ["\x45\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xB3"],
        ["\x48\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8D"],
        ["\x4D\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8D"],
        ["\x48\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBE"],
        ["\x53\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x8A"],
        ["\x4B\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAC"],
        ["\x46\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA4"],
        ["\x4C\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA1"],
        ["\x53\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x9F"],
        ["\x50\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA9"],
        ["\x47\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x87"],
        ["\x52\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x99"],
        ["\x47\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA5"],
        ["\x4E\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x82"],
        ["\x49\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x98"],
        ["\x45\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xAD"],
        ["\x51\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x83"],
        ["\x47\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x80"],
        ["\x49\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xAC"],
        ["\x49\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xAA"],
        ["\x4A\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB6"],
        ["\x50\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8C"],
        ["\x53\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x89"],
        ["\x48\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x99"],
        ["\x47\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x88"],
        ["\x45\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x83"],
        ["\x49\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA0"],
        ["\x49\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA3"],
        ["\x49\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x82"],
        ["\x53\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x96"],
        ["\x45\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9D"],
        ["\x47\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA6"],
        ["\x4D\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x87"],
        ["\x53\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB0"],
        ["\x50\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x93"],
        ["\x55\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB4"],
        ["\x46\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x89"],
        ["\x46\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x85"],
        ["\x4A\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x97"],
        ["\x48\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x93"],
        ["\x4D\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9C"],
        ["\x54\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x8E"],
        ["\x55\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xBD"],
        ["\x4D\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8B"],
        ["\x4E\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBF"],
        ["\x51\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xAD"],
        ["\x46\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9A"],
        ["\x48\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8A"],
        ["\x55\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA8"],
        ["\x52\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xBA"],
        ["\x4F\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9B"],
        ["\x46\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB9"],
        ["\x4F\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA6"],
        ["\x51\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAE"],
        ["\x64\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8E"],
        ["\x50\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xB5"],
        ["\x48\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB8"],
        ["\x53\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB7"],
        ["\x4D\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xAD"],
        ["\x4C\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x91"],
        ["\x51\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x83"],
        ["\x4C\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAE"],
        ["\x45\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8D"],
        ["\x46\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x84"],
        ["\x4D\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB8"],
        ["\x47\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xB6"],
        ["\x46\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA8"],
        ["\x4F\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x85"],
        ["\x51\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x95"],
        ["\x50\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB3"],
        ["\x51\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x8E"],
        ["\x50\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x8C"],
        ["\x4E\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x91"],
        ["\x54\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA8"],
        ["\x4A\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAA"],
        ["\x51\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBE"],
        ["\x49\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBD"],
        ["\x53\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9A"],
        ["\x4E\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x99"],
        ["\x55\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8F"],
        ["\x51\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8E"],
        ["\x4C\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x8E"],
        ["\x4C\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x96"],
        ["\x4D\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x9F"],
        ["\x4D\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x97"],
        ["\x47\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA0"],
        ["\x46\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x84"],
        ["\x4C\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x87"],
        ["\x4C\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB4"],
        ["\x4F\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xBB"],
        ["\x54\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA1"],
        ["\x50\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xA0"],
        ["\x4E\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA7"],
        ["\x4B\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB5"],
        ["\x4B\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8C"],
        ["\x53\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA2"],
        ["\x45\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x89"],
        ["\x51\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAA"],
        ["\x4C\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAE"],
        ["\x4C\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x8F"],
        ["\x52\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBD"],
        ["\x52\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8B"],
        ["\x4A\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA4"],
        ["\x51\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x9D"],
        ["\x4B\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA3"],
        ["\x48\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB3"],
        ["\x4D\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x9C"],
        ["\x4D\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x83"],
        ["\x55\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBF"],
        ["\x54\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xBB"],
        ["\x49\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8D"],
        ["\x46\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA9"],
        ["\x4E\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB9"],
        ["\x4C\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA3"],
        ["\x52\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8D"],
        ["\x4D\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBD"],
        ["\x54\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x95"],
        ["\x4C\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA5"],
        ["\x48\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x89"],
        ["\x54\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA9"],
        ["\x46\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB8"],
        ["\x4B\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x93"],
        ["\x51\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9F"],
        ["\x47\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8F"],
        ["\x50\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9C"],
        ["\x4B\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA1"],
        ["\x48\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x89"],
        ["\x4B\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x98"],
        ["\x4F\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAC"],
        ["\x50\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBC"],
        ["\x50\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBB"],
        ["\x48\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x85"],
        ["\x4A\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB0"],
        ["\x47\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x81"],
        ["\x51\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAD"],
        ["\x51\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x97"],
        ["\x4D\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x9C"],
        ["\x4D\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x92"],
        ["\x4B\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8F"],
        ["\x46\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x97"],
        ["\x4F\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x8E"],
        ["\x4D\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x93"],
        ["\x46\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xB5"],
        ["\x4C\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x88"],
        ["\x45\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA0"],
        ["\x4A\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x83"],
        ["\x49\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB4"],
        ["\x47\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x87"],
        ["\x4B\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB3"],
        ["\x4B\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAF"],
        ["\x53\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x89"],
        ["\x4B\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9F"],
        ["\x49\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAC"],
        ["\x46\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xB3"],
        ["\x48\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9F"],
        ["\x4E\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x97"],
        ["\x47\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x9E"],
        ["\x4F\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8A"],
        ["\x4A\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8F"],
        ["\x47\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9A"],
        ["\x4A\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x92"],
        ["\x4A\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x96"],
        ["\x4F\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB6"],
        ["\x4E\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x83"],
        ["\x4A\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x98"],
        ["\x4C\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xAB"],
        ["\x4C\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8A"],
        ["\x4B\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x8D"],
        ["\x45\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x91"],
        ["\x54\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x9C"],
        ["\x47\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x96"],
        ["\x45\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9A"],
        ["\x45\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAA"],
        ["\x50\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB0"],
        ["\x55\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x91"],
        ["\x54\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xBE"],
        ["\x53\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x95"],
        ["\x4D\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA5"],
        ["\x54\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB0"],
        ["\x47\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x93"],
        ["\x55\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x81"],
        ["\x54\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB5"],
        ["\x55\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x95"],
        ["\x4F\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x80"],
        ["\x4D\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x84"],
        ["\x53\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xA8"],
        ["\x46\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x93"],
        ["\x53\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x86"],
        ["\x46\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBE"],
        ["\x49\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x90"],
        ["\x52\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB1"],
        ["\x49\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAF"],
        ["\x48\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x85"],
        ["\x50\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA0"],
        ["\x48\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8B"],
        ["\x50\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB4"],
        ["\x4B\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBF"],
        ["\x46\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB0"],
        ["\x4D\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x9E"],
        ["\x52\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x8E"],
        ["\x52\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xBF"],
        ["\x52\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x94"],
        ["\x4A\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x8B"],
        ["\x4A\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB8"],
        ["\x4B\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x80"],
        ["\x4F\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xAE"],
        ["\x4A\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8A"],
        ["\x51\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9B"],
        ["\x50\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x9B"],
        ["\x45\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA3"],
        ["\x47\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB0"],
        ["\x45\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA7"],
        ["\x46\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xAC"],
        ["\x51\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x8D"],
        ["\x47\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8C"],
        ["\x4B\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB9"],
        ["\x47\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x9D"],
        ["\x52\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA7"],
        ["\x49\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x93"],
        ["\x53\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x84"],
        ["\x48\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x85"],
        ["\x55\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x98"],
        ["\x4E\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9E"],
        ["\x4B\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x93"],
        ["\x45\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xA2"],
        ["\x4D\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAF"],
        ["\x4E\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA2"],
        ["\x4A\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x97"],
        ["\x53\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB8"],
        ["\x50\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x81"],
        ["\x4F\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xBE"],
        ["\x4D\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB8"],
        ["\x55\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA7"],
        ["\x52\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xB8"],
        ["\x4E\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAA"],
        ["\x4F\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA9"],
        ["\x4E\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x86"],
        ["\x46\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x94"],
        ["\x47\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB0"],
        ["\x4E\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAA"],
        ["\x4A\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB1"],
        ["\x4E\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBD"],
        ["\x51\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAA"],
        ["\x54\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBF"],
        ["\x4B\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x9A"],
        ["\x45\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xB7"],
        ["\x52\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB8"],
        ["\x55\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x88"],
        ["\x4B\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBD"],
        ["\x4B\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB0"],
        ["\x48\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB9"],
        ["\x48\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x98"],
        ["\x50\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x86"],
        ["\x51\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA6"],
        ["\x4A\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x85"],
        ["\x4B\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA2"],
        ["\x4D\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA6"],
        ["\x54\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x8E"],
        ["\x4C\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA1"],
        ["\x53\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9B"],
        ["\x48\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAD"],
        ["\x4A\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAD"],
        ["\x48\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAF"],
        ["\x54\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xAA"],
        ["\x54\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBB"],
        ["\x55\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBD"],
        ["\x4E\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x86"],
        ["\x53\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8B"],
        ["\x4F\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x95"],
        ["\x48\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x9B"],
        ["\x47\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xA3"],
        ["\x4E\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x87"],
        ["\x4A\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xBE"],
        ["\x49\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAD"],
        ["\x4D\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x96"],
        ["\x4F\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x80"],
        ["\x47\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB5"],
        ["\x45\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB7"],
        ["\x49\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x87"],
        ["\x48\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA4"],
        ["\x45\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA5"],
        ["\x45\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB0"],
        ["\x55\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9B"],
        ["\x4E\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA5"],
        ["\x46\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xBA"],
        ["\x45\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA0"],
        ["\x50\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB4"],
        ["\x4D\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9A"],
        ["\x46\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAE"],
        ["\x4C\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xB4"],
        ["\x54\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x98"],
        ["\x4C\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x85"],
        ["\x52\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xB3"],
        ["\x49\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x89"],
        ["\x4D\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9C"],
        ["\x45\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB9"],
        ["\x4B\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x91"],
        ["\x4C\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x84"],
        ["\x50\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x90"],
        ["\x4D\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA9"],
        ["\x4F\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x92"],
        ["\x49\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB6"],
        ["\x55\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA1"],
        ["\x47\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x80"],
        ["\x45\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAD"],
        ["\x48\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB2"],
        ["\x4D\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x99"],
        ["\x46\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA0"],
        ["\x4D\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBD"],
        ["\x4C\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBC"],
        ["\x4B\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB1"],
        ["\x49\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA8"],
        ["\x4B\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xAB"],
        ["\x52\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB7"],
        ["\x4F\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBB"],
        ["\x55\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8E"],
        ["\x48\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB3"],
        ["\x4D\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x90"],
        ["\x53\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x97"],
        ["\x4F\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA6"],
        ["\x49\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAA"],
        ["\x54\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA7"],
        ["\x4A\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x97"],
        ["\x4C\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAF"],
        ["\x4B\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x81"],
        ["\x4D\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x86"],
        ["\x55\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8B"],
        ["\x55\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x8B"],
        ["\x55\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB5"],
        ["\x51\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x96"],
        ["\x4D\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB3"],
        ["\x4B\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x81"],
        ["\x51\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x94"],
        ["\x48\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB5"],
        ["\x4E\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAB"],
        ["\x4C\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB4"],
        ["\x51\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB2"],
        ["\x4F\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x91"],
        ["\x4C\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xA2"],
        ["\x47\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9D"],
        ["\x4C\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAE"],
        ["\x55\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x92"],
        ["\x45\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBA"],
        ["\x4E\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xBA"],
        ["\x4D\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB4"],
        ["\x55\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB9"],
        ["\x4D\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB8"],
        ["\x4E\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB6"],
        ["\x46\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xBF"],
        ["\x55\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9C"],
        ["\x4A\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x85"],
        ["\x50\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xB3"],
        ["\x4E\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9A"],
        ["\x45\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x95\xB7"],
        ["\x4D\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x82"],
        ["\x47\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA5"],
        ["\x4E\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x85"],
        ["\x55\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x97"],
        ["\x46\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB4"],
        ["\x55\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x95"],
        ["\x4C\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x88"],
        ["\x4D\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8D"],
        ["\x4B\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x83"],
        ["\x4C\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAE"],
        ["\x4E\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB3"],
        ["\x45\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA5"],
        ["\x51\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9C"],
        ["\x4B\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8E"],
        ["\x4E\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8C"],
        ["\x49\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xBD"],
        ["\x54\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x9A"],
        ["\x4C\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x9B"],
        ["\x45\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9A"],
        ["\x46\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x9A"],
        ["\x52\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x82"],
        ["\x54\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB4"],
        ["\x4B\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBB"],
        ["\x4E\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x83"],
        ["\x4E\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAC"],
        ["\x4F\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x98"],
        ["\x47\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBB"],
        ["\x4F\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA6"],
        ["\x4D\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB4"],
        ["\x54\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x94"],
        ["\x4C\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xBF"],
        ["\x54\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB0"],
        ["\x49\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xAA"],
        ["\x58\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB7"],
        ["\x52\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xAC"],
        ["\x55\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAC"],
        ["\x4C\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAA"],
        ["\x53\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8A"],
        ["\x4C\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA3"],
        ["\x47\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB4"],
        ["\x4E\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAD"],
        ["\x48\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8E"],
        ["\x4E\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x9C"],
        ["\x4F\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB5"],
        ["\x53\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x83"],
        ["\x46\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x9E"],
        ["\x4F\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x88"],
        ["\x4B\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA4"],
        ["\x45\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9A"],
        ["\x48\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9D"],
        ["\x4B\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x95"],
        ["\x48\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAD"],
        ["\x50\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB7"],
        ["\x4C\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9F"],
        ["\x4D\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8C"],
        ["\x4B\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB5"],
        ["\x53\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBA"],
        ["\x49\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x90"],
        ["\x51\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAF"],
        ["\x53\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x80"],
        ["\x51\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x87"],
        ["\x4B\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8E"],
        ["\x47\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8B"],
        ["\x4A\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA0"],
        ["\x4D\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x87"],
        ["\x4F\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x82"],
        ["\x52\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA6"],
        ["\x55\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x84"],
        ["\x51\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x93"],
        ["\x4D\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB8"],
        ["\x51\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xAD"],
        ["\x4F\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x98"],
        ["\x51\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x8E"],
        ["\x4E\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA5"],
        ["\x4D\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x98"],
        ["\x55\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA2"],
        ["\x4B\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB5"],
        ["\x4F\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB4"],
        ["\x45\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x84"],
        ["\x4F\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x9B"],
        ["\x49\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA9"],
        ["\x50\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x91"],
        ["\x54\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xBA"],
        ["\x47\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xB2"],
        ["\x48\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB9"],
        ["\x4E\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA4"],
        ["\x54\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8D"],
        ["\x53\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAD"],
        ["\x45\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x84"],
        ["\x47\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB8"],
        ["\x4F\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xAB"],
        ["\x46\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA9"],
        ["\x48\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x95"],
        ["\x48\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x97"],
        ["\x4A\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xBB"],
        ["\x55\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8F"],
        ["\x52\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9C"],
        ["\x50\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBC"],
        ["\x47\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xA2"],
        ["\x55\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x9B"],
        ["\x47\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB9"],
        ["\x48\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9D"],
        ["\x48\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBF"],
        ["\x55\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB1"],
        ["\x45\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB0"],
        ["\x45\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xBB"],
        ["\x50\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8E"],
        ["\x4E\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x90"],
        ["\x54\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB5"],
        ["\x48\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x97"],
        ["\x53\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xAC"],
        ["\x53\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA0"],
        ["\x4C\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x92"],
        ["\x4E\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x97"],
        ["\x52\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9C"],
        ["\x45\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA1"],
        ["\x46\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBB"],
        ["\x53\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x9F"],
        ["\x52\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xAD"],
        ["\x48\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x94"],
        ["\x45\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xBD"],
        ["\x55\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x8D"],
        ["\x4D\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA5"],
        ["\x50\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xBA"],
        ["\x4A\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAA"],
        ["\x45\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA6"],
        ["\x46\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x9F"],
        ["\x4D\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB4"],
        ["\x4C\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x92"],
        ["\x4B\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x92"],
        ["\x49\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x9A"],
        ["\x4B\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAC"],
        ["\x4B\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8D"],
        ["\x4C\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x80"],
        ["\x4B\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x90"],
        ["\x4C\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x94"],
        ["\x52\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x98"],
        ["\x55\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x97"],
        ["\x51\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x95"],
        ["\x45\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB6"],
        ["\x47\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x8B"],
        ["\x51\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xBC"],
        ["\x47\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x95"],
        ["\x52\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xAD"],
        ["\x45\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB1"],
        ["\x4A\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x83"],
        ["\x5C\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xBC"],
        ["\x4E\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x9F"],
        ["\x4D\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x97"],
        ["\x55\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x98"],
        ["\x48\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAF"],
        ["\x5D\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x9B"],
        ["\x4B\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAF"],
        ["\x4E\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x88"],
        ["\x46\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x93"],
        ["\x55\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x98"],
        ["\x55\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xB7"],
        ["\x46\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x89"],
        ["\x49\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x94"],
        ["\x4B\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x92"],
        ["\x48\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x96"],
        ["\x48\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB1"],
        ["\x4C\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB0"],
        ["\x50\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA3"],
        ["\x54\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA9"],
        ["\x45\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA4"],
        ["\x49\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8E"],
        ["\x4F\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x84"],
        ["\x4A\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x86"],
        ["\x4D\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x8F"],
        ["\x4C\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x83"],
        ["\x4B\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8F"],
        ["\x52\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x99"],
        ["\x4A\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB6"],
        ["\x47\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xAD"],
        ["\x4E\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB0"],
        ["\x4B\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x98"],
        ["\x48\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8D"],
        ["\x45\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x95"],
        ["\x46\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8C"],
        ["\x49\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x82"],
        ["\x48\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8E"],
        ["\x53\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA7"],
        ["\x55\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9E"],
        ["\x4D\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9E"],
        ["\x4F\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB3"],
        ["\x4D\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA5"],
        ["\x4E\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB4"],
        ["\x54\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x84"],
        ["\x45\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x93"],
        ["\x48\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x85"],
        ["\x4F\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA0"],
        ["\x51\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x87"],
        ["\x50\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBF"],
        ["\x47\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x97"],
        ["\x46\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB3"],
        ["\x55\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x9C"],
        ["\x46\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB9"],
        ["\x4A\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA3"],
        ["\x53\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBF"],
        ["\x4A\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA4"],
        ["\x4C\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x92"],
        ["\x4A\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xAC"],
        ["\x4A\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xAD"],
        ["\x47\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x83"],
        ["\x55\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA1"],
        ["\x50\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB8"],
        ["\x4A\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x81"],
        ["\x54\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB4"],
        ["\x4D\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8A"],
        ["\x54\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB6"],
        ["\x4D\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xAB"],
        ["\x4A\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x85"],
        ["\x4F\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x89"],
        ["\x53\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9E"],
        ["\x55\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB8"],
        ["\x4F\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAF"],
        ["\x4E\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x87"],
        ["\x49\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA6"],
        ["\x55\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x8C"],
        ["\x4C\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x9A"],
        ["\x54\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x81"],
        ["\x51\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x93"],
        ["\x50\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x91"],
        ["\x4C\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x87"],
        ["\x4E\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x8D"],
        ["\x45\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x88"],
        ["\x48\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA3"],
        ["\x45\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x85"],
        ["\x55\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8D"],
        ["\x54\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAA"],
        ["\x51\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x99"],
        ["\x52\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x8E"],
        ["\x4B\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x98"],
        ["\x4F\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xBA"],
        ["\x4B\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x8B"],
        ["\x4D\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA2"],
        ["\x50\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xB4"],
        ["\x48\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x84"],
        ["\x50\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB7"],
        ["\x45\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x97"],
        ["\x4A\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA0"],
        ["\x4C\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x9F"],
        ["\x49\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA3"],
        ["\x55\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9D"],
        ["\x45\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8C"],
        ["\x4A\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBC"],
        ["\x50\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x90"],
        ["\x64\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA9"],
        ["\x4E\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x82"],
        ["\x53\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x91"],
        ["\x4A\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x89"],
        ["\x51\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB9"],
        ["\x51\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBF"],
        ["\x45\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA5"],
        ["\x4A\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xB3"],
        ["\x46\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA5"],
        ["\x4B\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x82"],
        ["\x4C\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBF"],
        ["\x4F\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xAE"],
        ["\x4A\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xBB"],
        ["\x50\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x8A"],
        ["\x4B\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x8D"],
        ["\x4A\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x8D"],
        ["\x50\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA1"],
        ["\x50\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB0"],
        ["\x4F\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA2"],
        ["\x4F\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA7"],
        ["\x54\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB1"],
        ["\x4F\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAB"],
        ["\x47\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xB1"],
        ["\x45\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB4"],
        ["\x4A\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB5"],
        ["\x54\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xBB"],
        ["\x53\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9A"],
        ["\x49\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x83"],
        ["\x4B\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x98"],
        ["\x4B\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x83"],
        ["\x55\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBC"],
        ["\x45\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8B"],
        ["\x4D\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x9C"],
        ["\x51\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA2"],
        ["\x4B\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA9"],
        ["\x4A\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x83"],
        ["\x49\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8D"],
        ["\x47\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xBD"],
        ["\x4C\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB3"],
        ["\x53\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBF"],
        ["\x48\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB2"],
        ["\x53\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x97"],
        ["\x55\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA4"],
        ["\x4E\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB4"],
        ["\x4E\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x8A"],
        ["\x4E\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAD"],
        ["\x4B\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x87"],
        ["\x52\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB7"],
        ["\x46\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA2"],
        ["\x4A\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBE"],
        ["\x52\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB6"],
        ["\x4A\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xB4"],
        ["\x4E\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x86"],
        ["\x55\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB5"],
        ["\x54\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAD"],
        ["\x46\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xAC"],
        ["\x4C\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB3"],
        ["\x4B\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x83"],
        ["\x4E\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9D"],
        ["\x4C\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x92"],
        ["\x4B\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x97"],
        ["\x4C\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAF"],
        ["\x53\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x83"],
        ["\x55\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x8C"],
        ["\x4A\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x8C"],
        ["\x50\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xBA"],
        ["\x4E\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xA9"],
        ["\x47\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8D"],
        ["\x4A\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8D"],
        ["\x4D\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB9"],
        ["\x4D\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x92"],
        ["\x47\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x85"],
        ["\x52\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB3"],
        ["\x54\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA4"],
        ["\x54\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBD"],
        ["\x49\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB7"],
        ["\x47\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB2"],
        ["\x4F\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA0"],
        ["\x55\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xAA"],
        ["\x4F\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x99"],
        ["\x63\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xBF"],
        ["\x50\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA4"],
        ["\x55\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA7"],
        ["\x49\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA9"],
        ["\x49\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xAF"],
        ["\x54\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA5"],
        ["\x45\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9A"],
        ["\x4F\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8D"],
        ["\x49\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8F"],
        ["\x4D\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x8A"],
        ["\x46\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBD"],
        ["\x4E\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x94"],
        ["\x4C\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x95"],
        ["\x4B\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB6"],
        ["\x4A\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x84"],
        ["\x49\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAB"],
        ["\x52\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9D"],
        ["\x50\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA0"],
        ["\x4A\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x86"],
        ["\x52\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9B"],
        ["\x54\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xAB"],
        ["\x55\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x81"],
        ["\x4A\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA6"],
        ["\x4B\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBD"],
        ["\x4A\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB1"],
        ["\x52\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xB2"],
        ["\x50\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB8"],
        ["\x4B\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x87"],
        ["\x4D\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x88"],
        ["\x51\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xA8"],
        ["\x48\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA1"],
        ["\x4E\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x8C"],
        ["\x47\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x91"],
        ["\x49\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA0"],
        ["\x45\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAB"],
        ["\x4E\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA2"],
        ["\x54\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x8C"],
        ["\x46\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBA"],
        ["\x51\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x97"],
        ["\x4C\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAA"],
        ["\x50\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x90"],
        ["\x4F\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB0"],
        ["\x4A\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9C"],
        ["\x52\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8F"],
        ["\x51\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA5"],
        ["\x4D\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA9"],
        ["\x55\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xBA"],
        ["\x4F\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x99"],
        ["\x55\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xA4"],
        ["\x4E\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xBC"],
        ["\x49\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB4"],
        ["\x49\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA4"],
        ["\x47\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x8A"],
        ["\x47\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8D"],
        ["\x55\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9B"],
        ["\x4F\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x86"],
        ["\x4D\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xAC"],
        ["\x52\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x91"],
        ["\x46\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBF"],
        ["\x55\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xBE"],
        ["\x50\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x8E"],
        ["\x4A\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x88"],
        ["\x4C\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAF"],
        ["\x50\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAD"],
        ["\x4E\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x94"],
        ["\x47\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x81"],
        ["\x49\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAC"],
        ["\x4F\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA9"],
        ["\x4A\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA9"],
        ["\x49\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x84"],
        ["\x53\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x86"],
        ["\x54\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA9"],
        ["\x55\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x92"],
        ["\x46\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAF"],
        ["\x52\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBD"],
        ["\x4C\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA9"],
        ["\x48\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAA"],
        ["\x48\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA4"],
        ["\x4B\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x90"],
        ["\x52\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x83"],
        ["\x53\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAE"],
        ["\x55\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xAA"],
        ["\x53\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x91"],
        ["\x4C\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA6"],
        ["\x51\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x83"],
        ["\x55\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x87"],
        ["\x47\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBC"],
        ["\x4C\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB2"],
        ["\x50\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x89"],
        ["\x4C\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB9"],
        ["\x4F\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xAB"],
        ["\x4B\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x90"],
        ["\x47\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x94"],
        ["\x51\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x8C"],
        ["\x4D\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB2"],
        ["\x49\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xAE"],
        ["\x51\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x91"],
        ["\x4C\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x98"],
        ["\x53\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8B"],
        ["\x55\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB7"],
        ["\x49\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA5"],
        ["\x4B\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xAB"],
        ["\x55\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB9"],
        ["\x46\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBB"],
        ["\x4C\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBF"],
        ["\x48\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x9E"],
        ["\x48\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9B"],
        ["\x49\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8B"],
        ["\x51\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB8"],
        ["\x46\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x99"],
        ["\x45\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBE"],
        ["\x4B\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAE"],
        ["\x52\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x87"],
        ["\x53\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x98"],
        ["\x52\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB5"],
        ["\x52\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x89"],
        ["\x45\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8E"],
        ["\x4C\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xBB"],
        ["\x52\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8A"],
        ["\x50\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x97"],
        ["\x4F\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB9"],
        ["\x4E\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8B"],
        ["\x50\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAD"],
        ["\x45\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA6"],
        ["\x50\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9D"],
        ["\x48\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB1"],
        ["\x52\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x98"],
        ["\x52\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xBC"],
        ["\x47\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x85"],
        ["\x55\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA2"],
        ["\x4A\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x86"],
        ["\x55\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xBC"],
        ["\x50\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xA7"],
        ["\x4A\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xAB"],
        ["\x48\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9B"],
        ["\x4F\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x90"],
        ["\x45\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBE"],
        ["\x55\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xAC"],
        ["\x4D\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB5"],
        ["\x51\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAA"],
        ["\x49\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x99"],
        ["\x4C\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB7"],
        ["\x4F\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x82"],
        ["\x54\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA2"],
        ["\x4D\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA8"],
        ["\x46\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA8"],
        ["\x49\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x95"],
        ["\x55\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xB9"],
        ["\x55\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9F"],
        ["\x4B\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x8F"],
        ["\x49\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x85"],
        ["\x4D\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x92"],
        ["\x4A\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x97"],
        ["\x53\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA8"],
        ["\x55\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB2"],
        ["\x52\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x9C"],
        ["\x4E\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAD"],
        ["\x54\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAD"],
        ["\x45\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x81"],
        ["\x4E\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAC"],
        ["\x51\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x8C"],
        ["\x45\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x9C"],
        ["\x55\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x95"],
        ["\x4D\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA7"],
        ["\x50\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x93"],
        ["\x53\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBB"],
        ["\x46\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x8F"],
        ["\x4C\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB6"],
        ["\x46\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8D"],
        ["\x47\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x98"],
        ["\x51\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA0"],
        ["\x45\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAB"],
        ["\x49\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA6"],
        ["\x45\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x8C"],
        ["\x48\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA8"],
        ["\x47\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x83"],
        ["\x45\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x9C"],
        ["\x4E\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x96"],
        ["\x4D\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB6"],
        ["\x49\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB7"],
        ["\x51\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA7"],
        ["\x49\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAE"],
        ["\x4A\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAE"],
        ["\x45\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB6"],
        ["\x4F\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA6"],
        ["\x4D\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x90"],
        ["\x51\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9A"],
        ["\x4E\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x99"],
        ["\x4E\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9C"],
        ["\x49\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA0"],
        ["\x4F\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA6"],
        ["\x50\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB4"],
        ["\x47\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\x9C"],
        ["\x4B\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x84"],
        ["\x53\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAE"],
        ["\x51\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAB"],
        ["\x45\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA6"],
        ["\x4A\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9E"],
        ["\x55\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA1"],
        ["\x51\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAA"],
        ["\x45\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA8"],
        ["\x4D\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x81"],
        ["\x52\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x93"],
        ["\x47\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xA8"],
        ["\x50\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xBA"],
        ["\x54\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x97"],
        ["\x4A\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8F"],
        ["\x4B\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xAF"],
        ["\x4A\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA9"],
        ["\x4A\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x85"],
        ["\x47\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8D"],
        ["\x45\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8F"],
        ["\x4C\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB9"],
        ["\x4B\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x87"],
        ["\x4D\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x86"],
        ["\x48\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB5"],
        ["\x54\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x97"],
        ["\x49\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x95"],
        ["\x4E\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB8"],
        ["\x4B\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8F"],
        ["\x46\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA9"],
        ["\x52\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x92"],
        ["\x45\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x86"],
        ["\x53\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBB"],
        ["\x4E\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB4"],
        ["\x52\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB3"],
        ["\x4F\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA4"],
        ["\x54\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xAE"],
        ["\x54\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x9A"],
        ["\x4E\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAE"],
        ["\x48\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x89"],
        ["\x54\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9E"],
        ["\x4F\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9B"],
        ["\x4F\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB0"],
        ["\x45\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x87"],
        ["\x48\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9E"],
        ["\x50\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x99"],
        ["\x4B\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB5"],
        ["\x46\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB5"],
        ["\x53\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x80"],
        ["\x4E\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA3"],
        ["\x45\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB3"],
        ["\x50\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8A"],
        ["\x4A\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x84"],
        ["\x48\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA6"],
        ["\x54\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xBD"],
        ["\x4B\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x89"],
        ["\x51\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9B"],
        ["\x46\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB3"],
        ["\x4C\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x81"],
        ["\x55\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xBB"],
        ["\x4B\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x81"],
        ["\x53\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x96"],
        ["\x4D\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA7"],
        ["\x46\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA5"],
        ["\x55\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA5"],
        ["\x55\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x91"],
        ["\x55\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x86"],
        ["\x50\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x8F"],
        ["\x47\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x89"],
        ["\x47\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x87"],
        ["\x4F\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x87"],
        ["\x48\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA8"],
        ["\x45\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBA"],
        ["\x48\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x94"],
        ["\x50\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8D"],
        ["\x4B\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xBF"],
        ["\x48\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x89"],
        ["\x54\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA9"],
        ["\x4B\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x81"],
        ["\x54\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xAD"],
        ["\x45\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9D"],
        ["\x4E\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x97"],
        ["\x53\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xAA"],
        ["\x53\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x83"],
        ["\x4C\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x95"],
        ["\x47\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA9"],
        ["\x4D\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAB"],
        ["\x49\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9C"],
        ["\x4A\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x94"],
        ["\x48\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x82"],
        ["\x4A\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9F"],
        ["\x4E\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x93"],
        ["\x52\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x95"],
        ["\x51\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8A"],
        ["\x4A\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xAE"],
        ["\x49\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8D"],
        ["\x4F\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBF"],
        ["\x51\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xA9"],
        ["\x55\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA3"],
        ["\x50\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB8"],
        ["\x4A\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x85"],
        ["\x50\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x86"],
        ["\x49\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB1"],
        ["\x4D\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x89"],
        ["\x49\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9D"],
        ["\x48\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB0"],
        ["\x4A\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAF"],
        ["\x4F\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA9"],
        ["\x55\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x96"],
        ["\x4C\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB1"],
        ["\x52\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA7"],
        ["\x48\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBE"],
        ["\x45\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB9"],
        ["\x4B\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8B"],
        ["\x46\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x95"],
        ["\x4E\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA1"],
        ["\x55\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xB9"],
        ["\x4C\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xB2"],
        ["\x49\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xAB"],
        ["\x50\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9E"],
        ["\x46\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB3"],
        ["\x50\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8C"],
        ["\x50\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xAC"],
        ["\x4E\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x82"],
        ["\x51\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x92"],
        ["\x4A\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xAA"],
        ["\x46\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8A"],
        ["\x46\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA6"],
        ["\x54\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x92"],
        ["\x4D\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBD"],
        ["\x4E\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB3"],
        ["\x51\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xAC"],
        ["\x4F\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8F"],
        ["\x4C\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA1"],
        ["\x4E\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x8D"],
        ["\x51\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x96"],
        ["\x4C\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8A"],
        ["\x50\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA8"],
        ["\x4C\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xBD"],
        ["\x4C\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x98"],
        ["\x4E\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x99"],
        ["\x47\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xBF"],
        ["\x4C\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB4"],
        ["\x47\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9B"],
        ["\x50\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x90"],
        ["\x4B\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x92"],
        ["\x4F\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x92"],
        ["\x48\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA1"],
        ["\x4C\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAA"],
        ["\x4E\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA8"],
        ["\x4F\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x80"],
        ["\x50\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8C"],
        ["\x48\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBF"],
        ["\x51\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xBE"],
        ["\x47\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xB2"],
        ["\x53\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA0"],
        ["\x4E\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xAC"],
        ["\x45\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x97"],
        ["\x4A\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x95"],
        ["\x51\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9C"],
        ["\x4A\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xA8"],
        ["\x4E\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB2"],
        ["\x4E\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB4"],
        ["\x48\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA7"],
        ["\x4A\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA6"],
        ["\x52\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x86"],
        ["\x53\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA6"],
        ["\x54\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x83"],
        ["\x50\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xA1"],
        ["\x4F\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x86"],
        ["\x46\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x80"],
        ["\x49\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x8C"],
        ["\x52\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x94"],
        ["\x45\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAC"],
        ["\x51\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xBB"],
        ["\x4D\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA1"],
        ["\x50\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x86"],
        ["\x48\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xA9"],
        ["\x49\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA8"],
        ["\x4D\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x94"],
        ["\x48\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBB"],
        ["\x4E\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8B"],
        ["\x4B\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xB9"],
        ["\x55\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA7"],
        ["\x49\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9A"],
        ["\x49\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8E"],
        ["\x55\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA9"],
        ["\x68\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x99"],
        ["\x4C\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x95"],
        ["\x4D\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9C"],
        ["\x4F\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x95"],
        ["\x55\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAA"],
        ["\x50\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBE"],
        ["\x53\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x92"],
        ["\x4D\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9D"],
        ["\x4F\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA6"],
        ["\x4B\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA3"],
        ["\x48\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x88"],
        ["\x51\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB9"],
        ["\x47\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAB"],
        ["\x53\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xAB"],
        ["\x49\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x84"],
        ["\x56\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAD"],
        ["\x4D\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xAD"],
        ["\x4E\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBF"],
        ["\x45\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x87"],
        ["\x4D\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA2"],
        ["\x47\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x80"],
        ["\x4F\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAB"],
        ["\x55\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x93"],
        ["\x47\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB3"],
        ["\x49\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAA"],
        ["\x4D\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x85"],
        ["\x4A\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB3"],
        ["\x4C\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x95"],
        ["\x50\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAC"],
        ["\x4A\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x86"],
        ["\x53\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x9C"],
        ["\x4C\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8A"],
        ["\x4F\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x91"],
        ["\x47\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x94"],
        ["\x50\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x88"],
        ["\x4A\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x99"],
        ["\x53\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x8D"],
        ["\x47\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x91"],
        ["\x4E\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA0"],
        ["\x46\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x99"],
        ["\x4B\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA2"],
        ["\x47\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xA1"],
        ["\x4A\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9F"],
        ["\x50\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9B"],
        ["\x4E\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xA7"],
        ["\x55\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA1"],
        ["\x4D\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8B"],
        ["\x54\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xBF"],
        ["\x4B\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x98"],
        ["\x54\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA5"],
        ["\x45\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8D"],
        ["\x49\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBD"],
        ["\x45\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8E"],
        ["\x4B\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9F"],
        ["\x4E\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB7"],
        ["\x4D\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x98"],
        ["\x4B\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB4"],
        ["\x55\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xAA"],
        ["\x55\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9D"],
        ["\x4E\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x85"],
        ["\x4B\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8D"],
        ["\x55\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x89"],
        ["\x48\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBF"],
        ["\x55\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xAC"],
        ["\x46\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA2"],
        ["\x55\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBA"],
        ["\x55\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB8"],
        ["\x48\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA1"],
        ["\x46\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x82"],
        ["\x55\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x84"],
        ["\x4F\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9F"],
        ["\x46\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x9B"],
        ["\x4A\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9B"],
        ["\x50\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB2"],
        ["\x4A\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB2"],
        ["\x4F\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x97"],
        ["\x50\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x99"],
        ["\x54\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xB2"],
        ["\x45\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA8"],
        ["\x4D\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x99"],
        ["\x46\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xAE"],
        ["\x51\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA2"],
        ["\x52\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBF"],
        ["\x50\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x85"],
        ["\x53\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA4"],
        ["\x4C\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xBB"],
        ["\x4F\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xBE"],
        ["\x4D\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB0"],
        ["\x46\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x8F"],
        ["\x55\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB6"],
        ["\x4C\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8B"],
        ["\x46\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x80"],
        ["\x4F\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x81"],
        ["\x47\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9F"],
        ["\x51\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB6"],
        ["\x48\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9C"],
        ["\x50\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBA"],
        ["\x4E\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB6"],
        ["\x45\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8E"],
        ["\x47\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA5"],
        ["\x46\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA2"],
        ["\x53\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x84"],
        ["\x49\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB9"],
        ["\x47\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x84"],
        ["\x46\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAC"],
        ["\x4B\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB3"],
        ["\x4C\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8D"],
        ["\x48\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x96"],
        ["\x46\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB3"],
        ["\x62\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAE"],
        ["\x52\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x93"],
        ["\x50\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x89"],
        ["\x53\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x88"],
        ["\x46\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB9"],
        ["\x53\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x92"],
        ["\x4E\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAD"],
        ["\x46\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB8"],
        ["\x4B\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xAF"],
        ["\x4C\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x91"],
        ["\x47\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xAA"],
        ["\x46\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x87"],
        ["\x46\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8B"],
        ["\x4F\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA5"],
        ["\x52\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBD"],
        ["\x4D\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA0"],
        ["\x50\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x82"],
        ["\x4C\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x96"],
        ["\x46\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x89"],
        ["\x4E\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9A"],
        ["\x4F\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xA7"],
        ["\x4F\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8C"],
        ["\x50\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB6"],
        ["\x53\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB7"],
        ["\x46\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB1"],
        ["\x48\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x90"],
        ["\x46\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x95"],
        ["\x4A\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x98"],
        ["\x4A\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8A"],
        ["\x4C\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x91"],
        ["\x4C\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xB5"],
        ["\x45\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x84"],
        ["\x48\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x8D"],
        ["\x4A\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x95"],
        ["\x47\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x88"],
        ["\x49\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x99"],
        ["\x47\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8E"],
        ["\x4D\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x89"],
        ["\x50\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBF"],
        ["\x4D\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x90"],
        ["\x54\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xAD"],
        ["\x4D\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBC"],
        ["\x53\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x96"],
        ["\x48\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB9"],
        ["\x4C\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB8"],
        ["\x4C\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x9A"],
        ["\x4F\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xBA"],
        ["\x51\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x81"],
        ["\x4B\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9C"],
        ["\x51\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x8A"],
        ["\x48\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x98"],
        ["\x45\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8B"],
        ["\x48\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB6"],
        ["\x52\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x94"],
        ["\x45\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA8"],
        ["\x49\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAF"],
        ["\x4A\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8A"],
        ["\x52\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x80"],
        ["\x45\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x89"],
        ["\x50\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x89"],
        ["\x46\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x81"],
        ["\x4D\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA1"],
        ["\x4C\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x8A"],
        ["\x68\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA5"],
        ["\x47\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xBD"],
        ["\x49\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x8A"],
        ["\x53\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xBE"],
        ["\x4D\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x91"],
        ["\x4B\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB2"],
        ["\x55\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x83"],
        ["\x4B\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB4"],
        ["\x4D\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8C"],
        ["\x4D\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xBC"],
        ["\x4A\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x80"],
        ["\x4D\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x85"],
        ["\x51\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBA"],
        ["\x4F\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB8"],
        ["\x46\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA5"],
        ["\x52\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xB1"],
        ["\x4A\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBC"],
        ["\x4B\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB7"],
        ["\x54\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9B"],
        ["\x4C\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA1"],
        ["\x47\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xBD"],
        ["\x50\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xAA"],
        ["\x4B\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xB1"],
        ["\x4C\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB5"],
        ["\x49\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x90"],
        ["\x4E\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x84"],
        ["\x55\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAB"],
        ["\x4E\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8D"],
        ["\x4C\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xAD"],
        ["\x4E\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA7"],
        ["\x45\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA9"],
        ["\x50\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8F"],
        ["\x4C\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA5"],
        ["\x4E\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8E"],
        ["\x48\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA8"],
        ["\x45\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x86"],
        ["\x52\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x83"],
        ["\x51\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA2"],
        ["\x49\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x8F"],
        ["\x54\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xA1"],
        ["\x47\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8C"],
        ["\x49\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA2"],
        ["\x49\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB8"],
        ["\x49\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8B"],
        ["\x47\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x87"],
        ["\x45\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8B"],
        ["\x55\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x8E"],
        ["\x55\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA0"],
        ["\x4C\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA5"],
        ["\x51\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x89"],
        ["\x46\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x81"],
        ["\x4D\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9C"],
        ["\x50\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x89"],
        ["\x47\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x99"],
        ["\x49\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAB"],
        ["\x4C\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x92"],
        ["\x46\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x86"],
        ["\x49\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9C"],
        ["\x48\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x8D"],
        ["\x55\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xB6"],
        ["\x4C\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAE"],
        ["\x4A\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x85"],
        ["\x52\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9C"],
        ["\x4B\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x86"],
        ["\x49\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAE"],
        ["\x4D\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x9A"],
        ["\x48\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA1"],
        ["\x53\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8C"],
        ["\x4C\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xAE"],
        ["\x46\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x99"],
        ["\x4E\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x81"],
        ["\x4E\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xBC"],
        ["\x4E\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9F"],
        ["\x4B\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x82"],
        ["\x52\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xAD"],
        ["\x52\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9C"],
        ["\x4E\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA7"],
        ["\x45\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAF"],
        ["\x51\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x92"],
        ["\x52\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBC"],
        ["\x47\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8F"],
        ["\x50\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB5"],
        ["\x4A\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x98"],
        ["\x45\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x9B"],
        ["\x48\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x91"],
        ["\x4D\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAB"],
        ["\x4F\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x98"],
        ["\x45\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x97"],
        ["\x52\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8B"],
        ["\x4A\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x90"],
        ["\x54\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB3"],
        ["\x4C\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA8"],
        ["\x48\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xAA"],
        ["\x4C\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA3"],
        ["\x55\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x97"],
        ["\x51\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x9F"],
        ["\x50\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA0"],
        ["\x4B\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x81"],
        ["\x4D\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x99"],
        ["\x51\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAF"],
        ["\x46\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x9E"],
        ["\x49\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA4"],
        ["\x54\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB6"],
        ["\x4A\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8B"],
        ["\x48\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB7"],
        ["\x4D\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB1"],
        ["\x4C\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBA"],
        ["\x50\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9C"],
        ["\x4A\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB2"],
        ["\x49\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBC"],
        ["\x55\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x93"],
        ["\x45\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB4"],
        ["\x55\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB7"],
        ["\x50\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB6"],
        ["\x4F\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8A"],
        ["\x4C\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x97"],
        ["\x4C\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA2"],
        ["\x50\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xA6"],
        ["\x49\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB4"],
        ["\x4B\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x97"],
        ["\x4E\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA3"],
        ["\x4D\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x88"],
        ["\x4F\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x82"],
        ["\x4E\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x89"],
        ["\x4B\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8B"],
        ["\x55\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x90"],
        ["\x54\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA3"],
        ["\x4C\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x89"],
        ["\x52\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBE"],
        ["\x48\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB4"],
        ["\x53\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xAF"],
        ["\x4B\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xAE"],
        ["\x47\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA3"],
        ["\x4F\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAC"],
        ["\x4B\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x82"],
        ["\x51\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xAF"],
        ["\x55\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x93"],
        ["\x49\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x89"],
        ["\x55\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x82"],
        ["\x47\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAF"],
        ["\x4B\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB2"],
        ["\x48\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB4"],
        ["\x50\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x81"],
        ["\x4E\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x8A"],
        ["\x54\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x84"],
        ["\x48\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x97"],
        ["\x52\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBC"],
        ["\x55\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x94"],
        ["\x4A\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAA"],
        ["\x50\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x8F"],
        ["\x55\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA2"],
        ["\x50\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBC"],
        ["\x54\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xAD"],
        ["\x49\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x81"],
        ["\x53\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBE"],
        ["\x52\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8B"],
        ["\x45\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x8E"],
        ["\x45\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAD"],
        ["\x51\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x93"],
        ["\x50\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x84"],
        ["\x55\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x8B"],
        ["\x48\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xB2"],
        ["\x48\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x96"],
        ["\x4F\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAD"],
        ["\x45\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8C"],
        ["\x47\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB1"],
        ["\x55\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xAA"],
        ["\x50\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x84"],
        ["\x47\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x87"],
        ["\x4E\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x91"],
        ["\x4F\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA0"],
        ["\x4B\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB2"],
        ["\x50\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x99"],
        ["\x4B\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x98"],
        ["\x52\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x90"],
        ["\x50\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAB"],
        ["\x4F\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x81"],
        ["\x50\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA8"],
        ["\x54\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x80"],
        ["\x4D\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xBE"],
        ["\x54\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x97"],
        ["\x4C\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x95"],
        ["\x56\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8C"],
        ["\x56\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x90"],
        ["\x56\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x95"],
        ["\x56\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAA"],
        ["\x56\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB1"],
        ["\x56\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB6"],
        ["\x54\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBC"],
        ["\x56\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBF"],
        ["\x56\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x82"],
        ["\x56\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x96"],
        ["\x56\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x98"],
        ["\x56\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x82"],
        ["\x56\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x85"],
        ["\x53\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAB"],
        ["\x56\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8A"],
        ["\x61\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x92"],
        ["\x56\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8D"],
        ["\x56\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8E"],
        ["\x56\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9E"],
        ["\x51\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9F"],
        ["\x56\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA0"],
        ["\x56\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA2"],
        ["\x56\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB0"],
        ["\x56\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB3"],
        ["\x56\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB6"],
        ["\x56\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8E"],
        ["\x56\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8D"],
        ["\x56\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x84"],
        ["\x56\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x86"],
        ["\x56\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x82"],
        ["\x56\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x97"],
        ["\x56\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9E"],
        ["\x56\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xAD"],
        ["\x56\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9F"],
        ["\x53\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB7"],
        ["\x56\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x89"],
        ["\x56\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9A"],
        ["\x56\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB0"],
        ["\x56\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9B"],
        ["\x56\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9D"],
        ["\x56\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x97"],
        ["\x56\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x87"],
        ["\x51\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB6"],
        ["\x56\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x88"],
        ["\x56\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8F"],
        ["\x56\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x98"],
        ["\x56\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBB"],
        ["\x56\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xA9"],
        ["\x56\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB0"],
        ["\x4F\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x91"],
        ["\x56\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xAF"],
        ["\x56\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x86"],
        ["\x56\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x96"],
        ["\x52\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x98"],
        ["\x56\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x94"],
        ["\x53\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9F"],
        ["\x56\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8E"],
        ["\x56\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x98"],
        ["\x56\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9B"],
        ["\x56\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x91"],
        ["\x56\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9A"],
        ["\x56\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x90"],
        ["\x56\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA4"],
        ["\x56\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA5"],
        ["\x56\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9A"],
        ["\x56\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA8"],
        ["\x56\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x94"],
        ["\x56\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAA"],
        ["\x56\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA5"],
        ["\x56\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x85"],
        ["\x56\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9C"],
        ["\x51\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB6"],
        ["\x56\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA1"],
        ["\x56\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA9"],
        ["\x56\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAC"],
        ["\x56\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xBE"],
        ["\x56\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xAF"],
        ["\x56\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x91"],
        ["\x56\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x86"],
        ["\x56\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x83"],
        ["\x56\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x87"],
        ["\x56\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x83"],
        ["\x56\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x95"],
        ["\x56\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x90"],
        ["\x56\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x88"],
        ["\x56\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x9A"],
        ["\x56\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x96"],
        ["\x56\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xAC"],
        ["\x56\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB8"],
        ["\x56\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x80"],
        ["\x56\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x9A"],
        ["\x56\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x85"],
        ["\x56\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB4"],
        ["\x56\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB2"],
        ["\x56\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x89"],
        ["\x56\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8A"],
        ["\x56\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB3"],
        ["\x56\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x82"],
        ["\x52\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x96"],
        ["\x56\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x9E"],
        ["\x56\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA5"],
        ["\x56\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xAD"],
        ["\x56\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA3"],
        ["\x56\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xAE"],
        ["\x56\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB9"],
        ["\x56\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB5"],
        ["\x56\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x89"],
        ["\x56\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x81"],
        ["\x56\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x82"],
        ["\x56\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x96"],
        ["\x56\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x95"],
        ["\x56\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x94"],
        ["\x56\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9A"],
        ["\x56\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xA1"],
        ["\x56\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBA"],
        ["\x56\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xB7"],
        ["\x56\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBC"],
        ["\x56\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBB"],
        ["\x56\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBF"],
        ["\x56\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x80"],
        ["\x56\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x92"],
        ["\x56\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8C"],
        ["\x56\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x94"],
        ["\x56\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA2"],
        ["\x60\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB8"],
        ["\x56\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA9"],
        ["\x56\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAA"],
        ["\x56\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAE"],
        ["\x56\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x80"],
        ["\x56\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x82"],
        ["\x56\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x98"],
        ["\x56\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8C"],
        ["\x56\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x89"],
        ["\x56\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8F"],
        ["\x56\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x91"],
        ["\x56\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x93"],
        ["\x56\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x95"],
        ["\x56\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x96"],
        ["\x56\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA4"],
        ["\x56\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA6"],
        ["\x56\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA2"],
        ["\x56\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA9"],
        ["\x56\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAA"],
        ["\x56\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAB"],
        ["\x56\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB3"],
        ["\x56\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB1"],
        ["\x56\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB2"],
        ["\x56\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB0"],
        ["\x56\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB5"],
        ["\x56\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xBD"],
        ["\x56\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x85"],
        ["\x56\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x89"],
        ["\x56\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9B"],
        ["\x56\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA0"],
        ["\x62\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x95"],
        ["\x56\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA9"],
        ["\x56\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAD"],
        ["\x56\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB0"],
        ["\x56\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB5"],
        ["\x56\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBE"],
        ["\x56\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x84"],
        ["\x56\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8B"],
        ["\x56\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x94"],
        ["\x54\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8E"],
        ["\x56\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA7"],
        ["\x56\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xAA"],
        ["\x56\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xAE"],
        ["\x56\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB3"],
        ["\x56\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB9"],
        ["\x57\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8F"],
        ["\x56\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x84"],
        ["\x56\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8B"],
        ["\x51\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8C"],
        ["\x57\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9E"],
        ["\x57\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x94"],
        ["\x57\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xAA"],
        ["\x57\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB4"],
        ["\x57\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA9"],
        ["\x57\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB3"],
        ["\x57\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xBF"],
        ["\x57\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xBD"],
        ["\x57\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x8D"],
        ["\x55\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x94"],
        ["\x57\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x92"],
        ["\x57\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB1"],
        ["\x57\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x88"],
        ["\x57\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x91"],
        ["\x64\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA8"],
        ["\x64\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA7"],
        ["\x57\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAC"],
        ["\x57\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAD"],
        ["\x57\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xBC"],
        ["\x57\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB5"],
        ["\x57\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x81"],
        ["\x57\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x8D"],
        ["\x53\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x97"],
        ["\x57\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9E"],
        ["\x57\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA3"],
        ["\x57\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA6"],
        ["\x66\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAD"],
        ["\x57\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA0"],
        ["\x57\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB3"],
        ["\x57\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB5"],
        ["\x57\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB8"],
        ["\x57\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB9"],
        ["\x57\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x86"],
        ["\x57\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x88"],
        ["\x57\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB8"],
        ["\x57\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8D"],
        ["\x57\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x90"],
        ["\x57\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8F"],
        ["\x57\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x95"],
        ["\x57\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x9A"],
        ["\x57\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA3"],
        ["\x57\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xAF"],
        ["\x57\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB1"],
        ["\x57\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB3"],
        ["\x57\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB8"],
        ["\x57\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x80"],
        ["\x57\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x86"],
        ["\x57\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x85"],
        ["\x57\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x97"],
        ["\x57\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x89"],
        ["\x57\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x8D"],
        ["\x57\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x96"],
        ["\x57\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9E"],
        ["\x57\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA9"],
        ["\x57\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xAE"],
        ["\x52\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x98"],
        ["\x57\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBB"],
        ["\x57\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB7"],
        ["\x57\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x82"],
        ["\x57\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x96"],
        ["\x57\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA0"],
        ["\x57\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA6"],
        ["\x57\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA5"],
        ["\x57\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xAE"],
        ["\x57\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB0"],
        ["\x57\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB6"],
        ["\x57\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x83"],
        ["\x57\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x92"],
        ["\x66\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x99"],
        ["\x57\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9F"],
        ["\x57\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBC"],
        ["\x57\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAE"],
        ["\x57\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAE"],
        ["\x57\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA8"],
        ["\x57\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAD"],
        ["\x57\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xBA"],
        ["\x57\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x81"],
        ["\x57\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBD"],
        ["\x57\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x80"],
        ["\x57\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAC"],
        ["\x57\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAD"],
        ["\x57\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBC"],
        ["\x57\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAE"],
        ["\x57\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB6"],
        ["\x57\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA9"],
        ["\x57\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9D"],
        ["\x57\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x8E"],
        ["\x57\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8F"],
        ["\x57\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB5"],
        ["\x57\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8E"],
        ["\x57\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x9F"],
        ["\x57\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB1"],
        ["\x57\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB7"],
        ["\x57\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB0"],
        ["\x57\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x92"],
        ["\x57\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBB"],
        ["\x57\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x80"],
        ["\x57\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB6"],
        ["\x57\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x84"],
        ["\x57\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x90"],
        ["\x57\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x86"],
        ["\x57\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x87"],
        ["\x57\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA2"],
        ["\x57\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB8"],
        ["\x57\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA5"],
        ["\x57\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAC"],
        ["\x57\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x84"],
        ["\x57\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x88"],
        ["\x57\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA8"],
        ["\x57\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAB"],
        ["\x57\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x82"],
        ["\x57\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA4"],
        ["\x57\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBE"],
        ["\x57\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBC"],
        ["\x57\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x98"],
        ["\x57\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA5"],
        ["\x57\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA6"],
        ["\x57\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x8F"],
        ["\x57\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x94"],
        ["\x57\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xBD"],
        ["\x57\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xAE"],
        ["\x57\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xAD"],
        ["\x54\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xBA"],
        ["\x57\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA2"],
        ["\x57\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB9"],
        ["\x57\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x80"],
        ["\x57\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xA3"],
        ["\x57\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x8C"],
        ["\x57\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xAE"],
        ["\x57\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x9C"],
        ["\x57\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x85"],
        ["\x57\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x96"],
        ["\x57\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x97"],
        ["\x57\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB8"],
        ["\x57\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB3"],
        ["\x57\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x9D"],
        ["\x57\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x99"],
        ["\x57\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x80"],
        ["\x57\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAF"],
        ["\x57\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x8A"],
        ["\x57\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9F"],
        ["\x57\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBB"],
        ["\x57\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBE"],
        ["\x57\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x98"],
        ["\x57\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9E"],
        ["\x57\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAE"],
        ["\x57\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBC"],
        ["\x57\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x83"],
        ["\x57\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA9"],
        ["\x57\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x87"],
        ["\x57\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA8"],
        ["\x52\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9A"],
        ["\x57\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x85"],
        ["\x57\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9F"],
        ["\x57\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x84"],
        ["\x57\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9C"],
        ["\x57\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA4"],
        ["\x57\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x94"],
        ["\x57\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x94"],
        ["\x57\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xB7"],
        ["\x57\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x96"],
        ["\x57\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xBE"],
        ["\x57\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xBD"],
        ["\x57\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x9B"],
        ["\x57\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xB9"],
        ["\x57\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x8E"],
        ["\x57\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x90"],
        ["\x57\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x9F"],
        ["\x54\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB4"],
        ["\x57\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB6"],
        ["\x57\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB2"],
        ["\x57\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB8"],
        ["\x57\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAB"],
        ["\x57\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA4"],
        ["\x57\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xAF"],
        ["\x57\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAC"],
        ["\x57\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAA"],
        ["\x57\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x86"],
        ["\x57\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x80"],
        ["\x58\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x8A"],
        ["\x58\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA0"],
        ["\x57\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x94"],
        ["\x57\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x8F"],
        ["\x58\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA5"],
        ["\x58\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xAE"],
        ["\x58\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xB6"],
        ["\x58\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xB4"],
        ["\x58\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x82"],
        ["\x58\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xBC"],
        ["\x58\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x81"],
        ["\x58\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x83"],
        ["\x58\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x80"],
        ["\x58\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x88"],
        ["\x58\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x8E"],
        ["\x58\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x91"],
        ["\x58\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x93"],
        ["\x58\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x97"],
        ["\x58\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xAE"],
        ["\x58\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB9"],
        ["\x52\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x80"],
        ["\x58\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBF"],
        ["\x58\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x84"],
        ["\x58\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x89"],
        ["\x58\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x88"],
        ["\x51\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8B"],
        ["\x58\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8D"],
        ["\x54\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x93"],
        ["\x58\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x98"],
        ["\x58\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x96"],
        ["\x58\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x87"],
        ["\x58\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x9C"],
        ["\x58\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA6"],
        ["\x51\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB7"],
        ["\x58\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB8"],
        ["\x58\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8E"],
        ["\x58\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xBB"],
        ["\x58\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x80"],
        ["\x58\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8F"],
        ["\x53\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA9"],
        ["\x58\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x80"],
        ["\x58\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x88"],
        ["\x58\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA1"],
        ["\x58\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xBF"],
        ["\x58\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x89"],
        ["\x58\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x93"],
        ["\x58\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA0"],
        ["\x58\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xB3"],
        ["\x58\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA4"],
        ["\x58\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xAA"],
        ["\x53\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xB0"],
        ["\x58\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x83"],
        ["\x58\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x86"],
        ["\x58\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x94"],
        ["\x58\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x92"],
        ["\x58\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x93"],
        ["\x58\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x8A"],
        ["\x58\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x96"],
        ["\x58\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA3"],
        ["\x58\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x8B"],
        ["\x58\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x99"],
        ["\x53\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x9D"],
        ["\x58\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB2"],
        ["\x58\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA1"],
        ["\x58\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA2"],
        ["\x58\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x8B"],
        ["\x58\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB0"],
        ["\x58\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x80"],
        ["\x58\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x92"],
        ["\x58\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xBD"],
        ["\x58\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB9"],
        ["\x58\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x85"],
        ["\x58\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB9"],
        ["\x58\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9F"],
        ["\x58\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xAB"],
        ["\x58\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBA"],
        ["\x58\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9E"],
        ["\x55\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBB"],
        ["\x58\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB8"],
        ["\x58\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xAE"],
        ["\x58\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x85"],
        ["\x58\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x93"],
        ["\x58\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x91"],
        ["\x58\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x97"],
        ["\x58\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x99"],
        ["\x58\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x98"],
        ["\x58\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA5"],
        ["\x58\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9C"],
        ["\x58\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA4"],
        ["\x58\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9F"],
        ["\x58\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAF"],
        ["\x50\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBA"],
        ["\x58\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB9"],
        ["\x58\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBB"],
        ["\x58\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBC"],
        ["\x52\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBD"],
        ["\x58\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x82"],
        ["\x58\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8A"],
        ["\x58\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x90"],
        ["\x58\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9B"],
        ["\x58\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA6"],
        ["\x58\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA5"],
        ["\x58\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAC"],
        ["\x58\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAD"],
        ["\x58\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB2"],
        ["\x58\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB8"],
        ["\x58\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xBE"],
        ["\x60\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x92"],
        ["\x58\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x95"],
        ["\x58\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x90"],
        ["\x51\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x8E"],
        ["\x58\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x9A"],
        ["\x58\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x98"],
        ["\x58\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA2"],
        ["\x58\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA0"],
        ["\x58\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA7"],
        ["\x58\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAC"],
        ["\x58\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA9"],
        ["\x58\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB8"],
        ["\x58\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x81"],
        ["\x58\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x9D"],
        ["\x56\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9E"],
        ["\x56\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAB"],
        ["\x58\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA3"],
        ["\x58\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xB2"],
        ["\x58\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x86"],
        ["\x58\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA8"],
        ["\x51\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9C"],
        ["\x58\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x8D"],
        ["\x58\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x99"],
        ["\x58\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9A"],
        ["\x58\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA5"],
        ["\x58\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9F"],
        ["\x58\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x91"],
        ["\x58\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9C"],
        ["\x58\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x89"],
        ["\x58\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9A"],
        ["\x58\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x80"],
        ["\x58\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xAC"],
        ["\x58\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x89"],
        ["\x58\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xB5"],
        ["\x58\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xB6"],
        ["\x58\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA2"],
        ["\x58\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xAA"],
        ["\x58\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9A"],
        ["\x58\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBC"],
        ["\x58\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBE"],
        ["\x58\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x8B"],
        ["\x58\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x82"],
        ["\x58\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBD"],
        ["\x58\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA3"],
        ["\x58\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x97"],
        ["\x58\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA6"],
        ["\x58\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA9"],
        ["\x58\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x96"],
        ["\x58\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xBA"],
        ["\x58\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xBB"],
        ["\x58\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x8C"],
        ["\x58\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x8B"],
        ["\x58\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x96"],
        ["\x58\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB2"],
        ["\x58\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x90"],
        ["\x58\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xAA"],
        ["\x58\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB6"],
        ["\x58\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xBE"],
        ["\x58\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x83"],
        ["\x58\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x85"],
        ["\x58\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x80"],
        ["\x58\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x91"],
        ["\x58\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x95"],
        ["\x52\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9A"],
        ["\x58\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9B"],
        ["\x58\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA5"],
        ["\x58\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA9"],
        ["\x58\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB0"],
        ["\x58\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB3"],
        ["\x58\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB5"],
        ["\x58\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB8"],
        ["\x58\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x88"],
        ["\x58\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xBA"],
        ["\x58\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x80"],
        ["\x58\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x83"],
        ["\x58\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA6"],
        ["\x58\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB8"],
        ["\x58\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x83"],
        ["\x58\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x87"],
        ["\x58\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x89"],
        ["\x52\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x94"],
        ["\x59\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x90"],
        ["\x59\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA4"],
        ["\x51\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA6"],
        ["\x59\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA2"],
        ["\x59\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9E"],
        ["\x59\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA5"],
        ["\x59\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xAB"],
        ["\x59\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB0"],
        ["\x59\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB6"],
        ["\x59\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB3"],
        ["\x59\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x85"],
        ["\x59\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x87"],
        ["\x59\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x88"],
        ["\x59\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8D"],
        ["\x59\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x93"],
        ["\x59\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA0"],
        ["\x59\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA2"],
        ["\x59\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA8"],
        ["\x59\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB8"],
        ["\x51\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB9"],
        ["\x59\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x81"],
        ["\x59\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x86"],
        ["\x59\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8E"],
        ["\x59\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x93"],
        ["\x59\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x90"],
        ["\x54\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8F"],
        ["\x59\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB1"],
        ["\x59\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAC"],
        ["\x59\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAE"],
        ["\x56\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xA2"],
        ["\x59\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB6"],
        ["\x59\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB9"],
        ["\x59\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x8C"],
        ["\x52\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x91"],
        ["\x59\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x94"],
        ["\x58\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x9B"],
        ["\x59\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAB"],
        ["\x59\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBB"],
        ["\x59\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB6"],
        ["\x59\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBC"],
        ["\x59\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB7"],
        ["\x59\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x85"],
        ["\x59\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBE"],
        ["\x59\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x87"],
        ["\x59\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x99"],
        ["\x59\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA9"],
        ["\x59\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBD"],
        ["\x59\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBA"],
        ["\x59\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAD"],
        ["\x59\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x8C"],
        ["\x59\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAA"],
        ["\x59\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x8B"],
        ["\x59\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x95"],
        ["\x54\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x97"],
        ["\x59\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x9C"],
        ["\x59\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9F"],
        ["\x59\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9B"],
        ["\x59\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x91"],
        ["\x51\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x94"],
        ["\x59\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA2"],
        ["\x59\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9A"],
        ["\x59\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x99"],
        ["\x59\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x98"],
        ["\x59\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8C"],
        ["\x59\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x92"],
        ["\x59\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8E"],
        ["\x59\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8B"],
        ["\x59\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAC"],
        ["\x59\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xB3"],
        ["\x59\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xB6"],
        ["\x59\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x87"],
        ["\x59\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x84"],
        ["\x59\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x82"],
        ["\x59\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xA2"],
        ["\x59\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x9D"],
        ["\x59\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xAC"],
        ["\x59\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xAE"],
        ["\x4F\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBD"],
        ["\x59\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x90"],
        ["\x59\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB7"],
        ["\x59\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBC"],
        ["\x59\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x89"],
        ["\x52\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x8D"],
        ["\x59\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x93"],
        ["\x59\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x92"],
        ["\x51\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x96"],
        ["\x59\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9B"],
        ["\x59\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xAB"],
        ["\x4A\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB2"],
        ["\x59\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB5"],
        ["\x59\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x8B"],
        ["\x59\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9A"],
        ["\x59\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x99"],
        ["\x59\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x91"],
        ["\x59\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9B"],
        ["\x59\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB6"],
        ["\x54\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB7"],
        ["\x59\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x84"],
        ["\x59\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x83"],
        ["\x59\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x80"],
        ["\x59\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x8E"],
        ["\x59\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x97"],
        ["\x59\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x94"],
        ["\x54\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x9F"],
        ["\x59\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA2"],
        ["\x59\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA4"],
        ["\x59\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x87"],
        ["\x59\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB5"],
        ["\x59\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB6"],
        ["\x59\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBA"],
        ["\x68\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBC"],
        ["\x59\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBF"],
        ["\x59\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA0"],
        ["\x59\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x81"],
        ["\x59\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x82"],
        ["\x59\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x88"],
        ["\x59\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x90"],
        ["\x59\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x8F"],
        ["\x53\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x96"],
        ["\x50\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA3"],
        ["\x59\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9D"],
        ["\x59\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9A"],
        ["\x59\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9B"],
        ["\x59\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA2"],
        ["\x59\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA1"],
        ["\x59\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA8"],
        ["\x59\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA9"],
        ["\x59\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xAC"],
        ["\x59\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB1"],
        ["\x59\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB3"],
        ["\x59\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB0"],
        ["\x59\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB4"],
        ["\x52\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB8"],
        ["\x54\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBE"],
        ["\x59\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x83"],
        ["\x59\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x89"],
        ["\x59\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x9D"],
        ["\x59\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x9C"],
        ["\x59\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8B"],
        ["\x59\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x91"],
        ["\x59\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x96"],
        ["\x59\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA9"],
        ["\x59\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xAD"],
        ["\x59\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB8"],
        ["\x59\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x88"],
        ["\x59\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8C"],
        ["\x59\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8E"],
        ["\x59\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xAF"],
        ["\x59\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x91"],
        ["\x59\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x96"],
        ["\x59\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x97"],
        ["\x59\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x99"],
        ["\x59\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA1"],
        ["\x52\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAD"],
        ["\x59\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB3"],
        ["\x59\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB7"],
        ["\x59\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x83"],
        ["\x59\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x82"],
        ["\x59\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBF"],
        ["\x59\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8A"],
        ["\x59\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x88"],
        ["\x59\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x91"],
        ["\x59\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x87"],
        ["\x59\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x9E"],
        ["\x59\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x99"],
        ["\x59\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x98"],
        ["\x59\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA0"],
        ["\x59\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA8"],
        ["\x59\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAD"],
        ["\x59\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xBC"],
        ["\x59\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x96"],
        ["\x59\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBB"],
        ["\x59\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA4"],
        ["\x59\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB8"],
        ["\x59\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB1"],
        ["\x59\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x9D"],
        ["\x52\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB3"],
        ["\x59\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBF"],
        ["\x59\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA1"],
        ["\x5A\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA0"],
        ["\x59\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x99"],
        ["\x59\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x90"],
        ["\x59\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA9"],
        ["\x59\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x8E"],
        ["\x59\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xB1"],
        ["\x59\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9B"],
        ["\x59\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x95"],
        ["\x59\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAB"],
        ["\x59\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA6"],
        ["\x59\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x8F"],
        ["\x59\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xBA"],
        ["\x5A\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x9A"],
        ["\x5A\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x81"],
        ["\x5A\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAA"],
        ["\x5A\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB7"],
        ["\x5A\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x9F"],
        ["\x5A\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8A"],
        ["\x5A\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x86"],
        ["\x5A\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8D"],
        ["\x5A\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA3"],
        ["\x5A\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x83"],
        ["\x5A\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA4"],
        ["\x52\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x82"],
        ["\x5A\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAC"],
        ["\x5A\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAB"],
        ["\x5A\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x99"],
        ["\x5A\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x81"],
        ["\x55\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8D"],
        ["\x55\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA7"],
        ["\x5A\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x83"],
        ["\x5A\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9A"],
        ["\x5A\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x84"],
        ["\x5A\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9B"],
        ["\x5A\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x96"],
        ["\x5A\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x97"],
        ["\x5A\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x92"],
        ["\x5A\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA7"],
        ["\x5A\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8B"],
        ["\x5A\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA1"],
        ["\x5A\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB8"],
        ["\x5A\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA0"],
        ["\x5A\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x93"],
        ["\x53\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB4"],
        ["\x59\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB0"],
        ["\x5A\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xBD"],
        ["\x5A\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x86"],
        ["\x5A\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB5"],
        ["\x5A\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x98"],
        ["\x5A\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8D"],
        ["\x5A\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x95"],
        ["\x5A\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x86"],
        ["\x5A\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB6"],
        ["\x5A\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB7"],
        ["\x5A\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x80"],
        ["\x5A\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB4"],
        ["\x5A\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xBA"],
        ["\x5A\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x83"],
        ["\x5A\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA1"],
        ["\x5A\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xBB"],
        ["\x5A\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB1"],
        ["\x5A\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8D"],
        ["\x5A\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8E"],
        ["\x5A\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x87"],
        ["\x5A\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBE"],
        ["\x5A\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA8"],
        ["\x5A\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA7"],
        ["\x5A\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8A"],
        ["\x51\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBF"],
        ["\x5A\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBC"],
        ["\x5A\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xAC"],
        ["\x5A\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xB4"],
        ["\x5A\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBD"],
        ["\x5A\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x82"],
        ["\x5A\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x84"],
        ["\x5A\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB3"],
        ["\x5A\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB7"],
        ["\x5A\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x98"],
        ["\x5A\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x99"],
        ["\x5A\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9A"],
        ["\x5A\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAB"],
        ["\x5A\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB4"],
        ["\x5A\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAF"],
        ["\x5A\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA5"],
        ["\x5A\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB1"],
        ["\x5A\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9F"],
        ["\x5A\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9D"],
        ["\x5A\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x93"],
        ["\x5A\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB5"],
        ["\x5A\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x99"],
        ["\x5A\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x96"],
        ["\x5A\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x87"],
        ["\x5A\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAC"],
        ["\x5A\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x94"],
        ["\x55\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x9A"],
        ["\x5A\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x8A"],
        ["\x5A\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x91"],
        ["\x5A\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAB"],
        ["\x5A\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAE"],
        ["\x5A\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8C"],
        ["\x5A\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8A"],
        ["\x5A\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x89"],
        ["\x5A\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB7"],
        ["\x5A\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x88"],
        ["\x5A\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x83"],
        ["\x5A\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x86"],
        ["\x5A\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xBA"],
        ["\x5A\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8B"],
        ["\x5A\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB9"],
        ["\x5A\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8D"],
        ["\x5A\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xA6"],
        ["\x5A\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xA3"],
        ["\x5A\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB6"],
        ["\x5A\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBA"],
        ["\x5A\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB4"],
        ["\x5A\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBF"],
        ["\x5A\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBD"],
        ["\x5A\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBC"],
        ["\x5A\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBE"],
        ["\x5A\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x80"],
        ["\x5A\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x88"],
        ["\x5A\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x89"],
        ["\x5A\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8D"],
        ["\x54\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8C"],
        ["\x5A\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x94"],
        ["\x5A\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9B"],
        ["\x5A\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9E"],
        ["\x5A\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA1"],
        ["\x5A\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAA"],
        ["\x5A\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAE"],
        ["\x5A\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB0"],
        ["\x5A\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB2"],
        ["\x5A\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB3"],
        ["\x5A\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x81"],
        ["\x5A\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8E"],
        ["\x5A\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x9E"],
        ["\x5A\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA3"],
        ["\x5A\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x9B"],
        ["\x5A\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA0"],
        ["\x5A\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA8"],
        ["\x5A\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBC"],
        ["\x5A\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x82"],
        ["\x5A\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x89"],
        ["\x5A\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBE"],
        ["\x5A\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x92"],
        ["\x5A\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x93"],
        ["\x5A\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x96"],
        ["\x5A\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x94"],
        ["\x5A\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x83"],
        ["\x5A\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x94"],
        ["\x5A\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x97"],
        ["\x5A\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x91"],
        ["\x5A\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBB"],
        ["\x5A\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8F"],
        ["\x5A\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBF"],
        ["\x5A\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x86"],
        ["\x5B\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x94"],
        ["\x5A\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x88"],
        ["\x5A\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9C"],
        ["\x53\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8C"],
        ["\x5A\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8A"],
        ["\x5A\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x82"],
        ["\x5A\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x87"],
        ["\x5A\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9B"],
        ["\x5A\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x89"],
        ["\x5A\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x8C"],
        ["\x5A\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAE"],
        ["\x5A\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB1"],
        ["\x5A\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xA7"],
        ["\x5A\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x82"],
        ["\x5A\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x88"],
        ["\x5A\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAF"],
        ["\x5A\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB5"],
        ["\x5A\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x90"],
        ["\x5A\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBE"],
        ["\x5A\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8D"],
        ["\x5B\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x9C"],
        ["\x5A\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8F"],
        ["\x5A\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x96"],
        ["\x5A\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8E"],
        ["\x5A\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x80"],
        ["\x5A\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAB"],
        ["\x5A\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB6"],
        ["\x5A\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA3"],
        ["\x5A\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8F"],
        ["\x5A\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x89"],
        ["\x5A\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x9F"],
        ["\x5A\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB5"],
        ["\x5A\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xAB"],
        ["\x5A\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA9"],
        ["\x5A\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xBE"],
        ["\x5A\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA9"],
        ["\x5A\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x80"],
        ["\x5A\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x86"],
        ["\x5A\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA3"],
        ["\x5A\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x89"],
        ["\x5A\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x92"],
        ["\x5B\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB6"],
        ["\x5B\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x84"],
        ["\x5B\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x96"],
        ["\x5B\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xB4"],
        ["\x5B\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x86"],
        ["\x5B\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x93"],
        ["\x5B\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA6"],
        ["\x5B\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xB6"],
        ["\x5B\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x9D"],
        ["\x5B\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x97"],
        ["\x5B\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA8"],
        ["\x5B\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x8F"],
        ["\x5B\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xA7"],
        ["\x5B\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xAF"],
        ["\x5B\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB6"],
        ["\x5B\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x8E"],
        ["\x52\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAA"],
        ["\x5B\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x95"],
        ["\x5B\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x93"],
        ["\x5B\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA5"],
        ["\x5B\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA9"],
        ["\x5B\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x88"],
        ["\x5B\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBC"],
        ["\x5B\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x9A"],
        ["\x5B\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x92"],
        ["\x5B\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x85"],
        ["\x5B\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x87"],
        ["\x5B\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBB"],
        ["\x5B\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x98"],
        ["\x5B\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x82"],
        ["\x5B\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB1"],
        ["\x5B\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA7"],
        ["\x57\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x89"],
        ["\x5B\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA0"],
        ["\x5B\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA1"],
        ["\x5A\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xAC"],
        ["\x5B\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA3"],
        ["\x5B\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xAF"],
        ["\x5B\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAC"],
        ["\x5B\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB6"],
        ["\x5B\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB4"],
        ["\x5B\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB2"],
        ["\x5B\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBA"],
        ["\x5B\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x80"],
        ["\x5B\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBD"],
        ["\x5B\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x98"],
        ["\x5B\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x9C"],
        ["\x5B\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x85"],
        ["\x5B\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA4"],
        ["\x5B\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA3"],
        ["\x5B\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAB"],
        ["\x5B\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB4"],
        ["\x5B\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB5"],
        ["\x5B\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB7"],
        ["\x5B\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB6"],
        ["\x5B\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB8"],
        ["\x5B\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8B"],
        ["\x5B\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x88"],
        ["\x5B\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x96"],
        ["\x5B\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x95"],
        ["\x5B\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x8D"],
        ["\x5B\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x98"],
        ["\x51\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x9E"],
        ["\x5B\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x9D"],
        ["\x5B\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB2"],
        ["\x5B\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB8"],
        ["\x5B\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x82"],
        ["\x5B\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x83"],
        ["\x5B\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8A"],
        ["\x5B\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9B"],
        ["\x5B\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9F"],
        ["\x5B\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAB"],
        ["\x5B\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB7"],
        ["\x5B\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x83"],
        ["\x5B\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x86"],
        ["\x5B\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x81"],
        ["\x5B\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x84"],
        ["\x5B\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8C"],
        ["\x5B\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x92"],
        ["\x51\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x9B"],
        ["\x5B\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x99"],
        ["\x5B\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA0"],
        ["\x5B\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA1"],
        ["\x5B\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xB1"],
        ["\x5B\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB2"],
        ["\x52\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8A"],
        ["\x5B\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x83"],
        ["\x5B\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xBB"],
        ["\x5B\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB3"],
        ["\x5B\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB5"],
        ["\x51\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB6"],
        ["\x5B\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB4"],
        ["\x5B\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x9C"],
        ["\x51\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8F"],
        ["\x5B\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x84"],
        ["\x5B\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x89"],
        ["\x52\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x81"],
        ["\x5B\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9E"],
        ["\x5B\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9D"],
        ["\x5B\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA4"],
        ["\x50\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA7"],
        ["\x51\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA8"],
        ["\x4F\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9F"],
        ["\x5B\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA2"],
        ["\x5B\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB0"],
        ["\x5B\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x83"],
        ["\x5B\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x88"],
        ["\x4F\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x8E"],
        ["\x4E\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x89"],
        ["\x5B\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x84"],
        ["\x5B\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x98"],
        ["\x5B\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x9D"],
        ["\x5B\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x81"],
        ["\x52\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB9"],
        ["\x5B\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x89"],
        ["\x5B\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBE"],
        ["\x5B\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBC"],
        ["\x5B\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x84"],
        ["\x5B\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB8"],
        ["\x5B\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x96"],
        ["\x5B\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9A"],
        ["\x51\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA0"],
        ["\x5B\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBF"],
        ["\x5B\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA6"],
        ["\x5B\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA9"],
        ["\x5B\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB0"],
        ["\x5B\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB5"],
        ["\x5B\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB7"],
        ["\x54\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8F"],
        ["\x5B\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x96"],
        ["\x5B\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9E"],
        ["\x5B\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA6"],
        ["\x5B\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA7"],
        ["\x5B\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB8"],
        ["\x5B\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAE"],
        ["\x5B\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBF"],
        ["\x5B\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB6"],
        ["\x53\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x81"],
        ["\x5B\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB8"],
        ["\x5B\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB7"],
        ["\x5B\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x86"],
        ["\x5B\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9E"],
        ["\x54\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA0"],
        ["\x5B\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x99"],
        ["\x52\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA3"],
        ["\x5B\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA4"],
        ["\x5B\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x89"],
        ["\x5B\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB0"],
        ["\x5B\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA9"],
        ["\x54\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBC"],
        ["\x5B\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAA"],
        ["\x54\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x8C"],
        ["\x5B\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x8B"],
        ["\x5B\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA6"],
        ["\x5B\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA1"],
        ["\x5B\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x85"],
        ["\x5B\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB7"],
        ["\x5B\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAF"],
        ["\x5B\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB4"],
        ["\x5B\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAC"],
        ["\x54\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB3"],
        ["\x5B\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA9"],
        ["\x5B\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB8"],
        ["\x5B\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA4"],
        ["\x54\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9E"],
        ["\x5B\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9D"],
        ["\x5B\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA2"],
        ["\x5B\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAE"],
        ["\x5B\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB9"],
        ["\x5B\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8E"],
        ["\x5B\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x86"],
        ["\x5B\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA7"],
        ["\x4D\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x9C"],
        ["\x5B\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x9E"],
        ["\x5B\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x86"],
        ["\x52\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA9"],
        ["\x5B\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x80"],
        ["\x5B\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x8D"],
        ["\x5B\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB2"],
        ["\x5B\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x8E"],
        ["\x53\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB3"],
        ["\x52\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xAB"],
        ["\x5B\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x99"],
        ["\x5B\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xA3"],
        ["\x5C\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB7"],
        ["\x5C\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBF"],
        ["\x5C\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9F"],
        ["\x5C\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x8F"],
        ["\x5C\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAD"],
        ["\x5C\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x94"],
        ["\x4E\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9D"],
        ["\x53\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9B"],
        ["\x5C\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x83"],
        ["\x54\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAE"],
        ["\x5C\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB9"],
        ["\x5C\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB4"],
        ["\x5C\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB5"],
        ["\x52\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA0"],
        ["\x5C\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xBA"],
        ["\x5C\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8F"],
        ["\x5B\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x8D"],
        ["\x5C\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBE"],
        ["\x5C\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x81"],
        ["\x5C\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8A"],
        ["\x5C\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x88"],
        ["\x5C\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x98"],
        ["\x5C\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA2"],
        ["\x5C\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA6"],
        ["\x5C\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA1"],
        ["\x5C\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8C"],
        ["\x5C\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8D"],
        ["\x5C\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x94"],
        ["\x5C\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA7"],
        ["\x5C\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x95"],
        ["\x5C\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB6"],
        ["\x5C\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x92"],
        ["\x5C\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x84"],
        ["\x54\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x97"],
        ["\x5C\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA3"],
        ["\x53\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA5"],
        ["\x54\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB9"],
        ["\x5C\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA0"],
        ["\x5C\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAF"],
        ["\x5C\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA8"],
        ["\x5C\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xAA"],
        ["\x53\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9A"],
        ["\x5C\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA3"],
        ["\x5C\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA1"],
        ["\x5C\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x86"],
        ["\x5C\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB9"],
        ["\x5C\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB7"],
        ["\x54\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9C"],
        ["\x5C\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB8"],
        ["\x54\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAB"],
        ["\x5C\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x94"],
        ["\x5C\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBE"],
        ["\x53\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAE"],
        ["\x52\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB9"],
        ["\x5C\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB4"],
        ["\x5C\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xBD"],
        ["\x5C\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x99"],
        ["\x5C\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB0"],
        ["\x52\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA1"],
        ["\x5C\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9E"],
        ["\x5C\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9D"],
        ["\x5C\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x81"],
        ["\x5C\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAA"],
        ["\x5C\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB2"],
        ["\x51\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xAE"],
        ["\x54\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x90"],
        ["\x5C\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBF"],
        ["\x5C\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x81"],
        ["\x5C\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x93"],
        ["\x5C\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBE"],
        ["\x5C\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8E"],
        ["\x5C\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA8"],
        ["\x5C\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8A"],
        ["\x5C\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x9D"],
        ["\x5C\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBB"],
        ["\x5C\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x83"],
        ["\x53\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA7"],
        ["\x5C\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAE"],
        ["\x54\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x91"],
        ["\x5C\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA0"],
        ["\x5C\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x9C"],
        ["\x5C\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x95"],
        ["\x53\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB4"],
        ["\x5C\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x9E"],
        ["\x5C\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA8"],
        ["\x5C\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x82"],
        ["\x5C\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9B"],
        ["\x5C\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBF"],
        ["\x5C\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x8A"],
        ["\x5C\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB9"],
        ["\x5C\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB2"],
        ["\x5C\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA7"],
        ["\x53\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x85"],
        ["\x5C\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB1"],
        ["\x5C\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9E"],
        ["\x5C\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAD"],
        ["\x5C\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x94"],
        ["\x5C\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAB"],
        ["\x5C\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8A"],
        ["\x5C\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x92"],
        ["\x5C\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x81"],
        ["\x5C\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA3"],
        ["\x5C\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x93"],
        ["\x5C\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x84"],
        ["\x5C\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8C"],
        ["\x5C\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xB2"],
        ["\x5C\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB6"],
        ["\x5C\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xB8"],
        ["\x5C\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x87"],
        ["\x5C\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA2"],
        ["\x5C\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x99"],
        ["\x5C\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA6"],
        ["\x5C\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x88"],
        ["\x5C\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB8"],
        ["\x5C\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA2"],
        ["\x5C\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x90"],
        ["\x5C\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x8D"],
        ["\x5C\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA0"],
        ["\x5C\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x84"],
        ["\x5C\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA2"],
        ["\x5C\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA3"],
        ["\x5C\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x97"],
        ["\x5C\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x97"],
        ["\x5C\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xBB"],
        ["\x52\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x83"],
        ["\x5C\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x82"],
        ["\x5C\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xB8"],
        ["\x5C\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xB3"],
        ["\x5C\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAC"],
        ["\x5C\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9E"],
        ["\x5C\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x91"],
        ["\x53\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9F"],
        ["\x5C\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAA"],
        ["\x5C\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9A"],
        ["\x5C\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xAA"],
        ["\x52\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xBB"],
        ["\x5C\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x85"],
        ["\x5C\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x96"],
        ["\x5C\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xBA"],
        ["\x5C\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x92"],
        ["\x5C\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x96"],
        ["\x67\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xB1"],
        ["\x5C\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9F"],
        ["\x5C\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB8"],
        ["\x5C\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB7"],
        ["\x5C\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9C"],
        ["\x5C\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB9"],
        ["\x5C\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAE"],
        ["\x5C\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x87"],
        ["\x5C\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x83"],
        ["\x5C\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x89"],
        ["\x5C\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x90"],
        ["\x5C\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x99"],
        ["\x5C\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x94"],
        ["\x5C\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x9B"],
        ["\x5C\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x9F"],
        ["\x5C\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA1"],
        ["\x5C\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB8"],
        ["\x5C\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB9"],
        ["\x5C\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xBF"],
        ["\x5C\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x80"],
        ["\x5C\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x84"],
        ["\x5C\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x83"],
        ["\x5C\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8D"],
        ["\x5C\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x98"],
        ["\x5C\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x95"],
        ["\x5C\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x9E"],
        ["\x5C\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xA4"],
        ["\x5C\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAA"],
        ["\x5C\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAB"],
        ["\x5C\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAF"],
        ["\x5C\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB2"],
        ["\x5C\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB1"],
        ["\x5C\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB3"],
        ["\x5C\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB7"],
        ["\x5C\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBC"],
        ["\x5C\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x86"],
        ["\x5C\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8B"],
        ["\x5C\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x93"],
        ["\x5C\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x9F"],
        ["\x5C\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAC"],
        ["\x5C\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAB"],
        ["\x5C\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xB3"],
        ["\x5C\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAF"],
        ["\x68\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBE"],
        ["\x5C\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x88"],
        ["\x5C\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x93"],
        ["\x5C\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x94"],
        ["\x5C\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x9B"],
        ["\x5C\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xA4"],
        ["\x5C\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xA3"],
        ["\x5C\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9E"],
        ["\x5C\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x95"],
        ["\x5C\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA2"],
        ["\x52\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xAA"],
        ["\x5C\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x82"],
        ["\x5C\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x8D"],
        ["\x5D\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x9A"],
        ["\x5D\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x81"],
        ["\x5D\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x9B"],
        ["\x5D\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBE"],
        ["\x5D\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA8"],
        ["\x5D\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB3"],
        ["\x5D\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x92"],
        ["\x5D\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x90"],
        ["\x5D\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x84"],
        ["\x5D\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB1"],
        ["\x54\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x93"],
        ["\x5D\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBD"],
        ["\x55\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x97"],
        ["\x5D\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x85"],
        ["\x5D\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9D"],
        ["\x5D\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xAE"],
        ["\x5D\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB1"],
        ["\x5D\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBE"],
        ["\x5D\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBA"],
        ["\x5D\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9B"],
        ["\x5D\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAF"],
        ["\x5D\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x99"],
        ["\x5D\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAA"],
        ["\x5D\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9F"],
        ["\x63\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x8D"],
        ["\x5D\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB6"],
        ["\x5D\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAB"],
        ["\x5D\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBD"],
        ["\x50\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB8"],
        ["\x52\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x99"],
        ["\x52\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB5"],
        ["\x5D\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB3"],
        ["\x5D\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x92"],
        ["\x5D\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8C"],
        ["\x5D\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA3"],
        ["\x5D\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x93"],
        ["\x5D\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA4"],
        ["\x5D\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x9A"],
        ["\x5D\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB9"],
        ["\x5D\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x99"],
        ["\x5D\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8E"],
        ["\x5D\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x95"],
        ["\x51\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA4"],
        ["\x5D\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x85"],
        ["\x5D\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB9"],
        ["\x51\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x95"],
        ["\x5D\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x8A"],
        ["\x5D\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB5"],
        ["\x5D\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x87"],
        ["\x5D\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA6"],
        ["\x5D\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB8"],
        ["\x5D\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x86"],
        ["\x5D\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAC"],
        ["\x5D\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x9E"],
        ["\x5D\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8C"],
        ["\x5D\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA8"],
        ["\x5D\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x92"],
        ["\x5D\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x85"],
        ["\x5D\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xBA"],
        ["\x5D\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x99"],
        ["\x5D\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA4"],
        ["\x5D\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x95"],
        ["\x5D\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAA"],
        ["\x5D\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAE"],
        ["\x5D\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAD"],
        ["\x5D\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAE"],
        ["\x5D\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAE"],
        ["\x5D\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x99"],
        ["\x5D\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xB2"],
        ["\x5D\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9F"],
        ["\x5D\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xBE"],
        ["\x5D\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA3"],
        ["\x5D\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAB"],
        ["\x5D\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAB"],
        ["\x5D\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xB6"],
        ["\x5D\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8D"],
        ["\x5D\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9F"],
        ["\x5D\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x83"],
        ["\x5D\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xBA"],
        ["\x5D\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8E"],
        ["\x5D\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA4"],
        ["\x5D\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xBF"],
        ["\x5D\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9D"],
        ["\x5D\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB8"],
        ["\x5D\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x82"],
        ["\x5D\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xAA"],
        ["\x5D\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x98"],
        ["\x52\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x89"],
        ["\x5D\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB7"],
        ["\x52\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x93"],
        ["\x5D\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xBD"],
        ["\x5D\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xAF"],
        ["\x5D\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x84"],
        ["\x5D\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB2"],
        ["\x5D\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x94"],
        ["\x5D\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x95"],
        ["\x5D\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x8F"],
        ["\x53\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xA5"],
        ["\x5D\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x82"],
        ["\x5D\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9F"],
        ["\x5D\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x81"],
        ["\x55\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x91"],
        ["\x53\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x8C"],
        ["\x5D\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xAC"],
        ["\x5D\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB8"],
        ["\x5D\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xBE"],
        ["\x5D\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xBF"],
        ["\x5D\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB2"],
        ["\x5D\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB1"],
        ["\x5D\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xAF"],
        ["\x5D\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB2"],
        ["\x5D\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x8C"],
        ["\x5D\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xBE"],
        ["\x5D\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x93"],
        ["\x5D\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB7"],
        ["\x5D\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x86"],
        ["\x5D\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBA"],
        ["\x5D\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB8"],
        ["\x55\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x81"],
        ["\x5D\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x80"],
        ["\x5D\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAF"],
        ["\x5D\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9B"],
        ["\x5D\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB3"],
        ["\x5D\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAD"],
        ["\x5D\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x82"],
        ["\x5D\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBC"],
        ["\x5D\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x98"],
        ["\x5D\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x8E"],
        ["\x5D\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x91"],
        ["\x5D\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x82"],
        ["\x5D\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA6"],
        ["\x5D\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB3"],
        ["\x5D\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA3"],
        ["\x5D\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA1"],
        ["\x4E\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA4"],
        ["\x5D\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB9"],
        ["\x5D\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x86"],
        ["\x5D\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xAA"],
        ["\x5D\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9F"],
        ["\x5D\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x95"],
        ["\x5D\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAC"],
        ["\x5D\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x94"],
        ["\x5D\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x98"],
        ["\x50\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB1"],
        ["\x5D\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAE"],
        ["\x5D\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9B"],
        ["\x5D\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x89"],
        ["\x5D\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x8B"],
        ["\x5D\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xBA"],
        ["\x5D\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x91"],
        ["\x5D\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x81"],
        ["\x5D\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x8F"],
        ["\x51\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xBE"],
        ["\x5D\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9B"],
        ["\x5D\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9A"],
        ["\x5D\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB4"],
        ["\x52\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9D"],
        ["\x5D\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x98"],
        ["\x5D\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9F"],
        ["\x5D\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xB0"],
        ["\x5D\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xBE"],
        ["\x5D\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xB2"],
        ["\x5D\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x91"],
        ["\x5D\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xA3"],
        ["\x5D\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x99"],
        ["\x4F\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x92"],
        ["\x5D\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAF"],
        ["\x5D\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xB1"],
        ["\x5D\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAC"],
        ["\x5D\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB8"],
        ["\x52\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB3"],
        ["\x5D\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAE"],
        ["\x5D\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x9F"],
        ["\x5D\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x8B"],
        ["\x53\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x9D"],
        ["\x5D\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x99"],
        ["\x5D\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x89"],
        ["\x5D\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xBD"],
        ["\x5D\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x9C"],
        ["\x5D\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x99"],
        ["\x53\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA5"],
        ["\x68\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x95"],
        ["\x5E\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x88"],
        ["\x5D\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA6"],
        ["\x5E\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA2"],
        ["\x5E\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x8C"],
        ["\x5E\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x96"],
        ["\x5E\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xAC"],
        ["\x5E\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x8F"],
        ["\x5E\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBB"],
        ["\x5E\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x84"],
        ["\x5E\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x95"],
        ["\x54\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xA8"],
        ["\x5E\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xAC"],
        ["\x5E\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x97"],
        ["\x5E\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xB9"],
        ["\x5E\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xBE"],
        ["\x5E\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x92"],
        ["\x5E\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x89"],
        ["\x5E\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x94"],
        ["\x5E\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x8E"],
        ["\x5E\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA0"],
        ["\x5E\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAC"],
        ["\x5E\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA7"],
        ["\x5E\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xB5"],
        ["\x5E\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBC"],
        ["\x5E\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xB9"],
        ["\x5E\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBF"],
        ["\x5E\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x8D"],
        ["\x5E\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x90"],
        ["\x53\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x9B"],
        ["\x5E\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xA8"],
        ["\x5E\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAD"],
        ["\x5E\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAC"],
        ["\x5E\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB0"],
        ["\x5E\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB2"],
        ["\x5E\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBB"],
        ["\x5E\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBC"],
        ["\x5E\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBF"],
        ["\x5E\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x80"],
        ["\x5E\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x86"],
        ["\x5E\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x8B"],
        ["\x5E\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x98"],
        ["\x5E\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB4"],
        ["\x5E\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xBE"],
        ["\x5E\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x82"],
        ["\x5E\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x81"],
        ["\x5E\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x87"],
        ["\x5E\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x92"],
        ["\x5E\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x96"],
        ["\x5E\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA2"],
        ["\x5E\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA7"],
        ["\x5E\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB9"],
        ["\x5E\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB2"],
        ["\x5E\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x83"],
        ["\x5E\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x86"],
        ["\x5E\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x84"],
        ["\x5E\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x8E"],
        ["\x5E\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x92"],
        ["\x5E\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA2"],
        ["\x5E\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA0"],
        ["\x5E\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA1"],
        ["\x5E\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB9"],
        ["\x5E\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB7"],
        ["\x56\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8F"],
        ["\x5E\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x97"],
        ["\x5E\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x8A"],
        ["\x5E\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9C"],
        ["\x5E\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x96"],
        ["\x5E\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9D"],
        ["\x5E\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB4"],
        ["\x5E\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAF"],
        ["\x5E\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA9"],
        ["\x5E\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA5"],
        ["\x5E\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xBE"],
        ["\x5E\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x8E"],
        ["\x5E\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x8F"],
        ["\x5E\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x98"],
        ["\x5E\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x97"],
        ["\x5E\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xAA"],
        ["\x5E\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xA8"],
        ["\x5E\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB0"],
        ["\x5E\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB8"],
        ["\x5E\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB5"],
        ["\x5E\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xBB"],
        ["\x51\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xBA"],
        ["\x5E\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x88"],
        ["\x5E\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB3"],
        ["\x5E\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8E"],
        ["\x5E\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xBB"],
        ["\x5E\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x80"],
        ["\x5E\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA5"],
        ["\x5E\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAE"],
        ["\x5E\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x9E"],
        ["\x5E\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA2"],
        ["\x5E\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x85"],
        ["\x5E\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xAF"],
        ["\x5E\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA5"],
        ["\x5E\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB8"],
        ["\x5E\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB2"],
        ["\x5E\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xBA"],
        ["\x5E\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x95"],
        ["\x5E\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xBF"],
        ["\x5E\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9F"],
        ["\x5E\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x99"],
        ["\x5E\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x81"],
        ["\x5E\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9C"],
        ["\x5E\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA9"],
        ["\x5E\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB0"],
        ["\x5E\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA3"],
        ["\x5E\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xAA"],
        ["\x68\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB6"],
        ["\x5E\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xBE"],
        ["\x50\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x8B"],
        ["\x5E\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x9E"],
        ["\x5E\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA7"],
        ["\x5E\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x8A"],
        ["\x5E\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x8F"],
        ["\x5E\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x94"],
        ["\x5E\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB1"],
        ["\x5E\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA0"],
        ["\x5E\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA3"],
        ["\x5E\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA7"],
        ["\x5E\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA9"],
        ["\x5E\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xAE"],
        ["\x5E\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB2"],
        ["\x5E\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB0"],
        ["\x5E\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB1"],
        ["\x5E\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB8"],
        ["\x5E\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB7"],
        ["\x5E\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x84"],
        ["\x5E\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x83"],
        ["\x5E\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x85"],
        ["\x5E\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8C"],
        ["\x5E\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8E"],
        ["\x5E\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8D"],
        ["\x53\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x95"],
        ["\x5E\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x93"],
        ["\x5E\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9E"],
        ["\x5E\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA6"],
        ["\x5E\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAC"],
        ["\x5E\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBC"],
        ["\x5E\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x84"],
        ["\x5E\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8D"],
        ["\x5E\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8A"],
        ["\x5E\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x89"],
        ["\x5E\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9B"],
        ["\x5E\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x86"],
        ["\x5E\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9A"],
        ["\x52\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA9"],
        ["\x5E\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA4"],
        ["\x5E\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA7"],
        ["\x5E\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAB"],
        ["\x5E\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAD"],
        ["\x5E\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB8"],
        ["\x5E\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB6"],
        ["\x5E\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x86"],
        ["\x5E\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x87"],
        ["\x5E\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB4"],
        ["\x5E\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8A"],
        ["\x5E\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x89"],
        ["\x5E\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x82"],
        ["\x5E\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x94"],
        ["\x5E\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x9A"],
        ["\x5E\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x9D"],
        ["\x5E\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xA5"],
        ["\x5E\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xA3"],
        ["\x5E\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x82"],
        ["\x5E\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB3"],
        ["\x5E\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x83"],
        ["\x5E\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB5"],
        ["\x5E\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBD"],
        ["\x5E\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB8"],
        ["\x5E\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBC"],
        ["\x5E\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB1"],
        ["\x5E\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x8D"],
        ["\x5F\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x8A"],
        ["\x5F\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x92"],
        ["\x5F\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x99"],
        ["\x5F\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA3"],
        ["\x5F\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x9E"],
        ["\x5F\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBE"],
        ["\x5F\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBF"],
        ["\x5F\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBC"],
        ["\x5F\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x81"],
        ["\x5F\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB0"],
        ["\x5F\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBA"],
        ["\x5F\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB2"],
        ["\x5F\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB3"],
        ["\x5F\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x8B"],
        ["\x52\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x8D"],
        ["\x5F\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x89"],
        ["\x5F\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x9F"],
        ["\x5F\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA7"],
        ["\x5F\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA0"],
        ["\x5F\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA1"],
        ["\x5F\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA2"],
        ["\x5F\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA4"],
        ["\x5F\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB4"],
        ["\x5F\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB0"],
        ["\x5F\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xBB"],
        ["\x5F\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x87"],
        ["\x5F\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x88"],
        ["\x5F\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x86"],
        ["\x5F\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x9C"],
        ["\x5F\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x98"],
        ["\x5F\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA1"],
        ["\x5F\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA2"],
        ["\x5F\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA8"],
        ["\x5F\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA9"],
        ["\x5F\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAA"],
        ["\x5F\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA7"],
        ["\x5F\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAC"],
        ["\x5F\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB0"],
        ["\x5F\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB2"],
        ["\x5F\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB6"],
        ["\x53\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB8"],
        ["\x5F\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBC"],
        ["\x5F\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x80"],
        ["\x5F\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x83"],
        ["\x5F\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x88"],
        ["\x5F\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x8B"],
        ["\x52\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x8E"],
        ["\x53\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x96"],
        ["\x4E\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x93"],
        ["\x5F\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x99"],
        ["\x5F\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9A"],
        ["\x5F\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB0"],
        ["\x5F\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB4"],
        ["\x5F\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB8"],
        ["\x5F\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB9"],
        ["\x5F\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xBA"],
        ["\x5F\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x82"],
        ["\x5F\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8D"],
        ["\x5F\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x96"],
        ["\x5F\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x92"],
        ["\x5F\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9E"],
        ["\x5F\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA1"],
        ["\x5F\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA5"],
        ["\x53\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA7"],
        ["\x5F\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xAA"],
        ["\x5F\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xAF"],
        ["\x5F\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xBB"],
        ["\x5F\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x88"],
        ["\x5F\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x87"],
        ["\x5F\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x84"],
        ["\x5F\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA9"],
        ["\x5F\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA4"],
        ["\x51\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9E"],
        ["\x5F\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA5"],
        ["\x5F\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA6"],
        ["\x5F\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9B"],
        ["\x5F\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB7"],
        ["\x5F\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB8"],
        ["\x5F\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x87"],
        ["\x5F\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9A"],
        ["\x5F\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA8"],
        ["\x5F\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xAB"],
        ["\x5F\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9B"],
        ["\x5F\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA5"],
        ["\x5F\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBF"],
        ["\x5F\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBE"],
        ["\x5F\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xB9"],
        ["\x5F\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x8E"],
        ["\x5F\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x8B"],
        ["\x5F\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x91"],
        ["\x5F\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA0"],
        ["\x5F\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x9E"],
        ["\x5F\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB0"],
        ["\x5F\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB6"],
        ["\x5F\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB9"],
        ["\x5F\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBF"],
        ["\x5F\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBC"],
        ["\x5F\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBD"],
        ["\x5F\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBB"],
        ["\x5F\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x87"],
        ["\x5F\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x8D"],
        ["\x53\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x97"],
        ["\x5F\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9A"],
        ["\x5F\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9C"],
        ["\x5F\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA3"],
        ["\x5F\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAE"],
        ["\x5F\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xBC"],
        ["\x5F\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x8C"],
        ["\x5F\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x92"],
        ["\x51\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xA6"],
        ["\x5F\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA0"],
        ["\x51\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAA"],
        ["\x5F\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x85"],
        ["\x5F\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8E"],
        ["\x5F\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xB4"],
        ["\x5F\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x86"],
        ["\x5F\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xBC"],
        ["\x5F\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x9A"],
        ["\x5F\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8C"],
        ["\x5F\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA3"],
        ["\x5F\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xB5"],
        ["\x5F\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xAA"],
        ["\x5F\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xAF"],
        ["\x5F\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x91"],
        ["\x5F\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x86"],
        ["\x5F\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x8B"],
        ["\x5F\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x94"],
        ["\x5F\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBE"],
        ["\x5F\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBC"],
        ["\x5F\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x85"],
        ["\x5F\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x8A"],
        ["\x5F\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xAC"],
        ["\x5F\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA7"],
        ["\x5F\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x9A"],
        ["\x5F\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xBD"],
        ["\x5F\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xB4"],
        ["\x5F\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x87"],
        ["\x4D\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x92"],
        ["\x5F\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x91"],
        ["\x5F\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x99"],
        ["\x5F\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAC"],
        ["\x5F\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAB"],
        ["\x5F\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x80"],
        ["\x5F\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA0"],
        ["\x53\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x97"],
        ["\x5F\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9F"],
        ["\x5F\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9A"],
        ["\x5F\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x95"],
        ["\x55\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x93"],
        ["\x52\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xBA"],
        ["\x5F\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xBF"],
        ["\x5F\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8A"],
        ["\x5F\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x9D"],
        ["\x4F\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xA7"],
        ["\x51\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8B"],
        ["\x5F\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xAA"],
        ["\x54\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xAE"],
        ["\x5F\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB3"],
        ["\x53\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB9"],
        ["\x5F\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBA"],
        ["\x5F\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x89"],
        ["\x5F\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x95"],
        ["\x5F\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA7"],
        ["\x5F\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xAC"],
        ["\x54\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA1"],
        ["\x5F\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA3"],
        ["\x5F\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x88"],
        ["\x5F\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8D"],
        ["\x5F\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x98"],
        ["\x5F\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x99"],
        ["\x53\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xA0"],
        ["\x5F\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9F"],
        ["\x50\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x80"],
        ["\x5F\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB1"],
        ["\x5F\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBB"],
        ["\x5F\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBE"],
        ["\x5F\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB7"],
        ["\x5F\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x83"],
        ["\x5F\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x97"],
        ["\x5F\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x89"],
        ["\x5F\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA1"],
        ["\x5F\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA2"],
        ["\x5F\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA9"],
        ["\x5F\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x9D"],
        ["\x5F\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB0"],
        ["\x5F\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB9"],
        ["\x5F\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBD"],
        ["\x5F\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x88"],
        ["\x60\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x97"],
        ["\x5F\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x95"],
        ["\x5F\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x98"],
        ["\x5F\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x96"],
        ["\x60\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xA9"],
        ["\x52\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x88"],
        ["\x60\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xB0"],
        ["\x60\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xB6"],
        ["\x60\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x85"],
        ["\x60\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x84"],
        ["\x60\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBF"],
        ["\x60\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x83"],
        ["\x60\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x87"],
        ["\x60\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8A"],
        ["\x60\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8D"],
        ["\x60\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8F"],
        ["\x60\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x95"],
        ["\x60\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x93"],
        ["\x60\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x99"],
        ["\x60\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9A"],
        ["\x60\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9D"],
        ["\x60\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA1"],
        ["\x60\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA2"],
        ["\x60\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA6"],
        ["\x60\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAD"],
        ["\x60\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB0"],
        ["\x60\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x82"],
        ["\x60\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8F"],
        ["\x60\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8A"],
        ["\x60\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x86"],
        ["\x60\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB3"],
        ["\x53\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x98"],
        ["\x60\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x99"],
        ["\x60\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x9E"],
        ["\x60\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB5"],
        ["\x60\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA8"],
        ["\x60\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB6"],
        ["\x60\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x90"],
        ["\x60\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xBA"],
        ["\x54\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x84"],
        ["\x60\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8D"],
        ["\x60\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8B"],
        ["\x60\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8C"],
        ["\x60\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x85"],
        ["\x60\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB5"],
        ["\x54\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA5"],
        ["\x60\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB4"],
        ["\x50\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA7"],
        ["\x60\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB0"],
        ["\x60\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB1"],
        ["\x53\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAC"],
        ["\x60\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAE"],
        ["\x60\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9D"],
        ["\x60\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x98"],
        ["\x60\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9F"],
        ["\x60\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8D"],
        ["\x60\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9C"],
        ["\x60\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9A"],
        ["\x55\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8B"],
        ["\x60\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x92"],
        ["\x60\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8F"],
        ["\x60\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x9D"],
        ["\x60\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x99"],
        ["\x60\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8B"],
        ["\x51\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x81"],
        ["\x60\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8C"],
        ["\x60\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8F"],
        ["\x60\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB4"],
        ["\x60\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x86"],
        ["\x60\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x9D"],
        ["\x60\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA9"],
        ["\x4F\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x91"],
        ["\x60\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x94"],
        ["\x60\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA6"],
        ["\x60\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA5"],
        ["\x4C\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA0"],
        ["\x60\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x80"],
        ["\x60\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x87"],
        ["\x60\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x93"],
        ["\x60\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB3"],
        ["\x60\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB7"],
        ["\x51\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x97"],
        ["\x60\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x8D"],
        ["\x60\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB6"],
        ["\x60\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA3"],
        ["\x60\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA7"],
        ["\x60\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xAA"],
        ["\x60\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x9F"],
        ["\x60\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB7"],
        ["\x60\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xAB"],
        ["\x60\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBD"],
        ["\x60\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8C"],
        ["\x60\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x83"],
        ["\x4F\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x94"],
        ["\x51\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8F"],
        ["\x60\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x80"],
        ["\x60\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x90"],
        ["\x60\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x98"],
        ["\x60\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x9F"],
        ["\x52\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA4"],
        ["\x60\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x96"],
        ["\x60\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA5"],
        ["\x60\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xAC"],
        ["\x60\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB5"],
        ["\x60\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x83"],
        ["\x60\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x90"],
        ["\x60\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA4"],
        ["\x60\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAD"],
        ["\x60\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA2"],
        ["\x60\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAB"],
        ["\x60\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA1"],
        ["\x60\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA8"],
        ["\x60\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB3"],
        ["\x60\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB2"],
        ["\x60\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB1"],
        ["\x60\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAE"],
        ["\x60\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB9"],
        ["\x60\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xBD"],
        ["\x51\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x80"],
        ["\x60\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x85"],
        ["\x60\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x82"],
        ["\x60\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x98"],
        ["\x60\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x92"],
        ["\x60\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9C"],
        ["\x60\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA2"],
        ["\x67\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xBB"],
        ["\x60\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xAF"],
        ["\x60\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB2"],
        ["\x60\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB4"],
        ["\x60\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB6"],
        ["\x52\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBA"],
        ["\x60\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x86"],
        ["\x60\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x82"],
        ["\x60\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9C"],
        ["\x60\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x95"],
        ["\x60\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8A"],
        ["\x60\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x85"],
        ["\x60\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8B"],
        ["\x60\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAE"],
        ["\x60\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB2"],
        ["\x60\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBF"],
        ["\x60\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB5"],
        ["\x60\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x86"],
        ["\x60\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB3"],
        ["\x60\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x96"],
        ["\x60\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8E"],
        ["\x52\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB2"],
        ["\x60\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA8"],
        ["\x60\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xAE"],
        ["\x60\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8F"],
        ["\x60\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA3"],
        ["\x60\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x93"],
        ["\x60\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x89"],
        ["\x60\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9B"],
        ["\x53\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x8F"],
        ["\x54\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xBD"],
        ["\x54\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9B"],
        ["\x54\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBA"],
        ["\x60\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAE"],
        ["\x60\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA3"],
        ["\x60\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB5"],
        ["\x60\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x87"],
        ["\x60\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBD"],
        ["\x60\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAB"],
        ["\x60\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBD"],
        ["\x60\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA2"],
        ["\x60\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAF"],
        ["\x60\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9C"],
        ["\x60\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB8"],
        ["\x60\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9F"],
        ["\x60\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB0"],
        ["\x60\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x98"],
        ["\x60\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9D"],
        ["\x60\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA4"],
        ["\x60\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9E"],
        ["\x60\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xBB"],
        ["\x60\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB2"],
        ["\x60\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA1"],
        ["\x60\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x85"],
        ["\x60\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x8A"],
        ["\x55\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA3"],
        ["\x60\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA1"],
        ["\x60\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x92"],
        ["\x60\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB1"],
        ["\x60\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9F"],
        ["\x60\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x89"],
        ["\x60\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x8B"],
        ["\x5B\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA2"],
        ["\x60\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x86"],
        ["\x60\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA6"],
        ["\x60\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBB"],
        ["\x60\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB5"],
        ["\x60\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB9"],
        ["\x60\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x83"],
        ["\x60\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB7"],
        ["\x60\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB2"],
        ["\x60\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBA"],
        ["\x61\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA7"],
        ["\x60\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9D"],
        ["\x60\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x96"],
        ["\x60\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9E"],
        ["\x60\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x99"],
        ["\x61\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9A"],
        ["\x61\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xB9"],
        ["\x61\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xAA"],
        ["\x61\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA9"],
        ["\x61\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBC"],
        ["\x61\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBB"],
        ["\x61\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x83"],
        ["\x60\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x95"],
        ["\x61\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBD"],
        ["\x61\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAE"],
        ["\x61\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBF"],
        ["\x52\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x88"],
        ["\x61\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x89"],
        ["\x61\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8C"],
        ["\x61\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x92"],
        ["\x52\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x90"],
        ["\x61\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x93"],
        ["\x61\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x94"],
        ["\x61\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x96"],
        ["\x61\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8E"],
        ["\x61\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x9B"],
        ["\x53\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x9C"],
        ["\x61\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xB8"],
        ["\x61\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xBA"],
        ["\x61\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x85"],
        ["\x61\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8C"],
        ["\x54\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8D"],
        ["\x61\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8E"],
        ["\x51\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x90"],
        ["\x61\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x91"],
        ["\x61\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x95"],
        ["\x61\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x94"],
        ["\x61\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x98"],
        ["\x61\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x9F"],
        ["\x61\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA0"],
        ["\x61\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA8"],
        ["\x61\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA9"],
        ["\x61\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA7"],
        ["\x61\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB8"],
        ["\x61\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x82"],
        ["\x61\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x86"],
        ["\x61\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x83"],
        ["\x61\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x88"],
        ["\x61\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x87"],
        ["\x61\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8C"],
        ["\x61\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x94"],
        ["\x61\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9E"],
        ["\x61\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9D"],
        ["\x61\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9A"],
        ["\x61\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA3"],
        ["\x61\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xAF"],
        ["\x61\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB2"],
        ["\x61\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB9"],
        ["\x61\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xAE"],
        ["\x61\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB6"],
        ["\x61\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB8"],
        ["\x61\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB1"],
        ["\x61\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x85"],
        ["\x61\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x86"],
        ["\x61\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8A"],
        ["\x61\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x95"],
        ["\x54\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x94"],
        ["\x61\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA1"],
        ["\x61\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA6"],
        ["\x61\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA9"],
        ["\x61\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB3"],
        ["\x61\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB9"],
        ["\x66\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9C"],
        ["\x53\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x86"],
        ["\x61\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x84"],
        ["\x61\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8B"],
        ["\x61\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x92"],
        ["\x54\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x98"],
        ["\x61\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x99"],
        ["\x61\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x9C"],
        ["\x61\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA1"],
        ["\x61\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA8"],
        ["\x61\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBF"],
        ["\x61\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBB"],
        ["\x61\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x8A"],
        ["\x61\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x86"],
        ["\x61\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x92"],
        ["\x61\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x98"],
        ["\x54\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9A"],
        ["\x61\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9F"],
        ["\x61\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA2"],
        ["\x61\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA8"],
        ["\x61\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB3"],
        ["\x61\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB2"],
        ["\x61\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB0"],
        ["\x61\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB6"],
        ["\x61\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB9"],
        ["\x61\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBD"],
        ["\x61\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBF"],
        ["\x61\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x84"],
        ["\x53\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x86"],
        ["\x61\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x85"],
        ["\x52\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9B"],
        ["\x61\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x93"],
        ["\x61\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9A"],
        ["\x61\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAD"],
        ["\x61\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x90"],
        ["\x61\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAC"],
        ["\x61\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9B"],
        ["\x61\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA5"],
        ["\x61\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x99"],
        ["\x61\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9D"],
        ["\x61\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x84"],
        ["\x61\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9A"],
        ["\x52\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x96"],
        ["\x61\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x89"],
        ["\x61\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xAF"],
        ["\x61\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB1"],
        ["\x61\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x9B"],
        ["\x4C\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xA9"],
        ["\x61\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xA3"],
        ["\x61\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xAF"],
        ["\x61\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x8B"],
        ["\x66\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8B"],
        ["\x61\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x86"],
        ["\x61\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xBE"],
        ["\x61\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x93"],
        ["\x61\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x91"],
        ["\x61\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xBC"],
        ["\x61\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB1"],
        ["\x61\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xAE"],
        ["\x61\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA5"],
        ["\x61\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA6"],
        ["\x61\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB4"],
        ["\x61\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x83"],
        ["\x61\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x88"],
        ["\x61\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x8A"],
        ["\x61\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x80"],
        ["\x61\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x82"],
        ["\x61\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA0"],
        ["\x61\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x95"],
        ["\x61\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA4"],
        ["\x61\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA3"],
        ["\x61\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x9F"],
        ["\x61\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x93"],
        ["\x61\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA9"],
        ["\x61\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB0"],
        ["\x61\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB5"],
        ["\x61\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBE"],
        ["\x61\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB8"],
        ["\x61\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBD"],
        ["\x61\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x80"],
        ["\x61\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x82"],
        ["\x61\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBA"],
        ["\x61\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x89"],
        ["\x61\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x8D"],
        ["\x61\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x91"],
        ["\x61\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x99"],
        ["\x61\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x98"],
        ["\x61\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x88"],
        ["\x61\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x9A"],
        ["\x61\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x9F"],
        ["\x61\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA0"],
        ["\x51\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA7"],
        ["\x61\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBA"],
        ["\x61\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBB"],
        ["\x61\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBE"],
        ["\x61\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x81"],
        ["\x61\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x82"],
        ["\x61\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x85"],
        ["\x53\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x87"],
        ["\x62\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8A"],
        ["\x61\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8D"],
        ["\x61\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x90"],
        ["\x61\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x96"],
        ["\x61\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xA9"],
        ["\x61\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAB"],
        ["\x61\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB8"],
        ["\x61\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB3"],
        ["\x61\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x80"],
        ["\x61\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x99"],
        ["\x54\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x98"],
        ["\x61\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9D"],
        ["\x61\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9A"],
        ["\x61\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9F"],
        ["\x61\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA4"],
        ["\x61\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA2"],
        ["\x61\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA8"],
        ["\x61\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAA"],
        ["\x61\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAB"],
        ["\x61\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAE"],
        ["\x61\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB1"],
        ["\x61\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB7"],
        ["\x53\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB8"],
        ["\x61\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xBE"],
        ["\x61\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8D"],
        ["\x61\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x92"],
        ["\x61\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAB"],
        ["\x61\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x9F"],
        ["\x61\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBB"],
        ["\x61\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAC"],
        ["\x61\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA1"],
        ["\x61\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA3"],
        ["\x61\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9F"],
        ["\x61\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x92"],
        ["\x61\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB4"],
        ["\x61\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB3"],
        ["\x62\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBA"],
        ["\x62\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x93"],
        ["\x61\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x83"],
        ["\x61\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBB"],
        ["\x61\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB9"],
        ["\x62\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9E"],
        ["\x62\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x86"],
        ["\x62\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9C"],
        ["\x62\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x89"],
        ["\x62\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x99"],
        ["\x62\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB5"],
        ["\x62\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB4"],
        ["\x62\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x96"],
        ["\x54\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB2"],
        ["\x62\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB1"],
        ["\x62\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x80"],
        ["\x62\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB9"],
        ["\x62\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x90"],
        ["\x62\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x85"],
        ["\x62\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xAF"],
        ["\x62\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xAB"],
        ["\x53\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x97"],
        ["\x62\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x98"],
        ["\x62\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x85"],
        ["\x62\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9A"],
        ["\x62\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xAA"],
        ["\x62\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9F"],
        ["\x62\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA2"],
        ["\x62\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x96"],
        ["\x62\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xA3"],
        ["\x62\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x8E"],
        ["\x54\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x87"],
        ["\x62\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x8A"],
        ["\x62\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBC"],
        ["\x62\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xB5"],
        ["\x62\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB3"],
        ["\x62\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB5"],
        ["\x62\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA0"],
        ["\x62\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x89"],
        ["\x62\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA8"],
        ["\x62\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB4"],
        ["\x62\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x93"],
        ["\x54\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xAB"],
        ["\x62\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8E"],
        ["\x62\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xBD"],
        ["\x62\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x83"],
        ["\x62\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x98"],
        ["\x62\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8B"],
        ["\x62\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x81"],
        ["\x62\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB7"],
        ["\x62\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x87"],
        ["\x62\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xA0"],
        ["\x62\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB2"],
        ["\x62\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8D"],
        ["\x54\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA2"],
        ["\x62\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA0"],
        ["\x62\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xBD"],
        ["\x62\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB8"],
        ["\x62\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x86"],
        ["\x62\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xBB"],
        ["\x51\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAD"],
        ["\x62\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xAA"],
        ["\x62\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xBC"],
        ["\x62\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x9A"],
        ["\x62\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x84"],
        ["\x62\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB7"],
        ["\x62\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAB"],
        ["\x62\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xAD"],
        ["\x62\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAE"],
        ["\x62\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x82"],
        ["\x62\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA9"],
        ["\x62\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x86"],
        ["\x4B\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xAC"],
        ["\x62\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAF"],
        ["\x62\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB9"],
        ["\x62\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB5"],
        ["\x62\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8A"],
        ["\x62\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA2"],
        ["\x62\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB9"],
        ["\x62\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBF"],
        ["\x62\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x9F"],
        ["\x62\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x99"],
        ["\x62\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8D"],
        ["\x62\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBB"],
        ["\x62\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x9A"],
        ["\x62\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x90"],
        ["\x62\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x81"],
        ["\x62\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x86"],
        ["\x62\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x96"],
        ["\x62\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xA1"],
        ["\x54\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA1"],
        ["\x62\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xBF"],
        ["\x62\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xB4"],
        ["\x62\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x97"],
        ["\x62\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x98"],
        ["\x62\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xAC"],
        ["\x62\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x9F"],
        ["\x62\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x95"],
        ["\x62\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x94"],
        ["\x51\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xBC"],
        ["\x62\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x80"],
        ["\x62\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA3"],
        ["\x62\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x98"],
        ["\x62\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x88"],
        ["\x62\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x81"],
        ["\x54\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x82"],
        ["\x62\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8B"],
        ["\x62\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x95"],
        ["\x62\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x80"],
        ["\x62\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA4"],
        ["\x62\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x88"],
        ["\x62\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x91"],
        ["\x62\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x8A"],
        ["\x62\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA8"],
        ["\x62\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAD"],
        ["\x62\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x94"],
        ["\x62\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x9B"],
        ["\x4C\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xAA"],
        ["\x62\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x87"],
        ["\x62\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x9C"],
        ["\x62\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xB7"],
        ["\x62\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xBE"],
        ["\x62\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x90"],
        ["\x62\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x89"],
        ["\x62\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xBA"],
        ["\x62\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8F"],
        ["\x62\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xB9"],
        ["\x62\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x90"],
        ["\x62\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x95"],
        ["\x62\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x9D"],
        ["\x62\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA5"],
        ["\x62\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x9C"],
        ["\x62\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xB9"],
        ["\x62\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x8A"],
        ["\x62\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x93"],
        ["\x62\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x8B"],
        ["\x62\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBE"],
        ["\x53\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBA"],
        ["\x4E\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x86"],
        ["\x62\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xA2"],
        ["\x62\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x9A"],
        ["\x62\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xB0"],
        ["\x62\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xBF"],
        ["\x62\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x8D"],
        ["\x62\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x95"],
        ["\x52\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x94"],
        ["\x62\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9F"],
        ["\x62\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xA7"],
        ["\x62\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB1"],
        ["\x62\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x93"],
        ["\x62\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA3"],
        ["\x62\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA9"],
        ["\x62\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAA"],
        ["\x62\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8B"],
        ["\x62\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8C"],
        ["\x62\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB6"],
        ["\x62\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAF"],
        ["\x62\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x84"],
        ["\x62\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x86"],
        ["\x62\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB0"],
        ["\x62\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x89"],
        ["\x53\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA3"],
        ["\x62\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAB"],
        ["\x62\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x94"],
        ["\x62\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9E"],
        ["\x62\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xA9"],
        ["\x62\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAC"],
        ["\x62\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9F"],
        ["\x62\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9B"],
        ["\x4F\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAF"],
        ["\x62\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x92"],
        ["\x62\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x86"],
        ["\x62\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x88"],
        ["\x62\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x80"],
        ["\x62\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x83"],
        ["\x62\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBB"],
        ["\x62\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x91"],
        ["\x62\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x89"],
        ["\x62\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x8D"],
        ["\x62\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xB9"],
        ["\x62\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x8A"],
        ["\x62\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xB4"],
        ["\x62\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBF"],
        ["\x52\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xB7"],
        ["\x62\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBB"],
        ["\x62\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xA5"],
        ["\x62\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xA9"],
        ["\x62\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x9A"],
        ["\x63\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA0"],
        ["\x62\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x9F"],
        ["\x62\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB8"],
        ["\x62\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8C"],
        ["\x62\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8E"],
        ["\x63\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB4"],
        ["\x63\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x97"],
        ["\x63\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA8"],
        ["\x63\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xAE"],
        ["\x63\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x99"],
        ["\x63\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x93"],
        ["\x63\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA3"],
        ["\x63\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xAA"],
        ["\x55\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x85"],
        ["\x63\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xA2"],
        ["\x63\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x9F"],
        ["\x63\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x82"],
        ["\x63\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xAF"],
        ["\x63\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x8B"],
        ["\x63\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBD"],
        ["\x63\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x80"],
        ["\x63\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x90"],
        ["\x63\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x96"],
        ["\x63\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xAB"],
        ["\x63\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x84"],
        ["\x63\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xB3"],
        ["\x54\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x87"],
        ["\x63\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x86"],
        ["\x63\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBB"],
        ["\x63\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xAF"],
        ["\x63\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB2"],
        ["\x63\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xA0"],
        ["\x63\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8F"],
        ["\x63\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8D"],
        ["\x63\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xBE"],
        ["\x63\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB6"],
        ["\x63\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB7"],
        ["\x63\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8E"],
        ["\x63\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x92"],
        ["\x63\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x91"],
        ["\x63\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x96"],
        ["\x63\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x95"],
        ["\x63\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA2"],
        ["\x63\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA1"],
        ["\x63\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB1"],
        ["\x63\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB6"],
        ["\x63\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB9"],
        ["\x63\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA7"],
        ["\x63\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xBB"],
        ["\x63\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x84"],
        ["\x63\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x82"],
        ["\x63\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x92"],
        ["\x63\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x99"],
        ["\x63\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9E"],
        ["\x63\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA2"],
        ["\x63\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xAB"],
        ["\x63\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x81"],
        ["\x63\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBE"],
        ["\x63\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x9E"],
        ["\x63\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB5"],
        ["\x63\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBD"],
        ["\x63\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB5"],
        ["\x63\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB2"],
        ["\x63\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x82"],
        ["\x63\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x97"],
        ["\x63\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x92"],
        ["\x63\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xAE"],
        ["\x63\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x99"],
        ["\x63\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xA2"],
        ["\x63\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x8D"],
        ["\x63\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xA4"],
        ["\x54\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB0"],
        ["\x63\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xBF"],
        ["\x63\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB1"],
        ["\x63\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x83"],
        ["\x63\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x84"],
        ["\x63\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x94"],
        ["\x63\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x98"],
        ["\x63\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x99"],
        ["\x63\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9D"],
        ["\x63\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB9"],
        ["\x63\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x82"],
        ["\x63\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBC"],
        ["\x53\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB4"],
        ["\x63\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xA8"],
        ["\x63\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB2"],
        ["\x63\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x84"],
        ["\x63\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x8C"],
        ["\x63\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x8A"],
        ["\x63\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x93"],
        ["\x63\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x83"],
        ["\x63\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9E"],
        ["\x63\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xA5"],
        ["\x63\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xAA"],
        ["\x63\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xAB"],
        ["\x63\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x81"],
        ["\x50\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x84"],
        ["\x63\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xBB"],
        ["\x63\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB6"],
        ["\x63\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB8"],
        ["\x63\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x8C"],
        ["\x63\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9D"],
        ["\x63\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA0"],
        ["\x63\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x9E"],
        ["\x63\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA6"],
        ["\x63\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA4"],
        ["\x63\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAD"],
        ["\x63\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAA"],
        ["\x63\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAF"],
        ["\x63\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB4"],
        ["\x63\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB7"],
        ["\x63\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xBE"],
        ["\x63\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x83"],
        ["\x63\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x88"],
        ["\x63\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8A"],
        ["\x63\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x93"],
        ["\x63\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x98"],
        ["\x63\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA1"],
        ["\x63\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA9"],
        ["\x63\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA6"],
        ["\x63\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAC"],
        ["\x63\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAF"],
        ["\x63\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB2"],
        ["\x63\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBA"],
        ["\x63\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBD"],
        ["\x63\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBF"],
        ["\x63\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x80"],
        ["\x63\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9A"],
        ["\x53\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9C"],
        ["\x63\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9D"],
        ["\x63\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA7"],
        ["\x63\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB4"],
        ["\x63\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB8"],
        ["\x63\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x83"],
        ["\x63\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x96"],
        ["\x63\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x90"],
        ["\x63\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8C"],
        ["\x63\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9B"],
        ["\x63\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9D"],
        ["\x63\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA5"],
        ["\x63\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB6"],
        ["\x63\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x81"],
        ["\x63\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x9B"],
        ["\x63\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x92"],
        ["\x63\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x86"],
        ["\x63\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x88"],
        ["\x63\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xBC"],
        ["\x63\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAD"],
        ["\x63\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAC"],
        ["\x63\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA2"],
        ["\x63\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x85"],
        ["\x63\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x82"],
        ["\x63\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x84"],
        ["\x63\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA8"],
        ["\x63\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA1"],
        ["\x63\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x91"],
        ["\x63\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA5"],
        ["\x63\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA6"],
        ["\x63\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x9A"],
        ["\x63\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA3"],
        ["\x50\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x84"],
        ["\x63\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8D"],
        ["\x63\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x82"],
        ["\x63\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9A"],
        ["\x4E\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAB"],
        ["\x63\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB3"],
        ["\x63\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA7"],
        ["\x63\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA4"],
        ["\x63\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB1"],
        ["\x63\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x94"],
        ["\x63\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA0"],
        ["\x63\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA2"],
        ["\x63\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB7"],
        ["\x63\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9E"],
        ["\x63\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9B"],
        ["\x63\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x8C"],
        ["\x63\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x87"],
        ["\x63\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9A"],
        ["\x63\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA1"],
        ["\x63\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x96"],
        ["\x63\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x90"],
        ["\x63\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x97"],
        ["\x63\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA0"],
        ["\x63\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xB3"],
        ["\x63\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xAB"],
        ["\x63\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA6"],
        ["\x63\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xAB"],
        ["\x64\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xBE"],
        ["\x53\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA8"],
        ["\x63\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x81"],
        ["\x64\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8C"],
        ["\x64\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8F"],
        ["\x64\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8E"],
        ["\x64\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x89"],
        ["\x64\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x96"],
        ["\x64\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9B"],
        ["\x64\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9A"],
        ["\x64\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAB"],
        ["\x64\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9F"],
        ["\x64\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAC"],
        ["\x64\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAF"],
        ["\x64\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB4"],
        ["\x64\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xBD"],
        ["\x64\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x80"],
        ["\x64\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8C"],
        ["\x64\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8E"],
        ["\x64\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x92"],
        ["\x64\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x93"],
        ["\x64\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x96"],
        ["\x64\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x99"],
        ["\x64\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x9A"],
        ["\x64\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xBA"],
        ["\x64\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x81"],
        ["\x64\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xBF"],
        ["\x64\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x88"],
        ["\x64\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8C"],
        ["\x64\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8E"],
        ["\x64\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x90"],
        ["\x64\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x95"],
        ["\x64\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xA2"],
        ["\x64\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAC"],
        ["\x64\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xB8"],
        ["\x64\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xBA"],
        ["\x64\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x82"],
        ["\x64\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x89"],
        ["\x64\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x85"],
        ["\x64\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8A"],
        ["\x64\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8D"],
        ["\x64\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8E"],
        ["\x64\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x94"],
        ["\x64\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xBC"],
        ["\x64\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x98"],
        ["\x64\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9D"],
        ["\x64\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAD"],
        ["\x64\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAA"],
        ["\x64\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBD"],
        ["\x64\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB2"],
        ["\x64\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB3"],
        ["\x64\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAE"],
        ["\x64\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB6"],
        ["\x64\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x88"],
        ["\x64\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x81"],
        ["\x55\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA4"],
        ["\x64\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA3"],
        ["\x64\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9A"],
        ["\x64\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBD"],
        ["\x64\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBA"],
        ["\x64\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBB"],
        ["\x53\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x84"],
        ["\x55\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x85"],
        ["\x64\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8A"],
        ["\x64\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x87"],
        ["\x64\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8F"],
        ["\x64\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8D"],
        ["\x64\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x90"],
        ["\x68\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8E"],
        ["\x64\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x93"],
        ["\x64\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8D"],
        ["\x64\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x94"],
        ["\x64\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x96"],
        ["\x64\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA7"],
        ["\x64\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xAD"],
        ["\x64\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB1"],
        ["\x51\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB3"],
        ["\x64\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x81"],
        ["\x51\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x99"],
        ["\x64\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x82"],
        ["\x64\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xBE"],
        ["\x64\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xBA"],
        ["\x64\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8F"],
        ["\x64\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9A"],
        ["\x64\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x96"],
        ["\x64\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8C"],
        ["\x64\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9B"],
        ["\x64\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8B"],
        ["\x64\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAA"],
        ["\x64\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAB"],
        ["\x64\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9F"],
        ["\x64\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA3"],
        ["\x64\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xBC"],
        ["\x64\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x88"],
        ["\x64\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x89"],
        ["\x64\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xBF"],
        ["\x64\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9D"],
        ["\x64\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9E"],
        ["\x64\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x90"],
        ["\x64\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9F"],
        ["\x64\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x82"],
        ["\x64\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB5"],
        ["\x64\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB0"],
        ["\x64\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB4"],
        ["\x64\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x8A"],
        ["\x64\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x87"],
        ["\x64\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x89"],
        ["\x64\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x8C"],
        ["\x64\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x90"],
        ["\x64\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x88"],
        ["\x64\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x99"],
        ["\x64\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA4"],
        ["\x64\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA0"],
        ["\x50\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xAA"],
        ["\x64\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA3"],
        ["\x64\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x95"],
        ["\x64\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB6"],
        ["\x64\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB2"],
        ["\x64\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xBC"],
        ["\x64\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x81"],
        ["\x64\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x87"],
        ["\x64\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x85"],
        ["\x64\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x84"],
        ["\x64\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8B"],
        ["\x64\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8A"],
        ["\x64\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x93"],
        ["\x64\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x91"],
        ["\x64\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x94"],
        ["\x64\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x99"],
        ["\x64\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAA"],
        ["\x64\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xA1"],
        ["\x50\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAC"],
        ["\x53\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xB0"],
        ["\x64\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x86"],
        ["\x64\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xB1"],
        ["\x64\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xBE"],
        ["\x64\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x85"],
        ["\x64\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x88"],
        ["\x64\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8B"],
        ["\x64\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x9B"],
        ["\x64\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xA3"],
        ["\x64\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBC"],
        ["\x64\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBB"],
        ["\x64\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xAB"],
        ["\x64\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBE"],
        ["\x64\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x8A"],
        ["\x64\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x85"],
        ["\x64\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x95"],
        ["\x64\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x92"],
        ["\x64\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x99"],
        ["\x64\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x93"],
        ["\x64\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9C"],
        ["\x64\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9F"],
        ["\x51\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9B"],
        ["\x64\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x8C"],
        ["\x64\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xA6"],
        ["\x64\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB3"],
        ["\x64\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBB"],
        ["\x64\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB9"],
        ["\x64\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x85"],
        ["\x64\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x82"],
        ["\x64\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBE"],
        ["\x64\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8C"],
        ["\x64\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x89"],
        ["\x64\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x86"],
        ["\x64\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8E"],
        ["\x64\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x97"],
        ["\x64\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x9C"],
        ["\x64\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA2"],
        ["\x64\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA3"],
        ["\x64\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA4"],
        ["\x64\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9C"],
        ["\x64\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9F"],
        ["\x64\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA3"],
        ["\x64\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAD"],
        ["\x64\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAF"],
        ["\x64\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB7"],
        ["\x64\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x9A"],
        ["\x64\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA5"],
        ["\x64\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA2"],
        ["\x4E\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAA"],
        ["\x64\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAF"],
        ["\x51\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x87"],
        ["\x64\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB4"],
        ["\x64\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x85"],
        ["\x64\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB9"],
        ["\x54\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xBA"],
        ["\x64\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x91"],
        ["\x64\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x95"],
        ["\x64\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA1"],
        ["\x65\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8D"],
        ["\x65\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9E"],
        ["\x65\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x96"],
        ["\x65\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8B"],
        ["\x65\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA7"],
        ["\x65\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB6"],
        ["\x54\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB5"],
        ["\x65\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB9"],
        ["\x64\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB8"],
        ["\x65\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8F"],
        ["\x65\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x90"],
        ["\x65\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x91"],
        ["\x65\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x92"],
        ["\x64\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8E"],
        ["\x65\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x89"],
        ["\x65\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xBE"],
        ["\x65\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x96"],
        ["\x65\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x98"],
        ["\x65\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x9E"],
        ["\x65\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA8"],
        ["\x65\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAF"],
        ["\x65\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB6"],
        ["\x65\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA8"],
        ["\x65\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB2"],
        ["\x65\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x82"],
        ["\x65\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBD"],
        ["\x53\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x81"],
        ["\x65\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x80"],
        ["\x50\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x8A"],
        ["\x65\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x89"],
        ["\x65\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x8F"],
        ["\x51\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA8"],
        ["\x65\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xAF"],
        ["\x65\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB1"],
        ["\x65\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB5"],
        ["\x65\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA2"],
        ["\x65\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA4"],
        ["\x65\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x88"],
        ["\x65\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x9B"],
        ["\x65\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x82"],
        ["\x65\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x92"],
        ["\x65\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x99"],
        ["\x65\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB2"],
        ["\x65\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB0"],
        ["\x65\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8A"],
        ["\x65\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x96"],
        ["\x65\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x98"],
        ["\x65\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA3"],
        ["\x65\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA5"],
        ["\x65\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA9"],
        ["\x65\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB3"],
        ["\x65\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB2"],
        ["\x65\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x8B"],
        ["\x65\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x89"],
        ["\x65\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x82"],
        ["\x65\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xA2"],
        ["\x65\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAB"],
        ["\x65\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAF"],
        ["\x65\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAA"],
        ["\x65\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB5"],
        ["\x65\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB4"],
        ["\x65\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xBA"],
        ["\x65\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x80"],
        ["\x65\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x81"],
        ["\x52\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x89"],
        ["\x65\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8B"],
        ["\x65\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x90"],
        ["\x65\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x96"],
        ["\x65\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9F"],
        ["\x65\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA1"],
        ["\x65\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9B"],
        ["\x51\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xBC"],
        ["\x65\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xB5"],
        ["\x65\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xB6"],
        ["\x65\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x9E"],
        ["\x65\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xBF"],
        ["\x65\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x94"],
        ["\x65\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xAC"],
        ["\x65\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x95"],
        ["\x52\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x91"],
        ["\x53\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9E"],
        ["\x65\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x97"],
        ["\x65\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x85"],
        ["\x65\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x89"],
        ["\x65\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA4"],
        ["\x65\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x88"],
        ["\x65\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x95"],
        ["\x65\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xBF"],
        ["\x65\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x8B"],
        ["\x65\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x90"],
        ["\x65\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9C"],
        ["\x65\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x96"],
        ["\x65\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x93"],
        ["\x65\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9B"],
        ["\x65\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9A"],
        ["\x65\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x8F"],
        ["\x65\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xB9"],
        ["\x65\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xB7"],
        ["\x65\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA9"],
        ["\x65\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x8F"],
        ["\x65\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBA"],
        ["\x65\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x84"],
        ["\x52\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAE"],
        ["\x65\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x99"],
        ["\x65\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA2"],
        ["\x65\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9A"],
        ["\x65\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA3"],
        ["\x65\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xBA"],
        ["\x65\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xB5"],
        ["\x65\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xBB"],
        ["\x52\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x9C"],
        ["\x65\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xA0"],
        ["\x65\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xBC"],
        ["\x65\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xAE"],
        ["\x65\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x96"],
        ["\x65\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xB0"],
        ["\x53\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAC"],
        ["\x65\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAD"],
        ["\x65\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x94"],
        ["\x65\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xB9"],
        ["\x65\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x96"],
        ["\x65\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x97"],
        ["\x65\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA8"],
        ["\x65\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA5"],
        ["\x65\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x98"],
        ["\x65\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x83"],
        ["\x65\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x9D"],
        ["\x65\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x90"],
        ["\x65\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x88"],
        ["\x65\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA4"],
        ["\x65\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x9A"],
        ["\x65\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x94"],
        ["\x65\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x93"],
        ["\x65\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x83"],
        ["\x65\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x87"],
        ["\x51\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x90"],
        ["\x65\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB6"],
        ["\x65\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xAB"],
        ["\x51\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB5"],
        ["\x65\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xA1"],
        ["\x65\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xBA"],
        ["\x65\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x81"],
        ["\x65\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x92"],
        ["\x65\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x84"],
        ["\x65\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9B"],
        ["\x65\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xA0"],
        ["\x65\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xA2"],
        ["\x65\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9E"],
        ["\x65\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xAA"],
        ["\x65\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xA9"],
        ["\x65\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB0"],
        ["\x65\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB5"],
        ["\x66\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB7"],
        ["\x66\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBD"],
        ["\x65\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9A"],
        ["\x66\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBC"],
        ["\x66\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBE"],
        ["\x66\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x92\x81"],
        ["\x66\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBF"],
        ["\x66\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x82"],
        ["\x66\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x87"],
        ["\x66\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8A"],
        ["\x66\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x94"],
        ["\x66\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x96"],
        ["\x66\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x98"],
        ["\x66\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x99"],
        ["\x66\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA0"],
        ["\x66\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA8"],
        ["\x66\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA7"],
        ["\x66\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xAD"],
        ["\x66\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xBC"],
        ["\x66\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xBB"],
        ["\x66\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xB9"],
        ["\x66\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xBE"],
        ["\x66\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x8A"],
        ["\x66\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB6"],
        ["\x66\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x83"],
        ["\x66\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x8D"],
        ["\x66\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x8C"],
        ["\x66\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x95"],
        ["\x66\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x94"],
        ["\x66\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x96"],
        ["\x66\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x9C"],
        ["\x66\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\xA1"],
        ["\x66\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\xA5"],
        ["\x66\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\xA2"],
        ["\x66\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xA1"],
        ["\x66\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xA8"],
        ["\x66\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAE"],
        ["\x66\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAF"],
        ["\x66\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x82"],
        ["\x66\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8C"],
        ["\x66\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8F"],
        ["\x66\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8B"],
        ["\x66\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB7"],
        ["\x66\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9C"],
        ["\x52\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9E"],
        ["\x66\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9D"],
        ["\x66\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9F"],
        ["\x66\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA6"],
        ["\x66\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB2"],
        ["\x66\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xAC"],
        ["\x66\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8D"],
        ["\x66\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x98"],
        ["\x66\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x95"],
        ["\x66\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x97"],
        ["\x66\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xAA"],
        ["\x66\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA7"],
        ["\x66\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB1"],
        ["\x66\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB2"],
        ["\x66\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB0"],
        ["\x66\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB4"],
        ["\x66\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB6"],
        ["\x66\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB8"],
        ["\x66\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB9"],
        ["\x66\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8E"],
        ["\x66\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8B"],
        ["\x54\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x89"],
        ["\x52\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8D"],
        ["\x63\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x8D"],
        ["\x66\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x9C"],
        ["\x66\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8D"],
        ["\x66\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x95"],
        ["\x66\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB9"],
        ["\x66\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x84"],
        ["\x66\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x86"],
        ["\x66\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x88"],
        ["\x66\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x93"],
        ["\x66\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8E"],
        ["\x66\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x91"],
        ["\x66\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8F"],
        ["\x66\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x96"],
        ["\x66\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x99"],
        ["\x66\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xA4"],
        ["\x66\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xAA"],
        ["\x66\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB0"],
        ["\x66\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB9"],
        ["\x66\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xBD"],
        ["\x66\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xBE"],
        ["\x66\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x84"],
        ["\x66\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x86"],
        ["\x66\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x88"],
        ["\x66\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x82"],
        ["\x66\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x89"],
        ["\x66\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x9C"],
        ["\x66\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA0"],
        ["\x66\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA4"],
        ["\x66\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA6"],
        ["\x66\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA8"],
        ["\x53\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x92"],
        ["\x53\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xAB"],
        ["\x52\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB1"],
        ["\x66\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB9"],
        ["\x66\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x85"],
        ["\x66\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xBC"],
        ["\x66\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x81"],
        ["\x66\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xBA"],
        ["\x52\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x86"],
        ["\x66\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x8B"],
        ["\x66\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x8F"],
        ["\x66\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x90"],
        ["\x66\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x9C"],
        ["\x66\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA8"],
        ["\x66\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA6"],
        ["\x66\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA3"],
        ["\x66\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xB3"],
        ["\x66\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xB4"],
        ["\x66\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x83"],
        ["\x66\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x86"],
        ["\x66\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x88"],
        ["\x66\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x8B"],
        ["\x66\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x9C"],
        ["\x66\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xAD"],
        ["\x68\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8F"],
        ["\x66\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB2"],
        ["\x66\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9F"],
        ["\x52\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB6"],
        ["\x66\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB5"],
        ["\x66\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x8F"],
        ["\x54\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x8C"],
        ["\x50\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB8"],
        ["\x66\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xA4"],
        ["\x66\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xA1"],
        ["\x66\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB7"],
        ["\x66\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBD"],
        ["\x51\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x86"],
        ["\x66\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8F"],
        ["\x66\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8B"],
        ["\x66\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xAB"],
        ["\x66\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xAF"],
        ["\x66\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB0"],
        ["\x66\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB1"],
        ["\x66\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB4"],
        ["\x66\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB3"],
        ["\x66\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xAA"],
        ["\x66\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xAF"],
        ["\x66\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xB1"],
        ["\x66\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xB6"],
        ["\x66\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x84"],
        ["\x66\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x83"],
        ["\x66\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x86"],
        ["\x66\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xA9"],
        ["\x66\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAB"],
        ["\x66\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x83"],
        ["\x54\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x89"],
        ["\x66\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x92"],
        ["\x66\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x94"],
        ["\x66\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x98"],
        ["\x66\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA1"],
        ["\x66\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x9D"],
        ["\x66\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x9E"],
        ["\x66\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA4"],
        ["\x66\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA0"],
        ["\x66\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xAC"],
        ["\x66\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xAE"],
        ["\x66\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xBD"],
        ["\x66\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xBE"],
        ["\x66\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x82"],
        ["\x66\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x89"],
        ["\x66\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x85"],
        ["\x66\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x90"],
        ["\x66\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x8B"],
        ["\x66\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x91"],
        ["\x52\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x92"],
        ["\x66\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x8C"],
        ["\x66\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x95"],
        ["\x66\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x97"],
        ["\x66\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x98"],
        ["\x66\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xA5"],
        ["\x66\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xAD"],
        ["\x66\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xAE"],
        ["\x66\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xBC"],
        ["\x66\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x9F"],
        ["\x67\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x9B"],
        ["\x67\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x9D"],
        ["\x67\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x98"],
        ["\x67\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x91"],
        ["\x67\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xAD"],
        ["\x67\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xAE"],
        ["\x67\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xB1"],
        ["\x67\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xB2"],
        ["\x67\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xBB"],
        ["\x67\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xB8"],
        ["\x67\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x81"],
        ["\x67\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x8F"],
        ["\x67\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x85"],
        ["\x67\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xA2"],
        ["\x67\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x99"],
        ["\x67\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xAB"],
        ["\x67\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB7"],
        ["\x67\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x85"],
        ["\x67\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x82"],
        ["\x67\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x80"],
        ["\x67\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x83"],
        ["\x67\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xBE"],
        ["\x67\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x95"],
        ["\x67\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x8D"],
        ["\x67\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x9B"],
        ["\x67\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x97"],
        ["\x67\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x9F"],
        ["\x67\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA2"],
        ["\x67\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA5"],
        ["\x67\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA4"],
        ["\x67\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA9"],
        ["\x67\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xAB"],
        ["\x67\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xAA"],
        ["\x67\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xAD"],
        ["\x67\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xB0"],
        ["\x67\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xBC"],
        ["\x67\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x80"],
        ["\x67\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x8F"],
        ["\x67\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x91"],
        ["\x67\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x93"],
        ["\x67\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x94"],
        ["\x67\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x9E"],
        ["\x67\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x9F"],
        ["\x67\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA2"],
        ["\x67\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA3"],
        ["\x67\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA6"],
        ["\x67\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAF"],
        ["\x67\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAB"],
        ["\x67\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAE"],
        ["\x67\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xB4"],
        ["\x67\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xB1"],
        ["\x67\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xB7"],
        ["\x67\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xBB"],
        ["\x67\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x86"],
        ["\x67\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x98"],
        ["\x67\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x9A"],
        ["\x67\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x9F"],
        ["\x67\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA2"],
        ["\x67\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA3"],
        ["\x67\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA5"],
        ["\x67\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA7"],
        ["\x67\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA8"],
        ["\x67\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA9"],
        ["\x67\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAA"],
        ["\x67\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAE"],
        ["\x67\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAF"],
        ["\x67\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xB2"],
        ["\x67\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x84"],
        ["\x67\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x83"],
        ["\x53\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x8F"],
        ["\x67\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x8D"],
        ["\x67\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x8E"],
        ["\x67\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x91"],
        ["\x67\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x98"],
        ["\x67\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB4"],
        ["\x67\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x93"],
        ["\x67\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x83"],
        ["\x67\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x91"],
        ["\x67\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x96"],
        ["\x67\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x97"],
        ["\x67\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x9F"],
        ["\x67\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xA0"],
        ["\x67\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xA8"],
        ["\x67\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB4"],
        ["\x67\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x80"],
        ["\x67\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x8A"],
        ["\x67\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB9"],
        ["\x67\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x86"],
        ["\x67\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x8F"],
        ["\x67\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x91"],
        ["\x67\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x92"],
        ["\x67\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA3"],
        ["\x67\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA2"],
        ["\x67\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA4"],
        ["\x67\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x94"],
        ["\x67\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA1"],
        ["\x51\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xBA"],
        ["\x67\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB2"],
        ["\x67\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB1"],
        ["\x55\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB0"],
        ["\x67\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x95"],
        ["\x67\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x94"],
        ["\x67\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x89"],
        ["\x67\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x93"],
        ["\x67\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x8C"],
        ["\x67\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x86"],
        ["\x67\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x88"],
        ["\x67\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x92"],
        ["\x67\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x8A"],
        ["\x67\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x84"],
        ["\x67\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAE"],
        ["\x67\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x9B"],
        ["\x67\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA5"],
        ["\x67\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA4"],
        ["\x67\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA1"],
        ["\x67\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB0"],
        ["\x67\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x87"],
        ["\x67\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB2"],
        ["\x67\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x86"],
        ["\x67\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xBE"],
        ["\x67\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x9A"],
        ["\x67\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA0"],
        ["\x67\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA7"],
        ["\x67\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB6"],
        ["\x67\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB8"],
        ["\x67\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA7"],
        ["\x67\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xAC"],
        ["\x67\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB0"],
        ["\x67\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x89"],
        ["\x54\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x88"],
        ["\x67\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xAB"],
        ["\x67\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x83"],
        ["\x67\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x86"],
        ["\x67\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAA"],
        ["\x67\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xA6"],
        ["\x50\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xAF"],
        ["\x67\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xA3"],
        ["\x67\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9F"],
        ["\x67\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x84"],
        ["\x67\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x95"],
        ["\x67\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x92"],
        ["\x67\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x81"],
        ["\x67\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xBF"],
        ["\x67\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xBE"],
        ["\x67\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x86"],
        ["\x67\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x88"],
        ["\x67\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9D"],
        ["\x67\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9E"],
        ["\x67\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA4"],
        ["\x67\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x91"],
        ["\x67\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x90"],
        ["\x67\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x99"],
        ["\x67\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xB2"],
        ["\x53\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x89"],
        ["\x67\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x87"],
        ["\x67\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xAB"],
        ["\x67\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xAF"],
        ["\x67\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xBA"],
        ["\x67\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x9A"],
        ["\x67\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xA4"],
        ["\x67\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xA9"],
        ["\x67\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB2"],
        ["\x67\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x84"],
        ["\x67\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x81"],
        ["\x67\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xBB"],
        ["\x67\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB8"],
        ["\x67\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xBA"],
        ["\x67\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x86"],
        ["\x67\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x8F"],
        ["\x67\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x82"],
        ["\x67\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x99"],
        ["\x67\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x93"],
        ["\x67\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB8"],
        ["\x67\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xA6"],
        ["\x67\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xAD"],
        ["\x67\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xAF"],
        ["\x67\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xBD"],
        ["\x67\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9A"],
        ["\x67\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9B"],
        ["\x68\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9E"],
        ["\x68\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xB5"],
        ["\x68\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xB9"],
        ["\x68\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xBD"],
        ["\x68\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x81"],
        ["\x68\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x88"],
        ["\x68\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x8B"],
        ["\x68\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x8C"],
        ["\x51\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x92"],
        ["\x68\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x95"],
        ["\x68\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x91"],
        ["\x68\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x9D"],
        ["\x68\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA5"],
        ["\x53\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA9"],
        ["\x68\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB8"],
        ["\x68\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xAA"],
        ["\x68\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xAD"],
        ["\x68\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA1"],
        ["\x68\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8C"],
        ["\x51\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8E"],
        ["\x68\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8F"],
        ["\x68\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x90"],
        ["\x68\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x94"],
        ["\x68\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9C"],
        ["\x68\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9E"],
        ["\x68\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9D"],
        ["\x68\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xA0"],
        ["\x68\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xA5"],
        ["\x68\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xA8"],
        ["\x68\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xAF"],
        ["\x68\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xB4"],
        ["\x68\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xB6"],
        ["\x68\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xB7"],
        ["\x68\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xB9"],
        ["\x68\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xBB"],
        ["\x68\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xBC"],
        ["\x68\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xBD"],
        ["\x68\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x87"],
        ["\x68\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x88"],
        ["\x68\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB7"],
        ["\x68\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x95"],
        ["\x68\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xA1"],
        ["\x68\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xAC"],
        ["\x68\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xBE"],
        ["\x68\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8A"],
        ["\x68\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x92"],
        ["\x68\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x94"],
        ["\x68\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA3"],
        ["\x68\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x9F"],
        ["\x68\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA0"],
        ["\x68\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA1"],
        ["\x68\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA6"],
        ["\x68\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA7"],
        ["\x68\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xAC"],
        ["\x68\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xAA"],
        ["\x68\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xB7"],
        ["\x68\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xB2"],
        ["\x68\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xB6"],
        ["\x68\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x95"],
        ["\x68\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x9C"],
        ["\x68\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\xA0"],
        ["\x4E\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xAF"],
        ["\x4D\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x87"],
        ["\x52\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x99"],
        ["\x5E\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA4"],
        ["\x68\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9C"],
        ["\x4F\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x99"],
        ["\x41\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB0"],
        ["\x41\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB1"],
        ["\x41\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB2"],
        ["\x41\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB3"],
        ["\x41\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB4"],
        ["\x41\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB5"],
        ["\x41\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB6"],
        ["\x41\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB7"],
        ["\x41\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB8"],
        ["\x41\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB9"],
        ["\xE9\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA4"],
        ["\x42\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x87"],
        ["\x42\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x82"],
        ["\x51\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8A"],
        ["\x51\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9C"],
        ["\x51\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x88"],
        ["\x52\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x88"],
        ["\x52\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x9C"],
        ["\x52\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x89"],
        ["\x52\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xBB"],
        ["\x52\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB1"],
        ["\x53\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x88"],
        ["\x53\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB9"],
        ["\x53\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBB"],
        ["\x53\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x85"],
        ["\x56\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA8"],
        ["\x56\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA1"],
        ["\x56\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xBC"],
        ["\x56\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x80"],
        ["\x56\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x83"],
        ["\x56\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB9"],
        ["\x56\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x96"],
        ["\x56\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x92"],
        ["\x56\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8A"],
        ["\x56\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x9A"],
        ["\x56\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x94"],
        ["\x56\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8D"],
        ["\x56\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x80"],
        ["\x56\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA2"],
        ["\x56\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xBF"],
        ["\x56\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9E"],
        ["\x56\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x86"],
        ["\x56\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB0"],
        ["\x56\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x82"],
        ["\x56\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x94"],
        ["\x56\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB4"],
        ["\x56\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x98"],
        ["\x56\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8A"],
        ["\x56\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA4"],
        ["\x56\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x9D"],
        ["\x56\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xBE"],
        ["\x56\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAC"],
        ["\x56\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x95"],
        ["\x57\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x9C"],
        ["\x57\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA6"],
        ["\x57\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x80"],
        ["\x57\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9B"],
        ["\x57\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x80"],
        ["\x57\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x87"],
        ["\x57\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA4"],
        ["\x57\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB2"],
        ["\x57\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x93"],
        ["\x57\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB2"],
        ["\x57\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9D"],
        ["\x57\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x8E"],
        ["\x57\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x9C"],
        ["\x57\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8A"],
        ["\x57\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA9"],
        ["\x57\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xBF"],
        ["\x57\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x86"],
        ["\x58\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x99"],
        ["\x58\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA5"],
        ["\x58\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xAC"],
        ["\x58\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x88"],
        ["\x58\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x87"],
        ["\x58\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x8F"],
        ["\x58\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x90"],
        ["\x58\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9E"],
        ["\x58\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB2"],
        ["\x58\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8B"],
        ["\x58\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x93"],
        ["\x58\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x9B"],
        ["\x58\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x9D"],
        ["\x58\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA3"],
        ["\x58\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA4"],
        ["\x58\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBA"],
        ["\x58\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x96"],
        ["\x58\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x80"],
        ["\x58\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAF"],
        ["\x59\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x98"],
        ["\x59\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xAC"],
        ["\x59\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x9E"],
        ["\x59\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA6"],
        ["\x59\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBA"],
        ["\x59\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB5"],
        ["\x59\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA7"],
        ["\x59\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x93"],
        ["\x59\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x91"],
        ["\x59\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x82"],
        ["\x59\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAD"],
        ["\x59\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB8"],
        ["\x59\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB9"],
        ["\x59\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x90"],
        ["\x59\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA1"],
        ["\x59\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB4"],
        ["\x59\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA7"],
        ["\x59\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB7"],
        ["\x59\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x9E"],
        ["\x5A\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x9D"],
        ["\x5A\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x85"],
        ["\x5A\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8A"],
        ["\x5A\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9E"],
        ["\x5A\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x95"],
        ["\x5A\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA0"],
        ["\x5A\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB2"],
        ["\x5A\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x91"],
        ["\x5A\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xB7"],
        ["\x5A\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xB0"],
        ["\x5A\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x98"],
        ["\x5A\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x93"],
        ["\x5A\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xA6"],
        ["\x5A\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB5"],
        ["\x5B\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xA0"],
        ["\x5B\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9D"],
        ["\x5B\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8E"],
        ["\x5B\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x8E"],
        ["\x5B\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x80"],
        ["\x5B\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x95"],
        ["\x4F\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBB"],
        ["\x5B\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x89"],
        ["\x5B\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAE"],
        ["\x5B\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x9E"],
        ["\x5B\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA4"],
        ["\x5B\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA5"],
        ["\x5B\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x97"],
        ["\x5B\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x99"],
        ["\x5B\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x92"],
        ["\x5B\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB3"],
        ["\x5B\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x99"],
        ["\x5B\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xA0"],
        ["\x5B\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB2"],
        ["\x5B\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBF"],
        ["\x5B\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBA"],
        ["\x5B\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8E"],
        ["\x5B\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4\xA9"],
        ["\x5B\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA6"],
        ["\x5B\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xBB"],
        ["\x5B\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x92"],
        ["\x5B\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x80"],
        ["\x5B\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x81"],
        ["\x5B\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x84"],
        ["\x5C\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8F"],
        ["\x5C\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x93"],
        ["\x5C\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA8"],
        ["\x5C\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x94"],
        ["\x5C\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x98"],
        ["\x5C\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA2"],
        ["\x5C\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB0"],
        ["\x5C\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xAB"],
        ["\x5C\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x86"],
        ["\x5C\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xB3"],
        ["\x5C\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xBE"],
        ["\x5C\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xA2"],
        ["\x5C\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xA4"],
        ["\x5C\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x96"],
        ["\x5C\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xBF"],
        ["\x5C\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9C"],
        ["\x5C\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x86"],
        ["\x5C\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xAF"],
        ["\x5D\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9A"],
        ["\x5D\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x84"],
        ["\x5D\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x87"],
        ["\x5D\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAF"],
        ["\x5D\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x96"],
        ["\x5D\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xAC"],
        ["\x5D\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8F"],
        ["\x5D\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB8"],
        ["\x5D\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB2"],
        ["\x5D\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xBC"],
        ["\x5D\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB9"],
        ["\x5D\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9C"],
        ["\x5D\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA7"],
        ["\x5D\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xBC"],
        ["\x5D\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xBF"],
        ["\x5D\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x88"],
        ["\x5D\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB5"],
        ["\x5D\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB5"],
        ["\x5D\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x85"],
        ["\x5D\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x87"],
        ["\x5D\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA8"],
        ["\x5D\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x85"],
        ["\x5D\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAB"],
        ["\x5D\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x8F"],
        ["\x5D\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x84"],
        ["\x5D\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x9C"],
        ["\x5D\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x86"],
        ["\x5D\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x87"],
        ["\x5E\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x95"],
        ["\x5E\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x81"],
        ["\x5E\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBE"],
        ["\x5E\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB1"],
        ["\x5E\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xBE"],
        ["\x5E\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA4"],
        ["\x5E\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x96"],
        ["\x5E\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB7"],
        ["\x5E\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xBD"],
        ["\x5E\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x89"],
        ["\x5E\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x96"],
        ["\x5E\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA3"],
        ["\x5E\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x92"],
        ["\x5E\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x87"],
        ["\x5E\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB5"],
        ["\x5E\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA6"],
        ["\x5E\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xAA"],
        ["\x5E\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA9"],
        ["\x5E\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xAE"],
        ["\x5E\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA2"],
        ["\x5E\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x89"],
        ["\x5E\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x9F"],
        ["\x5E\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x81"],
        ["\x5E\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAF"],
        ["\x5F\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x82"],
        ["\x5F\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9C"],
        ["\x5F\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9E"],
        ["\x5F\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9B"],
        ["\x5F\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xA6"],
        ["\x5F\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x97"],
        ["\x5F\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x86"],
        ["\x5F\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAF"],
        ["\x5F\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA1"],
        ["\x5F\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x8E"],
        ["\x5F\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xA4"],
        ["\x5F\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xBA"],
        ["\x5F\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xB0"],
        ["\x5F\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x98"],
        ["\x5F\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x99"],
        ["\x5F\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9A"],
        ["\x5F\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x94"],
        ["\x5F\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9B"],
        ["\x5F\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x9B"],
        ["\x60\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x91"],
        ["\x60\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA7"],
        ["\x60\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9C"],
        ["\x60\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAB"],
        ["\x60\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9E"],
        ["\x60\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9D"],
        ["\x60\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x88"],
        ["\x60\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9C"],
        ["\x60\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB7"],
        ["\x60\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA0"],
        ["\x60\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x96"],
        ["\x60\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x92"],
        ["\x61\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x87"],
        ["\x61\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA1"],
        ["\x61\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9E"],
        ["\x61\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x81"],
        ["\x62\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xA2"],
        ["\x62\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBF"],
        ["\x62\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x87"],
        ["\x62\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB6"],
        ["\x62\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x88"],
        ["\x62\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB4"],
        ["\x62\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x93"],
        ["\x62\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x99"],
        ["\x62\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAB"],
        ["\x62\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9F"],
        ["\x62\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xB0"],
        ["\x62\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA0"],
        ["\x62\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA1"],
        ["\x63\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x87"],
        ["\x63\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB5"],
        ["\x63\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x92"],
        ["\x63\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB7"],
        ["\x63\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB9"],
        ["\x63\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA7"],
        ["\x63\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xBE"],
        ["\x63\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9F"],
        ["\x63\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA2"],
        ["\x63\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB6"],
        ["\x64\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x93"],
        ["\x64\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xBF"],
        ["\x64\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xB0"],
        ["\x64\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xB4"],
        ["\x64\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x92"],
        ["\x64\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB6"],
        ["\x64\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA3"],
        ["\x64\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8F"],
        ["\x64\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA4"],
        ["\x65\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA5"],
        ["\x65\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA7"],
        ["\x65\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x9E"],
        ["\x65\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA6"],
        ["\x65\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x95"],
        ["\x65\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xA7"],
        ["\x65\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9A"],
        ["\x65\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x97"],
        ["\x65\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9E"],
        ["\x65\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xAD"],
        ["\x65\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xAE"],
        ["\x65\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA4"],
        ["\x65\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA5"],
        ["\x65\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x86"],
        ["\x65\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x90"],
        ["\x65\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x8A"],
        ["\x65\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xBA"],
        ["\x65\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x80"],
        ["\x65\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xBC"],
        ["\x65\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x8E"],
        ["\x65\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x99"],
        ["\x65\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x91"],
        ["\x65\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB9"],
        ["\x65\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA7"],
        ["\x65\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xA7"],
        ["\x65\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xB7"],
        ["\x65\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xB8"],
        ["\x65\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA7"],
        ["\x65\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x97"],
        ["\x65\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x99"],
        ["\x65\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x90"],
        ["\x65\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA7"],
        ["\x65\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x95"],
        ["\x65\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA0"],
        ["\x65\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x93"],
        ["\x65\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA5"],
        ["\x65\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA1"],
        ["\x65\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBB"],
        ["\x65\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA8"],
        ["\x65\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9E"],
        ["\x65\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBF"],
        ["\x65\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9D"],
        ["\x65\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x82"],
        ["\x65\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xB0"],
        ["\x65\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x97"],
        ["\x65\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xA4"],
        ["\x65\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x86"],
        ["\x65\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x9E"],
        ["\x65\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xB8"],
        ["\x65\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB1"],
        ["\x65\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x85"],
        ["\x65\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x88"],
        ["\x66\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x92"],
        ["\x66\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7\x9C"],
        ["\x66\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA9"],
        ["\x66\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x9D"],
        ["\x66\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xAF"],
        ["\x66\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB3"],
        ["\x66\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xBB"],
        ["\x66\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x83"],
        ["\x66\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x8D"],
        ["\x66\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x8F"],
        ["\x66\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x91"],
        ["\x66\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x95"],
        ["\x66\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x97"],
        ["\x66\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xA5"],
        ["\x66\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xAA"],
        ["\x66\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xAB"],
        ["\x66\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA7"],
        ["\x66\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xAC"],
        ["\x66\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x9E"],
        ["\x67\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x8E"],
        ["\x67\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x99"],
        ["\x67\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x9C"],
        ["\x67\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB5"],
        ["\x67\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB2"],
        ["\x67\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x8F"],
        ["\x67\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB1"],
        ["\x67\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xBB"],
        ["\x67\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x80"],
        ["\x67\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xB0"],
        ["\x67\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xAB"],
        ["\x67\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xAD"],
        ["\x67\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x99"],
        ["\x68\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x91"],
        ["\x44\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x95"],
        ["\x44\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA5"],
        ["\x42\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8D"],
        ["\xE6\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\xB3"],
        ["\xE6\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\xB4"],
        ["\xE6\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\xB5"],
        ["\xE6\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\xBB"],
        ["\xE6\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\xBC"],
        ["\xE6\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBF"],
        ["\xE6\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9F"],
        ["\xE0\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x84"],
        ["\xE0\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x85"],
        ["\xE0\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x8A"],
        ["\xE0\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x8B"],
        ["\xDF\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x89"],
        ["\xDF\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x85"],
        ["\xE0\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C\x85"],
        ["\xE0\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C\x86"],
        ["\xE0\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x95"],
        ["\xE0\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x96"],
        ["\xE0\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x97"],
        ["\xDF\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA6"],
        ["\xE9\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9F"],
        ["\xE9\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xA0"],
        ["\xE6\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x98"],
        ["\xE6\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x99"],
        ["\xE6\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x96"],
        ["\xE6\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x97"],
        ["\xE0\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA2"],
        ["\xDF\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\x83"],
        ["\xDF\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\x85"],
        ["\xE0\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\x88"],
        ["\xE0\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xB6"],
        ["\xE0\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xB7"],
        ["\xDF\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x94"],
        ["\xE4\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAE"],
        ["\xE4\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAB"],
        ["\xE4\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAC"],
        ["\xE4\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA9"],
        ["\xE3\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB7"],
        ["\xE3\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB6"],
        ["\xE3\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x81"],
        ["\xE3\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x80"],
        ["\xDF\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x97"],
        ["\xDF\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x98"],
        ["\xDF\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x96"],
        ["\xDF\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x99"],
        ["\xDF\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\x84"],
        ["\xDF\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\xA8"],
        ["\xDF\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\xA6"],
        ["\xDF\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\xA7"],
        ["\xDF\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\xA9"],
        ["\xEB\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4\xB4"],
        ["\xEB\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4\xB5"],
        ["\xEC\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6\xBF"],
        ["\xE3\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x89"],
        ["\xE6\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\xBD"],
        ["\xEC\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xB9\x86"],
        ["\xEC\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xB9\x85"],
        ["\xE4\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\xA6"],
        ["\xDD\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA2"],
        ["\xDF\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x93"],
        ["\xDE\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\xB5"],
        ["\xDE\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x8F"],
        ["\xE9\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F\x8B"],
        ["\xDE\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x93"],
        ["\xDE\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\xA7"],
        ["\xE6\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA0"],
        ["\xDD\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x93"],
        ["\xEC\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7\xBA"],
        ["\xEC\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7\xBB"],
        ["\xE6\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x94"],
        ["\xE6\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x95"],
        ["\xE6\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x96"],
        ["\xE4\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA4"],
        ["\xE4\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA0"],
        ["\xE4\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA2"],
        ["\xE4\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA6"],
        ["\xE4\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA1"],
        ["\xE4\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA5"],
        ["\xE4\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA7"],
        ["\xE4\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA3"],
        ["\xD9\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x82"],
        ["\xE3\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB5"],
        ["\xE3\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB6"],
        ["\xE3\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB7"],
        ["\xE3\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB8"],
        ["\xE3\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB9"],
        ["\xE3\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xBA"],
        ["\xE3\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xBB"],
        ["\xE3\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xBC"],
        ["\xE3\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xBD"],
        ["\xE3\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xBE"],
        ["\xE4\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x96"],
        ["\xE4\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x97"],
        ["\xE6\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\xA0"],
        ["\xE4\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x8E"],
        ["\xE4\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x80"],
        ["\xE4\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x81"],
        ["\xE4\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x82"],
        ["\xE4\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x83"],
        ["\xE4\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA8"],
        ["\xE3\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB1"],
        ["\xEC\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB0"],
        ["\xEC\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB1"],
        ["\xEC\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB2"],
        ["\xEC\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB3"],
        ["\xEC\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB4"],
        ["\xEC\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB5"],
        ["\xEC\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB6"],
        ["\xEC\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB7"],
        ["\xEC\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB8"],
        ["\xEC\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB9"],
        ["\xEC\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xBA"],
        ["\xEC\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xBB"],
        ["\xEC\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xBC"],
        ["\xEC\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xBD"],
        ["\xEC\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xBE"],
        ["\xEC\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xBF"],
        ["\xE0\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8E\xBE"],
        ["\xE0\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8E\xBF"],
        ["\xE0\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x80"],
        ["\xE0\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x81"],
        ["\xE0\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x82"],
        ["\xE0\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x83"],
        ["\xE0\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x84"],
        ["\xE0\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x85"],
        ["\xE0\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x86"],
        ["\xE0\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x87"],
        ["\xE1\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x88"],
        ["\xE1\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x89"],
        ["\xE1\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x8A"],
        ["\xE1\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x8B"],
        ["\xE1\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x8C"],
        ["\xE6\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB7"],
        ["\xE6\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB8"],
        ["\xE6\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB9"],
        ["\xE6\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBA"],
        ["\xE0\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8B\x9A"],
        ["\xE0\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8B\x9B"],
        ["\xDE\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\x93"],
        ["\xDE\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\x94"],
        ["\xDE\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\x95"],
        ["\xE5\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x9C\x93"],
        ["\xE0\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C\x98"],
        ["\xEA\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x90\xA3"],
        ["\xE1\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x8E"],
        ["\xE7\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x91"],
        ["\xE7\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x92"],
        ["\xE7\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x93"],
        ["\xE7\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x94"],
        ["\xE7\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x95"],
        ["\xE7\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x96"],
        ["\xE7\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x97"],
        ["\xE7\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x98"],
        ["\xE7\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x99"],
        ["\xE7\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x9A"],
        ["\xE7\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x9B"],
        ["\xE7\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x9C"],
        ["\xE7\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x9D"],
        ["\xE7\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x9E"],
        ["\xE7\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x9F"],
        ["\xE7\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB1"],
        ["\xE7\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB2"],
        ["\xE7\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB3"],
        ["\xE7\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB4"],
        ["\xE7\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB5"],
        ["\xE7\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB6"],
        ["\xE7\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB7"],
        ["\xE7\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB8"],
        ["\xE7\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB9"],
        ["\xE7\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xBA"],
        ["\xE7\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xBB"],
        ["\xE7\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xBC"],
        ["\xE7\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xBD"],
        ["\xE7\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xBE"],
        ["\xE7\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xBF"],
        ["\xE3\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x90"],
        ["\xE3\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x91"],
        ["\xE3\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x92"],
        ["\xE3\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x93"],
        ["\xDD\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xBC"],
        ["\xDD\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x81\x87"],
        ["\xDD\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x81\x88"],
        ["\xDD\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x81\x89"],
        ["\xD7\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\x8D"],
        ["\xD7\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\x8E"],
        ["\xD7\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\x90"],
        ["\xDA\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8\xBE"],
        ["\xDA\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8\xBF"],
        ["\xD7\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xB8"],
        ["\xD7\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xB9"],
        ["\xD7\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\x91"],
        ["\xD7\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\x92"],
        ["\xD7\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\x94"],
        ["\xD7\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\x96"],
        ["\xD7\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\x98"],
        ["\xD7\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\x9A"],
        ["\xD7\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\x9C"],
        ["\x42\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x82\xAC"],
        ["\xD6\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xA0"],
        ["\xD6\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],
        ["\xD6\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xA4"],
        ["\x42\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xA6"],
        ["\xD6\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xA9"],
        ["\xD6\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xAA"],
        ["\xD6\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xAB"],
        ["\xD6\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xAD"],
        ["\xD6\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xAE"],
        ["\xD6\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xAF"],
        ["\xD6\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB2"],
        ["\xD6\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB3"],
        ["\xD6\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB7"],
        ["\xD6\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB8"],
        ["\xD6\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB9"],
        ["\xD6\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xBA"],
        ["\xD6\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xBB"],
        ["\xD6\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xBC"],
        ["\xD6\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xBD"],
        ["\xD6\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xBE"],
        ["\xD6\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xBF"],
        ["\xD6\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x80"],
        ["\xD6\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x81"],
        ["\xD6\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x82"],
        ["\xD6\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x83"],
        ["\xD6\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x84"],
        ["\xD6\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x85"],
        ["\xD6\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x86"],
        ["\xD6\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x87"],
        ["\xD6\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x88"],
        ["\xD6\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x89"],
        ["\xD6\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x8A"],
        ["\xD6\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x8B"],
        ["\xD6\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x8C"],
        ["\xD6\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x8D"],
        ["\xD6\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x8E"],
        ["\xD6\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x8F"],
        ["\xD6\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x90"],
        ["\xD6\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x91"],
        ["\xD6\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x92"],
        ["\xD6\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x93"],
        ["\xD6\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x94"],
        ["\xD6\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x95"],
        ["\xD6\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x96"],
        ["\xD6\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x98"],
        ["\xD6\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x99"],
        ["\xD6\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x9A"],
        ["\xD6\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x9B"],
        ["\xD6\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x9C"],
        ["\xD6\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x9D"],
        ["\xD6\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x9E"],
        ["\xD6\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x9F"],
        ["\xD6\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA0"],
        ["\xD6\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],
        ["\xD6\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],
        ["\xD6\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA3"],
        ["\xD6\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA4"],
        ["\xD6\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA5"],
        ["\xD6\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6"],
        ["\xD6\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA7"],
        ["\xD6\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],
        ["\xD6\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA9"],
        ["\xD6\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xAA"],
        ["\xD6\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],
        ["\xD6\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xAC"],
        ["\xD6\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xAD"],
        ["\xD6\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xAE"],
        ["\xD6\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xAF"],
        ["\xD6\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],
        ["\xD6\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB1"],
        ["\xD6\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB2"],
        ["\xD6\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB3"],
        ["\xD6\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB4"],
        ["\xD6\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB5"],
        ["\xD6\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB6"],
        ["\xD6\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB8"],
        ["\xD6\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB9"],
        ["\xD6\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],
        ["\xD6\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xBB"],
        ["\xD6\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],
        ["\xD6\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xBD"],
        ["\xD6\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xBE"],
        ["\xD6\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xBF"],
        ["\xD6\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x80"],
        ["\xD6\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xAA"],
        ["\xD7\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xAA"],
        ["\xD6\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x92"],
        ["\xD7\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x8C"],
        ["\xD6\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x81"],
        ["\xD6\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],
        ["\xD7\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xAB"],
        ["\xD6\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x93"],
        ["\xD7\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x8D"],
        ["\xD6\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x84"],
        ["\xD8\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\x98"],
        ["\xD6\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x81"],
        ["\xD6\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xBD"],
        ["\xD7\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x9A"],
        ["\xD7\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xA0"],
        ["\xD7\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x9E"],
        ["\xD7\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xA4"],
        ["\xD7\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xB9"],
        ["\xD7\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xBD"],
        ["\xD7\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xBB"],
        ["\xD6\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x85"],
        ["\xD8\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\x9B"],
        ["\xD6\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x82"],
        ["\xD6\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xBE"],
        ["\xD7\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x9B"],
        ["\xD8\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\x87"],
        ["\xD7\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],
        ["\xD7\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x9F"],
        ["\xD7\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xA5"],
        ["\xD7\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xBA"],
        ["\xD8\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\x9D"],
        ["\xD7\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xBE"],
        ["\xD7\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xBC"],
        ["\xD7\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x94"],
        ["\xD6\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x82"],
        ["\xD6\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xB9"],
        ["\xD6\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x86"],
        ["\xD6\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x8C"],
        ["\xD6\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x98"],
        ["\xD6\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x9A"],
        ["\xD6\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x8E"],
        ["\xD6\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x83"],
        ["\xD7\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x87"],
        ["\xD7\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x90"],
        ["\xD7\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x98"],
        ["\xD7\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xAE"],
        ["\xD7\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],
        ["\xD7\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xA2"],
        ["\xD7\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x95"],
        ["\xD6\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x83"],
        ["\xD6\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xBA"],
        ["\xD6\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x87"],
        ["\xD6\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x8D"],
        ["\xD6\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x99"],
        ["\xD6\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x9B"],
        ["\xD6\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x8F"],
        ["\xD6\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x91"],
        ["\xD6\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x84"],
        ["\xD7\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x88"],
        ["\xD7\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x91"],
        ["\xD7\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x99"],
        ["\xD7\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xAF"],
        ["\xD7\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xB1"],
        ["\xD7\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xA3"],
        ["\xD8\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\x99"],
        ["\xD6\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x88"],
        ["\xD6\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x9C"],
        ["\xD6\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xA4"],
        ["\xD6\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xB4"],
        ["\xD7\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x9C"],
        ["\xD7\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xAC"],
        ["\xD6\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x89"],
        ["\xD6\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\x9D"],
        ["\xD6\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xA5"],
        ["\xD6\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xB5"],
        ["\xD7\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x9D"],
        ["\xD7\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xAD"],
        ["\xD8\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xB1"],
        ["\xD8\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\x8B"],
        ["\xD8\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xBE"],
        ["\xD8\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\x83"],
        ["\xD8\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\x92"],
        ["\xD8\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xAC"],
        ["\xD8\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xAE"],
        ["\xD8\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xB9"],
        ["\xD8\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\x88"],
        ["\xD8\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\x96"],
        ["\xD8\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xB3"],
        ["\xD8\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xBD"],
        ["\xD8\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\x82"],
        ["\xD8\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\x90"],
        ["\xD8\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xBB"],
        ["\xD8\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xAD"],
        ["\xD8\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\x9F"],
        ["\xD8\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xB2"],
        ["\xD8\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\x9D"],
        ["\xD8\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\x8E"],
        ["\xD8\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xA1"],
        ["\xD7\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x8B"],
        ["\xD8\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],
        ["\xD8\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\x81"],
        ["\xD6\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xA7"],
        ["\xD8\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\x95"],
        ["\xD8\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\x94"],
        ["\xD8\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xA6"],
        ["\xD8\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\x98"],
        ["\xD7\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\x82"],
        ["\xD8\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\x93"],
        ["\xD8\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\x97"],
        ["\xD8\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\x84"],
        ["\xD8\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xA0"],
        ["\xD7\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\x93"],
        ["\xD7\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x93"],
        ["\xD7\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\x92"],
        ["\xD8\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xA8"],
        ["\xD8\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\x89"],
        ["\xD8\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\x98"],
        ["\xD8\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xB5"],
        ["\xD8\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\x99"],
        ["\xD8\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\x9C"],
        ["\xD8\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\x9E"],
        ["\xD8\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\x90"],
        ["\xD8\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xAF"],
        ["\xD8\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\x8A"],
        ["\xD8\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xA4"],
        ["\xD8\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\x8C"],
        ["\xD8\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\x94"],
        ["\xD8\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\x91"],
        ["\xD8\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\x92"],
        ["\xD8\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\x8D"],
        ["\xD8\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xA5"],
        ["\xD8\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xA2"],
        ["\xD8\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xA1"],
        ["\xD8\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\x95"],
        ["\xD8\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\x91"],
        ["\xD8\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xBA"],
        ["\xD8\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xA7"],
        ["\xD8\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\x9A"],
        ["\xD7\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xBD"],
        ["\xDC\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD\xB0"],
        ["\xDC\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD\xB1"],
        ["\xDC\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD\xB2"],
        ["\xDC\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD\xB3"],
        ["\xEA\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xA1"],
        ["\xD8\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\x88"],
        ["\xD8\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\x8C"],
        ["\xD8\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\x90"],
        ["\xD8\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\x91"],
        ["\xEA\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\x86"],
        ["\xDD\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xBF"],
        ["\xEA\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\x8B"],
        ["\xEA\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\x81"],
        ["\xEA\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\x84"],
        ["\xEA\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\x80"],
        ["\xEA\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\x8F"],
        ["\xEA\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\x8C"],
        ["\xEA\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\x82"],
        ["\xD9\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xA5"],
        ["\xD9\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xA6"],
        ["\xD9\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xA7"],
        ["\xD9\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xA8"],
        ["\xD9\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xA9"],
        ["\xEA\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xA5"],
        ["\xEA\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xAC"],
        ["\xEA\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xB9"],
        ["\xEA\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\x9C"],
        ["\xEA\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\x9F"],
        ["\xEA\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xA0"],
        ["\xEA\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\x88"],
        ["\xEA\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xBD"],
        ["\xEA\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xA9"],
        ["\xEA\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xAF"],
        ["\xD9\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\x9E"],
        ["\xEA\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xA4"],
        ["\xEA\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xB0"],
        ["\xEA\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xBC"],
        ["\xEA\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xB4"],
        ["\xEA\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\x9D"],
        ["\xEA\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\x9E"],
        ["\xEA\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\x98"],
        ["\xEA\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\x99"],
        ["\xEA\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xAA"],
        ["\xEA\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xBA"],
        ["\xEA\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xBB"],
        ["\xEA\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\x83"],
        ["\xEA\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\x9A"],
        ["\xE5\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xB6"],
        ["\xE6\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xB7"],
        ["\xE6\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xB8"],
        ["\xE6\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xB9"],
        ["\xE6\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xBA"],
        ["\xE6\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xBB"],
        ["\xE6\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xBC"],
        ["\xE6\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xBD"],
        ["\xE6\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xBE"],
        ["\xE6\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xBF"],
        ["\xE2\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xAB"],
        ["\xE2\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xAC"],
        ["\xE2\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xAD"],
        ["\xE2\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xAE"],
        ["\xE3\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xAF"],
        ["\xE3\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB0"],
        ["\xE3\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB1"],
        ["\xE3\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB2"],
        ["\xE3\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB3"],
        ["\xE3\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB4"],
        ["\xDF\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xBA"],
        ["\xDF\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xBB"],
        ["\xE2\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x90"],
        ["\xE2\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x91"],
        ["\xE2\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x92"],
        ["\xE2\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x93"],
        ["\xE2\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x94"],
        ["\xE2\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x95"],
        ["\xE2\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x96"],
        ["\xE2\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x97"],
        ["\xE2\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x98"],
        ["\xE2\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x99"],
        ["\xE2\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9A"],
        ["\xE2\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9B"],
        ["\xE2\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9C"],
        ["\xE2\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9D"],
        ["\xE2\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9E"],
        ["\xE2\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9F"],
        ["\xE2\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA0"],
        ["\xE2\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA1"],
        ["\xE2\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA2"],
        ["\xE2\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA3"],
        ["\xE2\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA4"],
        ["\xE2\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA5"],
        ["\xE2\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA6"],
        ["\xE2\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA7"],
        ["\xE2\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA8"],
        ["\xE2\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA9"],
        ["\xE7\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x90"],
        ["\xE7\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x91"],
        ["\xE7\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x92"],
        ["\xE7\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x93"],
        ["\xE7\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x94"],
        ["\xE7\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x95"],
        ["\xE7\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x96"],
        ["\xE7\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x97"],
        ["\xE7\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x98"],
        ["\xE7\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x99"],
        ["\xE7\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x9A"],
        ["\xE7\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x9B"],
        ["\xE7\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x9C"],
        ["\xE7\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x9D"],
        ["\xE7\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x9E"],
        ["\xE7\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x9F"],
        ["\xE7\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA0"],
        ["\xE7\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA1"],
        ["\xE7\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA2"],
        ["\xE7\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA3"],
        ["\xE7\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xBA"],
        ["\xE7\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA9"],
        ["\xE7\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA5"],
        ["\xE7\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xAD"],
        ["\xE7\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xAC"],
        ["\xDD\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x81\x91"],
        ["\xDD\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x81\x82"],
        ["\xDF\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xAA"],
        ["\xDF\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xAB"],
        ["\xE5\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\x96"],
        ["\xE4\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x9E"],
        ["\xB3\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB1"],
        ["\xB3\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x80\x8B"],
        ["\xB3\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x90\x82"],
        ["\xB8\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAF"],
        ["\xB8\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB0"],
        ["\xB8\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8D"],
        ["\xB8\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xBD"],
        ["\xB8\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xBF"],
        ["\xB8\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8B"],
        ["\xB8\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xA0"],
        ["\xB8\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x88"],
        ["\xB8\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x89"],
        ["\xB8\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9F"],
        ["\xB8\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xAA"],
        ["\xB8\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xAC"],
        ["\xB8\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBE"],
        ["\xB8\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x97"],
        ["\xB3\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB0"],
        ["\xB8\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA0"],
        ["\xB8\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x81"],
        ["\xB3\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x82"],
        ["\xB8\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8E"],
        ["\xB8\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x98"],
        ["\xB8\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA7"],
        ["\xB8\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAE"],
        ["\xB8\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xBB"],
        ["\xB8\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x81"],
        ["\xB8\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8C"],
        ["\xB9\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB2"],
        ["\xB9\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x90"],
        ["\xB9\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA6"],
        ["\xB3\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB1"],
        ["\xB9\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x86"],
        ["\xB9\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x83"],
        ["\xB9\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x8B"],
        ["\xB9\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9E"],
        ["\xB9\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xB5"],
        ["\xB3\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB2"],
        ["\xB9\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x95"],
        ["\xB9\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x97"],
        ["\xB3\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x92\xB5"],
        ["\xB3\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x83"],
        ["\xB3\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8A"],
        ["\xB9\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9E"],
        ["\xB9\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA2"],
        ["\xB9\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAE"],
        ["\xB9\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x81"],
        ["\xB3\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x93\x9B"],
        ["\xB9\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x93"],
        ["\xB9\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x89"],
        ["\xB9\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x97"],
        ["\xB9\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA1"],
        ["\xB9\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x93"],
        ["\xB9\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x88"],
        ["\xB3\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB3"],
        ["\xB9\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x8C"],
        ["\xB3\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x90"],
        ["\xB9\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x96"],
        ["\xB3\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB4"],
        ["\xB9\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB0"],
        ["\xB3\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBB"],
        ["\xB9\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x9C"],
        ["\xB3\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB5"],
        ["\xB9\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA1"],
        ["\xB9\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA3"],
        ["\xB3\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBD"],
        ["\xBA\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x9D"],
        ["\xB3\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x92"],
        ["\xBA\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA7"],
        ["\xBA\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x8D"],
        ["\xBA\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xAB"],
        ["\xBA\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB4"],
        ["\xBA\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBF"],
        ["\xBA\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x88"],
        ["\xBA\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x96"],
        ["\xBA\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA1"],
        ["\xBA\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x86"],
        ["\xBA\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x8E"],
        ["\xBA\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xAB"],
        ["\xBA\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB5"],
        ["\xBA\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x90"],
        ["\xBA\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x9E"],
        ["\xBA\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x81"],
        ["\xBA\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x8E"],
        ["\xB3\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB6"],
        ["\xBA\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAD"],
        ["\xBA\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x8E"],
        ["\xB3\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB7"],
        ["\xBA\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x88"],
        ["\xBA\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x8E"],
        ["\xBA\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xBB"],
        ["\xBA\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x89"],
        ["\xB3\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB6"],
        ["\xBA\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA6"],
        ["\xB3\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB8"],
        ["\xBB\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAF"],
        ["\xBB\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB1"],
        ["\xBB\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB2"],
        ["\xBB\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x99"],
        ["\xBB\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x9E"],
        ["\xBB\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA9"],
        ["\xBB\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xAC"],
        ["\xBB\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xB3"],
        ["\xBB\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x89"],
        ["\xBB\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x8A"],
        ["\xBB\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8A"],
        ["\xB3\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x88\xBD"],
        ["\xB3\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA1"],
        ["\xBB\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xAF"],
        ["\xBB\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB3"],
        ["\xBB\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB4"],
        ["\xBB\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xB0"],
        ["\xBB\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xB7"],
        ["\xBB\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xBC"],
        ["\xBB\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x9C"],
        ["\xB3\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x8C\x9B"],
        ["\xBB\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xB8"],
        ["\xBB\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8F"],
        ["\xBB\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA4"],
        ["\xBB\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xAD"],
        ["\xBB\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB5"],
        ["\xBB\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB6"],
        ["\xBB\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBF"],
        ["\xBB\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x89"],
        ["\xBB\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA1"],
        ["\xBB\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA4"],
        ["\xB3\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB9"],
        ["\xBB\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xBC"],
        ["\xBB\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x89"],
        ["\xB3\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xBA"],
        ["\xBB\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xA9"],
        ["\xB3\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x91\xAE"],
        ["\xBC\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x92"],
        ["\xBB\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8E"],
        ["\xBC\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x94"],
        ["\xBC\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9A"],
        ["\xB3\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA0"],
        ["\xBC\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA9"],
        ["\xBC\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8C"],
        ["\xCB\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x81"],
        ["\xBC\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAD"],
        ["\xBC\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x8B"],
        ["\xBC\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x92"],
        ["\xBC\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x83"],
        ["\xBC\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x92"],
        ["\xBC\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9D"],
        ["\xBC\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x93"],
        ["\xBC\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA3"],
        ["\xBC\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA7"],
        ["\xBC\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xAD"],
        ["\xBC\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xB7"],
        ["\xBC\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xBE"],
        ["\xB3\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x84"],
        ["\xBC\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9E"],
        ["\xBC\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xA7"],
        ["\xBC\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x84"],
        ["\xB3\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xA2\xBD"],
        ["\xBC\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x99"],
        ["\xBC\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xA5"],
        ["\xB3\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9D"],
        ["\xB3\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xAE\x9F"],
        ["\xBC\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x81"],
        ["\xBC\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xBD"],
        ["\xBC\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x93"],
        ["\xB3\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x92"],
        ["\xBD\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA3"],
        ["\xBD\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xAB"],
        ["\xB3\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9E\x8D"],
        ["\xBD\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA2"],
        ["\xB3\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xBB"],
        ["\xB3\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xBC"],
        ["\xB3\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x9A\xB4"],
        ["\xBD\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xBA"],
        ["\xBD\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x8F"],
        ["\xBD\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x9F"],
        ["\xBD\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA3"],
        ["\xBD\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAA"],
        ["\xBD\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x8B"],
        ["\xB3\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x90"],
        ["\xBD\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x92"],
        ["\xBD\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB4"],
        ["\xB3\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB8\xB4"],
        ["\xB3\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F\xA2"],
        ["\xBD\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x8D"],
        ["\xBD\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x86"],
        ["\xB3\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x87"],
        ["\xBD\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8A"],
        ["\xBD\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x81"],
        ["\xBD\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xA0"],
        ["\xB4\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xA4"],
        ["\xBD\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xA7"],
        ["\xBD\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x8B"],
        ["\xB3\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9E"],
        ["\x59\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x81"],
        ["\xB3\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x93"],
        ["\xB4\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA2"],
        ["\xBD\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x94"],
        ["\xBD\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x98"],
        ["\xBD\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x98"],
        ["\xBD\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x9E"],
        ["\xBD\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xBE"],
        ["\xB4\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4\xA8"],
        ["\xBD\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x8B"],
        ["\xB4\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB9"],
        ["\xB4\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x80"],
        ["\xBD\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x82"],
        ["\xBD\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x87"],
        ["\xBD\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9D"],
        ["\xBD\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA3"],
        ["\xBD\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB6"],
        ["\xBE\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xBD"],
        ["\xBE\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x80"],
        ["\xBE\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x94"],
        ["\xBE\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x98"],
        ["\xBE\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA4"],
        ["\xBE\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBD"],
        ["\xBE\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x89"],
        ["\xBE\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x9C"],
        ["\xBE\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA7"],
        ["\xBE\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAF"],
        ["\xB4\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB5"],
        ["\xBE\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x89"],
        ["\xBE\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA1"],
        ["\xBE\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA9"],
        ["\xBE\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x8D"],
        ["\xBE\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x94"],
        ["\xBE\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x98"],
        ["\xBE\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xB3"],
        ["\xBE\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xB5"],
        ["\xBE\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x87"],
        ["\xB4\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xBD"],
        ["\xBE\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9D"],
        ["\xBE\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9E"],
        ["\xBE\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x8B"],
        ["\xBE\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x94"],
        ["\xBE\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9D"],
        ["\xBE\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB8"],
        ["\xBE\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9C"],
        ["\xBE\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xAB"],
        ["\xB4\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xBE"],
        ["\xBE\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x8D"],
        ["\xB4\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xBF"],
        ["\xBE\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xBC"],
        ["\xBE\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xB9"],
        ["\xB4\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x80"],
        ["\xBF\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA2"],
        ["\xB4\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xBE"],
        ["\xBF\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x83"],
        ["\xBF\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x96"],
        ["\xBF\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x9A"],
        ["\xBF\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xAF"],
        ["\xB4\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x85"],
        ["\xBF\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x84"],
        ["\xBF\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x96"],
        ["\xBF\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBC"],
        ["\xBF\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x8A"],
        ["\xBF\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x98"],
        ["\xBF\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xB9"],
        ["\xBF\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x83"],
        ["\xBF\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA5"],
        ["\xBF\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xBC"],
        ["\xBF\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA5"],
        ["\xB4\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xAD"],
        ["\xBF\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x90"],
        ["\xBF\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x94"],
        ["\xBF\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA2"],
        ["\xB4\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB9"],
        ["\xBF\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x91"],
        ["\xBF\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xAD"],
        ["\xBF\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBE"],
        ["\xBF\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBF"],
        ["\xBF\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x84"],
        ["\xBF\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8A"],
        ["\xC0\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x90"],
        ["\xC0\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB7"],
        ["\xC0\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBB"],
        ["\xC0\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA2"],
        ["\xC0\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA9"],
        ["\xB4\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x81"],
        ["\xC0\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA7"],
        ["\xC0\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9D"],
        ["\xB4\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x82"],
        ["\xB4\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBA"],
        ["\xC0\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA2"],
        ["\xC0\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAB"],
        ["\xC0\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB0"],
        ["\xC0\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB3"],
        ["\xB4\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x88"],
        ["\xC0\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8C"],
        ["\xB4\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x87\x84"],
        ["\xB4\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9A"],
        ["\xC0\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA1"],
        ["\xC0\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB7"],
        ["\xC0\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB8"],
        ["\xC0\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x8D"],
        ["\xB4\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x83"],
        ["\xC0\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBB"],
        ["\xB4\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x86"],
        ["\xC0\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x88"],
        ["\xB4\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC\xA2"],
        ["\xC0\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9B"],
        ["\xC0\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA8"],
        ["\xC0\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x93"],
        ["\xC0\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB3"],
        ["\xC0\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x87"],
        ["\xC0\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x88"],
        ["\xC0\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBB"],
        ["\xC0\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x81"],
        ["\xC0\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x93"],
        ["\xC0\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x98"],
        ["\xC0\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9B"],
        ["\xC1\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB9"],
        ["\xC1\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x97"],
        ["\xB4\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBC"],
        ["\xC1\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x9D"],
        ["\xC1\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xAC"],
        ["\xC1\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB1"],
        ["\xC1\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9B"],
        ["\xC1\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB2"],
        ["\xC1\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB5"],
        ["\xB4\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x84"],
        ["\xC1\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA3"],
        ["\xC1\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA5"],
        ["\xC1\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB2"],
        ["\xC1\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x90"],
        ["\xC1\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA8"],
        ["\xC1\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAD"],
        ["\xC1\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB0"],
        ["\xC1\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB1"],
        ["\xC1\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xBC"],
        ["\xC1\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8A"],
        ["\xC1\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x89"],
        ["\xB4\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x97\x84"],
        ["\xC1\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB5"],
        ["\xC1\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x82"],
        ["\xC1\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x97"],
        ["\xC1\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA3"],
        ["\xC1\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA4"],
        ["\xC1\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x80"],
        ["\xC1\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA5"],
        ["\xC1\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xAD"],
        ["\xB4\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8F"],
        ["\xB4\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE\xB6"],
        ["\xB4\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF\x83"],
        ["\xB4\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA9"],
        ["\xB4\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAA"],
        ["\xC1\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB5"],
        ["\xB4\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB6"],
        ["\xC1\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8F"],
        ["\xC1\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x95"],
        ["\xB4\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x9C\xBF"],
        ["\xC1\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBB"],
        ["\xC1\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBE"],
        ["\xC1\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x85"],
        ["\xC1\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x90"],
        ["\xC1\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x96"],
        ["\xC1\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x9B"],
        ["\xB4\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x9D\xA3"],
        ["\xC1\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x89"],
        ["\xB4\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x94"],
        ["\xC1\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x9D"],
        ["\xC1\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x9E"],
        ["\xC1\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA5"],
        ["\xC2\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xA7"],
        ["\xB4\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0\x8F"],
        ["\xB4\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4\x9D"],
        ["\xC2\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9B"],
        ["\xC2\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9E"],
        ["\xC2\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xAC"],
        ["\xC2\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB5"],
        ["\xC2\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x86"],
        ["\xC2\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x96"],
        ["\xC2\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA0"],
        ["\xB4\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA5"],
        ["\xC2\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA7"],
        ["\xB4\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB7"],
        ["\xC2\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x82"],
        ["\xC2\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xA9"],
        ["\xC2\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAD"],
        ["\xB4\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA5\xB0"],
        ["\xB4\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8F"],
        ["\xB4\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x97"],
        ["\xC2\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xBF"],
        ["\xC2\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x85"],
        ["\xC2\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x90"],
        ["\xC2\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB3"],
        ["\xC2\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x99"],
        ["\xB4\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xAA"],
        ["\xC2\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB4"],
        ["\xC2\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB6"],
        ["\xC2\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x85"],
        ["\xC2\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x98"],
        ["\xC2\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x9C"],
        ["\xB4\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xBB"],
        ["\xC2\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x86"],
        ["\xC2\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x94"],
        ["\xC2\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA0"],
        ["\xC2\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAB"],
        ["\xC2\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAE"],
        ["\xB5\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xB3\xBE"],
        ["\xC2\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8E"],
        ["\xC2\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAE"],
        ["\xC2\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB1"],
        ["\xC2\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB9"],
        ["\xC2\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBF"],
        ["\xB5\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x98"],
        ["\xC2\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA5"],
        ["\xB5\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x85"],
        ["\xC2\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x82"],
        ["\xB5\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x89"],
        ["\xC2\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x94"],
        ["\xC2\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xAA"],
        ["\xC2\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xBF"],
        ["\xC2\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x84"],
        ["\xC3\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x96"],
        ["\xB5\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x9A"],
        ["\xC3\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x9B"],
        ["\xC3\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x9D"],
        ["\xB5\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x86"],
        ["\xB5\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB4"],
        ["\xC3\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x84"],
        ["\xC3\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9E"],
        ["\xB5\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xAB"],
        ["\xC3\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB1"],
        ["\xC3\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x81"],
        ["\xC3\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x87"],
        ["\xC3\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x8E"],
        ["\xB5\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x90"],
        ["\xC3\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x9A"],
        ["\xB5\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x87"],
        ["\xC3\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAA"],
        ["\xC3\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAF"],
        ["\xC3\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB3"],
        ["\xC3\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x91"],
        ["\xC3\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x99"],
        ["\xC3\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9E"],
        ["\xC3\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA1"],
        ["\xC3\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA2"],
        ["\xC3\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBE"],
        ["\xC3\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x8C"],
        ["\xC3\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x8D"],
        ["\xC3\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x94"],
        ["\xC3\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA0"],
        ["\xC3\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA7"],
        ["\xC3\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB6"],
        ["\xC3\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xBC"],
        ["\xC3\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x87"],
        ["\xC3\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x8A"],
        ["\xC3\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB9"],
        ["\xC3\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB0"],
        ["\xC3\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x86"],
        ["\xC3\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x8A"],
        ["\xC3\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x9D"],
        ["\xC3\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x9E"],
        ["\xC3\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x8E"],
        ["\xC3\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xA4"],
        ["\xC3\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB5"],
        ["\xC3\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xA4"],
        ["\xC3\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB7"],
        ["\xC3\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x94"],
        ["\xC3\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x98"],
        ["\xC3\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xA4"],
        ["\xC4\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xAB"],
        ["\xC4\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x9E"],
        ["\xC4\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xA0"],
        ["\xB5\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xAE"],
        ["\xC4\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xB0"],
        ["\xB5\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x91"],
        ["\xB5\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x88"],
        ["\xC4\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x92"],
        ["\xC4\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA0"],
        ["\xC4\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA8"],
        ["\xC4\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x85"],
        ["\xC4\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x87"],
        ["\xC4\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x92"],
        ["\xC4\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xBA"],
        ["\xC4\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x84"],
        ["\xC4\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x80"],
        ["\xB5\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x95"],
        ["\xC4\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x95"],
        ["\xC4\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x96"],
        ["\xB5\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8\xBF"],
        ["\xC4\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x8D"],
        ["\xC4\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x9B"],
        ["\xB5\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x80"],
        ["\xC4\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBB"],
        ["\xB5\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\x9F\xB1"],
        ["\xC4\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA7"],
        ["\xC4\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA8"],
        ["\xC4\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x90"],
        ["\xC4\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xA6"],
        ["\xC4\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xBC"],
        ["\xC4\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x95"],
        ["\xC4\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x9F"],
        ["\xC4\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA0"],
        ["\xC4\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA2"],
        ["\xC4\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA6"],
        ["\xC4\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xAB"],
        ["\xC4\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8F"],
        ["\xC4\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x99"],
        ["\xC4\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA9"],
        ["\xC5\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x8A"],
        ["\xC5\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x9A"],
        ["\xC5\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x9B"],
        ["\xB5\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x8A"],
        ["\xC5\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA8"],
        ["\xC5\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xAB"],
        ["\xC5\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xAC"],
        ["\xC5\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xAF"],
        ["\xC5\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB0"],
        ["\xC5\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x84"],
        ["\xC5\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x86"],
        ["\xC5\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x87"],
        ["\xC5\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x8B"],
        ["\xC5\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x97"],
        ["\xC5\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xAB"],
        ["\xC5\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xAD"],
        ["\xC5\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x86"],
        ["\xC5\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x87"],
        ["\xC5\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x98"],
        ["\xC5\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x9C"],
        ["\xC5\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA3"],
        ["\xC5\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x90"],
        ["\xC5\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA6"],
        ["\xC5\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA8"],
        ["\xC5\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA9"],
        ["\xC5\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xB5"],
        ["\xC5\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xBF"],
        ["\xC5\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x88"],
        ["\xC5\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x89"],
        ["\xC5\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x9A"],
        ["\xC5\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xBF"],
        ["\xC5\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x97"],
        ["\xC5\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB9"],
        ["\xC5\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x92"],
        ["\xB5\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD\xB2"],
        ["\xC5\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x8E"],
        ["\xC5\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA4"],
        ["\xC5\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x80"],
        ["\xC5\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x82"],
        ["\xC5\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x88"],
        ["\xC5\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x95"],
        ["\xC5\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x96"],
        ["\xC5\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x99"],
        ["\xC5\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x9E"],
        ["\xC5\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xAD"],
        ["\xC5\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB5"],
        ["\xC5\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x83"],
        ["\xC6\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x8B"],
        ["\xC6\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA4"],
        ["\xC6\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA5"],
        ["\xC6\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAD"],
        ["\xC6\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAF"],
        ["\xC6\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB1"],
        ["\xC6\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x81"],
        ["\xC6\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9D"],
        ["\xC6\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xAA"],
        ["\xB5\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB6"],
        ["\xC6\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x85"],
        ["\xC6\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8C"],
        ["\xC6\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8E"],
        ["\xC6\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x94"],
        ["\xC6\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA6"],
        ["\xC6\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB1"],
        ["\xC6\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xBC"],
        ["\xC6\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x8A"],
        ["\xC6\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x99"],
        ["\xC6\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB4"],
        ["\xC6\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB6"],
        ["\xC6\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x8D"],
        ["\xC6\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x8E"],
        ["\xC6\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9C"],
        ["\xC6\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9F"],
        ["\xC6\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA2"],
        ["\xC6\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBA"],
        ["\xC6\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x80"],
        ["\xC6\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x94"],
        ["\xC6\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xAA"],
        ["\xC6\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA0"],
        ["\xC6\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xAD"],
        ["\xB5\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x92\x8E"],
        ["\xC6\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x83"],
        ["\xB5\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x8F"],
        ["\xB5\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x91"],
        ["\xC6\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xA8"],
        ["\xC6\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAE"],
        ["\xB5\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x8B"],
        ["\xC6\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xB0"],
        ["\xB5\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x94\x8E"],
        ["\xC6\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xAD"],
        ["\xC6\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA4"],
        ["\xC7\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xB2"],
        ["\xC7\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x80"],
        ["\xC7\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xB7"],
        ["\xC7\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x9C"],
        ["\xB5\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAE"],
        ["\xC7\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xB1"],
        ["\xC7\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xB4"],
        ["\xB5\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x8C"],
        ["\xB5\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x8D"],
        ["\xC7\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x85"],
        ["\xC7\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x86"],
        ["\xB5\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x8E"],
        ["\xB5\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x8F"],
        ["\xB5\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x90"],
        ["\xC7\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9C"],
        ["\xB5\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x91"],
        ["\xC7\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xB9"],
        ["\xB5\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x92"],
        ["\xB5\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x93"],
        ["\xC7\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x98"],
        ["\xC7\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB1"],
        ["\xC7\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB8"],
        ["\xC7\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x88"],
        ["\xC7\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x8A"],
        ["\xB5\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x9D\xB1"],
        ["\xC7\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x94"],
        ["\xC7\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x9E"],
        ["\xC7\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xAB"],
        ["\xC7\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xAD"],
        ["\xC7\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x83"],
        ["\xB5\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x94"],
        ["\xC7\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB9"],
        ["\xC7\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x9D"],
        ["\xC7\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xAD"],
        ["\xB5\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x95"],
        ["\xC7\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x85"],
        ["\xC7\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xA0"],
        ["\xB5\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xA7\x84"],
        ["\xC7\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xB3"],
        ["\xC7\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBB"],
        ["\xC7\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8E"],
        ["\xC7\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xBD"],
        ["\xB5\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x92"],
        ["\xC7\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xAD"],
        ["\xB5\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xBB"],
        ["\xC7\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x87"],
        ["\xC7\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8E"],
        ["\xC7\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA0"],
        ["\xC7\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAD"],
        ["\xC7\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAF"],
        ["\xC7\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB2"],
        ["\xB5\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x96"],
        ["\xC8\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x97"],
        ["\xC8\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x99"],
        ["\xC8\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x81"],
        ["\xC8\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB1"],
        ["\xB6\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x9E"],
        ["\xC8\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA0"],
        ["\xC8\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB3"],
        ["\xC8\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB6"],
        ["\xB6\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x89\xA4"],
        ["\xB6\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xB6\xA1"],
        ["\xC8\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x99"],
        ["\xC8\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xAD"],
        ["\xC8\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB9"],
        ["\xC8\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x8F"],
        ["\xC8\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x94"],
        ["\xC8\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA0"],
        ["\xC8\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xBC"],
        ["\xC8\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x95"],
        ["\xC8\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x99"],
        ["\xC8\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9D"],
        ["\xC8\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x87"],
        ["\xC8\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x88"],
        ["\xC8\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x93"],
        ["\xC8\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9D"],
        ["\xC8\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA3"],
        ["\xC8\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB1"],
        ["\xC8\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x81"],
        ["\xC8\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x93"],
        ["\xC8\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xBA"],
        ["\xC8\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x83"],
        ["\xC8\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x8B"],
        ["\xC8\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA6"],
        ["\xC8\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x82"],
        ["\xC8\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8C"],
        ["\xB6\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA3"],
        ["\xB6\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x97"],
        ["\xC9\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA8"],
        ["\xC9\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x88"],
        ["\xC9\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x91"],
        ["\xC9\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x95"],
        ["\xB6\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x99"],
        ["\xC9\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x87"],
        ["\xC9\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA1"],
        ["\xC9\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8D"],
        ["\xB6\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x9A"],
        ["\xC9\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x91"],
        ["\xC9\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x97"],
        ["\xC9\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xBF"],
        ["\xC9\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8E"],
        ["\xC9\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x9B"],
        ["\xC9\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x9F"],
        ["\xC9\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xAC"],
        ["\xC9\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xAE"],
        ["\xC9\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xBA"],
        ["\xB6\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x9B"],
        ["\xC9\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x94"],
        ["\xC9\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA6"],
        ["\xC9\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB5"],
        ["\xC9\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB7"],
        ["\xC9\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBC"],
        ["\xB6\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x8A"],
        ["\xC9\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x97"],
        ["\xC9\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA0"],
        ["\xC9\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB3"],
        ["\xC9\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x98"],
        ["\xC9\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x8A"],
        ["\xC9\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA0"],
        ["\xC9\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA7"],
        ["\xC9\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA8"],
        ["\xC9\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xAD"],
        ["\xCA\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBB"],
        ["\xCA\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x8A"],
        ["\xCA\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x8F"],
        ["\xCA\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x97"],
        ["\xB6\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x9C"],
        ["\xB6\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x91\x93"],
        ["\xB6\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x91\x9B"],
        ["\xCA\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA0"],
        ["\xCA\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB4"],
        ["\xB6\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xAB\xBF"],
        ["\xCA\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8E"],
        ["\xCA\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA1"],
        ["\xCA\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA3"],
        ["\xCA\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA4"],
        ["\xCA\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA9"],
        ["\xCA\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAE"],
        ["\xCA\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB7"],
        ["\xCA\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBE"],
        ["\xCA\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBF"],
        ["\xCA\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x86"],
        ["\xCA\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x95"],
        ["\xCA\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBD"],
        ["\xCA\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBE"],
        ["\xCA\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x80"],
        ["\xCA\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xA2"],
        ["\xCA\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xAD"],
        ["\xCA\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xBA"],
        ["\xCA\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x83"],
        ["\xCA\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x87"],
        ["\xCA\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x91"],
        ["\xCA\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x95"],
        ["\xCA\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBD"],
        ["\xCA\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x86"],
        ["\xCA\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x92"],
        ["\xCA\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x98"],
        ["\xCA\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA7"],
        ["\xCA\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA9"],
        ["\xCA\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xBF"],
        ["\xCA\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x80"],
        ["\xCA\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8F"],
        ["\xCA\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x91"],
        ["\xB6\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xA1"],
        ["\xCA\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xAA"],
        ["\xCA\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x81"],
        ["\xCA\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x86"],
        ["\xCA\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8A"],
        ["\xB6\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x9F"],
        ["\xB6\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x9F"],
        ["\xCB\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB0"],
        ["\xCB\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB3"],
        ["\xCB\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x85"],
        ["\xCB\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x9E"],
        ["\xCB\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xAF"],
        ["\xCB\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBA"],
        ["\xCB\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x80"],
        ["\xCB\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x82"],
        ["\xB6\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xB9\x80"],
        ["\xCB\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xB2"],
        ["\xCB\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x9E"],
        ["\xCB\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA3"],
        ["\xCB\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xAF"],
        ["\xCB\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA4"],
        ["\xCB\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAD"],
        ["\xCB\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xBA"],
        ["\xCB\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x8C"],
        ["\xCB\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x8F"],
        ["\xCB\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA2"],
        ["\xCB\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8B"],
        ["\xCB\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8E"],
        ["\xCB\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xAD"],
        ["\xCB\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x92"],
        ["\xCB\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBF"],
        ["\xCB\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x84"],
        ["\xCB\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x85"],
        ["\xCB\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x90"],
        ["\xB6\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x83\xB4"],
        ["\xCB\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x98"],
        ["\xCB\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xA9"],
        ["\xCB\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xB8"],
        ["\xCB\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x97"],
        ["\xB6\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9B"],
        ["\xB6\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4\xB6"],
        ["\xCB\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xA2"],
        ["\xB6\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x96\x9D"],
        ["\xCB\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xAC"],
        ["\xCB\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB5"],
        ["\xCB\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x98"],
        ["\xCC\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB8"],
        ["\xCC\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBA"],
        ["\xCC\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBC"],
        ["\xCC\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBD"],
        ["\xCC\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x8B"],
        ["\xCC\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB1"],
        ["\xCC\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x87"],
        ["\xCC\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x88"],
        ["\xCC\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xAC"],
        ["\xCC\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xAD"],
        ["\xCC\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xB5"],
        ["\xB6\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x97\xAA"],
        ["\xCC\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x96"],
        ["\xB6\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xAC"],
        ["\xCC\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x86"],
        ["\xCC\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8A"],
        ["\xCC\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x90"],
        ["\xCC\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x94"],
        ["\xCC\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x9F"],
        ["\xCC\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x98"],
        ["\xCC\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xAA"],
        ["\xCC\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x8A"],
        ["\xCC\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x8E"],
        ["\xB6\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x9A\x84"],
        ["\xB6\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA0"],
        ["\xCD\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x98"],
        ["\xCD\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x99"],
        ["\xCD\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9A"],
        ["\xCD\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xA7"],
        ["\xCD\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB0"],
        ["\xCD\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB2"],
        ["\xCD\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB9"],
        ["\xCD\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x80"],
        ["\xCD\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x94"],
        ["\xB6\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA1"],
        ["\xCD\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x94"],
        ["\xCD\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA5"],
        ["\xCD\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB6"],
        ["\xCD\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x95"],
        ["\xCD\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA2"],
        ["\xCD\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x87"],
        ["\xCD\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x8E"],
        ["\xCD\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x9D"],
        ["\xCD\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA1"],
        ["\xCD\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB5"],
        ["\xB6\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x90"],
        ["\xCD\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB4"],
        ["\xB6\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA2"],
        ["\xB6\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA3"],
        ["\xCD\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x86"],
        ["\xCD\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x94"],
        ["\xCD\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x99"],
        ["\xB6\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xA9"],
        ["\xB6\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x9D"],
        ["\xCE\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x89"],
        ["\xCE\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xA8"],
        ["\xB6\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA4"],
        ["\xCE\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA1"],
        ["\xCE\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xB8"],
        ["\xCE\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBE"],
        ["\xB6\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA5"],
        ["\xCE\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x9B"],
        ["\xCE\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xAF"],
        ["\xCE\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8E"],
        ["\xCE\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x91"],
        ["\xCE\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x97"],
        ["\xCE\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xA0"],
        ["\xCE\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xA3"],
        ["\xCE\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xBD"],
        ["\xCE\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB0"],
        ["\xCE\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xBB"],
        ["\xB7\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA8\x89\xB7"],
        ["\xCE\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x80"],
        ["\xB7\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1\x84"],
        ["\xCE\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBA"],
        ["\xCF\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9E"],
        ["\xCF\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xAD"],
        ["\xCF\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB6"],
        ["\xCF\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x94"],
        ["\xB7\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA8\x8F\x8D"],
        ["\xCF\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA6"],
        ["\xCF\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB5"],
        ["\xCF\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA4"],
        ["\xCF\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA8"],
        ["\xCF\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAE"],
        ["\xCF\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x88"],
        ["\xCF\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xAD"],
        ["\xB7\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA7"],
        ["\xCF\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x88"],
        ["\xCF\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x95"],
        ["\xCF\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x97"],
        ["\xCF\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x99"],
        ["\xCF\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x9B"],
        ["\xCF\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA2"],
        ["\xCF\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB3"],
        ["\xCF\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xBE"],
        ["\xCF\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x84"],
        ["\xCF\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x85"],
        ["\xCF\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x87"],
        ["\xCF\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x97"],
        ["\xCF\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x9D"],
        ["\xCF\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xAF"],
        ["\xCF\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xB4"],
        ["\xCF\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x94"],
        ["\xCF\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x96"],
        ["\xCF\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xA2"],
        ["\xCF\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xA3"],
        ["\xCF\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xAF"],
        ["\xCF\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB1"],
        ["\xCF\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB4"],
        ["\xCF\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xBD"],
        ["\xCF\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x88"],
        ["\xCF\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x9B"],
        ["\xCF\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x83"],
        ["\xD0\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x9E"],
        ["\xD0\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAC"],
        ["\xD0\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB1"],
        ["\xD0\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xBC"],
        ["\xD0\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xBB"],
        ["\xD0\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xB1"],
        ["\xD0\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x87"],
        ["\xD0\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB8"],
        ["\xD0\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x83"],
        ["\xD0\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x8F"],
        ["\xD0\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x82"],
        ["\xD0\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x8B"],
        ["\xD0\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x8C"],
        ["\xB7\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x84"],
        ["\xD0\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9F"],
        ["\xD0\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x89"],
        ["\xB7\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x8A"],
        ["\xD0\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xA4"],
        ["\xD0\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xA5"],
        ["\xD0\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xAA"],
        ["\xD0\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x9B"],
        ["\xD0\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xA3"],
        ["\xD1\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xBA"],
        ["\xD1\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x9F"],
        ["\xD1\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x84"],
        ["\xD1\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xBD"],
        ["\xD1\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB3"],
        ["\xD1\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x8A"],
        ["\xD1\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xA3"],
        ["\xD1\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xAB"],
        ["\xD1\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB1"],
        ["\xD1\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB2"],
        ["\xD1\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8E"],
        ["\xD1\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x9F"],
        ["\xD1\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA6"],
        ["\xD1\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA9"],
        ["\xD1\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xAC"],
        ["\xD1\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xB6"],
        ["\xD1\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xBD"],
        ["\xD1\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x8B"],
        ["\xD1\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x90"],
        ["\xD1\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x93"],
        ["\xB7\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6\xB0"],
        ["\xD1\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x9A"],
        ["\xD1\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x9E"],
        ["\xD1\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x98"],
        ["\xD1\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x84"],
        ["\xD1\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA4"],
        ["\xD1\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA5"],
        ["\xD1\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x92"],
        ["\xD1\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x9E"],
        ["\xB7\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA8"],
        ["\xD1\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA9"],
        ["\xD1\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xAF"],
        ["\xD1\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x8E"],
        ["\xD1\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x9A"],
        ["\xD1\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xAE"],
        ["\xD1\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB3"],
        ["\xD1\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x95"],
        ["\xD2\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xAE"],
        ["\xD2\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xBA"],
        ["\xD2\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x81"],
        ["\xD2\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x89"],
        ["\xD2\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x9E"],
        ["\xD2\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x9B"],
        ["\xD2\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB4"],
        ["\xB7\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA9"],
        ["\xD2\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x8A"],
        ["\xD2\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x9E"],
        ["\xD2\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xAB"],
        ["\xD2\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB0"],
        ["\xB7\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xAA"],
        ["\xD2\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x92"],
        ["\xD2\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x93"],
        ["\xD2\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x96"],
        ["\xD2\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x99"],
        ["\xD2\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x9A"],
        ["\xB7\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7\x90"],
        ["\xD2\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xAC"],
        ["\xD2\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xBA"],
        ["\xD2\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x88"],
        ["\xD2\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xA7"],
        ["\xD2\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x98"],
        ["\xD2\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x82"],
        ["\xD2\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x83"],
        ["\xD2\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xA4"],
        ["\xD2\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xAD"],
        ["\xD2\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xAE"],
        ["\xD3\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB8"],
        ["\xD3\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x8A"],
        ["\xB7\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x92"],
        ["\xD3\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xB6"],
        ["\xD3\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x81"],
        ["\xD3\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x83"],
        ["\xD3\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x8E"],
        ["\xD3\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x96"],
        ["\xD3\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xB9"],
        ["\xD3\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x82"],
        ["\xD3\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x88"],
        ["\xD3\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA0"],
        ["\xB7\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0\x97"],
        ["\xD3\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAD"],
        ["\xD3\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x9E"],
        ["\xD3\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB9"],
        ["\xD3\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xA6"],
        ["\xD3\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x84"],
        ["\xD3\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x8A"],
        ["\xD3\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x9E"],
        ["\xD3\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xA7"],
        ["\xD3\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x81"],
        ["\xD3\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x8E"],
        ["\xD3\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA5"],
        ["\xD3\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB8"],
        ["\xD3\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xBD"],
        ["\xD3\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA3"],
        ["\xD3\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x81"],
        ["\xD3\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x8F"],
        ["\xD3\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x90"],
        ["\xD3\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x93"],
        ["\xD3\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA3"],
        ["\xB7\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA5"],
        ["\xD4\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB7"],
        ["\xD4\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9D"],
        ["\xD4\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9E"],
        ["\xD4\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x83"],
        ["\xD4\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x87"],
        ["\xB7\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x92"],
        ["\xD4\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA3"],
        ["\xD4\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xBC"],
        ["\xD4\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x8A"],
        ["\xD4\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x96"],
        ["\xB7\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x80"],
        ["\xD4\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xAC"],
        ["\xD4\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xBC"],
        ["\xD4\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x97"],
        ["\xB7\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x86\x90"],
        ["\xD4\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xA7"],
        ["\xD4\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x87"],
        ["\xD4\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x95"],
        ["\xD4\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xBC"],
        ["\xD4\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x9E"],
        ["\xD4\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA4"],
        ["\xD4\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xAC"],
        ["\xD4\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xAF"],
        ["\xD4\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB4"],
        ["\xD4\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB5"],
        ["\xB7\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x83"],
        ["\xD4\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x90"],
        ["\xD4\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xB9"],
        ["\xD4\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x97"],
        ["\xD5\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x90"],
        ["\xD5\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x94"],
        ["\xD5\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x97"],
        ["\xD5\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\xA2"],
        ["\xB3\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xB8"],
        ["\xB3\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x9B"],
        ["\xB4\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB7"],
        ["\xC5\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA6"],
        ["\xC9\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xAB"],
        ["\xB3\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x82\x89"],
        ["\xB8\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x82"],
        ["\xB3\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8F"],
        ["\xB8\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x92"],
        ["\xB3\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA9"],
        ["\xB8\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAB"],
        ["\xB8\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAE"],
        ["\xB8\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x80"],
        ["\xB8\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x87"],
        ["\xB3\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x88"],
        ["\xB3\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x82\xA2"],
        ["\xB8\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x91"],
        ["\xB3\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x90\x86"],
        ["\xB3\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x82\xA4"],
        ["\xB8\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9A"],
        ["\xB8\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xA9"],
        ["\xB8\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9D"],
        ["\xB3\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x90\xAC"],
        ["\xB3\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x90\xAE"],
        ["\xB8\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB9"],
        ["\xB3\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xBB"],
        ["\xB3\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x86\xA2"],
        ["\xB3\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xBC"],
        ["\xB8\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x83"],
        ["\xB3\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x88"],
        ["\xB8\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x90"],
        ["\xB3\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xAB"],
        ["\xB8\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9A"],
        ["\xB8\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB1"],
        ["\xB8\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB5"],
        ["\xB8\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x96"],
        ["\xB3\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xA4"],
        ["\xB8\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB7"],
        ["\xB8\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBE"],
        ["\xB8\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x94"],
        ["\xB8\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x98"],
        ["\xB3\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x88\x93"],
        ["\xB8\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB7"],
        ["\xB8\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB8"],
        ["\xB8\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBA"],
        ["\xB8\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBD"],
        ["\xB8\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x82"],
        ["\xB8\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x85"],
        ["\xB3\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA6"],
        ["\xB8\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xB2"],
        ["\xB8\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xBE"],
        ["\xB8\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x85"],
        ["\xB8\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8B"],
        ["\xB8\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8F"],
        ["\xB8\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x92"],
        ["\xB3\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x91\xAA"],
        ["\xB8\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB2"],
        ["\xB8\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x80"],
        ["\xB8\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x90"],
        ["\xB8\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x93"],
        ["\xB8\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9C"],
        ["\xB3\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x91\xA8"],
        ["\xB8\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x8E"],
        ["\xB8\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x93"],
        ["\xB8\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x97"],
        ["\xB8\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xA3"],
        ["\xB8\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xA6"],
        ["\xB8\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xAA"],
        ["\xB3\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xA3"],
        ["\xB3\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x88"],
        ["\xB8\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x92"],
        ["\xB8\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x93"],
        ["\xB3\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x95"],
        ["\xB8\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x96"],
        ["\xB8\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x9C"],
        ["\xB8\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xAA"],
        ["\xB3\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x8C\xAB"],
        ["\xB3\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB1"],
        ["\xB8\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xBA"],
        ["\xB3\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xBB"],
        ["\xB8\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x84"],
        ["\xB8\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x87"],
        ["\xB3\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB3"],
        ["\xB3\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x8E\x81"],
        ["\xB9\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8E"],
        ["\xB3\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x8D\xB1"],
        ["\xB9\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x94"],
        ["\xB3\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x99"],
        ["\xB3\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA1"],
        ["\xB9\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA9"],
        ["\xB3\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x92\x92"],
        ["\xBC\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x96"],
        ["\xBC\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xAC"],
        ["\xB3\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D\xA1"],
        ["\xB3\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D\xA2"],
        ["\xB3\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x8E"],
        ["\xBC\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x96"],
        ["\xB3\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D\xAC"],
        ["\xB3\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D\xAB"],
        ["\xBD\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB1"],
        ["\xBD\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBD"],
        ["\xB3\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D\xB5"],
        ["\xB3\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x83"],
        ["\xBD\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA9"],
        ["\xBD\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB0"],
        ["\xB3\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB1\x96"],
        ["\xB3\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x9F"],
        ["\xBD\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA3"],
        ["\xBD\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA7"],
        ["\xBD\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA8"],
        ["\xBD\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA9"],
        ["\xBD\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB0"],
        ["\xB3\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB4\xAD"],
        ["\xB3\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB5\x85"],
        ["\xBD\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xBC"],
        ["\xB3\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB5\xB8"],
        ["\xB3\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB5\xA2"],
        ["\xBD\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x88"],
        ["\xBD\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x8A"],
        ["\xB3\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F\x81"],
        ["\xB3\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB6\xA1"],
        ["\xB3\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB6\x9C"],
        ["\xBD\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA0"],
        ["\xBD\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA2"],
        ["\xB3\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA7"],
        ["\xB3\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB6\x92"],
        ["\xB3\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAD"],
        ["\xBD\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB5"],
        ["\xB3\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB6\xB7"],
        ["\xBD\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x89"],
        ["\xB3\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB7\xA0"],
        ["\xB3\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB8\xB3"],
        ["\xBD\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x86"],
        ["\xB3\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x90"],
        ["\xBD\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xAB"],
        ["\xB3\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9D"],
        ["\xB3\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA0"],
        ["\xBD\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA4"],
        ["\xBD\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA6"],
        ["\xBD\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xB1"],
        ["\xBD\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xB9"],
        ["\xB3\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F\xA8"],
        ["\xBD\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xA1"],
        ["\xBD\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAA"],
        ["\xB3\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F\xB4"],
        ["\xBD\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xB0"],
        ["\xB4\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xBC\x9E"],
        ["\xB4\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F\xBD"],
        ["\xBD\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x88"],
        ["\xB4\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA0\x80"],
        ["\xBD\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x92"],
        ["\xBD\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x94"],
        ["\xB4\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x97"],
        ["\xBD\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x99"],
        ["\xBD\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB0"],
        ["\xBD\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB2"],
        ["\xBD\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB4"],
        ["\xB4\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xBD\xB6"],
        ["\xB4\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x91"],
        ["\xB4\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x97"],
        ["\xBD\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x98"],
        ["\xBD\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA0"],
        ["\xB4\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xBF\xBA"],
        ["\xBD\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA4"],
        ["\xBD\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA9"],
        ["\xB4\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA0\xAF"],
        ["\xBD\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x80"],
        ["\xB4\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA0\xB6"],
        ["\xBD\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x92"],
        ["\xBD\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x95"],
        ["\xB4\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1\x80"],
        ["\xBD\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9F"],
        ["\xBD\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAE"],
        ["\xBD\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xBE"],
        ["\xBD\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x89"],
        ["\xB4\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1\x9C"],
        ["\xBD\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x96"],
        ["\xB4\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1\xA1"],
        ["\xBD\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xAB"],
        ["\xBD\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xAC"],
        ["\xBD\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xAD"],
        ["\xB9\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x88"],
        ["\xB3\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x8F\xB9"],
        ["\xB9\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x97"],
        ["\xB9\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9B"],
        ["\xB3\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x91\x8A"],
        ["\xB3\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA0"],
        ["\xB3\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x94\x89"],
        ["\xB3\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB3"],
        ["\xB9\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x83"],
        ["\xB9\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8B"],
        ["\xB3\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x92\xBC"],
        ["\xB9\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x98"],
        ["\xB9\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA3"],
        ["\xB9\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAD"],
        ["\xB3\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x93\x87"],
        ["\xB9\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xBC"],
        ["\xB3\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x97\x96"],
        ["\xB3\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x98\xA8"],
        ["\xB9\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB3"],
        ["\xB9\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB4"],
        ["\xB9\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x82"],
        ["\xB9\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x92"],
        ["\xB9\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x96"],
        ["\xB3\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x9D\x8F"],
        ["\xB9\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x95"],
        ["\xB9\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9C"],
        ["\xB3\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xAC"],
        ["\xB9\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB7"],
        ["\xB3\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x84"],
        ["\xB9\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x82"],
        ["\xB3\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xA0\x87"],
        ["\xB9\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x98"],
        ["\xB3\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xA0\xBA"],
        ["\xB9\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA4"],
        ["\xB9\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xBA"],
        ["\xB9\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xBB"],
        ["\xB3\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x8A"],
        ["\xB3\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x94\x9F"],
        ["\xB9\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x91"],
        ["\xB3\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xA2\xB9"],
        ["\xB9\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB7"],
        ["\xB9\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8A"],
        ["\xB9\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8B"],
        ["\xB9\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB5"],
        ["\xB9\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBE"],
        ["\xB9\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x82"],
        ["\xB3\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xA5\xBC"],
        ["\xB3\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xA6\x9D"],
        ["\xB3\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA7"],
        ["\xB9\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xAC"],
        ["\xB3\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBA"],
        ["\xBA\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA4"],
        ["\xBA\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB4"],
        ["\xB3\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xAB\x93"],
        ["\xBA\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB7"],
        ["\xBA\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x80"],
        ["\xB3\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xAC\x9D"],
        ["\xB3\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x95\x9D"],
        ["\xB3\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x95\x9E"],
        ["\xBA\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x95"],
        ["\xBA\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9A"],
        ["\xB3\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x95\xA3"],
        ["\xB3\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB4"],
        ["\xBA\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB5"],
        ["\xB3\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x95"],
        ["\xB3\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA4"],
        ["\xBA\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA8"],
        ["\xB3\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x95\xAE"],
        ["\xBA\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x83"],
        ["\xBA\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xA2"],
        ["\xBA\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xA6"],
        ["\xB3\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xAC"],
        ["\xBA\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8D"],
        ["\xBA\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x95"],
        ["\xB3\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA0"],
        ["\xBA\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA6"],
        ["\xBA\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAD"],
        ["\xBA\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAE"],
        ["\xBA\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB7"],
        ["\xBA\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBA"],
        ["\xBA\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBF"],
        ["\xB3\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x83"],
        ["\xB3\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xB5\x85"],
        ["\xBA\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xAC"],
        ["\xBA\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xAF"],
        ["\xB3\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xB1"],
        ["\xB3\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xB3"],
        ["\xBA\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x80"],
        ["\xBA\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x81"],
        ["\xBA\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x89"],
        ["\xBA\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xBC"],
        ["\xBA\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x81"],
        ["\xB3\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x96\xA6"],
        ["\xBA\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x87"],
        ["\xBA\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x8A"],
        ["\xB3\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x96\xA8"],
        ["\xBA\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xA0"],
        ["\xBA\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xA1"],
        ["\xBA\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xA4"],
        ["\xB3\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xB7\xA1"],
        ["\xB3\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBD"],
        ["\xBA\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x82"],
        ["\xBA\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x88"],
        ["\xBA\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x91"],
        ["\xB3\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x97\x85"],
        ["\xBA\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x92"],
        ["\xB3\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xBA\x95"],
        ["\xB3\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xB9\xAD"],
        ["\xBA\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xBF"],
        ["\xBA\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x89"],
        ["\xBA\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x8C"],
        ["\xBA\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x91"],
        ["\xB3\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9D"],
        ["\xB3\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x97\x9A"],
        ["\xBA\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA2"],
        ["\xB3\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xB9\xA4"],
        ["\xBA\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA9"],
        ["\xB3\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xA8"],
        ["\xB3\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xBD\x9F"],
        ["\xB3\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x87"],
        ["\xBA\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x90"],
        ["\xBA\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB0"],
        ["\xBA\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB7"],
        ["\xB3\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x97\xB4"],
        ["\xBA\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xBD"],
        ["\xBA\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xBF"],
        ["\xBA\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x80"],
        ["\xB3\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x87"],
        ["\xBA\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x9E"],
        ["\xBA\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA0"],
        ["\xBB\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAD"],
        ["\xB3\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x98\x85"],
        ["\xBB\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x88"],
        ["\xBB\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x8C"],
        ["\xBB\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x95"],
        ["\xBB\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x9A"],
        ["\xBB\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x9D"],
        ["\xBB\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA8"],
        ["\xBB\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xAD"],
        ["\xB3\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xB2"],
        ["\xBB\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x85"],
        ["\xBB\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x8D"],
        ["\xBB\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9F"],
        ["\xBB\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xA8"],
        ["\xBB\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB6"],
        ["\xBB\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB7"],
        ["\xB3\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x88\x81"],
        ["\xBB\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x95"],
        ["\xBB\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA3"],
        ["\xB3\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x89\x95"],
        ["\xBB\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA9"],
        ["\xB3\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x89\xBB"],
        ["\xBB\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x85"],
        ["\xBB\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x86"],
        ["\xBB\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8C"],
        ["\xBB\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8D"],
        ["\xB3\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x89\xB4"],
        ["\xBB\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA8"],
        ["\xBB\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xAF"],
        ["\xBB\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xB3"],
        ["\xBB\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xB4"],
        ["\xBB\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xB5"],
        ["\xBB\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xBB"],
        ["\xB3\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x8B\xA4"],
        ["\xB3\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x8B\x97"],
        ["\xBB\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x9A"],
        ["\xBB\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x9D"],
        ["\xBB\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x9E"],
        ["\xBB\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA8"],
        ["\xB3\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x97"],
        ["\xB3\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x8B\xBD"],
        ["\xBB\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8C"],
        ["\xB3\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x8C\xB6"],
        ["\xB3\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x8D\x84"],
        ["\xBB\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x9E"],
        ["\xBB\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA6"],
        ["\xBB\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB0"],
        ["\xB3\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x99\x8A"],
        ["\xBB\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB8"],
        ["\xB3\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBB"],
        ["\xBB\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBD"],
        ["\xBB\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x84"],
        ["\xBB\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x9E"],
        ["\xBB\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA0"],
        ["\xBB\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA7"],
        ["\xBB\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB2"],
        ["\xBB\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB9"],
        ["\xB3\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x8F\x84"],
        ["\xBB\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x89"],
        ["\xBB\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x8C"],
        ["\xBB\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA7"],
        ["\xBB\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x8A"],
        ["\xB3\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x8B"],
        ["\xBB\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x8D"],
        ["\xBB\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x8F"],
        ["\xBB\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x90"],
        ["\xBB\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x94"],
        ["\xBB\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9D"],
        ["\xB3\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xAA"],
        ["\xBB\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB1"],
        ["\xB3\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x91\xAD"],
        ["\xB3\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x83"],
        ["\xBB\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8D"],
        ["\xBC\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA2"],
        ["\xBC\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB3"],
        ["\xB3\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB4"],
        ["\xBC\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x85"],
        ["\xBC\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x86"],
        ["\xB3\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8D"],
        ["\xBC\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x94"],
        ["\xBC\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA4"],
        ["\xB3\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x97\x97"],
        ["\xB3\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9A\x91"],
        ["\xB3\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xBD"],
        ["\xB3\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9A\x99"],
        ["\xBC\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x86"],
        ["\xB3\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9A\x96"],
        ["\xB6\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xB0\xA9"],
        ["\xBC\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x9F"],
        ["\xB3\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x99\x87"],
        ["\xBC\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB5"],
        ["\xBC\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB6"],
        ["\xBC\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xBC"],
        ["\xBC\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x9F"],
        ["\xBC\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xAE"],
        ["\xBC\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBC"],
        ["\xBC\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x88"],
        ["\xBC\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x8D"],
        ["\xBC\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9E"],
        ["\xBC\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA3"],
        ["\xBC\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA4"],
        ["\xBC\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA7"],
        ["\xBC\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xAE"],
        ["\xB3\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x9C\x86"],
        ["\xB3\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x9D\x82"],
        ["\xB3\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9B\x8F"],
        ["\xBC\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x8C"],
        ["\xBC\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x8D"],
        ["\xB3\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x97"],
        ["\xBC\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA7"],
        ["\xBC\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xAD"],
        ["\xBC\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x95"],
        ["\xBC\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA5"],
        ["\xBC\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xBA"],
        ["\xBC\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x8B"],
        ["\xBC\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9C"],
        ["\xBC\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9F"],
        ["\xBC\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xA0"],
        ["\xBC\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xA2"],
        ["\xBC\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xB1"],
        ["\xBC\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xB3"],
        ["\xBC\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xB5"],
        ["\xBC\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBA"],
        ["\xBC\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBF"],
        ["\xBC\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x9A"],
        ["\xBC\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x9C"],
        ["\xBC\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA0"],
        ["\xBC\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA5"],
        ["\xB3\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xB0"],
        ["\xBC\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xAE"],
        ["\xBC\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xB5"],
        ["\xBC\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x80"],
        ["\xBC\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x88"],
        ["\xBC\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x97"],
        ["\xBC\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB4"],
        ["\xBC\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xAD"],
        ["\xBC\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x8C"],
        ["\xBC\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x92"],
        ["\xBC\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA8"],
        ["\xBC\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xAF"],
        ["\xBC\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xBC"],
        ["\xBC\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xBF"],
        ["\xBC\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x81"],
        ["\xBC\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x84"],
        ["\xB3\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xA7\x83"],
        ["\xBD\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xAE"],
        ["\xB4\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\x85\xBB"],
        ["\xBD\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA5"],
        ["\xBD\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAA"],
        ["\xBD\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAC"],
        ["\xB4\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB9"],
        ["\xBD\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xBF"],
        ["\xBD\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x86"],
        ["\xBD\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x92"],
        ["\xB4\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x99"],
        ["\xB4\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\x8C\x9E"],
        ["\xB4\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBD"],
        ["\xBD\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x88"],
        ["\xBD\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8E"],
        ["\xBD\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9C"],
        ["\xB4\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\x8E\xAD"],
        ["\xB4\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9E"],
        ["\xBE\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x87"],
        ["\xBE\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA3"],
        ["\xBE\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB2"],
        ["\xBE\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBE"],
        ["\xBE\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8F"],
        ["\xBE\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA2"],
        ["\xBE\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA4"],
        ["\xBE\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB8"],
        ["\xBE\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x84"],
        ["\xB4\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3\xBA"],
        ["\xBE\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x87"],
        ["\xBE\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x8B"],
        ["\xBE\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x92"],
        ["\xBE\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x93"],
        ["\xBE\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x94"],
        ["\xBE\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA2"],
        ["\xBE\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xAE"],
        ["\xBE\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xAF"],
        ["\xBE\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB3"],
        ["\xBE\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBC"],
        ["\xB4\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4\x97"],
        ["\xBE\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x97"],
        ["\xB4\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA2"],
        ["\xBE\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA4"],
        ["\xB4\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4\x9A"],
        ["\xBE\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8C"],
        ["\xBE\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xBF"],
        ["\xBE\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x95"],
        ["\xBE\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA8"],
        ["\xB4\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\x9B\xB3"],
        ["\xBE\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB0"],
        ["\xBE\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB1"],
        ["\xBE\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xBE"],
        ["\xBE\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x88"],
        ["\xBE\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x99"],
        ["\xBE\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9B"],
        ["\xB4\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xAE"],
        ["\xBE\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB5"],
        ["\xBE\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x90"],
        ["\xBE\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x92"],
        ["\xBE\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x93"],
        ["\xBE\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x99"],
        ["\xBE\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9E"],
        ["\xB4\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBA"],
        ["\xB4\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5\xAF"],
        ["\xBE\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x81"],
        ["\xBE\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x86"],
        ["\xBE\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA0"],
        ["\xBE\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xBC"],
        ["\xB4\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xA1\x9B"],
        ["\xBE\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x92"],
        ["\xBE\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x93"],
        ["\xBE\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x97"],
        ["\xBE\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA5"],
        ["\xBE\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA8"],
        ["\xBE\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAD"],
        ["\xB4\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xA2\xAB"],
        ["\xBE\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x95"],
        ["\xBE\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x9D"],
        ["\xBE\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x9F"],
        ["\xB4\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB5"],
        ["\xB4\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xA6\x8F"],
        ["\xBF\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x95"],
        ["\xBF\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA3"],
        ["\xBF\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA9"],
        ["\xBF\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x86"],
        ["\xBF\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8C"],
        ["\xBF\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x91"],
        ["\xBF\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x92"],
        ["\xB4\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA1"],
        ["\xBF\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA4"],
        ["\xB4\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBB"],
        ["\xBF\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xAD"],
        ["\xBF\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB3"],
        ["\xB4\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x99"],
        ["\xBF\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x95"],
        ["\xB4\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xAA\xB8"],
        ["\xBF\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBD"],
        ["\xBF\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x83"],
        ["\xBF\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x8D"],
        ["\xBF\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x90"],
        ["\xB4\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xAD\x8F"],
        ["\xB4\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xAD\x90"],
        ["\xB4\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xB2"],
        ["\xBF\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xB5"],
        ["\xB4\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBB"],
        ["\xBF\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBC"],
        ["\xBF\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x81"],
        ["\xBF\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x84"],
        ["\xBF\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8E"],
        ["\xB4\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xAD\x86"],
        ["\xB4\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x99"],
        ["\xB4\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xB0\x9D"],
        ["\xB4\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xAE\xA6"],
        ["\xBF\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xAC"],
        ["\xBF\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x84"],
        ["\xBF\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x99"],
        ["\xB4\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xB0\xA4"],
        ["\xBF\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x94"],
        ["\xBF\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xBD"],
        ["\xB4\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB7"],
        ["\xBF\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x94"],
        ["\xBF\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x95"],
        ["\xBF\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x9C"],
        ["\xBF\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA0"],
        ["\xB4\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xAB"],
        ["\xBF\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xAC"],
        ["\xBF\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB2"],
        ["\xBF\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x89"],
        ["\xBF\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x9E"],
        ["\xBF\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA5"],
        ["\xBF\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA9"],
        ["\xBF\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xAF"],
        ["\xBF\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x9A"],
        ["\xBF\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x9B"],
        ["\xBF\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x9D"],
        ["\xBF\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB3"],
        ["\xBF\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xBD"],
        ["\xBF\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x87"],
        ["\xBF\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x91"],
        ["\xBF\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9F"],
        ["\xBF\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8B"],
        ["\xBF\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8C"],
        ["\xC0\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x95"],
        ["\xC0\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x97"],
        ["\xB4\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xB7\xA1"],
        ["\xC0\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA4"],
        ["\xC0\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA5"],
        ["\xC0\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBF"],
        ["\xC0\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x84"],
        ["\xB4\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9\xAE"],
        ["\xC0\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x8F"],
        ["\xC0\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x94"],
        ["\xC0\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x96"],
        ["\xB4\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9\xB3"],
        ["\xC0\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x9E"],
        ["\xB4\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB2"],
        ["\xB4\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x84"],
        ["\xC0\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x94"],
        ["\xC0\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xAB"],
        ["\xC0\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xBA"],
        ["\xC0\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x81"],
        ["\xB4\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x84"],
        ["\xC0\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x85"],
        ["\xC0\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x8A"],
        ["\xC0\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB2"],
        ["\xB4\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB5"],
        ["\xB4\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB8"],
        ["\xC0\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xBF"],
        ["\xC0\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x82"],
        ["\xC0\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x89"],
        ["\xC0\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x94"],
        ["\xB4\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB\x96"],
        ["\xC0\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xB2"],
        ["\xC0\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xB9"],
        ["\xB4\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xBC"],
        ["\xC0\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x84"],
        ["\xC0\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x88"],
        ["\xC0\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA1"],
        ["\xC0\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAA"],
        ["\xC0\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x85"],
        ["\xC0\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x91"],
        ["\xC0\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8E"],
        ["\xB4\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB\xAA"],
        ["\xB4\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x87\x83"],
        ["\xC0\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9B"],
        ["\xB4\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA3"],
        ["\xB4\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x87\xB5"],
        ["\xB4\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x86\xB6"],
        ["\xC0\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAA"],
        ["\xC0\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAB"],
        ["\xC0\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAC"],
        ["\xB4\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAD"],
        ["\xC0\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xBB"],
        ["\xC0\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x80"],
        ["\xC0\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x90"],
        ["\xC0\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x92"],
        ["\xB4\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC\x8E"],
        ["\xC0\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xAD"],
        ["\xC0\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB1"],
        ["\xC0\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB5"],
        ["\xB4\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC\x9A"],
        ["\xB4\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC\x9C"],
        ["\xC0\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xAC"],
        ["\xB4\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB\x97"],
        ["\xB4\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x81"],
        ["\xC0\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x85"],
        ["\xB4\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x92"],
        ["\xB4\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x8D\xB2"],
        ["\xC0\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x99"],
        ["\xB4\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x8F\x93"],
        ["\xB4\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x8F\x92"],
        ["\xC0\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8C"],
        ["\xB4\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8D"],
        ["\xC0\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x94"],
        ["\xC0\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9D"],
        ["\xB4\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x8F\x90"],
        ["\xB4\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x8F\xA4"],
        ["\xB4\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x8F\x95"],
        ["\xC0\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB4"],
        ["\xC0\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB6"],
        ["\xB4\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x8F\x9A"],
        ["\xB4\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x92"],
        ["\xB4\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x8F\x9F"],
        ["\xB6\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xA3"],
        ["\xB4\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x90"],
        ["\xC0\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB0"],
        ["\xC0\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB2"],
        ["\xC0\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x83"],
        ["\xC0\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x88"],
        ["\xC1\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x92"],
        ["\xC1\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x99"],
        ["\xB4\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9B"],
        ["\xC1\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB0"],
        ["\xC1\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB7"],
        ["\xB4\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x91\x8A"],
        ["\xB4\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x91\x91"],
        ["\xB4\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x91\x8B"],
        ["\xB4\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x98"],
        ["\xC1\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x9F"],
        ["\xC1\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xAD"],
        ["\xB4\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x91\xA5"],
        ["\xC1\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB3"],
        ["\xC1\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBB"],
        ["\xB4\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBE"],
        ["\xC1\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x85"],
        ["\xB4\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x89"],
        ["\xC1\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x8C"],
        ["\xC1\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x95"],
        ["\xC1\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x97"],
        ["\xB4\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD\xB7"],
        ["\xC1\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xAB"],
        ["\xC1\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xAE"],
        ["\xC1\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBA"],
        ["\xC1\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBC"],
        ["\xC1\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x82"],
        ["\xB4\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x90"],
        ["\xC1\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x96"],
        ["\xB4\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD\xAD"],
        ["\xC1\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x98"],
        ["\xB4\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x99"],
        ["\xC1\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9A"],
        ["\xC1\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9C"],
        ["\xC1\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAA"],
        ["\xB4\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAB"],
        ["\xB4\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB4"],
        ["\xC1\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xBB"],
        ["\xC1\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xBB"],
        ["\xB4\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x93\xA4"],
        ["\xB4\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x95\x9A"],
        ["\xB4\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x83"],
        ["\xC1\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x85"],
        ["\xC1\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8C"],
        ["\xC1\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x96"],
        ["\xC1\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x99"],
        ["\xB4\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA4"],
        ["\xC1\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA5"],
        ["\xC1\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAC"],
        ["\xB4\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB7"],
        ["\xB4\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x83"],
        ["\xB4\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x87"],
        ["\xB4\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE\x87"],
        ["\xB4\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE\x88"],
        ["\xB4\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x96\x94"],
        ["\xC1\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xBB"],
        ["\xB4\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE\x8D"],
        ["\xB4\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x86"],
        ["\xC1\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA9"],
        ["\xC1\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAC"],
        ["\xC1\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB2"],
        ["\xC1\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBA"],
        ["\xC1\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBF"],
        ["\xC1\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x92"],
        ["\xB4\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE\xA4"],
        ["\xC1\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x96"],
        ["\xC1\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA6"],
        ["\xB4\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB0"],
        ["\xC1\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB7"],
        ["\xC1\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBA"],
        ["\xC1\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBC"],
        ["\xB4\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x80"],
        ["\xC1\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x91"],
        ["\xC1\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x96"],
        ["\xB4\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x98\xB9"],
        ["\xB4\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x99\x87"],
        ["\xB4\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x98\xB8"],
        ["\xB4\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x98\xBA"],
        ["\xB4\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA3"],
        ["\xC1\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAE"],
        ["\xC1\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAF"],
        ["\xC1\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB3"],
        ["\xB4\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF\x8D"],
        ["\xB4\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB4"],
        ["\xC1\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBE"],
        ["\xC1\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x91"],
        ["\xC1\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9A"],
        ["\xC1\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9D"],
        ["\xB4\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x9C\x9C"],
        ["\xC1\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB2"],
        ["\xB4\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB3"],
        ["\xC1\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB4"],
        ["\xC1\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBF"],
        ["\xC1\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x89"],
        ["\xB4\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xBA"],
        ["\xC1\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x8E"],
        ["\xC1\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x92"],
        ["\xC1\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA4"],
        ["\xB4\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x9C\x8C"],
        ["\xC1\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x83"],
        ["\xC1\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x8B"],
        ["\xB4\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF\xB0"],
        ["\xC1\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x91"],
        ["\xC1\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x9F"],
        ["\xB4\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA1"],
        ["\xB4\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x9D\xA4"],
        ["\xC1\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAB"],
        ["\xC1\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xBD"],
        ["\xC2\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x86"],
        ["\xC2\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x94"],
        ["\xC2\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x90"],
        ["\xC2\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9C"],
        ["\xC2\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9D"],
        ["\xB4\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x9F\xBF"],
        ["\xB4\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x9F\xA7"],
        ["\xC2\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xAC"],
        ["\xC2\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xB1"],
        ["\xC2\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xB2"],
        ["\xB4\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xB3"],
        ["\xC2\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xBD"],
        ["\xB4\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xA0\xA4"],
        ["\xB4\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x8B"],
        ["\xC2\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x8F"],
        ["\xC2\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x90"],
        ["\xC2\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x91"],
        ["\xB4\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xA0\xBD"],
        ["\xC2\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x97"],
        ["\xB4\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0\xA6"],
        ["\xC2\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xAF"],
        ["\xC2\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x8A"],
        ["\xC2\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x98"],
        ["\xB4\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xAC"],
        ["\xC2\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB5"],
        ["\xB4\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xBA"],
        ["\xB4\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x81"],
        ["\xC2\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x9B"],
        ["\xC2\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAE"],
        ["\xB4\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xAA\x98"],
        ["\xC2\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBD"],
        ["\xC2\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBE"],
        ["\xB4\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x87"],
        ["\xB4\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x88"],
        ["\xC2\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x89"],
        ["\xC2\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x9A"],
        ["\xC2\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xA6"],
        ["\xC2\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xA7"],
        ["\xC2\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAE"],
        ["\xC2\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xB1"],
        ["\xC2\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x82"],
        ["\xB4\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x8A"],
        ["\xC2\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x8E"],
        ["\xC2\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB5"],
        ["\xC2\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB6"],
        ["\xC2\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xBA"],
        ["\xB4\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xB1\xBF"],
        ["\xC2\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x8D"],
        ["\xC2\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9B"],
        ["\xC2\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xAD"],
        ["\xB4\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x84"],
        ["\xC2\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x89"],
        ["\xB4\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3\x83"],
        ["\xC2\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x94"],
        ["\xC2\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x95"],
        ["\xC2\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x97"],
        ["\xB4\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xAD"],
        ["\xC2\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x82"],
        ["\xC2\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x90"],
        ["\xB4\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3\x92"],
        ["\xC2\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x96"],
        ["\xC2\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9C"],
        ["\xC2\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA9"],
        ["\xC2\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAC"],
        ["\xB4\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAD"],
        ["\xB5\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xB4\x80"],
        ["\xB4\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x80"],
        ["\xC2\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8A"],
        ["\xB5\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA4"],
        ["\xC2\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA6"],
        ["\xC2\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA7"],
        ["\xC2\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA7"],
        ["\xC2\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAF"],
        ["\xC2\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBC"],
        ["\xB5\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x9B"],
        ["\xC2\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x9E"],
        ["\xB5\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA0"],
        ["\xC2\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB0"],
        ["\xB5\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x80"],
        ["\xB5\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x81"],
        ["\xB5\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8A"],
        ["\xB5\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8D"],
        ["\xC2\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x91"],
        ["\xC2\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x98"],
        ["\xB5\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xB5\x80"],
        ["\xB5\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x97"],
        ["\xB5\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xB7\xBA"],
        ["\xB5\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xB7\xB9"],
        ["\xB5\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xB7\x93"],
        ["\xB5\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xAB"],
        ["\xB5\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xAE"],
        ["\xC2\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB4"],
        ["\xB5\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x82"],
        ["\xB5\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB4"],
        ["\xC2\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x88"],
        ["\xC3\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8E"],
        ["\xB5\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x90"],
        ["\xC3\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x9F"],
        ["\xC3\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA9"],
        ["\xC3\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB6"],
        ["\xC3\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB6"],
        ["\xC3\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9E"],
        ["\xC3\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA2"],
        ["\xB5\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4\x91"],
        ["\xC3\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB2"],
        ["\xC3\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x88"],
        ["\xC3\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x89"],
        ["\xC3\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8B"],
        ["\xB5\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8C"],
        ["\xC3\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8F"],
        ["\xC3\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x91"],
        ["\xC3\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x93"],
        ["\xC3\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x94"],
        ["\xC3\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x97"],
        ["\xC3\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xA3"],
        ["\xB5\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4\x9E"],
        ["\xC3\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x93"],
        ["\xC3\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xA7"],
        ["\xB5\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB4"],
        ["\xC3\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x83"],
        ["\xC3\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x8A"],
        ["\xB5\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x99"],
        ["\xB5\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB5"],
        ["\xC3\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xAB"],
        ["\xC3\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB9"],
        ["\xC3\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xBB"],
        ["\xC3\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x8A"],
        ["\xC3\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x8C"],
        ["\xC3\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x98"],
        ["\xB5\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA5"],
        ["\xC3\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB6"],
        ["\xC3\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xBC"],
        ["\xB5\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xBD\xBE"],
        ["\xC3\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x92"],
        ["\xC3\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x97"],
        ["\xC3\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9A"],
        ["\xB5\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA0"],
        ["\xC3\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA8"],
        ["\xB5\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x98"],
        ["\xC3\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBD"],
        ["\xC3\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x90"],
        ["\xC3\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x96"],
        ["\xB5\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xBE"],
        ["\xC3\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x9F"],
        ["\xC3\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA5"],
        ["\xC3\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xAF"],
        ["\xB5\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5\xA4"],
        ["\xC3\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x88"],
        ["\xB5\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x89"],
        ["\xC3\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9A"],
        ["\xC3\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9E"],
        ["\xC3\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA9"],
        ["\xB5\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\x82\x96"],
        ["\xC3\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xBC"],
        ["\xC3\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x80"],
        ["\xB5\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x8A"],
        ["\xC3\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA3"],
        ["\xB5\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\x84\x83"],
        ["\xC3\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xB9"],
        ["\xB5\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xBA"],
        ["\xC3\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xBC"],
        ["\xC3\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x83"],
        ["\xB5\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x87"],
        ["\xC3\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x8B"],
        ["\xB5\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6\x9A"],
        ["\xC3\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x94"],
        ["\xC3\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xA5"],
        ["\xB5\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xA9"],
        ["\xC3\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAC"],
        ["\xC3\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAE"],
        ["\xC3\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB6"],
        ["\xC3\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xBE"],
        ["\xC3\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x81"],
        ["\xC3\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x86"],
        ["\xC3\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x95"],
        ["\xC3\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x97"],
        ["\xB5\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\x87\x86"],
        ["\xB5\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x9F"],
        ["\xC3\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB1"],
        ["\xB5\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\x87\xBE"],
        ["\xB5\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xAC"],
        ["\xC3\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x8A"],
        ["\xC3\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x91"],
        ["\xC3\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x93"],
        ["\xC3\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x9C"],
        ["\xC3\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x83"],
        ["\xC3\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x86"],
        ["\xC3\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x87"],
        ["\xB5\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x88"],
        ["\xC3\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x8C"],
        ["\xB5\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7\x80"],
        ["\xC4\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xAF"],
        ["\xC4\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xB1"],
        ["\xC4\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x90"],
        ["\xC4\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x8A"],
        ["\xB5\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x93"],
        ["\xC4\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x9E"],
        ["\xB5\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7\x94"],
        ["\xB5\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x96"],
        ["\xC4\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x80"],
        ["\xC4\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x9B"],
        ["\xC4\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xA0"],
        ["\xC4\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xA2"],
        ["\xB5\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xAE"],
        ["\xC4\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xAF"],
        ["\xC4\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xB3"],
        ["\xB5\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\x8E\xBC"],
        ["\xC4\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x8B"],
        ["\xC4\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x93"],
        ["\xC4\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x99"],
        ["\xC4\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x9C"],
        ["\xC4\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x87"],
        ["\xB5\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8\x85"],
        ["\xB5\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x89"],
        ["\xC4\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAB"],
        ["\xC4\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB4"],
        ["\xC4\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB8"],
        ["\xC4\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB9"],
        ["\xB3\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAC"],
        ["\xC4\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x82"],
        ["\xC4\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x93"],
        ["\xB5\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x97"],
        ["\xC4\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA3"],
        ["\xB5\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\x98\xA9"],
        ["\xC4\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xAE"],
        ["\xC4\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xAF"],
        ["\xC4\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB8"],
        ["\xC4\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xBF"],
        ["\xC4\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x8E"],
        ["\xB5\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\x9A\xA5"],
        ["\xC4\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAD"],
        ["\xC4\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAE"],
        ["\xB5\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB0"],
        ["\xC4\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x81"],
        ["\xB5\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9\xA0"],
        ["\xC4\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x8C"],
        ["\xB5\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9\xA6"],
        ["\xB5\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9\xA8"],
        ["\xC4\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB3"],
        ["\xC4\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBA"],
        ["\xC4\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x87"],
        ["\xC4\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x92"],
        ["\xC4\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x98"],
        ["\xC4\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x99"],
        ["\xB5\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA\x83"],
        ["\xB5\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB9"],
        ["\xC4\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAC"],
        ["\xC4\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB1"],
        ["\xB5\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB3"],
        ["\xC4\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xBD"],
        ["\xC4\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x92"],
        ["\xB5\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA\x94"],
        ["\xC4\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xAB"],
        ["\xC4\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xAC"],
        ["\xB5\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xA2\x96"],
        ["\xC4\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xAE"],
        ["\xC4\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xAF"],
        ["\xC4\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB1"],
        ["\xC4\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x81"],
        ["\xC4\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x85"],
        ["\xB5\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x8A"],
        ["\xB5\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x94"],
        ["\xC4\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x98"],
        ["\xC4\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x9C"],
        ["\xC4\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x9E"],
        ["\xC4\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA5"],
        ["\xB5\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA8"],
        ["\xC4\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB5"],
        ["\xC4\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB7"],
        ["\xC4\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB9"],
        ["\xC4\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xBC"],
        ["\xC4\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xBF"],
        ["\xC4\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x85"],
        ["\xC4\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8B"],
        ["\xC4\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA1"],
        ["\xC4\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA7"],
        ["\xC5\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB9"],
        ["\xB5\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x93"],
        ["\xC5\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xBA"],
        ["\xC5\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x81"],
        ["\xC5\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA4"],
        ["\xC5\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB1"],
        ["\xC5\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB9"],
        ["\xB5\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x93"],
        ["\xC5\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x80"],
        ["\xC5\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x83"],
        ["\xC5\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x8D"],
        ["\xC5\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x92"],
        ["\xC5\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9D"],
        ["\xC5\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB1"],
        ["\xC5\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x81"],
        ["\xC5\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x85"],
        ["\xB5\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x88"],
        ["\xB5\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xA9\x8D"],
        ["\xC5\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x92"],
        ["\xB5\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x97"],
        ["\xC5\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x99"],
        ["\xC5\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA0"],
        ["\xC5\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA1"],
        ["\xB5\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA5"],
        ["\xC5\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xAA"],
        ["\xC5\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xAB"],
        ["\xC5\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xB9"],
        ["\xC5\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xBB"],
        ["\xB5\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xBA"],
        ["\xB5\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x96"],
        ["\xC5\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x98"],
        ["\xC5\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x9E"],
        ["\xC5\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xAF"],
        ["\xC5\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xAB"],
        ["\xB5\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xAD\x96"],
        ["\xC5\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xBA"],
        ["\xB5\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xAD\xAF"],
        ["\xC5\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA0"],
        ["\xC5\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA4"],
        ["\xC5\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAA"],
        ["\xB5\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD\x97"],
        ["\xB5\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xB0\x96"],
        ["\xC5\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBD"],
        ["\xC5\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBE"],
        ["\xC5\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x80"],
        ["\xC5\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x88"],
        ["\xC5\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8E"],
        ["\xC5\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x90"],
        ["\xC5\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x92"],
        ["\xB5\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAC"],
        ["\xB5\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB2"],
        ["\xC5\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB1"],
        ["\xC5\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xBA"],
        ["\xC5\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xBD"],
        ["\xC5\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xBE"],
        ["\xC5\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x81"],
        ["\xB5\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xB4\x94"],
        ["\xB5\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8C"],
        ["\xB5\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD\xB5"],
        ["\xC5\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xA2"],
        ["\xB5\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD\xB7"],
        ["\xB5\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB0"],
        ["\xB5\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB7"],
        ["\xC5\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBF"],
        ["\xC5\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x80"],
        ["\xC5\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x86"],
        ["\xC5\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x8F"],
        ["\xB5\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x93"],
        ["\xB5\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x9D"],
        ["\xC5\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x9F"],
        ["\xC5\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA0"],
        ["\xC5\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA7"],
        ["\xC5\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xAC"],
        ["\xC5\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xAE"],
        ["\xC5\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB1"],
        ["\xC5\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB9"],
        ["\xC5\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x83"],
        ["\xB5\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x98"],
        ["\xC5\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x87"],
        ["\xC5\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x8F"],
        ["\xB5\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE\xAE"],
        ["\xB5\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xB8\x8E"],
        ["\xC5\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x93"],
        ["\xC5\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x9B"],
        ["\xC5\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x9C"],
        ["\xB5\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xB8\xB7"],
        ["\xC5\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA5"],
        ["\xB5\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA8"],
        ["\xC5\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xBC"],
        ["\xC5\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB3"],
        ["\xB5\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xB9\xAA"],
        ["\xB5\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF\x89"],
        ["\xC5\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x81"],
        ["\xB5\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xBA\x8B"],
        ["\xC5\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x89"],
        ["\xC6\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x95"],
        ["\xB5\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF\x97"],
        ["\xC6\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAE"],
        ["\xC6\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x95"],
        ["\xB5\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xA1"],
        ["\xC6\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xA0"],
        ["\xC6\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xA7"],
        ["\xC6\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xA8"],
        ["\xB5\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xAF"],
        ["\xB5\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x81\x8A"],
        ["\xC6\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x89"],
        ["\xB5\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x81\x95"],
        ["\xC6\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA8"],
        ["\xC6\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xAC"],
        ["\xB5\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x84\xA2"],
        ["\xC6\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x97"],
        ["\xC6\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9A"],
        ["\xC6\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xAD"],
        ["\xC6\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB5"],
        ["\xB5\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x86\xA9"],
        ["\xB5\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x80\xB9"],
        ["\xB5\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x87\xA5"],
        ["\xB5\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x87\x8D"],
        ["\xB5\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x98"],
        ["\xC6\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA0"],
        ["\xC6\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xAA"],
        ["\xB5\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x88\x9E"],
        ["\xC6\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xB2"],
        ["\xB5\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBC"],
        ["\xC6\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBD"],
        ["\xB5\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x89\x8C"],
        ["\xB5\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x81\x98"],
        ["\xC6\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x9A"],
        ["\xC6\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x9F"],
        ["\xC6\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA2"],
        ["\xB5\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA4"],
        ["\xB5\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA9"],
        ["\xC6\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9E"],
        ["\xC6\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9F"],
        ["\xC6\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA4"],
        ["\xC6\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA6"],
        ["\xC6\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAA"],
        ["\xC6\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAC"],
        ["\xB5\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x82\x93"],
        ["\xC6\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xB0"],
        ["\xC6\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xB4"],
        ["\xC6\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xBB"],
        ["\xB5\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x90\xAE"],
        ["\xC6\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x85"],
        ["\xC6\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x86"],
        ["\xC6\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x89"],
        ["\xC6\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x8D"],
        ["\xB5\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x99"],
        ["\xB5\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xAC"],
        ["\xC6\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x87"],
        ["\xC6\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAA"],
        ["\xB5\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x93\x99"],
        ["\xC6\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8A"],
        ["\xC6\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x94"],
        ["\xC6\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA4"],
        ["\xC6\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x9D"],
        ["\xC6\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x9E"],
        ["\xC6\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x9F"],
        ["\xC6\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBB"],
        ["\xC6\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x88"],
        ["\xC6\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x8C"],
        ["\xC6\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x8E"],
        ["\xC6\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x95"],
        ["\xC6\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA0"],
        ["\xC6\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA1"],
        ["\xC6\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA6"],
        ["\xB5\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xB9"],
        ["\xC7\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xBA"],
        ["\xC7\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xBB"],
        ["\xB5\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xBE"],
        ["\xB5\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x96\xA7"],
        ["\xC7\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x90"],
        ["\xB5\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x9B"],
        ["\xC7\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xA5"],
        ["\xC7\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBB"],
        ["\xC7\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x8A"],
        ["\xC7\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x98"],
        ["\xC7\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9B"],
        ["\xB5\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x84\x85"],
        ["\xC7\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA7"],
        ["\xC7\x6A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xB2"],
        ["\xC7\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x95"],
        ["\xC7\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x96"],
        ["\xC7\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xA1"],
        ["\xC7\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xA9"],
        ["\xC7\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB4"],
        ["\xC7\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBB"],
        ["\xC7\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x82"],
        ["\xC7\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x87"],
        ["\xB5\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x8C"],
        ["\xB5\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x8D"],
        ["\xC7\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x96"],
        ["\xB5\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x85\x88"],
        ["\xB5\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x9E\xA9"],
        ["\xB5\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x9E\xB4"],
        ["\xB5\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x85\x8F"],
        ["\xC7\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8A"],
        ["\xC7\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x91"],
        ["\xC7\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x95"],
        ["\xC7\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9B"],
        ["\xC7\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9E"],
        ["\xB5\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x85\xA3"],
        ["\xC7\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xAD"],
        ["\xC7\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB8"],
        ["\xC7\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x87"],
        ["\xC7\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8C"],
        ["\xC7\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x96"],
        ["\xC7\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x99"],
        ["\xC7\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x9C"],
        ["\xC7\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x9F"],
        ["\xC7\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA0"],
        ["\xC7\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA7"],
        ["\xC7\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xAA"],
        ["\xC7\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB5"],
        ["\xC7\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB8"],
        ["\xC7\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x82"],
        ["\xC7\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x8A"],
        ["\xC7\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x90"],
        ["\xC7\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xA3"],
        ["\xC7\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAC"],
        ["\xB5\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xA7\x94"],
        ["\xB5\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x86\xB4"],
        ["\xC7\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xB9"],
        ["\xC7\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBC"],
        ["\xB5\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBE"],
        ["\xB5\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x86\xBF"],
        ["\xC7\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8C"],
        ["\xC7\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA8"],
        ["\xC7\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB4"],
        ["\xB5\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xAB\xA4"],
        ["\xB5\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xAB\xA3"],
        ["\xC7\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x87"],
        ["\xB5\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xAB\xB1"],
        ["\xC7\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xBD"],
        ["\xC7\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA7"],
        ["\xC7\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xAA"],
        ["\xC7\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xAE"],
        ["\xC7\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xAF"],
        ["\xC7\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB1"],
        ["\xB5\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x87\xA6"],
        ["\xB5\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x87\xB3"],
        ["\xB5\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xBF"],
        ["\xC7\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x81"],
        ["\xB5\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x87\xAE"],
        ["\xC7\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x95"],
        ["\xB5\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB9"],
        ["\xC7\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA4"],
        ["\xC7\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA6"],
        ["\xC7\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA9"],
        ["\xC7\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB3"],
        ["\xB5\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xAE\xB2"],
        ["\xB5\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x88\x87"],
        ["\xC7\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x90"],
        ["\xC7\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x91"],
        ["\xC8\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9B"],
        ["\xB5\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x88\x8E"],
        ["\xC8\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xAF"],
        ["\xC8\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB5"],
        ["\xC8\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xBC"],
        ["\xC8\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x85"],
        ["\xC8\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8A"],
        ["\xB5\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xB1\x8B"],
        ["\xB5\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xB1\xA4"],
        ["\xC8\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x94"],
        ["\xC8\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x96"],
        ["\xC8\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x9A"],
        ["\xC8\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xAA"],
        ["\xB5\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB0"],
        ["\xC8\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x83"],
        ["\xC8\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x8B"],
        ["\xC8\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x8E"],
        ["\xC8\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x8F"],
        ["\xC8\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA6"],
        ["\xB6\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x85"],
        ["\xC8\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8A"],
        ["\xC8\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x91"],
        ["\xB6\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x97"],
        ["\xC8\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x9E"],
        ["\xC8\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA1"],
        ["\xC8\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA9"],
        ["\xC8\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xAE"],
        ["\xB6\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xAF"],
        ["\xC8\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB0"],
        ["\xB6\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xB8\xAE"],
        ["\xB6\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xB9\x96"],
        ["\xB6\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xB9\xA5"],
        ["\xC8\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA6"],
        ["\xB6\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xB9\xA2"],
        ["\xC8\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB6"],
        ["\xC8\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB7"],
        ["\xC8\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xBF"],
        ["\xB6\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xBB\x98"],
        ["\xC8\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x84"],
        ["\xB6\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xBB\x82"],
        ["\xC8\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x88"],
        ["\xC8\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x8D"],
        ["\xB6\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xBB\xA8"],
        ["\xC8\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x97"],
        ["\xB6\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xBC\xA3"],
        ["\xC8\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA6"],
        ["\xC8\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xAB"],
        ["\xB6\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xBD\x9C"],
        ["\xC8\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB5"],
        ["\xC8\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x83"],
        ["\xC8\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x89"],
        ["\xB6\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x8B\x86"],
        ["\xC8\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x92"],
        ["\xC8\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9E"],
        ["\xB6\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xBF\xA0"],
        ["\xB6\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xBF\x94"],
        ["\xC8\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBD"],
        ["\xC8\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBE"],
        ["\xC8\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x80"],
        ["\xC8\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x87"],
        ["\xB6\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x80\x8C"],
        ["\xB6\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xBF\xBB"],
        ["\xB6\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x8B\x96"],
        ["\xC8\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x99"],
        ["\xC8\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9A"],
        ["\xC8\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xAA"],
        ["\xC8\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB0"],
        ["\xB6\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x8B\x9D"],
        ["\xC8\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xBF"],
        ["\xB6\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x80\x97"],
        ["\xC8\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x86"],
        ["\xC8\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x88"],
        ["\xC8\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x8C"],
        ["\xC8\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x97"],
        ["\xB6\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x81\xA0"],
        ["\xC8\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9D"],
        ["\xC8\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA7"],
        ["\xC8\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAA"],
        ["\xC8\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB6"],
        ["\xB6\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x80"],
        ["\xC8\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x97"],
        ["\xC8\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x99"],
        ["\xC8\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA6"],
        ["\xC8\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB1"],
        ["\xC8\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB9"],
        ["\xB6\x5C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x8C\x82"],
        ["\xB6\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x83\xAD"],
        ["\xB6\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x98"],
        ["\xC9\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x90"],
        ["\xC9\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x97"],
        ["\xC9\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9D"],
        ["\xC9\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA0"],
        ["\xC9\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA7"],
        ["\xC9\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xAC"],
        ["\xC9\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x85"],
        ["\xC9\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xB3"],
        ["\xB6\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xB5"],
        ["\xC9\x60",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBE"],
        ["\xC9\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x86"],
        ["\xC9\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x87"],
        ["\xB6\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x8C\xAB"],
        ["\xC9\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x91"],
        ["\xC9\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x98"],
        ["\xC9\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x9A"],
        ["\xB6\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x8D\x83"],
        ["\xC9\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xBC"],
        ["\xC9\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xBB"],
        ["\xC9\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xBE"],
        ["\xC9\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x83"],
        ["\xC9\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x84"],
        ["\xC9\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8F"],
        ["\xB3\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x93\x81"],
        ["\xB6\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x89\xB0"],
        ["\xC9\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x92"],
        ["\xB6\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x8A\x86"],
        ["\xC9\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA1"],
        ["\xC9\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA3"],
        ["\xC9\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA4"],
        ["\xC9\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAD"],
        ["\xC9\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xBD"],
        ["\xC9\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xBE"],
        ["\xB6\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x8D\x8C"],
        ["\xC9\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x90"],
        ["\xB6\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xBB"],
        ["\xB5\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xB4\x8E"],
        ["\xC9\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x96"],
        ["\xC9\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9C"],
        ["\xC9\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xAD"],
        ["\xB6\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x90\x82"],
        ["\xC9\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x83"],
        ["\xC9\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8F"],
        ["\xC9\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA3"],
        ["\xC9\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA5"],
        ["\xC9\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xAF"],
        ["\xC9\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB2"],
        ["\xB6\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x82"],
        ["\xC9\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8A"],
        ["\xC9\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x88"],
        ["\xC9\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8E"],
        ["\xC9\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x91"],
        ["\xC9\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x96"],
        ["\xC9\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA4"],
        ["\xC9\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xAC"],
        ["\xC9\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB0"],
        ["\xB6\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x83"],
        ["\xC9\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA6"],
        ["\xC9\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB1"],
        ["\xC9\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB5"],
        ["\xB6\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBB"],
        ["\xB6\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x99"],
        ["\xC9\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9C"],
        ["\xB6\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA4"],
        ["\xC9\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA7"],
        ["\xC9\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB8"],
        ["\xB6\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x99\xBE"],
        ["\xB6\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x85"],
        ["\xC9\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x95"],
        ["\xC9\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x98"],
        ["\xB6\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA6"],
        ["\xB6\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x9A\xB0"],
        ["\xB6\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x8D"],
        ["\xB6\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB5"],
        ["\xB6\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xBB"],
        ["\xB6\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x8F\xAE"],
        ["\xC9\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB5"],
        ["\xC9\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x96"],
        ["\xC9\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x9E"],
        ["\xB6\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x8F\xB0"],
        ["\xC9\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xA4"],
        ["\xC9\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xA7"],
        ["\xC9\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xAC"],
        ["\xB6\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x9C\x9D"],
        ["\xB6\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xBD"],
        ["\xB6\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x90\x88"],
        ["\xC9\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA9"],
        ["\xB6\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x90\x97"],
        ["\xCA\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x81"],
        ["\xB6\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x90\x9C"],
        ["\xCA\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x84"],
        ["\xCA\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x85"],
        ["\xB6\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x90\xA2"],
        ["\xCA\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x98"],
        ["\xCA\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB2"],
        ["\xB6\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x81"],
        ["\xCA\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x83"],
        ["\xB6\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x96"],
        ["\xCA\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x9B"],
        ["\xB6\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xA3\x9D"],
        ["\xCA\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA4"],
        ["\xB6\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xA3\xAA"],
        ["\xCA\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xAC"],
        ["\xB6\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xA5\x91"],
        ["\xCA\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBD"],
        ["\xCA\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBF"],
        ["\xB6\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xA5\xAF"],
        ["\xB6\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x84"],
        ["\xB6\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xA7\x9D"],
        ["\xCA\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x99"],
        ["\xCA\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xA1"],
        ["\xCA\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xA2"],
        ["\xB6\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xA8\x9E"],
        ["\xCA\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB2"],
        ["\xCA\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB4"],
        ["\xB6\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xBC"],
        ["\xCA\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x86"],
        ["\xB6\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x89"],
        ["\xCA\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x85"],
        ["\xB6\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xA9\x98"],
        ["\xCA\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x8B"],
        ["\xB6\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x91\xB6"],
        ["\xCA\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x8F"],
        ["\xB6\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x91\xBA"],
        ["\xB6\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x97"],
        ["\xB6\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xAA\x8C"],
        ["\xCA\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9C"],
        ["\xCA\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA3"],
        ["\xB6\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xAA\xB7"],
        ["\xB6\x94",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x9D"],
        ["\xB6\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x9E"],
        ["\xB6\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB9"],
        ["\xB6\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x92\x91"],
        ["\xCA\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xBD"],
        ["\xCA\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xBF"],
        ["\xCA\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x83"],
        ["\xCA\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8A"],
        ["\xB6\x98",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x93"],
        ["\xCA\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA7"],
        ["\xCA\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA8"],
        ["\xCA\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB2"],
        ["\xCA\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB4"],
        ["\xCA\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBA"],
        ["\xCA\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBC"],
        ["\xCA\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA2"],
        ["\xCA\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA8"],
        ["\xCA\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB7"],
        ["\xCA\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x87"],
        ["\xCA\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x88"],
        ["\xB6\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x8C"],
        ["\xCA\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x94"],
        ["\xCA\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x9B"],
        ["\xCA\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x9D"],
        ["\xCA\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB0"],
        ["\xCA\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xBC"],
        ["\xCA\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x84"],
        ["\xCA\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x97"],
        ["\xB6\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x92\xBE"],
        ["\xB6\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x93\x94"],
        ["\xB6\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x92\xB3"],
        ["\xCA\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x8D"],
        ["\xCA\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x94"],
        ["\xCA\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x95"],
        ["\xCA\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9B"],
        ["\xCA\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9D"],
        ["\xCA\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x89"],
        ["\xCA\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x90"],
        ["\xCA\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x94"],
        ["\xCA\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x9D"],
        ["\xB6\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xA5"],
        ["\xCA\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB9"],
        ["\xCA\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8F"],
        ["\xCA\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x91"],
        ["\xCB\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x95"],
        ["\xB6\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xB1\xB3"],
        ["\xB6\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x97"],
        ["\xCB\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB9"],
        ["\xCB\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x8A"],
        ["\xCB\x49",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x8F"],
        ["\xCB\x4A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x91"],
        ["\xCB\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x92"],
        ["\xCB\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x99"],
        ["\xCB\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x9A"],
        ["\xCB\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x9C"],
        ["\xB6\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xB3\x9D"],
        ["\xCB\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA5"],
        ["\xCB\x59",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB6"],
        ["\xCB\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB8"],
        ["\xCB\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xBC"],
        ["\xCB\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x81"],
        ["\xB6\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x94\x8D"],
        ["\xB6\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x97"],
        ["\xCB\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xA6"],
        ["\xCB\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBE"],
        ["\xB6\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x94\x88"],
        ["\xB6\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8E"],
        ["\xCB\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8F"],
        ["\xCB\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x93"],
        ["\xB6\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xB9\xA5"],
        ["\xCB\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xA7"],
        ["\xCB\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xAA"],
        ["\xCB\x75",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xAF"],
        ["\xCB\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xB0"],
        ["\xCB\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xB1"],
        ["\xCB\x7A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xBA"],
        ["\xCB\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xBD"],
        ["\xCB\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x8C"],
        ["\xB6\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x9B"],
        ["\xCB\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA4"],
        ["\xCB\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA5"],
        ["\xCB\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xAB"],
        ["\xCB\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xB4"],
        ["\xCB\x93",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8F"],
        ["\xCB\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAF"],
        ["\xB6\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x94\xA5"],
        ["\xB6\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x95\x83"],
        ["\xB6\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xBE"],
        ["\xCB\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x91"],
        ["\xCB\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x9E"],
        ["\xCB\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA1"],
        ["\xCB\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA2"],
        ["\xB6\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xBE\x94"],
        ["\xCB\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xBB"],
        ["\xCB\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xBD"],
        ["\xCB\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xBF"],
        ["\xCB\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x81"],
        ["\xCB\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x86"],
        ["\xCB\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x93"],
        ["\xCB\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x9D"],
        ["\xCB\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x9F"],
        ["\xB6\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xBF\xB8"],
        ["\xB6\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xBF\xB6"],
        ["\xB6\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xBF\xB7"],
        ["\xCB\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xB7"],
        ["\xCB\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xBC"],
        ["\xCB\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x87"],
        ["\xCB\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8A"],
        ["\xCB\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x98"],
        ["\xB6\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x99"],
        ["\xCB\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x9F"],
        ["\xB6\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA1"],
        ["\xCB\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA6"],
        ["\xCB\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xB6"],
        ["\xCB\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x80"],
        ["\xCB\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x91"],
        ["\xCB\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x9E"],
        ["\xCB\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xA1"],
        ["\xB6\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xA4"],
        ["\xCB\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xA7"],
        ["\xB6\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x84\x8D"],
        ["\xB6\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xB9"],
        ["\xCB\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xBC"],
        ["\xB6\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x84\xB9"],
        ["\xCB\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x80"],
        ["\xCB\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x93"],
        ["\xCB\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x96"],
        ["\xCB\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xAF"],
        ["\xCB\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB7"],
        ["\xCB\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xBA"],
        ["\xB6\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x87"],
        ["\xB6\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x89"],
        ["\xCB\xFA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8D"],
        ["\xCB\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x91"],
        ["\xCC\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x9C"],
        ["\xB6\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x9D"],
        ["\xCC\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA8"],
        ["\xCC\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB1"],
        ["\xCC\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB3"],
        ["\xCC\x50",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x81"],
        ["\xCC\x51",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x83"],
        ["\xCC\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x91"],
        ["\xCC\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x95"],
        ["\xCC\x56",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x97"],
        ["\xCC\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xA3"],
        ["\xB6\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xA6"],
        ["\xB6\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x96\xB8"],
        ["\xCC\x61",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x85"],
        ["\xCC\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x87"],
        ["\xCC\x64",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x8E"],
        ["\xCC\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x90"],
        ["\xCC\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x93"],
        ["\xCC\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x99"],
        ["\xCC\x6B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x9F"],
        ["\xCC\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xA1"],
        ["\xCC\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xA3"],
        ["\xCC\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xB1"],
        ["\xCC\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBA"],
        ["\xCC\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBE"],
        ["\xCC\x78",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x80"],
        ["\xCC\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x83"],
        ["\xB6\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x91"],
        ["\xCC\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x98"],
        ["\xCC\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA4"],
        ["\xCC\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA5"],
        ["\xCC\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB2"],
        ["\xB6\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xBC"],
        ["\xB6\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x8F\x9B"],
        ["\xB6\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x8F\x9A"],
        ["\xCC\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xA7"],
        ["\xCC\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x89"],
        ["\xCC\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x8B"],
        ["\xCC\x8F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x93"],
        ["\xCC\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xA0"],
        ["\xB6\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x8F\xBE"],
        ["\xB6\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x97\xA5"],
        ["\xCC\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBE"],
        ["\xB6\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x90\x90"],
        ["\xCC\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x81"],
        ["\xCC\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x8E"],
        ["\xB6\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB5"],
        ["\xCC\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x9F"],
        ["\xB6\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x91\x89"],
        ["\xCC\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xA3"],
        ["\xB6\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xA5"],
        ["\xB6\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xA6"],
        ["\xCC\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xAA"],
        ["\xCC\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xAB"],
        ["\xCC\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xAD"],
        ["\xCC\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x81"],
        ["\xCC\xB6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x83"],
        ["\xCC\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8B"],
        ["\xCC\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x93"],
        ["\xCC\xC6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA8"],
        ["\xCC\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xAE"],
        ["\xCC\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB2"],
        ["\xCC\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xBC"],
        ["\xB6\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x98\x8F"],
        ["\xCC\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x8A"],
        ["\xCC\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x98"],
        ["\xCC\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9F"],
        ["\xCC\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA4"],
        ["\xB6\xD2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x98\x95"],
        ["\xB6\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x98\x94"],
        ["\xCC\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA9"],
        ["\xB6\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x98\xB1"],
        ["\xB6\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xAF"],
        ["\xCC\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xA0"],
        ["\xB6\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xBC"],
        ["\xCC\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xBD"],
        ["\xCC\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xBE"],
        ["\xCC\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x80"],
        ["\xCC\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x92"],
        ["\xB6\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x9A\x93"],
        ["\xCC\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x91"],
        ["\xCC\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x93"],
        ["\xCC\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9B"],
        ["\xCC\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB0"],
        ["\xCC\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB1"],
        ["\xB6\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x99\x81"],
        ["\xCD\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x81"],
        ["\xB6\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x9C\x8E"],
        ["\xB6\xDB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB7"],
        ["\xB6\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x9C\xA3"],
        ["\xCD\x57",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x82"],
        ["\xCD\x58",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x85"],
        ["\xCD\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x89"],
        ["\xB6\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x9D\x92"],
        ["\xB6\xDE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x99\xA5"],
        ["\xCD\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA2"],
        ["\xB6\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x80"],
        ["\xCD\x6D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x89"],
        ["\xCD\x6F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x90"],
        ["\xCD\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x9F"],
        ["\xCD\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB0"],
        ["\xCD\x7B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB7"],
        ["\xCD\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x96"],
        ["\xCD\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x98"],
        ["\xCD\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xAB"],
        ["\xB6\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x9A\xA1"],
        ["\xCD\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB1"],
        ["\xCD\x87",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB3"],
        ["\xCD\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xBD"],
        ["\xCD\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xBF"],
        ["\xB6\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x9A\xAF"],
        ["\xCD\x90",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x91"],
        ["\xCD\x91",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x94"],
        ["\xB6\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\xA6\x85"],
        ["\xB6\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA1"],
        ["\xCD\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB5"],
        ["\xCD\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBE"],
        ["\xCD\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x85"],
        ["\xCD\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x8D"],
        ["\xCD\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x98"],
        ["\xCD\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xAE"],
        ["\xCD\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x90"],
        ["\xCD\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB7"],
        ["\xCD\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x97"],
        ["\xCD\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xBC"],
        ["\xB6\xE7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\xAA\x84"],
        ["\xCD\xDA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x8A"],
        ["\xCD\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x85"],
        ["\xB6\xE8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x8D"],
        ["\xCD\xDD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9C"],
        ["\xCD\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9F"],
        ["\xCD\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xAD"],
        ["\xCD\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x83"],
        ["\xB6\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x9C\x8C"],
        ["\xB6\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x91"],
        ["\xCD\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9E"],
        ["\xCD\xF1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB6"],
        ["\xCD\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x81"],
        ["\xCD\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8B"],
        ["\xCD\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x94"],
        ["\xCD\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x95"],
        ["\xCD\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x9C"],
        ["\xCE\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x9E"],
        ["\xCE\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xB9"],
        ["\xB6\xEE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\xAE\xB3"],
        ["\xCE\x45",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xBD"],
        ["\xB6\xEF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\xAE\xBE"],
        ["\xB6\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\xAF\x87"],
        ["\xCE\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x85"],
        ["\xCE\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x87"],
        ["\xCE\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8F"],
        ["\xCE\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x94"],
        ["\xCE\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA4"],
        ["\xCE\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x96"],
        ["\xCE\x70",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x95"],
        ["\xCE\x72",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x99"],
        ["\xB6\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\xB6\xA0"],
        ["\xB6\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xB1"],
        ["\xB6\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\xB8\x90"],
        ["\xCE\x80",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x89"],
        ["\xB6\xF8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8E"],
        ["\xCE\x85",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xAC"],
        ["\xCE\x89",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x84"],
        ["\xCE\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x95"],
        ["\xCE\x92",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xA6"],
        ["\xB6\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\xBE\xB7"],
        ["\xCE\x9E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x86"],
        ["\xCE\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x88"],
        ["\xCE\xA7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x99"],
        ["\xB6\xFB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x9F\xBD"],
        ["\xCE\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xBD"],
        ["\xCE\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xA2"],
        ["\xB6\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA0\x96"],
        ["\xB7\x46",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1\x8E"],
        ["\xCF\x76",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x8D"],
        ["\xCF\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x83"],
        ["\xCF\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x84"],
        ["\xB7\x53",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2\xB5"],
        ["\xCF\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xAB"],
        ["\xD0\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x87"],
        ["\xD0\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA5"],
        ["\xD0\x9A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x89"],
        ["\xD0\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x97"],
        ["\xD0\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x8B"],
        ["\xB7\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xB1"],
        ["\xD1\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8D"],
        ["\xD1\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAC"],
        ["\xD1\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xB3"],
        ["\xB7\x77",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xB4"],
        ["\xD1\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xBC"],
        ["\xD1\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x82"],
        ["\xB7\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7\xA7"],
        ["\xB7\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7\xBA"],
        ["\xD1\xD5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x98"],
        ["\xB7\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8\x84"],
        ["\xB7\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8\xA9"],
        ["\xD1\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x97"],
        ["\xD1\xF3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xAA"],
        ["\xD2\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x8C"],
        ["\xD2\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x8D"],
        ["\xD2\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x94"],
        ["\xD2\x74",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x96"],
        ["\xB7\x8B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA\xBC"],
        ["\xD2\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xA3"],
        ["\xB7\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC\xBB"],
        ["\xD2\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x9C"],
        ["\xD2\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\xA0"],
        ["\xB7\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xA3"],
        ["\xD2\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xB9"],
        ["\xB7\x9D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xBC"],
        ["\xD2\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x91"],
        ["\xB7\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x9A"],
        ["\xD2\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xA0"],
        ["\xB7\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB1"],
        ["\xD2\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB6"],
        ["\xD3\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x84"],
        ["\xD3\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x8C"],
        ["\xB7\xA2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x98"],
        ["\xB7\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF\x82"],
        ["\xD3\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xAF"],
        ["\xB7\xA4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF\x8A"],
        ["\xB7\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xB7"],
        ["\xB7\xA6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF\x92"],
        ["\xD3\x54",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xB9"],
        ["\xD3\x5A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x86"],
        ["\xD3\x5D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x90"],
        ["\xD3\x5E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x92"],
        ["\xD3\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x95"],
        ["\xB7\xA8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF\xA8"],
        ["\xD3\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA0"],
        ["\xD3\x65",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA5"],
        ["\xD3\x67",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA9"],
        ["\xD3\x73",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x83"],
        ["\xD3\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x8C"],
        ["\xD3\x7C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x90"],
        ["\xD3\x7D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x92"],
        ["\xD3\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x96"],
        ["\xD3\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x9C"],
        ["\xD3\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAB"],
        ["\xD3\x86",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xB3"],
        ["\xD3\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xBD"],
        ["\xB7\xAA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0\xA0"],
        ["\xD3\x8E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x8B"],
        ["\xD3\x96",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xA3"],
        ["\xD3\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xA5"],
        ["\xD3\x9B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xAB"],
        ["\xD3\x9C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xAC"],
        ["\xD3\x9F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB3"],
        ["\xB7\xAB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB6"],
        ["\xD3\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB7"],
        ["\xD3\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xA6"],
        ["\xD3\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAC"],
        ["\xB7\xAC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9\xB7\x9B"],
        ["\xB7\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9\xB8\xBD"],
        ["\xD3\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB2"],
        ["\xD3\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB8"],
        ["\xD3\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xBE"],
        ["\xD3\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x87"],
        ["\xD3\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB3"],
        ["\xD3\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x98"],
        ["\xD3\xC4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x9D"],
        ["\xD3\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA7"],
        ["\xD3\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xAA"],
        ["\xD3\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xAB"],
        ["\xD3\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xAF"],
        ["\xB7\xAD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xAE"],
        ["\xB7\xAE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9\xB8\x95"],
        ["\xD3\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xBA"],
        ["\xB7\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9\xBA\x8A"],
        ["\xD3\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB7"],
        ["\xB7\xB0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9\xB9\x89"],
        ["\xD3\xD6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x96"],
        ["\xD3\xD7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x98"],
        ["\xD3\xD8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x99"],
        ["\xD3\xD9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x9A"],
        ["\xB7\xB1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x9D"],
        ["\xD3\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA2"],
        ["\xD3\xDF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA7"],
        ["\xD3\xE1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA9"],
        ["\xD3\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAA"],
        ["\xB7\xB3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9\xBB\x84"],
        ["\xD3\xE3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB1"],
        ["\xD3\xE5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB6"],
        ["\xD3\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB7"],
        ["\xD3\xEB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x85"],
        ["\xD3\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x9C"],
        ["\xB7\xB5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9\xBB\xA9"],
        ["\xD3\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x89"],
        ["\xD3\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x8A"],
        ["\xB7\xB4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9\xBB\x9B"],
        ["\xD3\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x94"],
        ["\xD3\xF4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x98"],
        ["\xD3\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x9B"],
        ["\xD3\xF7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x9D"],
        ["\xD3\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x9F"],
        ["\xD3\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA9"],
        ["\xD3\xFD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xAA"],
        ["\xD3\xFE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xAB"],
        ["\xB7\xB7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xAD"],
        ["\xD4\x41",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xAE"],
        ["\xD4\x42",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB0"],
        ["\xD4\x43",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB2"],
        ["\xD4\x44",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB5"],
        ["\xB7\xB8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xBA"],
        ["\xD4\x47",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA6"],
        ["\xD4\x48",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB2"],
        ["\xD4\x4C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x8B"],
        ["\xD4\x4B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x82"],
        ["\xB7\xB9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9\xBF\x8E"],
        ["\xD4\x4D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x91"],
        ["\xD4\x4E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x97"],
        ["\xD4\x4F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x98"],
        ["\xB7\xBD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x80\xAF"],
        ["\xB7\xBA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3\x84"],
        ["\xB7\xBB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x80\x9A"],
        ["\xD4\x55",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xB2"],
        ["\xB7\xBC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3\x91"],
        ["\xD4\x5B",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x82"],
        ["\xD4\x5F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x8A"],
        ["\xD4\x62",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9F"],
        ["\xD4\x63",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA2"],
        ["\xB7\xC2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x83\xB9"],
        ["\xD4\x66",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA9"],
        ["\xB7\xBF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x82\x82"],
        ["\xB7\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xB3"],
        ["\xD4\x68",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xB6"],
        ["\xD4\x69",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xB7"],
        ["\xD4\x6C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xBE"],
        ["\xD4\x6E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x84"],
        ["\xD4\x71",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x8D"],
        ["\xB7\xC1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x99"],
        ["\xD4\x79",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xA1"],
        ["\xD4\x81",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xBF"],
        ["\xD4\x7E",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB5"],
        ["\xD4\x7F",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB9"],
        ["\xB7\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xBD"],
        ["\xD4\x82",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x83"],
        ["\xD4\x83",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x87"],
        ["\xD4\x84",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x89"],
        ["\xD4\x88",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x96"],
        ["\xD4\x8A",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x9A"],
        ["\xD4\x8C",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x9F"],
        ["\xD4\x8D",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xA0"],
        ["\xB7\xC5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xA3"],
        ["\xD4\x95",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB4"],
        ["\xB7\xC7",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4\x87"],
        ["\xD4\x99",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x8A"],
        ["\xD4\x97",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x82"],
        ["\xB7\xC8",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x8D"],
        ["\xD4\xA0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9C"],
        ["\xD4\xA1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9D"],
        ["\xD4\xA3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xBB"],
        ["\xB4\x52",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\x88\x98"],
        ["\xD4\xA5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x80"],
        ["\xD4\xA9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x85"],
        ["\xD4\xAF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x9B"],
        ["\xD4\xB2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA8"],
        ["\xB7\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x8E\x8C"],
        ["\xB7\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBD"],
        ["\xB7\xCC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x90\xB7"],
        ["\xD4\xBE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9F"],
        ["\xD4\xC0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xA7"],
        ["\xD4\xC3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xAE"],
        ["\xD4\xC9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xBF"],
        ["\xD4\xCA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x82"],
        ["\xB7\xCD",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5\xB7"],
        ["\xD4\xCB",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x83"],
        ["\xD4\xD3",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x97"],
        ["\xD4\xD4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x99"],
        ["\xD4\xDC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xAF"],
        ["\xD4\xE0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xB7"],
        ["\xD4\xE2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xBA"],
        ["\xD4\xE4",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xBD"],
        ["\xD4\xE6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x81"],
        ["\xD4\xE9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x85"],
        ["\xD4\xEA",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x86"],
        ["\xD4\xEC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x93"],
        ["\xD4\xED",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x95"],
        ["\xD4\xF0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x98"],
        ["\xB7\xCE",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x97\xB1"],
        ["\xD4\xF2",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x9D"],
        ["\xB7\xCF",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x98\x82"],
        ["\xD4\xF5",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA9"],
        ["\xB7\xD0",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x98\x9A"],
        ["\xD4\xF6",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xAD"],
        ["\xD4\xF9",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xB0"],
        ["\xD4\xFC",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xB5"],
        ["\xB7\xD1",'utf8.1','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x9A\xB2"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e::RoundTrip;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::RoundTrip::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
