/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockSimple;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class TextBlockWithNumber
extends TextBlockSimple {
    private final TextBlock numText;

    public TextBlockWithNumber(String string, Display display, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple, double d) {
        super(display, fontConfiguration, horizontalAlignment, iSkinSimple, d);
        this.numText = TextBlockUtils.create(Display.create(string), fontConfiguration, HorizontalAlignment.LEFT, iSkinSimple);
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double d = this.getNumberWithAndMargin(stringBounder);
        double d2 = this.numText.calculateDimension(stringBounder).getHeight();
        Dimension2D dimension2D = super.calculateDimension(stringBounder);
        return new Dimension2DDouble(dimension2D.getWidth() + d, Math.max(d2, dimension2D.getHeight()));
    }

    private double getNumberWithAndMargin(StringBounder stringBounder) {
        double d = this.numText.calculateDimension(stringBounder).getWidth();
        return d + 4.0;
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = this.numText.calculateDimension(stringBounder).getHeight();
        double d2 = this.calculateDimension(stringBounder).getHeight() - d;
        this.numText.drawU(uGraphic.apply(new UTranslate(0.0, d2 / 2.0)));
        super.drawU(uGraphic.apply(new UTranslate(this.getNumberWithAndMargin(stringBounder), 0.0)));
    }
}

