/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp2.PStmtKey;
import org.apache.tomcat.dbcp.dbcp2.PoolableCallableStatement;
import org.apache.tomcat.dbcp.dbcp2.PoolablePreparedStatement;
import org.apache.tomcat.dbcp.pool2.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.KeyedPooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPool;

public class PoolingConnection
extends DelegatingConnection<Connection>
implements KeyedPooledObjectFactory<PStmtKey, DelegatingPreparedStatement> {
    private KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> stmtPool;
    private volatile boolean clearStatementPoolOnReturn;

    public PoolingConnection(Connection connection) {
        super(connection);
    }

    @Override
    public void activateObject(PStmtKey pStmtKey, PooledObject<DelegatingPreparedStatement> pooledObject) throws SQLException {
        pooledObject.getObject().activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        block12: {
            KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> keyedObjectPool;
            try {
                if (null == this.stmtPool) break block12;
                keyedObjectPool = this.stmtPool;
                this.stmtPool = null;
                try {
                    keyedObjectPool.close();
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new SQLException("Cannot close connection", exception);
                }
            }
            finally {
                try {
                    keyedObjectPool = this.getDelegateInternal();
                    if (keyedObjectPool != null) {
                        keyedObjectPool.close();
                    }
                }
                finally {
                    this.setClosedInternal(true);
                }
            }
        }
    }

    public void connectionReturnedToPool() throws SQLException {
        if (this.stmtPool != null && this.clearStatementPoolOnReturn) {
            try {
                this.stmtPool.clear();
            }
            catch (Exception exception) {
                throw new SQLException("Error clearing statement pool", exception);
            }
        }
    }

    protected PStmtKey createKey(String string) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull());
    }

    protected PStmtKey createKey(String string, int n) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), n);
    }

    protected PStmtKey createKey(String string, int n, int n2) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), n, n2);
    }

    protected PStmtKey createKey(String string, int n, int n2, int n3) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), n, n2, n3);
    }

    protected PStmtKey createKey(String string, int n, int n2, int n3, StatementType statementType) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), n, n2, n3, statementType);
    }

    protected PStmtKey createKey(String string, int n, int n2, StatementType statementType) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), n, n2, statementType);
    }

    protected PStmtKey createKey(String string, int[] nArray) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), nArray);
    }

    protected PStmtKey createKey(String string, StatementType statementType) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), statementType, null);
    }

    protected PStmtKey createKey(String string, String[] stringArray) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), stringArray);
    }

    @Override
    public void destroyObject(PStmtKey pStmtKey, PooledObject<DelegatingPreparedStatement> pooledObject) throws SQLException {
        Statement statement;
        DelegatingPreparedStatement delegatingPreparedStatement;
        if (pooledObject != null && (delegatingPreparedStatement = pooledObject.getObject()) != null && (statement = delegatingPreparedStatement.getInnermostDelegate()) != null) {
            statement.close();
        }
    }

    private String getCatalogOrNull() {
        try {
            return this.getCatalog();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private String getSchemaOrNull() {
        try {
            return this.getSchema();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> getStatementPool() {
        return this.stmtPool;
    }

    @Override
    public PooledObject<DelegatingPreparedStatement> makeObject(PStmtKey pStmtKey) throws SQLException {
        if (null == pStmtKey) {
            throw new IllegalArgumentException("Prepared statement key is null or invalid.");
        }
        if (pStmtKey.getStmtType() == StatementType.PREPARED_STATEMENT) {
            PreparedStatement preparedStatement = (PreparedStatement)pStmtKey.createStatement((Connection)this.getDelegate());
            PoolablePreparedStatement<PStmtKey> poolablePreparedStatement = new PoolablePreparedStatement<PStmtKey>(preparedStatement, pStmtKey, this.stmtPool, this);
            return new DefaultPooledObject<DelegatingPreparedStatement>(poolablePreparedStatement);
        }
        CallableStatement callableStatement = (CallableStatement)pStmtKey.createStatement((Connection)this.getDelegate());
        PoolableCallableStatement poolableCallableStatement = new PoolableCallableStatement(callableStatement, pStmtKey, this.stmtPool, this);
        return new DefaultPooledObject<DelegatingPreparedStatement>(poolableCallableStatement);
    }

    protected String normalizeSQL(String string) {
        return string.trim();
    }

    @Override
    public void passivateObject(PStmtKey pStmtKey, PooledObject<DelegatingPreparedStatement> pooledObject) throws SQLException {
        DelegatingPreparedStatement delegatingPreparedStatement = pooledObject.getObject();
        delegatingPreparedStatement.clearParameters();
        delegatingPreparedStatement.passivate();
    }

    private CallableStatement prepareCall(PStmtKey pStmtKey) throws SQLException {
        return (CallableStatement)this.prepareStatement(pStmtKey);
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(this.createKey(string, StatementType.CALLABLE_STATEMENT));
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(this.createKey(string, n, n2, StatementType.CALLABLE_STATEMENT));
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        return this.prepareCall(this.createKey(string, n, n2, n3, StatementType.CALLABLE_STATEMENT));
    }

    private PreparedStatement prepareStatement(PStmtKey pStmtKey) throws SQLException {
        if (null == this.stmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this.stmtPool.borrowObject(pStmtKey);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareStatement from pool failed", exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(this.createKey(string));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        return this.prepareStatement(this.createKey(string, n));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(this.createKey(string, n, n2));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return this.prepareStatement(this.createKey(string, n, n2, n3));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        return this.prepareStatement(this.createKey(string, nArray));
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        return this.prepareStatement(this.createKey(string, stringArray));
    }

    public void setClearStatementPoolOnReturn(boolean bl) {
        this.clearStatementPoolOnReturn = bl;
    }

    public void setStatementPool(KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> keyedObjectPool) {
        this.stmtPool = keyedObjectPool;
    }

    @Override
    public synchronized String toString() {
        GenericKeyedObjectPool genericKeyedObjectPool;
        if (this.stmtPool instanceof GenericKeyedObjectPool && (genericKeyedObjectPool = (GenericKeyedObjectPool)this.stmtPool).getFactory() == this) {
            return "PoolingConnection: " + String.valueOf(this.stmtPool.getClass()) + "@" + System.identityHashCode(this.stmtPool);
        }
        return "PoolingConnection: " + Objects.toString(this.stmtPool);
    }

    @Override
    public boolean validateObject(PStmtKey pStmtKey, PooledObject<DelegatingPreparedStatement> pooledObject) {
        return true;
    }

    public static enum StatementType {
        CALLABLE_STATEMENT,
        PREPARED_STATEMENT;

    }
}

