/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityFile;
import com.jcraft.jsch.JSchException;
import java.util.Vector;

public interface IdentityRepository {
    public static final int UNAVAILABLE = 0;
    public static final int NOTRUNNING = 1;
    public static final int RUNNING = 2;

    public String getName();

    public int getStatus();

    public Vector getIdentities();

    public boolean add(byte[] var1);

    public boolean remove(byte[] var1);

    public void removeAll();

    public static class Wrapper
    implements IdentityRepository {
        private IdentityRepository ir;
        private Vector cache = new Vector();
        private boolean keep_in_cache = false;

        Wrapper(IdentityRepository identityRepository) {
            this(identityRepository, false);
        }

        Wrapper(IdentityRepository identityRepository, boolean bl) {
            this.ir = identityRepository;
            this.keep_in_cache = bl;
        }

        @Override
        public String getName() {
            return this.ir.getName();
        }

        @Override
        public int getStatus() {
            return this.ir.getStatus();
        }

        @Override
        public boolean add(byte[] byArray) {
            return this.ir.add(byArray);
        }

        @Override
        public boolean remove(byte[] byArray) {
            return this.ir.remove(byArray);
        }

        @Override
        public void removeAll() {
            this.cache.removeAllElements();
            this.ir.removeAll();
        }

        @Override
        public Vector getIdentities() {
            Vector<Identity> vector = new Vector<Identity>();
            for (int i = 0; i < this.cache.size(); ++i) {
                Identity identity = (Identity)this.cache.elementAt(i);
                vector.add(identity);
            }
            Vector vector2 = this.ir.getIdentities();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add((Identity)vector2.elementAt(i));
            }
            return vector;
        }

        void add(Identity identity) {
            if (!this.keep_in_cache && !identity.isEncrypted() && identity instanceof IdentityFile) {
                try {
                    this.ir.add(((IdentityFile)identity).getKeyPair().forSSHAgent());
                }
                catch (JSchException jSchException) {}
            } else {
                this.cache.addElement(identity);
            }
        }

        void check() {
            if (this.cache.size() > 0) {
                Object[] objectArray = this.cache.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    Identity identity = (Identity)objectArray[i];
                    this.cache.removeElement(identity);
                    this.add(identity);
                }
            }
        }
    }
}

