/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleTimeoutThreadPerVM;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.EXCEPTIONAL_EXECUTION})
class OracleTimeoutPollingThread
extends Thread
implements Monitor {
    protected static final String threadName = "OracleTimeoutPollingThread";
    public static final String pollIntervalProperty = "oracle.jdbc.TimeoutPollInterval";
    public static final String pollIntervalDefault = "1000";
    private OracleTimeoutThreadPerVM[] knownTimeouts;
    private int count;
    private long sleepMillis;
    private final Monitor.CloseableLock monitorLock;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    public OracleTimeoutPollingThread() {
        super(threadName);
        boolean bl = (0x100000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$5, null, new Object[0]);
            }
            this.monitorLock = this.newDefaultLock();
            this.setDaemon(true);
            this.setPriority(10);
            this.knownTimeouts = new OracleTimeoutThreadPerVM[2];
            this.count = 0;
            this.sleepMillis = Long.parseLong(PhysicalConnection.getSystemPropertyPollInterval());
            this.start();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$5, null);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$5, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addTimeout(OracleTimeoutThreadPerVM oracleTimeoutThreadPerVM) {
        boolean bl = (0x100000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$0, this, oracleTimeoutThreadPerVM);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                int i2 = 0;
                if (this.count >= this.knownTimeouts.length) {
                    if (bl) {
                        this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "growing knownTimeouts--new size = " + this.knownTimeouts.length * 4);
                    }
                    OracleTimeoutThreadPerVM[] bigger = new OracleTimeoutThreadPerVM[this.knownTimeouts.length * 4];
                    System.arraycopy(this.knownTimeouts, 0, bigger, 0, this.knownTimeouts.length);
                    i2 = this.knownTimeouts.length;
                    this.knownTimeouts = bigger;
                }
                while (i2 < this.knownTimeouts.length) {
                    if (this.knownTimeouts[i2] == null) {
                        void t2;
                        this.knownTimeouts[i2] = t2;
                        ++this.count;
                        if (!bl) break;
                        this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "added at " + i2);
                        break;
                    }
                    ++i2;
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$0, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$0, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeTimeout(OracleTimeoutThreadPerVM oracleTimeoutThreadPerVM) {
        boolean bl = (0x100000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$1, this, oracleTimeoutThreadPerVM);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                for (int i2 = 0; i2 < this.knownTimeouts.length; ++i2) {
                    void t2;
                    if (this.knownTimeouts[i2] != t2) continue;
                    this.knownTimeouts[i2] = null;
                    --this.count;
                    if (!bl) break;
                    this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "removed from " + i2);
                    break;
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$1, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$1, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public void run() {
        boolean bl = (0x100000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$2, this, new Object[0]);
            }
            while (true) {
                try {
                    Thread.sleep(this.sleepMillis);
                }
                catch (InterruptedException e2) {
                    if (bl) {
                        this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "OracleTimeoutPollingThread Interrupted. Stop. ");
                    }
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$2, this);
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$2, this, null);
                    }
                    return;
                }
                this.pollOnce();
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    private void pollOnce() {
        boolean bl = (0x100000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (this.count > 0) {
                long now = System.currentTimeMillis();
                for (int i2 = 0; i2 < this.knownTimeouts.length; ++i2) {
                    try {
                        if (this.knownTimeouts[i2] == null) continue;
                        this.knownTimeouts[i2].interruptIfAppropriate(now);
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        boolean bl = (0x100000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$4, this, new Object[0]);
            }
            Monitor.CloseableLock closeableLock = this.monitorLock;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$4, this, closeableLock);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$4, this, null);
            }
            return closeableLock;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleTimeoutPollingThread.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$5 = OracleTimeoutPollingThread.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleTimeoutPollingThread.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleTimeoutPollingThread.class.getDeclaredMethod("pollOnce", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleTimeoutPollingThread.class.getDeclaredMethod("run", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleTimeoutPollingThread.class.getDeclaredMethod("removeTimeout", OracleTimeoutThreadPerVM.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleTimeoutPollingThread.class.getDeclaredMethod("addTimeout", OracleTimeoutThreadPerVM.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

