/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBStatementFetcher;
import org.firebirdsql.jdbc.FetchConfig;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class FBUpdatableCursorFetcher
extends FBStatementFetcher {
    FBUpdatableCursorFetcher(GDSHelper gdsHelper, FetchConfig fetchConfig, FbStatement stmth, FBObjectListener.FetcherListener fetcherListener) throws SQLException {
        super(gdsHelper, fetchConfig, stmth, fetcherListener);
    }

    @Override
    public boolean next() throws SQLException {
        boolean maxRowReached;
        if (this.isBeforeFirst()) {
            this.setIsBeforeFirst(false);
            this.setIsEmpty(false);
            this.setIsFirst(true);
            this.setRowNum(this.getRowNum() + 1);
            this.notifyRowChanged(this.getNextRow());
            return true;
        }
        this.setIsBeforeFirst(false);
        this.setIsFirst(false);
        this.setIsLast(false);
        this.setIsAfterLast(false);
        if (this.isEmpty()) {
            return false;
        }
        int maxRows = this.getMaxRows();
        if (this.getNextRow() == null || maxRows != 0 && this.getRowNum() == maxRows) {
            this.setIsAfterLast(true);
            this.setRowNum(0);
            return false;
        }
        this.fetch();
        boolean bl = maxRowReached = maxRows != 0 && this.getRowNum() == maxRows;
        if (this.getNextRow() == null || maxRowReached) {
            this.setIsAfterLast(true);
            return false;
        }
        this.notifyRowChanged(this.getNextRow());
        this.setRowNum(this.getRowNum() + 1);
        return true;
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new FBDriverNotCapableException("isLast() operation is not defined in case of updatable cursors, because server cannot determine cursor position without additional fetch.");
    }
}

