/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.xca;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.firebirdsql.gds.JaybirdSystemProperties;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.impl.GDSServerVersion;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.FetchDirection;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.gds.ng.listeners.ExceptionListener;
import org.firebirdsql.gds.ng.listeners.StatementListener;
import org.firebirdsql.jaybird.util.ByteArrayHelper;
import org.firebirdsql.jaybird.xca.FBConnectionRequestInfo;
import org.firebirdsql.jaybird.xca.FBIncorrectXidException;
import org.firebirdsql.jaybird.xca.FBLocalTransaction;
import org.firebirdsql.jaybird.xca.FBManagedConnectionFactory;
import org.firebirdsql.jaybird.xca.FBXAException;
import org.firebirdsql.jaybird.xca.FBXid;
import org.firebirdsql.jaybird.xca.FatalErrorHelper;
import org.firebirdsql.jaybird.xca.XcaConnectionEvent;
import org.firebirdsql.jaybird.xca.XcaConnectionEventListener;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBTpbMapper;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

public final class FBManagedConnection
implements ExceptionListener {
    private static final System.Logger log = System.getLogger(FBManagedConnection.class.getName());
    private final FBManagedConnectionFactory mcf;
    private final List<XcaConnectionEventListener> connectionEventListeners = new CopyOnWriteArrayList<XcaConnectionEventListener>();
    private static final AtomicReferenceFieldUpdater<FBManagedConnection, FBConnection> connectionHandleUpdater = AtomicReferenceFieldUpdater.newUpdater(FBManagedConnection.class, FBConnection.class, "connectionHandle");
    private volatile FBConnection connectionHandle;
    private static final AtomicReferenceFieldUpdater<FBManagedConnection, SQLWarning> unnotifiedWarningsUpdater = AtomicReferenceFieldUpdater.newUpdater(FBManagedConnection.class, SQLWarning.class, "unnotifiedWarnings");
    private volatile SQLWarning unnotifiedWarnings;
    private int timeout = 0;
    private final Map<Xid, FbTransaction> xidMap = new ConcurrentHashMap<Xid, FbTransaction>();
    private GDSHelper gdsHelper;
    private final FbDatabase database;
    private XAResource xaResource;
    private final FBConnectionRequestInfo cri;
    private FBTpbMapper transactionMapping;
    private TransactionParameterBuffer tpb;
    private int transactionIsolation;
    private volatile boolean managedEnvironment = true;
    private final Set<Xid> preparedXid = Collections.synchronizedSet(new HashSet());
    private volatile boolean inDistributedTransaction = false;
    private static final Set<TransactionState> XID_ACTIVE_STATE = Collections.unmodifiableSet(EnumSet.of(TransactionState.ACTIVE, TransactionState.PREPARED, TransactionState.PREPARING));
    static final CELNotifier connectionClosedNotifier = XcaConnectionEventListener::connectionClosed;
    static final CELNotifier connectionErrorOccurredNotifier = XcaConnectionEventListener::connectionErrorOccurred;

    FBManagedConnection(FBConnectionRequestInfo cri, FBManagedConnectionFactory mcf) throws SQLException {
        this(cri, mcf, false);
    }

    FBManagedConnection(FBConnectionRequestInfo cri, FBManagedConnectionFactory mcf, boolean createDb) throws SQLException {
        this.mcf = Objects.requireNonNull(mcf, "mcf");
        this.cri = Objects.requireNonNull(cri, "cri");
        this.tpb = mcf.getDefaultTpb();
        this.transactionIsolation = mcf.getDefaultTransactionIsolation();
        IConnectionProperties connectionProperties = cri.asIConnectionProperties();
        if (connectionProperties.getEncoding() == null && connectionProperties.getCharSet() == null) {
            String defaultEncoding = FBManagedConnection.getDefaultConnectionEncoding();
            if (defaultEncoding == null) {
                throw FbExceptionBuilder.toNonTransientConnectionException(337248341);
            }
            connectionProperties.setEncoding(defaultEncoding);
        }
        if (connectionProperties.getConnectTimeout() == -1 && DriverManager.getLoginTimeout() > 0) {
            connectionProperties.setConnectTimeout(DriverManager.getLoginTimeout());
        }
        this.database = mcf.getDatabaseFactory().connect(connectionProperties);
        this.database.addDatabaseListener(new MCDatabaseListener());
        this.database.addExceptionListener(this);
        if (createDb) {
            this.database.createDatabase();
        } else {
            this.database.attach();
        }
        this.gdsHelper = new GDSHelper(this.database);
    }

    @Override
    public void errorOccurred(Object source, SQLException ex) {
        log.log(System.Logger.Level.TRACE, "Error occurred", (Throwable)ex);
        if (FatalErrorHelper.isFatal(ex)) {
            this.notify(connectionErrorOccurredNotifier, new XcaConnectionEvent(this, XcaConnectionEvent.EventType.CONNECTION_ERROR_OCCURRED, ex));
        }
    }

    public GDSHelper getGDSHelper() throws SQLException {
        if (this.gdsHelper == null) {
            throw FbExceptionBuilder.toException(335544363);
        }
        return this.gdsHelper;
    }

    public boolean isManagedEnvironment() {
        return this.managedEnvironment;
    }

    public boolean inTransaction() {
        return this.gdsHelper != null && this.gdsHelper.inTransaction();
    }

    public void setManagedEnvironment(boolean managedEnvironment) throws SQLException {
        this.managedEnvironment = managedEnvironment;
        FBConnection connection = this.connectionHandle;
        if (connection != null) {
            connection.setManagedEnvironment(managedEnvironment);
        }
    }

    public FBLocalTransaction getLocalTransaction() {
        return new FBLocalTransaction(this);
    }

    public void addConnectionEventListener(XcaConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    public void removeConnectionEventListener(XcaConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    public void cleanup() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.disassociateConnections();
            this.clearCurrentTransaction();
            this.transactionMapping = null;
            this.tpb = this.mcf.getDefaultTpb();
            this.transactionIsolation = this.mcf.getDefaultTransactionIsolation();
        }
    }

    private void clearCurrentTransaction() {
        GDSHelper gdsHelper = this.gdsHelper;
        if (gdsHelper != null) {
            gdsHelper.setCurrentTransaction(null);
        }
    }

    private void setCurrentTransaction(FbTransaction transaction) throws SQLException {
        this.getGDSHelper().setCurrentTransaction(transaction);
    }

    private void disassociateConnections() throws SQLException {
        FBConnection connection = this.connectionHandle;
        if (connection != null) {
            connection.close();
        }
    }

    private void forceDisassociateConnections() {
        FBConnection connection = connectionHandleUpdater.getAndSet(this, null);
        if (connection != null) {
            try {
                connection.setManagedConnection(null);
                connection.close();
            }
            catch (SQLException sqlex) {
                log.log(System.Logger.Level.DEBUG, "Exception ignored during forced disassociation", (Throwable)sqlex);
            }
        }
    }

    public FBConnection getConnection() throws SQLException {
        SQLWarning warnings;
        this.disassociateConnections();
        FBConnection c = this.mcf.newConnection(this);
        c.setManagedEnvironment(this.isManagedEnvironment());
        FBConnection previous = connectionHandleUpdater.getAndSet(this, c);
        if (previous != null) {
            previous.setManagedConnection(null);
            if (log.isLoggable(System.Logger.Level.DEBUG)) {
                log.log(System.Logger.Level.DEBUG, "A connection was already associated with the managed connection", (Throwable)new RuntimeException("debug call trace"));
            }
            try {
                previous.setManagedConnection(null);
                previous.close();
            }
            catch (SQLException e) {
                log.log(System.Logger.Level.DEBUG, "Error forcing previous connection to close", (Throwable)e);
            }
        }
        if ((warnings = (SQLWarning)unnotifiedWarningsUpdater.getAndSet(this, null)) != null) {
            c.addWarning(warnings);
        }
        return c;
    }

    public void destroy() throws SQLException {
        this.destroy(null);
    }

    public void destroy(XcaConnectionEvent connectionEvent) throws SQLException {
        if (this.gdsHelper == null) {
            return;
        }
        try {
            if (this.isBrokenConnection(connectionEvent)) {
                FbDatabase currentDatabase = this.gdsHelper.getCurrentDatabase();
                currentDatabase.forceClose();
            } else {
                if (this.inTransaction()) {
                    throw FbExceptionBuilder.toException(337248327);
                }
                this.gdsHelper.detachDatabase();
            }
        }
        finally {
            this.gdsHelper = null;
            this.forceDisassociateConnections();
        }
    }

    private boolean isBrokenConnection(XcaConnectionEvent connectionEvent) {
        if (connectionEvent == null || connectionEvent.getEventType() != XcaConnectionEvent.EventType.CONNECTION_ERROR_OCCURRED) {
            return false;
        }
        return FatalErrorHelper.isBrokenConnection(connectionEvent.getException());
    }

    public XAResource getXAResource() {
        log.log(System.Logger.Level.TRACE, "XAResource requested from FBManagedConnection");
        try (LockCloseable ignored = this.withLock();){
            if (this.xaResource == null) {
                this.xaResource = new FbMcXaResource();
            }
            XAResource xAResource = this.xaResource;
            return xAResource;
        }
    }

    boolean isXidActive(Xid xid) {
        FbTransaction transaction = this.xidMap.get(xid);
        return transaction != null && XID_ACTIVE_STATE.contains((Object)transaction.getState());
    }

    private void commit(Xid id, boolean onePhase) throws XAException {
        this.mcf.notifyCommit(this, id, onePhase);
    }

    void internalCommit(Xid xid, boolean onePhase) throws XAException {
        log.log(System.Logger.Level.TRACE, "Commit called: {0}", xid);
        FbTransaction committingTr = this.xidMap.get(xid);
        if (onePhase && this.isPrepared(xid)) {
            throw new FBXAException("Cannot commit one-phase when transaction has been prepared", -6);
        }
        if (!onePhase && !this.isPrepared(xid)) {
            throw new FBXAException("Cannot commit two-phase when transaction has not been prepared", -6);
        }
        if (committingTr == null) {
            throw new FBXAException("Commit called with unknown transaction", -4);
        }
        try {
            if (committingTr == this.getGDSHelper().getCurrentTransaction()) {
                throw new FBXAException("Commit called with non-ended xid", -6);
            }
            committingTr.commit();
        }
        catch (SQLException ge) {
            if (this.gdsHelper != null) {
                try {
                    committingTr.rollback();
                }
                catch (SQLException ge2) {
                    log.log(System.Logger.Level.DEBUG, "Exception rolling back failed tx: ", (Throwable)ge2);
                }
            } else {
                log.log(System.Logger.Level.WARNING, "Unable to rollback failed tx, connection closed or lost");
            }
            throw new FBXAException(ge.getMessage(), -3, ge);
        }
        finally {
            this.xidMap.remove(xid);
            this.preparedXid.remove(xid);
        }
    }

    private boolean isPrepared(Xid xid) {
        return this.preparedXid.contains(xid);
    }

    private void end(Xid id, int flags) throws XAException {
        if (flags != 0x4000000 && flags != 0x20000000 && flags != 0x2000000) {
            throw new FBXAException("flag not allowed in this context: " + flags + ", valid flags are TMSUCCESS, TMFAIL, TMSUSPEND", -6);
        }
        this.internalEnd(id, flags);
        this.mcf.notifyEnd(this, id);
        this.inDistributedTransaction = false;
        try {
            this.setManagedEnvironment(this.isManagedEnvironment());
        }
        catch (SQLException ex) {
            throw new FBXAException("Reset of managed state failed", -3, ex);
        }
    }

    void internalEnd(Xid xid, int flags) throws XAException {
        log.log(System.Logger.Level.TRACE, "End called: {0}", xid);
        FbTransaction endingTr = this.xidMap.get(xid);
        if (endingTr == null) {
            throw new FBXAException("Unrecognized transaction", -4);
        }
        switch (flags) {
            case 0x20000000: {
                try {
                    endingTr.rollback();
                    this.clearCurrentTransaction();
                    break;
                }
                catch (SQLException ex) {
                    throw new FBXAException("can't rollback transaction", -7, ex);
                }
            }
            case 0x2000000: 
            case 0x4000000: {
                if (this.isCurrentTransaction(endingTr)) {
                    this.clearCurrentTransaction();
                    break;
                }
                throw new FBXAException("You are trying to %s a transaction that is not the current transaction".formatted(flags == 0x2000000 ? "suspend" : "end"), -5);
            }
        }
    }

    private boolean isCurrentTransaction(FbTransaction transaction) {
        GDSHelper gdsHelper = this.gdsHelper;
        return gdsHelper != null && gdsHelper.getCurrentTransaction() == transaction;
    }

    private XidQueries getXidQueries() {
        return XidQueries.forVersion(this.database.getServerVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forget(Xid id) throws XAException {
        FbStatement stmtHandle2;
        FbTransaction trHandle2;
        long inLimboId = -1L;
        try {
            trHandle2 = this.database.startTransaction(this.tpb);
            try {
                stmtHandle2 = this.database.createStatement(trHandle2);
                try {
                    GDSHelper gdsHelper2 = new GDSHelper(this.database);
                    gdsHelper2.setCurrentTransaction(trHandle2);
                    stmtHandle2.prepare(this.getXidQueries().forgetFindQuery());
                    DataProvider dataProvider = new DataProvider(stmtHandle2);
                    stmtHandle2.addStatementListener(dataProvider);
                    RowDescriptor rowDescriptor = stmtHandle2.getRowDescriptor();
                    FBField field0 = FBField.createField(rowDescriptor.getFieldDescriptor(0), dataProvider.asFieldDataProvider(0), gdsHelper2, false);
                    FBField field1 = FBField.createField(rowDescriptor.getFieldDescriptor(1), dataProvider.asFieldDataProvider(1), gdsHelper2, false);
                    while (dataProvider.next()) {
                        long inLimboTxId = field0.getLong();
                        if (!FBManagedConnection.matchesXid(id, inLimboTxId, field1.getBytes())) continue;
                        inLimboId = inLimboTxId;
                        break;
                    }
                }
                finally {
                    if (stmtHandle2 != null) {
                        stmtHandle2.close();
                    }
                }
            }
            finally {
                trHandle2.commit();
            }
        }
        catch (SQLException ex) {
            log.log(System.Logger.Level.DEBUG, "can't perform query to fetch xids", (Throwable)ex);
            throw new FBXAException(-7, ex);
        }
        if (inLimboId == -1L) {
            throw new FBXAException("XID not found", -4);
        }
        try {
            trHandle2 = this.database.startTransaction(this.tpb);
            try {
                stmtHandle2 = this.database.createStatement(trHandle2);
                try {
                    stmtHandle2.prepare(this.getXidQueries().forgetDelete() + inLimboId);
                    stmtHandle2.execute(RowValue.EMPTY_ROW_VALUE);
                }
                finally {
                    if (stmtHandle2 != null) {
                        stmtHandle2.close();
                    }
                }
            }
            finally {
                trHandle2.commit();
            }
        }
        catch (SQLException ex) {
            throw new FBXAException("can't perform query to delete xids", -7, ex);
        }
    }

    private static boolean matchesXid(Xid id, long fbTxId, byte[] fbTxMessage) {
        try {
            FBXid xid = new FBXid(fbTxMessage, fbTxId);
            return Arrays.equals(xid.getGlobalTransactionId(), id.getGlobalTransactionId()) && Arrays.equals(xid.getBranchQualifier(), id.getBranchQualifier());
        }
        catch (FBIncorrectXidException ex) {
            if (log.isLoggable(System.Logger.Level.WARNING)) {
                String message = "incorrect XID format in RDB$TRANSACTIONS where RDB$TRANSACTION_ID=%d: %s".formatted(fbTxId, ByteArrayHelper.toHexString(fbTxMessage));
                log.log(System.Logger.Level.WARNING, message + "; see debug level for stacktrace", (Throwable)ex);
                log.log(System.Logger.Level.DEBUG, message, (Throwable)ex);
            }
            return false;
        }
    }

    private int getTransactionTimeout() {
        return this.timeout;
    }

    private int prepare(Xid xid) throws XAException {
        return this.mcf.notifyPrepare(this, xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int internalPrepare(Xid xid) throws FBXAException {
        log.log(System.Logger.Level.TRACE, "prepare called: {0}", xid);
        FbTransaction committingTr = this.xidMap.get(xid);
        if (committingTr == null) {
            throw new FBXAException("Prepare called with unknown transaction", -4);
        }
        try {
            FBXid castXid;
            if (this.isCurrentTransaction(committingTr)) {
                throw new FBXAException("Prepare called with non-ended xid", -6);
            }
            FBXid fbxid = xid instanceof FBXid ? (castXid = (FBXid)xid) : new FBXid(xid);
            byte[] message = fbxid.toBytes();
            committingTr.prepare(message);
        }
        catch (SQLException ge) {
            try {
                if (this.gdsHelper != null) {
                    committingTr.rollback();
                } else {
                    log.log(System.Logger.Level.WARNING, "Unable to rollback failed tx, connection closed or lost");
                }
            }
            catch (SQLException ge2) {
                log.log(System.Logger.Level.DEBUG, "Exception rolling back failed tx", (Throwable)ge2);
            }
            finally {
                this.xidMap.remove(xid);
            }
            log.log(System.Logger.Level.WARNING, "error in prepare", (Throwable)ge);
            throw new FBXAException(-3, ge);
        }
        this.preparedXid.add(xid);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Xid[] recover(int flags) throws XAException {
        if (flags != 0x1000000 && flags != 0x800000 && flags != 0 && flags != 0x1800000) {
            throw new FBXAException("flag not allowed in this context: " + flags + ", valid flags are TMSTARTRSCAN, TMENDRSCAN, TMNOFLAGS, TMSTARTRSCAN|TMENDRSCAN", -6);
        }
        try {
            ArrayList<FBXid> xids = new ArrayList<FBXid>();
            FbTransaction trHandle = this.database.startTransaction(this.tpb);
            try (FbStatement stmtHandle = this.database.createStatement(trHandle);){
                GDSHelper gdsHelper = new GDSHelper(this.database);
                gdsHelper.setCurrentTransaction(trHandle);
                stmtHandle.prepare(this.getXidQueries().recoveryQuery());
                DataProvider dataProvider = new DataProvider(stmtHandle);
                stmtHandle.addStatementListener(dataProvider);
                stmtHandle.execute(RowValue.EMPTY_ROW_VALUE);
                FBField field0 = FBField.createField(stmtHandle.getRowDescriptor().getFieldDescriptor(0), dataProvider.asFieldDataProvider(0), gdsHelper, false);
                FBField field1 = FBField.createField(stmtHandle.getRowDescriptor().getFieldDescriptor(1), dataProvider.asFieldDataProvider(1), gdsHelper, false);
                while (dataProvider.next()) {
                    long inLimboTxId = field0.getLong();
                    byte[] inLimboMessage = field1.getBytes();
                    FBXid xid = FBManagedConnection.extractXid(inLimboMessage, inLimboTxId);
                    if (xid == null) continue;
                    xids.add(xid);
                }
            }
            finally {
                trHandle.commit();
            }
            return xids.toArray(new Xid[0]);
        }
        catch (SQLException e) {
            throw new FBXAException("can't perform query to fetch xids", -7, e);
        }
    }

    private static FBXid extractXid(byte[] xidData, long txId) {
        try {
            return new FBXid(xidData, txId);
        }
        catch (FBIncorrectXidException e) {
            if (log.isLoggable(System.Logger.Level.WARNING)) {
                log.log(System.Logger.Level.WARNING, "ignoring XID stored with invalid format in RDB$TRANSACTIONS for RDB$TRANSACTION_ID={0}: {1}", txId, ByteArrayHelper.toHexString(xidData));
            }
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    Xid findSingleXid(Xid externalXid) throws XAException {
        try {
            FbTransaction trHandle = this.database.startTransaction(this.tpb);
            try {
                Xid xid;
                block15: {
                    FbStatement stmtHandle;
                    block13: {
                        FBXid fBXid;
                        block14: {
                            stmtHandle = this.database.createStatement(trHandle);
                            try {
                                GDSHelper gdsHelper = new GDSHelper(this.database);
                                gdsHelper.setCurrentTransaction(trHandle);
                                stmtHandle.prepare(this.getXidQueries().recoveryQueryParameterized());
                                DataProvider dataProvider = new DataProvider(stmtHandle);
                                stmtHandle.addStatementListener(dataProvider);
                                FBXid tempXid = new FBXid(externalXid);
                                stmtHandle.execute(RowValue.of(stmtHandle.getParameterDescriptor(), (byte[][])new byte[][]{tempXid.toBytes()}));
                                FBField field0 = FBField.createField(stmtHandle.getRowDescriptor().getFieldDescriptor(0), dataProvider.asFieldDataProvider(0), gdsHelper, false);
                                FBField field1 = FBField.createField(stmtHandle.getRowDescriptor().getFieldDescriptor(1), dataProvider.asFieldDataProvider(1), gdsHelper, false);
                                stmtHandle.fetchRows(1);
                                if (!dataProvider.next()) break block13;
                                long inLimboTxId = field0.getLong();
                                byte[] inLimboMessage = field1.getBytes();
                                fBXid = FBManagedConnection.extractXid(inLimboMessage, inLimboTxId);
                                if (stmtHandle == null) break block14;
                            }
                            catch (Throwable throwable) {
                                if (stmtHandle != null) {
                                    try {
                                        stmtHandle.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            stmtHandle.close();
                        }
                        return fBXid;
                    }
                    xid = null;
                    if (stmtHandle == null) break block15;
                    stmtHandle.close();
                }
                return xid;
            }
            finally {
                trHandle.commit();
            }
        }
        catch (SQLException e) {
            throw new FBXAException("can't perform query to fetch xids", -7, e);
        }
    }

    public LockCloseable withLock() {
        return this.database.withLock();
    }

    public boolean isLockedByCurrentThread() {
        return this.database.isLockedByCurrentThread();
    }

    private void rollback(Xid xid) throws XAException {
        this.mcf.notifyRollback(this, xid);
    }

    void internalRollback(Xid xid) throws XAException {
        log.log(System.Logger.Level.TRACE, "rollback called: {0}", xid);
        FbTransaction committingTr = this.xidMap.get(xid);
        if (committingTr == null) {
            throw new FBXAException("Rollback called with unknown transaction: " + String.valueOf(xid));
        }
        try {
            if (this.isCurrentTransaction(committingTr)) {
                throw new FBXAException("Rollback called with non-ended xid", -6);
            }
            try {
                committingTr.rollback();
            }
            finally {
                this.xidMap.remove(xid);
                this.preparedXid.remove(xid);
            }
        }
        catch (SQLException ge) {
            log.log(System.Logger.Level.DEBUG, "Exception in rollback", (Throwable)ge);
            throw new FBXAException(ge.getMessage(), -3, ge);
        }
    }

    private boolean setTransactionTimeout(int timeout) {
        this.timeout = timeout;
        return true;
    }

    public boolean inDistributedTransaction() {
        return this.inDistributedTransaction;
    }

    private void start(Xid id, int flags) throws XAException {
        if (flags != 0 && flags != 0x200000 && flags != 0x8000000) {
            throw new FBXAException("flag not allowed in this context: " + flags + ", valid flags are TMNOFLAGS, TMJOIN, TMRESUME", -6);
        }
        if (flags == 0x200000) {
            throw new FBXAException("Joining two transactions is not supported", -7);
        }
        try {
            this.setTransactionIsolation(this.mcf.getDefaultTransactionIsolation());
            this.internalStart(id, flags);
            this.mcf.notifyStart(this, id);
            this.inDistributedTransaction = true;
            this.setManagedEnvironment(this.isManagedEnvironment());
        }
        catch (SQLException e) {
            throw new FBXAException(-3, e);
        }
    }

    public void internalStart(Xid id, int flags) throws XAException, SQLException {
        log.log(System.Logger.Level.TRACE, "start called: {0}", id);
        if (!this.isCurrentTransaction(null)) {
            throw new FBXAException("Transaction already started", -6);
        }
        this.findIscTrHandle(id, flags);
    }

    public void internalStart(Xid xid, String sql) throws XAException, SQLException {
        this.clearCurrentTransaction();
        this.requireNewXid(xid);
        this.registerNewTransaction(xid, this.database.startTransaction(sql));
    }

    public void close(FBConnection c) {
        c.setManagedConnection(null);
        if (!connectionHandleUpdater.compareAndSet(this, c, null) && log.isLoggable(System.Logger.Level.DEBUG)) {
            log.log(System.Logger.Level.DEBUG, "Call of close for connection not currently associated with this managed connection", (Throwable)new RuntimeException("debug call trace"));
        }
        XcaConnectionEvent ce = new XcaConnectionEvent(this, XcaConnectionEvent.EventType.CONNECTION_CLOSED);
        ce.setConnectionHandle(c);
        this.notify(connectionClosedNotifier, ce);
    }

    public FBConnectionRequestInfo getConnectionRequestInfo() {
        return this.cri;
    }

    public TransactionParameterBuffer getTransactionParameters() {
        TransactionParameterBuffer currentTpb;
        try (LockCloseable ignored = this.withLock();){
            currentTpb = this.tpb;
        }
        return currentTpb.deepCopy();
    }

    public void setTransactionParameters(TransactionParameterBuffer transactionParams) {
        TransactionParameterBuffer copy = transactionParams.deepCopy();
        try (LockCloseable ignored = this.withLock();){
            this.tpb = copy;
        }
    }

    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        try (LockCloseable ignored = this.withLock();){
            FBTpbMapper mapping = this.transactionMapping;
            if (mapping == null) {
                TransactionParameterBuffer transactionParameterBuffer = this.mcf.getTransactionParameters(isolation);
                return transactionParameterBuffer;
            }
            TransactionParameterBuffer transactionParameterBuffer = mapping.getMapping(isolation);
            return transactionParameterBuffer;
        }
    }

    public void setTransactionParameters(int isolation, TransactionParameterBuffer transactionParams) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            FBTpbMapper mapping = this.transactionMapping;
            if (mapping == null) {
                mapping = this.transactionMapping = this.mcf.getTransactionMappingCopy();
            }
            mapping.setMapping(isolation, transactionParams);
            if (this.getTransactionIsolation() == isolation) {
                this.setTransactionIsolation(isolation);
            }
        }
    }

    private void findIscTrHandle(Xid xid, int flags) throws SQLException, XAException {
        this.clearCurrentTransaction();
        if (flags == 0x8000000) {
            FbTransaction trHandle = this.xidMap.get(xid);
            if (trHandle == null) {
                throw new FBXAException("You are trying to resume a transaction that is not attached to this XAResource", -5);
            }
            this.setCurrentTransaction(trHandle);
            return;
        }
        this.requireNewXid(xid);
        try {
            this.registerNewTransaction(xid, this.database.startTransaction(this.tpb));
        }
        catch (SQLException e) {
            throw new FBXAException(e.getMessage(), -3, e);
        }
    }

    private void registerNewTransaction(Xid xid, FbTransaction newTx) throws SQLException {
        try {
            this.setCurrentTransaction(newTx);
            this.xidMap.put(xid, newTx);
        }
        catch (SQLException e) {
            newTx.commit();
            throw e;
        }
    }

    private void requireNewXid(Xid xid) throws XAException {
        for (Xid knownXid : this.xidMap.keySet()) {
            boolean sameFormatId = knownXid.getFormatId() == xid.getFormatId();
            boolean sameGtrid = Arrays.equals(knownXid.getGlobalTransactionId(), xid.getGlobalTransactionId());
            boolean sameBqual = Arrays.equals(knownXid.getBranchQualifier(), xid.getBranchQualifier());
            if (!sameFormatId || !sameGtrid || !sameBqual) continue;
            throw new FBXAException("A transaction with the same XID has already been started", -8);
        }
    }

    void notify(CELNotifier notifier, XcaConnectionEvent ce) {
        for (XcaConnectionEventListener cel : this.connectionEventListeners) {
            notifier.notify(cel, ce);
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            int n = this.transactionIsolation;
            return n;
        }
    }

    public void setTransactionIsolation(int isolation) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.transactionIsolation = isolation;
            FBTpbMapper mapping = this.transactionMapping;
            this.tpb = mapping == null ? this.mcf.getTpb(isolation) : mapping.getMapping(isolation);
        }
    }

    public FBManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    public void setTpbReadOnly(boolean readOnly) {
        this.tpb.setReadOnly(readOnly);
    }

    public boolean isTpbReadOnly() {
        return this.tpb.isReadOnly();
    }

    public void setTpbAutoCommit(boolean autoCommit) {
        this.tpb.setAutoCommit(autoCommit);
    }

    public boolean isTpbAutoCommit() {
        return this.tpb.isAutoCommit();
    }

    private void notifyWarning(SQLWarning warning) {
        FBConnection connection = this.connectionHandle;
        if (connection == null) {
            while (!unnotifiedWarningsUpdater.compareAndSet(this, null, warning)) {
                SQLWarning warnings = this.unnotifiedWarnings;
                if (warnings == null) continue;
                warnings.setNextWarning(warning);
                break;
            }
        } else {
            SQLWarning warnings = unnotifiedWarningsUpdater.getAndSet(this, null);
            if (warnings != null) {
                warnings.setNextWarning(warning);
                warning = warnings;
            }
            connection.addWarning(warning);
        }
    }

    private static String getDefaultConnectionEncoding() {
        try {
            String defaultConnectionEncoding = JaybirdSystemProperties.getDefaultConnectionEncoding();
            if (defaultConnectionEncoding != null) {
                return defaultConnectionEncoding;
            }
            if (JaybirdSystemProperties.isRequireConnectionEncoding()) {
                return null;
            }
        }
        catch (Exception e) {
            log.log(System.Logger.Level.ERROR, "Exception obtaining default connection encoding", (Throwable)e);
        }
        return "NONE";
    }

    private final class MCDatabaseListener
    implements DatabaseListener {
        private MCDatabaseListener() {
        }

        @Override
        public void warningReceived(FbDatabase database, SQLWarning warning) {
            if (database != FBManagedConnection.this.database) {
                database.removeDatabaseListener(this);
                return;
            }
            FBManagedConnection.this.notifyWarning(warning);
        }

        @Override
        public void detached(FbDatabase database) {
            if (database != FBManagedConnection.this.database) {
                return;
            }
            FBManagedConnection.this.gdsHelper = null;
            FBManagedConnection.this.forceDisassociateConnections();
        }
    }

    @FunctionalInterface
    static interface CELNotifier {
        public void notify(XcaConnectionEventListener var1, XcaConnectionEvent var2);
    }

    private final class FbMcXaResource
    implements XAResource {
        private FbMcXaResource() {
        }

        private FBManagedConnection getMc() {
            return FBManagedConnection.this;
        }

        @Override
        public void start(Xid xid, int flags) throws XAException {
            FBManagedConnection.this.start(xid, flags);
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            return FBManagedConnection.this.prepare(xid);
        }

        @Override
        public void commit(Xid xid, boolean onePhase) throws XAException {
            FBManagedConnection.this.commit(xid, onePhase);
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            FBManagedConnection.this.rollback(xid);
        }

        @Override
        public void end(Xid xid, int flags) throws XAException {
            FBManagedConnection.this.end(xid, flags);
        }

        @Override
        public void forget(Xid xid) throws XAException {
            FBManagedConnection.this.forget(xid);
        }

        @Override
        public Xid[] recover(int flag) throws XAException {
            return FBManagedConnection.this.recover(flag);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isSameRM(XAResource res) {
            if (res == this) return true;
            if (!(res instanceof FbMcXaResource)) return false;
            FbMcXaResource fbMcXaResource = (FbMcXaResource)res;
            if (FBManagedConnection.this.database != fbMcXaResource.getMc().database) return false;
            return true;
        }

        @Override
        public int getTransactionTimeout() {
            return FBManagedConnection.this.getTransactionTimeout();
        }

        @Override
        public boolean setTransactionTimeout(int seconds) {
            return FBManagedConnection.this.setTransactionTimeout(seconds);
        }
    }

    private static interface XidQueries {
        public String forgetFindQuery();

        public String forgetDelete();

        public String recoveryQuery();

        public String recoveryQueryParameterized();

        public static XidQueries forVersion(GDSServerVersion version) {
            if (version.isEqualOrAbove(3, 0)) {
                return XidQueriesFB30.INSTANCE;
            }
            if (version.isEqualOrAbove(2, 5)) {
                return XidQueriesFB25.INSTANCE;
            }
            return XidQueriesFB21.INSTANCE;
        }
    }

    private static final class DataProvider
    implements StatementListener {
        private static final int NO_ASYNC_FETCH = -1;
        private final Deque<RowValue> rows = new ArrayDeque<RowValue>();
        private final FbStatement statementHandle;
        private RowValue currentRow;
        private boolean moreRows = true;
        private int fetchAsyncAt = -1;

        private DataProvider(FbStatement statementHandle) {
            this.statementHandle = statementHandle;
        }

        boolean hasNext() throws SQLException {
            if (this.rows.isEmpty() && this.moreRows) {
                this.fetch();
            } else if (this.rows.size() == this.fetchAsyncAt && this.moreRows) {
                this.fetchAsync();
            }
            return !this.rows.isEmpty();
        }

        boolean next() throws SQLException {
            if (this.hasNext()) {
                this.currentRow = Objects.requireNonNull(this.rows.pollFirst(), "row");
                return true;
            }
            this.currentRow = null;
            return false;
        }

        private void fetch() throws SQLException {
            this.statementHandle.fetchRows(Integer.MAX_VALUE);
        }

        private void fetchAsync() throws SQLException {
            this.statementHandle.asyncFetchRows(Integer.MAX_VALUE);
        }

        @Override
        public void receivedRow(FbStatement sender, RowValue rowValue) {
            this.rows.add(rowValue);
        }

        @Override
        public void afterLast(FbStatement sender) {
            this.moreRows = false;
        }

        @Override
        public void fetchComplete(FbStatement sender, FetchDirection fetchDirection, int rows) {
            if (this.fetchAsyncAt * 3 < rows) {
                this.fetchAsyncAt = rows >= 15 ? Math.min(rows / 3, 200) : -1;
            }
        }

        FieldDataProvider asFieldDataProvider(final int fieldPos) {
            return new FieldDataProvider(){

                @Override
                public byte[] getFieldData() {
                    return currentRow.getFieldData(fieldPos);
                }

                @Override
                public void setFieldData(byte[] data) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static final class XidQueriesFB21
    implements XidQueries {
        static final XidQueriesFB21 INSTANCE = new XidQueriesFB21();
        private static final String FIND_TRANSACTION_FRAGMENT = "select RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION from RDB$TRANSACTIONS\n";

        private XidQueriesFB21() {
        }

        @Override
        public String forgetFindQuery() {
            return "select RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION from RDB$TRANSACTIONS\nwhere RDB$TRANSACTION_STATE in (2, 3)";
        }

        @Override
        public String forgetDelete() {
            return "delete from RDB$TRANSACTIONS where RDB$TRANSACTION_ID = ";
        }

        @Override
        public String recoveryQuery() {
            return FIND_TRANSACTION_FRAGMENT;
        }

        @Override
        public String recoveryQueryParameterized() {
            return "select RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION from RDB$TRANSACTIONS\nwhere RDB$TRANSACTION_DESCRIPTION = cast(? AS varchar(32764) character set octets)";
        }
    }

    private static final class XidQueriesFB25
    implements XidQueries {
        static final XidQueriesFB25 INSTANCE = new XidQueriesFB25();
        private static final String FIND_TRANSACTION_FRAGMENT = "select RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION from RDB$TRANSACTIONS\n";

        private XidQueriesFB25() {
        }

        @Override
        public String forgetFindQuery() {
            return "select RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION from RDB$TRANSACTIONS\nwhere RDB$TRANSACTION_STATE in (2, 3)\nand RDB$TRANSACTION_DESCRIPTION starting with x'0105'";
        }

        @Override
        public String forgetDelete() {
            return "delete from RDB$TRANSACTIONS where RDB$TRANSACTION_ID = ";
        }

        @Override
        public String recoveryQuery() {
            return "select RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION from RDB$TRANSACTIONS\nwhere RDB$TRANSACTION_DESCRIPTION starting with x'0105'";
        }

        @Override
        public String recoveryQueryParameterized() {
            return "select RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION from RDB$TRANSACTIONS\nwhere RDB$TRANSACTION_DESCRIPTION = cast(? AS varchar(32764) character set octets)";
        }
    }

    private static final class XidQueriesFB30
    implements XidQueries {
        static final XidQueriesFB30 INSTANCE = new XidQueriesFB30();
        private static final String FIND_TRANSACTION_FRAGMENT = "select RDB$TRANSACTION_ID, cast(RDB$TRANSACTION_DESCRIPTION as varchar(32764) character set octets)\nfrom RDB$TRANSACTIONS\n";

        private XidQueriesFB30() {
        }

        @Override
        public String forgetFindQuery() {
            return "select RDB$TRANSACTION_ID, cast(RDB$TRANSACTION_DESCRIPTION as varchar(32764) character set octets)\nfrom RDB$TRANSACTIONS\nwhere RDB$TRANSACTION_STATE in (2, 3)\"\nand RDB$TRANSACTION_DESCRIPTION starting with x'0105'";
        }

        @Override
        public String forgetDelete() {
            return "delete from RDB$TRANSACTIONS where RDB$TRANSACTION_ID = ";
        }

        @Override
        public String recoveryQuery() {
            return "select RDB$TRANSACTION_ID, cast(RDB$TRANSACTION_DESCRIPTION as varchar(32764) character set octets)\nfrom RDB$TRANSACTIONS\nwhere RDB$TRANSACTION_DESCRIPTION starting with x'0105'";
        }

        @Override
        public String recoveryQueryParameterized() {
            return "select RDB$TRANSACTION_ID, cast(RDB$TRANSACTION_DESCRIPTION as varchar(32764) character set octets)\nfrom RDB$TRANSACTIONS\nwhere RDB$TRANSACTION_DESCRIPTION = cast(? AS varchar(32764) character set octets)";
        }
    }
}

