/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.web.servlet;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.thymeleaf.util.Validate;
import org.thymeleaf.web.servlet.IServletWebApplication;
import org.thymeleaf.web.servlet.IServletWebExchange;
import org.thymeleaf.web.servlet.JavaxServletWebExchange;
import org.thymeleaf.web.servlet.JavaxServletWebRequest;
import org.thymeleaf.web.servlet.JavaxServletWebSession;

public class JavaxServletWebApplication
implements IServletWebApplication {
    private final ServletContext servletContext;

    JavaxServletWebApplication(ServletContext servletContext) {
        Validate.notNull(servletContext, "Servlet context cannot be null");
        this.servletContext = servletContext;
    }

    public static JavaxServletWebApplication buildApplication(ServletContext servletContext) {
        return new JavaxServletWebApplication(servletContext);
    }

    public IServletWebExchange buildExchange(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Validate.notNull(httpServletRequest, "Request cannot be null");
        Validate.notNull(httpServletResponse, "Response cannot be null");
        Validate.isTrue(this.servletContextMatches(httpServletRequest), "Cannot build an application for a request which servlet context does not match with the application that it is being built for.");
        JavaxServletWebRequest request = new JavaxServletWebRequest(httpServletRequest);
        JavaxServletWebSession session = new JavaxServletWebSession(httpServletRequest);
        return new JavaxServletWebExchange(request, session, this, httpServletResponse);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return this.servletContext.getAttributeNames();
    }

    @Override
    public Object getAttributeValue(String name) {
        Validate.notNull(name, "Name cannot be null");
        return this.servletContext.getAttribute(name);
    }

    @Override
    public void setAttributeValue(String name, Object value) {
        Validate.notNull(name, "Name cannot be null");
        this.servletContext.setAttribute(name, value);
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        Validate.notNull(path, "Path cannot be null");
        return this.servletContext.getResourceAsStream(path);
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        Validate.notNull(path, "Path cannot be null");
        return this.servletContext.getResource(path);
    }

    @Override
    public Object getNativeServletContextObject() {
        return this.servletContext;
    }

    private boolean servletContextMatches(HttpServletRequest httpServletRequest) {
        String servletContextPath = this.servletContext.getContextPath();
        String requestServletContextPath = httpServletRequest.getServletContext().getContextPath();
        return Objects.equals(servletContextPath, requestServletContextPath);
    }
}

