/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.timingdiagram.ChangeState;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.Panels;
import net.sourceforge.plantuml.timingdiagram.graphic.PanelsBinary;

public class PlayerBinary
extends Player {
    private static final String LOW_STRING = "0";
    private static final String HIGH_STRING = "1";
    private final List<TimeConstraint> constraints = new ArrayList<TimeConstraint>();
    private final SortedMap<TimeTick, ChangeState> values = new TreeMap<TimeTick, ChangeState>();
    private ChangeState initialState;

    public PlayerBinary(String code, ISkinParam skinParam, TimingRuler ruler, boolean compact, Stereotype stereotype) {
        super(code, skinParam, ruler, compact, stereotype, null, SName.binary, 30);
    }

    @Override
    protected Panels buildPlayerPanels() {
        return new PanelsBinary(this.getRuler(), this.getSkinParam(), this.getSuggestedHeight(), this.getStyle(), this.values, this.constraints, this.initialState, this.getNotes());
    }

    @Override
    public void defineState(String stateCode, String label) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setState(TimeTick now, String comment, Colors color, String ... states) {
        ChangeState cs = new ChangeState(now, comment, color, this.convert(states));
        if (now == null) {
            this.initialState = cs;
        } else {
            this.values.put(now, cs);
        }
    }

    private String[] convert(String[] states) {
        if (states.length == 1) {
            return new String[]{this.convert(states[0])};
        }
        return new String[]{this.convert(states[0]), this.convert(states[1])};
    }

    private String convert(String value) {
        if (HIGH_STRING.equals(value) || "high".equalsIgnoreCase(value)) {
            return HIGH_STRING;
        }
        return LOW_STRING;
    }

    @Override
    public void createConstraint(TimeTick tick1, TimeTick tick2, String message, ArrowConfiguration config) {
        this.constraints.add(new TimeConstraint(2.5, tick1, tick2, message, this.getSkinParam(), config));
    }
}

