/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.executor;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.analysis.AnalysisContext;
import org.opensearch.sql.analysis.Analyzer;
import org.opensearch.sql.ast.statement.ExplainMode;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.CalciteRelNodeVisitor;
import org.opensearch.sql.calcite.OpenSearchSchema;
import org.opensearch.sql.calcite.SysLimit;
import org.opensearch.sql.calcite.plan.rel.LogicalSystemLimit;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.common.utils.QueryContext;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.exception.CalciteUnsupportedException;
import org.opensearch.sql.exception.NonFallbackCalciteException;
import org.opensearch.sql.executor.ExecutionContext;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.executor.OpenSearchTypeSystem;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.monitor.profile.MetricName;
import org.opensearch.sql.monitor.profile.ProfileContext;
import org.opensearch.sql.monitor.profile.ProfileMetric;
import org.opensearch.sql.monitor.profile.QueryProfiling;
import org.opensearch.sql.planner.PlanContext;
import org.opensearch.sql.planner.Planner;
import org.opensearch.sql.planner.logical.LogicalPaginate;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.storage.split.Split;

public class QueryService {
    @Generated
    private static final Logger log = LogManager.getLogger(QueryService.class);
    private final Analyzer analyzer;
    private final ExecutionEngine executionEngine;
    private final Planner planner;
    private DataSourceService dataSourceService;
    private Settings settings;
    private final AtomicReference<Object> relNodeVisitor = new AtomicReference();

    public void execute(UnresolvedPlan plan, QueryType queryType, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        if (this.shouldUseCalcite(queryType)) {
            this.executeWithCalcite(plan, queryType, listener);
        } else {
            this.executeWithLegacy(plan, queryType, listener, Optional.empty());
        }
    }

    public void explain(UnresolvedPlan plan, QueryType queryType, ResponseListener<ExecutionEngine.ExplainResponse> listener, ExplainMode mode) {
        if (this.shouldUseCalcite(queryType)) {
            this.explainWithCalcite(plan, queryType, listener, mode);
        } else {
            this.explainWithLegacy(plan, queryType, listener, mode, Optional.empty());
        }
    }

    public void executeWithCalcite(UnresolvedPlan plan, QueryType queryType, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        CalcitePlanContext.run(() -> {
            try {
                ProfileContext profileContext = QueryProfiling.activate(QueryContext.isProfileEnabled());
                ProfileMetric analyzeMetric = profileContext.getOrCreateMetric(MetricName.ANALYZE);
                long analyzeStart = System.nanoTime();
                CalcitePlanContext context = CalcitePlanContext.create(this.buildFrameworkConfig(), SysLimit.fromSettings(this.settings), queryType);
                RelNode relNode = this.analyze(plan, context);
                RelNode calcitePlan = QueryService.convertToCalcitePlan(relNode, context);
                analyzeMetric.set(System.nanoTime() - analyzeStart);
                this.executionEngine.execute(calcitePlan, context, listener);
            }
            catch (Throwable t) {
                if (this.isCalciteFallbackAllowed(t) && !(t instanceof NonFallbackCalciteException)) {
                    log.warn("Fallback to V2 query engine since got exception", t);
                    this.executeWithLegacy(plan, queryType, listener, Optional.of(t));
                }
                if (t instanceof Exception) {
                    listener.onFailure((Exception)t);
                }
                if (t instanceof ExceptionInInitializerError && ((ExceptionInInitializerError)t).getException() instanceof Exception) {
                    listener.onFailure((Exception)((ExceptionInInitializerError)t).getException());
                }
                if (t instanceof VirtualMachineError) {
                    throw t;
                }
                listener.onFailure((Exception)new CalciteUnsupportedException(t.getMessage(), t));
            }
        }, this.settings);
    }

    public void explainWithCalcite(UnresolvedPlan plan, QueryType queryType, ResponseListener<ExecutionEngine.ExplainResponse> listener, ExplainMode mode) {
        CalcitePlanContext.run(() -> {
            try {
                QueryProfiling.noop();
                CalcitePlanContext context = CalcitePlanContext.create(this.buildFrameworkConfig(), SysLimit.fromSettings(this.settings), queryType);
                CalcitePlanContext.run(() -> {
                    RelNode relNode = this.analyze(plan, context);
                    RelNode calcitePlan = QueryService.convertToCalcitePlan(relNode, context);
                    this.executionEngine.explain(calcitePlan, mode, context, listener);
                }, this.settings);
            }
            catch (Throwable t) {
                if (this.isCalciteFallbackAllowed(t)) {
                    log.warn("Fallback to V2 query engine since got exception", t);
                    this.explainWithLegacy(plan, queryType, listener, mode, Optional.of(t));
                }
                if (t instanceof Error) {
                    listener.onFailure((Exception)new CalciteUnsupportedException(t.getMessage(), t));
                }
                listener.onFailure((Exception)t);
            }
        }, this.settings);
    }

    public void executeWithLegacy(UnresolvedPlan plan, QueryType queryType, ResponseListener<ExecutionEngine.QueryResponse> listener, Optional<Throwable> calciteFailure) {
        try {
            this.executePlan(this.analyze(plan, queryType), PlanContext.emptyPlanContext(), listener);
        }
        catch (Exception e) {
            if (this.shouldUseCalcite(queryType) && this.isCalciteFallbackAllowed(null)) {
                calciteFailure.ifPresentOrElse(t -> listener.onFailure((Exception)new RuntimeException((Throwable)t)), () -> listener.onFailure(e));
            }
            listener.onFailure(e);
        }
    }

    public void explainWithLegacy(UnresolvedPlan plan, QueryType queryType, ResponseListener<ExecutionEngine.ExplainResponse> listener, ExplainMode mode, Optional<Throwable> calciteFailure) {
        try {
            if (mode != null && mode != ExplainMode.STANDARD) {
                throw new UnsupportedOperationException("Explain mode " + mode.name() + " is not supported in v2 engine");
            }
            this.executionEngine.explain(this.plan(this.analyze(plan, queryType)), listener);
        }
        catch (Exception e) {
            if (this.shouldUseCalcite(queryType) && this.isCalciteFallbackAllowed(null)) {
                calciteFailure.ifPresentOrElse(t -> listener.onFailure((Exception)new RuntimeException((Throwable)t)), () -> listener.onFailure(e));
            }
            listener.onFailure(e);
        }
    }

    public void executePlan(LogicalPlan plan, PlanContext planContext, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        try {
            planContext.getSplit().ifPresentOrElse(split -> this.executionEngine.execute(this.plan(plan), new ExecutionContext((Split)split), listener), () -> this.executionEngine.execute(this.plan(plan), ExecutionContext.querySizeLimit(plan instanceof LogicalPaginate ? null : SysLimit.fromSettings(this.settings).querySizeLimit()), listener));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public RelNode analyze(UnresolvedPlan plan, CalcitePlanContext context) {
        context.setRootNode(plan);
        return this.getRelNodeVisitor().analyze(plan, context);
    }

    public LogicalPlan analyze(UnresolvedPlan plan, QueryType queryType) {
        return this.analyzer.analyze(plan, new AnalysisContext(queryType));
    }

    public PhysicalPlan plan(LogicalPlan plan) {
        return this.planner.plan(plan);
    }

    private boolean isCalciteFallbackAllowed(@Nullable Throwable t) {
        if (t instanceof CalciteUnsupportedException) {
            return true;
        }
        if (this.settings != null) {
            Boolean fallback_allowed = (Boolean)this.settings.getSettingValue(Settings.Key.CALCITE_FALLBACK_ALLOWED);
            if (fallback_allowed == null) {
                return false;
            }
            return fallback_allowed;
        }
        return true;
    }

    private boolean isCalciteEnabled(Settings settings) {
        if (settings != null) {
            return (Boolean)settings.getSettingValue(Settings.Key.CALCITE_ENGINE_ENABLED);
        }
        return false;
    }

    private boolean shouldUseCalcite(QueryType queryType) {
        return this.isCalciteEnabled(this.settings) && queryType == QueryType.PPL;
    }

    private FrameworkConfig buildFrameworkConfig() {
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)true, (boolean)false).plus();
        SchemaPlus opensearchSchema = rootSchema.add("OpenSearch", (Schema)new OpenSearchSchema(this.dataSourceService));
        Frameworks.ConfigBuilder configBuilder = Frameworks.newConfigBuilder().parserConfig(SqlParser.Config.DEFAULT).defaultSchema(opensearchSchema).traitDefs((List)null).programs(new Program[]{Programs.standard()}).typeSystem(OpenSearchTypeSystem.INSTANCE);
        return configBuilder.build();
    }

    private static RelNode convertToCalcitePlan(RelNode osPlan, CalcitePlanContext context) {
        LogicalSystemLimit calcitePlan = LogicalSystemLimit.create(LogicalSystemLimit.SystemLimitType.QUERY_SIZE_LIMIT, osPlan, (RexNode)context.relBuilder.literal(context.sysLimit.querySizeLimit()));
        RelCollation collation = calcitePlan.getTraitSet().getCollation();
        if (!(calcitePlan instanceof Sort) && collation != RelCollations.EMPTY) {
            calcitePlan = LogicalSort.create((RelNode)calcitePlan, (RelCollation)collation, null, null);
        }
        return calcitePlan;
    }

    @Generated
    public QueryService(Analyzer analyzer, ExecutionEngine executionEngine, Planner planner) {
        this.analyzer = analyzer;
        this.executionEngine = executionEngine;
        this.planner = planner;
    }

    @Generated
    public QueryService(Analyzer analyzer, ExecutionEngine executionEngine, Planner planner, DataSourceService dataSourceService, Settings settings) {
        this.analyzer = analyzer;
        this.executionEngine = executionEngine;
        this.planner = planner;
        this.dataSourceService = dataSourceService;
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public CalciteRelNodeVisitor getRelNodeVisitor() {
        Object $value = this.relNodeVisitor.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.relNodeVisitor;
            synchronized (atomicReference) {
                $value = this.relNodeVisitor.get();
                if ($value == null) {
                    CalciteRelNodeVisitor actualValue = new CalciteRelNodeVisitor(this.dataSourceService);
                    $value = actualValue == null ? this.relNodeVisitor : actualValue;
                    this.relNodeVisitor.set($value);
                }
            }
        }
        return (CalciteRelNodeVisitor)($value == this.relNodeVisitor ? null : $value);
    }
}

