/*
 * Decompiled with CFR 0.152.
 */
package org.passay.dictionary;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.passay.dictionary.TernaryNode;

public class TernaryTree {
    protected static final Comparator<Character> CASE_SENSITIVE_COMPARATOR = (a, b) -> a.charValue() - b.charValue();
    protected static final Comparator<Character> CASE_INSENSITIVE_COMPARATOR = (a, b) -> Character.toLowerCase(a.charValue()) - Character.toLowerCase(b.charValue());
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String[] EMPTY_ARRAY = new String[0];
    protected final Comparator<Character> comparator;
    private TernaryNode root;

    public TernaryTree() {
        this(true);
    }

    public TernaryTree(boolean caseSensitive) {
        this.comparator = caseSensitive ? CASE_SENSITIVE_COMPARATOR : CASE_INSENSITIVE_COMPARATOR;
    }

    public void insert(String word) {
        if (word != null) {
            this.root = this.insertNode(this.root, word, 0);
        }
    }

    public void insert(String[] words) {
        if (words != null) {
            for (String s : words) {
                this.insert(s);
            }
        }
    }

    public boolean search(String word) {
        return this.searchNode(this.root, word, 0);
    }

    public String[] partialSearch(String word) {
        if (this.comparator == CASE_INSENSITIVE_COMPARATOR) {
            throw new UnsupportedOperationException("Partial search is not supported for case insensitive ternary trees");
        }
        List<String> matches = this.partialSearchNode(this.root, null, "", word, 0);
        return matches == null ? EMPTY_ARRAY : matches.toArray(new String[matches.size()]);
    }

    public String[] nearSearch(String word, int distance) {
        if (this.comparator == CASE_INSENSITIVE_COMPARATOR) {
            throw new UnsupportedOperationException("Near search is not supported for case insensitive ternary trees");
        }
        List<String> matches = this.nearSearchNode(this.root, distance, null, "", word, 0);
        return matches == null ? EMPTY_ARRAY : matches.toArray(new String[matches.size()]);
    }

    public List<String> getWords() {
        List<String> words = this.traverseNode(this.root, "", new ArrayList<String>());
        return Collections.unmodifiableList(words);
    }

    public void print(Writer out, boolean fullPath) throws IOException {
        StringBuilder buffer = new StringBuilder();
        this.printNode(this.root, "", 0, fullPath, buffer);
        out.write(buffer.toString());
        out.flush();
    }

    public void print(Writer out) throws IOException {
        this.print(out, false);
    }

    private TernaryNode insertNode(TernaryNode node, String word, int index) {
        if (index < word.length()) {
            char c = word.charAt(index);
            if (node == null) {
                node = new TernaryNode(c);
            }
            char split = node.getSplitChar();
            int cmp = this.comparator.compare(Character.valueOf(c), Character.valueOf(split));
            if (cmp < 0) {
                node.setLokid(this.insertNode(node.getLokid(), word, index));
            } else if (cmp > 0) {
                node.setHikid(this.insertNode(node.getHikid(), word, index));
            } else if (index == word.length() - 1) {
                node.setEndOfWord(true);
            } else {
                node.setEqkid(this.insertNode(node.getEqkid(), word, index + 1));
            }
        }
        return node;
    }

    private boolean searchNode(TernaryNode node, String word, int index) {
        if (node != null && index < word.length()) {
            char c = word.charAt(index);
            char split = node.getSplitChar();
            int cmp = this.comparator.compare(Character.valueOf(c), Character.valueOf(split));
            if (cmp < 0) {
                return this.searchNode(node.getLokid(), word, index);
            }
            if (cmp > 0) {
                return this.searchNode(node.getHikid(), word, index);
            }
            if (index == word.length() - 1) {
                return node.isEndOfWord();
            }
            return this.searchNode(node.getEqkid(), word, index + 1);
        }
        return false;
    }

    private List<String> partialSearchNode(TernaryNode node, List<String> matches, String match, String word, int index) {
        if (node != null && index < word.length()) {
            char c = word.charAt(index);
            char split = node.getSplitChar();
            int cmp = this.comparator.compare(Character.valueOf(c), Character.valueOf(split));
            if (c == '.' || cmp < 0) {
                matches = this.partialSearchNode(node.getLokid(), matches, match, word, index);
            }
            if (c == '.' || cmp == 0) {
                if (index == word.length() - 1) {
                    if (node.isEndOfWord()) {
                        if (matches == null) {
                            matches = new ArrayList<String>();
                        }
                        matches.add(match + split);
                    }
                } else {
                    matches = this.partialSearchNode(node.getEqkid(), matches, match + split, word, index + 1);
                }
            }
            if (c == '.' || cmp > 0) {
                matches = this.partialSearchNode(node.getHikid(), matches, match, word, index);
            }
        }
        return matches;
    }

    private List<String> nearSearchNode(TernaryNode node, int distance, List<String> matches, String match, String word, int index) {
        if (node != null && distance >= 0) {
            char c = index < word.length() ? (char)word.charAt(index) : (char)'\uffff';
            char split = node.getSplitChar();
            int cmp = this.comparator.compare(Character.valueOf(c), Character.valueOf(split));
            if (distance > 0 || cmp < 0) {
                matches = this.nearSearchNode(node.getLokid(), distance, matches, match, word, index);
            }
            String newMatch = match + split;
            if (cmp == 0) {
                if (node.isEndOfWord() && newMatch.length() + distance >= word.length()) {
                    if (matches == null) {
                        matches = new ArrayList<String>();
                    }
                    matches.add(newMatch);
                }
                matches = this.nearSearchNode(node.getEqkid(), distance, matches, newMatch, word, index + 1);
            } else {
                if (node.isEndOfWord() && distance - 1 >= 0 && newMatch.length() + distance - 1 >= word.length()) {
                    if (matches == null) {
                        matches = new ArrayList<String>();
                    }
                    matches.add(newMatch);
                }
                matches = this.nearSearchNode(node.getEqkid(), distance - 1, matches, newMatch, word, index + 1);
            }
            if (distance > 0 || cmp > 0) {
                matches = this.nearSearchNode(node.getHikid(), distance, matches, match, word, index);
            }
        }
        return matches;
    }

    private List<String> traverseNode(TernaryNode node, String s, List<String> words) {
        if (node != null) {
            words = this.traverseNode(node.getLokid(), s, words);
            char c = node.getSplitChar();
            if (node.getEqkid() != null) {
                words = this.traverseNode(node.getEqkid(), s + c, words);
            }
            if (node.isEndOfWord()) {
                words.add(s + c);
            }
            words = this.traverseNode(node.getHikid(), s, words);
        }
        return words;
    }

    private void printNode(TernaryNode node, String s, int depth, boolean fullPath, StringBuilder buffer) {
        if (node != null) {
            this.printNode(node.getLokid(), s + "  /", depth + 1, fullPath, buffer);
            char c = node.getSplitChar();
            if (node.getEqkid() != null) {
                String suffix = node.isEndOfWord() ? "=" : "-";
                this.printNode(node.getEqkid(), s + '-' + c + suffix, depth + 1, fullPath, buffer);
            } else {
                int i = fullPath ? -1 : Math.max(s.lastIndexOf("  /"), s.lastIndexOf("  \\"));
                String line = i < 0 ? s : s.substring(0, i).replaceAll(".", " ") + s.substring(i);
                buffer.append(line).append('-').append(c).append(LINE_SEPARATOR);
            }
            this.printNode(node.getHikid(), s + "  \\", depth + 1, fullPath, buffer);
        }
    }

    private Map<Integer, Integer> getNodeStats(TernaryNode node, int depth, Map<Integer, Integer> histogram) {
        if (node != null) {
            if (node.isEndOfWord()) {
                histogram.put(depth, histogram.getOrDefault(depth, 0) + 1);
            }
            this.getNodeStats(node.getLokid(), depth + 1, histogram);
            this.getNodeStats(node.getEqkid(), depth + 1, histogram);
            this.getNodeStats(node.getHikid(), depth + 1, histogram);
        }
        return histogram;
    }

    protected Map<Integer, Integer> getNodeStats() {
        return this.getNodeStats(this.root, 0, new HashMap<Integer, Integer>());
    }
}

